/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Breadcrumbs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;

public class BreadcrumbsSkin<T>
extends SkinBase<Breadcrumbs<T>> {
    protected static final PseudoClass FIRST = PseudoClass.getPseudoClass((String)"first");
    protected static final PseudoClass LAST = PseudoClass.getPseudoClass((String)"last");
    protected final EventHandler<TreeItem.TreeModificationEvent<Object>> treeChildrenModifiedHandler = e -> this.updateBreadCrumbs();

    public BreadcrumbsSkin(Breadcrumbs<T> control) {
        super(control);
        control.selectedCrumbProperty().addListener((obs, old, val) -> this.updateSelectedPath((Breadcrumbs.BreadCrumbItem<T>)((Object)old), (Breadcrumbs.BreadCrumbItem<T>)((Object)val)));
        this.updateSelectedPath((Breadcrumbs.BreadCrumbItem)((Object)((Breadcrumbs)this.getSkinnable()).selectedCrumbProperty().get()), null);
    }

    protected void layoutChildren(double x, double y, double width, double height) {
        double controlHeight = ((Breadcrumbs)this.getSkinnable()).getHeight();
        double nodeX = x;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            double nodeWidth = this.snapSizeX(node.prefWidth(height));
            double nodeHeight = this.snapSizeY(node.prefHeight(-1.0));
            double nodeY = nodeHeight < controlHeight ? (controlHeight - nodeHeight) / 2.0 : y;
            node.resizeRelocate(nodeX, nodeY, nodeWidth, nodeHeight);
            nodeX += nodeWidth;
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double width = 0.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            width += this.snapSizeX(node.prefWidth(height));
        }
        return width + rightInset + leftInset;
    }

    protected void updateSelectedPath(Breadcrumbs.BreadCrumbItem<T> old, Breadcrumbs.BreadCrumbItem<T> val) {
        if (old != null) {
            old.removeEventHandler(Breadcrumbs.BreadCrumbItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        if (val != null) {
            val.addEventHandler(Breadcrumbs.BreadCrumbItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        this.updateBreadCrumbs();
    }

    protected void updateBreadCrumbs() {
        this.getChildren().clear();
        Breadcrumbs.BreadCrumbItem selectedTreeItem = ((Breadcrumbs)this.getSkinnable()).getSelectedCrumb();
        if (selectedTreeItem != null) {
            Node divider = this.createDivider(null);
            if (divider != null) {
                divider.pseudoClassStateChanged(FIRST, true);
                divider.pseudoClassStateChanged(LAST, false);
                this.getChildren().add((Object)divider);
            }
            List crumbs = this.constructFlatPath(selectedTreeItem);
            for (Breadcrumbs.BreadCrumbItem treeItem : crumbs) {
                ButtonBase crumb = this.createCrumb(treeItem);
                crumb.pseudoClassStateChanged(FIRST, treeItem.isFirst());
                crumb.pseudoClassStateChanged(LAST, treeItem.isLast());
                this.getChildren().add((Object)crumb);
                divider = this.createDivider(treeItem);
                if (divider == null) continue;
                if (treeItem.isLast()) {
                    divider.pseudoClassStateChanged(FIRST, false);
                    divider.pseudoClassStateChanged(LAST, true);
                }
                this.getChildren().add((Object)divider);
            }
        }
    }

    protected List<Breadcrumbs.BreadCrumbItem<T>> constructFlatPath(Breadcrumbs.BreadCrumbItem<T> bottomMost) {
        ArrayList<Breadcrumbs.BreadCrumbItem<T>> path = new ArrayList<Breadcrumbs.BreadCrumbItem<T>>();
        Breadcrumbs.BreadCrumbItem current = bottomMost;
        do {
            path.add(current);
            current.setFirst(false);
            current.setLast(false);
        } while ((current = (Breadcrumbs.BreadCrumbItem)current.getParent()) != null);
        Collections.reverse(path);
        if (path.size() > 0) {
            ((Breadcrumbs.BreadCrumbItem)((Object)path.get(0))).setFirst(true);
        }
        if (path.size() > 1) {
            ((Breadcrumbs.BreadCrumbItem)((Object)path.get(path.size() - 1))).setLast(true);
        }
        return path;
    }

    protected ButtonBase createCrumb(Breadcrumbs.BreadCrumbItem<T> treeItem) {
        ButtonBase crumb = (ButtonBase)((Breadcrumbs)this.getSkinnable()).getCrumbFactory().call(treeItem);
        crumb.setMnemonicParsing(false);
        if (!crumb.getStyleClass().contains((Object)"crumb")) {
            crumb.getStyleClass().add((Object)"crumb");
        }
        crumb.setOnAction(e -> this.onBreadCrumbAction(treeItem));
        return crumb;
    }

    protected Node createDivider(Breadcrumbs.BreadCrumbItem<T> treeItem) {
        Node divider = (Node)((Breadcrumbs)this.getSkinnable()).getDividerFactory().call(treeItem);
        if (divider == null) {
            return null;
        }
        if (!divider.getStyleClass().contains((Object)"divider")) {
            divider.getStyleClass().add((Object)"divider");
        }
        return divider;
    }

    protected void onBreadCrumbAction(Breadcrumbs.BreadCrumbItem<T> crumbModel) {
        Breadcrumbs breadCrumbBar = (Breadcrumbs)this.getSkinnable();
        Event.fireEvent((EventTarget)breadCrumbBar, new Breadcrumbs.BreadCrumbActionEvent<T>(crumbModel));
        if (breadCrumbBar.isAutoNavigationEnabled()) {
            breadCrumbBar.setSelectedCrumb(crumbModel);
        }
    }
}

