/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.data;

import com.inkwellideas.ographer.data.ViewLevel;

public abstract class MapObject {
    protected boolean gmOnly;
    protected double adjustScaleFactor = 100.0;

    public boolean isGmOnly() {
        return this.gmOnly;
    }

    public void setGmOnly(boolean gmOnly) {
        this.gmOnly = gmOnly;
    }

    public abstract MapObject clone();

    public static double getConversionFactor(ViewLevel vl, ViewLevel currentObjViewLevel, double continentFactor, double kingdomFactor, double provinceFactor) {
        if (vl == currentObjViewLevel) {
            return 1.0;
        }
        switch (vl) {
            case WORLD: {
                switch (currentObjViewLevel) {
                    case WORLD: {
                        return 1.0;
                    }
                    case CONTINENT: {
                        return 1.0 / continentFactor;
                    }
                    case KINGDOM: {
                        return 1.0 / (continentFactor * kingdomFactor);
                    }
                    case PROVINCE: {
                        return 1.0 / (continentFactor * kingdomFactor * provinceFactor);
                    }
                }
            }
            case CONTINENT: {
                switch (currentObjViewLevel) {
                    case WORLD: {
                        return continentFactor;
                    }
                    case CONTINENT: {
                        return 1.0;
                    }
                    case KINGDOM: {
                        return 1.0 / kingdomFactor;
                    }
                    case PROVINCE: {
                        return 1.0 / (kingdomFactor * provinceFactor);
                    }
                }
            }
            case KINGDOM: {
                switch (currentObjViewLevel) {
                    case WORLD: {
                        return continentFactor * kingdomFactor;
                    }
                    case CONTINENT: {
                        return kingdomFactor;
                    }
                    case KINGDOM: {
                        return 1.0;
                    }
                    case PROVINCE: {
                        return 1.0 / provinceFactor;
                    }
                }
            }
            case PROVINCE: {
                switch (currentObjViewLevel) {
                    case WORLD: {
                        return continentFactor * kingdomFactor * provinceFactor;
                    }
                    case CONTINENT: {
                        return kingdomFactor * provinceFactor;
                    }
                    case KINGDOM: {
                        return provinceFactor;
                    }
                    case PROVINCE: {
                        return 1.0;
                    }
                }
            }
        }
        return 1.0;
    }
}

