/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.Corridor;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;

public class MakeDungeonViaMinimorphs {
    public static void makeDungeon(int seed, String wall, String floor, String deluxefloor, Terrain[][] t, List<MapShape> shapes, List<Feature> features, HashSet<Note> notes, int sectionswide, int sectionshigh, MapLayer featurelayer, MapLayer shapelayer) {
        Random r = new Random();
        r.setSeed(seed);
        for (int i = 0; i < sectionswide; ++i) {
            for (int j = 0; j < sectionshigh; ++j) {
                int rotate = 0;
                MakeDungeonViaMinimorphs.makeSimplePlus(r, shapes, features, wall, floor, i * 5, j * 5, rotate, featurelayer, shapelayer, j == 0 ? 0 : 1, i == sectionswide - 1 ? 0 : 1, j == sectionshigh - 1 ? 0 : 1, i == 0 ? 0 : 1);
            }
        }
    }

    public static void makeSimplePlus(Random r, List<MapShape> shapes, List<Feature> features, String wallTexture, String floorTexture, double offsetX, double offsetY, int rotate, MapLayer featureLayer, MapLayer shapeLayer, int top, int right, int bottom, int left) {
        ArrayList<double[]> wallPointLists = new ArrayList<double[]>();
        double[] list1 = new double[]{0.0, 2.0, 2.0, 2.0, 2.0, 3.0, 0.0, 3.0};
        double[] list2 = new double[]{5.0, 2.0, 3.0, 2.0, 3.0, 3.0, 5.0, 3.0};
        double[] list3 = new double[]{2.0, 5.0, 2.0, 0.0, 3.0, 0.0, 3.0, 5.0};
        wallPointLists.add(list1);
        Corridor.makeCorridorRotatable(shapes, wallTexture, floorTexture, offsetX, offsetY, rotate, shapeLayer, wallPointLists, 5);
        MakeDungeonViaMinimorphs.placeFeature(features, offsetX, offsetY, rotate, featureLayer, 2.0, 2.5, -1.0, -1.0, 90.0, "Battlemat/Door Wood", "door", 5);
        wallPointLists.clear();
        wallPointLists.add(list2);
        Corridor.makeCorridorRotatable(shapes, wallTexture, floorTexture, offsetX, offsetY, rotate, shapeLayer, wallPointLists, 5);
        MakeDungeonViaMinimorphs.placeFeature(features, offsetX, offsetY, rotate, featureLayer, 3.0, 2.5, -1.0, -1.0, 90.0, "Battlemat/Door Wood", "door", 5);
        wallPointLists.clear();
        wallPointLists.add(list3);
        Corridor.makeCorridorRotatable(shapes, wallTexture, floorTexture, offsetX, offsetY, rotate, shapeLayer, wallPointLists, 5);
        MakeDungeonViaMinimorphs.placeFeature(features, offsetX, offsetY, rotate, featureLayer, 2.5, 0.0, -1.0, -1.0, 0.0, "Battlemat/Door Wood", "door", 5);
    }

    public static void placeFeature(List<Feature> features, double offsetx, double offsety, int roomrotation, MapLayer featurelayer, double x, double y, double w, double h, double rotation, String name, String tag, int sectionSize) {
        if (roomrotation == 90) {
            temp = x;
            x = (double)sectionSize - y;
            y = temp;
            rotation += 90.0;
        } else if (roomrotation == 180) {
            x = (double)sectionSize - x;
            y = (double)sectionSize - y;
            rotation += 180.0;
        } else if (roomrotation == 270) {
            temp = x;
            x = y;
            y = (double)sectionSize - temp;
            rotation += 270.0;
        }
        Feature maindoor = new Feature(name, false, false, false, false, null, rotation, null, w, h, null, tag, false, false, false, false, featurelayer);
        maindoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((offsetx + x) * 300.0, (offsety + y) * 300.0));
        features.add(maindoor);
    }
}

