/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.generator.battlemat.Exit;
import com.inkwellideas.ographer.generator.battlemat.ProceduralDungeonRoom;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;

public class ProceduralDungeonGenerator {
    Map<String, ProceduralDungeonRoom> rooms = new HashMap<String, ProceduralDungeonRoom>();
    Map<String, List<Exit>> exits = new HashMap<String, List<Exit>>();
    Random random = new Random();
    Terrain[][] terrain;
    List<MapShape> shapes;
    List<Feature> features;
    List<MapLabel> labels;
    HashSet<Note> notes;
    MapLayer shapeLayer;
    MapLayer featureLayer;
    MapLayer labelLayer;

    public ProceduralDungeonGenerator(int seed, Terrain[][] terrain, List<MapShape> shapes, List<Feature> features, List<MapLabel> labels, HashSet<Note> notes, MapLayer shapeLayer, MapLayer featureLayer, MapLayer labelLayer) {
        this.random.setSeed(seed);
        this.terrain = terrain;
        this.shapes = shapes;
        this.features = features;
        this.labels = labels;
        this.notes = notes;
        this.shapeLayer = shapeLayer;
        this.featureLayer = featureLayer;
        this.labelLayer = labelLayer;
    }

    public boolean generate(Map<String, ProceduralDungeonRoom> rooms) {
        this.rooms = rooms;
        boolean success = false;
        int tries = 0;
        int mostRooms = 0;
        int roomCount = 0;
        Terrain[][] bestTerrain = null;
        List<MapShape> bestShapes = null;
        List<Feature> bestFeatures = null;
        List<MapLabel> bestLabels = null;
        HashSet<Note> bestNotes = null;
        block0: while (!success && tries++ < 1000) {
            if (roomCount > mostRooms) {
                mostRooms = roomCount;
                bestTerrain = this.terrain;
                bestShapes = this.shapes;
                bestFeatures = this.features;
                bestLabels = this.labels;
                bestNotes = this.notes;
            }
            for (int i = 0; i < this.terrain.length; ++i) {
                for (int j = 0; j < this.terrain[i].length; ++j) {
                    this.terrain[i][j] = new Terrain("Blank", true);
                }
            }
            this.shapes.clear();
            this.features.clear();
            this.labels.clear();
            this.notes.clear();
            roomCount = 0;
            ProceduralDungeonRoom entranceRoom = rooms.get("Entrance");
            this.createEntrance(rooms, "Entrance", entranceRoom.minWidth, entranceRoom.minHeight, entranceRoom.maxWidth, entranceRoom.maxHeight);
            List<String> roomsFromEntrance = entranceRoom.adjacentRooms;
            for (String roomName : roomsFromEntrance) {
                if (roomName.endsWith("-")) {
                    roomName = roomName.substring(0, roomName.length() - 1);
                }
                ProceduralDungeonRoom room = rooms.get(roomName);
                int singleRoomTries = 0;
                boolean roomSuccess = false;
                while (!roomSuccess && singleRoomTries++ < 25) {
                    roomSuccess = this.createRooms(rooms, room.type, "Entrance", room.minWidth, room.minHeight, room.maxWidth, room.maxHeight);
                }
                if (roomSuccess) {
                    ++roomCount;
                }
                if (success = roomSuccess) continue;
                System.out.println("tries: " + tries);
                continue block0;
            }
        }
        if (!success) {
            this.terrain = bestTerrain;
            this.shapes = bestShapes;
            this.features = bestFeatures;
            this.labels = bestLabels;
            this.notes = bestNotes;
        }
        return success;
    }

    private boolean createEntrance(Map<String, ProceduralDungeonRoom> roomMap, String roomName, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        int roomWidth = (int)(this.random.nextDouble() * (double)(maxWidth - minWidth)) + minWidth;
        int roomHeight = (int)(this.random.nextDouble() * (double)(maxHeight - minHeight)) + minHeight;
        int x = this.terrain.length / 2 - roomWidth / 2;
        int y = this.terrain[0].length / 2 - roomHeight / 2;
        for (int j = x; j < x + roomWidth; ++j) {
            for (int k = y; k < y + roomHeight; ++k) {
                if (j < 0 || j >= this.terrain.length || k < 0 || k >= this.terrain[j].length) continue;
                this.terrain[j][k] = new Terrain("Floor/Stone Light", false);
            }
        }
        ArrayList<Exit> exitList = new ArrayList<Exit>();
        MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + roomWidth, y + roomHeight, "Rock Dark", 0.1, "Pavers Light", this.shapeLayer, "room", exitList);
        this.shapes.add(ms);
        this.exits.put(roomName, exitList);
        MapLabel ml = new MapLabel("Room", roomName, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", this.labelLayer);
        ml.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D((double)((x + roomWidth / 2) * 300), (double)((y + roomHeight / 2) * 300)), 25.0);
        this.labels.add(ml);
        return true;
    }

    private boolean createRooms(Map<String, ProceduralDungeonRoom> roomMap, String roomName, String priorRoomName, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        int k;
        int j;
        MapShape ms;
        List<String> roomList = roomMap.get((Object)roomName).adjacentRooms;
        int roomWidth = (int)(this.random.nextDouble() * (double)(maxWidth - minWidth)) + minWidth;
        int roomHeight = (int)(this.random.nextDouble() * (double)(maxHeight - minHeight)) + minHeight;
        if (roomName.toLowerCase().contains("hall") && roomWidth > 2 && roomHeight > 2) {
            if (this.random.nextBoolean()) {
                roomWidth = 2;
            } else {
                roomHeight = 2;
            }
        }
        int x = this.terrain.length / 2 - roomWidth / 2;
        int y = this.terrain[0].length / 2 - roomHeight / 2;
        List<Exit> priorExitList = this.exits.get(priorRoomName);
        Exit exit = priorExitList.get((int)(this.random.nextDouble() * (double)priorExitList.size()));
        if (exit.angle == 0.0) {
            x = (int)(exit.x / 300.0 - 0.5) - roomWidth / 2;
            y = (int)(exit.y / 300.0);
        } else if (exit.angle == 90.0) {
            y = (int)(exit.y / 300.0 - 0.5) - roomHeight / 2;
            x = (int)(exit.x / 300.0);
        } else if (exit.angle == 180.0) {
            x = (int)(exit.x / 300.0 - 0.5) - roomWidth / 2;
            y = (int)(exit.y / 300.0);
        } else if (exit.angle == 270.0) {
            y = (int)(exit.y / 300.0 - 0.5) - roomHeight / 2;
            x = (int)(exit.x / 300.0);
        }
        double exitX = exit.x;
        double exitY = exit.y;
        int connectorW = 0;
        int connectorH = 0;
        if (this.random.nextDouble() < 0.75) {
            int[] lengthOpts = new int[]{1, 1, 1, 2, 2, 3};
            connectorW = exit.angle == 90.0 || exit.angle == 270.0 ? lengthOpts[this.random.nextInt(6)] : 1;
            int n = connectorH = exit.angle == 0.0 || exit.angle == 180.0 ? lengthOpts[this.random.nextInt(6)] : 1;
            if (exit.angle == 0.0) {
                x = (int)(exit.x / 300.0 - 0.5) - connectorW / 2;
                y = (int)(exit.y / 300.0) - connectorH;
            } else if (exit.angle == 90.0) {
                y = (int)(exit.y / 300.0 - 0.5) - connectorH / 2;
                x = (int)(exit.x / 300.0);
            } else if (exit.angle == 180.0) {
                x = (int)(exit.x / 300.0 - 0.5) - connectorW / 2;
                y = (int)(exit.y / 300.0);
            } else if (exit.angle == 270.0) {
                y = (int)(exit.y / 300.0 - 0.5) - connectorH / 2;
                x = (int)(exit.x / 300.0) - connectorW;
            }
            if (BattlematDataGenerator.doRoomsOverlap(this.terrain, x, y, connectorW, connectorH)) {
                System.out.println("corridor overlap");
                return false;
            }
            Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, exit.angle, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, this.featureLayer);
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(exit.x, exit.y));
            this.features.add(door);
            MapLabel ml = new MapLabel("Room", "*" + roomName, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", this.labelLayer);
            ml.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D(((double)x + (double)connectorW / 2.0) * 300.0, ((double)y + (double)connectorH / 2.0) * 300.0), 25.0);
            this.labels.add(ml);
            ms = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + connectorW, y + connectorH, "Rock Dark", 0.15, "Pavers Light", this.shapeLayer, "room", new ArrayList<Exit>());
            this.shapes.add(ms);
            for (j = x; j < x + connectorW; ++j) {
                for (k = y; k < y + connectorH; ++k) {
                    if (j < 0 || j >= this.terrain.length || k < 0 || k >= this.terrain[j].length) continue;
                    this.terrain[j][k] = new Terrain("Floor/Stone Light", false);
                }
            }
            if (exit.angle == 0.0) {
                exitY -= (double)(connectorH * 300);
            } else if (exit.angle == 90.0) {
                exitX += (double)(connectorW * 300);
                x += connectorW;
            } else if (exit.angle == 180.0) {
                exitY += (double)(connectorH * 300);
                y += connectorH;
            } else if (exit.angle == 270.0) {
                exitX -= (double)(connectorW * 300);
            }
        }
        if (exit.angle == 0.0) {
            y -= roomHeight;
        } else if (exit.angle == 270.0) {
            x -= roomWidth;
        }
        System.out.println("x:" + x + " y:" + y + " angle:" + exit.angle + " roomWidth:" + roomWidth + " roomHeight:" + roomHeight);
        if (BattlematDataGenerator.doRoomsOverlap(this.terrain, x, y, roomWidth, roomHeight)) {
            System.out.println("room overlap");
            return false;
        }
        priorExitList.remove(exit);
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, exit.angle, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, this.featureLayer);
        door.setLocation(ViewLevel.BATTLEMAT, new Point2D(exitX, exitY));
        this.features.add(door);
        MapLabel ml = new MapLabel("Room", roomName, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", this.labelLayer);
        ml.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D((double)((x + roomWidth / 2) * 300), (double)((y + roomHeight / 2) * 300)), 25.0);
        this.labels.add(ml);
        ArrayList<Exit> exitList = new ArrayList<Exit>();
        this.exits.put(roomName, exitList);
        ms = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + roomWidth, y + roomHeight, "Rock Dark", 0.15, "Pavers Light", this.shapeLayer, "room", exitList);
        this.shapes.add(ms);
        System.out.println("added:" + roomName);
        for (j = x; j < x + roomWidth; ++j) {
            for (k = y; k < y + roomHeight; ++k) {
                if (j < 0 || j >= this.terrain.length || k < 0 || k >= this.terrain[j].length) continue;
                this.terrain[j][k] = new Terrain("Floor/Stone Light", false);
            }
        }
        if (roomList != null && !roomList.isEmpty()) {
            for (String nextRoomName : roomList) {
                if (nextRoomName.endsWith("-")) {
                    nextRoomName = nextRoomName.substring(0, nextRoomName.length() - 1);
                }
                ProceduralDungeonRoom room = roomMap.get(nextRoomName);
                this.createRooms(roomMap, room.type, roomName, room.minWidth, room.minHeight, room.maxWidth, room.maxHeight);
            }
        }
        return true;
    }
}

