/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.information;

import com.inkwellideas.ographer.map.MapDataIO;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Information {
    protected String name;
    protected String text;
    public List<Information> children;
    public UUID uuid;

    public Information(String title, String text, List<Information> c) {
        this(title, text, c, UUID.randomUUID());
    }

    public Information(String title, String text, List<Information> c, UUID uuid) {
        this.name = title;
        this.text = text;
        this.children = c;
        this.uuid = uuid;
    }

    public void addChild(Information c) {
        if (this.children == null) {
            this.children = new ArrayList<Information>();
        }
        this.children.add(c);
    }

    public void addChild(Integer i, Information c) {
        if (this.children == null) {
            this.children = new ArrayList<Information>();
        }
        this.children.add(i, c);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String generateInfo() {
        return "";
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getXMLString() {
        StringBuilder sb = new StringBuilder("<information uuid=\"" + this.uuid.toString() + "\" type=\"" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + "\" title=\"" + MapDataIO.toEscapedXML(this.name) + "\"><![CDATA[" + MapDataIO.toEscapedXML(this.text, false) + "]]>");
        if (this.children != null) {
            for (Information i : this.children) {
                sb.append("\n").append(i.getXMLString());
            }
        }
        sb.append("\n</information>\n");
        return sb.toString();
    }

    public String getAdditionalWriteInfo() {
        return "";
    }

    public void writeXMLString(Writer w) throws IOException {
        String noControlCharText = this.text;
        noControlCharText = noControlCharText.replace("\u0002", "");
        w.write("<information uuid=\"" + this.uuid.toString() + "\" type=\"" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + "\" title=\"" + MapDataIO.toEscapedXML(this.name) + "\"" + this.getAdditionalWriteInfo() + "><![CDATA[" + noControlCharText + "]]>\n");
        w.flush();
        if (this.children != null) {
            for (Information i : this.children) {
                if (i == null) continue;
                i.writeXMLString(w);
            }
        }
        w.write("\n</information>\n");
    }
}

