/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.io;

import com.inkwellideas.ographer.data.CheckUtils;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.OtherDialog;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;

public class UserPrefs {
    public static final String AUTO_UPDATE_OTHER_LEVELS = "autoUpdateOtherLevels";
    public static final String SELECT_INSIDE_POLYGONS = "selectInsidePolygons";
    public static final String SELECT_FEATURE_WHEN_PLACED = "selectFeatureWhenPlaced";
    public static final String USE_SIMILAR_NAMED_FEATURES = "useSimilarNamedFeaturesItem";
    public static final String SCROLL_WHEEL_ZOOM = "scrollWheelZoom";
    public static final String AUTO_SAVE = "autoSave";
    public static final String ADD_RANDOMNESS_TO_NEW_TERRAIN = "addRandomnessToNewTerrain";
    public static final Preferences PREFS = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
    public static String FAVORITE_FEATURES = PREFS.get("favorites features", "\t");
    public static String CONFIG_FOLDER = PREFS.get("configfolder", System.getProperty("user.home") + File.separator + "worldographer");
    public static String FAVORITE_TERRAIN = PREFS.get("favorites terrain", "\t");
    public static boolean FULL = System.currentTimeMillis() < Worldographer.demoTime;

    public static void load() {
        try {
            FULL = CheckUtils.check2025Dates(PREFS.get("lik2025", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (FULL) {
            TextureType.loadUserTextures(CONFIG_FOLDER);
            TerrainType.loadUserTerrain(Terrain.DEFAULT_TERRAIN, CONFIG_FOLDER);
            FeatureType.loadUserFeatures(Feature.DEFAULT_FEATURES, CONFIG_FOLDER);
            Feature.featureTypes.putAll(Feature.DEFAULT_FEATURES);
        }
        Worldographer.pingUsage("http://www.worldographer.com/usage/lics_" + PREFS.get("lik2025", "") + ".txt");
    }

    public static boolean darkMode() {
        return Preferences.userRoot().node("com/inkwellideas/worldographer2025").getBoolean("darkTheme", false);
    }

    public static void freeModeAlert() {
        if (!FULL) {
            Dialog d = new Dialog();
            d.setWidth(800.0);
            d.setHeight(640.0);
            d.setTitle("Free/Trial Version");
            d.setHeaderText("Free/Trial Version");
            d.getDialogPane().setContentText("No license detected. Defaulting to the 'free' version.\n\nYou'll need a pro license to use the 'power-user' features such as:\n* World/Region Map levels: drill down to add detail.\n* Configuring terrain, features, textures, grid.\n* Expanding/Reducing columns & rows of terrain.\n* Add Notes to the map.\n* Generate coasts, rivers, and nations quickly.\n* Trace an under-laid image.\n* Terrain Wizard (fill in a partly blank map).\n* Generate settlement maps with over 5000 people.\n* Specialty battlemat maps for stores, taverns, etc.\n* A room generator for battlemats.\n\nAnd a license supports continued development.\n\nGet a license at https://store.inkwellideas.com.\nThen enter a license here or use the File menu's Check/Update License.\n");
            ButtonType yes = new ButtonType("Go To Our Store");
            ButtonType enterLicense = new ButtonType("Enter License");
            ButtonType cancel = new ButtonType("Use The Free Version");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, enterLicense, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                try {
                    URI u = new URI("https://store.inkwellideas.com/collections/software-icon-sets");
                    Desktop.getDesktop().browse(u);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                d.close();
            } else if (result.isPresent() && result.get() == enterLicense) {
                new OtherDialog().showOtherDialog(Worldographer.getWorldographer().getPrimaryStage());
            } else {
                d.close();
            }
        }
    }

    public static void set(String key, boolean value) {
        Preferences.userRoot().node("com/inkwellideas/worldographer2025").putBoolean(key, value);
        FileSaveLoad.flushPrefs();
    }

    public static Boolean get(String key, boolean defaultValue) {
        return Preferences.userRoot().node("com/inkwellideas/worldographer2025").getBoolean(key, defaultValue);
    }
}

