/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.undo.Undoable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.util.Pair;

public class MapLabel
extends MapObject
implements Undoable {
    private String style;
    private String text;
    private String fontFace;
    private Color color;
    private Color outlineColor;
    private Color backgroundColor;
    private double outlineSize;
    private double rotate;
    private boolean isBold;
    private boolean isItalic;
    private MapLayer mapLayer;
    private boolean isWorld;
    private boolean isContinent;
    private boolean isKingdom;
    private boolean isProvince;
    private String tags;
    private TextAlignment textAlignment;
    private Map<ViewLevel, Pair<Point2D, Double>> location = new HashMap<ViewLevel, Pair<Point2D, Double>>();

    public MapLabel(String style, String text, String fontFace, Color color, double outlineSize, Color outlineColor, Color backgroundColor, double rotate, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, boolean isBold, boolean isItalic, boolean gmOnly, TextAlignment ta, String tags, MapLayer ml) {
        this.style = style;
        this.text = text;
        this.fontFace = fontFace;
        this.color = color;
        this.outlineSize = outlineSize;
        this.outlineColor = outlineColor;
        this.backgroundColor = backgroundColor;
        this.rotate = rotate;
        this.isWorld = isWorld;
        this.isContinent = isContinent;
        this.isKingdom = isKingdom;
        this.isProvince = isProvince;
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.mapLayer = ml;
        this.gmOnly = gmOnly;
        this.tags = tags;
        this.textAlignment = ta;
    }

    @Override
    public MapLabel clone() {
        MapLabel f = new MapLabel(this.style, this.text, this.fontFace, this.color, this.outlineSize, this.outlineColor, this.backgroundColor, this.rotate, this.isWorld, this.isContinent, this.isKingdom, this.isProvince, this.isBold, this.isItalic, this.gmOnly, this.textAlignment, this.tags, this.mapLayer);
        for (ViewLevel vl : this.location.keySet()) {
            f.location.put(vl, this.location.get((Object)vl));
        }
        return f;
    }

    @Override
    public void makeIdenticalTo(Undoable u) {
        if (!(u instanceof MapLabel)) {
            return;
        }
        MapLabel f = (MapLabel)u;
        this.style = f.style;
        this.text = f.text;
        this.fontFace = f.fontFace;
        this.color = f.color;
        this.outlineColor = f.outlineColor;
        this.outlineSize = f.outlineSize;
        this.backgroundColor = f.backgroundColor;
        this.rotate = f.rotate;
        this.isWorld = f.isWorld;
        this.isContinent = f.isContinent;
        this.isKingdom = f.isKingdom;
        this.isProvince = f.isProvince;
        this.isBold = f.isBold;
        this.isItalic = f.isItalic;
        this.mapLayer = f.mapLayer;
        this.gmOnly = f.gmOnly;
        this.textAlignment = f.textAlignment;
        this.tags = f.tags;
        this.location = new HashMap<ViewLevel, Pair<Point2D, Double>>();
        for (ViewLevel vl : f.location.keySet()) {
            this.location.put(vl, f.location.get((Object)vl));
        }
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFontFace() {
        return this.fontFace;
    }

    public void setFontFace(String fontFace) {
        this.fontFace = fontFace;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public double getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineSize(double outlineSize) {
        this.outlineSize = outlineSize;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }

    public boolean isWorld() {
        return this.isWorld;
    }

    public void setWorld(boolean isWorld) {
        this.isWorld = isWorld;
    }

    public boolean isContinent() {
        return this.isContinent;
    }

    public void setContinent(boolean isContinent) {
        this.isContinent = isContinent;
    }

    public boolean isKingdom() {
        return this.isKingdom;
    }

    public void setKingdom(boolean isKingdom) {
        this.isKingdom = isKingdom;
    }

    public boolean isProvince() {
        return this.isProvince;
    }

    public void setProvince(boolean isProvince) {
        this.isProvince = isProvince;
    }

    public Map<ViewLevel, Pair<Point2D, Double>> getLocation() {
        return this.location;
    }

    public void setLocationAndScale(ViewLevel vl, Pair<Point2D, Double> locationscale) {
        this.location.put(vl, locationscale);
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public Double getScale(ViewLevel vl) {
        if (this.location.get((Object)vl) == null) {
            return null;
        }
        return (Double)this.location.get((Object)vl).getValue();
    }

    public void clearOtherLocationsAndScales(ViewLevel vl) {
        if (vl != ViewLevel.WORLD) {
            this.location.put(ViewLevel.WORLD, null);
        }
        if (vl != ViewLevel.CONTINENT) {
            this.location.put(ViewLevel.CONTINENT, null);
        }
        if (vl != ViewLevel.KINGDOM) {
            this.location.put(ViewLevel.KINGDOM, null);
        }
        if (vl != ViewLevel.PROVINCE) {
            this.location.put(ViewLevel.PROVINCE, null);
        }
    }

    public void updateLocation(ViewLevel priorvl, ViewLevel newvl, MapData mapData) {
        Double scaleorig = this.getScale(priorvl);
        if (scaleorig == null) {
            return;
        }
        Point2D loc = mapData.calculateCoordinateAtNewLevel(priorvl, newvl, this.getLocation(priorvl));
        if (loc != null) {
            this.setLocationAndScale(newvl, (Pair<Point2D, Double>)new Pair((Object)loc, (Object)scaleorig));
        }
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public MapLayer getMapLayer() {
        return this.mapLayer;
    }

    public void setMapLayer(MapLayer mapLayer) {
        this.mapLayer = mapLayer;
    }

    public Point2D getLocation(ViewLevel vl) {
        if (this.location.get((Object)vl) == null) {
            return null;
        }
        return (Point2D)this.location.get((Object)vl).getKey();
    }

    public void setLocationAndScale(ViewLevel vl, Point2D pt, Double scale) {
        this.location.put(vl, (Pair<Point2D, Double>)new Pair((Object)pt, (Object)scale));
    }

    public void paint(GraphicsContext g, MapData md, double hexw, double hexh, double offsetscrollx, double offsetscrolly, ViewLevel vl, HexOrientation tileorientation, double continentfactor, double kingdomfactor, double provincefactor, boolean glowGMOnly) {
        Pair<Point2D, Double> pair = this.location.get((Object)vl);
        if (pair == null) {
            return;
        }
        Point2D modelpt = (Point2D)pair.getKey();
        Point2D pt = new Point2D(modelpt.getX() * hexw / 300.0 - offsetscrollx, modelpt.getY() * hexh / 300.0 - offsetscrolly);
        this.paint(g, md, pt.getX(), pt.getY(), hexw, hexh, offsetscrollx, offsetscrolly, vl, tileorientation, continentfactor, kingdomfactor, provincefactor, glowGMOnly);
    }

    public Font getFont(MapData md, double hexh, ViewLevel vl, double continentfactor, double kingdomfactor) {
        if (md.getLabelStyles() != null && md.getLabelStyles().containsKey(this.style)) {
            LabelStyle ls = md.getLabelStyles().get(this.style);
            FontWeight fw = ls.isBold() ? FontWeight.BOLD : FontWeight.NORMAL;
            FontPosture fp = ls.isItalic() ? FontPosture.ITALIC : FontPosture.REGULAR;
            double fontsize = hexh * ls.getScale() / 100.0;
            if (vl.equals((Object)ViewLevel.CONTINENT)) {
                fontsize *= continentfactor;
            }
            if (vl.equals((Object)ViewLevel.KINGDOM)) {
                fontsize = fontsize * continentfactor * kingdomfactor;
            }
            return Font.font((String)ls.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)fontsize);
        }
        FontWeight fw = this.isBold ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture fp = this.isItalic ? FontPosture.ITALIC : FontPosture.REGULAR;
        Double scale = this.getScale(vl);
        if (scale == null) {
            ViewLevel avl;
            ViewLevel[] vls;
            ViewLevel[] viewLevelArray = vls = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE, ViewLevel.SETTLEMENT, ViewLevel.BATTLEMAT};
            int n = viewLevelArray.length;
            for (int i = 0; i < n && (scale = this.getScale(avl = viewLevelArray[i])) == null; ++i) {
            }
            if (scale == null) {
                scale = 20.0;
            }
        }
        return Font.font((String)this.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)(hexh * scale / 100.0));
    }

    public void paint(GraphicsContext g, MapData md, double x, double y, double hexw, double hexh, double offseth, double offsetv, ViewLevel vl, HexOrientation tileorientation, double continentfactor, double kingdomfactor, double provincefactor, boolean glowGMOnly) {
        g.setLineDashes(null);
        if (glowGMOnly && this.isGmOnly()) {
            DropShadow ds = new DropShadow();
            ds.setSpread(2.0);
            ds.setRadius(2.0);
            ds.setColor(new Color(1.0, 0.0, 0.0, 0.5));
            ds.setOffsetX(0.0);
            ds.setOffsetY(0.0);
            g.setEffect((Effect)ds);
        }
        if (md.getLabelStyles().containsKey(this.style)) {
            if (this.text != null && !this.text.trim().equals("")) {
                LabelStyle ls = md.getLabelStyles().get(this.style);
                g.setStroke((Paint)ls.getColor());
                FontWeight fw = ls.isBold() ? FontWeight.BOLD : FontWeight.NORMAL;
                FontPosture fp = ls.isItalic() ? FontPosture.ITALIC : FontPosture.REGULAR;
                double scale = this.getAdjustedScale(vl, continentfactor, kingdomfactor, provincefactor, ls.getScale());
                g.setFont(Font.font((String)ls.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)(hexh * scale / 100.0)));
                if (ls.getBackgroundColor() != null) {
                    g.setFill((Paint)ls.getBackgroundColor());
                    List<Point2D> labelscreencontrolpts = this.getRotatedBoundingBoxPoints(md, x, y, hexw, hexh, continentfactor, kingdomfactor, provincefactor, offseth, offsetv, vl);
                    if (labelscreencontrolpts != null) {
                        double[] polyxpts = new double[]{labelscreencontrolpts.get(0).getX(), labelscreencontrolpts.get(1).getX(), labelscreencontrolpts.get(2).getX(), labelscreencontrolpts.get(3).getX()};
                        double[] polyypts = new double[]{labelscreencontrolpts.get(0).getY(), labelscreencontrolpts.get(1).getY(), labelscreencontrolpts.get(2).getY(), labelscreencontrolpts.get(3).getY()};
                        g.fillPolygon(polyxpts, polyypts, polyxpts.length);
                    }
                }
                if (this.rotate != 0.0) {
                    g.save();
                    Rotate r = new Rotate(this.rotate, x, y);
                    g.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
                }
                g.setFill((Paint)ls.getColor());
                g.setTextAlign(this.textAlignment);
                g.fillText(this.text, x, y);
                if (ls.getOutlineSize() > 0.0) {
                    g.setStroke((Paint)ls.getOutlineColor());
                    g.setLineWidth(ls.getOutlineSize() / 100.0 * hexh);
                    g.strokeText(this.text, x, y);
                }
                if (this.rotate != 0.0) {
                    g.restore();
                }
                g.setTextAlign(TextAlignment.CENTER);
            }
        } else if (this.text != null && !this.text.trim().equals("")) {
            FontWeight fw = this.isBold ? FontWeight.BOLD : FontWeight.NORMAL;
            FontPosture fp = this.isItalic ? FontPosture.ITALIC : FontPosture.REGULAR;
            Double scale = this.getScale(vl);
            if ((scale = this.getAdjustedScale(vl, continentfactor, kingdomfactor, provincefactor, scale)) != null) {
                g.setFont(Font.font((String)this.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)(hexh * scale / 100.0)));
                if (this.getBackgroundColor() != null) {
                    g.setFill((Paint)this.getBackgroundColor());
                    List<Point2D> labelscreencontrolpts = this.getRotatedBoundingBoxPoints(md, x, y, hexw, hexh, continentfactor, kingdomfactor, provincefactor, offseth, offsetv, vl);
                    if (labelscreencontrolpts != null) {
                        double[] polyxpts = new double[]{labelscreencontrolpts.get(0).getX(), labelscreencontrolpts.get(1).getX(), labelscreencontrolpts.get(2).getX(), labelscreencontrolpts.get(3).getX()};
                        double[] polyypts = new double[]{labelscreencontrolpts.get(0).getY(), labelscreencontrolpts.get(1).getY(), labelscreencontrolpts.get(2).getY(), labelscreencontrolpts.get(3).getY()};
                        g.fillPolygon(polyxpts, polyypts, polyxpts.length);
                    }
                }
                if (this.rotate != 0.0) {
                    g.save();
                    Rotate r = new Rotate(this.rotate, x, y);
                    g.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
                }
                g.setFill((Paint)this.color);
                g.setTextAlign(this.textAlignment);
                g.fillText(this.text, x, y);
                if (this.outlineSize > 0.0) {
                    g.setStroke((Paint)this.outlineColor);
                    g.setLineWidth(this.outlineSize / 100.0 * hexh);
                    g.strokeText(this.text, x, y);
                }
            }
            if (this.rotate != 0.0) {
                g.restore();
            }
            g.setTextAlign(TextAlignment.CENTER);
        }
        g.setEffect(null);
    }

    private Double getAdjustedScale(ViewLevel vl, double continentfactor, double kingdomfactor, double provincefactor, Double scale) {
        if (scale == null) {
            double scalediff;
            double scaleorig;
            if (this.getScale(ViewLevel.CONTINENT) != null) {
                scaleorig = this.getScale(ViewLevel.CONTINENT);
                scale = this.getScale(ViewLevel.CONTINENT) * MapLabel.getConversionFactor(ViewLevel.CONTINENT, vl, continentfactor, kingdomfactor, provincefactor);
                scalediff = scale - scaleorig;
                scale = scaleorig + scalediff * this.adjustScaleFactor / 100.0;
            }
            if (this.getScale(ViewLevel.WORLD) != null) {
                scaleorig = this.getScale(ViewLevel.WORLD);
                scale = this.getScale(ViewLevel.WORLD) * MapLabel.getConversionFactor(ViewLevel.WORLD, vl, continentfactor, kingdomfactor, provincefactor);
                scalediff = scale - scaleorig;
                scale = scaleorig + scalediff * this.adjustScaleFactor / 100.0;
            }
            if (this.getScale(ViewLevel.KINGDOM) != null) {
                scaleorig = this.getScale(ViewLevel.KINGDOM);
                scale = this.getScale(ViewLevel.KINGDOM) * MapLabel.getConversionFactor(ViewLevel.KINGDOM, vl, continentfactor, kingdomfactor, provincefactor);
                scalediff = scale - scaleorig;
                scale = scaleorig + scalediff * this.adjustScaleFactor / 100.0;
            }
            if (this.getScale(ViewLevel.PROVINCE) != null) {
                scaleorig = this.getScale(ViewLevel.PROVINCE);
                scale = this.getScale(ViewLevel.PROVINCE) * MapLabel.getConversionFactor(ViewLevel.PROVINCE, vl, continentfactor, kingdomfactor, provincefactor);
                scalediff = scale - scaleorig;
                scale = scaleorig + scalediff * this.adjustScaleFactor / 100.0;
            }
        }
        return scale;
    }

    public Text getTextObjectQuick(MapData md, ViewLevel vl, double x, double y, double hexh, double continentfactor, double kingdomfactor, double provincefactor, boolean isRotate) {
        if (md.getLabelStyles() != null && md.getLabelStyles().containsKey(this.style)) {
            LabelStyle ls = md.getLabelStyles().get(this.style);
            FontWeight fw = ls.isBold() ? FontWeight.BOLD : FontWeight.NORMAL;
            FontPosture fp = ls.isItalic() ? FontPosture.ITALIC : FontPosture.REGULAR;
            double scale = this.getAdjustedScale(vl, continentfactor, kingdomfactor, provincefactor, ls.getScale());
            Text t = new Text(this.text);
            t.setTextAlignment(this.textAlignment);
            t.setX(x);
            t.setY(y);
            t.setFont(Font.font((String)ls.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)(hexh * scale / 100.0)));
            if (isRotate) {
                t.setRotate(this.rotate);
            }
            return t;
        }
        FontWeight fw = this.isBold ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture fp = this.isItalic ? FontPosture.ITALIC : FontPosture.REGULAR;
        Double scale = this.getScale(vl);
        if ((scale = this.getAdjustedScale(vl, continentfactor, kingdomfactor, provincefactor, scale)) != null) {
            Text t = new Text(this.text);
            t.setTextAlignment(this.textAlignment);
            t.setX(x);
            t.setY(y);
            t.setFont(Font.font((String)this.getFontFace(), (FontWeight)fw, (FontPosture)fp, (double)(hexh * scale / 100.0)));
            if (isRotate) {
                t.setRotate(this.rotate);
            }
            return t;
        }
        return null;
    }

    public boolean isInsideLabelBoundingBox(MapData md, double hexw, double hexh, double continentfactor, double kingdomfactor, double provincefactor, double offsetscrollx, double offsetscrolly, ViewLevel vl, Point2D pointofinterest) {
        List<Point2D> pointList = this.getRotatedBoundingBoxPoints(md, hexw, hexh, continentfactor, kingdomfactor, provincefactor, offsetscrollx, offsetscrolly, vl);
        Polygon poly = new Polygon(new double[]{pointList.get(0).getX(), pointList.get(0).getY(), pointList.get(1).getX(), pointList.get(1).getY(), pointList.get(2).getX(), pointList.get(2).getY(), pointList.get(3).getX(), pointList.get(3).getY()});
        return poly.contains(pointofinterest);
    }

    public List<Point2D> getRotatedBoundingBoxPoints(MapData md, double hexw, double hexh, double continentfactor, double kingdomfactor, double provincefactor, double offsetscrollx, double offsetscrolly, ViewLevel vl) {
        if (this.location.get((Object)vl) == null) {
            return null;
        }
        Point2D modelpt = (Point2D)this.location.get((Object)vl).getKey();
        Point2D pt = new Point2D(modelpt.getX() * hexw / 300.0 - offsetscrollx, modelpt.getY() * hexh / 300.0 - offsetscrolly);
        return this.getRotatedBoundingBoxPoints(md, pt.getX(), pt.getY(), hexw, hexh, continentfactor, kingdomfactor, provincefactor, offsetscrollx, offsetscrolly, vl);
    }

    public List<Point2D> getRotatedBoundingBoxPoints(MapData md, double screenX, double screenY, double hexw, double hexh, double continentfactor, double kingdomfactor, double provincefactor, double offsetscrollx, double offsetscrolly, ViewLevel vl) {
        Text text = this.getTextObjectQuick(md, vl, screenX, screenY, hexh, continentfactor, kingdomfactor, provincefactor, false);
        Bounds boundsX = text.getLayoutBounds();
        BoundingBox bounds = new BoundingBox(boundsX.getMinX() - boundsX.getHeight() * 0.2, boundsX.getMinY() + boundsX.getHeight() * 0.1, boundsX.getWidth() + boundsX.getHeight() * 0.4, boundsX.getHeight());
        ArrayList<Point2D> pointlist = new ArrayList<Point2D>();
        double recenterForAlign = 0.0;
        if (this.textAlignment == TextAlignment.CENTER) {
            recenterForAlign = boundsX.getWidth() / 2.0;
        } else if (this.textAlignment == TextAlignment.RIGHT) {
            recenterForAlign = boundsX.getWidth();
        }
        if (this.rotate != 0.0) {
            Rotate r = new Rotate(this.rotate, screenX, screenY);
            Point2D upperleft = r.transform(new Point2D(bounds.getMinX() - recenterForAlign, bounds.getMinY()));
            Point2D upperright = r.transform(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getMinY()));
            Point2D lowerright = r.transform(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getMaxY()));
            Point2D lowerleft = r.transform(new Point2D(bounds.getMinX() - recenterForAlign, bounds.getMaxY()));
            Point2D rotate = r.transform(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getCenterY()));
            pointlist.add(upperleft);
            pointlist.add(upperright);
            pointlist.add(lowerright);
            pointlist.add(lowerleft);
            pointlist.add(rotate);
            return pointlist;
        }
        pointlist.add(new Point2D(bounds.getMinX() - recenterForAlign, bounds.getMinY()));
        pointlist.add(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getMinY()));
        pointlist.add(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getMaxY()));
        pointlist.add(new Point2D(bounds.getMinX() - recenterForAlign, bounds.getMaxY()));
        pointlist.add(new Point2D(bounds.getMaxX() - recenterForAlign, bounds.getCenterY()));
        return pointlist;
    }

    public String getXMLString() {
        String layerName = "";
        if (this.getMapLayer() != null) {
            layerName = this.getMapLayer().getName();
        }
        StringBuilder sb = new StringBuilder("<label ");
        sb.append(" mapLayer=\"").append(MapDataIO.toEscapedXML(layerName)).append("\"");
        sb.append(" style=\"").append(MapDataIO.toEscapedXML(this.getStyle())).append("\" fontFace=\"").append(MapDataIO.toEscapedXML(this.getFontFace())).append("\"");
        if (this.getColor() != null) {
            sb.append(" color=\"").append(this.getColor().getRed()).append(",").append(this.getColor().getGreen()).append(",").append(this.getColor().getBlue()).append(",").append(this.getColor().getOpacity()).append("\"");
        } else {
            sb.append(" color=\"null\"");
        }
        if (this.getBackgroundColor() != null) {
            sb.append(" backgroundColor=\"").append(this.getBackgroundColor().getRed()).append(",").append(this.getBackgroundColor().getGreen()).append(",").append(this.getBackgroundColor().getBlue()).append(",").append(this.getBackgroundColor().getOpacity()).append("\"");
        }
        if (this.getOutlineColor() != null) {
            sb.append(" outlineColor=\"").append(this.getOutlineColor().getRed()).append(",").append(this.getOutlineColor().getGreen()).append(",").append(this.getOutlineColor().getBlue()).append(",").append(this.getOutlineColor().getOpacity()).append("\"");
        } else {
            sb.append(" outlineColor=\"null\"");
        }
        sb.append(" outlineSize=\"").append(this.getOutlineSize()).append("\"");
        sb.append(" rotate=\"").append(this.getRotate()).append("\" isBold=\"").append(this.isBold()).append("\" isItalic=\"").append(this.isItalic()).append("\"");
        sb.append(" isWorld=\"").append(this.isWorld()).append("\" isContinent=\"").append(this.isContinent()).append("\" isKingdom=\"").append(this.isKingdom()).append("\" isProvince=\"").append(this.isProvince()).append("\"");
        sb.append(" isGMOnly=\"").append(this.isGmOnly()).append("\" tags=\"").append(MapDataIO.toEscapedXML(this.getTags())).append("\">");
        this.appendLocationXML(sb, ViewLevel.COSMIC);
        this.appendLocationXML(sb, ViewLevel.WORLD);
        this.appendLocationXML(sb, ViewLevel.CONTINENT);
        this.appendLocationXML(sb, ViewLevel.KINGDOM);
        this.appendLocationXML(sb, ViewLevel.PROVINCE);
        this.appendLocationXML(sb, ViewLevel.SETTLEMENT);
        this.appendLocationXML(sb, ViewLevel.BATTLEMAT);
        sb.append(MapDataIO.toEscapedXML(this.getText())).append("</label>\n");
        return sb.toString();
    }

    private void appendLocationXML(StringBuilder sb, ViewLevel vl) {
        if (this.getLocation(vl) != null) {
            Point2D loc = this.getLocation(vl);
            sb.append("<location viewLevel=\"").append(vl.name()).append("\" x=\"").append(loc.getX()).append("\" y=\"").append(loc.getY()).append("\" scale=\"").append(this.getScale(vl)).append("\" />");
        }
    }
}

