/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.Undoable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;

public class MapShape
extends MapObject
implements Undoable {
    private Shape shape;
    private ViewLevel highestViewLevel;
    private ViewLevel currentShapeViewLevel;
    private boolean snapVertices;
    private boolean matchTileBorders;
    private String tags;
    private boolean dropShadow = false;
    private boolean innerShadow = false;
    private boolean boxBlur = false;
    private double dsSpread;
    private double dsRadius;
    private double dsOffsetX;
    private double dsOffsetY;
    private double insChoke;
    private double insRadius;
    private double insOffsetX;
    private double insOffsetY;
    private double bbWidth;
    private double bbHeight;
    private int bbIterations;
    private Color dsColor;
    private Color insColor;
    private MapLayer mapLayer;
    private TextureType fillTexture;
    private TextureType strokeTexture;
    private StrokeType strokeType;
    private CreationType creationType;
    private boolean isWorld;
    private boolean isContinent;
    private boolean isKingdom;
    private boolean isProvince;
    private boolean isGradientEdge;
    private double extraLineLength;
    private double extraLineWidth;
    private double extraLineDistance;
    private double extraLineSeparation;

    public MapShape(ViewLevel hvl, ViewLevel cvl, Shape s, CreationType creationtype, StrokeType st, boolean gmOnly, String tags, double extraLineDistance, double extraLineLength, double extraLineWidth, double extraLineSeparation, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, MapLayer maplayer) {
        this.shape = s;
        this.highestViewLevel = hvl;
        this.currentShapeViewLevel = cvl;
        this.creationType = creationtype;
        this.strokeType = st;
        this.gmOnly = gmOnly;
        this.tags = tags;
        this.extraLineDistance = extraLineDistance;
        this.extraLineLength = extraLineLength;
        this.extraLineWidth = extraLineWidth;
        this.extraLineSeparation = extraLineSeparation;
        this.isWorld = isWorld;
        this.isContinent = isContinent;
        this.isKingdom = isKingdom;
        this.isProvince = isProvince;
        this.mapLayer = maplayer;
    }

    @Override
    public MapShape clone() {
        MapShape ms = new MapShape(this.highestViewLevel, this.currentShapeViewLevel, this.shape, this.creationType, this.strokeType, this.gmOnly, this.tags, this.extraLineLength, this.extraLineWidth, this.extraLineDistance, this.extraLineSeparation, this.isWorld, this.isContinent, this.isKingdom, this.isProvince, this.mapLayer);
        ms.makeIdenticalTo(this);
        return ms;
    }

    @Override
    public void makeIdenticalTo(Undoable u) {
        if (u instanceof MapShape) {
            MapShape ms = (MapShape)u;
            Paint stroke = ms.getShape().getStroke();
            double strokeWidth = ms.getShape().getStrokeWidth();
            StrokeLineCap slc = ms.getShape().getStrokeLineCap();
            StrokeLineJoin slj = ms.getShape().getStrokeLineJoin();
            Paint fill = ms.getShape().getFill();
            double opacity = ms.getShape().getOpacity();
            this.highestViewLevel = ms.highestViewLevel;
            this.currentShapeViewLevel = ms.currentShapeViewLevel;
            this.gmOnly = ms.gmOnly;
            this.snapVertices = ms.snapVertices;
            this.matchTileBorders = ms.matchTileBorders;
            this.tags = ms.tags;
            this.extraLineDistance = ms.extraLineDistance;
            this.extraLineLength = ms.extraLineLength;
            this.extraLineWidth = ms.extraLineWidth;
            this.extraLineSeparation = ms.extraLineSeparation;
            this.dropShadow = ms.dropShadow;
            this.dsSpread = ms.dsSpread;
            this.dsRadius = ms.dsRadius;
            this.dsOffsetX = ms.dsOffsetX;
            this.dsOffsetY = ms.dsOffsetY;
            this.dsColor = ms.dsColor;
            this.innerShadow = ms.innerShadow;
            this.insRadius = ms.insRadius;
            this.insChoke = ms.insChoke;
            this.insOffsetX = ms.insOffsetX;
            this.insOffsetY = ms.insOffsetY;
            this.boxBlur = ms.boxBlur;
            this.bbWidth = ms.bbWidth;
            this.bbHeight = ms.bbHeight;
            this.bbIterations = ms.bbIterations;
            this.insColor = ms.insColor;
            this.mapLayer = ms.mapLayer;
            this.fillTexture = ms.fillTexture;
            this.strokeTexture = ms.strokeTexture;
            this.strokeType = ms.strokeType;
            this.isWorld = ms.isWorld;
            this.isContinent = ms.isContinent;
            this.isKingdom = ms.isKingdom;
            this.isProvince = ms.isProvince;
            this.isGradientEdge = ms.isGradientEdge;
            if (ms.getShape() instanceof Polygon) {
                Polygon p = new Polygon();
                p.getPoints().addAll((Collection)((Polygon)ms.getShape()).getPoints());
                this.setShape((Shape)p);
            } else {
                Shape p = ms.getShape();
                if (p instanceof Path) {
                    Path p2 = (Path)p;
                    p2 = new Path();
                    for (int i = 0; i < p2.getElements().size(); ++i) {
                        ClosePath lt2;
                        PathElement pe = (PathElement)p2.getElements().get(i);
                        if (pe instanceof MoveTo) {
                            MoveTo mt = (MoveTo)pe;
                            MoveTo mt2 = new MoveTo(mt.getX(), mt.getY());
                            p2.getElements().add((Object)mt2);
                            continue;
                        }
                        if (pe instanceof LineTo) {
                            LineTo lt = (LineTo)pe;
                            lt2 = new LineTo(lt.getX(), lt.getY());
                            p2.getElements().add((Object)lt2);
                            continue;
                        }
                        if (pe instanceof CubicCurveTo) {
                            CubicCurveTo ct = (CubicCurveTo)pe;
                            CubicCurveTo ct2 = new CubicCurveTo(ct.getControlX1(), ct.getControlY1(), ct.getControlX2(), ct.getControlY2(), ct.getX(), ct.getY());
                            p2.getElements().add((Object)ct2);
                            continue;
                        }
                        if (!(pe instanceof ClosePath)) continue;
                        lt2 = new ClosePath();
                        p2.getElements().add((Object)lt2);
                    }
                    this.setShape(p2);
                } else {
                    p2 = ms.getShape();
                    if (p2 instanceof Arc) {
                        Arc a = (Arc)p2;
                        Arc a2 = new Arc();
                        a2.setCenterX(a.getCenterX());
                        a2.setCenterY(a.getCenterY());
                        a2.setRadiusX(a.getRadiusX());
                        a2.setRadiusY(a.getRadiusY());
                        a2.setStartAngle(a.getStartAngle());
                        a2.setType(a.getType());
                        a2.setLength(a.getLength());
                        this.setShape((Shape)a2);
                    }
                }
            }
            this.getShape().setStroke(stroke);
            this.getShape().setStrokeWidth(strokeWidth);
            this.getShape().setStrokeLineCap(slc);
            this.getShape().setStrokeLineJoin(slj);
            this.getShape().setFill(fill);
            this.getShape().setOpacity(opacity);
        }
    }

    public boolean isWorld() {
        return this.isWorld;
    }

    public void setWorld(boolean isWorld) {
        this.isWorld = isWorld;
    }

    public boolean isContinent() {
        return this.isContinent;
    }

    public void setContinent(boolean isContinent) {
        this.isContinent = isContinent;
    }

    public boolean isKingdom() {
        return this.isKingdom;
    }

    public void setKingdom(boolean isKingdom) {
        this.isKingdom = isKingdom;
    }

    public boolean isProvince() {
        return this.isProvince;
    }

    public void setProvince(boolean isProvince) {
        this.isProvince = isProvince;
    }

    public boolean isGradientEdge() {
        return this.isGradientEdge;
    }

    public void setGradientEdge(boolean isGradientEdge) {
        this.isGradientEdge = isGradientEdge;
    }

    public double getExtraLineLength() {
        return this.extraLineLength;
    }

    public void setExtraLineLength(double extraLineLength) {
        this.extraLineLength = extraLineLength;
    }

    public double getExtraLineWidth() {
        return this.extraLineWidth;
    }

    public void setExtraLineWidth(double extraLineWidth) {
        this.extraLineWidth = extraLineWidth;
    }

    public double getExtraLineDistance() {
        return this.extraLineDistance;
    }

    public void setExtraLineDistance(double extraLineDistance) {
        this.extraLineDistance = extraLineDistance;
    }

    public double getExtraLineSeparation() {
        return this.extraLineSeparation;
    }

    public void setExtraLineSeparation(double extraLineSeparation) {
        this.extraLineSeparation = extraLineSeparation;
    }

    public CreationType getCreationType() {
        return this.creationType;
    }

    public void setCreationType(CreationType creationType) {
        this.creationType = creationType;
    }

    public StrokeType getStrokeType() {
        return this.strokeType;
    }

    public void setStrokeType(StrokeType strokeType) {
        this.strokeType = strokeType;
    }

    public boolean isSnapVertices() {
        return this.snapVertices;
    }

    public void setSnapVertices(boolean snapVertices) {
        this.snapVertices = snapVertices;
    }

    public boolean isMatchTileBorders() {
        return this.matchTileBorders;
    }

    public void setMatchTileBorders(boolean matchTile) {
        this.matchTileBorders = matchTile;
    }

    public TextureType getFillTexture() {
        return this.fillTexture;
    }

    public void setFillTexture(TextureType fillTexture) {
        this.fillTexture = fillTexture;
    }

    public TextureType getStrokeTexture() {
        return this.strokeTexture;
    }

    public void setStrokeTexture(TextureType strokeTexture) {
        this.strokeTexture = strokeTexture;
    }

    public MapLayer getMapLayer() {
        return this.mapLayer;
    }

    public void setMapLayer(MapLayer mapLayer) {
        this.mapLayer = mapLayer;
    }

    public boolean isBoxBlur() {
        return this.boxBlur;
    }

    public void setBoxBlur(boolean boxBlur) {
        this.boxBlur = boxBlur;
    }

    public double getBbWidth() {
        return this.bbWidth;
    }

    public void setBbWidth(double bbWidth) {
        this.bbWidth = bbWidth;
    }

    public double getBbHeight() {
        return this.bbHeight;
    }

    public void setBbHeight(double bbHeight) {
        this.bbHeight = bbHeight;
    }

    public int getBbIterations() {
        return this.bbIterations;
    }

    public void setBbIterations(int bbIterations) {
        this.bbIterations = bbIterations;
    }

    public boolean isInnerShadow() {
        return this.innerShadow;
    }

    public void setInnerShadow(boolean innerShadow) {
        this.innerShadow = innerShadow;
    }

    public double getInsChoke() {
        return this.insChoke;
    }

    public void setInsChoke(double insChoke) {
        this.insChoke = insChoke;
    }

    public double getInsRadius() {
        return this.insRadius;
    }

    public void setInsRadius(double insRadius) {
        this.insRadius = insRadius;
    }

    public double getInsOffsetX() {
        return this.insOffsetX;
    }

    public void setInsOffsetX(double insOffsetX) {
        this.insOffsetX = insOffsetX;
    }

    public double getInsOffsetY() {
        return this.insOffsetY;
    }

    public void setInsOffsetY(double insOffsetY) {
        this.insOffsetY = insOffsetY;
    }

    public Color getInsColor() {
        return this.insColor;
    }

    public void setInsColor(Color insColor) {
        this.insColor = insColor;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public ViewLevel getCurrentShapeViewLevel() {
        return this.currentShapeViewLevel;
    }

    public void setCurrentShapeViewLevel(ViewLevel currentShapeViewLevel) {
        this.currentShapeViewLevel = currentShapeViewLevel;
    }

    public boolean isDropShadow() {
        return this.dropShadow;
    }

    public void setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
    }

    public double getDsSpread() {
        return this.dsSpread;
    }

    public void setDsSpread(double dsSpread) {
        this.dsSpread = dsSpread;
    }

    public double getDsRadius() {
        return this.dsRadius;
    }

    public void setDsRadius(double dsRadius) {
        this.dsRadius = dsRadius;
    }

    public double getDsOffsetX() {
        return this.dsOffsetX;
    }

    public void setDsOffsetX(double dsOffsetX) {
        this.dsOffsetX = dsOffsetX;
    }

    public double getDsOffsetY() {
        return this.dsOffsetY;
    }

    public void setDsOffsetY(double dsOffsetY) {
        this.dsOffsetY = dsOffsetY;
    }

    public Color getDsColor() {
        return this.dsColor;
    }

    public void setDsColor(Color dsColor) {
        this.dsColor = dsColor;
    }

    public void fractalize(UndoActionGroup uag, Point2D pt2, int sublength, int maxchange) {
        Shape shape = this.shape;
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            if (p.getPoints().size() == 0) {
                p.getPoints().add((Object)pt2.getX());
                p.getPoints().add((Object)pt2.getY());
            } else {
                priorPt = new Point2D(((Double)p.getPoints().get(p.getPoints().size() - 2)).doubleValue(), ((Double)p.getPoints().get(p.getPoints().size() - 1)).doubleValue());
                double distance = priorPt.distance(pt2);
                if (distance < (double)sublength) {
                    p.getPoints().add((Object)pt2.getX());
                    p.getPoints().add((Object)pt2.getY());
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, this, new Point2D(pt2.getX(), pt2.getY()), null, null, null, null));
                } else {
                    int dx = (int)(Math.random() * distance * 2.0 / (double)maxchange - distance / (double)maxchange);
                    int dy = (int)(Math.random() * distance * 2.0 / (double)maxchange - distance / (double)maxchange);
                    Point2D midpoint = new Point2D((priorPt.getX() + pt2.getX()) / 2.0 + (double)dx, (priorPt.getY() + pt2.getY()) / 2.0 + (double)dy);
                    this.fractalize(uag, midpoint, sublength, maxchange);
                    this.fractalize(uag, pt2, sublength, maxchange);
                }
            }
        } else {
            priorPt = this.shape;
            if (priorPt instanceof Path) {
                Path p = (Path)priorPt;
                PathElement priorpe = (PathElement)p.getElements().get(p.getElements().size() - 1);
                Point2D priorpt = priorpe instanceof LineTo ? new Point2D(((LineTo)priorpe).getX(), ((LineTo)priorpe).getY()) : new Point2D(((MoveTo)priorpe).getX(), ((MoveTo)priorpe).getY());
                double distance = priorpt.distance(pt2);
                if (distance < (double)sublength) {
                    LineTo lineTo = new LineTo();
                    lineTo.setX(pt2.getX());
                    lineTo.setY(pt2.getY());
                    p.getElements().add((Object)lineTo);
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, this, lineTo, null, p.getElements().indexOf((Object)lineTo), null, null));
                } else {
                    int dx = (int)(Math.random() * distance * 2.0 / (double)maxchange - distance / (double)maxchange);
                    int dy = (int)(Math.random() * distance * 2.0 / (double)maxchange - distance / (double)maxchange);
                    Point2D midpoint = new Point2D((priorpt.getX() + pt2.getX()) / 2.0 + (double)dx, (priorpt.getY() + pt2.getY()) / 2.0 + (double)dy);
                    this.fractalize(uag, midpoint, sublength, maxchange);
                    this.fractalize(uag, pt2, sublength, maxchange);
                }
            }
        }
    }

    public Shape getShape(MapData mapdata, ViewLevel newvl) {
        if (newvl == this.currentShapeViewLevel && this.shape != null) {
            return this.shape;
        }
        this.convertShape(mapdata, newvl);
        return this.shape;
    }

    public void convertShape(MapData mapdata, ViewLevel newvl) {
        double factor = MapShape.getConversionFactor(newvl, this.currentShapeViewLevel, mapdata.getView().getContinentFactor(), mapdata.getView().getKingdomFactor(), mapdata.getView().getProvinceFactor());
        Shape shape = this.shape;
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                double x = (Double)p.getPoints().get(i);
                double y = (Double)p.getPoints().get(i + 1);
                Point2D convertedpt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, x, y);
                p.getPoints().set(i, (Object)convertedpt.getX());
                p.getPoints().set(i + 1, (Object)convertedpt.getY());
            }
        } else {
            Shape i = this.shape;
            if (i instanceof Path) {
                Path p = (Path)i;
                for (int i2 = 0; i2 < p.getElements().size(); ++i2) {
                    Point2D convertedpt;
                    PathElement pe = (PathElement)p.getElements().get(i2);
                    if (pe instanceof MoveTo) {
                        MoveTo mt = (MoveTo)pe;
                        convertedpt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, mt.getX(), mt.getY());
                        mt.setX(convertedpt.getX());
                        mt.setY(convertedpt.getY());
                        continue;
                    }
                    if (pe instanceof LineTo) {
                        LineTo lt = (LineTo)pe;
                        convertedpt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, lt.getX(), lt.getY());
                        lt.setX(convertedpt.getX());
                        lt.setY(convertedpt.getY());
                        continue;
                    }
                    if (!(pe instanceof CubicCurveTo)) continue;
                    CubicCurveTo ct = (CubicCurveTo)pe;
                    convertedpt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, ct.getX(), ct.getY());
                    ct.setX(convertedpt.getX());
                    ct.setY(convertedpt.getY());
                    Point2D convertedc1pt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, ct.getControlX1(), ct.getControlY1());
                    ct.setControlX1(convertedc1pt.getX());
                    ct.setControlY1(convertedc1pt.getY());
                    Point2D convertedc2pt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, ct.getControlX2(), ct.getControlY2());
                    ct.setControlX2(convertedc2pt.getX());
                    ct.setControlY2(convertedc2pt.getY());
                }
            } else {
                i = this.shape;
                if (i instanceof Arc) {
                    Arc a = (Arc)i;
                    Point2D convertedpt = mapdata.calculateCoordinateAtNewLevel(this.currentShapeViewLevel, newvl, a.getCenterX(), a.getCenterY());
                    a.setCenterX(convertedpt.getX());
                    a.setCenterY(convertedpt.getY());
                    a.setRadiusX(a.getRadiusX() * factor);
                    a.setRadiusY(a.getRadiusY() * factor);
                }
            }
        }
        this.currentShapeViewLevel = newvl;
    }

    public void move(double diffx, double diffy) {
        Shape shape = this.shape;
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                double x = (Double)p.getPoints().get(i);
                double y = (Double)p.getPoints().get(i + 1);
                p.getPoints().set(i, (Object)(x + diffx));
                p.getPoints().set(i + 1, (Object)(y + diffy));
            }
        } else {
            Shape i = this.shape;
            if (i instanceof Path) {
                Path p = (Path)i;
                for (int i2 = 0; i2 < p.getElements().size(); ++i2) {
                    PathElement pe = (PathElement)p.getElements().get(i2);
                    if (pe instanceof MoveTo) {
                        MoveTo mt = (MoveTo)pe;
                        mt.setX(mt.getX() + diffx);
                        mt.setY(mt.getY() + diffy);
                        continue;
                    }
                    if (pe instanceof LineTo) {
                        LineTo lt = (LineTo)pe;
                        lt.setX(lt.getX() + diffx);
                        lt.setY(lt.getY() + diffy);
                        continue;
                    }
                    if (!(pe instanceof CubicCurveTo)) continue;
                    CubicCurveTo ct = (CubicCurveTo)pe;
                    ct.setX(ct.getX() + diffx);
                    ct.setY(ct.getY() + diffy);
                    ct.setControlX1(ct.getControlX1() + diffx);
                    ct.setControlY1(ct.getControlY1() + diffy);
                    ct.setControlX2(ct.getControlX2() + diffx);
                    ct.setControlY2(ct.getControlY2() + diffy);
                }
            } else {
                shape = this.shape;
                if (shape instanceof Arc) {
                    Arc a = (Arc)shape;
                    a.setCenterX(a.getCenterX() + diffx);
                    a.setCenterY(a.getCenterY() + diffy);
                }
            }
        }
    }

    public void removePoint(Point2D pt) {
        Shape shape = this.shape;
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            int removeindex = -1;
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                if (pt.getX() != ((Double)p.getPoints().get(i)).doubleValue() || pt.getY() != ((Double)p.getPoints().get(i + 1)).doubleValue()) continue;
                removeindex = i;
                break;
            }
            if (removeindex >= 0) {
                p.getPoints().remove(removeindex);
            }
            if (removeindex >= 0) {
                p.getPoints().remove(removeindex);
            }
        } else {
            Shape removeindex = this.shape;
            if (removeindex instanceof Path) {
                Path p = (Path)removeindex;
                PathElement toremove = null;
                for (int i = 0; i < p.getElements().size(); ++i) {
                    CubicCurveTo ct;
                    PathElement pe = (PathElement)p.getElements().get(i);
                    if (pe instanceof MoveTo) {
                        MoveTo mt = (MoveTo)pe;
                        if (mt.getX() != pt.getX() || mt.getY() != pt.getY()) continue;
                        toremove = pe;
                        if (i + 1 >= p.getElements().size()) break;
                        LineTo next = (LineTo)p.getElements().get(i + 1);
                        mt.setX(next.getX());
                        mt.setY(next.getY());
                        toremove = next;
                        break;
                    }
                    if (pe instanceof LineTo) {
                        LineTo lt = (LineTo)pe;
                        if (lt.getX() != pt.getX() || lt.getY() != pt.getY()) continue;
                        toremove = pe;
                        break;
                    }
                    if (!(pe instanceof CubicCurveTo) || !((ct = (CubicCurveTo)pe).getX() == pt.getX() && ct.getY() == pt.getY() || ct.getControlX1() == pt.getX() && ct.getControlY1() == pt.getY()) && (ct.getControlX2() != pt.getX() || ct.getControlY2() != pt.getY())) continue;
                    toremove = pe;
                    break;
                }
                if (toremove != null) {
                    p.getElements().remove(toremove);
                }
            }
        }
    }

    public static void printShapePointsImproved(Shape shape) {
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            System.out.print("print shape Polygon:");
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                try {
                    System.out.print(String.valueOf(p.getPoints().get(i)) + "," + String.valueOf(p.getPoints().get(i + 1)));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return;
        }
        if (shape instanceof Arc) {
            Arc a = (Arc)shape;
            System.out.println("print shape Arc center:" + a.getCenterX() + "," + a.getCenterY() + " radius:" + a.getRadiusX() + "," + a.getRadiusY());
        } else if (shape instanceof Path) {
            Path p = (Path)shape;
            for (int i = 0; i < p.getElements().size(); ++i) {
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    System.out.print(" moveto:" + mt.getX() + "," + mt.getY());
                    continue;
                }
                if (pe instanceof LineTo) {
                    LineTo lt = (LineTo)pe;
                    System.out.print(" lineto:" + lt.getX() + "," + lt.getY());
                    continue;
                }
                if (pe instanceof CubicCurveTo) {
                    CubicCurveTo ct = (CubicCurveTo)pe;
                    System.out.print(" cubiccurveto:" + ct.getX() + "," + ct.getY() + " control1:" + ct.getControlX1() + "," + ct.getControlY1() + " control2:" + ct.getControlX2() + "," + ct.getControlY2());
                    continue;
                }
                if (pe instanceof ClosePath) {
                    System.out.print(" close");
                    continue;
                }
                System.out.println(" unknown type: " + String.valueOf(pe));
            }
            System.out.println();
        }
        System.out.println("print shape none");
    }

    public static List<List<Point2D>> getShapePointsImproved(Shape shape) {
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            ArrayList<Point2D> pts = new ArrayList<Point2D>();
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                try {
                    pts.add(new Point2D(((Double)p.getPoints().get(i)).doubleValue(), ((Double)p.getPoints().get(i + 1)).doubleValue()));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            ArrayList<List<Point2D>> list = new ArrayList<List<Point2D>>();
            list.add(pts);
            return list;
        }
        if (shape instanceof Arc) {
            Arc a = (Arc)shape;
            ArrayList<Point2D> pts = new ArrayList<Point2D>();
            pts.add(new Point2D(a.getCenterX(), a.getCenterY()));
            pts.add(new Point2D(a.getCenterX() + a.getRadiusX(), a.getCenterY() + a.getRadiusY()));
            ArrayList<List<Point2D>> list = new ArrayList<List<Point2D>>();
            list.add(pts);
            return list;
        }
        if (shape instanceof Path) {
            Path p = (Path)shape;
            ArrayList<List<Point2D>> list = new ArrayList<List<Point2D>>();
            ArrayList<Point2D> pts = null;
            for (int i = 0; i < p.getElements().size(); ++i) {
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    if (pts != null) {
                        list.add(pts);
                    }
                    pts = new ArrayList<Point2D>();
                    pts.add(new Point2D(mt.getX(), mt.getY()));
                    continue;
                }
                if (pe instanceof LineTo) {
                    LineTo lt = (LineTo)pe;
                    if (pts == null) {
                        pts = new ArrayList();
                    }
                    pts.add(new Point2D(lt.getX(), lt.getY()));
                    continue;
                }
                if (!(pe instanceof CubicCurveTo)) continue;
                CubicCurveTo ct = (CubicCurveTo)pe;
                if (pts == null) {
                    pts = new ArrayList();
                }
                pts.add(new Point2D(ct.getX(), ct.getY()));
                pts.add(new Point2D(ct.getControlX1(), ct.getControlY1()));
                pts.add(new Point2D(ct.getControlX2(), ct.getControlY2()));
            }
            if (pts != null) {
                list.add(pts);
            }
            return list;
        }
        return null;
    }

    public static List<Point2D> getShapePoints(Shape shape) {
        ArrayList<Point2D> pts;
        block7: {
            block8: {
                block6: {
                    pts = new ArrayList<Point2D>();
                    if (!(shape instanceof Polygon)) break block6;
                    Polygon p = (Polygon)shape;
                    for (int i = 0; i < p.getPoints().size() - 1; i += 2) {
                        try {
                            if (((Double)p.getPoints().get(i)).equals(Double.NaN) || ((Double)p.getPoints().get(i + 1)).equals(Double.NaN)) continue;
                            pts.add(new Point2D(((Double)p.getPoints().get(i)).doubleValue(), ((Double)p.getPoints().get(i + 1)).doubleValue()));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                    break block7;
                }
                if (!(shape instanceof Arc)) break block8;
                Arc a = (Arc)shape;
                pts.add(new Point2D(a.getCenterX(), a.getCenterY()));
                pts.add(new Point2D(a.getCenterX() + a.getRadiusX(), a.getCenterY() + a.getRadiusY()));
                break block7;
            }
            if (!(shape instanceof Path)) break block7;
            Path p = (Path)shape;
            for (int i = 0; i < p.getElements().size(); ++i) {
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    pts.add(new Point2D(mt.getX(), mt.getY()));
                    continue;
                }
                if (pe instanceof LineTo) {
                    LineTo lt = (LineTo)pe;
                    pts.add(new Point2D(lt.getX(), lt.getY()));
                    continue;
                }
                if (!(pe instanceof CubicCurveTo)) continue;
                CubicCurveTo ct = (CubicCurveTo)pe;
                pts.add(new Point2D(ct.getX(), ct.getY()));
                pts.add(new Point2D(ct.getControlX1(), ct.getControlY1()));
                pts.add(new Point2D(ct.getControlX2(), ct.getControlY2()));
            }
        }
        return pts;
    }

    public List<Point2D> getShapePoints() {
        return MapShape.getShapePoints(this.shape);
    }

    public void updatePoint(Point2D oldpt, Point2D newpt) {
        Shape shape = this.shape;
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                if (!((Double)p.getPoints().get(i)).equals(oldpt.getX()) || !((Double)p.getPoints().get(i + 1)).equals(oldpt.getY())) continue;
                p.getPoints().set(i, (Object)newpt.getX());
                p.getPoints().set(i + 1, (Object)newpt.getY());
                return;
            }
        } else {
            Shape i = this.shape;
            if (i instanceof Path) {
                Path p = (Path)i;
                for (int i2 = 0; i2 < p.getElements().size(); ++i2) {
                    PathElement pe = (PathElement)p.getElements().get(i2);
                    if (pe instanceof MoveTo) {
                        MoveTo mt = (MoveTo)pe;
                        if (mt.getX() != oldpt.getX() || mt.getY() != oldpt.getY()) continue;
                        mt.setX(newpt.getX());
                        mt.setY(newpt.getY());
                        return;
                    }
                    if (pe instanceof LineTo) {
                        LineTo lt = (LineTo)pe;
                        if (lt.getX() != oldpt.getX() || lt.getY() != oldpt.getY()) continue;
                        lt.setX(newpt.getX());
                        lt.setY(newpt.getY());
                        return;
                    }
                    if (!(pe instanceof CubicCurveTo)) continue;
                    CubicCurveTo ct = (CubicCurveTo)pe;
                    if (ct.getX() == oldpt.getX() && ct.getY() == oldpt.getY()) {
                        ct.setX(newpt.getX());
                        ct.setY(newpt.getY());
                        return;
                    }
                    if (ct.getControlX1() == oldpt.getX() && ct.getControlY1() == oldpt.getY()) {
                        ct.setControlX1(newpt.getX());
                        ct.setControlY1(newpt.getY());
                        return;
                    }
                    if (ct.getControlX2() != oldpt.getX() || ct.getControlY2() != oldpt.getY()) continue;
                    ct.setControlX2(newpt.getX());
                    ct.setControlY2(newpt.getY());
                    return;
                }
            } else {
                shape = this.shape;
                if (shape instanceof Arc) {
                    Arc a = (Arc)shape;
                    if (a.getCenterX() == oldpt.getX() && a.getCenterY() == oldpt.getY()) {
                        a.setCenterX(newpt.getX());
                        a.setCenterY(newpt.getY());
                    } else if (a.getCenterX() + a.getRadiusX() == oldpt.getX() && a.getCenterY() + a.getRadiusY() == oldpt.getY()) {
                        a.setRadiusX(Math.abs(a.getCenterX() - newpt.getX()));
                        a.setRadiusY(Math.abs(a.getCenterY() - newpt.getY()));
                    }
                }
            }
        }
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public boolean isCurve() {
        Path p;
        Shape shape = this.shape;
        if (shape instanceof Path && (p = (Path)shape).getElements().size() > 1) {
            return p.getElements().get(1) instanceof CubicCurveTo;
        }
        return false;
    }

    public String getXMLString() {
        Color c;
        Object object;
        if (this.shape == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<shape ");
        sb.append(" type=\"").append(this.shape.getClass().getSimpleName()).append("\" isCurve=\"").append(this.isCurve()).append("\" isGMOnly=\"").append(this.isGmOnly()).append("\" isSnapVertices=\"").append(this.isSnapVertices()).append("\" isMatchTileBorders=\"").append(this.isMatchTileBorders()).append("\" tags=\"").append(this.getTags()).append("\" creationType=\"").append((Object)this.creationType).append("\"");
        sb.append(" isDropShadow=\"").append(this.isDropShadow()).append("\" isInnerShadow=\"").append(this.isInnerShadow()).append("\" isBoxBlur=\"").append(this.isBoxBlur()).append("\"");
        sb.append(" extraLineDistance=\"").append(this.extraLineDistance).append("\" extraLineLength=\"").append(this.extraLineLength).append("\" extraLineWidth=\"" + this.extraLineWidth).append("\" extraLineSeparation=\"" + this.extraLineSeparation + "\"");
        sb.append(" isWorld=\"").append(this.isWorld()).append("\" isContinent=\"").append(this.isContinent()).append("\" isKingdom=\"").append(this.isKingdom()).append("\" isProvince=\"").append(this.isProvince()).append("\"");
        sb.append(" dsSpread=\"").append(this.dsSpread).append("\" dsRadius=\"").append(this.dsRadius).append("\" dsOffsetX=\"").append(this.dsOffsetX).append("\" dsOffsetY=\"").append(this.dsOffsetY).append("\"");
        sb.append(" insChoke=\"").append(this.insChoke).append("\" insRadius=\"").append(this.insRadius).append("\" insOffsetX=\"").append(this.insOffsetX).append("\" insOffsetY=\"").append(this.insOffsetY).append("\"");
        sb.append(" bbWidth=\"").append(this.bbWidth).append("\" bbHeight=\"").append(this.bbHeight).append("\" bbIterations=\"").append(this.bbIterations).append("\" mapLayer=\"").append(this.mapLayer == null ? "" : MapDataIO.toEscapedXML(this.mapLayer.getName())).append("\"");
        sb.append(" fillTexture=\"").append(this.fillTexture != null ? this.fillTexture.type : "").append("\" strokeTexture=\"").append(this.strokeTexture != null ? this.strokeTexture.type : "").append("\" strokeType=\"").append(this.strokeType != null ? this.strokeType.toString() : "").append("\"");
        sb.append(" highestViewLevel=\"").append((Object)this.highestViewLevel).append("\" currentShapeViewLevel=\"").append((Object)this.currentShapeViewLevel).append("\"");
        sb.append(" lineCap=\"").append(this.shape.getStrokeLineCap()).append("\"");
        sb.append(" lineJoin=\"").append(this.shape.getStrokeLineJoin()).append("\"");
        sb.append(" opacity=\"").append(this.shape.getOpacity()).append("\"");
        if (this.getShape() instanceof Path) {
            sb.append(" fillRule=\"").append(((Path)this.getShape()).getFillRule()).append("\"");
        }
        if ((object = this.shape.getFill()) instanceof Color) {
            c = (Color)object;
            sb.append(" fillColor=\"").append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue()).append(",").append(c.getOpacity()).append("\"");
        }
        if ((object = this.shape.getStroke()) instanceof Color) {
            c = (Color)object;
            sb.append(" strokeColor=\"").append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue()).append(",").append(c.getOpacity()).append("\"");
        }
        sb.append(" strokeWidth=\"").append(this.shape.getStrokeWidth()).append("\"");
        if (this.dsColor != null) {
            sb.append(" dsColor=\"").append(this.dsColor.getRed()).append(",").append(this.dsColor.getGreen()).append(",").append(this.dsColor.getBlue()).append(",").append(this.dsColor.getOpacity()).append("\"");
        } else {
            sb.append(" dsColor=\"null\"");
        }
        if (this.insColor != null) {
            sb.append(" insColor=\"").append(this.insColor.getRed()).append(",").append(this.insColor.getGreen()).append(",").append(this.insColor.getBlue()).append(",").append(this.insColor.getOpacity()).append("\"");
        } else {
            sb.append(" insColor=\"null\"");
        }
        object = this.shape;
        if (object instanceof Arc) {
            Arc a = (Arc)object;
            sb.append(" length=\"").append(a.getLength()).append("\" startAngle=\"").append(a.getStartAngle()).append("\" arcType=\"").append(a.getType()).append("\" ");
        }
        sb.append(">\n");
        object = this.getShape();
        if (object instanceof Path) {
            Path spath = (Path)object;
            for (PathElement pe : spath.getElements()) {
                if (pe instanceof LineTo) {
                    sb.append(" <p x=\"").append(((LineTo)pe).getX()).append("\" y = \"").append(((LineTo)pe).getY()).append("\"/>\n");
                    continue;
                }
                if (pe instanceof MoveTo) {
                    sb.append(" <p type=\"m\" x=\"").append(((MoveTo)pe).getX()).append("\" y = \"").append(((MoveTo)pe).getY()).append("\"/>\n");
                    continue;
                }
                if (pe instanceof CubicCurveTo) {
                    sb.append(" <p type=\"c\" x=\"").append(((CubicCurveTo)pe).getX()).append("\" y = \"").append(((CubicCurveTo)pe).getY()).append("\"").append(" cx1=\"").append(((CubicCurveTo)pe).getControlX1()).append("\" cy1 = \"").append(((CubicCurveTo)pe).getControlY1()).append("\"").append(" cx2=\"").append(((CubicCurveTo)pe).getControlX2()).append("\" cy2 = \"").append(((CubicCurveTo)pe).getControlY2()).append("\"/>\n");
                    continue;
                }
                if (!(pe instanceof ClosePath)) continue;
                sb.append(" <p type=\"close\"/>\n");
            }
        } else {
            for (Point2D pt : this.getShapePoints()) {
                sb.append(" <p x=\"").append((int)pt.getX()).append("\" y=\"").append((int)pt.getY()).append("\"/>\n");
            }
        }
        sb.append("</shape>\n");
        return sb.toString();
    }

    public static enum CreationType {
        BASIC,
        CURVE,
        FRACTAL;

    }

    public static enum StrokeType {
        SIMPLE,
        CROSS_HATCH,
        DASHED,
        DOTTED,
        ELEVATION,
        ELEV_INVERTED,
        RAILROAD,
        COAST;

    }
}

