/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.map.GenerateResources;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.TerrainExtraInfo;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.undo.Point;
import java.util.Map;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.util.Pair;

public class Terrain
extends MapObject {
    public static final Map<String, TerrainType> DEFAULT_TERRAIN = TerrainType.setupDefaults();
    public static Map<String, TerrainType> terrainTypes = TerrainType.setupDefaults();
    private TerrainType type;
    private int elevation;
    private boolean savable;
    private Pair<MapLayer, Point> mapLayerAndLocation = null;
    private TerrainExtraInfo extraInfo = new TerrainExtraInfo();
    transient int gridTempX = -1;
    transient int gridTempY = -1;
    public static long drawImageTime = 0L;
    public static long calcLocTime = 0L;
    public static long setupTime = 0L;
    public static long offsetTime = 0L;

    public TerrainExtraInfo getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(TerrainExtraInfo extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Terrain(String t, boolean setDefaults) {
        this.setType(t, setDefaults);
        this.savable = true;
    }

    public Terrain(String t, int e, boolean icy, boolean gmOnly) {
        this.type = terrainTypes.get(t);
        this.gmOnly = gmOnly;
        this.elevation = e;
        this.extraInfo.setIcy(icy);
        this.savable = true;
    }

    @Override
    public Terrain clone() {
        Terrain clone = new Terrain(this.type.getType(), false);
        clone.setGmOnly(this.gmOnly);
        clone.setElevation(this.elevation);
        clone.extraInfo.setIcy(this.extraInfo.isIcy());
        clone.extraInfo.setBackgroundColor(this.extraInfo.getBackgroundColor());
        System.arraycopy(this.extraInfo.getResources(), 0, clone.extraInfo.getResources(), 0, this.extraInfo.getResources().length);
        return clone;
    }

    @Override
    public boolean isGmOnly() {
        return this.gmOnly;
    }

    @Override
    public void setGmOnly(boolean gmOnly) {
        this.gmOnly = gmOnly;
        this.savable = true;
    }

    public boolean isSavable() {
        return this.savable;
    }

    public void setSavable(boolean savable) {
        this.savable = savable;
    }

    public Pair<MapLayer, Point> getMapLayerAndLocation() {
        return this.mapLayerAndLocation;
    }

    public void setMapLayerAndLocation(Pair<MapLayer, Point> mapLayerAndLocation) {
        this.mapLayerAndLocation = mapLayerAndLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elevation;
        result = 31 * result + (this.extraInfo == null ? 0 : this.extraInfo.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Terrain other = (Terrain)obj;
        if (this.elevation != other.elevation) {
            return false;
        }
        if (this.extraInfo == null ? other.extraInfo != null : !this.extraInfo.equals(other.extraInfo)) {
            return false;
        }
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals(other.type);
    }

    public void makeEqual(Terrain input) {
        this.setType(input.getTypeName());
        this.setBackgroundColor(input.getBackgroundColor());
        this.setGmOnly(input.isGmOnly());
        this.setElevation(input.elevation);
        if (input.extraInfo == null) {
            this.extraInfo = null;
        } else {
            this.extraInfo = new TerrainExtraInfo(input.extraInfo.isIcy());
            this.extraInfo.setBackgroundColor(input.extraInfo.getBackgroundColor());
            System.arraycopy(input.extraInfo.getResources(), 0, this.extraInfo.getResources(), 0, this.extraInfo.getResources().length);
        }
        this.savable = input.savable;
    }

    public void setResources(byte[] resources) {
        this.extraInfo.setResources(resources);
        this.savable = true;
    }

    public void setOneResource(String key, byte value) {
        this.extraInfo.getResources()[ResourceType.valueOf((String)key).value()] = value;
        this.savable = true;
    }

    public void setOneResource(String key, double value) {
        this.extraInfo.getResources()[ResourceType.valueOf((String)key).value()] = (byte)value;
        this.savable = true;
    }

    public void setTempGMOnly(boolean isTempGMOnly) {
        this.extraInfo.setTempGMOnly(isTempGMOnly);
        this.savable = true;
    }

    public void setType(String type) {
        this.setType(type, true);
        this.savable = true;
    }

    public void setType(String type, boolean setDefaults) {
        this.type = type != null && terrainTypes != null && terrainTypes.get(type) != null ? terrainTypes.get(type) : terrainTypes.get("Blank");
        this.elevation = this.type.getElevation();
        if (setDefaults) {
            this.generateResources();
        }
        this.savable = true;
    }

    public TerrainType getType() {
        return this.type;
    }

    public TerrainType type() {
        return this.type;
    }

    public String getTypeName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getType();
    }

    public void generateResources() {
        this.savable = true;
        GenerateResources.generateTerrainResources(this);
    }

    public void paintBorder(GraphicsContext g, double baseX, double baseY, double w, double h, Color c, HexOrientation orientation) {
        g.setStroke((Paint)c);
        if (orientation == HexOrientation.COLUMNS) {
            double[] xs = new double[]{baseX, baseX + w / 4.0, baseX + w * 3.0 / 4.0, baseX + w, baseX + w * 3.0 / 4.0, baseX + w / 4.0};
            double[] ys = new double[]{(int)(baseY + h / 2.0), baseY, baseY, baseY + h / 2.0, baseY + h, baseY + h};
            g.strokePolygon(xs, ys, xs.length);
        } else if (orientation == HexOrientation.ROWS) {
            double[] xs = new double[]{baseX, (int)(baseX + w / 2.0), (int)(baseX + w), (int)(baseX + w), (int)(baseX + w / 2.0), baseX};
            double[] ys = new double[]{(int)(baseY + h / 4.0 + 0.5), baseY, (int)(baseY + h / 4.0 + 0.5), (int)(baseY + h * 3.0 / 4.0 + 0.5), (int)(baseY + h), (int)(baseY + h * 3.0 / 4.0 + 0.5)};
            g.strokePolygon(xs, ys, xs.length);
        } else {
            double[] xs = new double[]{baseX, baseX + w, baseX + w, baseX};
            double[] ys = new double[]{baseY, baseY, baseY + h, baseY + h};
            g.strokePolygon(xs, ys, xs.length);
        }
    }

    public void paintText(GraphicsContext g, String text, double basex, double basey, double h, Color c) {
        g.setFill((Paint)c);
        g.fillText(text, basex, basey + h - 1.0);
    }

    public Polygon getPolygon(double basex, double basey, double w, double h, double wpt75, double hpt75, HexOrientation orientation) {
        if (orientation == HexOrientation.COLUMNS) {
            double[] xs = new double[]{basex, basex + w / 4.0, basex + wpt75 + 0.7, basex + w + 0.7, basex + wpt75 + 0.7, basex + w / 4.0};
            double[] ys = new double[]{basey + h / 2.0, basey, basey, basey + h / 2.0, basey + h + 0.7, basey + h + 0.7};
            return new Polygon(new double[]{xs[0], ys[0], xs[1], ys[1], xs[2], ys[2], xs[3], ys[3], xs[4], ys[4], xs[5], ys[5]});
        }
        if (orientation == HexOrientation.ROWS) {
            double[] xs = new double[]{basex, basex + w / 2.0, basex + w + 0.7, basex + w + 0.7, basex + w / 2.0, basex};
            double[] ys = new double[]{basey + h / 4.0 + 0.5, basey, basey + h / 4.0 + 0.5, basey + hpt75 + 0.7, basey + h + 0.7, basey + hpt75 + 0.7};
            return new Polygon(new double[]{xs[0], ys[0], xs[1], ys[1], xs[2], ys[2], xs[3], ys[3], xs[4], ys[4], xs[5], ys[5]});
        }
        double[] xs = new double[]{basex, basex + w, basex + w, basex};
        double[] ys = new double[]{basey, basey, basey + h, basey + h};
        return new Polygon(new double[]{xs[0], ys[0], xs[1], ys[1], xs[2], ys[2], xs[3], ys[3]});
    }

    public void paint(GraphicsContext g, double basex, double basey, double w, double h, double wpt75, double hpt75, Color c, HexOrientation orientation, boolean includeIcon, boolean drawborder, boolean fill, Paint overrideFill, boolean dontUseIcon) {
        long time3 = System.nanoTime();
        g.setStroke((Paint)c);
        if (this.getTypeName().equals("Empty")) {
            g.setFill((Paint)Color.BLACK);
        } else if (this.extraInfo != null && this.extraInfo.isIcy()) {
            if (this.getTypeName().toLowerCase().contains("water")) {
                g.setFill((Paint)Color.color((double)0.85, (double)0.9, (double)1.0));
            } else {
                g.setFill((Paint)Color.WHITE);
            }
        } else if (this.extraInfo != null && this.extraInfo.getBackgroundColor() != null) {
            g.setFill((Paint)this.extraInfo.getBackgroundColor());
        } else {
            g.setFill((Paint)this.type.getBgColor());
        }
        if (overrideFill != null) {
            g.setFill(overrideFill);
        }
        setupTime += System.nanoTime() - time3;
        long time2 = System.nanoTime();
        if (orientation == HexOrientation.COLUMNS) {
            xs = new double[]{basex, basex + w / 4.0, basex + wpt75 + 0.7, basex + w + 0.7, basex + wpt75 + 0.7, basex + w / 4.0};
            double[] ys = new double[]{basey + h / 2.0, basey, basey, basey + h / 2.0, basey + h + 0.7, basey + h + 0.7};
            if (fill) {
                g.fillPolygon(xs, ys, xs.length);
            }
            if (drawborder) {
                g.strokePolygon(xs, ys, xs.length);
            }
        } else if (orientation == HexOrientation.ROWS) {
            xs = new double[]{basex, basex + w / 2.0, basex + w + 0.7, basex + w + 0.7, basex + w / 2.0, basex};
            double[] ys = new double[]{basey + h / 4.0 + 0.5, basey, basey + h / 4.0 + 0.5, basey + hpt75 + 0.7, basey + h + 0.7, basey + hpt75 + 0.7};
            if (fill) {
                g.fillPolygon(xs, ys, xs.length);
            }
            if (drawborder) {
                g.strokePolygon(xs, ys, xs.length);
            }
        } else {
            xs = new double[]{basex, basex + w, basex + w, basex};
            double[] ys = new double[]{basey, basey, basey + h, basey + h};
            if (fill) {
                g.fillPolygon(xs, ys, xs.length);
            }
            if (drawborder) {
                g.strokePolygon(xs, ys, xs.length);
            }
        }
        calcLocTime += System.nanoTime() - time2;
        if (!includeIcon) {
            return;
        }
        if (!(orientation != HexOrientation.ROWS || this.getTypeName().toLowerCase().contains("iso ") || this.getTypeName().toLowerCase().contains("isometric") || this.getTypeName().toLowerCase().contains("full ") || !this.getTypeName().toLowerCase().contains("rows") && !this.getTypeName().toLowerCase().contains("cols"))) {
            h = w;
        }
        if (fill && this.type.getIcon() != null) {
            long time4 = System.nanoTime();
            double offsetx = (w - w * this.getType().getIconSize() + w * this.getType().getOffsetXDecimal()) / 2.0;
            double offsety = (h - h * this.getType().getIconSize() + h * this.getType().getOffsetYDecimal()) / 2.0;
            if (this.getType().getOffsetYDecimal() != 0.0) {
                h += Math.abs(this.getType().getOffsetYDecimal() / 2.0 * h);
            }
            if (this.getTypeName().contains("Protrude")) {
                offsety = ((h *= 1.5) - h * this.getType().getIconSize() * 1.3333) / 2.0;
            }
            offsetTime += System.nanoTime() - time4;
            long time = System.nanoTime();
            if (!dontUseIcon) {
                g.drawImage(this.type.getIcon(), basex + offsetx, basey + offsety, w * this.getType().getIconSize(), h * this.getType().getIconSize());
            }
            drawImageTime += System.nanoTime() - time;
        }
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int elev) {
        this.elevation = elev;
        this.savable = true;
    }

    public void setIcy(boolean isIcy) {
        this.extraInfo.setIcy(isIcy);
        this.savable = true;
    }

    public boolean isIcy() {
        return this.extraInfo.isIcy();
    }

    public void setBackgroundColor(Color background) {
        if (background == null) {
            return;
        }
        this.extraInfo.setBackgroundColor(background);
        this.savable = true;
    }

    public Color getBackgroundColor() {
        if (this.extraInfo == null) {
            return null;
        }
        return this.extraInfo.getBackgroundColor();
    }

    public int getGridTempX() {
        return this.gridTempX;
    }

    public void setGridTempX(int gridTempX) {
        this.gridTempX = gridTempX;
    }

    public int getGridTempY() {
        return this.gridTempY;
    }

    public void setGridTempY(int gridTempY) {
        this.gridTempY = gridTempY;
    }

    public static void restoreDefaults() {
        terrainTypes = DEFAULT_TERRAIN;
    }
}

