/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.undo.Undoable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;

public class Feature
extends MapObject
implements Undoable {
    public static final Map<String, FeatureType> DEFAULT_FEATURES = FeatureType.setupDefaults();
    public static Map<String, FeatureType> featureTypes = new TreeMap<String, FeatureType>();
    private FeatureType type;
    private MapLayer mapLayer;
    private double scale = -1.0;
    private double scaleHt = -1.0;
    private boolean horizontalFlip = false;
    private boolean verticalFlip = false;
    private Map<ViewLevel, Point2D> location = new HashMap<ViewLevel, Point2D>();
    private boolean hideTerrainIcon = true;
    private Color overrideColor = null;
    private double rotate = 0.0;
    private boolean placeFreely = false;
    private boolean fillHexBottom = false;
    private Color ring = null;
    private String tags = "";
    private MapLabel label;
    private boolean isWorld = true;
    private boolean isContinent = true;
    private boolean isKingdom = true;
    private boolean isProvince = true;
    private boolean overrideLabelStyle = false;
    private FeatureDecoration[] featureDecorations = new FeatureDecoration[8];
    private FeatureDecoration.FeatureDecorationLocation labelPosition;
    private int labelDistance;
    private UUID uuid;

    public Feature(String type) {
        this.setType(type);
    }

    public Feature(String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, MapLabel label, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer ml) {
        this(t, placefreely, hideterrainicon, isgmonly, fillhexbottom, ring, rotate, overridecolor, scale, scaleHt, false, false, label, 0, FeatureDecoration.FeatureDecorationLocation.SIX, tags, isworld, iscontinent, iskingdom, isprovince, ml);
    }

    public Feature(String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, boolean hflip, boolean vflip, MapLabel label, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer ml) {
        this(t, placefreely, hideterrainicon, isgmonly, fillhexbottom, ring, rotate, overridecolor, scale, scaleHt, hflip, vflip, label, 0, FeatureDecoration.FeatureDecorationLocation.SIX, tags, isworld, iscontinent, iskingdom, isprovince, ml);
    }

    public Feature(String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, boolean hflip, boolean vflip, MapLabel label, int labeldist, FeatureDecoration.FeatureDecorationLocation labelpos, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer ml) {
        if (!featureTypes.containsKey(t)) {
            System.out.println("Feature " + t + " not found");
        }
        this.setType(t);
        this.mapLayer = ml;
        this.placeFreely = placefreely;
        this.hideTerrainIcon = hideterrainicon;
        this.gmOnly = isgmonly;
        this.fillHexBottom = fillhexbottom;
        this.ring = ring;
        this.rotate = rotate;
        this.overrideColor = overridecolor;
        this.scale = scale;
        this.scaleHt = scaleHt;
        this.horizontalFlip = hflip;
        this.verticalFlip = vflip;
        this.tags = tags;
        this.label = label;
        this.labelDistance = labeldist;
        this.labelPosition = labelpos;
        this.isWorld = isworld;
        this.isContinent = iscontinent;
        this.isKingdom = iskingdom;
        this.isProvince = isprovince;
        this.uuid = UUID.randomUUID();
        Arrays.fill(this.featureDecorations, null);
    }

    @Override
    public Feature clone() {
        Feature f = new Feature(this.type.getType(), this.placeFreely, this.hideTerrainIcon, this.gmOnly, this.fillHexBottom, this.ring, this.rotate, this.overrideColor, this.scale, this.scaleHt, this.horizontalFlip, this.verticalFlip, this.label == null ? null : this.label.clone(), this.labelDistance, this.labelPosition, this.tags, this.isWorld, this.isContinent, this.isKingdom, this.isProvince, this.mapLayer);
        for (ViewLevel vl : this.location.keySet()) {
            f.location.put(vl, this.location.get((Object)vl));
        }
        for (int i = 0; i < this.featureDecorations.length; ++i) {
            FeatureDecoration fd = this.featureDecorations[i];
            f.featureDecorations[i] = fd == null ? null : new FeatureDecoration(fd.getText(), fd.getColor(), fd.getLocation());
        }
        return f;
    }

    @Override
    public void makeIdenticalTo(Undoable u) {
        if (!(u instanceof Feature)) {
            return;
        }
        Feature f = (Feature)u;
        this.setType(f.getTypeName());
        this.mapLayer = f.mapLayer;
        this.placeFreely = f.isPlaceFreely();
        this.hideTerrainIcon = f.hideTerrainIcon;
        this.gmOnly = f.gmOnly;
        this.fillHexBottom = f.fillHexBottom;
        this.ring = f.ring;
        this.rotate = f.rotate;
        this.overrideColor = f.overrideColor;
        this.scale = f.scale;
        this.scaleHt = f.scaleHt;
        this.tags = f.tags;
        this.label = f.label == null ? null : f.label.clone();
        this.labelPosition = f.labelPosition;
        this.labelDistance = f.labelDistance;
        this.overrideLabelStyle = f.overrideLabelStyle;
        this.horizontalFlip = f.horizontalFlip;
        this.verticalFlip = f.verticalFlip;
        this.isWorld = f.isWorld;
        this.isContinent = f.isContinent;
        this.isKingdom = f.isKingdom;
        this.isProvince = f.isProvince;
        this.location = new HashMap<ViewLevel, Point2D>();
        for (ViewLevel vl : f.location.keySet()) {
            this.location.put(vl, f.location.get((Object)vl));
        }
        for (int i = 0; i < f.featureDecorations.length; ++i) {
            FeatureDecoration fd = f.featureDecorations[i];
            this.featureDecorations[i] = fd == null ? null : new FeatureDecoration(fd.getText(), fd.getColor(), fd.getLocation());
        }
    }

    public void setUUID(String uuidstr) {
        this.uuid = uuidstr == null || uuidstr.equals("") ? UUID.randomUUID() : UUID.fromString(uuidstr);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public MapLayer getMapLayer() {
        return this.mapLayer;
    }

    public void setMapLayer(MapLayer mapLayer) {
        this.mapLayer = mapLayer;
    }

    public FeatureDecoration[] getFeatureDecorations() {
        return this.featureDecorations;
    }

    public void setFeatureDecorations(FeatureDecoration[] featureDecorations) {
        this.featureDecorations = featureDecorations;
    }

    public boolean isWorld() {
        return this.isWorld;
    }

    public void setWorld(boolean isWorld) {
        this.isWorld = isWorld;
    }

    public boolean isContinent() {
        return this.isContinent;
    }

    public void setContinent(boolean isContinent) {
        this.isContinent = isContinent;
    }

    public boolean isKingdom() {
        return this.isKingdom;
    }

    public void setKingdom(boolean isKingdom) {
        this.isKingdom = isKingdom;
    }

    public boolean isProvince() {
        return this.isProvince;
    }

    public void setProvince(boolean isProvince) {
        this.isProvince = isProvince;
    }

    public double getScaleHt() {
        return this.scaleHt;
    }

    public void setScaleHt(double scaleHt) {
        this.scaleHt = scaleHt;
    }

    public boolean isHorizontalFlip() {
        return this.horizontalFlip;
    }

    public void setHorizontalFlip(boolean horizontalFlip) {
        this.horizontalFlip = horizontalFlip;
    }

    public boolean isVerticalFlip() {
        return this.verticalFlip;
    }

    public void setVerticalFlip(boolean verticalFlip) {
        this.verticalFlip = verticalFlip;
    }

    public MapLabel getLabel() {
        return this.label;
    }

    public void setLabel(MapLabel label) {
        this.label = label;
    }

    public FeatureDecoration.FeatureDecorationLocation getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(FeatureDecoration.FeatureDecorationLocation labelPosition) {
        this.labelPosition = labelPosition;
    }

    public int getLabelDistance() {
        return this.labelDistance;
    }

    public void setLabelDistance(int labelDistance) {
        this.labelDistance = labelDistance;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public double getScale() {
        return this.scale;
    }

    public double getScaleFallbackType() {
        if (this.scale < 0.0) {
            return this.type.getIconSize() * 100.0;
        }
        return this.scale;
    }

    public double getScaleHtFallbackType() {
        if (this.scaleHt < 0.0) {
            return this.type.getIconHeight() * 100.0;
        }
        return this.scaleHt;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public boolean isPlaceFreely() {
        return this.placeFreely;
    }

    public void setPlaceFreely(boolean placeFreely) {
        this.placeFreely = placeFreely;
    }

    public boolean isFillHexBottom() {
        return this.fillHexBottom;
    }

    public void setFillHexBottom(boolean fillHexBottom) {
        this.fillHexBottom = fillHexBottom;
    }

    public Color getRing() {
        return this.ring;
    }

    public void setRing(Color ring) {
        this.ring = ring;
    }

    public boolean isHideTerrainIcon() {
        return this.hideTerrainIcon;
    }

    public void setHideTerrainIcon(boolean hideTerrainIcon) {
        this.hideTerrainIcon = hideTerrainIcon;
    }

    public Point2D getLocation(ViewLevel vl) {
        if (vl.equals((Object)ViewLevel.WORLD) && !this.isWorld()) {
            return null;
        }
        if (vl.equals((Object)ViewLevel.KINGDOM) && !this.isKingdom()) {
            return null;
        }
        if (vl.equals((Object)ViewLevel.CONTINENT) && !this.isContinent()) {
            return null;
        }
        if (vl.equals((Object)ViewLevel.PROVINCE) && !this.isProvince()) {
            return null;
        }
        return this.location.get((Object)vl);
    }

    public void setLocation(ViewLevel vl, double x, double y) {
        this.setLocation(vl, new Point2D(x, y));
    }

    public void setLocation(ViewLevel vl, Point2D pt) {
        this.location.put(vl, pt);
    }

    public void setType(String type) {
        this.type = featureTypes.get(type);
    }

    public FeatureType getType() {
        return this.type;
    }

    public FeatureType type() {
        return this.type;
    }

    public String getTypeName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Feature:" + this.type.getType());
        sb.append(" scale:").append(this.scale);
        sb.append(" scaleHt:").append(this.scaleHt);
        sb.append(" location:").append(this.location);
        sb.append(" hideTerrainIcon:").append(this.hideTerrainIcon);
        sb.append(" overrideColor:").append(this.overrideColor);
        sb.append(" rotate:").append(this.rotate);
        sb.append(" placeFreely:").append(this.placeFreely);
        sb.append(" fillHexBottom:").append(this.fillHexBottom);
        sb.append(" ring:").append(this.ring);
        sb.append(" isGMOnly:").append(this.gmOnly);
        sb.append(" tags:").append(this.tags);
        sb.append(" label:").append(this.label);
        sb.append(" labelPosition:").append((Object)this.labelPosition);
        sb.append(" labelDistance:").append(this.labelDistance);
        sb.append(" layer:").append(this.mapLayer);
        return sb.toString();
    }

    public void paint(GraphicsContext g, MapData md, double hexw, double hexh, double offsetscrollx, double offsetscrolly, HexOrientation orientation, ViewLevel vl, boolean glowGMOnly, boolean showFeatureLabels, boolean useAlternateIcons, Point2D tilecenterpt) {
        if (this.type == null) {
            return;
        }
        if (this.type.getIcon() != null) {
            Point2D modelpt;
            double typeht;
            double scalew;
            Image icon = this.type.getIcon();
            if (useAlternateIcons && this.type.getAlternateIcon() != null) {
                icon = this.type.getAlternateIcon();
            }
            if ((scalew = this.scale) < 0.0) {
                scalew = this.getType().getIconSize() * 100.0;
            }
            double imageAdjWidth = hexw * scalew * 0.01;
            double imageAdjHeight = this.scaleHt >= 0.0 ? hexh * this.scaleHt * 0.01 : ((typeht = this.getType().getIconHeight()) > 0.0 ? hexw * typeht * scalew / this.getType().getIconSize() * 0.01 : hexh * scalew * 0.01);
            if (this.overrideColor != null && this.overrideColor.getOpacity() != 0.0) {
                icon = Feature.overrideImageColor(icon, this.overrideColor);
            }
            if ((modelpt = this.location.get((Object)vl)) == null) {
                return;
            }
            Point2D pt = new Point2D(modelpt.getX() * hexw / 300.0 - offsetscrollx, modelpt.getY() * hexh / 300.0 - offsetscrolly);
            if (glowGMOnly && this.isGmOnly()) {
                DropShadow ds = new DropShadow();
                ds.setSpread(2.0);
                ds.setRadius(2.0);
                ds.setColor(new Color(1.0, 0.0, 0.0, 0.5));
                ds.setOffsetX(0.0);
                ds.setOffsetY(0.0);
                g.setEffect((Effect)ds);
            }
            if (this.isFillHexBottom() && tilecenterpt != null) {
                g.setFill((Paint)Color.BLACK);
                if (this.getTypeName().toLowerCase().contains("capital")) {
                    g.setFill((Paint)Color.web((String)"rgb(198,11,11)"));
                }
                if (this.getOverrideColor() != null) {
                    g.setFill((Paint)this.getOverrideColor());
                }
                if (orientation == HexOrientation.COLUMNS) {
                    xs = new double[]{tilecenterpt.getX() - hexw * 13.0 / 32.0, tilecenterpt.getX() + hexw * 13.0 / 32.0, tilecenterpt.getX() + hexw / 4.0, tilecenterpt.getX() - hexw / 4.0};
                    ys = new double[]{tilecenterpt.getY() + hexh / 5.0, tilecenterpt.getY() + hexh / 5.0, tilecenterpt.getY() + hexh / 2.0, tilecenterpt.getY() + hexh / 2.0};
                    g.fillPolygon(xs, ys, xs.length);
                } else if (orientation == HexOrientation.ROWS) {
                    xs = new double[]{tilecenterpt.getX() - hexw / 2.0, tilecenterpt.getX() + hexw / 2.0, tilecenterpt.getX() + hexh / 2.0, tilecenterpt.getX(), tilecenterpt.getX() - hexh / 2.0};
                    ys = new double[]{tilecenterpt.getY() + hexh / 5.0, tilecenterpt.getY() + hexh / 5.0, tilecenterpt.getY() + hexh / 4.0, tilecenterpt.getY() + hexh / 2.0, tilecenterpt.getY() + hexh / 4.0};
                    g.fillPolygon(xs, ys, xs.length);
                }
            }
            if (this.rotate != 0.0) {
                g.save();
                Rotate r = new Rotate(this.rotate, pt.getX(), pt.getY());
                g.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
            }
            g.drawImage(icon, pt.getX() - imageAdjWidth / 2.0 + (this.horizontalFlip ? imageAdjWidth : 0.0), pt.getY() - imageAdjHeight / 2.0 + (this.verticalFlip ? imageAdjHeight : 0.0), this.horizontalFlip ? -imageAdjWidth : imageAdjWidth, this.verticalFlip ? -imageAdjHeight : imageAdjHeight);
            if (this.rotate != 0.0) {
                g.restore();
            }
            if (this.getRing() != null) {
                g.setStroke((Paint)this.ring);
                g.setLineWidth(3.0);
                double r = hexw * 3.0 / 8.0;
                g.strokeArc(pt.getX() - r, pt.getY() - r, r * 2.0, r * 2.0, 0.0, 360.0, ArcType.CHORD);
            }
            if (this.label != null && !"".equals(this.label.getText()) && showFeatureLabels) {
                Point2D pos = this.calculateFeatureDecorationPt(hexw, hexh, 1.0, (double)this.getLabelDistance() / 100.0 + 1.0, pt, this.getLabelPosition());
                g.setFont(this.label.getFont(md, hexh, vl, 1.0, 1.0));
                double x = pos.getX();
                double y = pos.getY() + g.getFont().getSize() / 2.0;
                if (this.label.getLocation() == null || this.label.getLocation().size() == 0) {
                    this.label.setLocationAndScale(vl, new Point2D(modelpt.getX(), modelpt.getY() + (double)this.getLabelDistance() / 100.0 * 300.0 + g.getFont().getSize() / 2.0 * 300.0 / hexh), this.label.getScale(vl));
                }
                this.label.paint(g, md, x, y, hexw, hexh, offsetscrollx, offsetscrolly, vl, orientation, 1.0, 1.0, 1.0, glowGMOnly);
            }
            if (this.featureDecorations != null) {
                for (FeatureDecoration featureDecoration : this.featureDecorations) {
                    if (featureDecoration == null || featureDecoration.getLocation() == null) continue;
                    g.setFont(Font.font((String)"Arial", (double)(hexh / 4.0)));
                    g.setTextAlign(TextAlignment.CENTER);
                    Point2D pos = this.calculateFeatureDecorationPt(hexw, hexh, 1.0, 1.0, pt, featureDecoration.getLocation());
                    double x = pos.getX();
                    double y = pos.getY() + g.getFont().getSize() / 2.0;
                    g.setFill((Paint)featureDecoration.getColor());
                    g.fillText(featureDecoration.getText(), x, y);
                }
            }
            g.setEffect(null);
        }
    }

    public Point2D calculateFeatureDecorationPt(double hexw, double hexh, double factorw, double factorh, Point2D pt, FeatureDecoration.FeatureDecorationLocation loc) {
        double x = 0.0;
        double y = 0.0;
        switch (loc) {
            case ONE: {
                x = pt.getX() + hexw / 6.0 * factorw;
                y = pt.getY() - hexh * 0.4 * factorh;
                break;
            }
            case TWO: {
                x = pt.getX() + hexw / 4.0 * factorw;
                y = pt.getY() - hexh / 5.0 * factorh;
                break;
            }
            case THREE: {
                x = pt.getX() + hexw / 3.0 * factorw;
                y = pt.getY();
                break;
            }
            case FOUR: {
                x = pt.getX() + hexw / 4.0 * factorw;
                y = pt.getY() + hexh / 5.0 * factorh;
                break;
            }
            case FIVE: {
                x = pt.getX() + hexw / 6.0 * factorw;
                y = pt.getY() + hexh / 3.0 * factorh;
                break;
            }
            case SIX: {
                x = pt.getX();
                y = pt.getY() + hexh * 0.4 * factorh;
                break;
            }
            case SEVEN: {
                x = pt.getX() - hexw / 6.0 * factorw;
                y = pt.getY() + hexh / 3.0 * factorh;
                break;
            }
            case EIGHT: {
                x = pt.getX() - hexw / 4.0 * factorw;
                y = pt.getY() + hexh / 5.0 * factorh;
                break;
            }
            case NINE: {
                x = pt.getX() - hexw / 3.0 * factorw;
                y = pt.getY();
                break;
            }
            case TEN: {
                x = pt.getX() - hexw / 4.0 * factorw;
                y = pt.getY() - hexh / 5.0 * factorh;
                break;
            }
            case ELEVEN: {
                x = pt.getX() - hexw / 6.0 * factorw;
                y = pt.getY() - hexh * 0.4 * factorh;
                break;
            }
            case TWELVE: {
                x = pt.getX();
                y = pt.getY() - hexh / 2.0 * factorh * 0.88;
            }
        }
        return new Point2D(x, y);
    }

    public void setOverrideColor(Color color) {
        this.overrideColor = color;
    }

    public Color getOverrideColor() {
        return this.overrideColor;
    }

    public static void restoreDefaults(String folder, boolean isfull) {
        featureTypes = new TreeMap<String, FeatureType>();
        if (isfull) {
            FeatureType.loadUserFeatures(DEFAULT_FEATURES, folder);
        }
        for (FeatureType ft : DEFAULT_FEATURES.values()) {
            featureTypes.put(ft.getType(), new FeatureType(ft.getType(), ft.getIcon(), ft.getIconSize(), ft.isDefaultAndUnchanged()));
        }
    }

    public static FeatureType restoreOneDefault(String typename) {
        Properties props = FeatureType.loadDefaults();
        FeatureType ft = FeatureType.setupOneDefault(typename, props);
        if (ft != null) {
            featureTypes.put(ft.getType(), new FeatureType(ft.getType(), ft.getIcon(), ft.getIconSize(), ft.isDefaultAndUnchanged()));
            return ft;
        }
        return ft;
    }

    public String getXMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<feature type=\"").append(MapDataIO.toEscapedXML(this.getTypeName())).append("\" rotate=\"").append(this.getRotate()).append("\" uuid=\"").append(this.uuid).append("\"");
        sb.append(" mapLayer=\"").append(MapDataIO.toEscapedXML(this.getMapLayer().getName())).append("\" isFlipHorizontal=\"").append(this.isHorizontalFlip()).append("\" isFlipVertical=\"").append(this.isVerticalFlip()).append("\"");
        sb.append(" scale=\"").append(this.getScale()).append("\" scaleHt=\"").append(this.getScaleHt()).append("\" tags=\"").append(MapDataIO.toEscapedXML(this.getTags())).append("\"");
        if (this.getOverrideColor() != null) {
            sb.append(" color=\"").append(this.getOverrideColor().getRed()).append(",").append(this.getOverrideColor().getGreen()).append(",").append(this.getOverrideColor().getBlue()).append(",").append(this.getOverrideColor().getOpacity()).append("\"");
        } else {
            sb.append(" color=\"null\"");
        }
        if (this.getRing() != null) {
            sb.append(" ringColor=\"").append(this.getRing().getRed()).append(",").append(this.getRing().getGreen()).append(",").append(this.getRing().getBlue()).append(",").append(this.getRing().getOpacity()).append("\"");
        } else {
            sb.append(" ringcolor=\"null\"");
        }
        sb.append(" isGMOnly=\"").append(this.isGmOnly()).append("\" isPlaceFreely=\"").append(this.isPlaceFreely()).append("\"");
        sb.append(" labelPosition=\"").append((Object)this.getLabelPosition()).append("\" labelDistance=\"").append(this.getLabelDistance()).append("\"");
        sb.append(" isWorld=\"").append(this.isWorld()).append("\" isContinent=\"").append(this.isContinent()).append("\" isKingdom=\"").append(this.isKingdom()).append("\" isProvince=\"").append(this.isProvince()).append("\"");
        sb.append(" isFillHexBottom=\"").append(this.isFillHexBottom()).append("\" isHideTerrainIcon=\"").append(this.isHideTerrainIcon()).append("\">");
        if (this.featureDecorations != null) {
            for (FeatureDecoration fd : this.getFeatureDecorations()) {
                if (fd == null || fd.getLocation() == null || fd.getColor() == null) continue;
                sb.append("<decoration color=\"").append(fd.getColor().getRed()).append(",").append(fd.getColor().getGreen()).append(",").append(fd.getColor().getBlue()).append(",").append(fd.getColor().getOpacity()).append("\"").append(" location=\"").append(fd.getLocation().getValue()).append("\">").append(MapDataIO.toEscapedXML(fd.getText())).append("</decoration>\n");
            }
        }
        this.appendLocationXML(sb, ViewLevel.COSMIC);
        this.appendLocationXML(sb, ViewLevel.WORLD);
        this.appendLocationXML(sb, ViewLevel.CONTINENT);
        this.appendLocationXML(sb, ViewLevel.KINGDOM);
        this.appendLocationXML(sb, ViewLevel.PROVINCE);
        this.appendLocationXML(sb, ViewLevel.SETTLEMENT);
        this.appendLocationXML(sb, ViewLevel.BATTLEMAT);
        if (this.getLabel() != null) {
            sb.append(this.getLabel().getXMLString());
        }
        sb.append("</feature>\n");
        return sb.toString();
    }

    private void appendLocationXML(StringBuilder sb, ViewLevel vl) {
        if (this.getLocation(vl) != null) {
            Point2D loc = this.getLocation(vl);
            sb.append("<location viewLevel=\"").append(vl.name()).append("\" x=\"").append(loc.getX()).append("\" y=\"").append(loc.getY()).append("\" />");
        }
    }

    public static Image overrideImageColor(Image image, Color newcolor) {
        PixelReader pixelReader = image.getPixelReader();
        WritableImage wImage = new WritableImage((int)image.getWidth(), (int)image.getHeight());
        PixelWriter pixelWriter = wImage.getPixelWriter();
        int readY = 0;
        while ((double)readY < image.getHeight()) {
            int readX = 0;
            while ((double)readX < image.getWidth()) {
                Color color = pixelReader.getColor(readX, readY);
                if (color.getOpacity() > 0.0) {
                    pixelWriter.setColor(readX, readY, new Color(newcolor.getRed(), newcolor.getGreen(), newcolor.getBlue(), color.getOpacity()));
                }
                ++readX;
            }
            ++readY;
        }
        return wImage;
    }
}

