/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import javafx.concurrent.Task;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javax.imageio.ImageIO;

public class ExportUVTTMapTask
extends Task<Integer> {
    File file;
    final MapData mapData;
    final MapUI mapUI;
    final ViewLevel currentViewLevel;

    public ExportUVTTMapTask(Worldographer worldographer, File f, MapData md, ViewLevel currentViewLevel) {
        this.file = f;
        this.mapData = md;
        this.mapUI = worldographer.getMapUI();
        this.currentViewLevel = currentViewLevel;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
    }

    protected Integer call() throws Exception {
        this.updateMessage("Starting . . .");
        this.exportUVTTFile();
        this.updateMessage("Finished.");
        return 1;
    }

    public void exportUVTTFile() throws Exception {
        if (!this.file.getName().endsWith(".uvtt")) {
            String filename = this.file.getAbsolutePath().substring(0, this.file.getAbsolutePath().length() - 5) + ".uvtt";
            this.file = new File(filename);
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), StandardCharsets.UTF_16);
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("\"software\": \"Worldographer 2025\",");
        sb.append("\"format\": 1.0,\n");
        sb.append("\"resolution\": {\n");
        sb.append("     \"map_origin\": {\n");
        sb.append("          \"x\": 0,\n");
        sb.append("          \"y\": 0\n");
        sb.append("     },\n");
        sb.append("     \"map_size\": {\n");
        sb.append("          \"x\": " + this.mapData.getTerrain(this.currentViewLevel).length + ",\n");
        sb.append("          \"y\": " + this.mapData.getTerrain(this.currentViewLevel)[0].length + "\n");
        sb.append("     },\n");
        sb.append("     \"pixels_per_grid\": " + this.mapData.getTileWidth() + ",\n");
        sb.append("},\n");
        sb.append("\"line_of_sight\": {\n");
        ArrayList<Path> paths = new ArrayList<Path>();
        for (MapShape ms : this.mapData.getShapes()) {
            if (!ms.getTags().toLowerCase().contains("wall")) continue;
            paths.add((Path)ms.getShape());
        }
        for (int j = 0; j < paths.size(); ++j) {
            Path path = (Path)paths.get(j);
            sb.append("     [\n");
            ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
            for (PathElement pe : path.getElements()) {
                if (pe instanceof MoveTo) {
                    pathElements.add(pe);
                }
                if (!(pe instanceof LineTo)) continue;
                pathElements.add(pe);
            }
            for (int i = 0; i < pathElements.size(); ++i) {
                PathElement pe;
                pe = (PathElement)pathElements.get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    sb.append("          {");
                    sb.append("          \"x\": " + mt.getX() + ",\n");
                    sb.append("          \"y\": " + mt.getY() + "\n");
                    sb.append("          }");
                    if (i != pathElements.size() - 1) {
                        sb.append(",\n");
                        continue;
                    }
                    sb.append("\n");
                    continue;
                }
                if (!(pe instanceof LineTo)) continue;
                LineTo lt = (LineTo)pe;
                sb.append("          {");
                sb.append("          \"x\": " + lt.getX() + ",\n");
                sb.append("          \"y\": " + lt.getY() + "\n");
                sb.append("          }");
                if (i != pathElements.size() - 1) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
            sb.append("     ]");
            if (j != paths.size() - 1) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append("},\n");
        this.updateMessage("Creating image.");
        Rectangle rect = this.mapUI.getSnapShotArea(false);
        this.updateMessage("Got area for image.");
        BufferedImage bi = this.mapUI.getSnapShotMapAsImage(rect);
        this.updateMessage("Got Image.");
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", bas);
        this.updateMessage("Image written.");
        sb.append("\"image\": \"" + Base64.encodeObject((Serializable)bas.toByteArray()) + "\"\n");
        this.updateMessage("Image encoded.");
        sb.append("}");
        w.write(sb.toString());
        w.close();
        this.updateMessage("UVTT export complete.");
    }

    public void updateMessagePublic(String message) {
        this.updateMessage(message);
    }
}

