/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.generator.city.SettlementData;
import com.inkwellideas.ographer.generator.city.StreetGenConfig;
import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.setup.SetupCityScreen;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import javafx.util.Pair;

public class GenerateCityTask
extends Task<MapDataSetup> {
    private static final String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private final MapDataSetup setup;
    private final CITYGEN citygen;
    private final MapUI mapUI;
    public static int buildingFailsCoastRiver = 0;
    public static int buildingFailsRoad = 0;
    public static int buildingFailsOtherBuilding = 0;

    public GenerateCityTask(MapDataSetup mapDataSetup, Worldographer worldographer, CITYGEN citygen, MapUI mapui) {
        this.setup = mapDataSetup;
        this.citygen = citygen;
        this.mapUI = mapui;
        buildingFailsCoastRiver = 0;
        buildingFailsRoad = 0;
        buildingFailsOtherBuilding = 0;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
        worldographer.getCancelButton().setDisable(false);
        worldographer.getCancelButton().setOnAction(t -> {
            this.cancel();
            worldographer.getCancelButton().setDisable(true);
            worldographer.getMapUI().draw();
        });
        if (CityDataGenerator.settlementData.getRaces().size() == 0) {
            CityDataGenerator.parseSettings(new LoadGeneratorData().getCityMedieval(), false);
        }
    }

    private static List<Line> getRoadSegments(MapData data, boolean includewalls) {
        ArrayList<Line> hsl = new ArrayList<Line>();
        for (MapShape l : data.getShapes()) {
            if (l.getTags() != null && l.getTags().contains("road") && l.getShape() instanceof Path) {
                GenerateCityTask.getRoadSegmentsHelper(hsl, l);
            }
            if (!includewalls || l.getTags() == null || !l.getTags().contains("wall") || !(l.getShape() instanceof Path)) continue;
            GenerateCityTask.getRoadSegmentsHelper(hsl, l);
        }
        return hsl;
    }

    private static List<Line> getWallSegments(MapData data) {
        ArrayList<Line> hsl = new ArrayList<Line>();
        for (MapShape l : data.getShapes()) {
            if (l.getTags() == null || !l.getTags().contains("wall") || !(l.getShape() instanceof Path)) continue;
            GenerateCityTask.getRoadSegmentsHelper(hsl, l);
        }
        return hsl;
    }

    private static void getRoadSegmentsHelper(List<Line> hsl, MapShape l) {
        Point2D priorpt = null;
        ObservableList pes = ((Path)l.getShape()).getElements();
        if (pes.size() > 1) {
            for (PathElement pe : pes) {
                Line line;
                Point2D nextpt;
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    if (priorpt == null) {
                        priorpt = new Point2D(mt.getX(), mt.getY());
                        continue;
                    }
                    nextpt = new Point2D(mt.getX(), mt.getY());
                    line = new Line(priorpt.getX(), priorpt.getY(), nextpt.getX(), nextpt.getY());
                    hsl.add(line);
                    priorpt = nextpt;
                    continue;
                }
                if (!(pe instanceof LineTo)) continue;
                LineTo mt = (LineTo)pe;
                if (priorpt == null) {
                    priorpt = new Point2D(mt.getX(), mt.getY());
                    continue;
                }
                nextpt = new Point2D(mt.getX(), mt.getY());
                if (priorpt.getX() != nextpt.getX() && priorpt.getY() != nextpt.getY()) {
                    line = new Line(priorpt.getX(), priorpt.getY(), nextpt.getX(), nextpt.getY());
                    hsl.add(line);
                }
                priorpt = nextpt;
            }
        }
    }

    private static int placeSingleBuilding(UndoActionGroup uag, MapUI mapUI, List<Feature> features, List<Line> roads, List<Shape> buildingborderlines, Line road, double dx, double dy, double slope, double rotation, int extraPushBack, double percent, Feature f, double mapwidth, double mapheight, boolean onroad, Point2D cityCenter, Map<String, Integer> buildingcodes, MapLayer labellayer, boolean dense, Shape selectedAreaPolygon, String labelOptions) {
        Shape inter;
        double scaleht;
        double fHeight = f.getType().getIconHeight();
        if (fHeight < 0.0) {
            fHeight = f.getType().getIconSize();
        }
        double pushbackdistance = road.getStrokeWidth() * 100.0 + fHeight * 100.0 + (double)(extraPushBack * 3);
        double inverseslope = -1.0 / slope;
        double pbdx = Math.sqrt(pushbackdistance * pushbackdistance / (1.0 + inverseslope * inverseslope));
        double pbdy = inverseslope * pbdx;
        if (Math.random() < 0.5) {
            pbdx = -pbdx;
            pbdy = -pbdy;
        }
        boolean intersect = false;
        double x = road.getStartX() + dx * percent + pbdx;
        double y = road.getStartY() + dy * percent + pbdy;
        double scale = f.getScale();
        if (scale <= 0.0) {
            scale = f.getType().getIconSize();
        }
        if ((scaleht = f.getScaleHt()) <= 0.0) {
            scaleht = f.getType().getIconHeight();
        }
        if (!onroad) {
            x = mapwidth * Math.random();
            y = mapheight * Math.random();
        }
        if (selectedAreaPolygon != null && !selectedAreaPolygon.contains(x, y)) {
            return -1;
        }
        String fkey = f.getTypeName().toLowerCase().replaceAll(" ", "_");
        double distance = 5000.0;
        if (cityCenter != null) {
            distance = cityCenter.distance(x, y);
            for (String buildingkey : CityDataGenerator.settlementData.buildings.keySet()) {
                String bkey = buildingkey.toLowerCase().replaceAll(" ", "_");
                if (!fkey.contains(bkey)) continue;
                SettlementData.Building b = CityDataGenerator.settlementData.buildings.get(buildingkey);
                if (b.getPlacement().equalsIgnoreCase("near") && distance > (double)(300 * b.getDistance())) {
                    return -1;
                }
                if (!b.getPlacement().equalsIgnoreCase("away") || !(distance < (double)(300 * b.getDistance()))) break;
                return -1;
            }
        }
        if (x - f.getScale() * 300.0 / 2.0 < 0.0 || x + f.getScale() * 300.0 / 2.0 > mapwidth - 300.0 || y - scaleht * 300.0 / 2.0 < 0.0 || y + scaleht * 300.0 / 2.0 > mapheight - 300.0) {
            intersect = true;
        }
        f.setLocation(ViewLevel.SETTLEMENT, new Point2D(x, y));
        Shape buildingShape = GenerateCityTask.calculateBuildingShape(f, 10);
        Shape tightBuildingShape = null;
        if (dense) {
            tightBuildingShape = GenerateCityTask.calculateBuildingShape(f, 0);
        }
        Shape wideBuildingShape = GenerateCityTask.calculateBuildingShape(f, 30);
        List<MapShape> shapes = mapUI.getMapData().getShapes();
        for (MapShape ms : shapes) {
            if (!ms.getTags().contains("coast") && !ms.getTags().contains("river")) continue;
            Shape s = ms.getShape();
            for (int i = 0; i < 4; ++i) {
                Shape inter2 = Shape.intersect((Shape)s, (Shape)buildingShape);
                if (!(inter2 instanceof Path) || ((Path)inter2).getElements().size() == 0) continue;
                intersect = true;
                ++buildingFailsCoastRiver;
                break;
            }
            if (!intersect) continue;
            break;
        }
        if (!intersect) {
            for (Line r : roads) {
                inter = Shape.intersect((Shape)r, (Shape)wideBuildingShape);
                if (!(inter instanceof Path) || ((Path)inter).getElements().size() == 0) continue;
                intersect = true;
                ++buildingFailsRoad;
                break;
            }
        }
        if (!intersect) {
            if (dense) {
                buildingShape = tightBuildingShape;
            }
            for (Shape existingBuildingShape : buildingborderlines) {
                inter = Shape.intersect((Shape)existingBuildingShape, (Shape)buildingShape);
                if (!(inter instanceof Path) || ((Path)inter).getElements().size() == 0) continue;
                intersect = true;
                ++buildingFailsOtherBuilding;
                break;
            }
        }
        if (!intersect) {
            if (pbdy > 0.0) {
                f.setRotate((f.getRotate() + 180.0) % 360.0);
            }
            features.add(f);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, f, null, null, null, null, null));
            buildingborderlines.add(buildingShape);
            Note n = new Note(ViewLevel.SETTLEMENT, x, y);
            String letterx = letters[(int)(x / mapwidth * 26.0)];
            String lettery = letters[(int)(y / mapheight * 26.0)];
            Integer code = buildingcodes.get(letterx + lettery);
            code = code == null ? Integer.valueOf(1) : Integer.valueOf(code + 1);
            buildingcodes.put(letterx + lettery, code);
            String name = CityDataGenerator.getName(f.getTypeName());
            n.setTitle(letterx + lettery + code + " " + name);
            Object labelText = name.trim();
            if (labelOptions.equals("Name") || labelOptions.equals("Name & Coord")) {
                if (((String)labelText).contains("(")) {
                    labelText = ((String)labelText).substring(0, ((String)labelText).indexOf("(")).trim();
                }
                if (((String)labelText).toLowerCase(Locale.ROOT).startsWith("structure")) {
                    labelText = ((String)labelText).substring(10);
                }
                if (((String)labelText).toLowerCase(Locale.ROOT).startsWith("medieval")) {
                    labelText = ((String)labelText).substring(9);
                }
                if (((String)labelText).toLowerCase(Locale.ROOT).startsWith("modern")) {
                    labelText = ((String)labelText).substring(7);
                }
                if (((String)labelText).toLowerCase(Locale.ROOT).startsWith("western")) {
                    labelText = ((String)labelText).substring(8);
                }
                if (((String)labelText).lastIndexOf(32) == ((String)labelText).length() - 2 || ((String)labelText).lastIndexOf(32) == ((String)labelText).length() - 3) {
                    labelText = ((String)labelText).substring(0, ((String)labelText).lastIndexOf(32));
                }
                if (((String)(labelText = ((String)labelText).trim())).endsWith("Narrow")) {
                    labelText = ((String)labelText).substring(0, ((String)labelText).lastIndexOf(32));
                }
                if (((String)labelText).contains("House")) {
                    labelText = "";
                }
            }
            if (labelOptions.equals("Name & Coord")) {
                labelText = letterx + lettery + code + (String)labelText;
            } else if (labelOptions.equals("None")) {
                labelText = "";
            } else if (labelOptions.equals("Coordinate")) {
                labelText = letterx + lettery + code;
            }
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Structure ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Medieval ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Modern ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Fantasy ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Settlement ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Mappack ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Post-apocalypse ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Settlement-apocalypse ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Settlement-modern ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Settlement-futuristic ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future-clean ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future Clean ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "future Clean ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future-gritty ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "future Gritty ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future Gritty ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future-retro ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "Future Retro ");
            labelText = GenerateCityTask.removeUnneededTextInLabel((String)labelText, "future Retro ");
            f.setLabel(new MapLabel("Building", (String)labelText, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "town political", labellayer));
            n.setDetails(MapLogic.createStructureNoteDetails(f.getTypeName(), x, y));
            n.setParent(f);
            mapUI.getMapData().getNotes().add(n);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.NOTE, n, null, null, null, null, null));
            Map<String, NoteTable> noteTableMap = n.getTableData();
            int population = 0;
            for (String key : noteTableMap.keySet()) {
                NoteTable noteTable = noteTableMap.get(key);
                if (noteTable.getHeadings().getH().equals("") || key.toLowerCase().contains("staff") || key.toLowerCase().contains("patrons") || key.toLowerCase().contains("employees")) continue;
                population += noteTable.getData().size();
            }
            return population;
        }
        return -1;
    }

    private static String removeUnneededTextInLabel(String labelText, String searchFor) {
        if (((String)labelText).contains(searchFor)) {
            int loc = ((String)labelText).indexOf(searchFor);
            labelText = ((String)labelText).substring(0, loc) + ((String)labelText).substring(loc + searchFor.length());
        }
        return labelText;
    }

    private static Shape calculateBuildingShape(Feature f, int modifier) {
        double rotation = Math.toRadians(f.getRotate());
        double x = f.getLocation(ViewLevel.SETTLEMENT).getX();
        double y = f.getLocation(ViewLevel.SETTLEMENT).getY();
        double halfw = 150.0 * f.getType().getIconSize() + (double)modifier;
        double halfh = 150.0 * f.getType().getIconHeight() + (double)modifier;
        double x1 = -halfw;
        double y1 = -halfh;
        double y2 = -halfh;
        double x4 = -halfw;
        double x1p = x + x1 * Math.cos(rotation) - y1 * Math.sin(rotation);
        double y1p = y + y1 * Math.cos(rotation) + x1 * Math.sin(rotation);
        double x2p = x + halfw * Math.cos(rotation) - y2 * Math.sin(rotation);
        double y2p = y + y2 * Math.cos(rotation) + halfw * Math.sin(rotation);
        double x3p = x + halfw * Math.cos(rotation) - halfh * Math.sin(rotation);
        double y3p = y + halfh * Math.cos(rotation) + halfw * Math.sin(rotation);
        double x4p = x + x4 * Math.cos(rotation) - halfh * Math.sin(rotation);
        double y4p = y + halfh * Math.cos(rotation) + x4 * Math.sin(rotation);
        Polygon p = new Polygon();
        p.getPoints().add((Object)x1p);
        p.getPoints().add((Object)y1p);
        p.getPoints().add((Object)x2p);
        p.getPoints().add((Object)y2p);
        p.getPoints().add((Object)x3p);
        p.getPoints().add((Object)y3p);
        p.getPoints().add((Object)x4p);
        p.getPoints().add((Object)y4p);
        p.setFill((Paint)Color.RED);
        return p;
    }

    private static void addStraightRoadOrWallBetweenTowers(UndoActionGroup uag, MapUI mapUI, Feature previous, Feature f, MapLayer ml, String texture, boolean isRoads) {
        Path p = new Path();
        p.getElements().add((Object)new MoveTo(f.getLocation(mapUI.getViewLevel()).getX(), f.getLocation(mapUI.getViewLevel()).getY()));
        p.getElements().add((Object)new LineTo(previous.getLocation(mapUI.getViewLevel()).getX(), previous.getLocation(mapUI.getViewLevel()).getY()));
        MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, isRoads ? "road" : "wall", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        p.setStrokeWidth(isRoads ? 0.25 : 0.12);
        ms.setStrokeTexture(TextureType.ALL_TEXTURES.get(texture));
        ImagePattern newtexture = new ImagePattern(TextureType.ALL_TEXTURES.get(texture).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        p.setStroke((Paint)newtexture);
        p.setStrokeLineCap(StrokeLineCap.ROUND);
        mapUI.getMapData().getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        List<Line> mainroads = GenerateCityTask.getRoadSegments(mapUI.getMapData(), false);
        if (!isRoads) {
            for (Line mainroad : mainroads) {
                Point2D intersectpoint = MapLogic.intersection(mainroad.getStartX(), mainroad.getStartY(), mainroad.getEndX(), mainroad.getEndY(), f.getLocation(mapUI.getViewLevel()).getX(), f.getLocation(mapUI.getViewLevel()).getY(), previous.getLocation(mapUI.getViewLevel()).getX(), previous.getLocation(mapUI.getViewLevel()).getY());
                if (intersectpoint == null) continue;
                double slope = (mainroad.getStartY() - mainroad.getEndY()) / (mainroad.getStartX() - mainroad.getEndX());
                Feature gatehouse = new Feature("Structure/Medieval Gatehouse", true, false, false, false, null, Math.toDegrees(Math.atan(slope)) + 90.0, null, -1.0, -1.0, null, "building gatehouse", true, true, true, true, ml);
                gatehouse.setLocation(mapUI.getViewLevel(), new Point2D(intersectpoint.getX(), intersectpoint.getY()));
                mapUI.getMapData().getFeatures().add(0, gatehouse);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, gatehouse, null, null, null, null, null));
            }
        }
    }

    private static int makeBranchingStreet(UndoActionGroup uag, StreetGenConfig sgc, Point2D intersectionPoint, int maxchange, int randomsize, int basesize, double streetWidth, MapData data, List<Line> roadsegments, List<Line> wallsegments, List<Shape> water, boolean minimzereconnections, Object texturetypeorcolor, MapLayer ml) {
        Line segment;
        double distancefromintersect;
        if (roadsegments.size() == 0) {
            // empty if block
        }
        if ((distancefromintersect = intersectionPoint.distance((segment = roadsegments.get((int)(Math.random() * (double)roadsegments.size()))).getStartX(), segment.getStartY())) > Math.random() * (double)sgc.mapWidth / 2.0) {
            return -1;
        }
        double slope = (segment.getEndY() - segment.getStartY()) / (segment.getEndX() - segment.getStartX());
        int distance = (int)(Math.random() * 600.0 - 300.0 + sgc.segmentLength * 300.0 * (Math.random() * (double)randomsize));
        double tangentslope = -1.0 / slope;
        Double angle = Math.atan(tangentslope);
        if (angle.equals(Double.NaN)) {
            angle = 1.5707963267948966;
        }
        angle = angle - 0.19634954084936207 + Math.random() * Math.PI / 8.0;
        int x = (int)(Math.cos(angle) * (double)distance);
        int y = (int)(Math.sin(angle) * (double)distance);
        if (Math.random() < 0.5) {
            x = (int)segment.getStartX() - x;
            y = (int)segment.getStartY() - y;
        } else {
            x = (int)segment.getStartX() + x;
            y = (int)segment.getStartY() + y;
        }
        if (x < 0 || x > sgc.mapWidth || y < 0 || y > sgc.mapHeight) {
            return -1;
        }
        for (Line l : wallsegments) {
            if (MapLogic.intersection(l.getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), segment.getStartX(), segment.getStartY(), x, y) == null) continue;
            return -1;
        }
        for (Shape s : water) {
            List<Point2D> pts = MapShape.getShapePoints(s);
            for (int i = 0; i < pts.size() - 1; ++i) {
                if (MapLogic.intersection(pts.get(i).getX(), pts.get(i).getY(), pts.get(i + 1).getX(), pts.get(i + 1).getY(), segment.getStartX(), segment.getStartY(), x, y) == null) continue;
                return -1;
            }
            if (!(s instanceof Polygon)) continue;
            if (MapLogic.intersection(pts.get(pts.size() - 1).getX(), pts.get(pts.size() - 1).getY(), pts.get(0).getX(), pts.get(0).getY(), segment.getStartX(), segment.getStartY(), x, y) != null) {
                return -1;
            }
            if (!s.contains(segment.getStartX(), segment.getStartY()) && !s.contains((double)x, (double)y)) continue;
            return -1;
        }
        Path p = new Path();
        p.getElements().add((Object)new MoveTo(segment.getStartX(), segment.getStartY()));
        p.getElements().add((Object)new LineTo((double)x, (double)y));
        if (segment.getStartX() < 300.0 || segment.getStartX() > (double)(sgc.mapWidth - 300) || x < 300 || x > sgc.mapWidth - 300 || segment.getStartY() < 300.0 || segment.getStartY() > (double)(sgc.mapHeight - 300) || y < 300 || y > sgc.mapHeight - 300) {
            return -1;
        }
        p = MapLogic.fractalize(p, 650, 0.3);
        MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        p.setStrokeWidth(streetWidth);
        if (texturetypeorcolor instanceof TextureType) {
            ms.setStrokeTexture((TextureType)texturetypeorcolor);
            ImagePattern newtexture = new ImagePattern(((TextureType)texturetypeorcolor).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
            p.setStroke((Paint)newtexture);
        } else {
            p.setStroke((Paint)((Color)texturetypeorcolor));
        }
        Point2D pt1 = null;
        Point2D pt2 = null;
        ArrayList<Line> tempsegments = new ArrayList<Line>();
        GenerateCityTask.getRoadSegmentsHelper(tempsegments, ms);
        double toocloselimit = 570.0;
        for (Line l : tempsegments) {
            for (Line asegment : roadsegments) {
                boolean tooclose;
                pt1 = new Point2D(asegment.getStartX(), asegment.getStartY());
                pt2 = new Point2D(asegment.getEndX(), asegment.getEndY());
                double pt1startdistance = pt1.distance(l.getStartX(), l.getStartY());
                double pt1enddistance = pt1.distance(l.getEndX(), l.getEndY());
                double pt2startdistance = pt2.distance(l.getStartX(), l.getStartY());
                double pt2enddistance = pt2.distance(l.getEndX(), l.getEndY());
                int tooclosecount = 0;
                if (pt1startdistance < toocloselimit / 2.0 && pt1startdistance > 3.0 || pt1enddistance < toocloselimit / 2.0 && pt1enddistance > 3.0) {
                    ++tooclosecount;
                } else if (pt1startdistance < toocloselimit && pt1startdistance > 3.0 || pt1enddistance < toocloselimit && pt1enddistance > 3.0) {
                    if (minimzereconnections) {
                        ++tooclosecount;
                    } else {
                        tooclose = GenerateCityTask.isSlopeTooClose(l, asegment);
                        if (tooclose) {
                            ++tooclosecount;
                        }
                    }
                }
                if (pt2startdistance < toocloselimit / 2.0 && pt2startdistance > 3.0 || pt2enddistance < toocloselimit / 2.0 && pt2enddistance > 3.0) {
                    ++tooclosecount;
                } else if (pt2startdistance < toocloselimit && pt2startdistance > 3.0 || pt2enddistance < toocloselimit && pt2enddistance > 3.0) {
                    if (minimzereconnections) {
                        ++tooclosecount;
                    } else {
                        tooclose = GenerateCityTask.isSlopeTooClose(l, asegment);
                        if (tooclose) {
                            ++tooclosecount;
                        }
                    }
                }
                if (tooclosecount <= 0) continue;
                return -1;
            }
        }
        data.getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        roadsegments.addAll(tempsegments);
        return 1;
    }

    private static boolean isSlopeTooClose(Line asegment, Line bsegment) {
        double aslope = (asegment.getEndY() - asegment.getStartY()) / (asegment.getEndX() - asegment.getStartX());
        double bslope = (bsegment.getEndY() - bsegment.getStartY()) / (bsegment.getEndX() - bsegment.getStartX());
        Double aangle = Math.toDegrees(Math.atan(aslope));
        Double bangle = Math.toDegrees(Math.atan(bslope));
        double diff = Math.abs(aangle - bangle);
        return diff < 30.0;
    }

    private static void putInSegmentMap(TreeMap<Double, Line> segments, Line lnew2) {
        double length = GenerateCityTask.getLineLength(lnew2);
        while (segments.containsKey(length)) {
            length += Math.random();
        }
        segments.put(length, lnew2);
    }

    private static double getLineLength(Line la) {
        return Math.sqrt((la.getEndY() - la.getStartY()) * (la.getEndY() - la.getStartY()) + (la.getEndX() - la.getStartX()) * (la.getEndX() - la.getStartX()));
    }

    protected MapDataSetup call() throws InterruptedException {
        MapShape coast;
        boolean hasriver;
        boolean hascoast;
        this.updateMessage("City Generator task begun.");
        double width = this.mapUI.computeTotalMapWidthPixelsBaseTileSize();
        double height = this.mapUI.computeTotalMapHeightPixelsBaseTileSize();
        UndoActionGroup uag = new UndoActionGroup();
        Point2D intersectionPoint = null;
        if (!this.isCancelled() && (this.citygen == CITYGEN.ALL || this.citygen == CITYGEN.COAST) && (hascoast = this.setup.city.hasCoast)) {
            this.updateMessage("Creating coast...");
            this.generateCoastline(uag, width, height, this.setup.city.coastStart, this.setup.city.coastEnd, this.mapUI.getMapData().getMapLayer("Above Terrain"));
            this.updateMessage("Creating coast done.");
        }
        if (!this.isCancelled() && (this.citygen == CITYGEN.ALL || this.citygen == CITYGEN.RIVER) && (hasriver = this.setup.city.hasRiver)) {
            this.updateMessage("Creating river...");
            this.generateRiver(uag, width, height, this.setup.city.riverStart, this.setup.city.riverEnd, this.mapUI.getMapData().getMapLayer("Above Terrain"));
            this.updateMessage("Creating river done.");
        }
        TextureType roadTexture = null;
        Color roadColor = null;
        if ("texture".equals(this.setup.city.roadtype)) {
            roadTexture = this.setup.city.roadtexture;
        } else {
            roadColor = this.setup.city.roadcolor;
        }
        if (!(this.isCancelled() || this.citygen != CITYGEN.ALL && this.citygen != CITYGEN.MAINROADS)) {
            this.updateMessage("Creating main roads...");
            Double windiness = this.setup.city.windiness;
            Boolean tangent = this.setup.city.mainRoadsPerpendicular;
            boolean mainRoadsSuccess = this.generateMainRoads(uag, this.mapUI.getMapData(), this.setup, 0.3, intersectionPoint, width, height, roadTexture, roadColor, windiness, tangent, this.mapUI.getMapData().getMapLayer("Above Terrain"));
            if (!mainRoadsSuccess) {
                this.updateMessage("Main roads intersection was too close to the map's edge. Try again with different main road clock positions.");
                this.cancel();
            } else {
                this.updateMessage("Creating main roads done.");
            }
        }
        if (!this.isCancelled()) {
            if (intersectionPoint == null) {
                intersectionPoint = this.getMainRoadsIntersectionPoint();
            }
            if (this.citygen == CITYGEN.ALL || this.citygen == CITYGEN.WALL) {
                boolean haswall;
                this.updateMessage("Creating wall...");
                coast = null;
                for (MapShape ms : this.mapUI.getMapData().getShapes()) {
                    if (!ms.getTags().contains("coast")) continue;
                    coast = ms;
                    break;
                }
                if (haswall = this.setup.city.hasWall) {
                    Integer walltowers = this.setup.city.wallTowers;
                    Integer wallradius = this.setup.city.wallRadius;
                    this.generateStraightRoadOrWall(uag, width, height, walltowers, wallradius * 300, intersectionPoint, this.mapUI, this.mapUI.getMapData().getMapLayer("Features"), Math.random(), "Cobblestone", false, coast, null);
                }
            }
        }
        if (!(this.isCancelled() || this.citygen != CITYGEN.ALL && this.citygen != CITYGEN.STREETS)) {
            this.updateMessage("Creating " + String.valueOf((Object)this.setup.city.streetLayout) + " streets...");
            coast = null;
            for (MapShape ms : this.mapUI.getMapData().getShapes()) {
                if (!ms.getTags().contains("coast")) continue;
                coast = ms;
                break;
            }
            StreetGenConfig sgc = new StreetGenConfig();
            sgc.numLongerStreets = (int)((double)this.setup.city.numStreets.intValue() / 10.0 * 3.0);
            sgc.numShorterStreets = (int)((double)this.setup.city.numStreets.intValue() / 10.0 * 7.0);
            sgc.numStreets = this.setup.city.numStreets;
            sgc.numStreetLinks = 7;
            sgc.skipChance = this.setup.city.skipChance.intValue();
            sgc.variance = 0;
            sgc.segmentLength = 5.0;
            sgc.circular = Math.random() < 0.5;
            sgc.mapWidth = (int)this.mapUI.computeTotalMapWidthPixelsBaseTileSize();
            sgc.mapHeight = (int)this.mapUI.computeTotalMapHeightPixelsBaseTileSize();
            ArrayList<Shape> mainroads = new ArrayList<Shape>();
            ArrayList<Shape> waterfeatures = new ArrayList<Shape>();
            for (MapShape ms : this.mapUI.getMapData().getShapes()) {
                if (ms.getTags().contains("main road")) {
                    mainroads.add(ms.getShape());
                }
                if (ms.getTags().contains("coast")) {
                    waterfeatures.add(ms.getShape());
                }
                if (!ms.getTags().contains("river")) continue;
                waterfeatures.add(ms.getShape());
            }
            this.generateStreets(uag, this.setup.city.streetLayout, sgc, intersectionPoint, 0.25, this.mapUI, mainroads, waterfeatures, roadTexture, this.mapUI.getMapData().getMapLayer("Above Terrain"), width, height, roadTexture, coast);
        }
        if (!(this.isCancelled() || this.citygen != CITYGEN.ALL && this.citygen != CITYGEN.BUILDINGS)) {
            boolean dense = this.setup.city.dense;
            Integer extraPushBack = this.setup.city.extraPushBack;
            MapLayer labellayer = this.mapUI.getMapData().getMapLayer("Labels");
            if (labellayer == null) {
                this.mapUI.getMapData().getMapLayer("Features");
            }
            this.placeBuildings(uag, width, height, extraPushBack, this.mapUI.getMapData().getFeatures(), this.setup.city.population, intersectionPoint, dense, this.mapUI.getMapData().getMapLayer("Features"), labellayer, this.setup.selectedAreaPoly, this.setup.city.buildingLabels);
        }
        if (!(this.isCancelled() || this.citygen != CITYGEN.ALL && this.citygen != CITYGEN.VEGETATION)) {
            this.updateMessage("Creating vegetation...");
            Integer deciduous = this.setup.city.deciduous;
            Integer evergreen = this.setup.city.evergreen;
            Integer tropical = this.setup.city.tropical;
            if (deciduous != 0 || evergreen != 0 || tropical != 0) {
                MapLayer veglayer = this.mapUI.getMapData().getMapLayer("Vegetation");
                if (veglayer == null) {
                    veglayer = new MapLayer("Vegetation");
                    List<MapLayer> layers = this.mapUI.getMapData().getMapLayers();
                    for (int i = 0; i < layers.size(); ++i) {
                        if (!layers.get(i).getName().equals("Features")) continue;
                        layers.add(i + 1, veglayer);
                        this.mapUI.getMapData().getMapLayers().add(i + 1, veglayer);
                        break;
                    }
                }
                this.placeVegetation(uag, width, height, this.mapUI.getMapData().getFeatures(), deciduous, evergreen, tropical, intersectionPoint, veglayer);
            }
            this.updateMessage("Creating vegetation done.");
        }
        this.mapUI.getController().getUndoRedoHandler().push(uag);
        if (this.isCancelled()) {
            this.updateMessage("Cancelled.");
        }
        return this.setup;
    }

    public void generateRiver(UndoActionGroup uag, double width, double height, double start, double end, MapLayer ml) {
        int i;
        double y;
        double x;
        if (start == end) {
            return;
        }
        if (end < start) {
            double temp = end;
            end = start;
            start = temp;
        }
        ArrayList<Double> pts = new ArrayList<Double>();
        if (start == 0.0) {
            pts.add(width / 2.0);
            pts.add(-height / 10.0);
        }
        if (start == 1.0) {
            pts.add(width * 3.0 / 4.0);
            pts.add(-height / 10.0);
        }
        if (start == 2.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height / 4.0);
        }
        if (start == 3.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height / 2.0);
        }
        if (start == 4.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height * 3.0 / 4.0);
        }
        if (start == 5.0) {
            pts.add(width * 3.0 / 4.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (start == 6.0) {
            pts.add(width / 2.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (start == 7.0) {
            pts.add(width / 4.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (start == 8.0) {
            pts.add(-width / 10.0);
            pts.add(height * 3.0 / 4.0);
        }
        if (start == 9.0) {
            pts.add(-width / 10.0);
            pts.add(height / 2.0);
        }
        if (start == 10.0) {
            pts.add(-width / 10.0);
            pts.add(height / 4.0);
        }
        if (start == 11.0) {
            pts.add(width / 4.0);
            pts.add(-height / 10.0);
        }
        if (end == 0.0) {
            pts.add(width / 2.0);
            pts.add(-height / 10.0);
        }
        if (end == 1.0) {
            pts.add(width * 3.0 / 4.0);
            pts.add(-height / 10.0);
        }
        if (end == 2.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height / 4.0);
        }
        if (end == 3.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height / 2.0);
        }
        if (end == 4.0) {
            pts.add(width * 11.0 / 10.0);
            pts.add(height * 3.0 / 4.0);
        }
        if (end == 5.0) {
            pts.add(width * 3.0 / 4.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (end == 6.0) {
            pts.add(width / 2.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (end == 7.0) {
            pts.add(width / 4.0);
            pts.add(height * 11.0 / 10.0);
        }
        if (end == 8.0) {
            pts.add(-width / 10.0);
            pts.add(height * 3.0 / 4.0);
        }
        if (end == 9.0) {
            pts.add(-width / 10.0);
            pts.add(height / 2.0);
        }
        if (end == 10.0) {
            pts.add(-width / 10.0);
            pts.add(height / 4.0);
        }
        if (end == 11.0) {
            pts.add(width / 4.0);
            pts.add(-height / 10.0);
        }
        if (Math.random() < 1.0) {
            x = ((Double)pts.get(pts.size() - 2) - (Double)pts.get(0)) / 3.0 + (Double)pts.get(0);
            y = ((Double)pts.get(pts.size() - 1) - (Double)pts.get(1)) / 3.0 + (Double)pts.get(1);
            x = x - 2400.0 + Math.random() * 4800.0;
            y = y - 2400.0 + Math.random() * 4800.0;
            pts.add(pts.size() - 2, x);
            pts.add(pts.size() - 2, y);
        }
        if (Math.random() < 1.0) {
            x = ((Double)pts.get(pts.size() - 2) - (Double)pts.get(0)) / 2.0 + (Double)pts.get(0);
            y = ((Double)pts.get(pts.size() - 1) - (Double)pts.get(1)) / 2.0 + (Double)pts.get(1);
            x = x - 2400.0 + Math.random() * 4800.0;
            y = y - 2400.0 + Math.random() * 4800.0;
            pts.add(pts.size() - 2, x);
            pts.add(pts.size() - 2, y);
        }
        if (Math.random() < 1.0) {
            x = ((Double)pts.get(pts.size() - 2) - (Double)pts.get(0)) * 2.0 / 3.0 + (Double)pts.get(0);
            y = ((Double)pts.get(pts.size() - 1) - (Double)pts.get(1)) * 2.0 / 3.0 + (Double)pts.get(1);
            x = x - 2400.0 + Math.random() * 4800.0;
            y = y - 2400.0 + Math.random() * 4800.0;
            pts.add(pts.size() - 2, x);
            pts.add(pts.size() - 2, y);
        }
        ArrayList<Double> firstpts = new ArrayList<Double>();
        ArrayList<Double> returnpts = new ArrayList<Double>();
        for (i = 0; i < pts.size(); i += 2) {
            double ddy;
            double ddx;
            if (((Double)pts.get(1)).equals(pts.get(pts.size() - 1))) {
                ddx = (Double)pts.get(0) - (Double)pts.get(2);
                ddy = 0.0;
            } else if (i == 0) {
                ddx = (Double)pts.get(0) - (Double)pts.get(2);
                ddy = (Double)pts.get(1) - (Double)pts.get(3);
            } else if (i == pts.size() - 2) {
                ddx = (Double)pts.get(i - 2) - (Double)pts.get(i);
                ddy = (Double)pts.get(i - 1) - (Double)pts.get(i + 1);
            } else {
                ddx = (Double)pts.get(i - 2) - (Double)pts.get(i + 2);
                ddy = (Double)pts.get(i - 1) - (Double)pts.get(i + 3);
            }
            double slope = ddy / ddx;
            if (slope == Double.NaN) {
                slope = Double.MAX_VALUE;
            }
            double inverseslope = -1.0 / slope;
            if (slope == 0.0) {
                inverseslope = 100000.0;
            }
            double pbdx = Math.sqrt(90000.0 / (1.0 + inverseslope * inverseslope));
            double pbdy = inverseslope * pbdx;
            firstpts.add((Double)pts.get(i) + pbdx);
            firstpts.add((Double)pts.get(i + 1) + pbdy);
            returnpts.add((Double)pts.get(i) - pbdx);
            returnpts.add((Double)pts.get(i + 1) - pbdy);
        }
        pts = firstpts;
        for (i = returnpts.size() - 2; i >= 0; i -= 2) {
            pts.add((Double)returnpts.get(i));
            pts.add((Double)returnpts.get(i + 1));
        }
        ArrayList<Double> fractaledpts = new ArrayList<Double>();
        for (int i2 = 0; i2 < pts.size(); i2 += 2) {
            fractaledpts.addAll(MapLogic.fractalize((Double)pts.get(i2 % pts.size()), (Double)pts.get((i2 + 1) % pts.size()), (Double)pts.get((i2 + 2) % pts.size()), (Double)pts.get((i2 + 3) % pts.size()), 600, 0.5, width, height));
        }
        pts = fractaledpts;
        Polygon sea = new Polygon();
        sea.getPoints().addAll(pts);
        MapShape ms = new MapShape(ViewLevel.WORLD, ViewLevel.WORLD, (Shape)sea, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "river", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        sea.setStrokeWidth(0.0);
        sea.setStroke((Paint)Color.WHITE);
        ms.setFillTexture(TextureType.ALL_TEXTURES.get("Water"));
        ImagePattern newtexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Water").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        sea.setFill((Paint)newtexture);
        this.mapUI.getMapData().getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
    }

    public void generateCoastline(UndoActionGroup uag, double width, double height, double fromdegrees, double todegrees, MapLayer ml) {
        ArrayList<Double> pts = new ArrayList<Double>();
        if (todegrees <= fromdegrees) {
            todegrees += 12.0;
        }
        if (fromdegrees <= 0.0 && todegrees >= 0.0) {
            pts.add(width / 2.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 1.0 && todegrees >= 1.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 2.0 && todegrees >= 2.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 3.0 && todegrees >= 3.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 4.0 && todegrees >= 4.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 5.0 && todegrees >= 5.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 6.0 && todegrees >= 6.0) {
            pts.add(width / 2.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 7.0 && todegrees >= 7.0) {
            pts.add(width / 3.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 8.0 && todegrees >= 8.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 9.0 && todegrees >= 9.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 10.0 && todegrees >= 10.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 11.0 && todegrees >= 11.0) {
            pts.add(width / 3.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 12.0 && todegrees >= 12.0) {
            pts.add(width / 2.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 13.0 && todegrees >= 13.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 14.0 && todegrees >= 14.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 15.0 && todegrees >= 15.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 16.0 && todegrees >= 16.0) {
            pts.add(width * 75.0 / 100.0 + width / 5.0 * Math.random());
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 17.0 && todegrees >= 17.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 18.0 && todegrees >= 18.0) {
            pts.add(width / 2.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 19.0 && todegrees >= 19.0) {
            pts.add(width / 3.0);
            pts.add(height * 75.0 / 100.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 20.0 && todegrees >= 20.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 21.0 && todegrees >= 21.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 22.0 && todegrees >= 22.0) {
            pts.add(width / 20.0 + width / 5.0 * Math.random());
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 23.0 && todegrees >= 24.0) {
            pts.add(width / 3.0);
            pts.add(height / 20.0 + height / 5.0 * Math.random());
        }
        if (fromdegrees <= 23.0 && todegrees >= 23.0) {
            pts.add(width / 3.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 22.0 && todegrees >= 23.0) {
            pts.add(-1.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 22.0 && todegrees >= 22.0) {
            pts.add(-1.0);
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 21.0 && todegrees >= 21.0) {
            pts.add(-1.0);
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 20.0 && todegrees >= 20.0) {
            pts.add(-1.0);
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 19.0 && todegrees >= 20.0) {
            pts.add(-1.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 19.0 && todegrees >= 19.0) {
            pts.add(width / 3.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 18.0 && todegrees >= 18.0) {
            pts.add(width / 2.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 17.0 && todegrees >= 17.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 16.0 && todegrees >= 17.0) {
            pts.add(width + 1.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 16.0 && todegrees >= 16.0) {
            pts.add(width + 1.0);
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 15.0 && todegrees >= 15.0) {
            pts.add(width + 1.0);
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 14.0 && todegrees >= 14.0) {
            pts.add(width + 1.0);
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 13.0 && todegrees >= 14.0) {
            pts.add(width + 1.0);
            pts.add(-height / 10.0);
        }
        if (fromdegrees <= 13.0 && todegrees >= 13.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 12.0 && todegrees >= 12.0) {
            if (fromdegrees == 0.0 && todegrees == 12.0) {
                pts.add(width * 0.55);
            } else {
                pts.add(width / 2.0);
            }
            pts.add(-1.0);
        }
        if (fromdegrees <= 11.0 && todegrees >= 11.0) {
            pts.add(width / 3.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 10.0 && todegrees >= 11.0) {
            pts.add(-1.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 10.0 && todegrees >= 10.0) {
            pts.add(-1.0);
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 9.0 && todegrees >= 9.0) {
            pts.add(-1.0);
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 8.0 && todegrees >= 8.0) {
            pts.add(-1.0);
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 7.0 && todegrees >= 8.0) {
            pts.add(-1.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 7.0 && todegrees >= 7.0) {
            pts.add(width / 3.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 6.0 && todegrees >= 6.0) {
            pts.add(width / 2.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 5.0 && todegrees >= 5.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 4.0 && todegrees >= 5.0) {
            pts.add(width + 1.0);
            pts.add(height + 1.0);
        }
        if (fromdegrees <= 4.0 && todegrees >= 4.0) {
            pts.add(width + 1.0);
            pts.add(height * 2.0 / 3.0);
        }
        if (fromdegrees <= 3.0 && todegrees >= 3.0) {
            pts.add(width + 1.0);
            pts.add(height / 2.0);
        }
        if (fromdegrees <= 2.0 && todegrees >= 2.0) {
            pts.add(width + 1.0);
            pts.add(height / 3.0);
        }
        if (fromdegrees <= 1.0 && todegrees >= 2.0) {
            pts.add(width + 1.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 1.0 && todegrees >= 1.0) {
            pts.add(width * 2.0 / 3.0);
            pts.add(-1.0);
        }
        if (fromdegrees <= 0.0 && todegrees >= 0.0) {
            if (fromdegrees == 0.0 && todegrees == 12.0) {
                pts.add(width * 0.45);
            } else {
                pts.add(width / 2.0);
            }
            pts.add(-1.0);
        }
        ArrayList<Double> fractaledpts = new ArrayList<Double>();
        for (int i = 0; i < pts.size(); i += 2) {
            fractaledpts.addAll(MapLogic.fractalize((Double)pts.get(i % pts.size()), (Double)pts.get((i + 1) % pts.size()), (Double)pts.get((i + 2) % pts.size()), (Double)pts.get((i + 3) % pts.size()), 300, 2.0, width, height));
        }
        pts = fractaledpts;
        Polygon sea = new Polygon();
        sea.getPoints().addAll(pts);
        MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)sea, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "coast", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        ms.setFillTexture(TextureType.ALL_TEXTURES.get("Water"));
        ImagePattern newtexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Water").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        sea.setFill((Paint)newtexture);
        sea.setStrokeWidth(0.0);
        sea.setStroke((Paint)Color.PALEGOLDENROD);
        this.mapUI.getMapData().getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        Path coastline = new Path();
        for (int i = 0; i < pts.size(); i += 2) {
            boolean nextptoffmap;
            double x1 = (Double)pts.get(i);
            double y1 = (Double)pts.get(i + 1);
            boolean pt1offmap = x1 < 0.0 || y1 < 0.0 || x1 > width || y1 > height;
            double xprior = (Double)pts.get((i - 2 + pts.size()) % pts.size());
            double yprior = (Double)pts.get((i - 1 + pts.size()) % pts.size());
            boolean priorptoffmap = xprior < 0.0 || yprior < 0.0 || xprior > width || yprior > height;
            double xnext = (Double)pts.get((i + 2) % pts.size());
            double ynext = (Double)pts.get((i + 3) % pts.size());
            boolean bl = nextptoffmap = xnext < 0.0 || ynext < 0.0 || xnext > width || ynext > height;
            if (pt1offmap && priorptoffmap && nextptoffmap) {
                coastline.getElements().add((Object)new MoveTo(((Double)pts.get(i)).doubleValue(), ((Double)pts.get(i + 1)).doubleValue()));
                continue;
            }
            coastline.getElements().add((Object)new LineTo(((Double)pts.get(i)).doubleValue(), ((Double)pts.get(i + 1)).doubleValue()));
        }
        Color c = Color.rgb((int)243, (int)235, (int)163, (double)0.7);
        coastline.setStrokeWidth(0.1);
        coastline.setStrokeLineJoin(StrokeLineJoin.ROUND);
        coastline.setStroke((Paint)c);
        MapShape ms2 = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)sea, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "coast", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        ms2.setShape((Shape)coastline);
        this.mapUI.getMapData().getShapes().add(ms2);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms2, null, null, null, null, null));
    }

    /*
     * WARNING - void declaration
     */
    public void placeBuildings(UndoActionGroup uag, double width, double height, int extraPushBack, List<Feature> features, int populationTarget, Point2D cityCenter, boolean dense, MapLayer ml, MapLayer labellayer, Object selectedAreaPolygon, String labelOptions) {
        HashMap<String, Integer> buildingcodes = new HashMap<String, Integer>();
        List<Line> roads = GenerateCityTask.getRoadSegments(this.mapUI.getMapData(), false);
        List<Line> roadsandwalls = GenerateCityTask.getRoadSegments(this.mapUI.getMapData(), true);
        ArrayList<Shape> buildingShapes = new ArrayList<Shape>();
        for (Feature f : this.mapUI.getMapData().getFeatures()) {
            buildingShapes.add(GenerateCityTask.calculateBuildingShape(f, 10));
        }
        TreeMap<Double, FeatureType> numberordertofeaturetypemap = new TreeMap<Double, FeatureType>();
        HashMap<SettlementData.Building, Pair> buildingtonumberordermap = new HashMap<SettlementData.Building, Pair>();
        HashMap<FeatureType, Boolean> featureonroadmap = new HashMap<FeatureType, Boolean>();
        int maxlength = 0;
        for (SettlementData.Building building : CityDataGenerator.settlementData.buildings.values()) {
            maxlength = Math.max(maxlength, building.getName().length());
        }
        int populationcount = 0;
        for (int i = maxlength; i > 0; --i) {
            for (SettlementData.Building building : CityDataGenerator.settlementData.buildings.values()) {
                if (building.getName().length() != i) continue;
                for (FeatureType featureType : Feature.featureTypes.values()) {
                    if (!featureType.getType().toLowerCase().contains("structure/") || !featureType.getType().toLowerCase().contains(building.getName().toLowerCase()) || building.getPerPopulation() <= 0) continue;
                    int numtoadd = populationTarget / building.getPerPopulation();
                    if (numtoadd > 0) {
                        Double num = (double)numtoadd + Math.random();
                        numberordertofeaturetypemap.put(num, featureType);
                        Pair numberAndFeatures = (Pair)buildingtonumberordermap.get(building);
                        if (numberAndFeatures == null) {
                            featuresList = new ArrayList();
                            featuresList.add(featureType);
                            buildingtonumberordermap.put(building, new Pair((Object)num, featuresList));
                        } else {
                            featuresList = (List)numberAndFeatures.getValue();
                            featuresList.add(featureType);
                            buildingtonumberordermap.put(building, new Pair((Object)((Double)numberAndFeatures.getKey()), featuresList));
                        }
                    }
                    featureonroadmap.put(featureType, building.onRoad);
                }
            }
        }
        TreeMap<Double, List> featuresByNumber = new TreeMap<Double, List>();
        for (Pair pair : buildingtonumberordermap.values()) {
            featuresByNumber.put((Double)pair.getKey(), (List)pair.getValue());
        }
        for (Map.Entry entry : featuresByNumber.entrySet()) {
            populationcount = this.placeSpecificBuildings(uag, width, height, extraPushBack, features, cityCenter, dense, ml, labellayer, selectedAreaPolygon, buildingcodes, roads, roadsandwalls, buildingShapes, featureonroadmap, populationTarget, populationcount, entry, labelOptions);
        }
        TreeMap<Double, Line> distancesToRoads = new TreeMap<Double, Line>();
        HashMap<Line, Double> hashMap = new HashMap<Line, Double>();
        for (Line line : roads) {
            double d1 = cityCenter.distance(line.getStartX(), line.getStartY());
            double d2 = cityCenter.distance(line.getEndX(), line.getEndY());
            double distance = (d1 + d2) / 2.0;
            while (distancesToRoads.containsKey(distance)) {
                distance += Math.random();
            }
            distancesToRoads.put(distance, line);
            hashMap.put(line, distance);
        }
        ArrayList<String> matchingremainingbuildings = new ArrayList<String>();
        for (String b : CityDataGenerator.settlementData.remainingBuildings) {
            if (this.isCancelled()) {
                return;
            }
            if (b.equals("")) {
                return;
            }
            if (Feature.featureTypes.containsKey(b = b.toLowerCase())) {
                matchingremainingbuildings.add(b);
                continue;
            }
            for (String f : Feature.featureTypes.keySet()) {
                if (!f.toLowerCase().contains(b)) continue;
                matchingremainingbuildings.add(f);
            }
        }
        if (dense) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String bn : matchingremainingbuildings) {
                if (!bn.contains("Narrow")) continue;
                arrayList.add(bn);
            }
            if (arrayList.size() == 0) {
                ArrayList<String> arrayList2 = matchingremainingbuildings;
            }
            block12: for (int i = populationcount; i < populationTarget / 4; ++i) {
                if (this.isCancelled()) {
                    return;
                }
                Iterator roaditer = distancesToRoads.values().iterator();
                Line road = (Line)roaditer.next();
                int fails = 0;
                while (i < populationTarget / 4 && roaditer.hasNext()) {
                    void var28_40;
                    int priorpop = populationcount;
                    i = this.placeBuildingsHelper(uag, width, height, extraPushBack, features, roads, roadsandwalls, buildingShapes, populationTarget, populationcount, road, 50.0, (List<String>)var28_40, cityCenter, ml, buildingcodes, labellayer, dense, selectedAreaPolygon, labelOptions);
                    road = (Line)roaditer.next();
                    populationcount = i;
                    if (priorpop == populationcount) {
                        ++fails;
                    }
                    if (fails <= 50) continue;
                    continue block12;
                }
            }
        }
        boolean bl = false;
        for (int i = populationcount; i < populationTarget; ++i) {
            void var28_43;
            int priorpop;
            if (this.isCancelled()) {
                return;
            }
            Line road = roads.get((int)((double)roads.size() * Math.random()));
            if (dense) {
                for (int k = 0; k < 2; ++k) {
                    Line road2 = roads.get((int)((double)roads.size() * Math.random()));
                    if (!((Double)hashMap.get(road2) < (Double)hashMap.get(road))) continue;
                    road = road2;
                }
            }
            if ((priorpop = populationcount) == (populationcount = (i = this.placeBuildingsHelper(uag, width, height, extraPushBack, features, roads, roadsandwalls, buildingShapes, populationTarget, populationcount, road, dense ? 100.0 : 5.0, matchingremainingbuildings, cityCenter, ml, buildingcodes, labellayer, false, selectedAreaPolygon, labelOptions)))) {
                ++var28_43;
            }
            if (var28_43 > 1000) break;
        }
        this.updateMessage("Population " + populationcount + "/" + populationTarget + " residents placed.");
    }

    private int placeSpecificBuildings(UndoActionGroup uag, double width, double height, int extraPushBack, List<Feature> features, Point2D cityCenter, boolean dense, MapLayer ml, MapLayer labellayer, Object selectedAreaPolygon, Map<String, Integer> buildingcodes, List<Line> roads, List<Line> roadsandwalls, List<Shape> buildingborderlines, Map<FeatureType, Boolean> featureonroadmap, int populationTarget, int population, Map.Entry<Double, List<FeatureType>> entrylist, String labelOptions) {
        int success = -1;
        int fails = 0;
        int i = 0;
        while ((double)i < entrylist.getKey() - 1.0) {
            block15: {
                Feature f;
                double dy;
                double dx;
                boolean onroad;
                Line road;
                FeatureType entry;
                block14: {
                    int tries2;
                    if (this.isCancelled()) {
                        return population;
                    }
                    List<FeatureType> entries = entrylist.getValue();
                    entry = entries.get((int)(Math.random() * (double)entries.size()));
                    road = roads.get((int)((double)roads.size() * Math.random()));
                    onroad = featureonroadmap.get(entry);
                    dx = road.getEndX() - road.getStartX();
                    dy = road.getEndY() - road.getStartY();
                    if (selectedAreaPolygon == null) break block14;
                    for (tries2 = 0; tries2 < 1000 && !((Shape)selectedAreaPolygon).contains(road.getStartX() + dx, road.getStartY() + dy); ++tries2) {
                        road = roads.get((int)((double)roads.size() * Math.random()));
                        onroad = featureonroadmap.get(entry);
                        dx = road.getEndX() - road.getStartX();
                        dy = road.getEndY() - road.getStartY();
                    }
                    if (tries2 >= 1000) break block15;
                }
                double slope = dy / dx;
                double rotation = Math.atan(slope);
                double percent = Math.random();
                if (dense && (cityCenter.distance(road.getEndX(), road.getEndY()) < 3000.0 || cityCenter.distance(road.getStartX(), road.getStartY()) < 3000.0)) {
                    String key = entry.getType() + " Narrow";
                    FeatureType ft = Feature.featureTypes.get(key);
                    if (ft != null) {
                        entry = ft;
                    } else {
                        key = entry.getType().substring(0, entry.getType().lastIndexOf(32)) + " Narrow";
                        ft = Feature.featureTypes.get(key);
                        if (ft != null) {
                            entry = ft;
                        } else {
                            key = "fail:" + key;
                        }
                    }
                }
                if ((success = GenerateCityTask.placeSingleBuilding(uag, this.mapUI, features, roadsandwalls, buildingborderlines, road, dx, dy, slope, rotation, extraPushBack, percent, f = new Feature(entry.getType(), true, false, false, false, null, Math.toDegrees(rotation), null, -1.0, -1.0, null, "house", true, true, true, true, ml), width, height, onroad, cityCenter, buildingcodes, labellayer, dense, (Shape)selectedAreaPolygon, labelOptions)) >= 0) {
                    if (success == 0) {
                        success = 1;
                    }
                    this.updateMessage("Placing Buildings " + (population += success) + "/" + populationTarget + " residents: " + entry.getType());
                } else {
                    --i;
                    ++fails;
                }
                if (fails == 1000) break;
            }
            ++i;
        }
        return population;
    }

    private int placeBuildingsHelper(UndoActionGroup uag, double width, double height, int extraPushBack, List<Feature> features, List<Line> roads, List<Line> roadsandwalls, List<Shape> buildingborderlines, int populationTarget, int population, Line road, double tries, List<String> matchingremainingbuildings, Point2D cityCenter, MapLayer ml, Map<String, Integer> buildingcodes, MapLayer labellayer, boolean dense, Object selectedAreaPolygon, String labelOptions) {
        double dx = road.getEndX() - road.getStartX();
        double dy = road.getEndY() - road.getStartY();
        if (selectedAreaPolygon != null) {
            for (int tries2 = 0; tries2 < 1000 && !((Shape)selectedAreaPolygon).contains(road.getStartX() + dx, road.getStartY() + dy); ++tries2) {
                road = roads.get((int)((double)roads.size() * Math.random()));
                dx = road.getEndX() - road.getStartX();
                dy = road.getEndY() - road.getStartY();
            }
        }
        double slope = dy / dx;
        double rotation = Math.atan(slope);
        double percent = 0.0;
        String buildingname = matchingremainingbuildings.get((int)((double)matchingremainingbuildings.size() * Math.random()));
        boolean onroad = true;
        SettlementData.Building bdata = CityDataGenerator.settlementData.buildings.get(buildingname);
        if (bdata != null) {
            onroad = bdata.onRoad;
        }
        Feature f = new Feature(buildingname, true, false, false, false, null, Math.toDegrees(rotation), null, -1.0, -1.0, null, "house", true, true, true, true, ml);
        int k = 0;
        while ((double)k < tries) {
            if (this.isCancelled()) {
                return population;
            }
            int success = GenerateCityTask.placeSingleBuilding(uag, this.mapUI, features, roadsandwalls, buildingborderlines, road, dx, dy, slope, rotation, extraPushBack, percent + (double)k / tries, f, width, height, onroad, cityCenter, buildingcodes, labellayer, dense, (Shape)selectedAreaPolygon, labelOptions);
            if (success >= 0) {
                this.updateMessage("Placing Buildings " + (population += success) + "/" + populationTarget + " residents: " + buildingname);
                if (population > populationTarget) break;
                buildingname = matchingremainingbuildings.get((int)((double)matchingremainingbuildings.size() * Math.random()));
                onroad = true;
                bdata = CityDataGenerator.settlementData.buildings.get(buildingname);
                if (bdata != null) {
                    onroad = bdata.onRoad;
                }
                f = new Feature(buildingname, true, false, false, false, null, Math.toDegrees(rotation), null, -1.0, -1.0, null, "house", true, true, true, true, ml);
            }
            ++k;
        }
        return population;
    }

    public void placeVegetation(UndoActionGroup uag, double width, double height, List<Feature> features, int deciduous, int evergreen, int tropical, Point2D intersectionPoint, MapLayer ml) {
        List<Line> roads = GenerateCityTask.getRoadSegments(this.mapUI.getMapData(), true);
        ArrayList<Shape> buildingShapes = new ArrayList<Shape>();
        for (Feature f : this.mapUI.getMapData().getFeatures()) {
            buildingShapes.add(GenerateCityTask.calculateBuildingShape(f, 10));
        }
        int totalpossibletoadd = (int)(width / 300.0 * height / 300.0 / 5.0);
        int numbertoadd = (int)((double)totalpossibletoadd * ((double)deciduous / 100.0 + (double)evergreen / 100.0 + (double)tropical / 100.0));
        double deciduouspercentofforest = (double)deciduous * 1.0 / (double)(tropical + deciduous + evergreen);
        double evergreenpercentofforest = (double)evergreen * 1.0 / (double)(tropical + deciduous + evergreen);
        double tropicalpercentofforest = (double)tropical * 1.0 / (double)(tropical + deciduous + evergreen);
        int count = 0;
        for (int i = 0; i < numbertoadd; ++i) {
            Shape inter;
            this.updateMessage("Creating vegetation " + i + "/" + numbertoadd);
            Point2D pt = new Point2D(width * Math.random(), height * Math.random());
            double distancefromintersection = pt.distance(intersectionPoint);
            double percentfromintersection = distancefromintersection / width / 2.0;
            if (Math.random() > percentfromintersection) {
                --i;
                continue;
            }
            Feature f = null;
            double ran1 = Math.random();
            double ran = Math.random();
            if (ran1 < deciduouspercentofforest) {
                f = ran < 0.55 ? new Feature("Battlemat/Semi-Real Tree", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.7 ? new Feature("Battlemat/Semi-Real Tree Cluster", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.85 ? new Feature("Battlemat/Semi-Real Tree Cluster 2", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : new Feature("Battlemat/Semi-Real Tree Cluster 3", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml)));
            } else if (ran1 < deciduouspercentofforest + evergreenpercentofforest) {
                f = ran < 0.55 ? new Feature("Battlemat/Semi-Real Evergreen", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.7 ? new Feature("Battlemat/Semi-Real Evergreen Cluster", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.85 ? new Feature("Battlemat/Semi-Real Evergreen Cluster 2", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : new Feature("Battlemat/Semi-Real Evergreen Cluster 3", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml)));
            } else if (ran1 < deciduouspercentofforest + evergreenpercentofforest + tropicalpercentofforest) {
                f = ran < 0.55 ? new Feature("Battlemat/Semi-Real Tropical", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.7 ? new Feature("Battlemat/Semi-Real Tropical Cluster", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : (ran < 0.85 ? new Feature("Battlemat/Semi-Real Tropical Cluster 2", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml) : new Feature("Battlemat/Semi-Real Tropical Cluster 3", true, false, false, false, null, Math.random() * 360.0, null, -1.0, -1.0, null, "vegetation", true, true, true, true, ml)));
            }
            if (f == null) continue;
            f.setLocation(ViewLevel.SETTLEMENT, pt);
            Shape vegborder = GenerateCityTask.calculateBuildingShape(f, 10);
            boolean intersect = false;
            for (MapShape ms : this.mapUI.getMapData().getShapes()) {
                Shape s;
                Shape inter2;
                if (!ms.getTags().contains("coast") && !ms.getTags().contains("river") || !((inter2 = Shape.intersect((Shape)(s = ms.getShape()), (Shape)vegborder)) instanceof Path) || ((Path)inter2).getElements().size() == 0) continue;
                intersect = true;
                break;
            }
            if (intersect) {
                --i;
                continue;
            }
            for (Line r : roads) {
                inter = Shape.intersect((Shape)r, (Shape)vegborder);
                if (!(inter instanceof Path) || ((Path)inter).getElements().size() == 0) continue;
                intersect = true;
                break;
            }
            for (Shape existingbuildingline : buildingShapes) {
                inter = Shape.intersect((Shape)existingbuildingline, (Shape)vegborder);
                if (!(inter instanceof Path) || ((Path)inter).getElements().size() == 0) continue;
                intersect = true;
                break;
            }
            if (intersect) {
                --i;
                continue;
            }
            features.add(f);
            ++count;
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, f, null, null, null, null, null));
        }
        this.updateMessage("Vegetation " + count + "/" + numbertoadd + " placed.\nNote: Not all streets/buildings/vegetation is placed.\n(After several collisions with other buildings or\nroads, the system moves on to the next.)");
    }

    public void generateStraightRoadOrWall(UndoActionGroup uag, double wd, double ht, int numtowers, double distancefromintersection, Point2D intersectPoint, MapUI mapUI, MapLayer ml, double degreeStartRatio, String texture, boolean isRoads, MapShape coast, List<Line> wallSegments) {
        Feature fNext;
        int j;
        List<Line> roadSegments = GenerateCityTask.getRoadSegments(mapUI.getMapData(), false);
        Line l1 = roadSegments.get(0);
        Line l2 = roadSegments.get(1);
        block0: while (intersectPoint == null) {
            for (int i = 0; i < roadSegments.size(); ++i) {
                l1 = roadSegments.get(i);
                for (int j2 = 0; j2 < roadSegments.size(); ++j2) {
                    if (i == j2) continue;
                    l2 = roadSegments.get(j2);
                    intersectPoint = MapLogic.intersection(l1.getStartX(), l1.getStartY(), l1.getEndX(), l1.getEndY(), l2.getStartX(), l2.getStartY(), l2.getEndX(), l2.getEndY());
                    if (intersectPoint != null) break;
                }
                if (intersectPoint != null) continue block0;
            }
        }
        double degreesdiff = 360.0 / (double)numtowers;
        double currentdegrees = degreeStartRatio * degreesdiff;
        Object first = null;
        Object previous = null;
        ArrayList<Feature> towers = new ArrayList<Feature>();
        for (int i = 0; i < numtowers; ++i) {
            Feature f = new Feature("Structure/Medieval Walltower", true, false, false, false, null, currentdegrees, null, -1.0, -1.0, null, "building tower", true, true, true, true, ml);
            double x = intersectPoint.getX() + distancefromintersection * Math.cos(Math.toRadians(currentdegrees));
            double y = intersectPoint.getY() + distancefromintersection * (mapUI.getMapData().getTileWidth() / mapUI.getMapData().getTileHeight()) * Math.sin(Math.toRadians(currentdegrees));
            f.setLocation(ViewLevel.SETTLEMENT, new Point2D(x, y));
            if (x < 0.0 || y < 0.0 || x > wd || y > ht) {
                if (!isRoads) {
                    this.updateMessage("Wall not placed--it would extend beyond map.");
                }
                return;
            }
            towers.add(f);
            currentdegrees += degreesdiff;
        }
        HashSet<Feature> newTowers = new HashSet<Feature>();
        for (j = 0; j < towers.size(); ++j) {
            Feature f = (Feature)towers.get(j);
            fNext = (Feature)towers.get((j + 1) % towers.size());
            if (coast == null || !coast.getShape().contains(f.getLocation(ViewLevel.SETTLEMENT)) && !coast.getShape().contains(fNext.getLocation(ViewLevel.SETTLEMENT)) || coast.getShape().contains(f.getLocation(ViewLevel.SETTLEMENT)) && coast.getShape().contains(fNext.getLocation(ViewLevel.SETTLEMENT))) continue;
            List<Point2D> coastPts = coast.getShapePoints();
            Point2D coastIntersect = null;
            for (int i = 1; i < coastPts.size() && (coastIntersect = MapLogic.intersection(coastPts.get(i - 1).getX(), coastPts.get(i - 1).getY(), coastPts.get(i).getX(), coastPts.get(i).getY(), f.getLocation(ViewLevel.SETTLEMENT).getX(), f.getLocation(ViewLevel.SETTLEMENT).getY(), fNext.getLocation(ViewLevel.SETTLEMENT).getX(), fNext.getLocation(ViewLevel.SETTLEMENT).getY())) == null; ++i) {
            }
            if (coastIntersect == null) continue;
            Feature newF = f.clone();
            newF.setLocation(ViewLevel.SETTLEMENT, coastIntersect);
            newTowers.add(newF);
            towers.add(j + 1, newF);
            ++j;
        }
        for (j = 0; j < towers.size(); ++j) {
            Feature f = (Feature)towers.get(j);
            fNext = (Feature)towers.get((j + 1) % towers.size());
            Point2D intersectsWall = null;
            if (coast != null && coast.getShape() != null) {
                if (!(!newTowers.contains(f) && coast.getShape().contains(f.getLocation(ViewLevel.SETTLEMENT)) || !newTowers.contains(fNext) && coast.getShape().contains(fNext.getLocation(ViewLevel.SETTLEMENT)))) {
                    if (wallSegments != null) {
                        Line l;
                        Iterator<Line> iterator = wallSegments.iterator();
                        while (iterator.hasNext() && (intersectsWall = MapLogic.intersection((l = iterator.next()).getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), f.getLocation(ViewLevel.SETTLEMENT).getX(), f.getLocation(ViewLevel.SETTLEMENT).getY(), fNext.getLocation(ViewLevel.SETTLEMENT).getX(), fNext.getLocation(ViewLevel.SETTLEMENT).getY())) == null) {
                        }
                    }
                    if (intersectsWall == null) {
                        GenerateCityTask.addStraightRoadOrWallBetweenTowers(uag, mapUI, f, fNext, ml, texture, isRoads);
                    }
                }
            } else if (intersectsWall == null) {
                GenerateCityTask.addStraightRoadOrWallBetweenTowers(uag, mapUI, f, fNext, ml, texture, isRoads);
            }
            if (isRoads || !newTowers.contains(f) && coast != null && coast.getShape().contains(f.getLocation(ViewLevel.SETTLEMENT))) continue;
            mapUI.getMapData().getFeatures().add(f);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, f, null, null, null, null, null));
        }
        this.updateMessage("Creating " + (isRoads ? "road loop" : "wall") + " done.\n");
    }

    private Point2D getMainRoadsIntersectionPoint() {
        ArrayList<MapShape> mapshapes = new ArrayList<MapShape>();
        for (MapShape ms : this.mapUI.getMapData().getShapes()) {
            if (!ms.getTags().contains("main road")) continue;
            mapshapes.add(ms);
        }
        for (int i = 0; i < mapshapes.size(); ++i) {
            MapShape a = (MapShape)mapshapes.get(i);
            List<Point2D> apts = a.getShapePoints();
            for (int j = 0; j < mapshapes.size(); ++j) {
                if (i == j) continue;
                MapShape b = (MapShape)mapshapes.get(j);
                List<Point2D> bpts = b.getShapePoints();
                for (int m = 0; m < apts.size() - 1; ++m) {
                    for (int n = 0; n < bpts.size() - 1; ++n) {
                        Point2D pt = MapLogic.intersection(apts.get(m).getX(), apts.get(m).getY(), apts.get(m + 1).getX(), apts.get(m + 1).getY(), bpts.get(n).getX(), bpts.get(n).getY(), bpts.get(n + 1).getX(), bpts.get(n + 1).getY());
                        if (pt == null) continue;
                        return pt;
                    }
                }
            }
        }
        return null;
    }

    public void generateStreets(UndoActionGroup uag, SetupCityScreen.LAYOUTS choice, StreetGenConfig sgc, Point2D intersectionPoint, double streetWidth, MapUI mapUI, List<Shape> mainroads, List<Shape> water, Object texturetypeorcolor, MapLayer ml, double width, double height, TextureType roadTexture, MapShape coast) {
        if (SetupCityScreen.LAYOUTS.Random == choice || choice == null) {
            double rnd = Math.random();
            choice = rnd < 0.25 ? SetupCityScreen.LAYOUTS.Branching : (rnd < 0.5 ? SetupCityScreen.LAYOUTS.Haphazard : (rnd < 0.6 ? SetupCityScreen.LAYOUTS.Ordered : (rnd < 0.65 ? SetupCityScreen.LAYOUTS.Very_Ordered : (rnd < 0.7 ? SetupCityScreen.LAYOUTS.Square : (rnd < 0.75 ? SetupCityScreen.LAYOUTS.Pentagon : (rnd < 0.8 ? SetupCityScreen.LAYOUTS.Hexagon : (rnd < 0.85 ? SetupCityScreen.LAYOUTS.Heptagon : (rnd < 0.9 ? SetupCityScreen.LAYOUTS.Octagon : (rnd < 0.75 ? SetupCityScreen.LAYOUTS.Nonagon : SetupCityScreen.LAYOUTS.Decagon)))))))));
        }
        switch (choice) {
            case Haphazard: {
                this.branchingCrossStreets(uag, sgc, intersectionPoint, streetWidth, mapUI.getMapData(), water, false, texturetypeorcolor);
                break;
            }
            case Branching: {
                this.branchingCrossStreets(uag, sgc, intersectionPoint, streetWidth, mapUI.getMapData(), water, true, texturetypeorcolor);
                break;
            }
            case Very_Ordered: {
                this.buildOutRoadsVeryOrdered(uag, mapUI.getMapData(), sgc, intersectionPoint, mainroads, water, true, texturetypeorcolor, ml);
                break;
            }
            case Square: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 4);
                break;
            }
            case Pentagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 5);
                break;
            }
            case Hexagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 6);
                break;
            }
            case Heptagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 7);
                break;
            }
            case Octagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 8);
                break;
            }
            case Nonagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 9);
                break;
            }
            case Decagon: {
                this.generateEvenlyShapedStreets(uag, intersectionPoint, mapUI, width, height, roadTexture, coast, 10);
                break;
            }
            default: {
                this.buildOutRoadsVeryOrdered(uag, mapUI.getMapData(), sgc, intersectionPoint, mainroads, water, false, texturetypeorcolor, ml);
            }
        }
    }

    private void generateEvenlyShapedStreets(UndoActionGroup uag, Point2D intersectionPoint, MapUI mapUI, double width, double height, TextureType roadTexture, MapShape coast, int walltowers) {
        if (walltowers > 0) {
            int rings = this.setup.city.numStreets / walltowers;
            double degreeStartRatio = Math.random();
            double distanceFromIntersection = this.setup.city.streetDistance;
            List<Line> wallSegments = GenerateCityTask.getWallSegments(mapUI.getMapData());
            for (int i = 0; i < rings; ++i) {
                double skip = Math.random() * 100.0;
                if (skip > (double)this.setup.city.skipChance.intValue()) {
                    this.generateStraightRoadOrWall(uag, width, height, walltowers, distanceFromIntersection * 300.0, intersectionPoint, mapUI, mapUI.getMapData().getMapLayer("Features"), degreeStartRatio, roadTexture.type, true, coast, wallSegments);
                }
                distanceFromIntersection += this.setup.city.streetDistance.doubleValue();
            }
        }
    }

    private void branchingCrossStreets(UndoActionGroup uag, StreetGenConfig sgc, Point2D intersectionPoint, double streetWidth, MapData data, List<Shape> water, boolean minimizereconnections, Object texturetypeorcolor) {
        int success;
        int i;
        MapLayer ml = data.getMapLayer("Above Terrain");
        int bailcount = 0;
        List<Line> roadsegments = GenerateCityTask.getRoadSegments(data, false);
        List<Line> wallsegments = GenerateCityTask.getWallSegments(data);
        int streetsplaced = 0;
        int streetcount = sgc.numLongerStreets + sgc.numShorterStreets;
        for (i = 0; i <= sgc.numLongerStreets; ++i) {
            success = GenerateCityTask.makeBranchingStreet(uag, sgc, intersectionPoint, 5, 5, 3, streetWidth, data, roadsegments, wallsegments, water, minimizereconnections, texturetypeorcolor, ml);
            if (success == -2) {
                return;
            }
            if (success == -1) {
                --i;
                if (++bailcount == 10000) {
                    break;
                }
            } else {
                bailcount = 0;
                ++streetsplaced;
            }
            this.updateMessage("Placing Streets " + streetsplaced + "/" + streetcount);
        }
        bailcount = 0;
        for (i = 0; i < sgc.numShorterStreets; ++i) {
            if (i == 0) {
                bailcount = 0;
            }
            if ((success = GenerateCityTask.makeBranchingStreet(uag, sgc, intersectionPoint, 10, 3, 2, streetWidth * 0.9, data, roadsegments, wallsegments, water, minimizereconnections, texturetypeorcolor, ml)) == -2) {
                return;
            }
            if (success == -1) {
                --i;
                if (++bailcount == 10000) {
                    break;
                }
            } else {
                bailcount = 0;
                ++streetsplaced;
            }
            this.updateMessage("Placing Streets " + streetsplaced + "/" + streetcount);
        }
        this.updateMessage("Streets " + streetsplaced + "/" + streetcount + " placed.\n");
    }

    public boolean generateMainRoads(UndoActionGroup uag, MapData mapData, MapDataSetup setup, double highwayWidth, Point2D intersectionPoint, double width, double height, TextureType roadTexture, Color roadColor, double windiness, boolean tangent, MapLayer ml) {
        ArrayList<MapShape> coasts = new ArrayList<MapShape>();
        for (MapShape ms : mapData.getShapes()) {
            if (!ms.getTags().contains("coast")) continue;
            coasts.add(ms);
        }
        List<Shape> mainroads = MapLogic.generateMainRoadsHelper((int)width, (int)height, setup.city.mainRoad1Start, setup.city.mainRoad1End, setup.city.mainRoad2Start, setup.city.mainRoad2End, 1200, windiness, intersectionPoint, coasts, tangent);
        if (mainroads == null || mainroads.size() < 2) {
            return false;
        }
        for (Shape l : mainroads) {
            MapShape ms = new MapShape(ViewLevel.WORLD, ViewLevel.WORLD, l, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "main road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
            l.setStrokeWidth(highwayWidth);
            if (roadTexture != null) {
                ms.setStrokeTexture(roadTexture);
                ImagePattern newtexture = new ImagePattern(roadTexture.getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                l.setStroke((Paint)newtexture);
            } else {
                l.setStroke((Paint)roadColor);
            }
            mapData.getShapes().add(ms);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        }
        return true;
    }

    private void buildOutRoadsVeryOrdered(UndoActionGroup uag, MapData data, StreetGenConfig sgc, Point2D intersectPoint, List<Shape> mainroads, List<Shape> water, boolean usebothroads, Object texturetypeorcolor, MapLayer ml) {
        TreeMap<Double, Line> segments = new TreeMap<Double, Line>();
        double road1startx = 0.0;
        double road1starty = 0.0;
        double road1endx = 0.0;
        double road1endy = 0.0;
        for (PathElement pe : ((Path)mainroads.get(0)).getElements()) {
            if (pe instanceof MoveTo) {
                road1startx = ((MoveTo)pe).getX();
                road1starty = ((MoveTo)pe).getY();
                continue;
            }
            if (!(pe instanceof LineTo)) continue;
            road1endx = ((LineTo)pe).getX();
            road1endy = ((LineTo)pe).getY();
        }
        this.updateMessage("Got first main road..." + mainroads.size());
        double road2startx = 0.0;
        double road2starty = 0.0;
        double road2endx = 0.0;
        double road2endy = 0.0;
        for (PathElement pe : ((Path)mainroads.get(1)).getElements()) {
            if (pe instanceof MoveTo) {
                road2startx = ((MoveTo)pe).getX();
                road2starty = ((MoveTo)pe).getY();
                continue;
            }
            if (!(pe instanceof LineTo)) continue;
            road2endx = ((LineTo)pe).getX();
            road2endy = ((LineTo)pe).getY();
        }
        this.updateMessage("Got second main road...");
        List<Line> wallsegments = GenerateCityTask.getWallSegments(data);
        double dx = road1endx - road1startx;
        double dy = road1endy - road1starty;
        double d = Math.sqrt(dx * dx + dy * dy);
        double segmentlength = sgc.segmentLength * 300.0;
        if (usebothroads) {
            double dx2 = road2endx - road2startx;
            double dy2 = road2endy - road2starty;
            double d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            this.updateMessage("About to build cross streets...");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx, dy, d, segmentlength, 1, wallsegments, water, dx2, dy2);
            this.updateMessage("Cross streets section 1 done.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx, dy, d, segmentlength, -1, wallsegments, water, dx2, dy2);
            this.updateMessage("Cross streets section 2 done.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx2, dy2, d2, segmentlength, 1, wallsegments, water, dx, dy);
            this.updateMessage("Cross streets section 3 done.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx2, dy2, d2, segmentlength, -1, wallsegments, water, dx, dy);
            this.updateMessage("Cross streets section 4 done.");
        } else {
            this.updateMessage("Building cross streets (one road)...");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx, dy, d, segmentlength, 1, wallsegments, water);
            this.updateMessage("Cross streets section 1 complete.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, dx, dy, d, segmentlength, -1, wallsegments, water);
            this.updateMessage("Cross streets section 2 complete.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, -dy, dx, d, segmentlength, 1, wallsegments, water);
            this.updateMessage("Cross streets section 3 complete.");
            this.buildVeryOrderedCrossStreets(sgc, segments, intersectPoint, -dy, dx, d, segmentlength, -1, wallsegments, water);
            this.updateMessage("Cross streets section 4 complete.");
        }
        for (Line l : segments.values()) {
            if (this.isCancelled()) {
                return;
            }
            Path p = new Path();
            p.getElements().add((Object)new MoveTo(l.getStartX(), l.getStartY()));
            p.getElements().add((Object)new LineTo(l.getEndX(), l.getEndY()));
            MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
            p.setStrokeWidth(0.25);
            if (texturetypeorcolor instanceof TextureType) {
                ms.setStrokeTexture((TextureType)texturetypeorcolor);
                ImagePattern newtexture = new ImagePattern(((TextureType)texturetypeorcolor).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                p.setStroke((Paint)newtexture);
            } else {
                p.setStroke((Paint)((Color)texturetypeorcolor));
            }
            data.getShapes().add(ms);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        }
    }

    private void buildVeryOrderedCrossStreets(StreetGenConfig sgc, TreeMap<Double, Line> segments, Point2D intersectPoint, double dx, double dy, double d, double segmentlength, int direction, List<Line> wallsegments, List<Shape> water, double otherdx, double otherdy) {
        double intersectx = intersectPoint.getX() + dx / d * segmentlength * (double)direction;
        double intersecty = intersectPoint.getY() + dy / d * segmentlength * (double)direction;
        for (int i = 0; i < sgc.numStreets / 4; ++i) {
            for (int j = 0; j < sgc.numStreets / 4; ++j) {
                boolean intersects;
                if (this.isCancelled()) {
                    return;
                }
                double intersecttype = Math.random();
                Line lnew = null;
                Line lnew2 = null;
                double slope = otherdy / otherdx;
                double r = Math.sqrt(1.0 + Math.pow(slope, 2.0));
                if (intersecttype < sgc.skipChance / 100.0) {
                    lnew = new Line(intersectx + (double)j * segmentlength / r, intersecty + (double)j * segmentlength * slope / r, intersectx + (double)(j + 1) * segmentlength / r, intersecty + (double)(j + 1) * segmentlength * slope / r);
                } else if (intersecttype < sgc.skipChance / 100.0 * 2.0) {
                    lnew = new Line(intersectx - (double)j * segmentlength / r, intersecty - (double)j * segmentlength * slope / r, intersectx - (double)(j + 1) * segmentlength / r, intersecty - (double)(j + 1) * segmentlength * slope / r);
                } else {
                    lnew = new Line(intersectx + (double)j * segmentlength / r, intersecty + (double)j * segmentlength * slope / r, intersectx + (double)(j + 1) * segmentlength / r, intersecty + (double)(j + 1) * segmentlength * slope / r);
                    lnew2 = new Line(intersectx - (double)j * segmentlength / r, intersecty - (double)j * segmentlength * slope / r, intersectx - (double)(j + 1) * segmentlength / r, intersecty - (double)(j + 1) * segmentlength * slope / r);
                }
                if (lnew.getStartX() < 300.0 || lnew.getStartX() > (double)(sgc.mapWidth - 300) || lnew.getEndX() < 300.0 || lnew.getEndX() > (double)(sgc.mapWidth - 300) || lnew.getStartY() < 300.0 || lnew.getStartY() > (double)(sgc.mapHeight - 300) || lnew.getEndY() < 300.0 || lnew.getEndY() > (double)(sgc.mapHeight - 300)) {
                    lnew = null;
                }
                if (lnew2 != null && (lnew2.getStartX() < 300.0 || lnew2.getStartX() > (double)(sgc.mapWidth - 300) || lnew2.getEndX() < 300.0 || lnew2.getEndX() > (double)(sgc.mapWidth - 300) || lnew2.getStartY() < 300.0 || lnew2.getStartY() > (double)(sgc.mapHeight - 300) || lnew2.getEndY() < 300.0 || lnew2.getEndY() > (double)(sgc.mapHeight - 300))) {
                    lnew2 = null;
                }
                if (lnew != null) {
                    intersects = false;
                    for (Line l : wallsegments) {
                        if (MapLogic.intersection(l.getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), lnew.getStartX(), lnew.getStartY(), lnew.getEndX(), lnew.getEndY()) == null) continue;
                        intersects = true;
                        break;
                    }
                    for (Shape s : water) {
                        if (!(s instanceof Polygon) || !s.contains(lnew.getStartX(), lnew.getStartY()) && !s.contains(lnew.getEndX(), lnew.getEndY())) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        GenerateCityTask.putInSegmentMap(segments, lnew);
                    }
                }
                if (lnew2 == null) continue;
                intersects = false;
                for (Line l : wallsegments) {
                    if (MapLogic.intersection(l.getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), lnew2.getStartX(), lnew2.getStartY(), lnew2.getEndX(), lnew2.getEndY()) == null) continue;
                    intersects = true;
                    break;
                }
                for (Shape s : water) {
                    if (!(s instanceof Polygon) || !s.contains(lnew2.getStartX(), lnew2.getStartY()) && !s.contains(lnew2.getEndX(), lnew2.getEndY())) continue;
                    intersects = true;
                    break;
                }
                if (intersects) continue;
                GenerateCityTask.putInSegmentMap(segments, lnew2);
            }
            intersectx += dx / d * segmentlength * (double)direction;
            intersecty += dy / d * segmentlength * (double)direction;
        }
    }

    private void buildVeryOrderedCrossStreets(StreetGenConfig sgc, TreeMap<Double, Line> segments, Point2D intersectPoint, double dx, double dy, double d, double segmentlength, int direction, List<Line> wallsegments, List<Shape> water) {
        double intersectx = intersectPoint.getX() + dx / d * segmentlength * (double)direction;
        double intersecty = intersectPoint.getY() + dy / d * segmentlength * (double)direction;
        for (int i = 0; i < sgc.numStreets / 4; ++i) {
            for (int j = 0; j < sgc.numStreets / 4; ++j) {
                boolean intersects;
                if (this.isCancelled()) {
                    return;
                }
                double intersecttype = Math.random();
                Line lnew = null;
                Line lnew2 = null;
                if (intersecttype < sgc.skipChance / 100.0) {
                    lnew = new Line(intersectx + dy / d * segmentlength * (double)j, intersecty - dx / d * segmentlength * (double)j, intersectx + dy / d * segmentlength * (double)(j + 1), intersecty - dx / d * segmentlength * (double)(j + 1));
                } else if (intersecttype < sgc.skipChance / 100.0 * 2.0) {
                    lnew = new Line(intersectx - dy / d * segmentlength * (double)j, intersecty + dx / d * segmentlength * (double)j, intersectx - dy / d * segmentlength * (double)(j + 1), intersecty + dx / d * segmentlength * (double)(j + 1));
                } else {
                    lnew = new Line(intersectx + dy / d * segmentlength * (double)j, intersecty - dx / d * segmentlength * (double)j, intersectx + dy / d * segmentlength * (double)(j + 1), intersecty - dx / d * segmentlength * (double)(j + 1));
                    lnew2 = new Line(intersectx - dy / d * segmentlength * (double)j, intersecty + dx / d * segmentlength * (double)j, intersectx - dy / d * segmentlength * (double)(j + 1), intersecty + dx / d * segmentlength * (double)(j + 1));
                }
                if (lnew.getStartX() < 300.0 || lnew.getStartX() > (double)(sgc.mapWidth - 300) || lnew.getEndX() < 300.0 || lnew.getEndX() > (double)(sgc.mapWidth - 300) || lnew.getStartY() < 300.0 || lnew.getStartY() > (double)(sgc.mapHeight - 300) || lnew.getEndY() < 300.0 || lnew.getEndY() > (double)(sgc.mapHeight - 300)) {
                    lnew = null;
                }
                if (lnew2 != null && (lnew2.getStartX() < 300.0 || lnew2.getStartX() > (double)(sgc.mapWidth - 300) || lnew2.getEndX() < 300.0 || lnew2.getEndX() > (double)(sgc.mapWidth - 300) || lnew2.getStartY() < 300.0 || lnew2.getStartY() > (double)(sgc.mapHeight - 300) || lnew2.getEndY() < 300.0 || lnew2.getEndY() > (double)(sgc.mapHeight - 300))) {
                    lnew2 = null;
                }
                if (lnew != null) {
                    intersects = false;
                    for (Line l : wallsegments) {
                        if (MapLogic.intersection(l.getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), lnew.getStartX(), lnew.getStartY(), lnew.getEndX(), lnew.getEndY()) == null) continue;
                        intersects = true;
                        break;
                    }
                    for (Shape s : water) {
                        if (lnew == null || !(s instanceof Polygon) || !s.contains(lnew.getStartX(), lnew.getStartY()) && !s.contains(lnew.getEndX(), lnew.getEndY())) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        GenerateCityTask.putInSegmentMap(segments, lnew);
                    }
                }
                if (lnew2 == null) continue;
                intersects = false;
                for (Line l : wallsegments) {
                    if (MapLogic.intersection(l.getStartX(), l.getStartY(), l.getEndX(), l.getEndY(), lnew2.getStartX(), lnew2.getStartY(), lnew2.getEndX(), lnew2.getEndY()) == null) continue;
                    intersects = true;
                    break;
                }
                for (Shape s : water) {
                    if (lnew2 == null || !(s instanceof Polygon) || !s.contains(lnew2.getStartX(), lnew2.getStartY()) && !s.contains(lnew2.getEndX(), lnew2.getEndY())) continue;
                    intersects = true;
                    break;
                }
                if (intersects) continue;
                GenerateCityTask.putInSegmentMap(segments, lnew2);
            }
            intersectx += dx / d * segmentlength * (double)direction;
            intersecty += dy / d * segmentlength * (double)direction;
        }
    }

    public static enum CITYGEN {
        COAST,
        RIVER,
        MAINROADS,
        WALL,
        BUILDINGS,
        STREETS,
        VEGETATION,
        ALL;

    }
}

