/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.information.Religion;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapKeyEntry;
import com.inkwellideas.ographer.map.MapKeySettings;
import com.inkwellideas.ographer.map.MapKeyType;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TableData;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import javafx.util.Pair;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LoadMapTask
extends Task<MapDataSetup> {
    final File file;
    final boolean configOnly;
    final MapDataSetup data = new MapDataSetup();
    final int offsetX;
    final int offsetY;
    final int rotate;
    int tilesWide;
    int tilesHigh;
    final boolean doublesize;
    Map<String, String> uuidMap = new HashMap<String, String>();
    Map<String, String> customFeatureMappings = new HashMap<String, String>();
    Map<String, String> customTerrainMappings = new HashMap<String, String>();
    public static Map<String, String> v1Tov2FeatureTypes = new HashMap<String, String>();
    public static String[] terrainPrefixes;
    String[] terrainPrefixesV1 = new String[]{"Classic", "Cosmic", "Floor", "ISO Cols", "ISO Rows", "Large Area"};
    public static Map<String, String> v1Tov2TerrainTypes;
    static String[] featurePrefixesV1;

    public LoadMapTask(Worldographer worldographer, File f, boolean configonly, int offsetx, int offsety, int rotate, boolean doublesize) {
        this.file = f;
        this.configOnly = configonly;
        if (offsetx == Integer.MAX_VALUE) {
            offsetx = 0;
        }
        if (offsety == Integer.MAX_VALUE) {
            offsety = 0;
        }
        this.offsetX = offsetx;
        this.offsetY = offsety;
        this.rotate = rotate;
        this.doublesize = doublesize;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
    }

    protected MapDataSetup call() throws Exception {
        this.updateMessage("Starting . . .");
        this.loadFile();
        this.updateMessage("Finished.");
        return this.data;
    }

    private Color attributeToColor(Element el, String c) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty() || c.isBlank()) {
            return null;
        }
        String value = el.getAttribute(c);
        if (value.isEmpty() || value.isBlank()) {
            return null;
        }
        return Color.web((String)value);
    }

    private Double attributeToDouble(Element el, String c) {
        if (c == null) {
            return null;
        }
        if (c.isBlank() || c.isBlank()) {
            return null;
        }
        String value = el.getAttribute(c);
        if (value.isEmpty() || value.isBlank()) {
            return null;
        }
        return Double.valueOf(value);
    }

    private Integer attributeToInteger(Element el, String c) {
        if (c == null) {
            return null;
        }
        if (c.isBlank() || c.isBlank()) {
            return null;
        }
        String value = el.getAttribute(c);
        if (value.isEmpty() || value.isBlank()) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public MapDataSetup loadFile() throws Exception {
        Element el;
        String version;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource();
        FileInputStream fis = new FileInputStream(this.file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_16));
        String line1 = br.readLine();
        fis.close();
        fis = new FileInputStream(this.file);
        if (line1.startsWith("<?xml version") || line1.startsWith("<map type")) {
            inputSource.setCharacterStream(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_16));
        } else {
            inputSource.setCharacterStream(new InputStreamReader((InputStream)new GZIPInputStream(fis), StandardCharsets.UTF_16));
        }
        this.updateMessage("Parsing...");
        Document doc = documentBuilder.parse(inputSource);
        this.updateMessage("Parsed.");
        String release = doc.getDocumentElement().getAttribute("release");
        this.data.release = release == null ? "1.0" : "2025";
        String schema = doc.getDocumentElement().getAttribute("release");
        this.data.schema = schema == null || "".equals(schema) ? 0.9 : Double.parseDouble(schema);
        this.data.version = version = doc.getDocumentElement().getAttribute("version");
        double versionnum = 1.0;
        if (version.contains(" ")) {
            version = version.substring(0, version.indexOf(" "));
        }
        if (!version.trim().equals("")) {
            if (version.equals("1.19.1")) {
                version = "1.191";
            }
            versionnum = Double.parseDouble(version);
            this.data.versionNum = versionnum;
        }
        if (!this.configOnly) {
            String traceimage;
            String datafilename;
            String vSrollbarPos;
            this.data.lastViewLevel = doc.getDocumentElement().getAttribute("lastViewLevel");
            this.data.view.continentFactor = Integer.parseInt(doc.getDocumentElement().getAttribute("continentFactor"));
            this.data.view.kingdomFactor = Integer.parseInt(doc.getDocumentElement().getAttribute("kingdomFactor"));
            this.data.view.provinceFactor = Integer.parseInt(doc.getDocumentElement().getAttribute("provinceFactor"));
            this.data.view.worldToContinentHOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("worldToContinentHOffset"));
            this.data.view.continentToKingdomHOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("continentToKingdomHOffset"));
            this.data.view.kingdomToProvinceHOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("kingdomToProvinceHOffset"));
            this.data.view.worldToContinentVOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("worldToContinentVOffset"));
            this.data.view.continentToKingdomVOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("continentToKingdomVOffset"));
            this.data.view.kingdomToProvinceVOffset = Double.parseDouble(doc.getDocumentElement().getAttribute("kingdomToProvinceVOffset"));
            this.data.hexWidth = Double.parseDouble(doc.getDocumentElement().getAttribute("hexWidth"));
            this.data.hexHeight = Double.parseDouble(doc.getDocumentElement().getAttribute("hexHeight"));
            String hSrollbarPos = doc.getDocumentElement().getAttribute("hScrollbarPos");
            if (!hSrollbarPos.equals("")) {
                this.data.hScrollBar = Double.parseDouble(hSrollbarPos);
            }
            if (!(vSrollbarPos = doc.getDocumentElement().getAttribute("vScrollbarPos")).equals("")) {
                this.data.vScrollBar = Double.parseDouble(vSrollbarPos);
            }
            this.data.view.triangleSize = Integer.parseInt(doc.getDocumentElement().getAttribute("triangleSize"));
            this.data.hexOrientation = HexOrientation.valueOf(doc.getDocumentElement().getAttribute("hexOrientation"));
            this.data.mapProjection = MapProjection.valueOf(doc.getDocumentElement().getAttribute("mapProjection"));
            this.data.show.notes = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showNotes"));
            this.data.show.GMOnly = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showGMOnly"));
            this.data.show.GMOnlyGlow = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showGMOnlyGlow"));
            this.data.show.featureLabels = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showFeatureLabels"));
            this.data.show.grid = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showGrid"));
            this.data.show.gridNumbers = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showGridNumbers"));
            this.data.show.shadows = Boolean.parseBoolean(doc.getDocumentElement().getAttribute("showShadows"));
            NodeList gnnode = doc.getElementsByTagName("gridandnumbering");
            el = (Element)gnnode.item(0);
            if (el != null) {
                this.data.grid.gridcolor0 = this.attributeToColor(el, "color0");
                this.data.grid.gridcolor1 = this.attributeToColor(el, "color1");
                this.data.grid.gridcolor2 = this.attributeToColor(el, "color2");
                this.data.grid.gridcolor3 = this.attributeToColor(el, "color3");
                this.data.grid.gridcolor4 = this.attributeToColor(el, "color4");
                this.data.grid.gridwidth0 = this.attributeToDouble(el, "width0");
                this.data.grid.gridwidth1 = this.attributeToDouble(el, "width1");
                this.data.grid.gridwidth2 = this.attributeToDouble(el, "width2");
                this.data.grid.gridwidth3 = this.attributeToDouble(el, "width3");
                this.data.grid.gridwidth4 = this.attributeToDouble(el, "width4");
                this.data.view.gridOffsetContinentKingdomX = this.attributeToDouble(el, "gridOffsetContinentKingdomX");
                this.data.view.gridOffsetContinentKingdomY = this.attributeToDouble(el, "gridOffsetContinentKingdomY");
                this.data.view.gridOffsetWorldContinentX = this.attributeToDouble(el, "gridOffsetWorldContinentX");
                this.data.view.gridOffsetWorldContinentY = this.attributeToDouble(el, "gridOffsetWorldContinentY");
                this.data.view.gridOffsetWorldKingdomX = this.attributeToDouble(el, "gridOffsetWorldKingdomX");
                this.data.view.gridOffsetWorldKingdomY = this.attributeToDouble(el, "gridOffsetWorldKingdomY");
                this.data.grid.gridSquare = this.attributeToInteger(el, "gridSquare");
                this.data.grid.gridSquareHeight = this.attributeToDouble(el, "gridSquareHeight");
                this.data.grid.gridSquareWidth = this.attributeToDouble(el, "gridSquareWidth");
                this.data.grid.gridOffsetX = this.attributeToDouble(el, "gridOffsetX");
                this.data.grid.gridOffsetY = this.attributeToDouble(el, "gridOffsetY");
                this.data.numbering.setFontName(el.getAttribute("numberFont"));
                this.data.numbering.setFontColor(this.attributeToColor(el, "numberColor"));
                this.data.numbering.setFontSize(this.attributeToInteger(el, "numberSize"));
                try {
                    this.data.numbering.setFontStyle(NumberingData.FontStyle.valueOf(el.getAttribute("numberStyle")));
                }
                catch (Exception e) {
                    this.data.numbering.setFontStyle(NumberingData.FontStyle.PLAIN);
                }
                this.data.numbering.setFirstColumn(this.attributeToInteger(el, "numberFirstCol"));
                this.data.numbering.setFirstRow(this.attributeToInteger(el, "numberFirstRow"));
                try {
                    this.data.numbering.setOrder(NumberingData.OrderNumbers.valueOf(el.getAttribute("numberOrder")));
                }
                catch (Exception e) {
                    this.data.numbering.setOrder(NumberingData.OrderNumbers.COL_ROW);
                }
                try {
                    this.data.numbering.setPosition(NumberingData.NumberPosition.valueOf(el.getAttribute("numberPosition")));
                }
                catch (Exception e) {
                    this.data.numbering.setPosition(NumberingData.NumberPosition.BOTTOM);
                }
                try {
                    this.data.numbering.setPrePadNums(NumberingData.PrePadNums.valueOf(el.getAttribute("numberPrePad")));
                }
                catch (Exception e) {
                    this.data.numbering.setPrePadNums(NumberingData.PrePadNums.NO);
                }
                this.data.numbering.setSeparator(el.getAttribute("numberSeparator"));
            }
            if ((datafilename = doc.getDocumentElement().getAttribute("dataFile")) != null && !datafilename.equals("")) {
                try {
                    WorldAndNameData.loadProps(new FileInputStream(datafilename));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if ((traceimage = doc.getDocumentElement().getAttribute("traceImageFileName")) != null && !"".equals(traceimage)) {
                this.data.trace.imageFileName = traceimage;
                this.data.trace.opacity = Double.parseDouble(doc.getDocumentElement().getAttribute("traceOpacity"));
                this.data.trace.width = Double.parseDouble(doc.getDocumentElement().getAttribute("traceWidth"));
                this.data.trace.height = Double.parseDouble(doc.getDocumentElement().getAttribute("traceHeight"));
                this.data.trace.topLeftX = Double.parseDouble(doc.getDocumentElement().getAttribute("traceTopLeftX"));
                this.data.trace.topLeftY = Double.parseDouble(doc.getDocumentElement().getAttribute("traceTopLeftY"));
            }
            this.updateMessage("Setup done.");
        }
        NodeList mlnode = doc.getElementsByTagName("maplayer");
        if (!(this.configOnly || mlnode != null && mlnode.getLength() != 0)) {
            mapLayers = new ArrayList<MapLayer>();
            mapLayers.add(new MapLayer("Labels"));
            mapLayers.add(new MapLayer("Grid"));
            mapLayers.add(new MapLayer("Features"));
            mapLayers.add(new MapLayer("Above Terrain"));
            mapLayers.add(new MapLayer("Terrain Land"));
            mapLayers.add(new MapLayer("Above Water"));
            mapLayers.add(new MapLayer("Terrain Water"));
            mapLayers.add(new MapLayer("Below All"));
            this.data.mapLayers = mapLayers;
        } else if (!this.configOnly) {
            mapLayers = new ArrayList();
            for (int i = 0; i < mlnode.getLength(); ++i) {
                el = (Element)mlnode.item(i);
                MapLayer ml = new MapLayer(el.getAttribute("name"));
                ml.setVisible(Boolean.parseBoolean(el.getAttribute("isVisible")));
                String opacityStr = el.getAttribute("opacity");
                if (opacityStr != null && !opacityStr.equals("")) {
                    ml.setOpacity(Double.parseDouble(opacityStr));
                }
                mapLayers.add(ml);
                System.out.println("**Load Map Layer:" + String.valueOf(ml));
            }
            if (version == null || versionnum <= 1.154 && this.data.release.equals("1.0") && this.data.schema < 1.0) {
                mapLayers.add(1, new MapLayer("Grid"));
            }
            this.data.mapLayers = mapLayers;
        }
        this.readTerrainConfiguration(doc, this.data.release);
        this.updateMessage("Terrain configuration read.");
        this.readFeatureConfiguration(doc, this.data.release);
        this.updateMessage("Feature configuration read.");
        this.readTextureConfiguration(doc);
        this.updateMessage("Texture configuration read.");
        Map<String, LabelStyle> labelStyleMap = this.readLabelStyleConfiguration(doc);
        if (this.data.schema < 1.0 && labelStyleMap.size() == 0) {
            LabelStyle.setupLabelStyles(labelStyleMap, ViewLevel.valueOf(this.data.lastViewLevel));
        }
        this.data.labelStyles = labelStyleMap;
        this.updateMessage("Label styles read.");
        Map<String, ShapeStyle> shapeStyleMap = this.readShapeStyleConfiguration(doc);
        if (this.data.schema < 1.0 && shapeStyleMap.size() == 0) {
            ShapeStyle.setupShapeStyles(shapeStyleMap, ViewLevel.valueOf(this.data.lastViewLevel));
        }
        this.data.shapeStyles = shapeStyleMap;
        this.updateMessage("Shape styles read.");
        if (!this.configOnly) {
            String terrainmapstring;
            HashMap<String, String> terrainmap = new HashMap<String, String>();
            NodeList tmnode = doc.getElementsByTagName("terrainmap");
            Element el2 = (Element)tmnode.item(0);
            if (el2 != null && (terrainmapstring = el2.getTextContent()) != null && terrainmapstring.length() > 0) {
                String[] split = terrainmapstring.split("\\t");
                for (int i = 0; i < split.length; i += 2) {
                    if (split[i].equals("Grassland")) {
                        split[i] = "Flat Grassland";
                    }
                    terrainmap.put(split[i + 1], split[i]);
                }
            }
            this.readMapKey(this.data, doc);
            this.readTerrain(this.data, doc, terrainmap, versionnum, release);
            if (this.doublesize) {
                this.tilesWide *= 2;
                this.tilesHigh *= 2;
            }
            this.updateMessage("Terrain read.");
            this.readFeatures(doc, release, versionnum);
            this.updateMessage("Features read.");
            this.readExtraTerrain(doc, versionnum);
            this.updateMessage("Extra Terrain read.");
            this.readShapes(doc, versionnum);
            this.updateMessage("Shapes read.");
            this.readLabelsHelper(doc, release, versionnum);
            this.updateMessage("Labels read.");
            this.readNotes(doc, this.data.features);
            this.updateMessage("Notes read.");
            HashMap<String, Culture> cultures = new HashMap<String, Culture>();
            this.readInformation(doc, true, cultures);
            this.readInformation(doc, false, cultures);
        }
        this.updateMessage("Map successfully loaded.");
        return this.data;
    }

    private void readLabelsHelper(Document doc, String release, double versionNum) {
        NodeList labelsnode = doc.getElementsByTagName("labels");
        Element el = (Element)labelsnode.item(0);
        if (el != null) {
            this.readLabels(this.data, el.getElementsByTagName("label"), null, release, versionNum);
        }
    }

    private Point2D getSizedRotatedPt(double x, double y) {
        if (this.doublesize) {
            x *= 2.0;
            y *= 2.0;
        }
        if (this.rotate != 0) {
            if (this.rotate == 90) {
                double tx = (double)(this.tilesWide * 300) - y;
                y = x;
                x = tx;
            } else if (this.rotate == 180) {
                double tx = (double)(this.tilesWide * 300) - x;
                y = (double)(this.tilesHigh * 300) - y;
                x = tx;
            } else if (this.rotate == 270) {
                double tx = y;
                y = (double)(this.tilesHigh * 300) - x;
                x = tx;
            }
        }
        return new Point2D(x, y);
    }

    private double reviseXBottomLeft(double x, double proportion, double offset) {
        x -= offset;
        double proportionline = proportion * 2925.0;
        x = (x - proportionline) / (2925.0 - proportionline) * 2925.0;
        return x += offset;
    }

    private double reviseXBottomRight(double x, double proportion, double offset) {
        x -= offset;
        double proportionline = (1.0 - proportion) * 2925.0 + 2925.0;
        x = (x - 2925.0) / (proportionline - 2925.0) * 2925.0 + 2925.0;
        return x += offset;
    }

    private double reviseXTopRight(double x, double proportion, double offset) {
        x -= offset;
        double proportionline = proportion * 2925.0 + 2925.0;
        x = (x - 2925.0) / (proportionline - 2925.0) * 2925.0 + 2925.0;
        return x += offset;
    }

    private double reviseXTopLeft(double x, double proportion, double offset) {
        x -= offset;
        double proportionline = (1.0 - proportion) * 2925.0;
        x = (x - proportionline) / (2925.0 - proportionline) * 2925.0;
        return x += offset;
    }

    private void readShapes(Document doc, double versionnum) {
        NodeList shapesnode = doc.getElementsByTagName("shapes");
        Element el = (Element)shapesnode.item(0);
        NodeList mss = el.getElementsByTagName("shape");
        ArrayList<MapShape> mapshapes = new ArrayList<MapShape>();
        for (int i = 0; i < mss.getLength(); ++i) {
            String fillcolorstr;
            String inscolorstr;
            String dscolorstr;
            TextureType tt;
            String stroketexture;
            TextureType tt2;
            Element ms = (Element)mss.item(i);
            String tags = ms.getAttribute("tags");
            ViewLevel hvl = ViewLevel.valueOf(ms.getAttribute("highestViewLevel"));
            ViewLevel cvl = ViewLevel.valueOf(ms.getAttribute("currentShapeViewLevel"));
            String type = ms.getAttribute("type");
            boolean isCurve = Boolean.parseBoolean(ms.getAttribute("isCurve"));
            NodeList pts = ms.getElementsByTagName("point");
            if (pts == null || pts.getLength() == 0) {
                pts = ms.getElementsByTagName("p");
            }
            ArrayList<Double> xsys = new ArrayList<Double>();
            for (int j = 0; j < pts.getLength() * 2; j += 2) {
                Element pt = (Element)pts.item(j / 2);
                String pttype = pt.getAttribute("type");
                if ("close".equals(pttype)) continue;
                double x = Double.parseDouble(pt.getAttribute("x"));
                double y = Double.parseDouble(pt.getAttribute("y"));
                Point2D rotatedPt = this.getSizedRotatedPt(x, y);
                xsys.add((double)(this.offsetX * 300) + rotatedPt.getX());
                xsys.add((double)(this.offsetY * 300) + rotatedPt.getY());
            }
            Polygon s = null;
            if ("Polygon".equals(type)) {
                s = new Polygon();
                s.getPoints().addAll(xsys);
            } else if ("Path".equals(type)) {
                s = new Path();
                Path p = (Path)s;
                String frstr = ms.getAttribute("fillRule");
                if (frstr != null && !"".equals(frstr)) {
                    p.setFillRule(FillRule.valueOf((String)frstr));
                } else {
                    p.setFillRule(FillRule.EVEN_ODD);
                }
                for (int k = 0; k < pts.getLength(); ++k) {
                    Point2D rotatedPt;
                    Element pt = (Element)pts.item(k);
                    String pttype = pt.getAttribute("type");
                    if (k == 0 || "m".equals(pttype)) {
                        rotatedPt = this.getSizedRotatedPt(Double.parseDouble(pt.getAttribute("x")), Double.parseDouble(pt.getAttribute("y")));
                        MoveTo mt = new MoveTo((double)(this.offsetX * 300) + rotatedPt.getX(), (double)(this.offsetY * 300) + rotatedPt.getY());
                        p.getElements().add((Object)mt);
                        continue;
                    }
                    if ("c".equals(pttype)) {
                        String cx1 = pt.getAttribute("cx1");
                        String cy1 = pt.getAttribute("cy1");
                        String cx2 = pt.getAttribute("cx2");
                        String cy2 = pt.getAttribute("cy2");
                        Point2D rotatedPt2 = this.getSizedRotatedPt(Double.parseDouble(pt.getAttribute("x")), Double.parseDouble(pt.getAttribute("y")));
                        Point2D rotatedC1Pt = this.getSizedRotatedPt(Double.parseDouble(cx1), Double.parseDouble(cy1));
                        Point2D rotatedC2Pt = this.getSizedRotatedPt(Double.parseDouble(cx2), Double.parseDouble(cy2));
                        String ct = new CubicCurveTo((double)(this.offsetX * 300) + rotatedC1Pt.getX(), (double)(this.offsetY * 300) + rotatedC1Pt.getY(), (double)(this.offsetX * 300) + rotatedC2Pt.getX(), (double)(this.offsetY * 300) + rotatedC2Pt.getY(), (double)(this.offsetX * 300) + rotatedPt2.getX(), (double)(this.offsetY * 300) + rotatedPt2.getY());
                        p.getElements().add((Object)ct);
                        continue;
                    }
                    if (isCurve && versionnum < 1.2) {
                        try {
                            CubicCurveTo ct = new CubicCurveTo(((Double)xsys.get(k * 2 + 2)).doubleValue(), ((Double)xsys.get(k * 2 + 3)).doubleValue(), ((Double)xsys.get(k * 2 + 4)).doubleValue(), ((Double)xsys.get(k * 2 + 5)).doubleValue(), ((Double)xsys.get(k * 2)).doubleValue(), ((Double)xsys.get(k * 2 + 1)).doubleValue());
                            p.getElements().add((Object)ct);
                        }
                        catch (Exception ct) {
                            // empty catch block
                        }
                        k += 2;
                        continue;
                    }
                    if ("close".equals(pttype)) {
                        p.getElements().add((Object)new ClosePath());
                        continue;
                    }
                    rotatedPt = this.getSizedRotatedPt(Double.parseDouble(pt.getAttribute("x")), Double.parseDouble(pt.getAttribute("y")));
                    LineTo lt = new LineTo((double)(this.offsetX * 300) + rotatedPt.getX(), (double)(this.offsetY * 300) + rotatedPt.getY());
                    p.getElements().add((Object)lt);
                }
            } else if ("Arc".equals(type)) {
                String startang;
                s = new Arc();
                ((Arc)s).setCenterX(((Double)xsys.get(0)).doubleValue());
                ((Arc)s).setCenterY(((Double)xsys.get(1)).doubleValue());
                ((Arc)s).setRadiusX((Double)xsys.get(2) - (Double)xsys.get(0));
                ((Arc)s).setRadiusY((Double)xsys.get(3) - (Double)xsys.get(1));
                if (versionnum < 1.35 && this.data.release.equals("1.0") && this.data.schema < 1.0) {
                    ((Arc)s).setCenterX((Double)xsys.get(0) + ((Double)xsys.get(2) - (Double)xsys.get(0)) / 2.0);
                    ((Arc)s).setCenterY((Double)xsys.get(1) + ((Double)xsys.get(3) - (Double)xsys.get(1)) / 2.0);
                    ((Arc)s).setRadiusX(Math.abs(((Double)xsys.get(2) - (Double)xsys.get(0)) / 2.0));
                    ((Arc)s).setRadiusY(Math.abs(((Double)xsys.get(3) - (Double)xsys.get(1)) / 2.0));
                }
                if ((startang = ms.getAttribute("startAngle")) == null || startang.equals("")) {
                    startang = "0";
                }
                ((Arc)s).setStartAngle((Double.parseDouble(startang) + (double)(360 - this.rotate)) % 360.0);
                String len = ms.getAttribute("length");
                if (len == null || len.equals("")) {
                    len = "360";
                }
                ((Arc)s).setLength(Double.parseDouble(len));
                String arctype = ms.getAttribute("arcType");
                if (arctype == null || arctype.equals("")) {
                    arctype = "OPEN";
                }
                ((Arc)s).setType(ArcType.valueOf((String)arctype));
            }
            String opacity = ms.getAttribute("opacity");
            if (opacity != null && !opacity.equals("")) {
                s.setOpacity(Double.parseDouble(opacity));
            }
            boolean isWorld = Boolean.parseBoolean(ms.getAttribute("isWorld"));
            boolean isContinent = Boolean.parseBoolean(ms.getAttribute("isContinent"));
            boolean isKingdom = Boolean.parseBoolean(ms.getAttribute("isKingdom"));
            boolean isProvince = Boolean.parseBoolean(ms.getAttribute("isProvince"));
            boolean isGMOnly = Boolean.parseBoolean(ms.getAttribute("isGMOnly"));
            String cts = ms.getAttribute("creationType");
            MapShape.CreationType ct1 = MapShape.CreationType.valueOf(cts);
            String st1 = ms.getAttribute("strokeType");
            if (st1.equals("0")) {
                st1 = "SIMPLE";
            }
            if (st1.equals("1")) {
                st1 = "DASHED";
            }
            if (st1.equals("2")) {
                st1 = "DOTTED";
            }
            if (st1.equals("3")) {
                st1 = "ELEVATION";
            }
            if (st1.equals("4")) {
                st1 = "ELEV_INVERTED";
            }
            if (st1.equals("5")) {
                st1 = "RAILROAD";
            }
            if (st1.equals("6")) {
                st1 = "COAST";
            }
            MapShape.StrokeType st = MapShape.StrokeType.valueOf(st1);
            String mapLayerstr = ms.getAttribute("mapLayer");
            if (mapLayerstr == null || mapLayerstr.equals("")) {
                mapLayerstr = "Above Terrain";
            }
            int layernum = switch (mapLayerstr) {
                case "ABOVE_TEXT" -> 0;
                case "ABOVE_MAP_ITEMS" -> 0;
                case "ABOVE_TERRAIN" -> 2;
                case "ABOVE_WATER" -> 4;
                case "BELOW_ALL" -> 6;
                case "ALL" -> 0;
                default -> -1;
            };
            MapLayer mapLayer = null;
            if (layernum >= 0) {
                mapLayer = this.data.mapLayers.get(layernum);
            } else {
                for (MapLayer ml : this.data.mapLayers) {
                    if (ml.getName().equals(mapLayerstr)) {
                        mapLayer = ml;
                        break;
                    }
                    if (!ml.getName().equals("Above Terrain")) continue;
                    mapLayer = ml;
                }
            }
            String elwStr = ms.getAttribute("extraLineWidth");
            double extraLineWidth = s.getStrokeWidth();
            if (elwStr != null && !elwStr.equals("")) {
                extraLineWidth = Double.parseDouble(elwStr);
            }
            String ellStr = ms.getAttribute("extraLineLength");
            double extraLineLength = this.data.hexWidth / 8.0;
            if (ellStr != null && !ellStr.equals("")) {
                extraLineLength = Double.parseDouble(ellStr);
            }
            String eldStr = ms.getAttribute("extraLineDistance");
            double extraLineDistance = this.data.hexWidth / 6.0;
            if (eldStr != null && !eldStr.equals("")) {
                extraLineDistance = Double.parseDouble(eldStr);
            }
            String elsStr = ms.getAttribute("extraLineSeparation");
            double extraLineSeparation = 15.0;
            if (eldStr != null && !eldStr.equals("")) {
                extraLineSeparation = Double.parseDouble(elsStr);
            }
            MapShape mapshape = new MapShape(hvl, cvl, (Shape)s, ct1, st, isGMOnly, tags, extraLineDistance, extraLineLength, extraLineWidth, extraLineSeparation, isWorld, isContinent, isKingdom, isProvince, mapLayer);
            mapshape.setSnapVertices(Boolean.parseBoolean(ms.getAttribute("isSnapVertices")));
            mapshape.setMatchTileBorders(Boolean.parseBoolean(ms.getAttribute("isMatchTileBorders")));
            mapshape.setDropShadow(Boolean.parseBoolean(ms.getAttribute("isDropShadow")));
            mapshape.setInnerShadow(Boolean.parseBoolean(ms.getAttribute("isInnerShadow")));
            mapshape.setBoxBlur(Boolean.parseBoolean(ms.getAttribute("isBoxBlur")));
            mapshape.setDsSpread(Double.parseDouble(ms.getAttribute("dsSpread")));
            mapshape.setDsRadius(Double.parseDouble(ms.getAttribute("dsRadius")));
            mapshape.setDsOffsetX(Double.parseDouble(ms.getAttribute("dsOffsetX")));
            mapshape.setDsOffsetY(Double.parseDouble(ms.getAttribute("dsOffsetY")));
            mapshape.setInsChoke(Double.parseDouble(ms.getAttribute("insChoke")));
            mapshape.setInsRadius(Double.parseDouble(ms.getAttribute("insRadius")));
            mapshape.setInsOffsetX(Double.parseDouble(ms.getAttribute("insOffsetX")));
            mapshape.setInsOffsetY(Double.parseDouble(ms.getAttribute("insOffsetY")));
            mapshape.setBbWidth(Double.parseDouble(ms.getAttribute("bbWidth")));
            mapshape.setBbHeight(Double.parseDouble(ms.getAttribute("bbHeight")));
            mapshape.setBbIterations(Integer.parseInt(ms.getAttribute("bbIterations")));
            String filltexture = ms.getAttribute("fillTexture");
            if (filltexture != null && !"".equals(filltexture) && (tt2 = TextureType.ALL_TEXTURES.get(filltexture)) != null && tt2.getIcon() != null) {
                Image fillicon = tt2.getIcon();
                mapshape.getShape().setFill((Paint)new ImagePattern(fillicon, 0.0, 0.0, 100.0, 173.0, false));
                mapshape.setFillTexture(TextureType.ALL_TEXTURES.get(filltexture));
            }
            if ((stroketexture = ms.getAttribute("strokeTexture")) != null && !"".equals(stroketexture) && (tt = TextureType.ALL_TEXTURES.get(stroketexture)) != null && tt.getIcon() != null) {
                Image strokeicon = tt.getIcon();
                mapshape.getShape().setStroke((Paint)new ImagePattern(strokeicon, 0.0, 0.0, 100.0, 173.0, false));
                mapshape.setStrokeTexture(TextureType.ALL_TEXTURES.get(stroketexture));
            }
            if ((dscolorstr = ms.getAttribute("dsColor")) != null && !dscolorstr.equals("null")) {
                String[] vals = dscolorstr.split(",");
                mapshape.setDsColor(new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
            if ((inscolorstr = ms.getAttribute("insColor")) != null && !inscolorstr.equals("null")) {
                String[] vals = inscolorstr.split(",");
                mapshape.setInsColor(new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
            mapshape.getShape().setStrokeWidth(Double.parseDouble(ms.getAttribute("strokeWidth")));
            String strokecolorstr = ms.getAttribute("strokeColor");
            if (strokecolorstr != null && !strokecolorstr.equals("null") && !strokecolorstr.equals("")) {
                String[] vals = strokecolorstr.split(",");
                mapshape.getShape().setStroke((Paint)new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
            if ((fillcolorstr = ms.getAttribute("fillColor")) != null && !fillcolorstr.equals("null") && !fillcolorstr.equals("")) {
                String[] vals = fillcolorstr.split(",");
                mapshape.getShape().setFill((Paint)new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
            if ((fillcolorstr == null || "".equals(fillcolorstr)) && (filltexture == null || "".equals(filltexture))) {
                mapshape.getShape().setFill(null);
            }
            if (mapshape.getShape() instanceof Path && this.data.schema < 1.0 && (this.data.versionNum == null || this.data.versionNum <= 1.144 && this.data.versionNum != 1.0)) {
                mapshape.getShape().setFill(null);
            }
            if (ms.getAttribute("lineCap") != null) {
                mapshape.getShape().setStrokeLineCap(StrokeLineCap.valueOf((String)ms.getAttribute("lineCap")));
            }
            if (ms.getAttribute("lineJoin") != null) {
                mapshape.getShape().setStrokeLineJoin(StrokeLineJoin.valueOf((String)ms.getAttribute("lineJoin")));
            }
            mapshapes.add(mapshape);
        }
        this.data.shapes = mapshapes;
    }

    private void readLabels(MapDataSetup data, NodeList labels, Feature feature, String release, double versionnum) {
        MapLabel label = null;
        ArrayList<MapLabel> labellist = new ArrayList<MapLabel>();
        for (int i = 0; i < labels.getLength(); ++i) {
            Element l = (Element)labels.item(i);
            String style = l.getAttribute("style");
            String fontface = l.getAttribute("fontFace");
            String colorString = l.getAttribute("color");
            Color color = null;
            if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                String[] vals = colorString.split(",");
                color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            String bgColorString = l.getAttribute("backgroundColor");
            Color bgColor = null;
            if (bgColorString != null && !"".equals(bgColorString) && !"null".equals(bgColorString)) {
                String[] vals = bgColorString.split(",");
                bgColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            String outlineColorString = l.getAttribute("outlineColor");
            Color outlineColor = null;
            if (outlineColorString != null && !"".equals(outlineColorString) && !"null".equals(outlineColorString)) {
                String[] vals = outlineColorString.split(",");
                outlineColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            String outlineSizeStr = l.getAttribute("outlineSize");
            double outlineSize = 0.0;
            if (outlineSizeStr != null && !"".equals(outlineSizeStr)) {
                outlineSize = Double.parseDouble(outlineSizeStr);
            }
            String ltags = l.getAttribute("tags");
            double lrotate = Double.parseDouble(l.getAttribute("rotate"));
            lrotate = (lrotate + (double)this.rotate) % 360.0;
            boolean lisBold = Boolean.parseBoolean(l.getAttribute("isBold"));
            boolean lisItalic = Boolean.parseBoolean(l.getAttribute("isItalic"));
            boolean lisWorld = Boolean.parseBoolean(l.getAttribute("isWorld"));
            boolean lisContinent = Boolean.parseBoolean(l.getAttribute("isContinent"));
            boolean lisKingdom = Boolean.parseBoolean(l.getAttribute("isKingdom"));
            boolean lisProvince = Boolean.parseBoolean(l.getAttribute("isProvince"));
            boolean lisGMOnly = Boolean.parseBoolean(l.getAttribute("isGMOnly"));
            String maplayername = l.getAttribute("mapLayer");
            MapLayer mapLayer = null;
            if (maplayername != null) {
                for (MapLayer ml : data.mapLayers) {
                    if (!ml.getName().equals(maplayername)) continue;
                    mapLayer = ml;
                }
            }
            if (mapLayer == null) {
                maplayername = "Labels";
                for (MapLayer ml : data.mapLayers) {
                    if (!ml.getName().equals(maplayername)) continue;
                    mapLayer = ml;
                }
            }
            if (mapLayer == null) {
                mapLayer = new MapLayer("Labels");
                data.mapLayers.add(0, mapLayer);
            }
            String text = l.getTextContent();
            String textAlignString = l.getAttribute("textAlignment");
            TextAlignment textAlign = TextAlignment.CENTER;
            if (textAlignString != null && !"".equals(textAlignString)) {
                textAlign = TextAlignment.valueOf((String)textAlignString);
            }
            String asf = l.getAttribute("adjustScaleFactor");
            Double adjustScaleFactor = 0.0;
            if (style != null && (style.equals("") || style.equals("Use Custom Style"))) {
                adjustScaleFactor = 100.0;
            }
            if (asf != null && !asf.trim().equals("") && release.equals("1.0") && versionnum > 1.42 && data.schema < 1.0) {
                adjustScaleFactor = Double.parseDouble(asf);
            }
            label = new MapLabel(style, text, fontface, color, outlineSize, outlineColor, bgColor, lrotate, lisWorld, lisContinent, lisKingdom, lisProvince, lisBold, lisItalic, lisGMOnly, textAlign, ltags, mapLayer);
            NodeList locations = l.getElementsByTagName("location");
            for (int j = 0; j < locations.getLength(); ++j) {
                Element loc = (Element)locations.item(j);
                ViewLevel vl = ViewLevel.valueOf(loc.getAttribute("viewLevel"));
                double x = Double.parseDouble(loc.getAttribute("x"));
                double y = Double.parseDouble(loc.getAttribute("y"));
                if (this.doublesize) {
                    x *= 2.0;
                    y *= 2.0;
                }
                if (this.rotate != 0) {
                    if (this.rotate == 90) {
                        tx = (double)(this.tilesWide * 300) - y;
                        y = x;
                        x = tx;
                    } else if (this.rotate == 180) {
                        tx = (double)(this.tilesWide * 300) - x;
                        y = (double)(this.tilesHigh * 300) - y;
                        x = tx;
                    } else if (this.rotate == 270) {
                        tx = y;
                        y = (double)(this.tilesHigh * 300) - x;
                        x = tx;
                    }
                }
                double scale = 25.0;
                try {
                    scale = Double.parseDouble(loc.getAttribute("scale"));
                }
                catch (Exception e) {
                    scale = 25.0;
                }
                label.setLocationAndScale(vl, (Pair<Point2D, Double>)new Pair((Object)new Point2D((double)(this.offsetX * 300) + x, (double)(this.offsetY * 300) + y), (Object)scale));
            }
            if (feature != null) {
                feature.setLabel(label);
                return;
            }
            labellist.add(label);
        }
        data.labels = labellist;
    }

    /*
     * WARNING - void declaration
     */
    private void readExtraTerrain(Document doc, double versionNum) {
        NodeList et = doc.getElementsByTagName("extraTerrain");
        if (et == null || et.getLength() == 0) {
            return;
        }
        Element el = (Element)et.item(0);
        NodeList mlNodes = el.getElementsByTagName("mapLayer");
        for (int i = 0; i < mlNodes.getLength(); ++i) {
            Element mlElem = (Element)mlNodes.item(i);
            String layerName = mlElem.getAttribute("name");
            NodeList terrainNodes = ((Element)mlNodes.item(i)).getElementsByTagName("terrainAndLocation");
            for (int j = 0; j < terrainNodes.getLength(); ++j) {
                void var23_30;
                Element terrainElem = (Element)terrainNodes.item(j);
                String terrainName = terrainElem.getAttribute("name");
                String elevation = terrainElem.getAttribute("elevation");
                boolean icy = terrainElem.getAttribute("icy").toLowerCase().equals("true");
                boolean gmOnly = terrainElem.getAttribute("gmOnly").toLowerCase().equals("true");
                String resourcesStr = terrainElem.getAttribute("resources");
                byte[] resources = new byte[7];
                int rcount = 0;
                if (resourcesStr != null && !resourcesStr.equals("Z")) {
                    for (String string : resourcesStr.split(",")) {
                        resources[rcount] = Byte.parseByte(string);
                        ++rcount;
                    }
                }
                String[] locStrings = terrainElem.getAttribute("location").split(",");
                Terrain terrain = new Terrain(terrainName, false);
                terrain.setElevation(Integer.parseInt(elevation));
                terrain.setIcy(icy);
                terrain.setGmOnly(gmOnly);
                terrain.getExtraInfo().setResources(resources);
                MapLayer mapLayer = null;
                for (MapLayer ml : this.data.mapLayers) {
                    if (!ml.getName().equals(layerName)) continue;
                    mapLayer = ml;
                }
                if (mapLayer == null) continue;
                Map<Point, Terrain> map = this.data.extraTerrainByLayer.get(mapLayer);
                if (map == null) {
                    HashMap hashMap = new HashMap();
                    this.data.extraTerrainByLayer.put(mapLayer, hashMap);
                }
                var23_30.put(new Point(Double.parseDouble(locStrings[0]), Double.parseDouble(locStrings[1])), terrain);
            }
        }
    }

    private void readFeatures(Document doc, String release, double versionNum) {
        NodeList fs = doc.getElementsByTagName("feature");
        ArrayList<Feature> features = new ArrayList<Feature>();
        int featureCount = 0;
        for (int i = 0; i < fs.getLength(); ++i) {
            Element f;
            String type;
            if (++featureCount % 1000 == 0) {
                this.updateMessage("Loading features: #" + featureCount + "/" + fs.getLength());
            }
            if (this.customFeatureMappings.containsKey(type = (f = (Element)fs.item(i)).getAttribute("type"))) {
                type = this.customFeatureMappings.get(type);
            }
            if (type.equals("Battlemat Bed")) {
                type = "Battlemat Bed Pine";
            } else if (type.equals("Battlemat Bed Double")) {
                type = "Battlemat Bed Double Pine";
            } else if (type.equals("Battlemat Bed Blue")) {
                type = "Battlemat Bed Blue Pine";
            } else if (type.equals("Battlemat Bed Double Blue")) {
                type = "Battlemat Bed Double Blue Pine";
            } else if (type.equals("Battlemat Bed Red")) {
                type = "Battlemat Bed Red Pine";
            } else if (type.equals("Battlemat Bed Double Red")) {
                type = "Battlemat Bed Double Red Pine";
            }
            if (release.equals("1.0") || release.equals("")) {
                type = LoadMapTask.getUpdatedFeatureTypeName(type);
            }
            if (type.length() == 0) continue;
            String maplayerstr = f.getAttribute("mapLayer");
            if (maplayerstr == null) {
                maplayerstr = "";
            }
            MapLayer maplayer = null;
            List<MapLayer> mls = this.data.mapLayers;
            for (MapLayer ml : mls) {
                if (ml.getName().equals(maplayerstr)) {
                    maplayer = ml;
                    break;
                }
                if (!ml.getName().equals("Features")) continue;
                maplayer = ml;
            }
            Object uuidstr = f.getAttribute("uuid");
            double rotate = Double.parseDouble(f.getAttribute("rotate"));
            if (release.equals("1.0") || release.equals("")) {
                if (type.equals("Battlemat Chair Basic Blue") || type.equals("Battlemat Chair Basic Red") || type.equals("Battlemat Chair Basic White") || type.equals("Battlemat Chair Basic Yellow") || type.equals("Battlemat Chair Dining") || type.equals("Battlemat Chair Garden") || type.equals("Battlemat Chair Metal") || type.equals("Battlemat Chair Modern Red") || type.equals("Battlemat Chair Office") || type.equals("Battlemat Chair Upholstered Black") || type.equals("Battlemat Chair Upholstered Red") || type.equals("Battlemat Chair Upholstered White") || type.equals("Battlemat Chair Upholstered Yellow") || type.equals("Battlemat Chair Wood") || type.equals("Battlemat Chair Pine") || type.equals("Battlemat Chair Walnut") || type.equals("Battlemat Chair Weathered")) {
                    rotate += 90.0;
                } else if (type.equals("Battlemat SF Chair")) {
                    rotate -= 90.0;
                }
            }
            rotate = (rotate + (double)this.rotate) % 360.0;
            double scale = Double.parseDouble(f.getAttribute("scale"));
            double scaleHt = Double.parseDouble(f.getAttribute("scaleHt"));
            String labelDistanceStr = f.getAttribute("labelDistance");
            int labelDistance = 0;
            if (labelDistanceStr != null && !labelDistanceStr.equals("")) {
                labelDistance = Integer.parseInt(labelDistanceStr);
            }
            String labelPositionStr = f.getAttribute("labelPosition");
            int labelPosition = 6;
            if (labelPositionStr != null && labelPositionStr.indexOf(58) > 0) {
                labelPosition = Integer.parseInt(labelPositionStr.substring(0, labelPositionStr.indexOf(58)));
            }
            String tags = f.getAttribute("tags");
            boolean isWorld = Boolean.parseBoolean(f.getAttribute("isWorld"));
            boolean isContinent = Boolean.parseBoolean(f.getAttribute("isContinent"));
            boolean isKingdom = Boolean.parseBoolean(f.getAttribute("isKingdom"));
            boolean isProvince = Boolean.parseBoolean(f.getAttribute("isProvince"));
            String ringColorString = f.getAttribute("ringColor");
            Color ring = null;
            if (ringColorString != null && !"".equals(ringColorString) && !"null".equals(ringColorString)) {
                String[] vals = ringColorString.split(",");
                ring = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            String overrideColorString = f.getAttribute("color");
            Color overrideColor = null;
            if (overrideColorString != null && !"".equals(overrideColorString) && !"null".equals(overrideColorString)) {
                String[] vals = overrideColorString.split(",");
                overrideColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            boolean isGMOnly = Boolean.parseBoolean(f.getAttribute("isGMOnly"));
            boolean isPlaceFreely = Boolean.parseBoolean(f.getAttribute("isPlaceFreely"));
            boolean isHideTerrainIcon = Boolean.parseBoolean(f.getAttribute("isHideTerrainIcon"));
            boolean isFillHexBottom = Boolean.parseBoolean(f.getAttribute("isFillHexBottom"));
            boolean isFlipHorizontal = Boolean.parseBoolean(f.getAttribute("isFlipHorizontal"));
            boolean isFlipVertical = Boolean.parseBoolean(f.getAttribute("isFlipVertical"));
            Feature feature = new Feature(type, isPlaceFreely, isHideTerrainIcon, isGMOnly, isFillHexBottom, ring, rotate, overrideColor, scale, scaleHt, isFlipHorizontal, isFlipVertical, null, labelDistance, FeatureDecoration.FeatureDecorationLocation.lookup(labelPosition), tags, isWorld, isContinent, isKingdom, isProvince, maplayer);
            if (((String)uuidstr).length() < 16) {
                uuidstr = String.valueOf(UUID.randomUUID());
            }
            feature.setUUID((String)uuidstr);
            if (this.doublesize && (type.contains("Stairs") || type.contains("Porticullis"))) {
                feature.setScale(feature.getScaleFallbackType() * 2.0);
                feature.setScaleHt(feature.getScaleHtFallbackType() * 2.0);
            }
            NodeList locations = f.getElementsByTagName("location");
            for (int j = 0; j < locations.getLength(); ++j) {
                Element loc = (Element)locations.item(j);
                ViewLevel vl = ViewLevel.valueOf(loc.getAttribute("viewLevel"));
                if (this.data.getTerrainByViewLevel(vl) == null || this.data.getTerrainByViewLevel(vl).length <= 0 || feature.getLocation(vl) != null) continue;
                double x = Double.parseDouble(loc.getAttribute("x"));
                double y = Double.parseDouble(loc.getAttribute("y"));
                this.uuidMap.put(x + "," + y, (String)uuidstr);
                if (this.doublesize) {
                    x *= 2.0;
                    y *= 2.0;
                }
                if (this.rotate != 0) {
                    if (this.rotate == 90) {
                        tx = (double)(this.tilesWide * 300) - y;
                        y = x;
                        x = tx;
                    } else if (this.rotate == 180) {
                        tx = (double)(this.tilesWide * 300) - x;
                        y = (double)(this.tilesHigh * 300) - y;
                        x = tx;
                    } else if (this.rotate == 270) {
                        tx = y;
                        y = (double)(this.tilesHigh * 300) - x;
                        x = tx;
                    }
                }
                feature.setLocation(vl, new Point2D((double)(this.offsetX * 300) + x, (double)(this.offsetY * 300) + y));
            }
            NodeList decorations = f.getElementsByTagName("decoration");
            for (int j = 0; j < decorations.getLength() && j < feature.getFeatureDecorations().length; ++j) {
                Element dec = (Element)decorations.item(j);
                String text = dec.getTextContent();
                String colorString = dec.getAttribute("color");
                Color color = null;
                if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                    String[] vals = colorString.split(",");
                    color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                FeatureDecoration.FeatureDecorationLocation loc = FeatureDecoration.FeatureDecorationLocation.lookup(Integer.parseInt(dec.getAttribute("location")));
                feature.getFeatureDecorations()[j] = new FeatureDecoration(text, color, loc);
            }
            this.readLabels(this.data, f.getElementsByTagName("label"), feature, release, versionNum);
            features.add(feature);
        }
        this.data.features = features;
    }

    private static String getUpdatedFeatureTypeName(String type) {
        String type2 = v1Tov2FeatureTypes.get(type);
        if (type2 != null) {
            type = type2;
        } else if (Feature.DEFAULT_FEATURES.containsKey("Classic/" + (String)type)) {
            type = "Classic/" + (String)type;
        } else {
            for (int k = 0; k < terrainPrefixes.length; k += 2) {
                if (!((String)type).startsWith(terrainPrefixes[k]) || !Feature.DEFAULT_FEATURES.containsKey(terrainPrefixes[k + 1] + ((String)type).substring(terrainPrefixes[k].length()))) continue;
                type = terrainPrefixes[k + 1] + ((String)type).substring(terrainPrefixes[k].length());
                break;
            }
        }
        return type;
    }

    private void readNotes(Document doc, List<Feature> features) {
        NodeList ns = doc.getElementsByTagName("note");
        HashSet<Note> notes = new HashSet<Note>();
        for (int i = 0; i < ns.getLength(); ++i) {
            String world;
            Note note;
            Element n = (Element)ns.item(i);
            String parent = n.getAttribute("parent");
            String originalViewLevel = n.getAttribute("originalViewLevel");
            if (!this.data.release.equals("2025") || this.data.versionNum <= 1.06 && this.data.versionNum != 1.0 && this.data.schema < 1.0 || originalViewLevel.equals("")) {
                String p;
                ViewLevel vl = ViewLevel.valueOf(n.getAttribute("viewLevel"));
                double x = Double.parseDouble(n.getAttribute("x"));
                double y = Double.parseDouble(n.getAttribute("y"));
                if ("".equals(parent) && (p = this.uuidMap.get(x + "," + y)) != null) {
                    parent = p;
                }
                if (this.doublesize) {
                    x *= 2.0;
                    y *= 2.0;
                }
                if (this.rotate != 0) {
                    if (this.rotate == 90) {
                        double tx = (double)(this.tilesWide * 300) - y;
                        y = x;
                        x = tx;
                    } else if (this.rotate == 180) {
                        double tx = (double)(this.tilesWide * 300) - x;
                        y = (double)(this.tilesHigh * 300) - y;
                        x = tx;
                    } else if (this.rotate == 270) {
                        double tx = y;
                        y = (double)(this.tilesHigh * 300) - x;
                        x = tx;
                    }
                }
                note = new Note(vl, (double)(this.offsetX * 300) + x, (double)(this.offsetY * 300) + y);
            } else {
                note = new Note(ViewLevel.valueOf(originalViewLevel), 0.0, 0.0);
                NodeList locations = n.getElementsByTagName("location");
                for (int j = 0; j < locations.getLength(); ++j) {
                    Element loc = (Element)locations.item(j);
                    ViewLevel vl = ViewLevel.valueOf(loc.getAttribute("viewLevel"));
                    double x = Double.parseDouble(loc.getAttribute("x"));
                    double y = Double.parseDouble(loc.getAttribute("y"));
                    if (this.doublesize) {
                        x *= 2.0;
                        y *= 2.0;
                    }
                    if (this.rotate != 0) {
                        if (this.rotate == 90) {
                            tx = (double)(this.tilesWide * 300) - y;
                            y = x;
                            x = tx;
                        } else if (this.rotate == 180) {
                            tx = (double)(this.tilesWide * 300) - x;
                            y = (double)(this.tilesHigh * 300) - y;
                            x = tx;
                        } else if (this.rotate == 270) {
                            tx = y;
                            y = (double)(this.tilesHigh * 300) - x;
                            x = tx;
                        }
                    }
                    note.setLocation(vl, new Point2D((double)(this.offsetX * 300) + x, (double)(this.offsetY * 300) + y));
                }
            }
            String title = n.getAttribute("title");
            NodeList notetext = n.getElementsByTagName("notetext");
            String text = null;
            if (notetext.getLength() == 1) {
                Element nt = (Element)notetext.item(0);
                text = nt.getTextContent();
            }
            if (text == null) {
                text = n.getTextContent();
            }
            String colorString = n.getAttribute("color");
            String filename = n.getAttribute("filename");
            if (filename == null) {
                filename = "";
            }
            note.setWorld((world = n.getAttribute("isWorld")) == null || world.equals("") || Boolean.parseBoolean(world));
            String continent = n.getAttribute("isContinent");
            note.setContinent(continent == null || continent.equals("") || Boolean.parseBoolean(continent));
            String kingdom = n.getAttribute("isKingdom");
            note.setKingdom(kingdom == null || kingdom.equals("") || Boolean.parseBoolean(kingdom));
            String province = n.getAttribute("isProvince");
            note.setProvince(province == null || province.equals("") || Boolean.parseBoolean(province));
            note.setTitle(title);
            note.setDetails(text);
            note.setFilename(filename);
            if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                String[] vals = colorString.split(",");
                note.setColor(new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
            if (parent != null && !parent.trim().equals("")) {
                try {
                    UUID uuidparent = UUID.fromString(parent);
                    for (Feature f : features) {
                        if (!f.getUUID().equals(uuidparent)) continue;
                        note.setParent(f);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            NodeList tables = n.getElementsByTagName("table");
            for (int j = 0; j < tables.getLength(); ++j) {
                Element table = (Element)tables.item(j);
                String key = table.getAttribute("key");
                String[] rows = table.getTextContent().split("\\n");
                TableData headings = new TableData(table.getAttribute("headingA"), table.getAttribute("headingB"), table.getAttribute("headingC"), table.getAttribute("headingD"), table.getAttribute("headingE"), table.getAttribute("headingF"), table.getAttribute("headingG"), table.getAttribute("headingH"));
                ArrayList<TableData> tdatalist = new ArrayList<TableData>();
                for (String s : rows) {
                    String[] row = s.split("\\t");
                    String row0 = row.length > 0 ? row[0] : "";
                    String row1 = row.length > 1 ? row[1] : "";
                    String row2 = row.length > 2 ? row[2] : "";
                    String row3 = row.length > 3 ? row[3] : "";
                    String row4 = row.length > 4 ? row[4] : "";
                    String row5 = row.length > 5 ? row[5] : "";
                    String row6 = row.length > 6 ? row[6] : "";
                    String row7 = row.length > 7 ? row[7] : "";
                    tdatalist.add(new TableData(row0, row1, row2, row3, row4, row5, row6, row7));
                }
                NoteTable nt = new NoteTable(headings, (ObservableList<TableData>)FXCollections.observableArrayList(tdatalist));
                note.getTableData().put(key, nt);
            }
            notes.add(note);
        }
        this.data.notes = notes;
    }

    private void readInformation(Document doc, boolean onlycultures, Map<String, Culture> cultures) {
        NodeList ns1 = doc.getElementsByTagName("informations");
        if (ns1.getLength() > 0) {
            NodeList ns = ns1.item(0).getChildNodes();
            this.data.information = this.readInformationHelper(ns, onlycultures, cultures, "");
        }
    }

    public String getFirstLevelTextContent(Node node) {
        StringBuilder content = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("#text")) continue;
            content.append(child.getTextContent());
        }
        return content.toString();
    }

    private List<Information> readInformationHelper(NodeList ns, boolean onlycultures, Map<String, Culture> cultures, String indent) {
        ArrayList<Information> infos = new ArrayList<Information>();
        for (int i = 0; i < ns.getLength(); ++i) {
            if (ns.item(i).getNodeType() != 1) continue;
            Element n = (Element)ns.item(i);
            String title = n.getAttribute("title");
            String type = n.getAttribute("type");
            String uuidstr = n.getAttribute("uuid");
            UUID uuid = UUID.fromString(uuidstr);
            String text = n.getFirstChild().getNodeValue();
            Information info = null;
            ArrayList<Information> children = new ArrayList();
            NodeList childnodes = n.getChildNodes();
            if (childnodes != null) {
                children = this.readInformationHelper(childnodes, onlycultures, cultures, indent + "~+-");
            }
            switch (type) {
                case "Culture": {
                    if (onlycultures) {
                        language = n.getAttribute("language");
                        info = new Culture(title, language, text, uuid);
                        cultures.put(uuidstr, (Culture)info);
                    } else {
                        language = n.getAttribute("language");
                        info = new Culture(title, language, text, uuid);
                        info = cultures.get(uuidstr);
                    }
                    info.children = children;
                    break;
                }
                case "Nation": {
                    if (onlycultures) break;
                    String culturesstr = n.getAttribute("cultures");
                    String[] culturesstrarry = culturesstr.split(",");
                    ArrayList<Culture> culturelist = new ArrayList<Culture>();
                    for (String cid : culturesstrarry) {
                        culturelist.add(cultures.get(cid));
                    }
                    String[] rulers = n.getAttribute("rulers").split(",");
                    String government = n.getAttribute("government");
                    info = new Nation(title, culturelist, government, rulers, text, uuid);
                    info.children = children;
                    break;
                }
                case "Religion": {
                    if (onlycultures) break;
                    String holysymbol = n.getAttribute("holySymbol");
                    String religiontype = n.getAttribute("religionType");
                    String domains = n.getAttribute("domains");
                    String[] domainsarray = domains.split(",");
                    String culturestr = n.getAttribute("culture");
                    Culture culture = cultures.get(culturestr);
                    info = new Religion(title, religiontype, culture, domainsarray, holysymbol, text, children);
                    break;
                }
                default: {
                    if (onlycultures) break;
                    info = new Information(title, text, children, uuid);
                }
            }
            if (onlycultures || info == null) continue;
            infos.add(info);
        }
        return infos;
    }

    private void readTerrainConfiguration(Document doc, String release) {
        try {
            NodeList tcnode = doc.getElementsByTagName("terrain-config");
            Element el = (Element)tcnode.item(0);
            NodeList ttnodes = el.getElementsByTagName("terraintype");
            for (int i = 0; i < ttnodes.getLength(); ++i) {
                Element ttnode = (Element)ttnodes.item(i);
                Object type = ttnode.getAttribute("type");
                for (String prefix : this.terrainPrefixesV1) {
                    if (!((String)type).startsWith(prefix + " ")) continue;
                    String newType = prefix + "/" + ((String)type).substring(prefix.length() + 1);
                    this.customTerrainMappings.put((String)type, newType);
                    type = newType;
                }
                System.out.println("**Load Terrain Config:" + (String)type + ":" + release);
                type = LoadMapTask.getUpdatedTerrainName((String)type);
                System.out.println("**Load Terrain Config Updated Name?:" + (String)type);
                int elevation = Integer.parseInt(ttnode.getAttribute("elevation"));
                double iconsize = Double.parseDouble(ttnode.getAttribute("iconSize"));
                String colorString = ttnode.getAttribute("color");
                String isDefault = ttnode.getAttribute("isDefault");
                Color color = null;
                if (!"".equals(colorString) && !"null".equals(colorString)) {
                    String[] vals = colorString.split(",");
                    color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                String iconString = ttnode.getTextContent();
                WritableImage image = null;
                if (iconString != null && !iconString.equals("")) {
                    byte[] ba = (byte[])Base64.decodeToObject(iconString.trim());
                    ByteArrayInputStream in = new ByteArrayInputStream(ba);
                    image = SwingFXUtils.toFXImage((BufferedImage)ImageIO.read(in), null);
                }
                double offsetYDecimal = 0.0;
                String offsetYDecimalString = ttnode.getAttribute("offsetYDecimal");
                if (offsetYDecimalString != null && !offsetYDecimalString.equals("")) {
                    offsetYDecimal = Double.parseDouble(offsetYDecimalString);
                }
                double offsetXDecimal = 0.0;
                String offsetXDecimalString = ttnode.getAttribute("offsetXDecimal");
                if (offsetXDecimalString != null && !offsetXDecimalString.equals("")) {
                    offsetXDecimal = Double.parseDouble(offsetXDecimalString);
                }
                TerrainType tt = new TerrainType((String)type, (Image)image, iconsize, color, elevation, null, isDefault.toLowerCase().equals("true"), offsetXDecimal, offsetYDecimal);
                String similarTerrainString = ttnode.getAttribute("similarTerrain");
                if (!"".equals(similarTerrainString) && !"null".equals(similarTerrainString)) {
                    tt.setSimilarTerrain(similarTerrainString.split(":::"));
                }
                Terrain.terrainTypes.put((String)type, tt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readFeatureConfiguration(Document doc, String release) {
        try {
            NodeList tcnode = doc.getElementsByTagName("feature-config");
            Element el = (Element)tcnode.item(0);
            NodeList ttnodes = el.getElementsByTagName("featuretype");
            for (int i = 0; i < ttnodes.getLength(); ++i) {
                Element ttnode = (Element)ttnodes.item(i);
                Object type = ttnode.getAttribute("type");
                for (String prefix : featurePrefixesV1) {
                    if (!((String)type).startsWith(prefix + " ")) continue;
                    String newType = prefix + "/" + ((String)type).substring(prefix.length() + 1);
                    if (newType.startsWith("Structure/Structure ")) {
                        newType = "Structure/" + ((String)type).substring(19);
                    }
                    this.customFeatureMappings.put((String)type, newType);
                    type = newType;
                }
                System.out.println("**Load Feature Config:" + (String)type + " release:" + release);
                type = LoadMapTask.getUpdatedFeatureTypeName((String)type);
                double iconsize = Double.parseDouble(ttnode.getAttribute("iconSize"));
                String iconHeightStr = ttnode.getAttribute("iconHeight");
                double iconHeight = -1.0;
                if (iconHeightStr != null && !iconHeightStr.equals("")) {
                    iconHeight = Double.parseDouble(iconHeightStr);
                }
                String isDefault = ttnode.getAttribute("isDefault");
                String iconString = ttnode.getTextContent();
                WritableImage image = null;
                if (iconString != null && !iconString.equals("")) {
                    byte[] ba = (byte[])Base64.decodeToObject(iconString.trim());
                    ByteArrayInputStream in = new ByteArrayInputStream(ba);
                    image = SwingFXUtils.toFXImage((BufferedImage)ImageIO.read(in), null);
                }
                FeatureType ft = new FeatureType((String)type, (Image)image, iconsize, iconHeight, isDefault.toLowerCase().equals("true"));
                String alternateIconString = ttnode.getAttribute("alternateIcon");
                if (alternateIconString != null && !"".equals(alternateIconString)) {
                    byte[] ba = (byte[])Base64.decodeToObject(alternateIconString.trim());
                    ByteArrayInputStream in = new ByteArrayInputStream(ba);
                    WritableImage altImage = SwingFXUtils.toFXImage((BufferedImage)ImageIO.read(in), null);
                    ft.setAlternateIcon((Image)altImage);
                }
                Feature.featureTypes.put((String)type, ft);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, LabelStyle> readLabelStyleConfiguration(Document doc) {
        HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
        try {
            NodeList tcnode = doc.getElementsByTagName("text-config");
            Element el = (Element)tcnode.item(0);
            NodeList ttnodes = el.getChildNodes();
            for (int i = 0; i < ttnodes.getLength(); ++i) {
                if (ttnodes.item(i).getNodeType() != 1) continue;
                Element ttnode = (Element)ttnodes.item(i);
                String name = ttnode.getAttribute("name");
                System.out.println("**Load Label Style:" + name);
                String face = ttnode.getAttribute("fontFace");
                String outlinesizestr = ttnode.getAttribute("outlineSize");
                double outlinesize = 0.0;
                if (outlinesizestr != null && !"".equals(outlinesizestr)) {
                    outlinesize = Double.parseDouble(outlinesizestr);
                }
                double scale = Double.parseDouble(ttnode.getAttribute("scale"));
                boolean isbold = Boolean.parseBoolean(ttnode.getAttribute("isBold"));
                boolean isitalic = Boolean.parseBoolean(ttnode.getAttribute("isItalic"));
                String colorString = ttnode.getAttribute("color");
                Color color = null;
                if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                    String[] vals = colorString.split(",");
                    color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                String bgColorString = ttnode.getAttribute("backgroundColor");
                Color bgcolor = null;
                if (bgColorString != null && !"".equals(bgColorString) && !"null".equals(bgColorString)) {
                    String[] vals = bgColorString.split(",");
                    bgcolor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                String outlineColorString = ttnode.getAttribute("outlineColor");
                Color outlinecolor = null;
                if (outlineColorString != null && !"".equals(outlineColorString) && !"null".equals(outlineColorString)) {
                    String[] vals = outlineColorString.split(",");
                    outlinecolor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                LabelStyle ls = new LabelStyle(name, face, color, outlinesize, outlinecolor, scale, isbold, isitalic, bgcolor);
                labelStyleMap.put(name, ls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return labelStyleMap;
    }

    private Color parseColor(String colorString) {
        Color color = null;
        if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
            String[] vals = colorString.split(",");
            color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
        }
        return color;
    }

    private Map<String, ShapeStyle> readShapeStyleConfiguration(Document doc) {
        HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
        try {
            NodeList tcnode = doc.getElementsByTagName("shape-config");
            Element el = (Element)tcnode.item(0);
            if (el != null) {
                NodeList ttnodes = el.getElementsByTagName("shapestyle");
                for (int i = 0; i < ttnodes.getLength(); ++i) {
                    String lineJoin;
                    Element ttnode = (Element)ttnodes.item(i);
                    String name = ttnode.getAttribute("name");
                    System.out.println("**Load Shape Style:" + name);
                    MapShape.StrokeType strokeType = MapShape.StrokeType.valueOf(ttnode.getAttribute("strokeType"));
                    boolean isFractal = Boolean.parseBoolean(ttnode.getAttribute("isFractal"));
                    double strokeWidth = Double.parseDouble(ttnode.getAttribute("strokeWidth"));
                    double opacity = Double.parseDouble(ttnode.getAttribute("opacity"));
                    boolean snapVertices = Boolean.parseBoolean(ttnode.getAttribute("snapVertices"));
                    String tags = ttnode.getAttribute("tags");
                    boolean dropShadow = Boolean.parseBoolean(ttnode.getAttribute("dropShadow"));
                    boolean innerShadow = Boolean.parseBoolean(ttnode.getAttribute("innerShadow"));
                    boolean boxBlur = Boolean.parseBoolean(ttnode.getAttribute("boxBlur"));
                    double dsSpread = Double.parseDouble(ttnode.getAttribute("dsSpread"));
                    double dsRadius = Double.parseDouble(ttnode.getAttribute("dsRadius"));
                    double dsOffsetX = Double.parseDouble(ttnode.getAttribute("dsOffsetX"));
                    double dsOffsetY = Double.parseDouble(ttnode.getAttribute("dsOffsetY"));
                    double insChoke = Double.parseDouble(ttnode.getAttribute("insChoke"));
                    double insRadius = Double.parseDouble(ttnode.getAttribute("insRadius"));
                    double insOffsetX = Double.parseDouble(ttnode.getAttribute("insOffsetX"));
                    double insOffsetY = Double.parseDouble(ttnode.getAttribute("insOffsetY"));
                    double bbWidth = Double.parseDouble(ttnode.getAttribute("bbWidth"));
                    double bbHeight = Double.parseDouble(ttnode.getAttribute("bbHeight"));
                    int bbIterations = Integer.parseInt(ttnode.getAttribute("bbIterations"));
                    String fillTextureName = ttnode.getAttribute("fillTexture");
                    TextureType fillTexture = TextureType.ALL_TEXTURES.get(fillTextureName);
                    String strokeTextureName = ttnode.getAttribute("strokeTexture");
                    TextureType strokeTexture = TextureType.ALL_TEXTURES.get(strokeTextureName);
                    Color dsColor = this.parseColor(ttnode.getAttribute("dscolor"));
                    Color insColor = this.parseColor(ttnode.getAttribute("inscolor"));
                    Color strokePaint = this.parseColor(ttnode.getAttribute("strokePaint"));
                    Color fillPaint = this.parseColor(ttnode.getAttribute("fillPaint"));
                    String lineCap = ttnode.getAttribute("lineCap");
                    if (lineCap == null || "".equals(lineCap)) {
                        lineCap = "SQUARE";
                    }
                    if ((lineJoin = ttnode.getAttribute("lineJoin")) == null || "".equals(lineJoin)) {
                        lineJoin = "ROUND";
                    }
                    ShapeStyle ss = new ShapeStyle(name, strokeType, isFractal, strokeWidth, (Paint)strokePaint, (Paint)fillPaint, opacity, snapVertices, tags, dropShadow, innerShadow, boxBlur, dsSpread, dsRadius, dsOffsetX, dsOffsetY, insChoke, insRadius, insOffsetX, insOffsetY, bbWidth, bbHeight, bbIterations, dsColor, insColor, fillTexture, strokeTexture, lineCap, lineJoin);
                    shapeStyleMap.put(name, ss);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shapeStyleMap;
    }

    private void readTextureConfiguration(Document doc) {
        try {
            NodeList tcnode = doc.getElementsByTagName("texture-config");
            Element el = (Element)tcnode.item(0);
            NodeList ttnodes = el.getElementsByTagName("texturetype");
            for (int i = 0; i < ttnodes.getLength(); ++i) {
                Element ttnode = (Element)ttnodes.item(i);
                String type = ttnode.getAttribute("type");
                System.out.println("**Load Texture Config:" + type);
                boolean isDefault = Boolean.parseBoolean(ttnode.getAttribute("isDefault"));
                String iconString = ttnode.getTextContent();
                WritableImage image = null;
                if (iconString != null && !iconString.equals("")) {
                    byte[] ba = (byte[])Base64.decodeToObject(iconString.trim());
                    ByteArrayInputStream in = new ByteArrayInputStream(ba);
                    image = SwingFXUtils.toFXImage((BufferedImage)ImageIO.read(in), null);
                }
                String w = ttnode.getAttribute("width");
                int width = 174;
                if (w != null && !w.equals("")) {
                    width = Integer.parseInt(w);
                }
                TextureType tt = new TextureType(type, (Image)image, isDefault, width);
                TextureType.ALL_TEXTURES.put(type, tt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readMapKey(MapDataSetup data, Document doc) {
        NodeList mapkeynode = doc.getElementsByTagName("mapkey");
        MapKeySettings mapKeySettings = new MapKeySettings();
        if (mapkeynode.getLength() == 0) {
            return;
        }
        for (int a = 0; a < 1; ++a) {
            Element el = (Element)mapkeynode.item(a);
            String px = el.getAttribute("positionx");
            mapKeySettings.positionx = px != null && !"".equals(px) && !"null".equals(px) ? Double.valueOf(px) : Double.valueOf(1.0);
            String py = el.getAttribute("positiony");
            mapKeySettings.positiony = py != null && !"".equals(py) && !"null".equals(py) ? Double.valueOf(py) : Double.valueOf(1.0);
            String vl = el.getAttribute("viewlevel");
            mapKeySettings.viewlevel = vl != null && !"".equals(vl) && !"null".equals(vl) ? ViewLevel.valueOf(vl) : ViewLevel.WORLD;
            String ht = el.getAttribute("height");
            mapKeySettings.height = ht != null && !"".equals(vl) && !"null".equals(ht) ? Integer.parseInt(ht) : 10;
            Color bgColor = null;
            String bgcolorString = el.getAttribute("backgroundcolor");
            if (bgcolorString != null && !"".equals(bgcolorString) && !"null".equals(bgcolorString)) {
                String[] vals = bgcolorString.split(",");
                bgColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            } else {
                bgColor = Color.ANTIQUEWHITE;
            }
            mapKeySettings.backgroundColor = bgColor;
            String bo = el.getAttribute("backgroundopacity");
            mapKeySettings.backgroundOpacity = bo != null && !"".equals(bo) && !"null".equals(bo) ? Integer.parseInt(bo) : 70;
            mapKeySettings.titleText = el.getAttribute("titleText");
            mapKeySettings.titleFontFace = el.getAttribute("titleFontFace");
            Color titleFontColor = null;
            String colorString = el.getAttribute("titleFontColor");
            if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                String[] vals = colorString.split(",");
                titleFontColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            mapKeySettings.titleFontColor = titleFontColor;
            mapKeySettings.titleFontBold = Boolean.parseBoolean(el.getAttribute("titleFontBold"));
            mapKeySettings.titleFontItalic = Boolean.parseBoolean(el.getAttribute("titleFontItalic"));
            mapKeySettings.titleScale = Integer.parseInt(el.getAttribute("titleScale"));
            mapKeySettings.scaleText = el.getAttribute("scaleText");
            mapKeySettings.scaleFontFace = el.getAttribute("scaleFontFace");
            Color scaleFontColor = null;
            colorString = el.getAttribute("scaleFontColor");
            if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                String[] vals = colorString.split(",");
                scaleFontColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            mapKeySettings.scaleFontColor = scaleFontColor;
            mapKeySettings.scaleFontBold = Boolean.parseBoolean(el.getAttribute("scaleFontBold"));
            mapKeySettings.scaleFontItalic = Boolean.parseBoolean(el.getAttribute("scaleFontItalic"));
            mapKeySettings.scaleScale = Integer.parseInt(el.getAttribute("scaleScale"));
            mapKeySettings.entryFontFace = el.getAttribute("entryFontFace");
            Color entryFontColor = null;
            colorString = el.getAttribute("entryFontColor");
            if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                String[] vals = colorString.split(",");
                entryFontColor = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
            }
            mapKeySettings.entryFontColor = entryFontColor;
            mapKeySettings.entryFontBold = Boolean.parseBoolean(el.getAttribute("entryFontBold"));
            mapKeySettings.entryFontItalic = Boolean.parseBoolean(el.getAttribute("entryFontItalic"));
            mapKeySettings.entryScale = Integer.parseInt(el.getAttribute("entryScale"));
            NodeList entries = el.getElementsByTagName("mapkeyentry");
            TreeMap<String, MapKeyEntry> entriesmap = new TreeMap<String, MapKeyEntry>();
            for (int i = 0; i < entries.getLength(); ++i) {
                Element entryel = (Element)entries.item(i);
                String ts = entryel.getAttribute("type");
                String key = entryel.getAttribute("key");
                Color color = null;
                colorString = entryel.getAttribute("color");
                if (colorString != null && !"".equals(colorString) && !"null".equals(colorString)) {
                    String[] vals = colorString.split(",");
                    color = new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3]));
                }
                MapKeyEntry mke = new MapKeyEntry(MapKeyType.valueOf(ts), key, entryel.getTextContent(), Integer.parseInt(entryel.getAttribute("order")), color, Integer.parseInt(entryel.getAttribute("scale")));
                entriesmap.put(key, mke);
            }
            mapKeySettings.entries = entriesmap;
        }
        data.mapKeySettings = mapKeySettings;
    }

    private void readTerrain(MapDataSetup data, Document doc, Map<String, String> terrainintmap, double version, String release) {
        HashMap<ViewLevel, Terrain[][]> terrainmap = new HashMap<ViewLevel, Terrain[][]>();
        NodeList tilesnode = doc.getElementsByTagName("tiles");
        String line = null;
        Object textlines = null;
        String[] tokens = new String[13];
        for (int a = 0; a < tilesnode.getLength(); ++a) {
            long time = System.currentTimeMillis();
            Element el = (Element)tilesnode.item(a);
            ViewLevel vl = ViewLevel.valueOf(el.getAttribute("viewLevel"));
            int w = Integer.parseInt(el.getAttribute("tilesWide"));
            int h = Integer.parseInt(el.getAttribute("tilesHigh"));
            this.tilesWide = w;
            this.tilesHigh = h;
            this.updateMessage("Loading terrain: " + String.valueOf((Object)vl));
            Terrain[][] t = new Terrain[w][h];
            int count = 0;
            NodeList terrainrows = el.getElementsByTagName("tilerow");
            int priorindex = 1;
            int nextindex = -1;
            for (int i = 0; i < w; ++i) {
                priorindex = 1;
                nextindex = -1;
                Node terrainrow = terrainrows.item(i);
                for (int j = 0; j < h; ++j) {
                    byte[] resources = new byte[7];
                    if (count % 10000 == 0) {
                        this.updateMessage("Loading terrain: " + String.valueOf((Object)vl) + " " + count + "/" + w * h);
                    }
                    if (terrainrow == null) {
                        t[i][j] = new Terrain("Border Only", true);
                        continue;
                    }
                    nextindex = terrainrow.getTextContent().indexOf(10, priorindex);
                    if (nextindex < 0) {
                        nextindex = terrainrow.getTextContent().length();
                    }
                    if ((line = terrainrow.getTextContent().substring(priorindex, nextindex)).startsWith("null")) {
                        t[i][j] = null;
                    } else if (release.equals("1.0") && version <= 1.28) {
                        LoadMapTask.optimizedSplit(line, tokens, '\t', 6);
                        t[i][j] = new Terrain(terrainintmap.size() > 0 ? terrainintmap.get(tokens[0]) : tokens[0], Integer.parseInt(tokens[1]), tokens[3].equals("true") || tokens[3].equals("1"), tokens[4].equals("true") || tokens[4].equals("1"));
                        resources[0] = Byte.parseByte(tokens[5]);
                        resources[1] = Byte.parseByte(tokens[6]);
                        resources[2] = Byte.parseByte(tokens[7]);
                        resources[3] = Byte.parseByte(tokens[8]);
                        resources[4] = Byte.parseByte(tokens[9]);
                        resources[5] = Byte.parseByte(tokens[10]);
                        resources[6] = Byte.parseByte(tokens[11]);
                        t[i][j].setResources(resources);
                        if (tokens[12] != null && !"".equals(tokens[12]) && !"null".equals(tokens[12])) {
                            String[] vals = tokens[12].split(",");
                            t[i][j].setBackgroundColor(new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
                            tokens[12] = null;
                        }
                    } else {
                        String tname;
                        LoadMapTask.optimizedSplit(line, tokens, '\t', 5);
                        String string = tname = terrainintmap.size() > 0 ? terrainintmap.get(tokens[0]) : tokens[0];
                        if (this.customTerrainMappings.containsKey(tname)) {
                            tname = this.customTerrainMappings.get(tname);
                        }
                        if (!Terrain.DEFAULT_TERRAIN.containsKey(tname = LoadMapTask.getUpdatedTerrainName(tname))) {
                            System.out.println("*****Terrain not found:" + tname);
                        }
                        t[i][j] = new Terrain(tname, Integer.parseInt(tokens[1]), tokens[2].equals("true") || tokens[2].equals("1"), tokens[3].equals("true") || tokens[3].equals("1"));
                        resources[0] = Byte.parseByte(tokens[4]);
                        resources[1] = Byte.parseByte(tokens[5]);
                        resources[2] = Byte.parseByte(tokens[6]);
                        resources[3] = Byte.parseByte(tokens[7]);
                        resources[4] = Byte.parseByte(tokens[8]);
                        resources[5] = Byte.parseByte(tokens[9]);
                        resources[6] = Byte.parseByte(tokens[10]);
                        if (resources[0] != 0 || resources[1] != 0 || resources[2] != 0 || resources[3] != 0 || resources[4] != 0 || resources[5] != 0 || resources[6] != 0) {
                            t[i][j].setResources(resources);
                        }
                        if (tokens[11] != null && !"".equals(tokens[11]) && !"null".equals(tokens[11])) {
                            String[] vals = tokens[11].split(",");
                            if (vals.length > 3) {
                                t[i][j].setBackgroundColor(new Color(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
                            }
                            tokens[11] = null;
                        }
                    }
                    ++count;
                    priorindex = nextindex + 1;
                }
            }
            count = 0;
            terrainmap.put(vl, t);
        }
        for (ViewLevel viewLevel : terrainmap.keySet()) {
            data.setTerrainByViewLevel(viewLevel, (Terrain[][])terrainmap.get((Object)viewLevel));
        }
        data.generateOneTerrain = false;
        data.solidTerrain = null;
        data.iconStyle = SetupWorldRegionScreen.TerrainStyle.Isometric;
    }

    private static String getUpdatedTerrainName(String tname) {
        if (v1Tov2TerrainTypes.containsKey(tname)) {
            tname = v1Tov2TerrainTypes.get(tname);
        } else if (((String)tname).startsWith("ISO Cols ")) {
            if (Terrain.DEFAULT_TERRAIN.containsKey("ISO Cols/" + ((String)tname).substring(9))) {
                tname = "ISO Cols/" + ((String)tname).substring(9);
            }
        } else if (((String)tname).startsWith("ISO Rows ")) {
            if (Terrain.DEFAULT_TERRAIN.containsKey("ISO Rows/" + ((String)tname).substring(9))) {
                tname = "ISO Rows/" + ((String)tname).substring(9);
            }
        } else if (((String)tname).startsWith("Floor ") && Terrain.DEFAULT_TERRAIN.containsKey("Floor/" + ((String)tname).substring(6))) {
            tname = "Floor/" + ((String)tname).substring(6);
        }
        return tname;
    }

    public static void optimizedSplit(String s, String[] array, char ch, int indexstart) {
        int count = 0;
        int off = 0;
        int next = 0;
        while ((next = s.indexOf(ch, off)) != -1) {
            array[count] = s.substring(off, next);
            if (array[count].equals("Z")) {
                array[indexstart] = "0";
                array[indexstart + 1] = "0";
                array[indexstart + 2] = "0";
                array[indexstart + 3] = "0";
                array[indexstart + 4] = "0";
                array[indexstart + 5] = "0";
                count = indexstart + 5;
            }
            off = next + 1;
            ++count;
        }
        array[count] = s.substring(off);
        if (array[count].equals("Z")) {
            array[indexstart] = "0";
            array[indexstart + 1] = "0";
            array[indexstart + 2] = "0";
            array[indexstart + 3] = "0";
            array[indexstart + 4] = "0";
            array[indexstart + 5] = "0";
        }
    }

    static {
        v1Tov2FeatureTypes.put("Circle", "General/Circle");
        v1Tov2FeatureTypes.put("Ringed Circle", "General/Ringed Circle");
        v1Tov2FeatureTypes.put("Square", "General/Square");
        v1Tov2FeatureTypes.put("Ringed Square", "General/Ringed Square");
        v1Tov2FeatureTypes.put("Triangle", "General/Triangle");
        v1Tov2FeatureTypes.put("Ringed Triangle", "General/Ringed Triangle");
        v1Tov2FeatureTypes.put("Three Dots", "General/Three Dots");
        v1Tov2FeatureTypes.put("Star", "General/Star");
        v1Tov2FeatureTypes.put("Compass Rose", "General/Compass Rose");
        v1Tov2FeatureTypes.put("Other Volcano A", "Isometric Region/Other Volcano A");
        v1Tov2FeatureTypes.put("Other Volcano B", "Isometric Region/Other Volcano B");
        v1Tov2FeatureTypes.put("Other Volcano C", "Isometric Region/Other Volcano C");
        v1Tov2FeatureTypes.put("Symbol Geyser", "Classic/Natural Geyser");
        terrainPrefixes = new String[]{"Battlemat ", "Battlemat/", "Classic Coasts ", "Classic Water/Classic Coasts ", "Classic Lake ", "Classic Water/Classic Lake ", "Classic River ", "Classic Water/Classic River ", "Classic Shore ", "Classic Water/Classic Shore ", "Classic ", "Classic/", "Cosmic ", "Cosmic/", "Creature ", "Creature/", "Lineart ", "Lineart/", "Perspective ", "Perspective/", "Military ", "Classic/Military ", "Settlement Isometric ", "Isometric Region/Settlement ", "Building Isometric ", "Isometric Region/Building ", "Other Isometric ", "Isometric Region/Other ", "Other Isometric Other ", "Isometric Region/Other ", "Military Isometric ", "Isometric Region/Military ", "Building ", "Classic/Building ", "Settlement ", "Classic/Settlement ", "Symbol ", "Classic/Symbol ", "Natural ", "Classic/Natural ", "Structure ", "Settlement/", "Token ", "Token/", "Semi-Real ", "Battlemat/Semi-Real ", "Structure ", "Structure/", "Isometric Shore ", "Isometric Region/Shore ", "Isometric Mountain ", "Isometric Region/Mountain "};
        v1Tov2TerrainTypes = new HashMap<String, String>();
        v1Tov2TerrainTypes.put("Cosmic Stars", "Cosmic/Cosmic Stars");
        v1Tov2TerrainTypes.put("Cosmic Stars Inverted", "Cosmic/Cosmic Stars Inverted");
        v1Tov2TerrainTypes.put("Cosmic Nebula", "Cosmic/Cosmic Nebula");
        v1Tov2TerrainTypes.put("Cosmic Nebula Inverted", "Cosmic/Cosmic Nebula Inverted");
        v1Tov2TerrainTypes.put("Flat Beach", "Classic/Flat Beach");
        v1Tov2TerrainTypes.put("Flat Dead Forest", "Classic/Flat Forest Dead");
        v1Tov2TerrainTypes.put("Flat Dead Forest Wetlands", "Classic/Flat Forest Dead Wetlands");
        v1Tov2TerrainTypes.put("Flat Desert Cactus", "Classic/Flat Desert Cactus");
        v1Tov2TerrainTypes.put("Flat Desert Cactus Heavy", "Classic/Flat Desert Cactus Heavy");
        v1Tov2TerrainTypes.put("Flat Desert Coastal", "Classic/Flat Desert Coastal");
        v1Tov2TerrainTypes.put("Flat Desert Cold", "Classic/Flat Desert Cold");
        v1Tov2TerrainTypes.put("Flat Desert Dunes", "Classic/Flat Desert Dunes");
        v1Tov2TerrainTypes.put("Flat Desert Rocky", "Classic/Flat Desert Rocky");
        v1Tov2TerrainTypes.put("Flat Desert Sandy", "Classic/Flat Desert Sandy");
        v1Tov2TerrainTypes.put("Flat Farmland", "Classic/Flat Farmland");
        v1Tov2TerrainTypes.put("Flat Farmland Cultivated", "Classic/Flat Farmland Cultivated");
        v1Tov2TerrainTypes.put("Flat Forest Deciduous", "Classic/Flat Forest Deciduous");
        v1Tov2TerrainTypes.put("Flat Forest Deciduous Heavy", "Classic/Flat Forest Deciduous Heavy");
        v1Tov2TerrainTypes.put("Flat Forest Evergreen", "Classic/Flat Forest Evergreen");
        v1Tov2TerrainTypes.put("Flat Forest Evergreen Heavy", "Classic/Flat Forest Evergreen Heavy");
        v1Tov2TerrainTypes.put("Flat Forest Mixed", "Classic/Flat Forest Mixed");
        v1Tov2TerrainTypes.put("Flat Forest Mixed Heavy", "Classic/Flat Forest Mixed Heavy");
        v1Tov2TerrainTypes.put("Flat Forest Wetlands", "Classic/Flat Forest Wetlands");
        v1Tov2TerrainTypes.put("Flat Grassland", "Classic/Flat Grassland");
        v1Tov2TerrainTypes.put("Flat Grassland Poor", "Classic/Flat Grassland Poor");
        v1Tov2TerrainTypes.put("Flat Grazing Land", "Classic/Flat Grazing Land");
        v1Tov2TerrainTypes.put("Flat Forest Jungle", "Classic/Flat Forest Jungle");
        v1Tov2TerrainTypes.put("Flat Forest Jungle Heavy", "Classic/Flat Forest Jungle Heavy");
        v1Tov2TerrainTypes.put("Flat Marsh", "Classic/Flat Marsh");
        v1Tov2TerrainTypes.put("Flat Moor", "Classic/Flat Moor");
        v1Tov2TerrainTypes.put("Flat Moss", "Classic/Flat Moss");
        v1Tov2TerrainTypes.put("Flat Mud", "Classic/Flat Mud");
        v1Tov2TerrainTypes.put("Flat Savanna", "Classic/Flat Savanna");
        v1Tov2TerrainTypes.put("Flat Shrubland", "Classic/Flat Shrubland");
        v1Tov2TerrainTypes.put("Flat Snowfields", "Classic/Flat Snowfields");
        v1Tov2TerrainTypes.put("Flat Steppe", "Classic/Flat Steppe");
        v1Tov2TerrainTypes.put("Flat Swamp", "Classic/Flat Swamp");
        v1Tov2TerrainTypes.put("Flat Wetlands Evergreen", "Classic/Flat Wetlands Evergreen");
        v1Tov2TerrainTypes.put("Flat Wetlands Jungle", "Classic/Flat Wetlands Jungle");
        v1Tov2TerrainTypes.put("Hills", "Classic/Hills");
        v1Tov2TerrainTypes.put("Hills Dead Forest", "Classic/Hills Forest Dead");
        v1Tov2TerrainTypes.put("Hills Forest Deciduous", "Classic/Hills Forest Deciduous");
        v1Tov2TerrainTypes.put("Hills Forest Evergreen", "Classic/Hills Forest Evergreen");
        v1Tov2TerrainTypes.put("Hills Forest Mixed", "Classic/Hills Forest Mixed");
        v1Tov2TerrainTypes.put("Hills Grassland", "Classic/Hills Grassland");
        v1Tov2TerrainTypes.put("Hills Grassy", "Classic/Hills Grassy");
        v1Tov2TerrainTypes.put("Hills Forest Jungle", "Classic/Hills Forest Jungle");
        v1Tov2TerrainTypes.put("Hills Shrubland", "Classic/Hills Shrubland");
        v1Tov2TerrainTypes.put("Mountain", "Classic/Mountain");
        v1Tov2TerrainTypes.put("Mountain Dead Forest", "Classic/Mountain Forest Dead");
        v1Tov2TerrainTypes.put("Mountain Forest Deciduous", "Classic/Mountain Forest Deciduous");
        v1Tov2TerrainTypes.put("Mountain Forest Evergreen", "Classic/Mountain Forest Evergreen");
        v1Tov2TerrainTypes.put("Mountain Forest Jungle", "Classic/Mountain Forest Jungle");
        v1Tov2TerrainTypes.put("Mountain Forest Mixed", "Classic/Mountain Forest Mixed");
        v1Tov2TerrainTypes.put("Mountain Snowcapped", "Classic/Mountain Snowcapped");
        v1Tov2TerrainTypes.put("Mountain Volcano", "Classic/Mountain Volcano");
        v1Tov2TerrainTypes.put("Mountain Volcano Dormant", "Classic/Mountain Volcano Dormant");
        v1Tov2TerrainTypes.put("Mountains", "Classic/Mountains");
        v1Tov2TerrainTypes.put("Mountains Dead Forest", "Classic/Mountains Forest Dead");
        v1Tov2TerrainTypes.put("Mountains Forest Deciduous", "Classic/Mountains Forest Deciduous");
        v1Tov2TerrainTypes.put("Mountains Forest Evergreen", "Classic/Mountains Forest Evergreen");
        v1Tov2TerrainTypes.put("Mountains Forest Jungle", "Classic/Mountains Forest Jungle");
        v1Tov2TerrainTypes.put("Mountains Forest Mixed", "Classic/Mountains Forest Mixed");
        v1Tov2TerrainTypes.put("Mountains Glacier", "Classic/Mountains Glacier");
        v1Tov2TerrainTypes.put("Mountains Lava", "Classic/Mountains Lava");
        v1Tov2TerrainTypes.put("Mountains Snowcapped", "Classic/Mountains Snowcapped");
        v1Tov2TerrainTypes.put("Mountains Volcano", "Classic/Mountains Volcano");
        v1Tov2TerrainTypes.put("Mountains Volcano Dormant", "Classic/Mountains Volcano Dormant");
        v1Tov2TerrainTypes.put("Other Badlands", "Classic/Other Badlands");
        v1Tov2TerrainTypes.put("Other Broken Lands", "Classic/Other Broken Lands");
        v1Tov2TerrainTypes.put("Underdark Broken Lands", "Classic/Underdark Broken Lands");
        v1Tov2TerrainTypes.put("Underdark Forest Fungal", "Classic/Underdark Forest Fungal");
        v1Tov2TerrainTypes.put("Underdark Forest Fungal Heavy", "Classic/Underdark Forest Fungal Heavy");
        v1Tov2TerrainTypes.put("Underdark Open", "Classic/Underdark Open");
        v1Tov2TerrainTypes.put("Underdark Solid Rock", "Classic/Underdark Solid Rock");
        v1Tov2TerrainTypes.put("Water Ocean", "Classic/Water Ocean");
        v1Tov2TerrainTypes.put("Water Ocean Deep", "Classic/Water Ocean Deep");
        v1Tov2TerrainTypes.put("Water Kelp", "Classic/Water Kelp");
        v1Tov2TerrainTypes.put("Water Kelp Heavy", "Classic/Water Kelp Heavy");
        v1Tov2TerrainTypes.put("Water Reefs", "Classic/Water Reefs");
        v1Tov2TerrainTypes.put("Water Sea", "Classic/Water Sea");
        v1Tov2TerrainTypes.put("Water Sea Deep", "Classic/Water Sea Deep");
        v1Tov2TerrainTypes.put("Water Shoals", "Classic/Water Shoals");
        v1Tov2TerrainTypes.put("Full Badlands", "Full Classic/Full Badlands");
        v1Tov2TerrainTypes.put("Full Forest", "Full Classic/Full Forest");
        v1Tov2TerrainTypes.put("Full Mountains", "Full Classic/Full Mountains");
        v1Tov2TerrainTypes.put("Full Wheatfields", "Full Classic/Full Wheatfields");
        v1Tov2TerrainTypes.put("Floor Floor Grill Gray", "Floor/Grill Gray");
        v1Tov2TerrainTypes.put("Floor Floor Grill Brown", "Floor/Grill Brown");
        v1Tov2TerrainTypes.put("Floor/Floor/Grill Gray", "Floor/Grill Gray");
        v1Tov2TerrainTypes.put("Floor/Floor/Grill Brown", "Floor/Grill Brown");
        featurePrefixesV1 = new String[]{"Battlemat", "Classic", "Cosmic", "Creature", "Isometric", "Large Area", "Line Art", "Perspective", "Resource", "Structure", "Token"};
    }
}

