/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.map.MapKeyEntry;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.undo.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javafx.concurrent.Task;
import javafx.scene.paint.Color;

public class SaveMapTask
extends Task<Integer> {
    final File file;
    final MapData mapData;
    final ViewLevel currentViewLevel;
    final double hScrollbarPos;
    final double vScrollbarPos;

    public SaveMapTask(Worldographer worldographer, File f, MapData md, ViewLevel currentviewlevel, double hScrollbarPos, double vScrollbarPos) {
        this.file = f;
        this.mapData = md;
        this.currentViewLevel = currentviewlevel;
        this.hScrollbarPos = hScrollbarPos;
        this.vScrollbarPos = vScrollbarPos;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
    }

    protected Integer call() throws Exception {
        this.updateMessage("Starting . . .");
        this.saveFile();
        this.updateMessage("Finished.");
        return 1;
    }

    public void saveFile() throws Exception {
        String tempfilename = this.file.getAbsolutePath().substring(0, this.file.getAbsolutePath().length() - 4) + "-tmp.wxx";
        File tempfile = new File(tempfilename);
        FileOutputStream fos = new FileOutputStream(tempfile);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), StandardCharsets.UTF_16);
        Map<String, Integer> terrainmap = this.mapData.makeTerrainMap();
        StringBuilder tmsb = new StringBuilder();
        for (String key : terrainmap.keySet()) {
            tmsb.append(key).append("\t").append(terrainmap.get(key)).append("\t");
        }
        String terrainmapstring = tmsb.toString().trim();
        String maptype = "WORLD";
        if (this.mapData.getTerrain(ViewLevel.COSMIC) != null) {
            maptype = "COSMIC";
        }
        if (this.mapData.getTerrain(ViewLevel.SETTLEMENT) != null) {
            maptype = "SETTLEMENT";
        }
        if (this.mapData.getTerrain(ViewLevel.BATTLEMAT) != null) {
            maptype = "BATTLEMAT";
        }
        StringBuilder sb = new StringBuilder("<?xml version='1.1' encoding='utf-16'?>\n<map type=\"" + maptype + "\" release=\"2025\" version=\"1.13\" schema=\"1.01\" lastViewLevel=\"" + String.valueOf((Object)this.currentViewLevel) + "\" continentFactor=\"" + this.mapData.getView().getContinentFactor() + "\" kingdomFactor=\"" + this.mapData.getView().getKingdomFactor() + "\" provinceFactor=\"" + this.mapData.getView().getProvinceFactor() + "\" ");
        sb.append("worldToContinentHOffset=\"").append(this.mapData.getView().getWorldToContinentHOffset()).append("\" continentToKingdomHOffset=\"").append(this.mapData.getView().getContinentToKingdomHOffset()).append("\" kingdomToProvinceHOffset=\"").append(this.mapData.getView().getKingdomToProvinceHOffset()).append("\" ");
        sb.append("worldToContinentVOffset=\"").append(this.mapData.getView().getWorldToContinentVOffset()).append("\" continentToKingdomVOffset=\"").append(this.mapData.getView().getContinentToKingdomVOffset()).append("\" kingdomToProvinceVOffset=\"").append(this.mapData.getView().getKingdomToProvinceVOffset()).append("\" ");
        if (WorldAndNameData.datafile != null) {
            sb.append("dataFile=\"").append(MapDataIO.toEscapedXML(WorldAndNameData.datafile)).append("\" ");
        }
        if (this.mapData.getTrace().getImageFileName() != null) {
            sb.append("\ntraceImageFileName=\"").append(MapDataIO.toEscapedXML(this.mapData.getTrace().getImageFileName())).append("\" traceOpacity=\"").append(this.mapData.getTrace().getOpacity()).append("\" traceWidth=\"").append(this.mapData.getTrace().getWidth()).append("\" traceHeight=\"").append(this.mapData.getTrace().getHeight()).append("\" traceTopLeftX=\"").append(this.mapData.getTrace().getTopLeftX()).append("\" traceTopLeftY=\"").append(this.mapData.getTrace().getTopLeftY()).append("\" ");
        }
        sb.append("\nhScrollbarPos=\"").append(this.hScrollbarPos).append("\" vScrollbarPos=\"").append(this.vScrollbarPos).append("\" ");
        sb.append("\nhexWidth=\"").append(this.mapData.getTileWidth()).append("\" hexHeight=\"").append(this.mapData.getTileHeight()).append("\" hexOrientation=\"").append(this.mapData.getTileOrientation().name()).append("\" mapProjection=\"").append(this.mapData.getMapProjection().name()).append("\"").append(" showNotes=\"").append(this.mapData.getShow().isNotes()).append("\" showGMOnly=\"").append(this.mapData.getShow().isGMOnly()).append("\" showGMOnlyGlow=\"").append(this.mapData.getShow().isGMOnlyGlow()).append("\" ").append("showFeatureLabels=\"").append(this.mapData.getShow().isFeatureLabels()).append("\" showGrid=\"").append(this.mapData.getShow().isGrid()).append("\" showGridNumbers=\"").append(this.mapData.getShow().isGridNumbers()).append("\" showShadows=\"").append(this.mapData.getShow().isShadows()).append("\" ").append(" triangleSize=\"").append(this.mapData.getView().getTriangleSize(ViewLevel.WORLD)).append("\">\n");
        sb.append("<gridandnumbering color0=\"").append(this.mapData.getGrid().getColor()[0]).append("\" color1=\"").append(this.mapData.getGrid().getColor()[1]).append("\" color2=\"").append(this.mapData.getGrid().getColor()[2]).append("\" color3=\"").append(this.mapData.getGrid().getColor()[3]).append("\" color4=\"").append(this.mapData.getGrid().getColor()[4]).append("\" ");
        sb.append("width0=\"").append(this.mapData.getGrid().getWidth()[0]).append("\" width1=\"").append(this.mapData.getGrid().getWidth()[1]).append("\" width2=\"").append(this.mapData.getGrid().getWidth()[2]).append("\" width3=\"").append(this.mapData.getGrid().getWidth()[3]).append("\" width4=\"").append(this.mapData.getGrid().getWidth()[4]).append("\" ");
        sb.append("gridOffsetContinentKingdomX=\"").append(this.mapData.getView().getGridOffsetContinentKingdomX()).append("\" gridOffsetContinentKingdomY=\"").append(this.mapData.getView().getGridOffsetContinentKingdomY()).append("\" ").append("gridOffsetWorldContinentX=\"").append(this.mapData.getView().getGridOffsetWorldContinentX()).append("\" gridOffsetWorldContinentY=\"").append(this.mapData.getView().getGridOffsetWorldContinentY()).append("\" ").append("gridOffsetWorldKingdomX=\"").append(this.mapData.getView().getGridOffsetWorldKingdomX()).append("\" gridOffsetWorldKingdomY=\"").append(this.mapData.getView().getGridOffsetWorldKingdomY()).append("\" ");
        sb.append("gridSquare=\"").append(this.mapData.getGrid().getSquare()).append("\" gridSquareHeight=\"").append(this.mapData.getGrid().getSquareHeight()).append("\" gridSquareWidth=\"").append(this.mapData.getGrid().getSquareWidth()).append("\" ").append("gridOffsetX=\"").append(this.mapData.getGrid().getOffsetX()).append("\" gridOffsetY=\"").append(this.mapData.getGrid().getOffsetY()).append("\" ");
        sb.append("numberFont=\"").append(this.mapData.getNumbering().getFontName()).append("\" numberColor=\"").append(this.mapData.getNumbering().getFontColor()).append("\" ").append("numberSize=\"").append(this.mapData.getNumbering().getFontSize()).append("\" numberStyle=\"").append((Object)this.mapData.getNumbering().getFontStyle()).append("\" ").append("numberFirstCol=\"").append(this.mapData.getNumbering().getFirstColumn()).append("\" numberFirstRow=\"").append(this.mapData.getNumbering().getFirstRow()).append("\" ").append("numberOrder=\"").append((Object)this.mapData.getNumbering().getOrder()).append("\" numberPosition=\"").append((Object)this.mapData.getNumbering().getPosition()).append("\" ");
        sb.append("numberPrePad=\"").append(this.mapData.getNumbering().getPrePadNums().name()).append("\" numberSeparator=\"").append(this.mapData.getNumbering().getSeparator()).append("\" ").append("/>\n");
        sb.append("<terrainmap>").append(terrainmapstring).append("</terrainmap>\n");
        w.write(sb.toString());
        w.flush();
        sb = new StringBuilder();
        for (MapLayer mapLayer : this.mapData.getMapLayers()) {
            sb.append("<maplayer name=\"").append(MapDataIO.toEscapedXML(mapLayer.getName())).append("\" isVisible=\"").append(mapLayer.isVisible()).append("\" opacity=\"").append(mapLayer.getOpacity()).append("\"/>\n");
        }
        w.write(sb.toString());
        w.flush();
        this.updateMessage("Saving Tiles...");
        MapDataIO.getTilesXMLString(this.mapData, w, terrainmap, this);
        this.updateMessage("Saving Map Key...");
        sb = new StringBuilder();
        if (this.mapData.getMapKeySettings() != null) {
            Color titlefontcolor = this.mapData.getMapKeySettings().titleFontColor;
            Color color = this.mapData.getMapKeySettings().scaleFontColor;
            Color entryfontcolor = this.mapData.getMapKeySettings().entryFontColor;
            Color bgcolor = this.mapData.getMapKeySettings().backgroundColor;
            String bgcolorstring = bgcolor.getRed() + "," + bgcolor.getGreen() + "," + bgcolor.getBlue() + "," + bgcolor.getOpacity();
            sb.append("<mapkey positionx=\"").append(this.mapData.getMapKeySettings().positionx).append("\" positiony=\"").append(this.mapData.getMapKeySettings().positiony).append("\" viewlevel=\"").append((Object)this.mapData.getMapKeySettings().viewlevel).append("\" height=\"").append(this.mapData.getMapKeySettings().height).append("\" backgroundcolor=\"").append(bgcolorstring).append("\" backgroundopacity=\"").append(this.mapData.getMapKeySettings().backgroundOpacity).append("\" titleText=\"").append(MapDataIO.toEscapedXML(this.mapData.getMapKeySettings().titleText)).append("\" ").append("titleFontFace=\"").append(this.mapData.getMapKeySettings().titleFontFace).append("\" ");
            if (titlefontcolor != null) {
                sb.append(" titleFontColor=\"").append(titlefontcolor.getRed()).append(",").append(titlefontcolor.getGreen()).append(",").append(titlefontcolor.getBlue()).append(",").append(titlefontcolor.getOpacity()).append("\" ");
            } else {
                sb.append(" titlefontcolor=\"null\" ");
            }
            sb.append("titleFontBold=\"").append(this.mapData.getMapKeySettings().titleFontBold).append("\" titleFontItalic=\"").append(this.mapData.getMapKeySettings().titleFontItalic).append("\" ").append("titleScale=\"").append(this.mapData.getMapKeySettings().titleScale).append("\" scaleText=\"").append(MapDataIO.toEscapedXML(this.mapData.getMapKeySettings().scaleText)).append("\" ").append("scaleFontFace=\"").append(this.mapData.getMapKeySettings().scaleFontFace).append("\" ");
            if (color != null) {
                sb.append(" scaleFontColor=\"").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(",").append(color.getOpacity()).append("\" ");
            } else {
                sb.append(" scalefontcolor=\"null\" ");
            }
            sb.append("scaleFontBold=\"").append(this.mapData.getMapKeySettings().scaleFontBold).append("\" scaleFontItalic=\"").append(this.mapData.getMapKeySettings().scaleFontItalic).append("\" ").append("scaleScale=\"").append(this.mapData.getMapKeySettings().scaleScale).append("\" entryFontFace=\"").append(this.mapData.getMapKeySettings().entryFontFace).append("\" ");
            if (entryfontcolor != null) {
                sb.append(" entryFontColor=\"").append(entryfontcolor.getRed()).append(",").append(entryfontcolor.getGreen()).append(",").append(entryfontcolor.getBlue()).append(",").append(entryfontcolor.getOpacity()).append("\" ");
            } else {
                sb.append(" entryfontcolor=\"null\" ");
            }
            sb.append("entryFontBold=\"").append(this.mapData.getMapKeySettings().entryFontBold).append("\" ").append("entryFontItalic=\"").append(this.mapData.getMapKeySettings().entryFontItalic).append("\" entryScale=\"").append(this.mapData.getMapKeySettings().entryScale).append("\"  >\n");
            w.write(sb.toString());
            w.flush();
            sb = new StringBuilder();
            Map<String, MapKeyEntry> entries = this.mapData.getMapKeySettings().entries;
            if (entries != null) {
                for (MapKeyEntry mke : entries.values()) {
                    if (mke == null) continue;
                    try {
                        w.write(mke.getXMLString());
                        w.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            w.write("</mapkey>\n");
            w.flush();
        }
        w.write(sb.toString());
        sb = new StringBuilder();
        this.updateMessage("Saving Features (+" + this.mapData.getFeatures().size() + ")...");
        sb.append("<features>\n");
        for (Feature feature : this.mapData.getFeatures()) {
            if (feature == null || feature.getMapLayer() == null) continue;
            sb.append(feature.getXMLString());
            w.flush();
        }
        sb.append("</features>\n");
        w.write(sb.toString());
        sb = new StringBuilder();
        w.flush();
        this.updateMessage("Saving Extra Terrain (+" + this.mapData.getFeatures().size() + ")...");
        w.write("<extraTerrain>\n");
        for (MapLayer mapLayer : this.mapData.getExtraTerrainByLayer().keySet()) {
            w.write("\t<mapLayer name=\"" + mapLayer.getName() + "\">\n");
            for (Point location : this.mapData.getExtraTerrainByLayer().get(mapLayer).keySet()) {
                Terrain terrain = this.mapData.getExtraTerrainByLayer().get(mapLayer).get(location);
                String escapedName = MapDataIO.toEscapedXML(terrain.getTypeName());
                w.write("\t\t<terrainAndLocation name=\"" + escapedName + "\" elevation=\"" + terrain.getElevation() + "\" icy=\"" + terrain.isIcy() + "\" gmOnly=\"" + terrain.isGmOnly() + "\" resources=\"");
                if (terrain.getExtraInfo().areAllResourcesButFirstZero()) {
                    w.write("Z");
                } else {
                    for (int k = 0; k < ResourceType.values().length; ++k) {
                        if (k > 0) {
                            w.write(",");
                        }
                        w.write("" + terrain.getExtraInfo().getResources()[k]);
                    }
                }
                w.write("\"");
                if (terrain.getBackgroundColor() != null) {
                    w.write(" bgColor=\"" + terrain.getBackgroundColor().getRed() + "," + terrain.getBackgroundColor().getGreen() + "," + terrain.getBackgroundColor().getBlue() + "," + terrain.getBackgroundColor().getOpacity() + "\"");
                }
                w.write(" location=\"" + location.getX() + "," + location.getY() + "\" />\n");
            }
            w.write("\t</mapLayer>\n");
        }
        w.write("</extraTerrain>\n");
        w.flush();
        this.updateMessage("Saving Labels (+" + this.mapData.getMapLabels().size() + ")...");
        sb.append("<labels>\n");
        for (MapLabel mapLabel : this.mapData.getMapLabels()) {
            if (mapLabel == null) continue;
            sb.append(mapLabel.getXMLString());
            w.flush();
        }
        sb.append("</labels>\n");
        w.write(sb.toString());
        sb = new StringBuilder();
        w.flush();
        this.updateMessage("Saving Shapes (+" + this.mapData.getShapes().size() + ")...");
        sb.append("<shapes>\n");
        for (MapShape mapShape : this.mapData.getShapes()) {
            if (mapShape == null || mapShape.getShapePoints().size() <= 0) continue;
            sb.append(mapShape.getXMLString());
            w.flush();
        }
        sb.append("</shapes>\n");
        w.write(sb.toString());
        sb = new StringBuilder();
        w.flush();
        this.updateMessage("Saving Notes (+" + this.mapData.getNotes().size() + ")...");
        sb.append("<notes>\n");
        for (Note note : this.mapData.getNotes()) {
            if (note == null) continue;
            sb.append(note.getXMLString());
            w.flush();
        }
        sb.append("</notes>\n");
        w.write(sb.toString());
        sb = new StringBuilder();
        w.flush();
        this.updateMessage("Saving Information (+" + this.mapData.getInformation().size() + ")...");
        w.write("<informations>\n");
        if (this.mapData.getInformation() != null) {
            for (Information information : this.mapData.getInformation()) {
                if (information == null) continue;
                information.writeXMLString(w);
            }
        }
        w.write("</informations>\n");
        w.flush();
        this.updateMessage("Saving Configuration Info...");
        MapDataIO.writeConfigString(this.mapData, w);
        sb.append("</map>");
        w.write(sb.toString());
        w.close();
        this.file.delete();
        boolean result = tempfile.renameTo(this.file);
        this.updateMessage("Rename file without '-tmp' result:" + result);
    }

    public void updateMessagePublic(String message) {
        this.updateMessage(message);
    }
}

