/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.ui.Worldographer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Launcher
extends Frame
implements ActionListener {
    private static final WindowListener closeWindow = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            e.getWindow().dispose();
        }
    };

    static void renderSplashFrame(Graphics2D g, int frame) {
        String[] comps = new String[]{"foo", "bar", "baz"};
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(120, 140, 200, 40);
        g.setPaintMode();
        g.setColor(Color.BLACK);
        g.drawString("Loading " + comps[frame / 5 % 3] + "...", 120, 150);
    }

    public Launcher() {
        super("SplashScreen demo");
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        Menu m1 = new Menu("File");
        MenuItem mi1 = new MenuItem("Exit");
        m1.add(mi1);
        mi1.addActionListener(this);
        this.addWindowListener(closeWindow);
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        mb.add(m1);
        Frame[] splash = Launcher.getFrames();
        if (splash == null) {
            System.out.println("SplashScreen.getSplashScreen() returned null");
            return;
        }
        Graphics2D g = (Graphics2D)splash[0].getGraphics();
        if (g == null) {
            System.out.println("g is null");
            return;
        }
        for (int i = 0; i < 100; ++i) {
            Launcher.renderSplashFrame(g, i);
            splash[0].update(g);
            try {
                Thread.sleep(90L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("Launching launch screen");
        Frame f = new Frame("Worldographer Launching...");
        System.out.println("Made frame");
        try {
            InputStream isCorner = Launcher.class.getResourceAsStream("other_imgs/cornerlogo.png");
            System.out.println("isCorner 1");
            if (isCorner != null) {
                BufferedImage imagecorner = ImageIO.read(isCorner);
                f.setIconImage(imagecorner);
            }
            System.out.println("Turned the Corner");
            InputStream is = Launcher.class.getResourceAsStream("other_imgs/splash.png");
            System.out.println("Got InputStream");
            if (is != null) {
                BufferedImage image = ImageIO.read(is);
                System.out.println("Image read");
                f.setSize(1000, 300);
                System.out.println("Get screen");
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                System.out.println("Setting frame properties");
                f.setLocation((int)(screen.getWidth() - 1000.0) / 2, (int)(screen.getHeight() - 300.0) / 2);
                f.setUndecorated(true);
                f.setVisible(true);
                System.out.println("Draw string");
                f.getGraphics().drawString(" ", 10, 60);
                System.out.println("Drawing image");
                f.getGraphics().drawImage(image, 5, 5, null);
                System.out.println("Image drawn");
            }
            System.out.println("Add window");
            f.addWindowListener(closeWindow);
            System.out.println("Window ready");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Setting splash");
        Worldographer.setSplashFrame(f);
        System.out.println("Splash set");
        Worldographer.main(args);
    }
}

