/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.map.MapShape;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.stage.Stage;

public class ShapeTest
extends Application {
    final List<MapShape> mapShapes;
    final double width;
    final double height;
    public Shape subtract;

    public ShapeTest(List<MapShape> shapes, double width, double height) {
        this.mapShapes = shapes;
        this.width = width;
        this.height = height;
    }

    public static void main(String[] args) {
        ShapeTest.launch((String[])args);
    }

    public final void start(Stage stage) throws IOException {
        AnchorPane pane = new AnchorPane();
        pane.setMinSize(6000.0, 6000.0);
        pane.setStyle("-fx-background-color: lightgray;");
        ScrollPane sp = new ScrollPane((Node)pane);
        VBox root = new VBox(new Node[]{sp});
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        stage.setTitle("add none");
        stage.setScene(new Scene((Parent)root));
        double size = 400.0;
        stage.setWidth(size + 50.0);
        stage.setHeight(size + 70.0);
        this.draw(pane);
        stage.show();
        this.write();
    }

    private void write() {
        try {
            File out = new File("C:\\Users\\Joe\\Documents\\subtractout.txt");
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            Path spath = (Path)this.subtract;
            bw.write("<shape  type=\"Path\" fillRule=\"" + String.valueOf(spath.getFillRule()) + "\" isCurve=\"false\" isGMOnly=\"false\" isSnapVertices=\"false\" tags=\"\" creationType=\"BASIC\" isDropShadow=\"false\" isInnerShadow=\"false\" isBoxBlur=\"false\" isWorld=\"true\" isContinent=\"true\" isKingdom=\"true\" isProvince=\"true\" dsSpread=\"0.2\" dsRadius=\"50.0\" dsOffsetX=\"0.0\" dsOffsetY=\"0.0\" insChoke=\"0.2\" insRadius=\"50.0\" insOffsetX=\"0.0\" insOffsetY=\"0.0\" bbWidth=\"10.0\" bbHeight=\"10.0\" bbIterations=\"3\" mapLayer=\"ABOVE_TERRAIN\" fillTexture=\"\" strokeTexture=\"\" strokeType=\"0\" highestViewLevel=\"WORLD\" currentShapeViewLevel=\"WORLD\" lineCap=\"SQUARE\" lineJoin=\"ROUND\" opacity=\"1.0\" fillColor=\"0.55,0.7,0.85,1.0\" strokeColor=\"0.55,0.7,0.85,1.0\" strokeWidth=\"0.00\" dsColor=\"1.0,0.8941176533699036,0.7686274647712708,1.0\" insColor=\"1.0,0.8941176533699036,0.7686274647712708,1.0\">\r\n");
            long linecounter = 0L;
            for (PathElement pe : spath.getElements()) {
                if (pe instanceof LineTo) {
                    bw.write(" <p x=\"" + ((LineTo)pe).getX() + "\" y = \"" + ((LineTo)pe).getY() + "\"/>");
                } else if (pe instanceof MoveTo) {
                    bw.write(" <p type=\"m\" x=\"" + ((MoveTo)pe).getX() + "\" y = \"" + ((MoveTo)pe).getY() + "\"/>");
                } else if (pe instanceof CubicCurveTo) {
                    bw.write(" <p type=\"c\" x=\"" + ((CubicCurveTo)pe).getX() + "\" y = \"" + ((CubicCurveTo)pe).getY() + "\" cx1=\"" + ((CubicCurveTo)pe).getControlX1() + "\" cy1 = \"" + ((CubicCurveTo)pe).getControlY1() + "\" cx2=\"" + ((CubicCurveTo)pe).getControlX2() + "\" cy2 = \"" + ((CubicCurveTo)pe).getControlY2() + "\"/>");
                } else if (pe instanceof ClosePath) {
                    bw.write(" <p type=\"close\"/>");
                }
                bw.flush();
                if (++linecounter % 50L != 0L) continue;
                bw.write("\n");
            }
            bw.write("</shape>\n");
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void draw(AnchorPane pane) {
        double[] pts1 = new double[]{0.0, 0.0, this.width, 0.0, this.width, this.height, 0.0, this.height};
        double[] pts2 = new double[]{200.0, 100.0, 200.0, 200.0, 400.0, 200.0, 400.0, 150.0};
        this.subtract = new Polygon(pts1);
        this.subtract.setFill((Paint)Color.BLUE);
        this.subtract.setStroke((Paint)Color.RED);
        this.subtract.setStrokeWidth(0.0);
        this.subtract.setOpacity(100.0);
        pane.getChildren().add((Object)this.subtract);
        int count = 0;
        for (MapShape ms : this.mapShapes) {
            Polygon p;
            Shape s = ms.getShape();
            if (s instanceof Polygon && ((Color)(p = (Polygon)s).getFill()).getGreen() > 0.9) {
                pane.getChildren().add((Object)s);
                this.subtract = Shape.subtract((Shape)this.subtract, (Shape)s);
                pane.getChildren().remove((Object)s);
            }
            ++count;
        }
        this.subtract.setFill((Paint)Color.ALICEBLUE);
        this.subtract.setStroke((Paint)Color.LIME);
        this.subtract.setStrokeWidth(0.0);
        pane.getChildren().add((Object)this.subtract);
    }
}

