/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.stage.Stage;

public class TestDraw
extends Application {
    private Line curLine;

    public static void main(String[] args) {
        TestDraw.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Pane drawingPane = new Pane();
        drawingPane.setPrefSize(800.0, 800.0);
        drawingPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        ScrollPane scrollPane = new ScrollPane((Node)drawingPane);
        scrollPane.setPrefSize(300.0, 300.0);
        scrollPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setStyle("-fx-focus-color: transparent;");
        drawingPane.setOnMousePressed(event -> {
            if (!event.isPrimaryButtonDown()) {
                return;
            }
            this.curLine = new Line(event.getX(), event.getY(), event.getX(), event.getY());
            drawingPane.getChildren().add((Object)this.curLine);
        });
        drawingPane.setOnMouseDragged(event -> {
            if (!event.isPrimaryButtonDown()) {
                return;
            }
            if (this.curLine == null) {
                return;
            }
            this.curLine.setEndX(event.getX());
            this.curLine.setEndY(event.getY());
            double mx = Math.max(this.curLine.getStartX(), this.curLine.getEndX());
            double my = Math.max(this.curLine.getStartY(), this.curLine.getEndY());
            if (mx > drawingPane.getMinWidth()) {
                drawingPane.setMinWidth(mx);
            }
            if (my > drawingPane.getMinHeight()) {
                drawingPane.setMinHeight(my);
            }
        });
        drawingPane.setOnMouseReleased(event -> {
            this.curLine = null;
        });
        Scene scene = new Scene((Parent)scrollPane);
        stage.setMinWidth(100.0);
        stage.setMinHeight(100.0);
        stage.setScene(scene);
        stage.show();
    }
}

