/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.generator.city.SettlementData;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureCityDataScreen
extends ConfigureScreen {
    Tab buildingDescsTab;
    Tab buildingPlacementTab;
    Tab racesTab;
    final ComboBox<String> buildingscombo = new ComboBox();
    final Map<String, TextField> raceKeyTFsMap = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> raceMinAgesSpinnersMap = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> raceMaxAgesSpinnersMap = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> raceChanceSpinnersMap = new HashMap<String, Spinner<Integer>>();
    final Map<String, TextField> raceLangSourcesTFMap = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeRaceCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> buildingItemTypeTFs = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> buildingItemMinSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingItemMaxSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, TextField> buildingItemUnitTFs = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> buildingItemAvailSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingItemMaxQuantSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, CheckBox> removeBuildingItemCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> buildingTableTFsMap = new HashMap<String, TextField>();
    final Map<String, TextField> buildingPersonTypeTFs = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> buildingPersonMinGroupsSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonMaxGroupsSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonMinPerGroupSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonMaxPerGroupSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonChanceAdvSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonChanceFemaleSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, Spinner<Integer>> buildingPersonChanceMinChildAgeSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, CheckBox> removeBuildingPersonCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> keyTFsMap = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> perPopulationSpinnersMap = new HashMap<String, Spinner<Integer>>();
    final Map<String, CheckBox> onRoadCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> farmCBsMap = new HashMap<String, CheckBox>();
    final Map<String, ComboBox<String>> placementCombosMap = new HashMap<String, ComboBox<String>>();
    final Map<String, Spinner<Integer>> distanceSpinnersMap = new HashMap<String, Spinner<Integer>>();
    final Map<String, CheckBox> denseCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> removePlacementCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> wordlistTFsMap = new HashMap<String, TextField>();
    final Map<String, TextField> buildingNameTFsMap = new HashMap<String, TextField>();
    final TextField advBgTF = new TextField();
    final TextField occupationsTF = new TextField();
    final TextField quirksTF = new TextField();
    final TextField remainingBuildingsTF = new TextField();
    final CheckBox clearPriorDataCheckBox = new CheckBox("Clear Prior Data     ");
    int numRaceRows;
    int numBuildingRows;
    int numBuildingPlacementRows;
    int numBuildingNamingRows;

    public ConfigureCityDataScreen(Worldographer ms) {
        super(ms, 1060, 400);
        if (CityDataGenerator.settlementData.getRaces().size() == 0) {
            CityDataGenerator.parseSettings(new LoadGeneratorData().getCityMedieval(), false);
        }
    }

    @Override
    public void setValues() {
        this.title = "Configure Settlement Data";
        this.configureLabel = "";
        this.configureTitle = "Configure Settlement Data Instructions";
        this.configureHeader = "Configure Settlement Data Instructions";
        this.configureScreenHelpText = "<p>These tabs control how settlements (cities & villages) are created.</p>\n<p>Note: You must click 'apply' for the changes to take effect.</p>\n<p>'Save Configuration' performs an 'apply' before saving.</p>\n\n<h3>Building Placement Tab</h3>\n<ul>\n<li>Key: Building name.  Uses a partial match to determine which buildings this row of settings will\napply to.  So a 'Dwarven Inn' will use this row's data if the key is 'Inn' and there is no 'Dwarven Inn'\nalso defined.</li>\n<li>#/Population: One of these buildings will be placed for every X people in the city/village. So a\nvalue of 500 and a city population of 5000 will result in 10 of these on the map.</li>\n<li>On Road: Should this building type be placed on a road?</li>\n<li>Is Farm: Some city generation algoritms in the future may use this.  Not used now.</li>\n<li>Placement: Should the building be placed near the city center, far away, or it doesn't matter?</li>\n<li>Distance: If placement is near or far, what is the dividing point (number of hexes).</li>\n<li>Dense?: Some city generation algoritms in the future may use this.  Not used now.</li>\n</ul>\n<h3>Building Descriptions Tab</h3>\n<p>Buildings can have data generated about them.  Select a building type from the drop-down\nand its current values will be displayed. Remove Selected will remove the data setup for the currently\nchosen building type. Clone Selected duplicates the currently selected building type as a new building\ntype; it will prompt you for a name of the new building type. Add New prompts you for a new building\ntype which initially has no data. A building can have several tables.  To add one, click the Add Table\nbutton. It will ask if the table is of items or people, then add it to the list of tables with a temporary\n name. Change the table name/title by changing the value in the Title textbox.  Add a row by clicking the\n Add Row button to the right side. Delete the entire table by clicking the Remove Table checkbox and\n clicking Apply.<p>A person table has the following columns:<ul>\n<li>Group type: This is the column under the Person Table Title.  It allows you to specific\nthis row generates a number of people of a type (cooks, waiters, barbers, whatever).</li><li>Min Groups:\nMinimum number of groups of this type of people.</li><li>Max Groups: Maximum number of groups of this\ntype of people.</li><li>Min/Group: Minimum number of people in each group.</li><li>Max/group: Maximum\nnumber of people in each group.</li><li>%Adv.: Percent chance each member is an adventurer.</li><li>%Female:\nPercent chance each memeber is female.</li><li>Remove Row: Check this box to remove the row, and click\nApply below.</li>\n</ul><p>An item table has the following columns:<ul><li>Item name: this is the first column\nunder the Item Table Title. The item name should go in the textfield.<li><li>Min Price: Minimum price of\nthe item.</li><li>Max Price: Maximum price of the item.</li><li>Unit: Enter the unit for the item prices.\n(gp, dollars, credits, etc.)</li><li>Available %: The chance that a store will have any in stock.</li>\n<li>Max Avail.: If a store has some in stock, the number will be between 1 and this number.</li><li>Remove\nRow: Check this box to remove the row, and click Apply below.</li>\n</ul>\n<h3>Races Tab</h3>\n<p>Use this table to enter the races found on your world.<ul><li>Name: name of the race.</li><li>Min\nAge: minimum age of an adult.</li><li>Max Age: maximum age or a member of the race.</li><li>Chance:\nAll the values in this column should total 100. The number is the percent chance any person is a member of\nthat race.</li><li>Language Sources: Comma separated list of the languages the race speaks and the percent\nchance of each.  The percentages for the race's languages should equal 100.</li><li>Remove: Check this\nbox to remove the row, and click Apply below.</li></ul><h3>Other Info Tab</h3><p>Used to generate values\nand other miscellaneous data/settlement generation tasks:<ul><li>Adv. Background: Possible adventure\nbackgrounds, comma separated.</li>\n<li>Occupation: Possible occupations, comma separated.</li>\n<li>Quirks: Possible quirks, comma separated.</li>\n<li>Remaining Buildings: Which buildings are used to fill out the settlement, comma separated. These\nwill likely be the most common buildings on the map.</li>\n<li>Building Name Word Lists: Used with the Building Naming section (see below) these lists give\npossible values to substitute into possible building names.</li>\n<li>Building Naming: Templates for building names by building type. Any all-caps word is checked for\na substitution word. Ex: If a value for shop is 'The MATERIAL Coin' and the MATERIAL word list is\n'Ivory, Ebony, Stone, Wooden, ...' then a shop name may be 'The Wooden Coin'.</li>\n</ul><h3>Load/Save/Close/Apply</h3><ul><li>Load Configuration: Load saved settlement configuration\ndata.</li><li>Save Configuration: Save the current settlement configuration data. Implicitly calls\n'Apply' in case there are unsaved changes.</li><li>Close: Closes the dialog without saving.</li>\n<li>Apply: Stores the configuration changes for use until Worldographer restarts.</li></ul>";
    }

    @Override
    protected HBox createBottomBar() {
        HBox bottombar = super.createBottomBar();
        bottombar.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        bottombar.getChildren().add(0, (Object)this.clearPriorDataCheckBox);
        Label loadLabel = new Label("Load Preset:");
        bottombar.setAlignment(Pos.CENTER);
        bottombar.getChildren().add(1, (Object)loadLabel);
        Object[] presets = new String[]{"Medieval", "Modern", "Post-Apocalypse", "Futuristic Clean", "Futuristic Gritty", "Futuristic Retro", "Western"};
        ObservableList presetList = FXCollections.observableArrayList((Object[])presets);
        ComboBox presetCombo = new ComboBox(presetList);
        presetCombo.setMaxWidth(200.0);
        bottombar.getChildren().add(2, (Object)presetCombo);
        presetCombo.setOnAction(t -> {
            String chosen = (String)presetCombo.getSelectionModel().getSelectedItem();
            LoadGeneratorData lgd = new LoadGeneratorData();
            if (chosen.equals("Medieval")) {
                this.loadCityDataAndShowDialog(lgd.getCityMedieval());
            } else if (chosen.equals("Modern")) {
                this.loadCityDataAndShowDialog(lgd.getCityModern());
            } else if (chosen.equals("Post-Apocalypse")) {
                this.loadCityDataAndShowDialog(lgd.getCityPostApocalypse());
            } else if (chosen.equals("Futuristic Clean")) {
                this.loadCityDataAndShowDialog(lgd.getCitySFClean());
            } else if (chosen.equals("Futuristic Gritty")) {
                this.loadCityDataAndShowDialog(lgd.getCitySFGritty());
            } else if (chosen.equals("Futuristic Retro")) {
                this.loadCityDataAndShowDialog(lgd.getCitySFRetro());
            } else if (chosen.equals("Western")) {
                this.loadCityDataAndShowDialog(lgd.getCityWestern());
            } else {
                File f = new File(chosen);
                try {
                    FileInputStream fis = new FileInputStream(f);
                    CityDataGenerator.parseSettings(fis, this.clearPriorDataCheckBox.isSelected());
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while loading your file.", "The stacktrace was:", e);
                }
            }
        });
        Button loadButton = new Button("Load Configuration");
        loadButton.setOnAction(t -> {
            File f;
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" XML (*.xml)", new String[]{"*.xml"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog(null)) != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    CityDataGenerator.parseSettings(fis, this.clearPriorDataCheckBox.isSelected());
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    this.primaryStage.close();
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Loaded", "Settlement Configuration Loaded", "Reopen the settlement configuration to see the changes", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while loading your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(3, (Object)loadButton);
        Button saveButton = new Button("Save Configuration");
        saveButton.setOnAction(event -> {
            File f;
            this.applyChanges(true);
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" XML (*.xml)", new String[]{"*.xml"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showSaveDialog(null)) != null) {
                try {
                    String exportconfig = CityDataGenerator.settlementData.createExportString();
                    FileOutputStream fos = new FileOutputStream(f);
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                    w.write("<?xml version='1.0' encoding='utf-8'?>\n");
                    w.write(exportconfig);
                    w.flush();
                    w.close();
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Saved", "Settlement Configuration Saved", "The settlement configuration was successfully saved.", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while saving your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(4, (Object)saveButton);
        return bottombar;
    }

    private void loadCityDataAndShowDialog(InputStream is) {
        CityDataGenerator.parseSettings(is, this.clearPriorDataCheckBox.isSelected());
        this.primaryStage.close();
        StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Loaded", "Settlement Configuration Loaded", "Reopen the settlement configuration to see the changes.", null, null);
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        SettlementData.SpecialBuildingTabInfo tabinfo;
        Map<String, SettlementData.SpecialBuildingTabInfo> tabinfos;
        String changedtabkey;
        String buildingkey;
        String[] keyparts;
        String[] qus;
        String[] ocs;
        String[] abs;
        CityDataGenerator.settlementData.adventurerBackgrounds.clear();
        for (String ab : abs = this.advBgTF.getText().split(",")) {
            CityDataGenerator.settlementData.adventurerBackgrounds.add(ab);
        }
        CityDataGenerator.settlementData.occupations.clear();
        for (String oc : ocs = this.occupationsTF.getText().split(",")) {
            CityDataGenerator.settlementData.occupations.add(oc);
        }
        CityDataGenerator.settlementData.quirks.clear();
        for (String qu : qus = this.quirksTF.getText().split(",")) {
            CityDataGenerator.settlementData.quirks.add(qu);
        }
        CityDataGenerator.settlementData.remainingBuildings.clear();
        String[] rbs = this.remainingBuildingsTF.getText().split(",");
        for (String string : rbs) {
            CityDataGenerator.settlementData.remainingBuildings.add(string);
        }
        for (String key : this.wordlistTFsMap.keySet()) {
            CityDataGenerator.settlementData.wordLists.put(key, Arrays.asList(this.wordlistTFsMap.get(key).getText().split(",")));
        }
        for (String key : this.keyTFsMap.keySet()) {
            String newkey = this.keyTFsMap.get(key).getText();
            if (!Objects.equals(newkey, key)) {
                CityDataGenerator.settlementData.buildings.remove(key);
            }
            if (!this.removePlacementCBsMap.get(key).isSelected()) {
                SettlementData.Building building = new SettlementData.Building(newkey, (Integer)this.perPopulationSpinnersMap.get(key).getValue(), this.onRoadCBsMap.get(key).isSelected(), this.farmCBsMap.get(key).isSelected(), (String)this.placementCombosMap.get(key).getValue(), (Integer)this.distanceSpinnersMap.get(key).getValue(), this.denseCBsMap.get(key).isSelected());
                CityDataGenerator.settlementData.buildings.put(newkey, building);
                continue;
            }
            CityDataGenerator.settlementData.buildings.remove(key);
        }
        for (String key : this.buildingNameTFsMap.keySet()) {
            CityDataGenerator.settlementData.specialBuildingNames.put(key, Arrays.asList(this.buildingNameTFsMap.get(key).getText().split(",")));
        }
        StringBuilder errorstring = new StringBuilder();
        int racepercentage = 0;
        for (String string : this.raceKeyTFsMap.keySet()) {
            String newkey = this.raceKeyTFsMap.get(string).getText();
            if (!Objects.equals(newkey, string)) {
                CityDataGenerator.settlementData.races.remove(string);
            }
            if (this.removeRaceCBsMap.get(string).isSelected()) continue;
            racepercentage += ((Integer)this.raceChanceSpinnersMap.get(string).getValue()).intValue();
            SettlementData.Race race = new SettlementData.Race(this.raceKeyTFsMap.get(string).getText(), (Integer)this.raceMinAgesSpinnersMap.get(string).getValue(), (Integer)this.raceMaxAgesSpinnersMap.get(string).getValue(), (Integer)this.raceChanceSpinnersMap.get(string).getValue());
            String[] langs = this.raceLangSourcesTFMap.get(string).getText().split(",");
            double percenttotal = 0.0;
            for (int i = 0; i < langs.length - 1; i += 2) {
                int percent = Integer.parseInt(langs[i + 1].trim());
                percenttotal += (double)percent;
                SettlementData.Language lang = new SettlementData.Language(langs[i].trim(), percent);
                race.languages.add(lang);
            }
            if (percenttotal != 100.0) {
                if (errorstring.toString().equals("")) {
                    errorstring = new StringBuilder(string + "'s language percentages don't add up to 100.");
                } else {
                    errorstring.append("\n").append(string).append("'s language percentages don't add up to 100.");
                }
            }
            CityDataGenerator.settlementData.races.put(newkey, race);
        }
        if (racepercentage != 100) {
            if (errorstring.toString().equals("")) {
                errorstring = new StringBuilder("The overall race percentages don't add up to 100.");
            } else {
                errorstring.insert(0, "The overall race percentages don't add up to 100.\n");
            }
        }
        HashMap<String, String> changedtabnames = new HashMap<String, String>();
        for (String key : this.buildingTableTFsMap.keySet()) {
            Map<String, SettlementData.SpecialBuildingTabInfo> tabinfos2;
            SettlementData.SpecialBuildingTabInfo tabinfo2;
            keyparts = key.split("\t", -1);
            buildingkey = keyparts[0];
            String tabkey = keyparts[1];
            if (this.removeBuildingItemCBsMap.get(key) != null && this.removeBuildingItemCBsMap.get(key).isSelected()) {
                CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingkey).remove(tabkey);
                continue;
            }
            if (this.removeBuildingPersonCBsMap.get(key) != null && this.removeBuildingPersonCBsMap.get(key).isSelected()) {
                CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingkey).remove(tabkey);
                continue;
            }
            String newtabkey = this.buildingTableTFsMap.get(key).getText();
            if (Objects.equals(tabkey, newtabkey) || (tabinfo2 = (tabinfos2 = CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingkey)).get(tabkey)) == null) continue;
            tabinfos2.remove(tabkey);
            tabinfo2.setName(newtabkey);
            tabinfos2.put(newtabkey, tabinfo2);
            changedtabnames.put(tabkey, newtabkey);
        }
        for (String key : this.buildingPersonTypeTFs.keySet()) {
            keyparts = key.split("\t", -1);
            buildingkey = keyparts[0];
            String tabkey = keyparts[1];
            changedtabkey = (String)changedtabnames.get(tabkey);
            if (changedtabkey != null) {
                tabkey = changedtabkey;
            }
            String personkey = keyparts[2];
            String newkey = this.buildingPersonTypeTFs.get(key).getText();
            tabinfos = CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingkey);
            if (tabinfos == null) continue;
            tabinfo = (SettlementData.SpecialBuildingPersonTabInfo)tabinfos.get(tabkey);
            SettlementData.Person person = null;
            if (tabinfo == null || ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople() == null) continue;
            for (SettlementData.Person person2 : ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople().values()) {
                if (!person2.getType().equals(personkey)) continue;
                person = person2;
                break;
            }
            if (person != null) {
                person.setType(newkey);
                person.setMingroups((Integer)this.buildingPersonMinGroupsSpinners.get(key).getValue());
                person.setMaxgroups((Integer)this.buildingPersonMaxGroupsSpinners.get(key).getValue());
                person.setMinpergroup((Integer)this.buildingPersonMinPerGroupSpinners.get(key).getValue());
                person.setMaxpergroup((Integer)this.buildingPersonMaxPerGroupSpinners.get(key).getValue());
                person.setChanceadventurer((Integer)this.buildingPersonChanceAdvSpinners.get(key).getValue());
                person.setChancefemale((Integer)this.buildingPersonChanceFemaleSpinners.get(key).getValue());
                person.setChildrenMinAgePercent((Integer)this.buildingPersonChanceMinChildAgeSpinners.get(key).getValue());
            }
            if (!this.removeBuildingPersonCBsMap.get(key).isSelected() || person == null) continue;
            ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople().remove(person.getType());
        }
        for (String key : this.buildingItemTypeTFs.keySet()) {
            keyparts = key.split("\t", -1);
            buildingkey = keyparts[0];
            String tabkey = keyparts[1];
            changedtabkey = (String)changedtabnames.get(tabkey);
            if (changedtabkey != null) {
                tabkey = changedtabkey;
            }
            String itemkey = keyparts[2];
            String newkey = this.buildingItemTypeTFs.get(key).getText();
            tabinfos = CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingkey);
            if (tabinfos == null) continue;
            tabinfo = (SettlementData.SpecialBuildingItemTabInfo)tabinfos.get(tabkey);
            SettlementData.Item item = null;
            if (tabinfo == null || ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems() == null) continue;
            for (SettlementData.Item item2 : ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems().values()) {
                if (!item2.getType().equals(itemkey)) continue;
                item = item2;
                break;
            }
            if (item != null) {
                item.setType(newkey);
                item.setMin((Integer)this.buildingItemMinSpinners.get(key).getValue());
                item.setMax((Integer)this.buildingItemMaxSpinners.get(key).getValue());
                item.setAvailability((Integer)this.buildingItemAvailSpinners.get(key).getValue());
                item.setMaxquantity((Integer)this.buildingItemMaxQuantSpinners.get(key).getValue());
                item.setUnit(this.buildingItemUnitTFs.get(key).getText());
            }
            if (!this.removeBuildingItemCBsMap.get(key).isSelected() || item == null) continue;
            ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems().remove(item.getType());
        }
        String string = (String)this.buildingscombo.getSelectionModel().getSelectedItem();
        this.buildingDescsTab.setContent(this.createBuildingsGrid(string, 0.0));
        this.buildingPlacementTab.setContent(this.createBuildingPlacementGrid());
        this.racesTab.setContent(this.createRacesGrid());
        if (!errorstring.toString().equals("")) {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Settlement Data Warnings", "Settlement Data Warnings", "There were errors with the settlement data. The data was saved, but the results may not be as expected.", errorstring.toString(), "Details:");
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Settlement Data Applied", "Settlement Data Applied", "Your changes have been successfully applied.\nGenerating data will use the new information.", null, "");
        }
    }

    @Override
    protected Node createGrid() {
        TabPane tabPane = new TabPane();
        this.buildingPlacementTab = new Tab("Building Placement", this.createBuildingPlacementGrid());
        tabPane.getTabs().add((Object)this.buildingPlacementTab);
        this.buildingDescsTab = new Tab("Building Details", this.createBuildingsGrid(null, 0.0));
        tabPane.getTabs().add((Object)this.buildingDescsTab);
        this.racesTab = new Tab("Races", this.createRacesGrid());
        tabPane.getTabs().add((Object)this.racesTab);
        Tab othertab = new Tab("Other Info", this.createOtherGrid());
        tabPane.getTabs().add((Object)othertab);
        return tabPane;
    }

    protected Node createBuildingPlacementGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key");
        l1.setMinWidth(200.0);
        l1.setMaxWidth(200.0);
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("#/Population");
        l2.setMinWidth(100.0);
        l2.setMaxWidth(100.0);
        gp1.add((Node)l2, 1, 0);
        Label l3 = new Label("On Road?");
        l3.setMinWidth(60.0);
        l3.setMaxWidth(60.0);
        gp1.add((Node)l3, 2, 0);
        Label l4 = new Label("Is Farm?");
        l4.setMinWidth(60.0);
        l4.setMaxWidth(60.0);
        gp1.add((Node)l4, 3, 0);
        Label l5 = new Label("Placement");
        l5.setMinWidth(100.0);
        l5.setMaxWidth(100.0);
        gp1.add((Node)l5, 4, 0);
        Label l6 = new Label("Distance");
        l6.setMinWidth(100.0);
        l6.setMaxWidth(100.0);
        gp1.add((Node)l6, 5, 0);
        Label l7 = new Label("Dense?");
        l7.setMinWidth(60.0);
        l7.setMaxWidth(60.0);
        gp1.add((Node)l7, 6, 0);
        GridPane gp2 = new GridPane();
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        int count = 0;
        Set<String> set = CityDataGenerator.settlementData.buildings.keySet();
        TreeSet<String> sortedset = new TreeSet<String>(set);
        for (String key : sortedset) {
            count = this.createBuildingPlacementRow(gp2, count, key);
        }
        this.numBuildingPlacementRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            this.numBuildingPlacementRows = this.createBuildingPlacementRow(gp2, this.numBuildingPlacementRows, "tempfeature###" + Math.random());
            scrollpane.setVvalue(1.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        return bp;
    }

    private int createBuildingPlacementRow(GridPane gp2, int count, String key) {
        SettlementData.Building ft = CityDataGenerator.settlementData.buildings.get(key);
        TextField typeTF = new TextField(key);
        gp2.add((Node)typeTF, 0, count);
        typeTF.setMaxWidth(200.0);
        typeTF.setMinWidth(200.0);
        this.keyTFsMap.put(key, typeTF);
        FocusSpinner popspinner = new FocusSpinner(0, 10000000, ft == null ? 0 : ft.getPerPopulation());
        popspinner.setMaxWidth(100.0);
        popspinner.setMinWidth(100.0);
        gp2.add(popspinner, 1, count);
        popspinner.setEditable(true);
        this.perPopulationSpinnersMap.put(key, popspinner);
        CheckBox onroadcb = new CheckBox();
        onroadcb.setSelected(ft == null || ft.isOnRoad());
        onroadcb.setMaxWidth(60.0);
        onroadcb.setMinWidth(60.0);
        gp2.add((Node)onroadcb, 2, count);
        this.onRoadCBsMap.put(key, onroadcb);
        CheckBox farmcb = new CheckBox();
        farmcb.setSelected(ft != null && ft.isFarm());
        farmcb.setMaxWidth(60.0);
        farmcb.setMinWidth(60.0);
        gp2.add((Node)farmcb, 3, count);
        this.farmCBsMap.put(key, farmcb);
        ObservableList placements = FXCollections.observableArrayList((Object[])new String[]{"", "any", "away", "near"});
        ComboBox placementCombo = new ComboBox(placements);
        placementCombo.getSelectionModel().select((Object)(ft != null ? ft.getPlacement() : "any"));
        placementCombo.setMaxWidth(100.0);
        placementCombo.setMinWidth(100.0);
        gp2.add((Node)placementCombo, 4, count);
        this.placementCombosMap.put(key, (ComboBox<String>)placementCombo);
        Spinner distanceSpinner = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 100, ft != null ? ft.getDistance() : 12));
        distanceSpinner.setMaxWidth(100.0);
        distanceSpinner.setMinWidth(100.0);
        gp2.add((Node)distanceSpinner, 5, count);
        this.distanceSpinnersMap.put(key, (Spinner<Integer>)distanceSpinner);
        CheckBox densecb = new CheckBox();
        densecb.setSelected(ft != null && ft.isDense());
        densecb.setMaxWidth(60.0);
        densecb.setMinWidth(60.0);
        gp2.add((Node)densecb, 6, count);
        this.denseCBsMap.put(key, densecb);
        CheckBox removecb = new CheckBox("Remove");
        onroadcb.setMaxWidth(60.0);
        onroadcb.setMinWidth(60.0);
        gp2.add((Node)removecb, 7, count);
        this.removePlacementCBsMap.put(key, removecb);
        return ++count;
    }

    private Node createOtherGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("List Name");
        l1.setMinWidth(150.0);
        l1.setMaxWidth(150.0);
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("Values (comma separated list; no spaces unless you're padding a value)");
        l2.setMinWidth(550.0);
        l2.setMaxWidth(550.0);
        gp1.add((Node)l2, 1, 0);
        gp1.add((Node)new Label("Adv. Background:"), 0, 1);
        this.advBgTF.setText(this.listToString(CityDataGenerator.settlementData.adventurerBackgrounds));
        gp1.add((Node)this.advBgTF, 1, 1);
        gp1.add((Node)new Label("Occupations:"), 0, 2);
        this.occupationsTF.setText(this.listToString(CityDataGenerator.settlementData.occupations));
        gp1.add((Node)this.occupationsTF, 1, 2);
        gp1.add((Node)new Label("Quirks:"), 0, 3);
        this.quirksTF.setText(this.listToString(CityDataGenerator.settlementData.quirks));
        gp1.add((Node)this.quirksTF, 1, 3);
        gp1.add((Node)new Label("Remaining Buildings:"), 0, 4);
        this.remainingBuildingsTF.setText(this.listToString(CityDataGenerator.settlementData.remainingBuildings));
        gp1.add((Node)this.remainingBuildingsTF, 1, 4);
        gp1.add((Node)new Label("Building Name Word Lists:"), 0, 5);
        this.numBuildingNamingRows = 6;
        for (String key : CityDataGenerator.settlementData.wordLists.keySet()) {
            TextField wordlistTF = new TextField(this.listToString(CityDataGenerator.settlementData.wordLists.get(key)));
            this.wordlistTFsMap.put(key, wordlistTF);
            gp1.add((Node)new Label(key), 0, this.numBuildingNamingRows);
            gp1.add((Node)wordlistTF, 1, this.numBuildingNamingRows);
            ++this.numBuildingNamingRows;
        }
        gp1.add((Node)new Label("Building Naming:"), 0, this.numBuildingNamingRows);
        ++this.numBuildingNamingRows;
        for (String key : CityDataGenerator.settlementData.specialBuildingNames.keySet()) {
            TextField bnTF = new TextField(this.listToString(CityDataGenerator.settlementData.specialBuildingNames.get(key)));
            this.buildingNameTFsMap.put(key, bnTF);
            String name = key.replaceAll("_", " ");
            gp1.add((Node)new Label(name), 0, this.numBuildingNamingRows);
            gp1.add((Node)bnTF, 1, this.numBuildingNamingRows);
            ++this.numBuildingNamingRows;
        }
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp1);
        BorderPane bp = new BorderPane();
        bp.setCenter((Node)scrollpane);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            RadioButton wordlistrb = new RadioButton("Word List");
            wordlistrb.setSelected(true);
            RadioButton buildingnamerb = new RadioButton("Building Name");
            ToggleGroup rbg = new ToggleGroup();
            wordlistrb.setToggleGroup(rbg);
            buildingnamerb.setToggleGroup(rbg);
            String name = this.promptForBuildingKeyDialog(wordlistrb, buildingnamerb);
            if (name != null) {
                if (wordlistrb.isSelected()) {
                    TextField wlTF = new TextField("");
                    this.wordlistTFsMap.put(name, wlTF);
                    gp1.add((Node)new Label(name), 0, this.numBuildingNamingRows);
                    gp1.add((Node)wlTF, 1, this.numBuildingNamingRows);
                    ++this.numBuildingNamingRows;
                    scrollpane.setVvalue(1.0);
                } else {
                    TextField bnTF = new TextField("");
                    String k = name.replaceAll(" ", "_");
                    this.buildingNameTFsMap.put(k, bnTF);
                    gp1.add((Node)new Label(k), 0, this.numBuildingNamingRows);
                    gp1.add((Node)bnTF, 1, this.numBuildingNamingRows);
                    ++this.numBuildingNamingRows;
                    scrollpane.setVvalue(1.0);
                }
            }
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        return bp;
    }

    private String promptForBuildingKeyDialog(RadioButton wordlistrb, RadioButton buildingnamerb) {
        StyledDialog dialog = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Worldographer Word List Building Type");
        dialog.setHeaderText("Word List or Building Type Name");
        Label questionLabel = new Label("Enter the world list or building type name: ");
        TextField tf = new TextField();
        GridPane gp = new GridPane();
        gp.add((Node)wordlistrb, 0, 0);
        gp.add((Node)buildingnamerb, 1, 0);
        gp.add((Node)questionLabel, 0, 1);
        gp.add((Node)tf, 1, 1);
        gp.add((Node)new Label("Note: A new word list will appear at the bottom of the building name\nsection until the Configure Settlement Data dialog is reopened."), 0, 2, 2, 1);
        dialog.getDialogPane().setContent((Node)gp);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return null;
        }
        return tf.getText();
    }

    private String listToString(List<String> list) {
        StringBuilder out = new StringBuilder();
        for (String s : list) {
            if (out.length() != 0) {
                out.append(",");
            }
            out.append(s);
        }
        return out.toString();
    }

    private Node createBuildingsGrid(String selectedbuilding, double vscrollvalue) {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Label l1 = new Label("Select Building:");
        gp1.add((Node)l1, 0, 0);
        this.buildingscombo.getItems().removeAll((Collection)this.buildingscombo.getItems());
        Set<String> set = CityDataGenerator.settlementData.specialBuildingTabInfo.keySet();
        TreeSet<String> treeset = new TreeSet<String>(set);
        this.buildingscombo.getItems().addAll(treeset);
        gp1.add(this.buildingscombo, 1, 0);
        this.buildingscombo.setOnAction(event -> {
            gp2.getChildren().removeAll((Collection)gp2.getChildren());
            if (this.buildingscombo.getSelectionModel().getSelectedItem() != null) {
                this.createBuildingRow(gp2, 0, (String)this.buildingscombo.getSelectionModel().getSelectedItem(), scrollpane);
            }
        });
        if (selectedbuilding != null) {
            this.buildingscombo.getSelectionModel().select((Object)selectedbuilding);
        }
        Button removeSelected = new Button("Remove Selected");
        gp1.add((Node)removeSelected, 2, 0);
        removeSelected.setOnAction(event -> {
            if (this.buildingscombo.getSelectionModel().getSelectedItem() != null) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Remove Selected");
                alert.setHeaderText("Confirm Remove Selected");
                alert.setContentText("Are you sure you wish to delete '" + (String)this.buildingscombo.getSelectionModel().getSelectedItem() + "'?");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    CityDataGenerator.settlementData.specialBuildingTabInfo.remove(this.buildingscombo.getSelectionModel().getSelectedItem());
                    this.buildingscombo.getItems().removeAll((Collection)this.buildingscombo.getItems());
                    Set<String> set2 = CityDataGenerator.settlementData.specialBuildingTabInfo.keySet();
                    TreeSet<String> treeset2 = new TreeSet<String>(set2);
                    this.buildingscombo.getItems().addAll(treeset2);
                    this.buildingscombo.getSelectionModel().select(0);
                }
            }
        });
        Button cloneSelected = new Button("Clone Selected");
        cloneSelected.setOnAction(event -> {
            if (this.buildingscombo.getSelectionModel().getSelectedItem() != null) {
                TextInputDialog dialog = new TextInputDialog("");
                dialog.setTitle("Clone Building Type");
                dialog.setHeaderText("Clone Building Type");
                dialog.setContentText("Enter the building type name:");
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    HashMap<String, Object> newmap = new HashMap<String, Object>();
                    Map<String, SettlementData.SpecialBuildingTabInfo> sbtimap = CityDataGenerator.settlementData.specialBuildingTabInfo.get(this.buildingscombo.getSelectionModel().getSelectedItem());
                    for (String k : sbtimap.keySet()) {
                        String name;
                        String type;
                        SettlementData.SpecialBuildingTabInfo info = sbtimap.get(k);
                        if (info instanceof SettlementData.SpecialBuildingPersonTabInfo) {
                            SettlementData.SpecialBuildingPersonTabInfo personinfo = (SettlementData.SpecialBuildingPersonTabInfo)info;
                            HashMap<String, SettlementData.Person> newpeople = new HashMap<String, SettlementData.Person>();
                            type = personinfo.getType();
                            name = personinfo.getName();
                            for (String k2 : personinfo.getPeople().keySet()) {
                                SettlementData.Person oldperson = personinfo.getPeople().get(k2);
                                SettlementData.Person newperson = new SettlementData.Person(oldperson.getType(), oldperson.getMingroups(), oldperson.getMaxgroups(), oldperson.getMinpergroup(), oldperson.getMaxpergroup(), oldperson.getChanceadventurer(), oldperson.getChancefemale(), oldperson.getChildrenMinAgePercent());
                                newpeople.put(k2, newperson);
                            }
                            SettlementData.SpecialBuildingPersonTabInfo newpersontab = new SettlementData.SpecialBuildingPersonTabInfo(name, type, newpeople);
                            newmap.put(k, newpersontab);
                            continue;
                        }
                        if (!(info instanceof SettlementData.SpecialBuildingItemTabInfo)) continue;
                        SettlementData.SpecialBuildingItemTabInfo iteminfo = (SettlementData.SpecialBuildingItemTabInfo)info;
                        HashMap<String, SettlementData.Item> newitems = new HashMap<String, SettlementData.Item>();
                        type = iteminfo.getType();
                        name = iteminfo.getName();
                        for (String k2 : iteminfo.getItems().keySet()) {
                            SettlementData.Item olditem = iteminfo.getItems().get(k2);
                            SettlementData.Item newitem = new SettlementData.Item(olditem.getType(), olditem.getUnit(), olditem.getMin(), olditem.getMax(), olditem.getAvailability(), olditem.getMaxquantity());
                            newitems.put(k2, newitem);
                        }
                        SettlementData.SpecialBuildingItemTabInfo newitemtab = new SettlementData.SpecialBuildingItemTabInfo(name, type, newitems);
                        newmap.put(k, newitemtab);
                    }
                    CityDataGenerator.settlementData.specialBuildingTabInfo.put((String)result.get(), newmap);
                    this.buildingscombo.getItems().removeAll((Collection)this.buildingscombo.getItems());
                    Set<String> set2 = CityDataGenerator.settlementData.specialBuildingTabInfo.keySet();
                    TreeSet<String> treeset2 = new TreeSet<String>(set2);
                    this.buildingscombo.getItems().addAll(treeset2);
                    this.buildingscombo.getSelectionModel().select((Object)((String)result.get()));
                }
            }
        });
        gp1.add((Node)cloneSelected, 3, 0);
        Button addNew = new Button("Add New");
        gp1.add((Node)addNew, 4, 0);
        addNew.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog("");
            dialog.setTitle("Add New Building Type");
            dialog.setHeaderText("Add New Building Type");
            dialog.setContentText("Enter the building type name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                HashMap sbtimap = new HashMap();
                CityDataGenerator.settlementData.specialBuildingTabInfo.put((String)result.get(), sbtimap);
                this.buildingscombo.getItems().removeAll((Collection)this.buildingscombo.getItems());
                Set<String> set2 = CityDataGenerator.settlementData.specialBuildingTabInfo.keySet();
                TreeSet<String> treeset2 = new TreeSet<String>(set2);
                this.buildingscombo.getItems().addAll(treeset2);
                this.buildingscombo.getSelectionModel().select((Object)((String)result.get()));
            }
        });
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        scrollpane.setVvalue(vscrollvalue);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private void createBuildingRow(GridPane gp2, int count, String buildingtype, ScrollPane parentscrollpane) {
        Map<String, SettlementData.SpecialBuildingTabInfo> tabsMap = CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingtype);
        Label l = new Label(buildingtype);
        Font f = l.getFont();
        l.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)20.0));
        gp2.add((Node)l, 0, count);
        l.setMaxWidth(160.0);
        l.setMinWidth(160.0);
        Button addtablebutton = new Button("Add Table");
        gp2.add((Node)addtablebutton, 1, count);
        addtablebutton.setMaxWidth(70.0);
        addtablebutton.setMinWidth(70.0);
        addtablebutton.setOnAction(event -> {
            ArrayList<String> choices = new ArrayList<String>();
            choices.add("Item");
            choices.add("Person");
            ChoiceDialog dialog = new ChoiceDialog((Object)"Item", choices);
            dialog.setTitle("Select New Building Table Type");
            dialog.setHeaderText("Select the building's new table type:");
            dialog.setContentText("Type:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                double v = parentscrollpane.getVvalue();
                this.applyChanges(false);
                long time = System.currentTimeMillis();
                if (((String)result.get()).equals("Item")) {
                    tabsMap.put("* New " + time, new SettlementData.SpecialBuildingItemTabInfo("* New " + time, "Item", new HashMap<String, SettlementData.Item>()));
                } else {
                    tabsMap.put("* New " + time, new SettlementData.SpecialBuildingPersonTabInfo("* New " + time, "Person", new HashMap<String, SettlementData.Person>()));
                }
                this.buildingDescsTab.setContent(this.createBuildingsGrid(buildingtype, v));
            }
        });
        ++count;
        for (SettlementData.SpecialBuildingTabInfo tabinfo : tabsMap.values()) {
            Label l3;
            Label l2;
            HBox hbox = new HBox();
            Label tabname = new Label((tabinfo instanceof SettlementData.SpecialBuildingItemTabInfo ? "Item" : "Person") + " Table, Title:");
            hbox.getChildren().add((Object)tabname);
            TextField tf = new TextField(tabinfo.getName());
            tf.setMaxWidth(60.0);
            tf.setMinWidth(60.0);
            this.buildingTableTFsMap.put(buildingtype + "\t" + tabinfo.getName(), tf);
            hbox.getChildren().add((Object)tf);
            gp2.add((Node)hbox, 0, count);
            hbox.setMaxWidth(160.0);
            hbox.setMinWidth(160.0);
            if (tabinfo instanceof SettlementData.SpecialBuildingItemTabInfo) {
                l2 = new Label("Min Price");
                l2.setMinWidth(70.0);
                l2.setMaxWidth(70.0);
                gp2.add((Node)l2, 1, count);
                l3 = new Label("Max Price");
                l3.setMinWidth(70.0);
                l3.setMaxWidth(70.0);
                gp2.add((Node)l3, 2, count);
                Label l4 = new Label("Unit");
                l4.setMinWidth(70.0);
                l4.setMaxWidth(70.0);
                gp2.add((Node)l4, 3, count);
                Label l5 = new Label("Available %");
                l5.setMinWidth(70.0);
                l5.setMaxWidth(70.0);
                gp2.add((Node)l5, 4, count);
                Label l6 = new Label("Max Avail.");
                l6.setMinWidth(60.0);
                l6.setMaxWidth(60.0);
                gp2.add((Node)l6, 5, count);
                Button addbutton = new Button("Add Row");
                addbutton.setMaxWidth(70.0);
                addbutton.setMinWidth(70.0);
                gp2.add((Node)addbutton, 7, count);
                addbutton.setOnAction(event -> {
                    double v = parentscrollpane.getVvalue();
                    this.applyChanges(false);
                    long time2 = System.currentTimeMillis();
                    ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems().put("* New " + time2, new SettlementData.Item("* New " + time2, "gp", 0, 0, 0, 0));
                    this.buildingDescsTab.setContent(this.createBuildingsGrid(buildingtype, v));
                });
                CheckBox removexcb = new CheckBox("Remove Table");
                removexcb.setMaxWidth(100.0);
                removexcb.setMinWidth(100.0);
                gp2.add((Node)removexcb, 8, count);
                this.removeBuildingItemCBsMap.put(buildingtype + "\t" + tabinfo.getName(), removexcb);
                ++count;
                TreeSet<String> treeset = new TreeSet<String>(((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems().keySet());
                for (String itemname : treeset) {
                    SettlementData.Item item = ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems().get(itemname);
                    TextField itemtypeTF = new TextField(item.getType());
                    gp2.add((Node)itemtypeTF, 0, count);
                    itemtypeTF.setMaxWidth(160.0);
                    itemtypeTF.setMinWidth(160.0);
                    this.buildingItemTypeTFs.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), itemtypeTF);
                    FocusSpinner minspinner = new FocusSpinner(0, 100000, item.getMin());
                    minspinner.setMaxWidth(70.0);
                    minspinner.setMinWidth(70.0);
                    gp2.add(minspinner, 1, count);
                    minspinner.setEditable(true);
                    this.buildingItemMinSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), minspinner);
                    FocusSpinner maxspinner = new FocusSpinner(0, 1000000000, item.getMax());
                    maxspinner.setMaxWidth(70.0);
                    maxspinner.setMinWidth(70.0);
                    gp2.add(maxspinner, 2, count);
                    maxspinner.setEditable(true);
                    this.buildingItemMaxSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), maxspinner);
                    TextField unitTF = new TextField(item.getUnit());
                    gp2.add((Node)unitTF, 3, count);
                    unitTF.setMaxWidth(70.0);
                    unitTF.setMinWidth(70.0);
                    this.buildingItemUnitTFs.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), unitTF);
                    FocusSpinner availspinner = new FocusSpinner(0, 100, item.getAvailability());
                    availspinner.setMaxWidth(70.0);
                    availspinner.setMinWidth(70.0);
                    gp2.add(availspinner, 4, count);
                    availspinner.setEditable(true);
                    this.buildingItemAvailSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), availspinner);
                    FocusSpinner maxquantspinner = new FocusSpinner(0, 100, item.getMaxquantity());
                    maxquantspinner.setMaxWidth(60.0);
                    maxquantspinner.setMinWidth(60.0);
                    gp2.add(maxquantspinner, 5, count);
                    maxquantspinner.setEditable(true);
                    this.buildingItemMaxQuantSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), maxquantspinner);
                    CheckBox removecb = new CheckBox("Remove Row");
                    removecb.setMaxWidth(100.0);
                    removecb.setMinWidth(100.0);
                    gp2.add((Node)removecb, 7, count);
                    this.removeBuildingItemCBsMap.put(buildingtype + "\t" + tabinfo.getName() + "\t" + item.getType(), removecb);
                    ++count;
                }
                continue;
            }
            if (!(tabinfo instanceof SettlementData.SpecialBuildingPersonTabInfo)) continue;
            l2 = new Label("Min Groups");
            l2.setMinWidth(70.0);
            l2.setMaxWidth(70.0);
            gp2.add((Node)l2, 1, count);
            l3 = new Label("Max Groups");
            l3.setMinWidth(70.0);
            l3.setMaxWidth(70.0);
            gp2.add((Node)l3, 2, count);
            Label l5 = new Label("Min/Group");
            l5.setMinWidth(70.0);
            l5.setMaxWidth(70.0);
            gp2.add((Node)l5, 3, count);
            Label l6 = new Label("Max/Group");
            l6.setMinWidth(70.0);
            l6.setMaxWidth(70.0);
            gp2.add((Node)l6, 4, count);
            Label l7 = new Label("% Adv.");
            l7.setMinWidth(60.0);
            l7.setMaxWidth(60.0);
            gp2.add((Node)l7, 5, count);
            Label l8 = new Label("% Female");
            l8.setMinWidth(60.0);
            l8.setMaxWidth(60.0);
            gp2.add((Node)l8, 6, count);
            Label l9 = new Label("Min Child Age %");
            l9.setTooltip(new Tooltip("If children are part of this group, sets their minimum age percentage.  The maximum age of the chlldren is\nthe minimum Age of the people of that Race/Ancestry (human, dwarf, etc.). '-1' means no children are part\nof this group. Ex: A Min Child Age % of 33 and a minimum age of that race of 15 gives a min child age 5."));
            l9.setMinWidth(95.0);
            l9.setMaxWidth(95.0);
            gp2.add((Node)l9, 7, count);
            Button addbutton = new Button("Add Row");
            addbutton.setMaxWidth(80.0);
            addbutton.setMinWidth(80.0);
            gp2.add((Node)addbutton, 8, count);
            addbutton.setOnAction(event -> {
                double v = parentscrollpane.getVvalue();
                this.applyChanges(false);
                long time2 = System.currentTimeMillis();
                ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople().put("* New " + time2, new SettlementData.Person("* New " + time2, 0, 0, 0, 0, 0, 0, -1));
                this.buildingDescsTab.setContent(this.createBuildingsGrid((String)this.buildingscombo.getSelectionModel().getSelectedItem(), v));
            });
            CheckBox removexcb = new CheckBox("Remove Table");
            removexcb.setMaxWidth(100.0);
            removexcb.setMinWidth(100.0);
            gp2.add((Node)removexcb, 9, count);
            this.removeBuildingPersonCBsMap.put(buildingtype + "\t" + tabinfo.getName(), removexcb);
            ++count;
            TreeSet<String> treeset = new TreeSet<String>(((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople().keySet());
            for (String personname : treeset) {
                SettlementData.Person person = ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople().get(personname);
                TextField persontypeTF = new TextField(person.getType());
                gp2.add((Node)persontypeTF, 0, count);
                persontypeTF.setMaxWidth(160.0);
                persontypeTF.setMinWidth(160.0);
                this.buildingPersonTypeTFs.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), persontypeTF);
                FocusSpinner mingroupsspinner = new FocusSpinner(0, 10000, person.getMingroups());
                mingroupsspinner.setMaxWidth(70.0);
                mingroupsspinner.setMinWidth(70.0);
                gp2.add(mingroupsspinner, 1, count);
                mingroupsspinner.setEditable(true);
                this.buildingPersonMinGroupsSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), mingroupsspinner);
                FocusSpinner maxgroupsspinner = new FocusSpinner(0, 10000, person.getMaxgroups());
                maxgroupsspinner.setMaxWidth(70.0);
                maxgroupsspinner.setMinWidth(70.0);
                gp2.add(maxgroupsspinner, 2, count);
                maxgroupsspinner.setEditable(true);
                this.buildingPersonMaxGroupsSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), maxgroupsspinner);
                FocusSpinner minpergroupspinner = new FocusSpinner(0, 10000, person.getMinpergroup());
                minpergroupspinner.setMaxWidth(70.0);
                minpergroupspinner.setMinWidth(70.0);
                gp2.add(minpergroupspinner, 3, count);
                minpergroupspinner.setEditable(true);
                this.buildingPersonMinPerGroupSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), minpergroupspinner);
                FocusSpinner maxpergroupspinner = new FocusSpinner(0, 10000, person.getMaxpergroup());
                maxpergroupspinner.setMaxWidth(70.0);
                maxpergroupspinner.setMinWidth(70.0);
                gp2.add(maxpergroupspinner, 4, count);
                maxpergroupspinner.setEditable(true);
                this.buildingPersonMaxPerGroupSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), maxpergroupspinner);
                FocusSpinner chanceadvspinner = new FocusSpinner(0, 100, person.getChanceadventurer());
                chanceadvspinner.setMaxWidth(60.0);
                chanceadvspinner.setMinWidth(60.0);
                gp2.add(chanceadvspinner, 5, count);
                chanceadvspinner.setEditable(true);
                this.buildingPersonChanceAdvSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), chanceadvspinner);
                FocusSpinner chancefemalespinner = new FocusSpinner(0, 100, person.getChancefemale());
                chancefemalespinner.setMaxWidth(60.0);
                chancefemalespinner.setMinWidth(60.0);
                gp2.add(chancefemalespinner, 6, count);
                chancefemalespinner.setEditable(true);
                this.buildingPersonChanceFemaleSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), chancefemalespinner);
                FocusSpinner minChildAgeSpinner = new FocusSpinner(-1, 100, person.getChildrenMinAgePercent());
                minChildAgeSpinner.setMaxWidth(60.0);
                minChildAgeSpinner.setMinWidth(60.0);
                gp2.add(minChildAgeSpinner, 7, count);
                minChildAgeSpinner.setEditable(true);
                this.buildingPersonChanceMinChildAgeSpinners.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), minChildAgeSpinner);
                CheckBox removecb = new CheckBox("Remove Row");
                removecb.setMaxWidth(100.0);
                removecb.setMinWidth(100.0);
                gp2.add((Node)removecb, 8, count);
                this.removeBuildingPersonCBsMap.put(buildingtype + "\t" + tabinfo.getName() + "\t" + person.getType(), removecb);
                ++count;
            }
        }
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {});
        ++count;
    }

    private Node createRacesGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Name");
        l1.setMinWidth(200.0);
        l1.setMaxWidth(200.0);
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("Min Age");
        l2.setMinWidth(80.0);
        l2.setMaxWidth(80.0);
        gp1.add((Node)l2, 1, 0);
        Label l3 = new Label("Max Age");
        l3.setMinWidth(80.0);
        l3.setMaxWidth(80.0);
        gp1.add((Node)l3, 2, 0);
        Label l4 = new Label("Chance");
        l4.setMinWidth(80.0);
        l4.setMaxWidth(80.0);
        gp1.add((Node)l4, 3, 0);
        Label l5 = new Label("Language Sources (Lang1,%,Lang2,%,...)");
        l5.setMinWidth(260.0);
        l5.setMaxWidth(260.0);
        gp1.add((Node)l5, 4, 0);
        int count = 0;
        GridPane gp2 = new GridPane();
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        for (SettlementData.Race race : CityDataGenerator.settlementData.getRaces().values()) {
            count = this.createRaceRow(gp2, count, race);
        }
        this.numRaceRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            String name = "New " + System.currentTimeMillis();
            SettlementData.Race r = new SettlementData.Race(name, 10, 100, 0);
            CityDataGenerator.settlementData.getRaces().put(name, r);
            this.numRaceRows = this.createRaceRow(gp1, this.numRaceRows, r);
            scrollpane.setVvalue(1.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        return bp;
    }

    private int createRaceRow(GridPane gp2, int count, SettlementData.Race race) {
        TextField tf = new TextField(race.getName());
        gp2.add((Node)tf, 0, count);
        tf.setMaxWidth(200.0);
        tf.setMinWidth(200.0);
        this.raceKeyTFsMap.put(race.getName(), tf);
        FocusSpinner minagespinner = new FocusSpinner(0, 100000, race.getMinAge());
        minagespinner.setMaxWidth(80.0);
        minagespinner.setMinWidth(80.0);
        gp2.add(minagespinner, 1, count);
        minagespinner.setEditable(true);
        this.raceMinAgesSpinnersMap.put(race.getName(), minagespinner);
        FocusSpinner maxagespinner = new FocusSpinner(0, 100000, race.getMaxAge());
        maxagespinner.setMaxWidth(80.0);
        maxagespinner.setMinWidth(80.0);
        gp2.add(maxagespinner, 2, count);
        maxagespinner.setEditable(true);
        this.raceMaxAgesSpinnersMap.put(race.getName(), maxagespinner);
        FocusSpinner chancespinner = new FocusSpinner(0, 100, race.getChance());
        chancespinner.setMaxWidth(80.0);
        chancespinner.setMinWidth(80.0);
        gp2.add(chancespinner, 3, count);
        chancespinner.setEditable(true);
        this.raceChanceSpinnersMap.put(race.getName(), chancespinner);
        StringBuilder langvalue = new StringBuilder();
        for (SettlementData.Language c : race.languages) {
            if (langvalue.length() != 0) {
                langvalue.append(",");
            }
            langvalue.append(c.getName()).append(",").append(c.getChance());
        }
        TextField langtf = new TextField(langvalue.toString());
        gp2.add((Node)langtf, 4, count);
        langtf.setMaxWidth(260.0);
        langtf.setMinWidth(260.0);
        this.raceLangSourcesTFMap.put(race.getName(), langtf);
        CheckBox removecb = new CheckBox("Remove");
        removecb.setMaxWidth(80.0);
        removecb.setMinWidth(80.0);
        gp2.add((Node)removecb, 5, count);
        this.removeRaceCBsMap.put(race.getName(), removecb);
        return ++count;
    }
}

