/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureFeaturesScreen
extends ConfigureScreen {
    final Map<String, Image> changedImagesMap = new HashMap<String, Image>();
    final Map<String, Image> changedAltImagesMap = new HashMap<String, Image>();
    final Map<String, Spinner<Double>> sizeSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, Spinner<Double>> heightSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, CheckBox> removeCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> keyTFsMap = new HashMap<String, TextField>();
    final String filter;
    int numFeatureRows;

    public ConfigureFeaturesScreen(Worldographer ms, String filter) {
        super(ms, 1060, 400);
        this.filter = filter.toLowerCase();
    }

    @Override
    public void setValues() {
        this.title = "Configure Features";
        this.configureLabel = "";
        this.configureTitle = "Configure Features Instructions";
        this.configureHeader = "Bulk Edit Feature Data/Settings.";
        this.configureScreenHelpText = "<p>To configure many features, use the Configure Features dialog. Each row configures a different feature.</p>\n<h3>Add</h3><p>Click the 'Add Row' button to add a new feature type to the system. You may have to scroll down to the new row.</p>\n<h3>Configure</h3>\n<ul><li>Key: System name and usually the name of the feature shown to the user in tooltips and such.</li>\n<li>Icon: The current icon for the feature is displayed here. Change it to another file on your computer with the 'Choose File' button.</li>\n<li>Width: The size of the icon as a percentage of a tile's overall width</li>\n<li>Height: The height of an icon as a percentage of a tile's height. If this value is negative, Worldographer will keep the icon's height proportional to the icon's width.</li>\n<li>Alternate Icon: When showing a Batttlemat, Worldographer's Tools menu has an option to show the map in a 'Simplistic' style. These are typically line art icons.    Use the 'Choose File' button here to set/change the icon used in that simplistic style. (The same menu allows you to change the icons back to the 'Realistic' style.)</li>\n<li>Reset: Reset the values to what they were when you opened this window.</li>\n<li>Reset To Original: If the feature was part of Worldographer's built in icons, this button allows you to restore it to the default settings.</li></ul>\n<h3>Remove</h3>\n<p>Use the 'Remove' checkbox to remove that row's feature from Worldographer once you also click 'Apply'.  (Note: Default/built-in features will come back when Worldographer is re-launched.)</p>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        FeatureType ft;
        FeatureType ft2;
        Object name;
        CheckBox cb;
        for (String key : this.changedImagesMap.keySet()) {
            if (key.startsWith("tempfeature###")) {
                cb = this.removeCBsMap.get(key);
                if (cb.isSelected()) continue;
                name = this.keyTFsMap.get(key).getText();
                if (((String)name).trim().equals("")) {
                    name = "No Name " + key.substring(14);
                    this.keyTFsMap.get(key).setText((String)name);
                }
                ft2 = new FeatureType((String)name, this.changedImagesMap.get(key), false);
                ft2.setIconSize((Double)this.sizeSpinnersMap.get(key).getValue() / 100.0);
                if (this.changedAltImagesMap.get(key) != null) {
                    ft2.setAlternateIcon(this.changedAltImagesMap.remove(key));
                }
                Feature.featureTypes.put((String)name, ft2);
                continue;
            }
            ft = Feature.featureTypes.get(key);
            ft.setIcon(this.changedImagesMap.get(key));
            ft.setDefaultAndUnchanged(false);
        }
        for (String key : this.changedAltImagesMap.keySet()) {
            cb = this.removeCBsMap.get(key);
            if (cb.isSelected()) continue;
            if (!key.startsWith("tempfeature###")) {
                FeatureType ft3 = Feature.featureTypes.get(key);
                ft3.setAlternateIcon(this.changedAltImagesMap.get(key));
                ft3.setDefaultAndUnchanged(false);
                continue;
            }
            name = this.keyTFsMap.get(key).getText();
            ft2 = new FeatureType((String)name, (Image)null, false);
            ft2.setIconSize((Double)this.sizeSpinnersMap.get(key).getValue() / 100.0);
            ft2.setAlternateIcon(this.changedAltImagesMap.get(key));
        }
        for (String key : this.sizeSpinnersMap.keySet()) {
            if (key.startsWith("tempfeature###") || (ft = Feature.featureTypes.get(key)).getIconSize() == (Double)this.sizeSpinnersMap.get(key).getValue() / 100.0) continue;
            ft.setDefaultAndUnchanged(false);
            ft.setIconSize((Double)this.sizeSpinnersMap.get(key).getValue() / 100.0);
        }
        for (String key : this.heightSpinnersMap.keySet()) {
            if (key.startsWith("tempfeature###") || (ft = Feature.featureTypes.get(key)).getIconHeight() < 0.0 && (Double)this.heightSpinnersMap.get(key).getValue() < 0.0 || ft.getIconHeight() == (Double)this.heightSpinnersMap.get(key).getValue() / 100.0) continue;
            ft.setDefaultAndUnchanged(false);
            ft.setIconHeight((Double)this.heightSpinnersMap.get(key).getValue() / 100.0);
        }
        for (String key : this.removeCBsMap.keySet()) {
            if (key.startsWith("temp###") || key.startsWith("tempfeature###") || key.startsWith("temptext###") || !(cb = this.removeCBsMap.get(key)).isSelected()) continue;
            Feature.featureTypes.remove(key);
        }
        this.worldographer.featuresToolbox.clearFeatureButtons();
        this.worldographer.featuresToolbox.updateFeatureButtons();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key");
        l1.setMinWidth(170.0);
        gp1.add((Node)l1, 0, 0);
        Label l3 = new Label("Icon");
        l3.setMinWidth(160.0);
        gp1.add((Node)l3, 2, 0, 2, 1);
        Label l4 = new Label("Width");
        l4.setMinWidth(80.0);
        gp1.add((Node)l4, 4, 0);
        Label ls = new Label("Height");
        ls.setMinWidth(80.0);
        gp1.add((Node)ls, 5, 0);
        Label l5 = new Label("Alternate Icon");
        l5.setMinWidth(140.0);
        gp1.add((Node)l5, 6, 0, 2, 1);
        GridPane gp2 = new GridPane();
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        int count = 0;
        for (String key : Feature.featureTypes.keySet()) {
            if (!this.filter.equals("all features") && !key.toLowerCase().contains(this.filter) && (!this.filter.equals("classic") || key.toLowerCase().contains("battlemat") || key.toLowerCase().contains("cosmic") || key.toLowerCase().contains("creature") || key.toLowerCase().contains("resource") || key.toLowerCase().contains("lineart") || key.toLowerCase().contains("structure") || key.toLowerCase().contains("token") || key.toLowerCase().contains("isometric") || key.toLowerCase().contains("perspective"))) continue;
            count = this.createFeatureRow(gp2, count, key);
        }
        this.numFeatureRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            this.numFeatureRows = this.createFeatureRow(gp2, this.numFeatureRows, "tempfeature###" + Math.random());
            scrollpane.setVvalue(1.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        return bp;
    }

    private int createFeatureRow(GridPane gp2, int count, String key) {
        FeatureType ft = Feature.featureTypes.get(key);
        if (ft != null) {
            Label keylabel = new Label(key);
            keylabel.setMaxWidth(170.0);
            keylabel.setMinWidth(170.0);
            gp2.add((Node)keylabel, 0, count);
        } else {
            TextField tf = new TextField("");
            tf.setMaxWidth(170.0);
            tf.setMinWidth(170.0);
            gp2.add((Node)tf, 0, count);
            this.keyTFsMap.put(key, tf);
        }
        ImageView iv1 = new ImageView(ft == null ? null : ft.getIcon());
        iv1.setFitWidth(60.0);
        iv1.setFitHeight(60.0);
        iv1.setPreserveRatio(true);
        iv1.setSmooth(true);
        iv1.setCache(true);
        Label imagelabel = new Label("", (Node)iv1);
        gp2.add((Node)imagelabel, 2, count);
        Button iconfilebutton1 = new Button("Choose File");
        iconfilebutton1.setMaxWidth(100.0);
        iconfilebutton1.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                Image image = new Image("file:" + f.getAbsolutePath());
                iv1.setImage(image);
                this.changedImagesMap.put(key, image);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton1, 3, count);
        FocusSpinner sizespinner = new FocusSpinner(-100.0, 1000.0, ft == null ? 85.0 : ft.getIconSize() * 100.0);
        sizespinner.setMaxWidth(80.0);
        gp2.add(sizespinner, 4, count);
        sizespinner.setEditable(true);
        this.sizeSpinnersMap.put(key, sizespinner);
        FocusSpinner htspinner = new FocusSpinner(-100.0, 1000.0, ft == null ? 85.0 : ft.getIconHeight() * 100.0);
        htspinner.setMaxWidth(80.0);
        gp2.add(htspinner, 5, count);
        htspinner.setEditable(true);
        this.heightSpinnersMap.put(key, htspinner);
        ImageView iv2 = new ImageView(ft == null ? null : ft.getAlternateIcon());
        iv2.setFitWidth(60.0);
        iv2.setFitHeight(60.0);
        iv2.setPreserveRatio(true);
        iv2.setSmooth(true);
        iv2.setCache(true);
        Label imagelabel2 = new Label("", (Node)iv2);
        gp2.add((Node)imagelabel2, 6, count);
        Button iconfilebutton = new Button("Choose File");
        iconfilebutton.setMaxWidth(100.0);
        iconfilebutton.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                Image image = new Image("file:" + f.getAbsolutePath());
                iv2.setImage(image);
                this.changedAltImagesMap.put(key, image);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton, 7, count);
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {
            FeatureType ft2 = Feature.DEFAULT_FEATURES.get(key);
            if (ft2 != null) {
                iv1.setImage(ft2.getIcon());
                this.changedImagesMap.put(key, ft2.getIcon());
                iv2.setImage(ft2.getAlternateIcon());
                this.changedAltImagesMap.put(key, ft2.getAlternateIcon());
                sizespinner.getValueFactory().setValue((Object)(ft2.getIconSize() * 100.0));
            }
        });
        gp2.add((Node)resetbutton, 8, count);
        Button resetorigbutton = new Button("Reset To\nOriginal");
        resetorigbutton.setStyle("-fx-alignment: center ;");
        resetorigbutton.setOnAction(event -> {
            FeatureType ft2 = Feature.restoreOneDefault(key);
            if (ft2 != null) {
                iv1.setImage(ft2.getIcon());
                this.changedImagesMap.put(key, ft2.getIcon());
                iv2.setImage(ft2.getAlternateIcon());
                this.changedAltImagesMap.put(key, ft2.getAlternateIcon());
                sizespinner.getValueFactory().setValue((Object)(ft2.getIconSize() * 100.0));
            }
        });
        gp2.add((Node)resetorigbutton, 9, count);
        CheckBox removeCB = new CheckBox("Remove");
        this.removeCBsMap.put(key, removeCB);
        gp2.add((Node)removeCB, 10, count);
        return ++count;
    }
}

