/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapKeyEntry;
import com.inkwellideas.ographer.map.MapKeySettings;
import com.inkwellideas.ographer.map.MapKeyType;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Window;

public class ConfigureMapKeyFrame {
    final GridPane gp;
    final TextField titleTF;
    final TextField scaleTF;
    final ComboBox<String> titleFontFaceList;
    final ComboBox<String> scaleFontFaceList;
    final ComboBox<String> entryFontFaceList;
    final ColorPicker titleCP;
    final ColorPicker scaleCP;
    final ColorPicker entryCP;
    final ColorPicker backgroundCP;
    final CheckBox titleBoldCB;
    final CheckBox titleItalicCB;
    final CheckBox scaleBoldCB;
    final CheckBox scaleItalicCB;
    final CheckBox entryBoldCB;
    final CheckBox entryItalicCB;
    final Spinner<Integer> titleScaleSpinner;
    final Spinner<Integer> scaleScaleSpinner;
    final Spinner<Integer> entryScaleSpinner;
    final Spinner<Integer> opacitySpinner;
    final MapData mapData;
    private TextField[] nameTFs;
    private Spinner<Integer>[] orderSpinners;
    private Spinner<Integer>[] sizeSpinners;
    private ColorPicker[] backgroundCPs;
    ScrollPane entriesScrollPane;
    final Button addTerrainButton;
    final Button addFeatureButton;
    final Dialog<ButtonType> mainDialog;
    final CheckBox keepNamesCB = new CheckBox("Keep Labels");
    final CheckBox reOrderCB = new CheckBox("Reorder");
    final Spinner<Double> positionXSpinner;
    final Spinner<Double> positionYSpinner;
    final Spinner<Integer> heightSpinner;
    String titleText = "Map Key";
    String scaleText = "1 Hex = # Miles";
    int totalcount = 1;
    Map<String, MapKeyEntry> entries = new TreeMap<String, MapKeyEntry>();
    boolean hadSavedValues = false;
    MapKeySettings mapKeySettings;
    String[] LINE_LABELS = new String[]{"Major Border", "Minor Border", "Sea Fill", "Coastline ", "River ", "Road ", "Trail ", "Elevation", "Shipping Lane"};

    public ConfigureMapKeyFrame(Worldographer worldographer, MapUI mapUI) {
        this.mapData = mapUI.getMapData();
        this.mapKeySettings = mapUI.getMapData().getMapKeySettings();
        if (this.mapKeySettings.entries.size() > 0) {
            this.hadSavedValues = true;
            this.entries = this.mapKeySettings.entries;
        } else {
            this.setupTerrainFeatureShapeData(false);
        }
        this.mainDialog = new StyledDialog<ButtonType>(true, (Window)worldographer.getPrimaryStage(), "Worldographer Configure Map Key");
        this.gp = new GridPane();
        this.gp.setHgap(5.0);
        this.gp.setVgap(5.0);
        this.gp.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        List fonts = Font.getFamilies();
        Object[] fontarray = new String[fonts.size()];
        for (int i = 0; i < fontarray.length; ++i) {
            fontarray[i] = (String)fonts.get(i);
        }
        this.backgroundCP = new ColorPicker(this.mapKeySettings.backgroundColor);
        this.opacitySpinner = new FocusSpinner<Integer>(0, 100, this.mapKeySettings.backgroundOpacity);
        this.titleTF = new TextField();
        this.titleFontFaceList = new ComboBox(FXCollections.observableArrayList((Object[])fontarray));
        this.titleCP = new ColorPicker();
        this.titleBoldCB = new CheckBox("Bold");
        this.titleItalicCB = new CheckBox("Italic");
        this.titleScaleSpinner = new FocusSpinner<Integer>(1, 1000, 75);
        this.scaleTF = new TextField();
        this.scaleFontFaceList = new ComboBox(FXCollections.observableArrayList((Object[])fontarray));
        this.scaleCP = new ColorPicker();
        this.scaleBoldCB = new CheckBox("Bold");
        this.scaleItalicCB = new CheckBox("Italic");
        this.scaleScaleSpinner = new FocusSpinner<Integer>(1, 1000, 75);
        this.entryFontFaceList = new ComboBox(FXCollections.observableArrayList((Object[])fontarray));
        this.entryCP = new ColorPicker();
        this.entryBoldCB = new CheckBox("Bold");
        this.entryItalicCB = new CheckBox("Italic");
        this.entryScaleSpinner = new FocusSpinner<Integer>(1, 1000, 75);
        double x = this.mapKeySettings.positionx;
        double y = this.mapKeySettings.positiony;
        if (this.mapKeySettings.viewlevel == null) {
            this.mapKeySettings.viewlevel = mapUI.viewLevel;
        }
        double cv = 1.0;
        if (mapUI.viewLevel != this.mapKeySettings.viewlevel) {
            cv = MapObject.getConversionFactor(mapUI.viewLevel, this.mapKeySettings.viewlevel, this.mapData.getView().getContinentFactor(), this.mapData.getView().getKingdomFactor(), this.mapData.getView().getProvinceFactor());
        }
        this.positionXSpinner = new FocusSpinner<Double>(0.0, 1000.0, x * cv);
        this.positionXSpinner.setEditable(true);
        this.positionYSpinner = new FocusSpinner<Double>(0.0, 1000.0, y * cv);
        this.positionYSpinner.setEditable(true);
        this.heightSpinner = new FocusSpinner<Integer>(-1, 1000, this.mapKeySettings.height);
        this.heightSpinner.setEditable(true);
        this.mainDialog.setHeaderText("Worldographer Configure map Key");
        this.mainDialog.getDialogPane().setContent((Node)this.gp);
        this.gp.setMinWidth(900.0);
        this.addTerrainButton = new Button("Add Terrain");
        this.addTerrainButton.setOnAction(event -> {
            StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Add Terrain to Map Key");
            d2.setHeaderText("Add Terrain to Map Key");
            VBox box = new VBox();
            box.getChildren().add((Object)new Label("Select the terrain type you want to add to the map key.\nIt will appear as a new row in the map key dialog."));
            ComboBox tCombo = new ComboBox(FXCollections.observableArrayList(Terrain.terrainTypes.keySet()));
            box.getChildren().add((Object)tCombo);
            d2.getDialogPane().setContent((Node)box);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                String s = (String)tCombo.getSelectionModel().getSelectedItem();
                TerrainType tt = Terrain.terrainTypes.get(s);
                this.entries.put(String.valueOf((Object)MapKeyType.EE_TERRAIN) + "_" + s, new MapKeyEntry(MapKeyType.EE_TERRAIN, s, s, this.totalcount, tt.getBgColor(), (int)(tt.getIconSize() * 100.0)));
                ++this.totalcount;
                this.setupEntriesPane();
            }
        });
        this.addFeatureButton = new Button("Add Feature");
        this.addFeatureButton.setOnAction(event -> {
            StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Add Feature to Map Key");
            d2.setHeaderText("Add Feature to Map Key");
            VBox box = new VBox();
            box.getChildren().add((Object)new Label("Select the feature type you want to add to the map key.\nIt will appear as a new row in the map key dialog."));
            ComboBox tCombo = new ComboBox(FXCollections.observableArrayList(Feature.featureTypes.keySet()));
            box.getChildren().add((Object)tCombo);
            d2.getDialogPane().setContent((Node)box);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                String s = (String)tCombo.getSelectionModel().getSelectedItem();
                FeatureType ft = Feature.featureTypes.get(s);
                this.entries.put(String.valueOf((Object)MapKeyType.LL_FEATURE) + "_" + s, new MapKeyEntry(MapKeyType.LL_FEATURE, s, s, this.totalcount, null, (int)(ft.getIconSize() * 100.0)));
                ++this.totalcount;
                this.setupEntriesPane();
            }
        });
        this.setupUI();
        this.mainDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Optional result = this.mainDialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.mapKeySettings.positionx = (Double)this.positionXSpinner.getValue();
            this.mapKeySettings.positiony = (Double)this.positionYSpinner.getValue();
            this.mapKeySettings.viewlevel = mapUI.getViewLevel();
            this.mapKeySettings.height = (Integer)this.heightSpinner.getValue();
            this.mapKeySettings.backgroundColor = (Color)this.backgroundCP.getValue();
            this.mapKeySettings.backgroundOpacity = (Integer)this.opacitySpinner.getValue();
            this.mapKeySettings.titleText = this.titleTF.getText();
            this.mapKeySettings.titleFontFace = (String)this.titleFontFaceList.getValue();
            this.mapKeySettings.titleFontColor = (Color)this.titleCP.getValue();
            this.mapKeySettings.titleFontBold = this.titleBoldCB.isSelected();
            this.mapKeySettings.titleFontItalic = this.titleItalicCB.isSelected();
            this.mapKeySettings.titleScale = (Integer)this.titleScaleSpinner.getValue();
            this.mapKeySettings.scaleText = this.scaleTF.getText();
            this.mapKeySettings.scaleFontFace = (String)this.scaleFontFaceList.getValue();
            this.mapKeySettings.scaleFontColor = (Color)this.scaleCP.getValue();
            this.mapKeySettings.scaleFontBold = this.scaleBoldCB.isSelected();
            this.mapKeySettings.scaleFontItalic = this.scaleItalicCB.isSelected();
            this.mapKeySettings.scaleScale = (Integer)this.scaleScaleSpinner.getValue();
            this.mapKeySettings.entryFontFace = (String)this.entryFontFaceList.getValue();
            this.mapKeySettings.entryFontColor = (Color)this.entryCP.getValue();
            this.mapKeySettings.entryFontBold = this.entryBoldCB.isSelected();
            this.mapKeySettings.entryFontItalic = this.entryItalicCB.isSelected();
            this.mapKeySettings.entryScale = (Integer)this.entryScaleSpinner.getValue();
            int entrycount = 0;
            for (MapKeyEntry mke : this.entries.values()) {
                mke.setLabel(this.nameTFs[entrycount].getText());
                mke.setOrder((Integer)this.orderSpinners[entrycount].getValue());
                mke.setScale((Integer)this.sizeSpinners[entrycount].getValue());
                mke.setColor((Color)this.backgroundCPs[entrycount].getValue());
                ++entrycount;
            }
            this.mapKeySettings.entries = this.entries;
            mapUI.draw();
        }
    }

    private void setupTextBarUI(int row, String rowlabelstr, TextField tf, String text, ComboBox<String> fontlist, String face, ColorPicker fontcp, Color color, CheckBox boldCB, boolean isBold, CheckBox italicCB, boolean isItalic, Spinner<Integer> scaleSpinner, int scale) {
        Label rowlabel = new Label(rowlabelstr);
        Font f = rowlabel.getFont();
        rowlabel.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)f.getSize()));
        this.gp.add((Node)rowlabel, 0, row);
        if (tf != null) {
            tf.setText(text);
            this.gp.add((Node)tf, 1, row);
        }
        this.gp.add((Node)new Label("Font:"), 2, row);
        fontlist.getSelectionModel().select((Object)face);
        fontlist.setMaxWidth(150.0);
        this.gp.add(fontlist, 3, row);
        fontcp.setValue((Object)color);
        this.gp.add((Node)fontcp, 4, row);
        f = boldCB.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        boldCB.setFont(f);
        boldCB.setSelected(isBold);
        this.gp.add((Node)boldCB, 5, row);
        Font f2 = italicCB.getFont();
        f2 = Font.font((String)f2.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f2.getSize());
        italicCB.setFont(f2);
        italicCB.setSelected(isItalic);
        this.gp.add((Node)italicCB, 6, row);
        scaleSpinner.getValueFactory().setValue((Object)scale);
        scaleSpinner.setEditable(true);
        scaleSpinner.setMaxWidth(70.0);
        this.gp.add((Node)new Label("Tile Height %:"), 7, row);
        this.gp.add(scaleSpinner, 8, row);
    }

    private void setupEntry(GridPane entriesGridPane, int rowcount, int entrycount, MapKeyEntry mke, int totalcount) {
        entriesGridPane.add((Node)new Label(mke.getKey()), 0, rowcount);
        this.nameTFs[entrycount] = new TextField(mke.getLabel());
        entriesGridPane.add((Node)this.nameTFs[entrycount], 1, rowcount);
        this.backgroundCPs[entrycount] = new ColorPicker(mke.getColor());
        this.sizeSpinners[entrycount] = new FocusSpinner<Integer>(0, 1000, mke.getScale());
        this.sizeSpinners[entrycount].setEditable(true);
        if (mke.getType() != MapKeyType.SS_SHAPE) {
            entriesGridPane.add((Node)this.backgroundCPs[entrycount], 2, rowcount);
            entriesGridPane.add(this.sizeSpinners[entrycount], 3, rowcount);
        }
        this.sizeSpinners[entrycount].setMaxWidth(80.0);
        this.orderSpinners[entrycount] = new FocusSpinner<Integer>(0, totalcount, mke.getOrder());
        this.orderSpinners[entrycount].setEditable(true);
        this.orderSpinners[entrycount].setMaxWidth(80.0);
        entriesGridPane.add(this.orderSpinners[entrycount], 4, rowcount);
    }

    public void setupUI() {
        HBox settings1 = new HBox();
        settings1.setAlignment(Pos.CENTER);
        this.gp.add((Node)new Label("Instructions: Set the hex number where the upper left corner of the map key should be located.\nHeight is number of entries in each column.  New columns are added as needed. Set height to -1 to turn off the map key."), 0, 0, 8, 1);
        settings1.getChildren().add((Object)new Label("Upper Left X"));
        settings1.getChildren().add(this.positionXSpinner);
        settings1.getChildren().add((Object)new Label("  Upper Left Y"));
        settings1.getChildren().add(this.positionYSpinner);
        settings1.getChildren().add((Object)new Label("  Height"));
        settings1.getChildren().add(this.heightSpinner);
        this.gp.add((Node)settings1, 0, 1, 9, 1);
        HBox settings2 = new HBox();
        settings2.setAlignment(Pos.CENTER);
        settings2.getChildren().add((Object)new Label("Background Color"));
        settings2.getChildren().add((Object)this.backgroundCP);
        settings2.getChildren().add((Object)new Label("  Opacity"));
        settings2.getChildren().add(this.opacitySpinner);
        this.gp.add((Node)settings2, 0, 2, 9, 1);
        this.setupTextBarUI(4, "Title", this.titleTF, this.mapKeySettings.titleText, this.titleFontFaceList, this.mapKeySettings.titleFontFace, this.titleCP, this.mapKeySettings.titleFontColor, this.titleBoldCB, this.mapKeySettings.titleFontBold, this.titleItalicCB, this.mapKeySettings.titleFontItalic, this.titleScaleSpinner, this.mapKeySettings.titleScale);
        this.setupTextBarUI(5, "Scale", this.scaleTF, this.mapKeySettings.scaleText, this.scaleFontFaceList, this.mapKeySettings.scaleFontFace, this.scaleCP, this.mapKeySettings.scaleFontColor, this.scaleBoldCB, this.mapKeySettings.scaleFontBold, this.scaleItalicCB, this.mapKeySettings.scaleFontItalic, this.scaleScaleSpinner, this.mapKeySettings.scaleScale);
        this.setupTextBarUI(6, "Entry", null, "", this.entryFontFaceList, this.mapKeySettings.entryFontFace, this.entryCP, this.mapKeySettings.entryFontColor, this.entryBoldCB, this.mapKeySettings.entryFontBold, this.entryItalicCB, this.mapKeySettings.scaleFontItalic, this.entryScaleSpinner, this.mapKeySettings.entryScale);
        this.setupEntriesPane();
        HBox addBox = new HBox(new Node[]{this.addTerrainButton, this.addFeatureButton});
        this.gp.add((Node)addBox, 6, 15, 3, 1);
        HBox bottombox = new HBox();
        bottombox.setAlignment(Pos.CENTER);
        Button clearautoconfigbutton = new Button("Clear & Update");
        clearautoconfigbutton.setOnAction(event -> {
            this.entries.clear();
            this.setupTerrainFeatureShapeData(false);
            this.setupEntriesPane();
        });
        bottombox.getChildren().add((Object)clearautoconfigbutton);
        bottombox.getChildren().add((Object)new Label(" "));
        Button reautoconfigbutton = new Button("Update Entries");
        reautoconfigbutton.setOnAction(event -> {
            this.setupTerrainFeatureShapeData(false);
            this.setupEntriesPane();
        });
        bottombox.getChildren().add((Object)reautoconfigbutton);
        bottombox.getChildren().add((Object)new Label(" "));
        bottombox.getChildren().add((Object)this.keepNamesCB);
        bottombox.getChildren().add((Object)new Label(" "));
        bottombox.getChildren().add((Object)this.reOrderCB);
        this.gp.add((Node)bottombox, 0, 16, 9, 1);
    }

    private void setupEntriesPane() {
        int count = 0;
        int entrycount = 0;
        this.nameTFs = new TextField[this.entries.size()];
        this.backgroundCPs = new ColorPicker[this.entries.size()];
        this.orderSpinners = new FocusSpinner[this.entries.size()];
        this.sizeSpinners = new FocusSpinner[this.entries.size()];
        MapKeyType mkt = null;
        int totalcount = this.entries.size();
        GridPane entriesGridPane = new GridPane();
        for (MapKeyEntry mke : this.entries.values()) {
            if (mke.getType() != mkt) {
                Font f;
                Label label;
                if (mke.getType() == MapKeyType.EE_TERRAIN) {
                    label = new Label("TERRAIN");
                    f = label.getFont();
                    label.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)f.getSize()));
                    entriesGridPane.add((Node)label, 0, count);
                }
                if (mke.getType() == MapKeyType.LL_FEATURE) {
                    label = new Label("FEATURES");
                    f = label.getFont();
                    label.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)f.getSize()));
                    entriesGridPane.add((Node)label, 0, count);
                    Label l = new Label("Note: Excludes Features with Coast, River, or Mouth in the name.");
                    entriesGridPane.add((Node)l, 1, count, 3, 1);
                }
                if (mke.getType() == MapKeyType.SS_SHAPE) {
                    label = new Label("SHAPES");
                    f = label.getFont();
                    label.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)f.getSize()));
                    entriesGridPane.add((Node)label, 0, count);
                }
                entriesGridPane.add((Node)new Label("Key"), 0, ++count);
                entriesGridPane.add((Node)new Label("Label"), 1, count);
                if (mke.getType() != MapKeyType.SS_SHAPE) {
                    entriesGridPane.add((Node)new Label("Color"), 2, count);
                    entriesGridPane.add((Node)new Label("Size"), 3, count);
                } else {
                    entriesGridPane.add((Node)new Label(" "), 2, count);
                    entriesGridPane.add((Node)new Label(" "), 3, count);
                }
                entriesGridPane.add((Node)new Label("Order"), 4, count);
                mkt = mke.getType();
                ++count;
            }
            this.setupEntry(entriesGridPane, count, entrycount, mke, totalcount);
            ++count;
            ++entrycount;
        }
        this.entriesScrollPane = new ScrollPane((Node)entriesGridPane);
        this.entriesScrollPane.setMaxHeight(300.0);
        this.entriesScrollPane.setMinHeight(300.0);
        this.gp.add((Node)this.entriesScrollPane, 0, 7, 9, 7);
    }

    private void setupTerrainFeatureShapeData(boolean includeRiversCoasts) {
        MapKeyEntry entry;
        boolean reorder = this.reOrderCB.isSelected();
        boolean keepname = this.keepNamesCB.isSelected();
        TreeSet<String> terrainset = new TreeSet<String>();
        TreeSet<String> featureset = new TreeSet<String>();
        TreeSet<String> shapesset = new TreeSet<String>();
        this.collectTerrainUsed(terrainset, ViewLevel.WORLD);
        this.collectTerrainUsed(terrainset, ViewLevel.CONTINENT);
        this.collectTerrainUsed(terrainset, ViewLevel.KINGDOM);
        for (Feature f : this.mapData.getFeatures()) {
            if (!includeRiversCoasts && (f.getTypeName().toLowerCase().contains(" river ") || f.getTypeName().toLowerCase().contains(" coasts "))) continue;
            featureset.add(f.getTypeName());
        }
        for (MapShape ms : this.mapData.getShapes()) {
            if (ms.getTags().toLowerCase().startsWith("coastline")) continue;
            shapesset.add(ms.getTags());
        }
        for (String s : terrainset) {
            entry = this.entries.get(String.valueOf((Object)MapKeyType.EE_TERRAIN) + "_" + s);
            if (entry != null) {
                this.entries.put(String.valueOf((Object)MapKeyType.EE_TERRAIN) + "_" + s, new MapKeyEntry(MapKeyType.EE_TERRAIN, s, keepname ? entry.getLabel() : s, reorder ? this.totalcount : entry.getOrder(), entry.getColor(), entry.getScale()));
            } else {
                TerrainType tt = Terrain.terrainTypes.get(s);
                this.entries.put(String.valueOf((Object)MapKeyType.EE_TERRAIN) + "_" + s, new MapKeyEntry(MapKeyType.EE_TERRAIN, s, s, this.totalcount, tt.getBgColor(), (int)(tt.getIconSize() * 100.0)));
            }
            ++this.totalcount;
        }
        for (String s : featureset) {
            entry = this.entries.get(String.valueOf((Object)MapKeyType.LL_FEATURE) + "_" + s);
            if (entry != null) {
                this.entries.put(String.valueOf((Object)MapKeyType.LL_FEATURE) + "_" + s, new MapKeyEntry(MapKeyType.LL_FEATURE, s, keepname ? entry.getLabel() : s, reorder ? this.totalcount : entry.getOrder(), entry.getColor(), entry.getScale()));
            } else {
                this.entries.put(String.valueOf((Object)MapKeyType.LL_FEATURE) + "_" + s, new MapKeyEntry(MapKeyType.LL_FEATURE, s, s, this.totalcount, null, 80));
            }
            ++this.totalcount;
        }
        for (String s : shapesset) {
            entry = this.entries.get(String.valueOf((Object)MapKeyType.SS_SHAPE) + "_" + s);
            if (entry != null) {
                this.entries.put(String.valueOf((Object)MapKeyType.SS_SHAPE) + "_" + s, new MapKeyEntry(MapKeyType.SS_SHAPE, s, keepname ? entry.getLabel() : s, reorder ? this.totalcount : entry.getOrder(), entry.getColor(), entry.getScale()));
            } else {
                this.entries.put(String.valueOf((Object)MapKeyType.SS_SHAPE) + "_" + s, new MapKeyEntry(MapKeyType.SS_SHAPE, s, s, this.totalcount, null, 80));
            }
            ++this.totalcount;
        }
    }

    private void collectTerrainUsed(Set<String> terrainset, ViewLevel vl) {
        if (this.mapData.getTerrain(vl) != null) {
            for (int x = 0; x < this.mapData.getTerrain(vl).length; ++x) {
                for (int y = 0; y < this.mapData.getTerrain(vl)[x].length; ++y) {
                    terrainset.add(this.mapData.getTerrain(vl)[x][y].getTypeName());
                }
            }
        }
    }
}

