/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.Map;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureSingleTerrainScreen
extends ConfigureScreen {
    final ColorPicker backgroundCP = new ColorPicker();
    Image changedImage;
    Spinner<Double> sizeSpinner;
    Spinner<Double> offsetXSpinner;
    Spinner<Double> offsetYSpinner;
    TextField elevationTF;
    ListView<String> similarTerrainListView;
    final CheckBox removeImageCB = new CheckBox("Remove Image");
    final String typeName;

    public ConfigureSingleTerrainScreen(Worldographer ms, String typename) {
        super(ms, 800, 600);
        this.typeName = typename;
        this.worldographer.colorPickerWithSelectorList.clear();
    }

    @Override
    public void setValues() {
        this.title = "Configure Individual Terrain";
        this.configureLabel = "";
        this.configureTitle = "Configure Individual Terrain Instructions";
        this.configureHeader = "Edit a Single Terrain Type's Data/Settings.";
        this.configureScreenHelpText = "You may bulk edit these settings for many terrain at once via 'Configure Terrain' on the 'Configure' menu.\n<ul><li>Key: System name and usually the name of the terrain shown to the user in tooltips and such.</li>\n<li>BG Color: The background color of the terrain.  If the icon covers the full tile area, you won't see the background.</li>\n<li>--The adjacent medicine dropper lets you select a color by clicking anywhere in Worldgrapher's windows.</li>\n<li>Icon: The current icon for the terrain is displayed here. Change it to another file on your computer with the 'Choose File' button.</li>\n<li>Remove Image: If you want to remove the icon and no longer have an icon for this terrain, select this.</li>\n<li>Size: The size of the icon as a percentage of the tile's overall width</li>\n<li>Elevation: Set an elevation for the terrain. The defaults are in feet and when specific terrain is placed, it uses this number as well as the adjacent terrain's     elevation on the map to randomly set a new value. The final number can vary wildly in a thick mountain area for example.</li>\n<li>Offset X: You can shift the location of the icon within the terrain's tile.  This is a percentage of a tile with 0 being centered. Negative values will move it left, positive go right.</li>\n<li>Offset Y: As Offset X, but vertically. Negative values will move the icon up, positive down.</li>\n<li>Related Terrain: Select any number of terrain that may be randomly substituted with this terrain for placing terrain when the 'Shuffle' button on the Terrain toolbox/tab is on.    (Type text in the Filter box and click 'Update' to narrow down the list of terrain.  Note: If you update the filter, previously chosen terrain is forgotten.)</li>\n<li>Reset All Fields: Reset the values to what they were when you opened this window.</li></ul>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        TerrainType tt = Terrain.terrainTypes.get(this.typeName);
        tt.setDefaultAndUnchanged(false);
        if (this.changedImage != null) {
            tt.setIcon(this.changedImage);
        }
        System.out.println("changed icon: " + String.valueOf(this.changedImage));
        if (this.removeImageCB.isSelected()) {
            tt.setIcon(null);
        }
        tt.setBgColor((Color)this.backgroundCP.getValue());
        tt.setIconSize((Double)this.sizeSpinner.getValue() / 100.0);
        System.out.println("changed size " + String.valueOf(this.sizeSpinner.getValue()));
        tt.setOffsetXDecimal((Double)this.offsetXSpinner.getValue() / 100.0);
        tt.setOffsetYDecimal((Double)this.offsetYSpinner.getValue() / 100.0);
        tt.setElevation(Integer.parseInt(this.elevationTF.getText()));
        ObservableList items = this.similarTerrainListView.getSelectionModel().getSelectedItems();
        tt.setSimilarTerrain(items.toArray(new String[0]));
        this.worldographer.terrainToolbox.clearTerrainButtons();
        this.worldographer.terrainToolbox.updateTerrainButtonsFlow();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key:");
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("BG Color:");
        gp1.add((Node)l2, 0, 1);
        Label l3 = new Label("Icon:");
        gp1.add((Node)l3, 0, 2);
        Label l4 = new Label("Size:");
        gp1.add((Node)l4, 0, 5);
        Label l5 = new Label("Elevation:");
        gp1.add((Node)l5, 0, 6);
        Label offX = new Label("Offset X:");
        gp1.add((Node)offX, 0, 7);
        Label offY = new Label("Offset Y:");
        gp1.add((Node)offY, 0, 8);
        Label l7 = new Label("Related Terrain:");
        gp1.add((Node)l7, 2, 1);
        TerrainType tt = Terrain.terrainTypes.get(this.typeName);
        if (tt != null) {
            Label keylabel = new Label(this.typeName);
            gp1.add((Node)keylabel, 1, 0, 4, 1);
        } else {
            TextField tf = new TextField("");
            tf.setMaxWidth(160.0);
            tf.setMinWidth(160.0);
            gp1.add((Node)tf, 1, 0, 4, 1);
        }
        this.backgroundCP.setValue((Object)tt.getBgColor());
        ColorPickerWithSelector terrainColorPickerWSelector = new ColorPickerWithSelector(this.backgroundCP);
        terrainColorPickerWSelector.setMaxWidth(160.0);
        gp1.add(terrainColorPickerWSelector.getNode(), 1, 1);
        this.worldographer.colorPickerWithSelectorList.add(terrainColorPickerWSelector);
        ImageView iv = new ImageView(tt == null ? null : tt.getIcon());
        iv.setFitWidth(100.0);
        iv.setFitHeight(100.0);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        iv.setCache(true);
        Label imagelabel = new Label("", (Node)iv);
        gp1.add((Node)imagelabel, 1, 2);
        Button iconfilebutton = new Button("Choose File");
        iconfilebutton.setMaxWidth(100.0);
        iconfilebutton.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                Image image = new Image("file:" + f.getAbsolutePath());
                iv.setImage(image);
                this.changedImage = image;
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp1.add((Node)iconfilebutton, 1, 3);
        gp1.add((Node)this.removeImageCB, 1, 4);
        this.sizeSpinner = new FocusSpinner<Double>(1.0, 400.0, tt == null ? 85.0 : tt.getIconSize() * 100.0);
        this.sizeSpinner.setMaxWidth(70.0);
        gp1.add(this.sizeSpinner, 1, 5);
        this.sizeSpinner.setEditable(true);
        DecimalFormat format = new DecimalFormat("######");
        format.setParseIntegerOnly(true);
        this.elevationTF = new TextField();
        this.elevationTF.setText(Integer.toString(tt == null ? 0 : tt.getElevation()));
        this.elevationTF.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Number object = format.parse(c.getControlNewText(), parsePosition);
            if (object == null || parsePosition.getIndex() < c.getControlNewText().length()) {
                return null;
            }
            return c;
        }));
        this.elevationTF.setMaxWidth(70.0);
        gp1.add((Node)this.elevationTF, 1, 6);
        this.offsetXSpinner = new Spinner(-1000.0, 1000.0, tt.getOffsetXDecimal() * 100.0);
        this.offsetXSpinner.setEditable(true);
        this.offsetXSpinner.setMaxWidth(80.0);
        gp1.add(this.offsetXSpinner, 1, 7);
        this.offsetYSpinner = new Spinner(-1000.0, 1000.0, tt.getOffsetYDecimal() * 100.0);
        this.offsetYSpinner.setEditable(true);
        this.offsetYSpinner.setMaxWidth(80.0);
        gp1.add(this.offsetYSpinner, 1, 8);
        gp1.add((Node)new Label("Filter:"), 3, 1);
        TextField filterTF = new TextField();
        filterTF.setOnKeyReleased(event -> {
            System.out.println("event:" + String.valueOf(event));
            if (event.getCode() == KeyCode.ENTER) {
                this.updateTerrainList(filterTF);
            }
        });
        gp1.add((Node)filterTF, 4, 1);
        Button updateButton = new Button("Update");
        updateButton.setOnAction(event -> this.updateTerrainList(filterTF));
        gp1.add((Node)updateButton, 5, 1);
        this.similarTerrainListView = new ListView();
        ObservableList items = FXCollections.observableArrayList(Terrain.terrainTypes.keySet());
        this.similarTerrainListView.setItems(items);
        this.similarTerrainListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        if (tt.getSimilarTerrain() != null) {
            for (String similar : tt.getSimilarTerrain()) {
                this.similarTerrainListView.getSelectionModel().select((Object)similar);
            }
        }
        this.similarTerrainListView.setMaxSize(500.0, Double.MAX_VALUE);
        this.similarTerrainListView.setPrefHeight(Double.MAX_VALUE);
        gp1.add(this.similarTerrainListView, 3, 2, 3, 10);
        Button resetbutton = this.getResetButton(iv);
        VBox resetRemoveBox = new VBox();
        resetRemoveBox.setAlignment(Pos.CENTER_RIGHT);
        resetRemoveBox.getChildren().add((Object)resetbutton);
        gp1.add((Node)resetRemoveBox, 4, 0, 2, 1);
        return gp1;
    }

    private void updateTerrainList(TextField filterTF) {
        ObservableList items = FXCollections.observableArrayList();
        if (filterTF.getText() != null && !filterTF.getText().isEmpty()) {
            Set<String> originalList = Terrain.terrainTypes.keySet();
            items.clear();
            for (String s : originalList) {
                if (!s.toLowerCase().contains(filterTF.getText())) continue;
                items.add((Object)s);
            }
        }
        this.similarTerrainListView.setItems(items);
    }

    private Button getResetButton(ImageView iv) {
        Button resetbutton = new Button("Reset To Original");
        resetbutton.setOnAction(event -> {
            Map<String, TerrainType> terraindefaults = TerrainType.setupDefaults();
            TerrainType tt2 = terraindefaults.get(this.typeName);
            if (tt2 != null) {
                this.backgroundCP.setValue((Object)tt2.getBgColor());
                iv.setImage(tt2.getIcon());
                this.changedImage = tt2.getIcon();
                this.elevationTF.setText(Integer.toString(tt2.getElevation()));
                this.sizeSpinner.getValueFactory().setValue((Object)(tt2.getIconSize() * 100.0));
                this.offsetXSpinner.getValueFactory().setValue((Object)(tt2.getOffsetXDecimal() * 100.0));
                this.offsetYSpinner.getValueFactory().setValue((Object)(tt2.getOffsetYDecimal() * 100.0));
                ObservableList items = FXCollections.observableArrayList(Terrain.terrainTypes.keySet());
                this.similarTerrainListView.setItems(items);
                this.similarTerrainListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                if (tt2 != null && tt2.getSimilarTerrain() != null) {
                    for (String similar : tt2.getSimilarTerrain()) {
                        this.similarTerrainListView.getSelectionModel().select((Object)similar);
                    }
                }
            }
        });
        return resetbutton;
    }
}

