/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.TerrainToolbox;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

public class ConvertUnderlayMapDialog {
    public void convertUnderlayMap(Worldographer worldographer, MapUI mapUI, TerrainToolbox terrainToolbox) {
        if (mapUI.getMapData().getTrace().getImage() == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Underlay Image Needed");
            alert.setContentText("You must add an underlay image to use this feature. (See the right sidebar near the bottom.)");
            alert.showAndWait();
            return;
        }
        StyledDialog d1 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Convert Underlay Image");
        d1.setHeaderText("Convert Underlay Image: Select Terrain");
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        Label l = new Label("Which terrain set do you wish to use?");
        gp.add((Node)l, 0, 0, 10, 1);
        d1.getDialogPane().setContent((Node)l);
        ButtonType classic = new ButtonType("Classic");
        ButtonType isometric = new ButtonType("Isometric");
        ButtonType cancel = new ButtonType("Cancel");
        d1.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{classic, isometric, cancel});
        Optional result = d1.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        ArrayList<TerrainType> terrains = new ArrayList<TerrainType>();
        if (result.isPresent() && result.get() == classic) {
            Set<String> keys = Terrain.terrainTypes.keySet();
            for (String string : keys) {
                if (string.contains("ISO Cols") || string.contains("ISO Rows")) continue;
                terrains.add(Terrain.terrainTypes.get(string));
            }
        } else if (result.isPresent() && result.get() == isometric) {
            String lookingfor = "ISO Cols";
            if (mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
                lookingfor = "ISO Rows";
            }
            Set<String> keys = Terrain.terrainTypes.keySet();
            for (String k : keys) {
                if (!k.contains(lookingfor) || k.lastIndexOf(" ") == k.length() - 2 && !k.endsWith(" A")) continue;
                terrains.add(Terrain.terrainTypes.get(k));
            }
        }
        int count = 0;
        ArrayList<ToggleButton> togglebuttons = new ArrayList<ToggleButton>();
        for (TerrainType tt : terrains) {
            ToggleButton button = new ToggleButton();
            terrainToolbox.createTerrainButton(new Terrain(tt.getType(), true), button, false, 48.0);
            togglebuttons.add(button);
            if ((tt.getType().contains("Farmland") || tt.getType().contains("Hills") || tt.getType().contains("Mountains") || tt.getType().contains("Light Forest") || tt.getType().contains("Heavy Forest") || tt.getType().contains("Rocky Desert") || tt.getType().contains("Sandy Desert") || tt.getType().contains("Forested Hills") || tt.getType().contains("Forested Mountains") || tt.getType().contains("Sea") || tt.getType().contains("Ocean") || tt.getType().contains("Snow Fields")) && !tt.getType().contains("Hex Fill")) {
                button.setSelected(true);
            }
            gp.add((Node)button, count % 10, count / 10 + 1);
            ++count;
        }
        CheckBox checkBox = new CheckBox("Only convert tiles that currently have Blank Terrain.");
        checkBox.setSelected(true);
        gp.add((Node)checkBox, 0, count / 10 + 2, 10, 1);
        StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Convert Underlay Image");
        d2.setResizable(true);
        d2.setWidth(680.0);
        d2.setHeight(600.0);
        d2.setHeaderText("Convert Underlay Image Select Terrain");
        sp.setContent((Node)gp);
        d2.getDialogPane().setContent((Node)sp);
        ButtonType convert = new ButtonType("Convert");
        ButtonType cancel2 = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{convert, cancel2});
        Optional result2 = d2.showAndWait();
        if (result2.isPresent() && result2.get() == cancel2) {
            return;
        }
        ArrayList<Terrain> selectedterrain = new ArrayList<Terrain>();
        for (ToggleButton hb : togglebuttons) {
            if (!hb.isSelected()) continue;
            selectedterrain.add((Terrain)hb.getUserData());
        }
        mapUI.getController().convertUnderlay(checkBox.isSelected(), selectedterrain);
        mapUI.draw();
    }
}

