/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.ArrayList;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

public class MapLevelDialog {
    private final MapUI mapUI;
    private final Worldographer worldographer;

    public MapLevelDialog(Worldographer worldographer) {
        this.worldographer = worldographer;
        this.mapUI = worldographer.getMapUI();
    }

    public ViewLevel showGenerateMapLevelDialog(ViewLevel basevl) {
        StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "(Re)Generate Map Level");
        d.setHeaderText("Create a map level based on another map level.  Warning: This can not be undone!");
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        ArrayList<ViewLevel> levels = new ArrayList<ViewLevel>();
        if (basevl == null) {
            grid.add((Node)new Label("Create the map level based on the following level:"), 0, 0);
            if (this.mapUI.getMapData().getTerrain(ViewLevel.WORLD) != null) {
                levels.add(ViewLevel.WORLD);
            }
            if (this.mapUI.getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                levels.add(ViewLevel.CONTINENT);
            }
            if (this.mapUI.getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                levels.add(ViewLevel.KINGDOM);
            }
            if (this.mapUI.getMapData().getTerrain(ViewLevel.PROVINCE) != null) {
                levels.add(ViewLevel.PROVINCE);
            }
        } else {
            grid.add((Node)new Label("Create which new level:"), 0, 0);
            if (basevl == ViewLevel.WORLD) {
                levels.add(ViewLevel.CONTINENT);
            } else if (basevl == ViewLevel.CONTINENT) {
                levels.add(ViewLevel.WORLD);
                levels.add(ViewLevel.KINGDOM);
            } else if (basevl == ViewLevel.KINGDOM) {
                levels.add(ViewLevel.CONTINENT);
                levels.add(ViewLevel.PROVINCE);
            } else if (basevl == ViewLevel.PROVINCE) {
                levels.add(ViewLevel.KINGDOM);
            }
        }
        ComboBox vlCombo = new ComboBox(FXCollections.observableArrayList(levels));
        grid.add((Node)vlCombo, 1, 0);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            return (ViewLevel)((Object)vlCombo.getValue());
        }
        return null;
    }

    public ViewLevel showDeleteMapLevelDialog() {
        StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Delete Map Level");
        d.setHeaderText("Delete a map level.  Warning: This can not be undone!");
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        ArrayList<ViewLevel> levels = new ArrayList<ViewLevel>();
        grid.add((Node)new Label("Delete which level:"), 0, 0);
        if (this.mapUI.getMapData().getTerrain(ViewLevel.WORLD) != null) {
            levels.add(ViewLevel.WORLD);
        }
        if (this.mapUI.getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
            levels.add(ViewLevel.CONTINENT);
        }
        if (this.mapUI.getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
            levels.add(ViewLevel.KINGDOM);
        }
        if (this.mapUI.getMapData().getTerrain(ViewLevel.PROVINCE) != null) {
            levels.add(ViewLevel.PROVINCE);
        }
        if (levels.size() < 2) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Must Have 2+ View Levels");
            alert.setContentText("You must have 2 or more view levels to delete one.\nIf you wish to delete the only view level, start a new map.");
            alert.showAndWait();
            return null;
        }
        ComboBox vlCombo = new ComboBox(FXCollections.observableArrayList(levels));
        grid.add((Node)vlCombo, 1, 0);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            return (ViewLevel)((Object)vlCombo.getValue());
        }
        return null;
    }
}

