/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class StandardDialog {
    public static void showException(Stage parentStage, String title, String header, String shortExplanation, String labeltext, Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (ex != null) {
            ex.printStackTrace(pw);
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)parentStage);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(shortExplanation);
        Label label = new Label(labeltext);
        TextArea textArea = new TextArea(sw.toString());
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        if (ex != null) {
            expContent.add((Node)textArea, 0, 1);
        }
        if (ex != null) {
            alert.getDialogPane().setExpandableContent((Node)expContent);
        }
        alert.showAndWait();
    }

    public static void showDialog(Stage parentStage, String title, String header, String shortExplanation, String details, String labeltext) {
        Alert d = new Alert(Alert.AlertType.INFORMATION);
        d.initModality(Modality.APPLICATION_MODAL);
        d.initOwner((Window)parentStage);
        d.setTitle(title);
        d.setHeaderText(header);
        d.setContentText(shortExplanation);
        Label label = new Label(labeltext);
        TextArea textArea = new TextArea(details);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        if (details != null) {
            expContent.add((Node)textArea, 0, 1);
        }
        if (details != null) {
            d.getDialogPane().setExpandableContent((Node)expContent);
        }
        d.showAndWait();
    }

    public static boolean showYesNoDialog(Stage parentStage, String title, String header, String shortExplanation, String yesButtonText, String noButtonText) {
        StyledDialog d2 = new StyledDialog(true, (Window)parentStage, title);
        d2.setTitle(title);
        d2.setHeaderText(header);
        d2.setContentText(shortExplanation);
        ButtonType ok1 = new ButtonType(yesButtonText);
        ButtonType cancel = new ButtonType(noButtonText);
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        return result.isPresent() && result.get() == ok1;
    }

    public static void showContentDialog(Stage parentStage, String title, String header, Node content) {
        Alert d2 = new Alert(Alert.AlertType.INFORMATION);
        d2.initModality(Modality.APPLICATION_MODAL);
        d2.initOwner((Window)parentStage);
        d2.setTitle(title);
        d2.setHeaderText(header);
        d2.getDialogPane().setContent(content);
        d2.showAndWait();
    }

    public static String showTextInputDialog(String title, String header, String labeltext, String defaultValue) {
        TextInputDialog d2 = new TextInputDialog(defaultValue);
        d2.setTitle(title);
        d2.setHeaderText(header);
        d2.setContentText(labeltext);
        Optional result = d2.showAndWait();
        return result.orElse(null);
    }

    public static void showNoMapOpenDialog(Stage parentStage, String title) {
        StandardDialog.showDialog(parentStage, title, "No Map Open.", "Sorry, you must create or open a map first.", null, "");
    }

    public static void showInformationAlert(String title, String content) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(title);
        alert.setContentText(content);
        alert.showAndWait();
    }
}

