/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.gesture;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.PointUtility;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.undo.UndoAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;

public class KeyPress {
    public static void handleKeyPress(KeyEvent t, MapUI mapUI, Worldographer worldographer) {
        block111: {
            block114: {
                double adjust;
                block112: {
                    block116: {
                        block115: {
                            block113: {
                                Preferences prefs;
                                boolean confirm;
                                if (!(t.getTarget() instanceof Scene) && !(t.getTarget() instanceof TabPane)) {
                                    return;
                                }
                                if ("u".equals(t.getText()) && t.isControlDown() && t.isShiftDown() && (confirm = StandardDialog.showYesNoDialog(worldographer.getPrimaryStage(), "Remove License Keys?", "Remove License Keys?", "Are you sure you wish to remove your license keys?", "Yes", "No"))) {
                                    prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
                                    prefs.put("lik2025", "");
                                    FileSaveLoad.flushPrefs();
                                    StandardDialog.showDialog(worldographer.getPrimaryStage(), "Licenses Removed", "Licenses Removed", "The licenses have been removed.\n\nRestart Worldographer for the change to take effect.", null, null);
                                }
                                if ("r".equals(t.getText()) && t.isControlDown() && t.isShiftDown() && (confirm = StandardDialog.showYesNoDialog(worldographer.getPrimaryStage(), "Remove Stored Settings", "Remove Stored Settings", "Are you sure you wish to reset all your settings to the defaults?", "Yes", "No"))) {
                                    try {
                                        prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
                                        String lik = prefs.get("lik", "");
                                        prefs.clear();
                                        prefs.put("lik", lik);
                                        FileSaveLoad.flushPrefs();
                                        StandardDialog.showDialog(worldographer.getPrimaryStage(), "Settings Reset", "Settings Reset", "The settings have been reset.\n\nFor some settings, you must restart Worldographer for the change to take effect.", null, null);
                                    }
                                    catch (Exception e) {
                                        StandardDialog.showDialog(worldographer.getPrimaryStage(), "Settings Reset Failed", "Settings Reset Failed", "The settings couldn't be reset.\n\nYou'll need to edit your registry and remove any Worldographer or Inkwell Ideas properties.\n\nSearch for 'edit registry' and list your operating system for instructions.", null, null);
                                    }
                                }
                                if (mapUI == null) {
                                    return;
                                }
                                if (t.getCode() != KeyCode.UP && t.getCode() != KeyCode.DOWN && t.getCode() != KeyCode.LEFT && t.getCode() != KeyCode.RIGHT) break block111;
                                adjust = 300.0 / mapUI.getMapData().getTileWidth() / 2.0;
                                if (t.isShiftDown()) {
                                    adjust *= 10.0;
                                }
                                if (mapUI.getCurrentObjects().size() != 0) break block112;
                                if (t.getCode() != KeyCode.UP) break block113;
                                mapUI.vScrollBar.setValue(mapUI.vScrollBar.getValue() - mapUI.getMapData().getTileHeight() * 2.0);
                                break block114;
                            }
                            if (t.getCode() != KeyCode.DOWN) break block115;
                            mapUI.vScrollBar.setValue(mapUI.vScrollBar.getValue() + mapUI.getMapData().getTileHeight() * 2.0);
                            break block114;
                        }
                        if (t.getCode() != KeyCode.LEFT) break block116;
                        mapUI.hScrollBar.setValue(mapUI.hScrollBar.getValue() - mapUI.getMapData().getTileWidth() * 2.0);
                        break block114;
                    }
                    if (t.getCode() != KeyCode.RIGHT) break block114;
                    mapUI.hScrollBar.setValue(mapUI.hScrollBar.getValue() + mapUI.getMapData().getTileWidth() * 2.0);
                    break block114;
                }
                for (MapObject mo : mapUI.getCurrentObjects()) {
                    Point2D oldloc;
                    if (mo instanceof Feature) {
                        Feature fs = (Feature)mo;
                        oldloc = fs.getLocation(mapUI.getViewLevel());
                        if (t.getCode() == KeyCode.UP) {
                            fs.setLocation(mapUI.getViewLevel(), oldloc.getX(), oldloc.getY() - adjust);
                        } else if (t.getCode() == KeyCode.DOWN) {
                            fs.setLocation(mapUI.getViewLevel(), oldloc.getX(), oldloc.getY() + adjust);
                        } else if (t.getCode() == KeyCode.LEFT) {
                            if (t.isAltDown()) {
                                rotate = fs.getRotate() - (double)(t.isShiftDown() ? 15 : 1);
                                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)rotate);
                            } else {
                                fs.setLocation(mapUI.getViewLevel(), oldloc.getX() - adjust, oldloc.getY());
                            }
                        } else if (t.getCode() == KeyCode.RIGHT) {
                            if (t.isAltDown()) {
                                rotate = fs.getRotate() + (double)(t.isShiftDown() ? 15 : 1);
                                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)rotate);
                            } else {
                                fs.setLocation(mapUI.getViewLevel(), oldloc.getX() + adjust, oldloc.getY());
                            }
                        }
                        mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.FEATURE, fs, fs.getLocation(mapUI.viewLevel), oldloc, (Object)mapUI.viewLevel, null, null));
                        mapUI.draw();
                        continue;
                    }
                    if (!(mo instanceof MapLabel)) continue;
                    MapLabel ls = (MapLabel)mo;
                    oldloc = ls.getLocation(mapUI.getViewLevel());
                    if (t.getCode() == KeyCode.UP) {
                        ls.setLocationAndScale(mapUI.getViewLevel(), new Point2D(oldloc.getX(), oldloc.getY() - adjust), ls.getScale(mapUI.getViewLevel()));
                    } else if (t.getCode() == KeyCode.DOWN) {
                        ls.setLocationAndScale(mapUI.getViewLevel(), new Point2D(oldloc.getX(), oldloc.getY() + adjust), ls.getScale(mapUI.getViewLevel()));
                    } else if (t.getCode() == KeyCode.LEFT) {
                        ls.setLocationAndScale(mapUI.getViewLevel(), new Point2D(oldloc.getX() - adjust, oldloc.getY()), ls.getScale(mapUI.getViewLevel()));
                    } else if (t.getCode() == KeyCode.RIGHT) {
                        ls.setLocationAndScale(mapUI.getViewLevel(), new Point2D(oldloc.getX() + adjust, oldloc.getY()), ls.getScale(mapUI.getViewLevel()));
                    }
                    mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.LABEL, ls, ls.getLocation(mapUI.viewLevel), oldloc, (Object)mapUI.viewLevel, null, null));
                    mapUI.draw();
                }
            }
            t.consume();
        }
        if ("8".equals(t.getText())) {
            boolean triggered = false;
            for (MapObject mo : mapUI.getCurrentObjects()) {
                if (mo instanceof MapLabel) {
                    ((MapLabel)mo).setRotate(((MapLabel)mo).getRotate() + 5.0);
                    worldographer.labelsToolbox.labelRotateSpinner.getValueFactory().setValue((Object)((MapLabel)mo).getRotate());
                    triggered = true;
                    continue;
                }
                if (!(mo instanceof Feature)) continue;
                ((Feature)mo).setRotate(((Feature)mo).getRotate() + 5.0);
                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)((Feature)mo).getRotate());
                triggered = true;
            }
            if (!triggered) {
                mapUI.vScrollBar.decrement();
            }
            mapUI.draw();
        } else if ("9".equals(t.getText())) {
            mapUI.vScrollBar.decrement();
            mapUI.hScrollBar.increment();
            mapUI.draw();
        } else if ("2".equals(t.getText())) {
            boolean triggered = false;
            for (MapObject mo : mapUI.getCurrentObjects()) {
                if (mo instanceof MapLabel) {
                    ((MapLabel)mo).setRotate(((MapLabel)mo).getRotate() - 5.0);
                    worldographer.labelsToolbox.labelRotateSpinner.getValueFactory().setValue((Object)((MapLabel)mo).getRotate());
                    triggered = true;
                    continue;
                }
                if (!(mo instanceof Feature)) continue;
                ((Feature)mo).setRotate(((Feature)mo).getRotate() - 5.0);
                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)((Feature)mo).getRotate());
                triggered = true;
            }
            if (!triggered) {
                mapUI.vScrollBar.increment();
            }
            mapUI.draw();
        } else if ("3".equals(t.getText())) {
            mapUI.vScrollBar.increment();
            mapUI.hScrollBar.increment();
            mapUI.draw();
        }
        if ("6".equals(t.getText())) {
            boolean triggered = false;
            for (MapObject mo : mapUI.getCurrentObjects()) {
                if (mo instanceof MapLabel) {
                    ((MapLabel)mo).setRotate(((MapLabel)mo).getRotate() + 1.0);
                    worldographer.labelsToolbox.labelRotateSpinner.getValueFactory().setValue((Object)((MapLabel)mo).getRotate());
                    triggered = true;
                    continue;
                }
                if (!(mo instanceof Feature)) continue;
                ((Feature)mo).setRotate(((Feature)mo).getRotate() + 1.0);
                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)((Feature)mo).getRotate());
                triggered = true;
            }
            if (!triggered) {
                mapUI.hScrollBar.increment();
            }
            mapUI.draw();
        } else if ("1".equals(t.getText())) {
            mapUI.vScrollBar.increment();
            mapUI.hScrollBar.decrement();
            mapUI.draw();
        }
        if ("4".equals(t.getText())) {
            boolean triggered = false;
            for (MapObject mo : mapUI.getCurrentObjects()) {
                if (mo instanceof MapLabel) {
                    ((MapLabel)mo).setRotate(((MapLabel)mo).getRotate() - 1.0);
                    worldographer.labelsToolbox.labelRotateSpinner.getValueFactory().setValue((Object)((MapLabel)mo).getRotate());
                    triggered = true;
                    continue;
                }
                if (!(mo instanceof Feature)) continue;
                ((Feature)mo).setRotate(((Feature)mo).getRotate() - 1.0);
                worldographer.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)((Feature)mo).getRotate());
                triggered = true;
            }
            if (!triggered) {
                mapUI.hScrollBar.decrement();
            }
            mapUI.draw();
        } else if ("7".equals(t.getText())) {
            mapUI.vScrollBar.decrement();
            mapUI.hScrollBar.decrement();
            mapUI.draw();
        }
        if ("5".equals(t.getText())) {
            boolean resize;
            if (!(mapUI.getMapData().getTerrain(mapUI.getViewLevel()).length <= 1000 && mapUI.getMapData().getTerrain(mapUI.getViewLevel())[0].length <= 1000 || (resize = StandardDialog.showYesNoDialog(worldographer.getPrimaryStage(), "Show Entire Large Map?", "Show Entire Large Map?", "Your map is over 1000 tiles across or high. Showing the full\nmap will draw slowly. Show full map anyway?", "Yes", "Cancel")))) {
                return;
            }
            mapUI.totalMapWidthScreen = 0.0;
            mapUI.totalMapWidthBase = 0.0;
            mapUI.totalMapHeightScreen = 0.0;
            mapUI.totalMapHeightBase = 0.0;
            double w = mapUI.canvas.getWidth() / (double)(mapUI.getMapData().getTerrain(mapUI.getViewLevel()).length + 1);
            if (mapUI.getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
                w *= 1.3;
            }
            double oldw = (Double)worldographer.viewLevelBox.tileWidthSpinner.getValue();
            double oldh = (Double)worldographer.viewLevelBox.tileHeightSpinner.getValue();
            double h = oldh * w / oldw;
            if (mapUI.computeTotalMapHeightPixels(h) > mapUI.canvas.getHeight()) {
                h = mapUI.canvas.getHeight() / (double)(mapUI.getMapData().getTerrain(mapUI.getViewLevel())[0].length + 1);
                if (mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
                    h *= 1.3;
                }
                w = oldw * h / oldh;
            }
            worldographer.viewLevelBox.tileWidthSpinner.getValueFactory().setValue((Object)w);
            worldographer.viewLevelBox.tileHeightSpinner.getValueFactory().setValue((Object)h);
            mapUI.hScrollBar.setValue(mapUI.computeTotalMapWidthPixelsBaseTileSize() / 2.0 - mapUI.canvas.getWidth() / 2.0 * 300.0 / mapUI.getMapData().getTileWidth());
            mapUI.vScrollBar.setValue(mapUI.computeTotalMapHeightPixelsBaseTileSize() / 2.0 - mapUI.canvas.getHeight() / 2.0 * 300.0 / mapUI.getMapData().getTileHeight());
            mapUI.draw();
        }
        if ("+".equals(t.getText()) || "=".equals(t.getText())) {
            worldographer.viewLevelBox.zoomIn(mapUI.getModelCoordsFromScreenPt(mapUI.canvas.getWidth() / 2.0, mapUI.canvas.getHeight() / 2.0));
        }
        if ("-".equals(t.getText())) {
            worldographer.viewLevelBox.zoomOut(mapUI.getModelCoordsFromScreenPt(mapUI.canvas.getWidth() / 2.0, mapUI.canvas.getHeight() / 2.0));
        }
        if (t.isShortcutDown()) {
            if ("p".equalsIgnoreCase(t.getText())) {
                worldographer.miniMapToolbox.panButton.setSelected(true);
            }
            if ("g".equalsIgnoreCase(t.getText())) {
                worldographer.shapesToolbox.controlGClick();
            }
            if ("d".equalsIgnoreCase(t.getText())) {
                mapUI.getCurrentObjects().clear();
                mapUI.draw();
            }
            if ("l".equalsIgnoreCase(t.getText()) && t.isShiftDown()) {
                HashSet<MapShape> toremove = new HashSet<MapShape>();
                HashMap<Shape, Bounds> shapestobounds = new HashMap<Shape, Bounds>();
                HashSet<MapShape> toadd = new HashSet<MapShape>();
                double MAXX = 0.0;
                double MAXY = 0.0;
                for (MapShape ms : mapUI.getMapData().getShapes()) {
                    Bounds shapebounds = ms.getShape().getBoundsInLocal();
                    if (shapebounds.getMaxX() > MAXX) {
                        MAXX = shapebounds.getMaxX();
                    }
                    if (!(shapebounds.getMaxY() > MAXY)) continue;
                    MAXY = shapebounds.getMaxY();
                }
                double sectionwidth = (MAXX - 150.0) / 10.0;
                double sectionheight = (MAXY - 300.0) / 3.0;
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        double[] sectorpts = new double[]{(double)i * sectionwidth + 150.0, (double)j * sectionheight + 300.0, (double)(i + 1) * sectionwidth + 150.0, (double)j * sectionheight + 300.0, (double)(i + 1) * sectionwidth + 150.0, (double)(j + 1) * sectionheight + 300.0, (double)i * sectionwidth + 150.0, (double)(j + 1) * sectionheight + 300.0};
                        Polygon sectorpoly = new Polygon(sectorpts);
                        Bounds sectorpolybounds = sectorpoly.getBoundsInLocal();
                        for (MapShape ms : mapUI.getMapData().getShapes()) {
                            boolean boundsintersect;
                            Color strokecolor;
                            Color fillcolor = (Color)ms.getShape().getFill();
                            if (fillcolor == null) {
                                fillcolor = new Color(0.0, 0.0, 0.0, 0.0);
                            }
                            if ((strokecolor = (Color)ms.getShape().getStroke()) == null) {
                                strokecolor = new Color(1.0, 0.0, 0.0, 0.0);
                            }
                            if (ms.getShape() instanceof Path || fillcolor.getBlue() > 0.9 || strokecolor.getRed() < 0.1) {
                                toadd.add(ms);
                                continue;
                            }
                            Bounds shapebounds = (Bounds)shapestobounds.get(ms.getShape());
                            if (shapebounds == null) {
                                shapebounds = ms.getShape().getBoundsInLocal();
                                shapestobounds.put(ms.getShape(), shapebounds);
                            }
                            if (boundsintersect = shapebounds.intersects(sectorpolybounds)) {
                                Shape intersect = Shape.intersect((Shape)sectorpoly, (Shape)ms.getShape());
                                if (intersect.getBoundsInLocal().isEmpty()) continue;
                                if (ms.getShape() instanceof Polygon && !(intersect instanceof Polygon)) {
                                    List<List<Point2D>> intersectptslists = MapShape.getShapePointsImproved(intersect);
                                    for (List<Point2D> intersectpts : intersectptslists) {
                                        double[] dpts = new double[intersectpts.size() * 2];
                                        for (int m = 0; m < dpts.length; m += 2) {
                                            dpts[m] = i == 0 && j == 2 ? intersectpts.get(m / 2).getX() + sectionwidth * 10.0 : intersectpts.get(m / 2).getX();
                                            dpts[m + 1] = intersectpts.get(m / 2).getY();
                                        }
                                        intersect = new Polygon(dpts);
                                        MapShape newms = ms.clone();
                                        newms.setShape(intersect);
                                        intersect.setStroke(ms.getShape().getStroke());
                                        intersect.setStrokeWidth(ms.getShape().getStrokeWidth());
                                        intersect.setStrokeLineJoin(StrokeLineJoin.ROUND);
                                        intersect.setFill(ms.getShape().getFill());
                                        toadd.add(newms);
                                    }
                                } else {
                                    toadd.add(ms);
                                }
                                toremove.add(ms);
                                continue;
                            }
                            toadd.add(ms);
                        }
                    }
                }
                mapUI.getMapData().getShapes().removeAll(mapUI.getMapData().getShapes());
                mapUI.getMapData().getShapes().addAll(toadd);
                sectionwidth *= 2.0;
                for (MapShape ms : mapUI.getMapData().getShapes()) {
                    Shape sectorpolybounds = ms.getShape();
                    if (sectorpolybounds instanceof Polygon) {
                        Polygon p = (Polygon)sectorpolybounds;
                        for (int ptcount = 0; ptcount < p.getPoints().size(); ptcount += 2) {
                            Point2D pt = PointUtility.convertPtToIcosahedral(sectionwidth, sectionheight, (Double)p.getPoints().get(ptcount), (Double)p.getPoints().get(ptcount + 1));
                            p.getPoints().set(ptcount, (Object)pt.getX());
                        }
                        continue;
                    }
                    Shape ptcount = ms.getShape();
                    if (!(ptcount instanceof Path)) continue;
                    Path p = (Path)ptcount;
                    for (PathElement pe : p.getElements()) {
                        Point2D pt;
                        if (pe instanceof MoveTo) {
                            MoveTo mt = (MoveTo)pe;
                            pt = PointUtility.convertPtToIcosahedral(sectionwidth, sectionheight, mt.getX(), mt.getY());
                            mt.setX(pt.getX());
                            mt.setY(pt.getY());
                            continue;
                        }
                        if (!(pe instanceof LineTo)) continue;
                        LineTo lt = (LineTo)pe;
                        pt = PointUtility.convertPtToIcosahedral(sectionwidth, sectionheight, lt.getX(), lt.getY());
                        lt.setX(pt.getX());
                        lt.setY(pt.getY());
                    }
                }
                double v1 = sectionheight + 300.0;
                double v2 = v1 + sectionheight;
                double v3 = v2 + sectionheight;
                double h1 = sectionwidth / 2.0;
                double[] mask1 = new double[]{0.0, 0.0, 0.0, v1, 150.0, v1, h1 + 150.0, 300.0, h1 * 2.0 + 150.0, v1, h1 * 3.0 + 150.0, 300.0, h1 * 4.0 + 150.0, v1, h1 * 5.0 + 150.0, 300.0, h1 * 6.0 + 150.0, v1, h1 * 7.0 + 150.0, 300.0, h1 * 8.0 + 150.0, v1, h1 * 9.0 + 150.0, 300.0, h1 * 11.0 + 150.0, v2, h1 * 11.0 + 450.0, v2, h1 * 11.0 + 450.0, 0.0};
                Polygon maskpoly1 = new Polygon(mask1);
                MapShape maskshape1 = mapUI.getMapData().getShapes().get(0).clone();
                maskshape1.setShape((Shape)maskpoly1);
                mapUI.getMapData().getShapes().add(maskshape1);
                double[] mask2 = new double[]{0.0, v1, 150.0, v1, h1 * 2.0 + 150.0, v3, h1 * 3.0 + 150.0, v2, h1 * 4.0 + 150.0, v3, h1 * 5.0 + 150.0, v2, h1 * 6.0 + 150.0, v3, h1 * 7.0 + 150.0, v2, h1 * 8.0 + 150.0, v3, h1 * 9.0 + 150.0, v2, h1 * 10.0 + 150.0, v3, h1 * 11.0 + 150.0, v2, h1 * 11.0 + 450.0, v2, h1 * 11.0 + 450.0, v3 + 300.0, 0.0, v3 + 300.0};
                Polygon maskpoly2 = new Polygon(mask2);
                MapShape maskshape2 = mapUI.getMapData().getShapes().get(0).clone();
                maskshape2.setShape((Shape)maskpoly2);
                mapUI.getMapData().getShapes().add(maskshape2);
                mapUI.draw();
            }
            if ("f".equalsIgnoreCase(t.getText()) && t.isShiftDown() && t.isAltDown()) {
                System.out.println("converting to flat");
                int sectionwidth = 10800;
                int sectionheight = 5850;
                for (MapShape ms2 : mapUI.getMapData().getShapes()) {
                    Shape h = ms2.getShape();
                    if (h instanceof Polygon) {
                        Polygon p = (Polygon)h;
                        for (int ptcount = 0; ptcount < p.getPoints().size(); ptcount += 2) {
                            Point2D pt = PointUtility.convertPtToFlat(sectionwidth, sectionheight, (Double)p.getPoints().get(ptcount), (Double)p.getPoints().get(ptcount + 1));
                            p.getPoints().set(ptcount, (Object)pt.getX());
                        }
                        continue;
                    }
                    Shape ptcount = ms2.getShape();
                    if (!(ptcount instanceof Path)) continue;
                    Path p = (Path)ptcount;
                    for (PathElement pe : p.getElements()) {
                        Point2D pt;
                        if (pe instanceof MoveTo) {
                            MoveTo mt = (MoveTo)pe;
                            pt = PointUtility.convertPtToFlat(sectionwidth, sectionheight, mt.getX(), mt.getY());
                            mt.setX(pt.getX());
                            mt.setY(pt.getY());
                            continue;
                        }
                        if (!(pe instanceof LineTo)) continue;
                        LineTo lt = (LineTo)pe;
                        pt = PointUtility.convertPtToFlat(sectionwidth, sectionheight, lt.getX(), lt.getY());
                        lt.setX(pt.getX());
                        lt.setY(pt.getY());
                    }
                }
            }
            if ("r".equalsIgnoreCase(t.getText()) && t.isShiftDown()) {
                for (MapShape ms : mapUI.getMapData().getShapes()) {
                    if (ms.getTags().contains("ocean")) {
                        ms.getShape().setStroke((Paint)Color.NAVY);
                    }
                    if (ms.getShape() instanceof Path) {
                        for (PathElement pe : ((Path)ms.getShape()).getElements()) {
                            if (pe instanceof LineTo) {
                                LineTo lt = (LineTo)pe;
                                lt.setX((lt.getX() - 150.0) * 26.0 / 22.0 + 150.0);
                                lt.setY(lt.getY() * 26.0 / 22.0 - 54.5454);
                                continue;
                            }
                            if (pe instanceof MoveTo) {
                                MoveTo mt = (MoveTo)pe;
                                mt.setX((mt.getX() - 150.0) * 26.0 / 22.0 + 150.0);
                                mt.setY(mt.getY() * 26.0 / 22.0 - 54.5454);
                                continue;
                            }
                            if (!(pe instanceof CubicCurveTo)) continue;
                            CubicCurveTo ct = (CubicCurveTo)pe;
                            ct.setX((ct.getX() - 150.0) * 26.0 / 22.0 + 150.0);
                            ct.setY(ct.getY() * 26.0 / 22.0 - 54.5454);
                            ct.setControlX1((ct.getControlX1() - 150.0) * 26.0 / 22.0 + 150.0);
                            ct.setControlY1(ct.getControlY1() * 26.0 / 22.0 - 54.5454);
                            ct.setControlX2((ct.getControlX2() - 150.0) * 26.0 / 22.0 + 150.0);
                            ct.setControlY2(ct.getControlY2() * 26.0 / 22.0 - 54.5454);
                        }
                        continue;
                    }
                    Shape ms2 = ms.getShape();
                    if (!(ms2 instanceof Polygon)) continue;
                    Polygon p = (Polygon)ms2;
                    ArrayList<Double> newpts = new ArrayList<Double>();
                    int xy = 0;
                    for (Double d : p.getPoints()) {
                        if (xy % 2 == 1) {
                            newpts.add(d * 26.0 / 22.0 - 54.5454);
                        } else {
                            newpts.add((d - 150.0) * 26.0 / 22.0 + 150.0);
                        }
                        ++xy;
                    }
                    p.getPoints().remove(0, p.getPoints().size());
                    p.getPoints().addAll(newpts);
                }
                mapUI.draw();
            }
            if ("h".equalsIgnoreCase(t.getText()) && t.isShiftDown()) {
                Terrain[][] ter = mapUI.getMapData().getTerrain(mapUI.getViewLevel());
                HashSet<MapShape> toadd = new HashSet<MapShape>();
                MapShape ocean = null;
                for (MapShape ms : mapUI.getMapData().getShapes()) {
                    if (!ms.getTags().contains("ocean")) continue;
                    ocean = ms;
                    break;
                }
                if (ocean != null) {
                    for (int i = 0; i < ter.length; ++i) {
                        for (int j = 0; j < ter[i].length; ++j) {
                            double[] ptseven = new double[]{i * 225, j * 300 + 150, i * 225 + 75, j * 300, i * 225 + 225, j * 300, i * 225 + 300, j * 300 + 150, i * 225 + 225, j * 300 + 300, i * 225 + 75, j * 300 + 300, i * 225, j * 300 + 150};
                            double[] ptsodd = new double[]{i * 225, j * 300 + 300, i * 225 + 75, j * 300 + 150, i * 225 + 225, j * 300 + 150, i * 225 + 300, j * 300 + 300, i * 225 + 225, j * 300 + 450, i * 225 + 75, j * 300 + 450, i * 225, j * 300 + 300};
                            double[] pts = i % 2 == 0 ? ptseven : ptsodd;
                            Polygon hexpoly = new Polygon(pts);
                            hexpoly.setFill((Paint)new Color(0.55, 0.7, 0.85, 1.0));
                            hexpoly.setStroke((Paint)Color.NAVY);
                            hexpoly.setStrokeWidth(0.0);
                            MapShape newms = ocean.clone();
                            hexpoly.setFill((Paint)new Color(0.55, 0.7, 0.85, 1.0));
                            Shape intersect = Shape.intersect((Shape)hexpoly, (Shape)ocean.getShape());
                            intersect.setFill((Paint)new Color(0.55, 0.7, 0.85, 1.0));
                            hexpoly.setStroke((Paint)Color.NAVY);
                            hexpoly.setStrokeWidth(0.5);
                            newms.setShape(intersect);
                            if (intersect.getBoundsInLocal().isEmpty()) continue;
                            toadd.add(newms);
                        }
                    }
                }
                mapUI.getMapData().getShapes().remove(ocean);
                mapUI.getMapData().getShapes().addAll(toadd);
            }
            if ("l".equalsIgnoreCase(t.getText()) && mapUI != null) {
                for (MapObject mo : mapUI.getCurrentObjects()) {
                    MapShape ms;
                    if (!(mo instanceof MapShape) || !((ms = (MapShape)mo).getShape() instanceof Polygon) || !ms.getTags().toLowerCase().contains("coastline")) continue;
                    MapShape copied = ms.clone();
                    Polygon polygon = (Polygon)copied.getShape();
                    Path path = new Path();
                    ObservableList pts = polygon.getPoints();
                    boolean snappedpt = false;
                    for (int i = 0; i < pts.size() - 1; i += 2) {
                        if ((Double)pts.get(i) % 37.5 != 0.0 && (Double)pts.get(i + 1) % 37.5 != 0.0) {
                            if (!PointUtility.isPointInAnyCoastlinePolygon(mapUI, ms.getShape(), (Double)pts.get(i), (Double)pts.get(i + 1))) {
                                if (path.getElements().size() == 0) {
                                    MoveTo mt2 = new MoveTo(((Double)pts.get(i)).doubleValue(), ((Double)pts.get(i + 1)).doubleValue());
                                    path.getElements().add((Object)mt2);
                                    continue;
                                }
                                LineTo lt2 = new LineTo(((Double)pts.get(i)).doubleValue(), ((Double)pts.get(i + 1)).doubleValue());
                                path.getElements().add((Object)lt2);
                                continue;
                            }
                            snappedpt = true;
                            continue;
                        }
                        snappedpt = true;
                    }
                    if (!snappedpt) {
                        LineTo lt2 = new LineTo(((Double)pts.get(0)).doubleValue(), ((Double)pts.get(1)).doubleValue());
                        path.getElements().add((Object)lt2);
                    }
                    if (path.getElements().size() <= 0) continue;
                    copied.setShape((Shape)path);
                    copied.getShape().setStroke((Paint)Color.web((String)"#001a80"));
                    copied.getShape().setStrokeWidth(0.015);
                    copied.getShape().setFill(null);
                    mapUI.getController().addShapeComplete(copied);
                    mapUI.draw();
                }
            }
        }
    }
}

