/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.gesture;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Window;
import javafx.util.Pair;

public class RightClickMenu {
    public static ContextMenu createRightClickMenu(MouseEvent t, MapUI mapUI, Worldographer worldographer) {
        ContextMenu cm = new ContextMenu();
        Menu genHexCrawlLocation = new Menu("Generate Random Hex Crawl Details");
        MenuItem minorGenHexCrawlLocation = new MenuItem("Minor");
        genHexCrawlLocation.getItems().add((Object)minorGenHexCrawlLocation);
        minorGenHexCrawlLocation.setOnAction(event -> {
            String locLevel = "Minor";
            RightClickMenu.genHexCrawlHelper(t, mapUI, worldographer, locLevel);
        });
        MenuItem mediumGenHexCrawlLocation = new MenuItem("Medium");
        genHexCrawlLocation.getItems().add((Object)mediumGenHexCrawlLocation);
        mediumGenHexCrawlLocation.setOnAction(event -> {
            String locLevel = "Medium";
            RightClickMenu.genHexCrawlHelper(t, mapUI, worldographer, locLevel);
        });
        MenuItem majorGenHexCrawlLocation = new MenuItem("Major");
        genHexCrawlLocation.getItems().add((Object)majorGenHexCrawlLocation);
        majorGenHexCrawlLocation.setOnAction(event -> {
            String locLevel = "Major";
            RightClickMenu.genHexCrawlHelper(t, mapUI, worldographer, locLevel);
        });
        MenuItem genCoastItem = new MenuItem("Generate Coastline Here");
        genCoastItem.setOnAction(event -> worldographer.generateCoastlineForTile(t));
        MenuItem genEmpireItem = new MenuItem("Generate Nation/Empire Here");
        genEmpireItem.setOnAction(event -> {
            ArrayList<Information> nations = new ArrayList<Information>();
            worldographer.getNations(mapUI.getMapData().getInformation(), nations);
            StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Generate Nations/Empires");
            d.setHeaderText("Choose the following options:");
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            grid.add((Node)new Label("Select the nation/empire to place:"), 0, 0);
            ComboBox nationCombo = new ComboBox(FXCollections.observableArrayList(nations));
            nationCombo.getSelectionModel().select(0);
            grid.add((Node)nationCombo, 1, 0);
            grid.add((Node)new Label("Size limit (#settlements):"), 0, 1);
            Spinner sizeSpinner = new Spinner(3, 10000, 25);
            sizeSpinner.setEditable(true);
            grid.add((Node)sizeSpinner, 1, 1);
            grid.add((Node)new Label("Border Color:"), 0, 2);
            ColorPicker colorpicker = new ColorPicker(Color.DARKRED);
            grid.add((Node)colorpicker, 1, 2);
            grid.add((Node)new Label("Distance Between Towns/Forts/Etc. :"), 0, 3);
            Spinner distanceBetweenFeaturesSpinner = new Spinner(2, 10, UserPrefs.PREFS.getInt("empireFeatureDistances", 3));
            distanceBetweenFeaturesSpinner.setEditable(true);
            grid.add((Node)distanceBetweenFeaturesSpinner, 1, 3);
            grid.add((Node)new Label("Fill with translucency?"), 0, 4);
            CheckBox fillcheckbox = new CheckBox();
            grid.add((Node)fillcheckbox, 1, 4);
            d.getDialogPane().setContent((Node)grid);
            ButtonType yes = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                UndoActionGroup uag = new UndoActionGroup();
                int terraintype = 0;
                Terrain[][] terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
                HashMap<Point, Terrain> allEmpiresTerrain = new HashMap<Point, Terrain>();
                ArrayList<Polygon> empirepolygons = new ArrayList<Polygon>();
                Color empirecolor = (Color)colorpicker.getValue();
                HashMap<Point, Terrain> empireTerrain = new HashMap<Point, Terrain>();
                HashSet<Feature> empireFeatures = new HashSet<Feature>();
                Point2D terrainclickedcoord = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
                if (terrain != null && (terrain[0][0].getTypeName().contains("ISO ") || terrain[5][5].getTypeName().contains("ISO "))) {
                    terraintype = 1;
                }
                HashSet<Pair<Integer, Integer>> featureLocations = new HashSet<Pair<Integer, Integer>>();
                for (Feature f : mapUI.getMapData().getFeatures()) {
                    Point2D loc = f.getLocation(mapUI.viewLevel);
                    featureLocations.add(new Pair((Object)((int)loc.getX()), (Object)((int)loc.getY())));
                }
                MapLogic.createNation(null, mapUI.viewLevel, mapUI.getMapData(), uag, terrain, featureLocations, terraintype, 0, 1, allEmpiresTerrain, empirepolygons, (Color)colorpicker.getValue(), empireTerrain, empireFeatures, (int)terrainclickedcoord.getX(), (int)terrainclickedcoord.getY(), (Nation)nationCombo.getSelectionModel().getSelectedItem(), mapUI.getMapData().getMapLayer("Features"), mapUI.getMapData().getNotes(), (Integer)sizeSpinner.getValue(), true, (Integer)distanceBetweenFeaturesSpinner.getValue());
                MapLayer borderslayer = mapUI.getMapData().getMapLayer("Borders");
                if (borderslayer == null) {
                    borderslayer = new MapLayer("Borders");
                    List<MapLayer> layers = mapUI.getMapData().getMapLayers();
                    for (int i = 0; i < layers.size(); ++i) {
                        if (!layers.get(i).getName().equals("Features")) continue;
                        layers.add(i, borderslayer);
                        break;
                    }
                }
                MapLogic.createNationPostActions(nations, mapUI.getMapData(), uag, nations.indexOf((Nation)nationCombo.getSelectionModel().getSelectedItem()) + 1, allEmpiresTerrain, empirepolygons, empirecolor, worldographer.getMapUI().getViewLevel(), empireTerrain, empireFeatures, borderslayer, fillcheckbox.isSelected());
                mapUI.getController().getUndoRedoHandler().push(uag);
                mapUI.draw();
            }
        });
        MenuItem generateRoadFromThisFeature = new MenuItem("Generate Road From Feature Here To Nearest Settlement");
        generateRoadFromThisFeature.setOnAction(event -> {
            Object found = null;
            Point2D clickLocation = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
            for (Feature f : mapUI.getMapData().getFeatures()) {
                Point2D modelPt = f.getLocation(mapUI.viewLevel);
                Pair<Integer, Integer> fLocation = mapUI.getTerrainFromModelPt(modelPt.getX(), modelPt.getY());
                if ((double)((Integer)fLocation.getKey()).intValue() != clickLocation.getX() || (double)((Integer)fLocation.getValue()).intValue() != clickLocation.getY()) continue;
                UndoActionGroup uag = new UndoActionGroup();
                MapLogic.generateRegionRoads(null, worldographer, mapUI, uag, f, true, true, true, false, Color.color((double)0.1, (double)0.1, (double)0.1));
                mapUI.getController().getUndoRedoHandler().push(uag);
                mapUI.draw();
                break;
            }
        });
        MenuItem gmOnlyAllItem = new MenuItem("Set All Terrain GM Only Except This");
        gmOnlyAllItem.setOnAction(event -> {
            Terrain[][] terrain;
            Point2D terrainclickedcoord = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
            Terrain[][] terrainArray = terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
            int n = terrainArray.length;
            for (int i = 0; i < n; ++i) {
                Terrain[] terrains;
                for (Terrain value : terrains = terrainArray[i]) {
                    value.setGmOnly(true);
                }
            }
            terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()].setGmOnly(!terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()].isGmOnly());
            mapUI.draw();
        });
        MenuItem gmOnlyOffItem = new MenuItem("Turn Off GM Only on All Terrain");
        gmOnlyOffItem.setOnAction(event -> {
            Terrain[][] terrain;
            Terrain[][] terrainArray = terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
            int n = terrainArray.length;
            for (int i = 0; i < n; ++i) {
                Terrain[] terrains;
                for (Terrain value : terrains = terrainArray[i]) {
                    value.setGmOnly(false);
                }
            }
            mapUI.draw();
        });
        MenuItem gmOnlyItem = new MenuItem("Toggle GM Only This Location");
        gmOnlyItem.setOnAction(event -> {
            Point2D terrainclickedcoord = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
            Terrain[][] terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
            terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()].setGmOnly(!terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()].isGmOnly());
            mapUI.draw();
        });
        MenuItem convertUnderlayColorItem = new MenuItem("Convert Underlay Color");
        convertUnderlayColorItem.setOnAction(event -> {
            MapData mapData = mapUI.getMapData();
            Image image = mapData.getTrace().getImage();
            ImageView iv1 = new ImageView();
            iv1.setImage(image);
            ImageView iv2 = new ImageView();
            iv2.setImage(image);
            int imagedisplaywidth = (int)(mapData.getTrace().getWidth() * mapData.getTileWidth() * 100.0 * 3.0 / 4.0 + mapData.getTileWidth() / 2.0);
            int imagedisplayheight = (int)(mapData.getTrace().getHeight() * mapData.getTileHeight() * 100.0 + mapData.getTileHeight() / 2.0);
            if (mapData.getTileOrientation() == HexOrientation.ROWS) {
                imagedisplaywidth = (int)(mapData.getTrace().getWidth() * mapData.getTileWidth() * 100.0 + mapData.getTileWidth() / 2.0);
                imagedisplayheight = (int)(mapData.getTrace().getHeight() * mapData.getTileHeight() * 100.0 * 3.0 / 4.0 + mapData.getTileHeight() / 2.0);
            }
            WritableImage wimg = new WritableImage(imagedisplaywidth, imagedisplayheight);
            SnapshotParameters ssparams = new SnapshotParameters();
            ssparams.setTransform((Transform)new Scale((double)imagedisplaywidth / image.getWidth(), (double)imagedisplayheight / image.getHeight()));
            iv2.snapshot(ssparams, wimg);
            UndoActionGroup uag = new UndoActionGroup();
            Color colorToMatch = wimg.getPixelReader().getColor((int)t.getX(), (int)t.getY());
            System.out.println(colorToMatch);
            ArrayList<Polygon> largePolygons = new ArrayList<Polygon>();
            List<Shape> polygons = RightClickMenu.checkColorMatchFullImage(wimg, colorToMatch);
            System.out.println("polys:" + polygons.size());
            boolean hadoverlap = true;
            ArrayList<Shape> toremove = new ArrayList<Shape>();
            Shape s = null;
            while (hadoverlap) {
                hadoverlap = false;
                for (int i = 0; i < polygons.size(); ++i) {
                    Shape p1 = polygons.get(i);
                    for (int j = i + 1; j < polygons.size(); ++j) {
                        Shape p2 = polygons.get(j);
                        s = Shape.intersect((Shape)p1, (Shape)p2);
                        if (s == null || ((Path)s).getElements().size() <= 0) continue;
                        s = Shape.union((Shape)p1, (Shape)p2);
                        hadoverlap = true;
                        toremove.add(p1);
                        toremove.add(p2);
                        System.out.println("overlapped:" + polygons.size());
                        break;
                    }
                    if (hadoverlap) break;
                }
                if (!hadoverlap) continue;
                polygons.removeAll(toremove);
                Polygon polygon = new Polygon();
                Path p = (Path)s;
                for (int i = 0; i < p.getElements().size(); ++i) {
                    PathElement pe = (PathElement)p.getElements().get(i);
                    if (pe instanceof LineTo) {
                        polygon.getPoints().add((Object)((LineTo)pe).getX());
                        polygon.getPoints().add((Object)((LineTo)pe).getY());
                        continue;
                    }
                    if (!(pe instanceof MoveTo)) continue;
                    polygon.getPoints().add((Object)((MoveTo)pe).getX());
                    polygon.getPoints().add((Object)((MoveTo)pe).getY());
                }
                if (polygon.getPoints().size() > 100) {
                    largePolygons.add(polygon);
                    continue;
                }
                if (polygon.getPoints().size() <= 0) continue;
                polygons.add(0, (Shape)polygon);
            }
            polygons.addAll(largePolygons);
            for (Shape polygon : polygons) {
                Polygon poly = (Polygon)polygon;
                for (int i = 0; i < poly.getPoints().size(); ++i) {
                    poly.getPoints().set(i, (Object)((Double)poly.getPoints().get(i) * 300.0 / (i % 2 == 0 ? mapData.getTileWidth() : mapData.getTileHeight())));
                }
                polygon.setFill((Paint)Color.BLUE);
                MapLayer ml = mapUI.getMapData().getMapLayer("Above Terrain");
                MapShape ms = new MapShape(ViewLevel.WORLD, mapUI.viewLevel, polygon, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "coastline", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
                mapUI.getMapData().getShapes().add(ms);
                System.out.println("added shape:" + String.valueOf(polygon));
                mapUI.draw();
            }
        });
        cm.getItems().addAll((Object[])new MenuItem[]{gmOnlyItem, gmOnlyAllItem, gmOnlyOffItem, genEmpireItem, genCoastItem});
        if (mapUI.getViewLevel() == ViewLevel.WORLD || mapUI.getViewLevel() == ViewLevel.CONTINENT || mapUI.getViewLevel() == ViewLevel.KINGDOM) {
            MenuItem infoItem = new MenuItem("Terrain Info");
            infoItem.setOnAction(event -> {
                Point2D terrainclickedcoord = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
                Terrain[][] terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
                Terrain ter = terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()];
                StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Terrain Info");
                d.setHeaderText("Terrain Info " + String.valueOf((Object)mapUI.getViewLevel()) + " Level: " + terrainclickedcoord.getX() + "," + terrainclickedcoord.getY());
                GridPane grid = new GridPane();
                grid.setHgap(3.0);
                grid.setVgap(3.0);
                grid.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                grid.add((Node)new Label("Elevation:"), 0, 0);
                grid.add((Node)new Label("" + ter.getElevation()), 1, 0);
                grid.add((Node)new Label("Animals:"), 0, 1);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[0]), 1, 1);
                grid.add((Node)new Label("Brick:"), 2, 1);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[1]), 3, 1);
                grid.add((Node)new Label("Crops:"), 0, 2);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[2]), 1, 2);
                grid.add((Node)new Label("Gems:"), 2, 2);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[3]), 3, 2);
                grid.add((Node)new Label("Lumber:"), 0, 3);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[4]), 1, 3);
                grid.add((Node)new Label("Metals:"), 2, 3);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[5]), 3, 3);
                grid.add((Node)new Label("Rock:"), 0, 4);
                grid.add((Node)new Label("" + ter.getExtraInfo().getResources()[6]), 1, 4);
                grid.add((Node)new Label("To edit: Select terrain and use the controls\nat the bottom of the terrain drawer."), 0, 5, 4, 1);
                d.getDialogPane().setContent((Node)grid);
                ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{cancel});
                d.show();
                mapUI.draw();
            });
            cm.getItems().add((Object)genHexCrawlLocation);
            cm.getItems().add((Object)generateRoadFromThisFeature);
            cm.getItems().add((Object)infoItem);
        }
        return cm;
    }

    private static void genHexCrawlHelper(MouseEvent t, MapUI mapUI, Worldographer worldographer, String locLevel) {
        Point2D terrainclickedcoord = mapUI.getTerrainFromScenePt(t.getX(), t.getY());
        Terrain[][] terrain = mapUI.getMapData().getTerrain(mapUI.viewLevel);
        Terrain ter = terrain[(int)terrainclickedcoord.getX()][(int)terrainclickedcoord.getY()];
        Point2D modelPt = mapUI.getModelCoordsFromScreenPt(t.getX(), t.getY());
        UndoActionGroup uag = new UndoActionGroup();
        MapLogic.getHexCrawlLocation(modelPt, ter, mapUI.getMapData(), mapUI.viewLevel, worldographer, locLevel, uag, true);
        if (uag.getActions().size() > 0) {
            mapUI.getController().getUndoRedoHandler().push(uag);
        }
    }

    private static List<Shape> checkColorMatchFullImage(WritableImage wimg, Color colorToMatch) {
        ArrayList<Shape> polys = new ArrayList<Shape>();
        int i = 1;
        while ((double)i < wimg.getWidth()) {
            int j = 1;
            while ((double)j < wimg.getHeight()) {
                Color c = wimg.getPixelReader().getColor(i, j);
                if (c.equals((Object)colorToMatch)) {
                    Polygon p = new Polygon();
                    p.getPoints().add((Object)((double)i - 2.0));
                    p.getPoints().add((Object)((double)j - 2.0));
                    p.getPoints().add((Object)((double)i + 2.0));
                    p.getPoints().add((Object)((double)j - 2.0));
                    p.getPoints().add((Object)((double)i + 2.0));
                    p.getPoints().add((Object)((double)j + 2.0));
                    p.getPoints().add((Object)((double)i - 2.0));
                    p.getPoints().add((Object)((double)j + 2.0));
                    p.setFill((Paint)Color.RED);
                    polys.add((Shape)p);
                    System.out.println("added");
                }
                j += 3;
            }
            i += 3;
        }
        return polys;
    }

    private static void checkColorMatch(WritableImage wimg, Color colorToMatch, boolean[][] colorMatchArray, int xcount, int ycount) {
        Color c;
        if (xcount < 0) {
            return;
        }
        if (xcount > colorMatchArray.length - 1) {
            return;
        }
        if (!colorMatchArray[xcount][ycount]) {
            colorMatchArray[xcount][ycount] = true;
        }
        ArrayList<Point2D> newPts = new ArrayList<Point2D>();
        int startycount = ycount--;
        while (ycount >= 0 && RightClickMenu.checkColorMatchOnePixel(wimg, colorToMatch, colorMatchArray, xcount, ycount, c = wimg.getPixelReader().getColor(xcount, ycount)) && !colorMatchArray[xcount][ycount]) {
            newPts.add(new Point2D((double)xcount, (double)ycount));
            colorMatchArray[xcount][ycount] = true;
            --ycount;
        }
        for (ycount = startycount + 1; ycount < colorMatchArray[0].length && RightClickMenu.checkColorMatchOnePixel(wimg, colorToMatch, colorMatchArray, xcount, ycount, c = wimg.getPixelReader().getColor(xcount, ycount)) && !colorMatchArray[xcount][ycount]; ++ycount) {
            newPts.add(new Point2D((double)xcount, (double)ycount));
            colorMatchArray[xcount][ycount] = true;
        }
        for (Point2D pt : newPts) {
            RightClickMenu.checkColorMatch(wimg, colorToMatch, colorMatchArray, (int)pt.getX() + 1, (int)pt.getY());
            RightClickMenu.checkColorMatch(wimg, colorToMatch, colorMatchArray, (int)pt.getX() - 1, (int)pt.getY());
        }
    }

    private static boolean checkColorMatchOnePixel(WritableImage wimg, Color colorToMatch, boolean[][] colorMatchArray, int xcount, int ycount, Color c) {
        return c.getRed() > colorToMatch.getRed() * 0.99 && c.getRed() < colorToMatch.getRed() * 1.01 && c.getGreen() > colorToMatch.getGreen() * 0.99 && c.getGreen() < colorToMatch.getGreen() * 1.01 && c.getBlue() > colorToMatch.getBlue() * 0.99 && c.getBlue() < colorToMatch.getBlue() * 1.01;
    }
}

