/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import java.util.Collection;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class LayersToolbox
extends Toolbox {
    public final TableView<MapLayer> layersTableView = new TableView();

    public LayersToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Layers", "other_imgs/layers_24.png", this.createLayersTable(), 300, 300, false);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public Node createLayersTable() {
        this.layersTableView.getColumns().removeAll((Collection)this.layersTableView.getColumns());
        BorderPane borderpane = new BorderPane();
        borderpane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        TableColumn visColumn = new TableColumn("Visible?");
        visColumn.setCellValueFactory((Callback)new PropertyValueFactory("visible"));
        visColumn.setCellFactory(CheckBoxTableCell.forTableColumn(param -> {
            MapLayer input = (MapLayer)this.layersTableView.getItems().get(param.intValue());
            input.visibleProperty().addListener(l -> this.mapUI().draw());
            return input.visibleProperty();
        }));
        visColumn.setOnEditCommit(event -> {
            ((MapLayer)event.getRowValue()).setVisible((Boolean)event.getNewValue());
            this.mapUI().draw();
        });
        visColumn.setPrefWidth(70.0);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        nameColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<MapLayer, String>>(this){

            public void handle(TableColumn.CellEditEvent<MapLayer, String> t) {
                Worldographer.getMapUI().getController().renameLayer((MapLayer)t.getTableView().getItems().get(t.getTablePosition().getRow()), (String)t.getNewValue());
            }
        });
        nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameColumn.setPrefWidth(210.0);
        TableColumn opacityColumn = new TableColumn("Opactiy");
        opacityColumn.setPrefWidth(90.0);
        opacityColumn.setCellValueFactory(op -> Bindings.createObjectBinding(() -> (MapLayer)op.getValue(), (Observable[])new Observable[0]));
        opacityColumn.setCellFactory((Callback)new Callback<TableColumn<MapLayer, MapLayer>, TableCell<MapLayer, MapLayer>>(){

            public TableCell<MapLayer, MapLayer> call(TableColumn<MapLayer, MapLayer> param) {
                TableCell<MapLayer, MapLayer> cell = new TableCell<MapLayer, MapLayer>(){
                    private final Spinner<Integer> opacitySpinner;
                    private final SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 100, 100, 5);
                    private final ChangeListener<Number> valueChangeListener;
                    {
                        this.opacitySpinner = new Spinner((SpinnerValueFactory)this.valueFactory);
                        this.opacitySpinner.setEditable(true);
                        this.opacitySpinner.setVisible(false);
                        this.setGraphic((Node)this.opacitySpinner);
                        this.valueChangeListener = (observable, oldValue, newValue) -> this.valueFactory.setValue((Object)((int)(newValue.doubleValue() * 100.0)));
                        this.opacitySpinner.valueProperty().addListener((obs, oldValue, newValue) -> {
                            if (this.getItem() != null) {
                                ((MapLayer)this.getItem()).setOpacity((double)newValue.intValue() / 100.0);
                                LayersToolbox.this.mapUI().draw();
                            }
                        });
                    }

                    public void updateItem(MapLayer layer, boolean empty) {
                        this.valueFactory.maxProperty().unbind();
                        if (this.getItem() != null) {
                            ((MapLayer)this.getItem()).opacityProperty().removeListener(this.valueChangeListener);
                        }
                        super.updateItem((Object)layer, empty);
                        if (empty || layer == null) {
                            this.opacitySpinner.setVisible(false);
                        } else {
                            this.valueFactory.setValue((Object)((int)(layer.getOpacity() * 100.0)));
                            layer.opacityProperty().addListener(this.valueChangeListener);
                            this.opacitySpinner.setVisible(true);
                        }
                    }
                };
                return cell;
            }
        });
        this.layersTableView.setSortPolicy(null);
        this.layersTableView.getColumns().add((Object)visColumn);
        this.layersTableView.getColumns().add((Object)nameColumn);
        this.layersTableView.getColumns().add((Object)opacityColumn);
        this.layersTableView.setItems(this.worldographer.observableLayers);
        this.layersTableView.setEditable(true);
        this.layersTableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    Integer index = row.getIndex();
                    Dragboard db = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    db.setDragView((Image)row.snapshot(null, null));
                    ClipboardContent cc = new ClipboardContent();
                    cc.put((Object)Worldographer.SERIALIZED_MIME_TYPE, (Object)index);
                    db.setContent((Map)cc);
                    event.consume();
                }
            });
            row.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasContent(Worldographer.SERIALIZED_MIME_TYPE) && row.getIndex() != ((Integer)db.getContent(Worldographer.SERIALIZED_MIME_TYPE)).intValue()) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                    event.consume();
                }
            });
            row.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasContent(Worldographer.SERIALIZED_MIME_TYPE)) {
                    MapLayer featuresselectedlayer = (MapLayer)this.worldographer.featuresToolbox.featuresMapLayerCombo.getValue();
                    MapLayer labelsselectedlayer = (MapLayer)this.worldographer.featuresToolbox.featuresMapLayerCombo.getValue();
                    MapLayer shapesselectedlayer = (MapLayer)this.worldographer.featuresToolbox.featuresMapLayerCombo.getValue();
                    int draggedIndex = (Integer)db.getContent(Worldographer.SERIALIZED_MIME_TYPE);
                    MapLayer draggedLayer = (MapLayer)this.layersTableView.getItems().remove(draggedIndex);
                    int dropIndex = row.isEmpty() ? this.layersTableView.getItems().size() : row.getIndex();
                    MapLayer dragged = this.mapUI().getMapData().getMapLayers().remove(draggedIndex);
                    this.mapUI().getMapData().getMapLayers().add(dropIndex, dragged);
                    this.layersTableView.getItems().add(dropIndex, (Object)draggedLayer);
                    this.layersTableView.getSelectionModel().select((Object)draggedLayer);
                    this.mapUI().draw();
                    event.setDropCompleted(true);
                    this.layersTableView.refresh();
                    this.worldographer.featuresToolbox.featuresMapLayerCombo.getSelectionModel().select((Object)featuresselectedlayer);
                    this.worldographer.labelsToolbox.labelsMapLayerCombo.getSelectionModel().select((Object)labelsselectedlayer);
                    this.worldographer.shapesToolbox.shapesMapLayerCombo.getSelectionModel().select((Object)shapesselectedlayer);
                    event.consume();
                }
            });
            return row;
        });
        borderpane.setCenter(this.layersTableView);
        Button addbutton = new Button("Add Above Selected");
        addbutton.setPrefWidth(150.0);
        addbutton.setOnAction(event -> {
            String name;
            int index = this.layersTableView.getSelectionModel().getSelectedIndex();
            if (index < 0 || index >= this.layersTableView.getItems().size()) {
                index = 0;
            }
            if ((name = StandardDialog.showTextInputDialog("Layer Name", "Enter Layer Name", "Name:", "")) != null) {
                MapLayer ml = this.mapUI().getController().addLayer(index, name);
                this.layersTableView.getItems().add(index, (Object)ml);
            }
        });
        Button removebutton = new Button("Remove Selected");
        removebutton.setPrefWidth(150.0);
        removebutton.setOnAction(event -> {
            MapLayer ml = (MapLayer)this.layersTableView.getSelectionModel().getSelectedItem();
            if (ml == null) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "No Layer Selected", "No Layer Selected", "You must select a layer to remove in the table.", null, "OK");
                return;
            }
            boolean remove = StandardDialog.showYesNoDialog(this.worldographer.getPrimaryStage(), "Remove Selected Layer", "Remove Selected Layer", "Removing the selected layer will remove all objects\non that layer and the layer.  Are you sure?", "Yes, Remove Them", "No");
            if (remove) {
                this.mapUI().getController().removeLayer(ml, this.layersTableView.getSelectionModel().getSelectedIndex());
                this.layersTableView.getItems().remove((Object)ml);
                this.worldographer.observableLayers.remove((Object)ml);
                this.mapUI().draw();
            }
        });
        HBox hbox = new HBox();
        hbox.getChildren().add((Object)addbutton);
        hbox.getChildren().add((Object)removebutton);
        borderpane.setTop((Node)hbox);
        borderpane.setBottom((Node)new Label("To rename a layer double-click a layer name then edit the text.\nRenaming default layers is not recommended."));
        return borderpane;
    }

    public void addToLayersTableView(int index, MapLayer ml) {
        this.layersTableView.getItems().add(index, (Object)ml);
    }
}

