/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;

public class LicGen {
    public static List<String> oldcodes(String[] args) {
        ArrayList<String> codes = new ArrayList<String>();
        if (args.length < 3) {
            System.out.println("Usage: LicenseGenerator id exp-date (where id is a 3 digit number and the exp-date form is yyyy-mm-dd) coa|hex|dun [+]");
            System.exit(0);
        }
        Calendar c = Calendar.getInstance();
        StringTokenizer st = new StringTokenizer(args[1], "-");
        int year = Integer.parseInt(st.nextToken());
        int month = Integer.parseInt(st.nextToken()) - 1;
        int date = Integer.parseInt(st.nextToken());
        c.set(year, month, date);
        year = c.get(1);
        int days = 0;
        for (int i = 2000; i < year; ++i) {
            days += 365;
            if (year % 4 != 0) continue;
            ++days;
        }
        String daystring = "" + (days += c.get(6));
        int count = 1;
        count = Integer.parseInt(args[3]);
        for (int i = 0; i < count; ++i) {
            int checksum;
            int six = (int)(Math.random() * 10.0);
            int seven = (int)(Math.random() * 10.0);
            int nine = (int)(Math.random() * 10.0);
            int ten = (int)(Math.random() * 10.0);
            int eleven = (int)(Math.random() * 10.0);
            if (count != 1) {
                eleven = i % 10;
            }
            int twelve = (int)(Math.random() * 10.0);
            if (count != 1) {
                twelve = i / 10;
            }
            if ((checksum = Integer.parseInt("" + args[0].charAt(0)) + Integer.parseInt("" + args[0].charAt(1)) + Integer.parseInt("" + daystring.charAt(0)) + Integer.parseInt("" + args[0].charAt(2)) + Integer.parseInt("" + daystring.charAt(1)) + six + seven + Integer.parseInt("" + daystring.charAt(2)) + nine + ten + eleven + twelve) > 90) {
                System.out.println("Checksum was over 90.  Try again.");
                System.exit(0);
            }
            int checksum2 = 0;
            if (args[2].equals("coa")) {
                checksum2 = checksum;
            } else if (args[2].equals("hex") || args[2].equals("dun")) {
                checksum2 = checksum + checksum % 10;
            } else {
                System.err.println("Invalid license type.");
                System.exit(-1);
            }
            String slicense = "" + args[0].charAt(0) + args[0].charAt(1) + daystring.charAt(0) + args[0].charAt(2) + daystring.charAt(1) + six + seven + daystring.charAt(2) + nine + ten + eleven + twelve + checksum + checksum2;
            if (args[2].equals("dun")) {
                slicense = "" + args[0].charAt(0) + args[0].charAt(1) + daystring.charAt(0) + args[0].charAt(2) + daystring.charAt(1) + six + seven + daystring.charAt(2) + checksum + checksum2 + nine + ten + eleven + twelve;
            }
            codes.add(slicense);
        }
        return codes;
    }

    public static boolean checkDates(String s) {
        if (s == null || s.length() < 8) {
            return false;
        }
        s = s.toUpperCase();
        s = s.replace("-", "");
        int value1 = 0;
        for (int i = 1; i < 4; ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int value2 = 0;
        for (int i = 5; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum2 = value2 % 36;
        long val1 = 0L;
        char c = s.charAt(0);
        val1 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        long val2 = 0L;
        c = s.charAt(4);
        val2 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        return val1 == (long)checksum1 && val2 == (long)checksum2;
    }

    public static boolean checkCityDates(String s) {
        s = s.toUpperCase();
        if ((s = s.replace("-", "")) == null || s.length() < 11) {
            return false;
        }
        if (s.charAt(10) != 'S') {
            return false;
        }
        int letters = 0;
        int zeros = 0;
        if (s.contains("00000")) {
            return false;
        }
        int value1 = 0;
        for (int i = 1; i < 5; ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                if (c == '0') {
                    ++zeros;
                }
                value1 += c - 48;
                continue;
            }
            ++letters;
            value1 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int value2 = 0;
        for (int i = 6; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                if (c == '0') {
                    ++zeros;
                }
                value2 += c - 48;
                continue;
            }
            ++letters;
            value2 += c - 65 + 10;
        }
        int checksum2 = value2 % 36;
        if (letters <= 1) {
            return false;
        }
        if (zeros >= 4) {
            return false;
        }
        long val1 = 0L;
        char c = s.charAt(0);
        val1 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        long val2 = 0L;
        c = s.charAt(5);
        val2 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        return val1 == (long)checksum1 && val2 == (long)checksum2;
    }

    public static boolean checkBattlematDates(String s) {
        s = s.toUpperCase();
        if ((s = s.replace("-", "")) == null || s.length() < 11) {
            return false;
        }
        if (s.charAt(10) != 'B') {
            return false;
        }
        int letters = 0;
        int zeros = 0;
        if (s.contains("00000")) {
            return false;
        }
        int value1 = 0;
        for (int i = 1; i < 5; ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                if (c == '0') {
                    ++zeros;
                }
                value1 += c - 48;
                continue;
            }
            ++letters;
            value1 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int value2 = 0;
        for (int i = 6; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                if (c == '0') {
                    ++zeros;
                }
                value2 += c - 48;
                continue;
            }
            ++letters;
            value2 += c - 65 + 10;
        }
        int checksum2 = value2 % 36;
        if (letters <= 1) {
            return false;
        }
        if (zeros >= 4) {
            return false;
        }
        long val1 = 0L;
        char c = s.charAt(0);
        val1 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        long val2 = 0L;
        c = s.charAt(5);
        val2 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        return val1 == (long)checksum1 && val2 == (long)checksum2;
    }

    public static boolean checkWorldDates(String s) {
        if (s == null || s.length() < 10) {
            return false;
        }
        s = s.toUpperCase();
        s = s.replace("-", "");
        int value1 = 0;
        for (int i = 1; i < 5; ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int value2 = 0;
        for (int i = 6; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum2 = value2 % 36;
        long val1 = 0L;
        char c = s.charAt(0);
        val1 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        long val2 = 0L;
        c = s.charAt(5);
        val2 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        return val1 == (long)checksum1 && val2 == (long)checksum2;
    }

    public static boolean check2025Dates(String s) {
        if ((s = s.substring(5)) == null || s.length() < 10) {
            return false;
        }
        s = s.toUpperCase();
        s = s.replace("-", "");
        int value1 = 0;
        for (int i = 1; i < 5; ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        int checksum1 = (value1 + 2) % 36;
        int value2 = 0;
        for (int i = 6; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum2 = (value2 + 5) % 36;
        long val1 = 0L;
        char c = s.charAt(0);
        val1 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        long val2 = 0L;
        c = s.charAt(5);
        val2 = c >= '0' && c <= '9' ? (long)(c - 48) : (long)(c - 65 + 10);
        return val1 == (long)checksum1 && val2 == (long)checksum2;
    }

    private static char convertToChar(int ran) {
        if (ran == 0) {
            return '0';
        }
        if (ran == 1) {
            return '1';
        }
        if (ran == 2) {
            return '2';
        }
        if (ran == 3) {
            return '3';
        }
        if (ran == 4) {
            return '4';
        }
        if (ran == 5) {
            return '5';
        }
        if (ran == 6) {
            return '6';
        }
        if (ran == 7) {
            return '7';
        }
        if (ran == 8) {
            return '8';
        }
        if (ran == 9) {
            return '9';
        }
        if (ran == 10) {
            return 'A';
        }
        if (ran == 11) {
            return 'B';
        }
        if (ran == 12) {
            return 'C';
        }
        if (ran == 13) {
            return 'D';
        }
        if (ran == 14) {
            return 'E';
        }
        if (ran == 15) {
            return 'F';
        }
        if (ran == 16) {
            return 'G';
        }
        if (ran == 17) {
            return 'H';
        }
        if (ran == 18) {
            return 'I';
        }
        if (ran == 19) {
            return 'J';
        }
        if (ran == 20) {
            return 'K';
        }
        if (ran == 21) {
            return 'L';
        }
        if (ran == 22) {
            return 'M';
        }
        if (ran == 23) {
            return 'N';
        }
        if (ran == 24) {
            return 'O';
        }
        if (ran == 25) {
            return 'P';
        }
        if (ran == 26) {
            return 'Q';
        }
        if (ran == 27) {
            return 'R';
        }
        if (ran == 28) {
            return 'S';
        }
        if (ran == 29) {
            return 'T';
        }
        if (ran == 30) {
            return 'U';
        }
        if (ran == 31) {
            return 'V';
        }
        if (ran == 32) {
            return 'W';
        }
        if (ran == 33) {
            return 'X';
        }
        if (ran == 34) {
            return 'Y';
        }
        if (ran == 35) {
            return 'Z';
        }
        throw new IllegalArgumentException("Problem parsing key");
    }

    public static String genKey(String seed1, String seed2) {
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s1.append(LicGen.convertToChar(ran));
        }
        s1.append(seed1);
        int value1 = 0;
        for (int i = 0; i < s1.length(); ++i) {
            char c = s1.charAt(i);
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s2.append(LicGen.convertToChar(ran));
        }
        s2.append(seed2);
        int value2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int checksum2 = value2 % 36;
        return LicGen.convertToChar(checksum1) + s1.toString() + "-" + LicGen.convertToChar(checksum2) + String.valueOf(s2);
    }

    public static String gen2025Key(String seed1, String seed2) {
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s1.append(LicGen.convertToChar(ran));
        }
        s1.append(seed1);
        int value1 = 0;
        for (int i = 0; i < s1.length(); ++i) {
            char c = s1.charAt(i);
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s2.append(LicGen.convertToChar(ran));
        }
        s2.append(seed2);
        int value2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum1 = (2 + value1) % 36;
        int checksum2 = (5 + value2) % 36;
        return "2025-" + LicGen.convertToChar(checksum1) + s1.toString() + "-" + LicGen.convertToChar(checksum2) + String.valueOf(s2);
    }

    public static String genWorldKey(String seed1, String seed2) {
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s1.append(LicGen.convertToChar(ran));
        }
        s1.append(seed1);
        int value1 = 0;
        for (int i = 0; i < s1.length(); ++i) {
            char c = s1.charAt(i);
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s2.append(LicGen.convertToChar(ran));
        }
        s2.append(seed2);
        int value2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int checksum2 = value2 % 36;
        return LicGen.convertToChar(checksum1) + s1.toString() + "-" + LicGen.convertToChar(checksum2) + String.valueOf(s2);
    }

    public static String genNewCityKey(String seed1, String seed2) {
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s1.append(LicGen.convertToChar(ran));
        }
        s1.append(seed1);
        int value1 = 0;
        for (int i = 0; i < s1.length(); ++i) {
            char c = s1.charAt(i);
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s2.append(LicGen.convertToChar(ran));
        }
        s2.append(seed2).append("S");
        int value2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int checksum2 = value2 % 36;
        return LicGen.convertToChar(checksum1) + s1.toString() + "-" + LicGen.convertToChar(checksum2) + s2.substring(0, s2.length() - 1) + "-S";
    }

    public static String genNewBattlematKey(String seed1, String seed2) {
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s1.append(LicGen.convertToChar(ran));
        }
        s1.append(seed1);
        int value1 = 0;
        for (int i = 0; i < s1.length(); ++i) {
            char c = s1.charAt(i);
            if (c >= '0' && c <= '9') {
                value1 += c - 48;
                continue;
            }
            value1 += c - 65 + 10;
        }
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int ran = (int)(Math.random() * 36.0);
            s2.append(LicGen.convertToChar(ran));
        }
        s2.append(seed2).append("B");
        int value2 = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                value2 += c - 48;
                continue;
            }
            value2 += c - 65 + 10;
        }
        int checksum1 = value1 % 36;
        int checksum2 = value2 % 36;
        return LicGen.convertToChar(checksum1) + s1.toString() + "-" + LicGen.convertToChar(checksum2) + s2.substring(0, s2.length() - 1) + "-B";
    }

    public static void main(String[] args) {
        switch (args[0]) {
            case "all": {
                ArrayList<CallSite> citycodes = new ArrayList<CallSite>();
                for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
                    citycodes.add((CallSite)((Object)("Cityographer#:" + LicGen.genKey(args[2], args[3]))));
                }
                String[] dunargs = new String[]{args[4], args[5], "dun", args[1]};
                List<String> duncodes = LicGen.oldcodes(dunargs);
                String[] hexargs = new String[]{args[6], args[7], "hex", args[1]};
                List<String> hexcodes = LicGen.oldcodes(hexargs);
                for (int i = 0; i < citycodes.size(); ++i) {
                    String new2025code;
                    String newbattlematcode;
                    String newcitycode;
                    String newworldcode = LicGen.genWorldKey(args[8], args[9]);
                    if (!LicGen.checkWorldDates(newworldcode)) {
                        System.out.println("failed:" + newworldcode);
                        System.exit(-1);
                    }
                    if (!LicGen.checkCityDates(newcitycode = LicGen.genNewCityKey(args[10], args[11]))) {
                        System.out.println("failed:" + newcitycode);
                        System.exit(-1);
                    }
                    if (!LicGen.checkBattlematDates(newbattlematcode = LicGen.genNewBattlematKey(args[12], args[13]))) {
                        System.out.println("failed:" + newbattlematcode);
                        System.exit(-1);
                    }
                    if (!LicGen.check2025Dates(new2025code = LicGen.gen2025Key(args[8], args[13]))) {
                        System.out.println("failed:" + new2025code);
                        System.exit(-1);
                    } else {
                        System.out.print("Worldographer 2025:" + new2025code);
                    }
                    System.out.print(" Worldographer/Hex2:" + newworldcode + " Settlements:" + newcitycode + " Battlemats:" + newbattlematcode);
                    System.out.println(" Codes for old versions:" + (String)citycodes.get(i) + " Dungeonographer#:" + duncodes.get(i) + " Hexographer#:" + hexcodes.get(i));
                }
                break;
            }
            case "2025": {
                int count = Integer.parseInt(args[1]);
                for (int i = 0; i < count; ++i) {
                    String new2025code = LicGen.gen2025Key(args[2], args[3]);
                    if (!LicGen.check2025Dates(new2025code)) {
                        System.out.println("failed:" + new2025code);
                        System.exit(-1);
                        continue;
                    }
                    System.out.println(new2025code);
                }
                break;
            }
            case "hex12": {
                String[] hexargs = new String[]{args[2], args[3], "hex", args[1]};
                List<String> hexcodes = LicGen.oldcodes(hexargs);
                for (String hexcode : hexcodes) {
                    System.out.println("Hexographer#:" + hexcode + " Worldographer#:" + LicGen.genWorldKey(args[4], args[5]));
                }
                break;
            }
            case "city": {
                if (args.length <= 0) break;
                for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
                    System.out.println("New Worldographer City/village code:" + LicGen.genNewCityKey(args[4], args[5]) + " Old Cityographer code:" + LicGen.genKey(args[2], args[3]));
                }
                break;
            }
            case "dungeon": {
                String[] dunargs = new String[]{args[2], args[3], "dun", args[1]};
                List<String> duncodes = LicGen.oldcodes(dunargs);
                if (args.length <= 0) break;
                for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
                    System.out.println("New Worldographer Dungeon/Battlemat code:" + LicGen.genNewBattlematKey(args[4], args[5]) + " Old Dungeonographer code:" + duncodes.get(i));
                }
                break;
            }
            case "newcity": {
                if (args.length <= 0) break;
                for (int i = 0; i < Integer.parseInt(args[1]); ++i) {
                    String s = LicGen.genNewCityKey(args[2], args[3]);
                    System.out.println("You're receiving this message because you bought Cityographer on or after June 1st.\r\nAs part of that purchase is the key to the new City/Town functionality in Worldographer.  Although it is still beta, this essentially replaces Cityographer.  The biggest advantages are a user interface to configure which buildings are used to auto-generate a map and the details it generates for each building (who lives/works there, what they have for sale), easier to add new buildings to the system, and more controls for generating a city/town/village (background and road color/textures, different street networks, different vegetation types, etc.). It also allows you to open a city map in a new tab when you click on the note for a city (if you set it up using the \"change file\" button on the note dialog).\r\nWe're just starting more detailed documentation, but if you know Cityographer and Worldographer it isn't too much different.  We do have a couple of videos going over the details.  See them in our channel here (please subscribe!): https://www.youtube.com/channel/UCORQgCvPuOnaDaMSJnUrXfQ/videos\r\nEnter a city/village license using the option on the File menu when Worldographer starts. (Make sure you update to v 1.13 or later.)\r\nHERE IS YOUR CODE: " + s + "\r\nAnd two other things:\r\n* If you aren't on our newsletter and want updates on what we're doing including updates to the software, join our mailing list using the form on the bottom right of this page: http://inkwellideas.com/posts/\r\n* And if you don't know about our Patreon, for just a couple dollars a month it gives you 15+ new icons for each of up to 4 different map icon sets & it supports continued development: https://www.patreon.com/InkwellIdeas\r\n");
                }
                break;
            }
            default: {
                if (Integer.parseInt(args[0]) < 0) {
                    System.out.println("result:" + LicGen.checkWorldDates(args[1]));
                }
                if (args.length <= 0) break;
                for (int i = 0; i < Integer.parseInt(args[0]); ++i) {
                    System.out.println("Thank you for your support.\nHere is your Hexographer 2 code. Remember this is still beta and fixes will be coming often for a little while. Go to Worldographer.com/download to download. License#:" + LicGen.genWorldKey(args[1], args[2]) + "\nThanks again!\nJoe\n\n");
                }
            }
        }
    }
}

