/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.util.html.Attributes;

public class ResolvedLink {
    private final LinkType myLinkType;
    private final String myUrl;
    private final LinkStatus myStatus;
    private Attributes myAttributes;

    public ResolvedLink(LinkType linkType, CharSequence url) {
        this(linkType, url, null, LinkStatus.UNKNOWN);
    }

    public ResolvedLink(LinkType linkType, CharSequence url, Attributes attributes) {
        this(linkType, url, attributes, LinkStatus.UNKNOWN);
    }

    public Attributes getAttributes() {
        return this.myAttributes;
    }

    public Attributes getNonNullAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new Attributes();
        }
        return this.myAttributes;
    }

    public ResolvedLink(LinkType linkType, CharSequence url, Attributes attributes, LinkStatus status) {
        this.myLinkType = linkType;
        this.myUrl = String.valueOf(url);
        this.myStatus = status;
        if (attributes != null) {
            this.getNonNullAttributes().addValues(attributes);
        }
    }

    public ResolvedLink withLinkType(LinkType linkType) {
        return linkType == this.myLinkType ? this : new ResolvedLink(linkType, this.myUrl, this.myAttributes, this.myStatus);
    }

    public ResolvedLink withStatus(LinkStatus status) {
        return status == this.myStatus ? this : new ResolvedLink(this.myLinkType, this.myUrl, this.myAttributes, status);
    }

    public LinkType getLinkType() {
        return this.myLinkType;
    }

    public LinkStatus getStatus() {
        return this.myStatus;
    }

    public ResolvedLink withUrl(CharSequence url) {
        String useUrl = String.valueOf(url);
        return this.myUrl.equals(useUrl) ? this : new ResolvedLink(this.myLinkType, useUrl, this.myAttributes, this.myStatus);
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getPageRef() {
        int pos = this.myUrl.indexOf(35);
        if (pos < 0) {
            return this.myUrl;
        }
        return this.myUrl.substring(0, pos);
    }

    public String getAnchorRef() {
        int pos = this.myUrl.indexOf(35);
        if (pos < 0) {
            return null;
        }
        return this.myUrl.substring(pos + 1);
    }

    public ResolvedLink withTitle(CharSequence title) {
        String haveTitle;
        String string = haveTitle = this.myAttributes == null ? null : this.myAttributes.getValue("title");
        if (title == haveTitle || haveTitle != null && haveTitle.equals(title)) {
            return this;
        }
        Attributes attributes = new Attributes(this.myAttributes);
        if (title == null) {
            attributes.remove("title");
            if (attributes.isEmpty()) {
                attributes = null;
            }
        } else {
            attributes.replaceValue("title", title);
        }
        return new ResolvedLink(this.myLinkType, this.myUrl, attributes, this.myStatus);
    }

    public String getTitle() {
        return this.myAttributes == null ? null : this.myAttributes.getValue("title");
    }

    public ResolvedLink withTarget(CharSequence target) {
        String haveTarget;
        String string = haveTarget = this.myAttributes == null ? null : this.myAttributes.getValue("target");
        if (target == haveTarget || haveTarget != null && haveTarget.equals(target)) {
            return this;
        }
        Attributes attributes = new Attributes(this.myAttributes);
        if (target == null) {
            attributes.remove("target");
            if (attributes.isEmpty()) {
                attributes = null;
            }
        } else {
            attributes.replaceValue("target", target);
        }
        return new ResolvedLink(this.myLinkType, this.myUrl, attributes, this.myStatus);
    }

    public String getTarget() {
        return this.myAttributes == null ? null : this.myAttributes.getValue("target");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedLink)) {
            return false;
        }
        ResolvedLink link = (ResolvedLink)o;
        if (!this.myLinkType.equals(link.myLinkType)) {
            return false;
        }
        if (!this.myUrl.equals(link.myUrl)) {
            return false;
        }
        return this.myStatus.equals(link.myStatus);
    }

    public int hashCode() {
        int result = this.myLinkType.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myStatus.hashCode();
        return result;
    }
}

