/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BreadcrumbsSkin;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;
import org.jetbrains.annotations.Nullable;

public class Breadcrumbs<T>
extends Control {
    protected static final String DEFAULT_STYLE_CLASS = "breadcrumbs";
    protected final Callback<BreadCrumbItem<T>, ButtonBase> defaultCrumbNodeFactory = item -> new Hyperlink(item.getStringValue());
    protected final Callback<BreadCrumbItem<T>, ? extends Node> defaultDividerFactory = item -> item != null && !item.isLast() ? new Label("/") : null;
    protected final ObjectProperty<BreadCrumbItem<T>> selectedCrumb = new SimpleObjectProperty((Object)this, "selectedCrumb");
    protected final BooleanProperty autoNavigation = new SimpleBooleanProperty((Object)this, "autoNavigationEnabled", true);
    protected final ObjectProperty<Callback<BreadCrumbItem<T>, ButtonBase>> crumbFactory = new SimpleObjectProperty((Object)this, "crumbFactory");
    protected final ObjectProperty<Callback<BreadCrumbItem<T>, ? extends Node>> dividerFactory = new SimpleObjectProperty((Object)this, "dividerFactory");
    protected final ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbAction = new ObjectPropertyBase<EventHandler<BreadCrumbActionEvent<T>>>(){

        protected void invalidated() {
            Breadcrumbs.this.setEventHandler(BreadCrumbActionEvent.CRUMB_ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return Breadcrumbs.this;
        }

        public String getName() {
            return "onCrumbAction";
        }
    };

    public Breadcrumbs() {
        this(null);
    }

    public Breadcrumbs(@Nullable BreadCrumbItem<T> selectedCrumb) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPrefWidth(-1.0);
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.setPrefHeight(-1.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setSelectedCrumb(selectedCrumb);
        this.setCrumbFactory(this.defaultCrumbNodeFactory);
        this.setDividerFactory(this.defaultDividerFactory);
    }

    protected Skin<?> createDefaultSkin() {
        return new BreadcrumbsSkin(this);
    }

    @SafeVarargs
    public static <T> BreadCrumbItem<T> buildTreeModel(T ... crumbs) {
        BreadCrumbItem<T> subRoot = null;
        for (T crumb : crumbs) {
            BreadCrumbItem<T> currentNode = new BreadCrumbItem<T>(crumb);
            if (subRoot != null) {
                subRoot.getChildren().add(currentNode);
            }
            subRoot = currentNode;
        }
        return subRoot;
    }

    public final ObjectProperty<BreadCrumbItem<T>> selectedCrumbProperty() {
        return this.selectedCrumb;
    }

    public final BreadCrumbItem<T> getSelectedCrumb() {
        return (BreadCrumbItem)((Object)this.selectedCrumb.get());
    }

    public final void setSelectedCrumb(BreadCrumbItem<T> selectedCrumb) {
        this.selectedCrumb.set(selectedCrumb);
    }

    public final BooleanProperty autoNavigationEnabledProperty() {
        return this.autoNavigation;
    }

    public final boolean isAutoNavigationEnabled() {
        return this.autoNavigation.get();
    }

    public final void setAutoNavigationEnabled(boolean enabled) {
        this.autoNavigation.set(enabled);
    }

    public final ObjectProperty<Callback<BreadCrumbItem<T>, ButtonBase>> crumbFactoryProperty() {
        return this.crumbFactory;
    }

    public final void setCrumbFactory(Callback<BreadCrumbItem<T>, ButtonBase> value) {
        if (value == null) {
            value = this.defaultCrumbNodeFactory;
        }
        this.crumbFactoryProperty().set(value);
    }

    public final Callback<BreadCrumbItem<T>, ButtonBase> getCrumbFactory() {
        return (Callback)this.crumbFactory.get();
    }

    public final ObjectProperty<Callback<BreadCrumbItem<T>, ? extends Node>> dividerFactoryProperty() {
        return this.dividerFactory;
    }

    public final void setDividerFactory(Callback<BreadCrumbItem<T>, ? extends Node> value) {
        if (value == null) {
            value = this.defaultDividerFactory;
        }
        this.dividerFactoryProperty().set(value);
    }

    public final Callback<BreadCrumbItem<T>, ? extends Node> getDividerFactory() {
        return (Callback)this.dividerFactory.get();
    }

    public final ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbActionProperty() {
        return this.onCrumbAction;
    }

    public final void setOnCrumbAction(EventHandler<BreadCrumbActionEvent<T>> value) {
        this.onCrumbActionProperty().set(value);
    }

    public final EventHandler<BreadCrumbActionEvent<T>> getOnCrumbAction() {
        return (EventHandler)this.onCrumbActionProperty().get();
    }

    public static class BreadCrumbItem<T>
    extends TreeItem<T> {
        protected boolean first;
        protected boolean last;

        public BreadCrumbItem(@Nullable T value) {
            super(value);
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isLast() {
            return this.last;
        }

        protected void setFirst(boolean first) {
            this.first = first;
        }

        protected void setLast(boolean last) {
            this.last = last;
        }

        protected String getStringValue() {
            return this.getValue() != null ? this.getValue().toString() : "";
        }
    }

    public static class BreadCrumbActionEvent<T>
    extends Event {
        public static final EventType<BreadCrumbActionEvent<?>> CRUMB_ACTION = new EventType("CRUMB_ACTION" + UUID.randomUUID());
        private final BreadCrumbItem<T> selectedCrumb;

        public BreadCrumbActionEvent(BreadCrumbItem<T> selectedCrumb) {
            super(CRUMB_ACTION);
            this.selectedCrumb = selectedCrumb;
        }

        public BreadCrumbItem<T> getSelectedCrumb() {
            return this.selectedCrumb;
        }
    }
}

