/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorBase;
import atlantafx.base.controls.Calendar;
import atlantafx.base.controls.CalendarSkin;
import atlantafx.base.util.PlatformUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class CalendarBehavior
extends BehaviorBase<Calendar, CalendarSkin> {
    public CalendarBehavior(Calendar control, CalendarSkin skin) {
        super(control, skin);
    }

    public void onKeyPressed(KeyEvent e) {
        ((CalendarSkin)((Object)this.getSkin())).rememberFocusedDayCell();
        if (e.getEventType() == KeyEvent.KEY_PRESSED) {
            switch (e.getCode()) {
                case HOME: {
                    ((CalendarSkin)((Object)this.getSkin())).goToDate(LocalDate.now(ZoneId.systemDefault()), true);
                    e.consume();
                    break;
                }
                case PAGE_UP: {
                    if (PlatformUtils.isMac() && e.isMetaDown() || !PlatformUtils.isMac() && e.isControlDown()) {
                        if (((CalendarSkin)((Object)this.getSkin())).canGoYearForward()) {
                            ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.YEARS, true);
                        }
                    } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthForward()) {
                        ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.MONTHS, true);
                    }
                    e.consume();
                    break;
                }
                case PAGE_DOWN: {
                    if (PlatformUtils.isMac() && e.isMetaDown() || !PlatformUtils.isMac() && e.isControlDown()) {
                        if (((CalendarSkin)((Object)this.getSkin())).canGoYearBack()) {
                            ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.YEARS, true);
                        }
                    } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthBack()) {
                        ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.MONTHS, true);
                    }
                    e.consume();
                }
            }
            ((CalendarSkin)((Object)this.getSkin())).rememberFocusedDayCell();
        }
        if (e.getCode() != KeyCode.ESCAPE) {
            e.consume();
        }
    }

    public void moveForward(MouseEvent e) {
        if (PlatformUtils.isMac() && e.isMetaDown() || !PlatformUtils.isMac() && e.isControlDown()) {
            if (((CalendarSkin)((Object)this.getSkin())).canGoYearForward()) {
                ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.YEARS, true);
            }
        } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthForward()) {
            ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.MONTHS, true);
        }
        e.consume();
    }

    public void moveBackward(MouseEvent e) {
        if (PlatformUtils.isMac() && e.isMetaDown() || !PlatformUtils.isMac() && e.isControlDown()) {
            if (((CalendarSkin)((Object)this.getSkin())).canGoYearBack()) {
                ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.YEARS, true);
            }
        } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthBack()) {
            ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.MONTHS, true);
        }
        e.consume();
    }
}

