/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ModalPaneSkin;
import atlantafx.base.util.Animations;
import java.util.Objects;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class ModalPane
extends Control {
    public static final int Z_FRONT = -10;
    public static final int Z_BACK = 10;
    public static final Duration DEFAULT_DURATION_IN = Duration.millis((double)200.0);
    public static final Duration DEFAULT_DURATION_OUT = Duration.millis((double)100.0);
    private final int topViewOrder;
    protected final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content", null);
    protected final BooleanProperty display = new SimpleBooleanProperty((Object)this, "display", false);
    protected final ObjectProperty<Pos> alignment = new SimpleObjectProperty((Object)this, "alignment", (Object)Pos.CENTER);
    protected final ObjectProperty<Function<Node, Animation>> inTransitionFactory = new SimpleObjectProperty((Object)this, "inTransitionFactory", node -> Animations.zoomIn(node, DEFAULT_DURATION_IN));
    protected final ObjectProperty<Function<Node, Animation>> outTransitionFactory = new SimpleObjectProperty((Object)this, "outTransitionFactory", node -> Animations.zoomOut(node, DEFAULT_DURATION_OUT));
    protected final BooleanProperty persistent = new SimpleBooleanProperty((Object)this, "persistent", false);

    public ModalPane() {
        this(-10);
    }

    public ModalPane(@NamedArg(value="topViewOrder") int topViewOrder) {
        this.topViewOrder = topViewOrder;
    }

    protected Skin<?> createDefaultSkin() {
        return new ModalPaneSkin(this);
    }

    public int getTopViewOrder() {
        return this.topViewOrder;
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public void setContent(Node node) {
        this.content.set((Object)node);
    }

    public BooleanProperty displayProperty() {
        return this.display;
    }

    public boolean isDisplay() {
        return this.display.get();
    }

    public void setDisplay(boolean display) {
        this.display.set(display);
    }

    public ObjectProperty<Pos> alignmentProperty() {
        return this.alignment;
    }

    public Pos getAlignment() {
        return (Pos)this.alignment.get();
    }

    public void setAlignment(Pos alignment) {
        this.alignment.set((Object)alignment);
    }

    public ObjectProperty<Function<Node, Animation>> inTransitionFactoryProperty() {
        return this.inTransitionFactory;
    }

    public Function<Node, Animation> getInTransitionFactory() {
        return (Function)this.inTransitionFactory.get();
    }

    public void setInTransitionFactory(Function<Node, Animation> inTransitionFactory) {
        this.inTransitionFactory.set(inTransitionFactory);
    }

    public ObjectProperty<Function<Node, Animation>> outTransitionFactoryProperty() {
        return this.outTransitionFactory;
    }

    public Function<Node, Animation> getOutTransitionFactory() {
        return (Function)this.outTransitionFactory.get();
    }

    public void setOutTransitionFactory(Function<Node, Animation> outTransitionFactory) {
        this.outTransitionFactory.set(outTransitionFactory);
    }

    public BooleanProperty persistentProperty() {
        return this.persistent;
    }

    public boolean getPersistent() {
        return this.persistent.get();
    }

    public void setPersistent(boolean persistent) {
        this.persistent.set(persistent);
    }

    public void show(Node node) {
        Objects.requireNonNull(this.content, "Content cannot be null.");
        this.setContent(node);
        this.setDisplay(true);
    }

    public void hide(boolean clear) {
        this.setDisplay(false);
        if (clear) {
            this.setContent(null);
        }
    }

    public void hide() {
        this.hide(false);
    }

    public void usePredefinedTransitionFactories(@Nullable Side side) {
        this.usePredefinedTransitionFactories(side, DEFAULT_DURATION_IN, DEFAULT_DURATION_OUT);
    }

    public void usePredefinedTransitionFactories(@Nullable Side side, @Nullable Duration inDuration, @Nullable Duration outDuration) {
        Duration durIn = Objects.requireNonNullElse(inDuration, DEFAULT_DURATION_IN);
        Duration durOut = Objects.requireNonNullElse(outDuration, DEFAULT_DURATION_OUT);
        if (side == null) {
            this.setInTransitionFactory(node -> Animations.zoomIn(node, durIn));
            this.setOutTransitionFactory(node -> Animations.fadeOut(node, durOut));
        } else {
            switch (side) {
                case TOP: {
                    this.setInTransitionFactory(node -> Animations.slideInDown(node, durIn));
                    this.setOutTransitionFactory(node -> Animations.slideOutUp(node, durOut));
                    break;
                }
                case RIGHT: {
                    this.setInTransitionFactory(node -> Animations.slideInRight(node, durIn));
                    this.setOutTransitionFactory(node -> Animations.slideOutRight(node, durOut));
                    break;
                }
                case BOTTOM: {
                    this.setInTransitionFactory(node -> Animations.slideInUp(node, durIn));
                    this.setOutTransitionFactory(node -> Animations.slideOutDown(node, durOut));
                    break;
                }
                case LEFT: {
                    this.setInTransitionFactory(node -> Animations.slideInLeft(node, durIn));
                    this.setOutTransitionFactory(node -> Animations.slideOutLeft(node, durOut));
                }
            }
        }
    }
}

