/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.theme;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.css.Stylesheet;

public class ThemeCompiler {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("You must provide the source directory path");
            }
            if (args.length > 1) {
                throw new IllegalArgumentException("Unexpected arguments were found: " + Arrays.toString(Arrays.copyOfRange(args, 1, args.length)));
            }
            Path dir = Paths.get(args[0], new String[0]);
            new ThemeCompiler().convertToBinary(dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void convertToBinary(Path dir) throws IOException {
        if (dir == null || !Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid directory: " + dir);
        }
        try (Stream<Path> stream = Files.list(dir);){
            stream.filter(f -> f.toString().endsWith(".css")).forEach(f -> {
                try {
                    this.convertToBinary((Path)f, f.resolveSibling(this.getFilename((Path)f) + ".bss"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public void convertToBinary(Path in, Path out) throws IOException {
        if (in == null || out == null) {
            throw new IllegalArgumentException("Both input and output files must be specified.");
        }
        if (in.equals(out)) {
            throw new IllegalArgumentException("Input file and output file cannot be the same.");
        }
        Stylesheet.convertToBinary((File)in.toFile(), (File)out.toFile());
    }

    private String getFilename(Path f) {
        String name = f.getFileName().toString();
        return name.substring(0, name.lastIndexOf(46));
    }
}

