/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.map.MapShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class Corridor {
    public static void makeCorridor(List<MapShape> shapes, String walltexture, String floortexture, MapLayer shapelayer, double[] ... wallpointlists) {
        ArrayList<double[]> ptlists = new ArrayList<double[]>(Arrays.asList(wallpointlists));
        Corridor.makeCorridor(shapes, walltexture, floortexture, shapelayer, ptlists);
    }

    public static void makeCorridor(List<MapShape> shapes, String walltexture, String floortexture, MapLayer shapelayer, List<double[]> wallpointlists) {
        Object object;
        ArrayList<Double> allpts = new ArrayList<Double>();
        for (double[] pts : wallpointlists) {
            object = pts;
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                Double pt = object[i];
                allpts.add(pt * 300.0);
            }
        }
        Polygon floor = new Polygon();
        floor.getPoints().addAll(allpts);
        MapShape floorms = BattlematDataGenerator.makeRoom((Shape)floor, null, floortexture, shapelayer, "room");
        shapes.add(floorms);
        object = wallpointlists.iterator();
        while (object.hasNext()) {
            double[] wallpoints = (double[])object.next();
            Path wall = new Path();
            for (int i = 0; i < wallpoints.length; i += 2) {
                if (i == 0) {
                    wall.getElements().add((Object)new MoveTo(wallpoints[i] * 300.0, wallpoints[i + 1] * 300.0));
                    continue;
                }
                wall.getElements().add((Object)new LineTo(wallpoints[i] * 300.0, wallpoints[i + 1] * 300.0));
            }
            MapShape wallms = BattlematDataGenerator.makeRoom((Shape)wall, walltexture, null, 0.22, shapelayer, "room");
            shapes.add(wallms);
        }
    }

    public static void makeCorridorRotatable(List<MapShape> shapes, String walltexture, String floortexture, double offsetx, double offsety, int rotate, MapLayer shapelayer, List<double[]> wallpointlists) {
        Corridor.makeCorridorRotatable(shapes, walltexture, floortexture, offsetx, offsety, rotate, shapelayer, wallpointlists, 20);
    }

    public static void makeCorridorRotatable(List<MapShape> shapes, String walltexture, String floortexture, double offsetx, double offsety, int rotate, MapLayer shapelayer, List<double[]> wallpointlists, int sectionSize) {
        ArrayList<Double> allpts = new ArrayList<Double>();
        for (double[] pts : wallpointlists) {
            for (int i = 0; i < pts.length; i += 2) {
                if (rotate == 90) {
                    temp = pts[i];
                    pts[i] = (double)sectionSize - pts[i + 1];
                    pts[i + 1] = temp;
                } else if (rotate == 180) {
                    pts[i] = (double)sectionSize - pts[i];
                    pts[i + 1] = (double)sectionSize - pts[i + 1];
                } else if (rotate == 270) {
                    temp = pts[i];
                    pts[i] = pts[i + 1];
                    pts[i + 1] = (double)sectionSize - temp;
                }
                allpts.add((offsetx + pts[i]) * 300.0);
                allpts.add((offsety + pts[i + 1]) * 300.0);
            }
        }
        Polygon floor = new Polygon();
        floor.getPoints().addAll(allpts);
        MapShape floorms = BattlematDataGenerator.makeRoom((Shape)floor, null, floortexture, shapelayer, "room");
        shapes.add(floorms);
        for (double[] wallpoints : wallpointlists) {
            Path wall = new Path();
            for (int i = 0; i < wallpoints.length; i += 2) {
                if (i == 0) {
                    wall.getElements().add((Object)new MoveTo((offsetx + wallpoints[i]) * 300.0, (offsety + wallpoints[i + 1]) * 300.0));
                    continue;
                }
                wall.getElements().add((Object)new LineTo((offsetx + wallpoints[i]) * 300.0, (offsety + wallpoints[i + 1]) * 300.0));
            }
            MapShape wallms = BattlematDataGenerator.makeRoom((Shape)wall, walltexture, null, 0.22, shapelayer, "room");
            shapes.add(wallms);
        }
    }

    public static void makeCorridorRotatable(List<MapShape> shapes, String walltexture, String floortexture, double offsetx, double offsety, int rotate, MapLayer shapelayer, double[] ... wallpointlists) {
        ArrayList<double[]> list = new ArrayList<double[]>(Arrays.asList(wallpointlists));
        Corridor.makeCorridorRotatable(shapes, walltexture, floortexture, offsetx, offsety, rotate, shapelayer, list);
    }
}

