/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.generator.battlemat.MakeHouse;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TextureType;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class MakeInn {
    public static Terrain[][] generateInn(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer) {
        double guestroombottom;
        Polygon guestroompoly;
        double i;
        ImagePattern rockdktexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Rock Dark").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        String mainfloor = "Cobblestone Light";
        double mf = Math.random();
        if (mf < 0.2) {
            mainfloor = "Cobblestone Dark";
        } else if (mf < 0.35) {
            mainfloor = "Cobblestone";
        } else if (mf < 0.5) {
            mainfloor = "Wood";
        } else if (mf < 0.65) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.85) {
            mainfloor = "Wood Light";
        }
        String kitchenfloor = "Cobblestone Light";
        double kf = Math.random();
        if (kf < 0.33) {
            kitchenfloor = "Cobblestone Dark";
        } else if (kf < 0.66) {
            kitchenfloor = "Cobblestone";
        }
        String topfloor = "Wood Light";
        double tf = Math.random();
        if (tf < 0.33) {
            topfloor = "Wood";
        } else if (tf < 0.66) {
            topfloor = "Wood Dark";
        }
        Polygon kitchenpoly = new Polygon();
        double kitchenleft = 3.0;
        double kitchentop = 9.0;
        double kitchenright = 9.0;
        double kitchenbottom = 15.0;
        if (Math.random() < 0.5) {
            kitchenbottom = 13.0;
        }
        Polygon commonroompoly = new Polygon();
        double commonroomtop = kitchentop - 6.0;
        double commonroombottom = kitchentop - 2.0;
        MakeInn.makeInnCommonRoom(shapes, features, "Rock Dark", mainfloor, commonroompoly, kitchenleft, commonroomtop, kitchenright, commonroombottom, ml, shapelayer);
        Polygon ownerroompoly = new Polygon();
        double ownerroomtop = kitchentop - 2.0;
        double ownerroomright = kitchenleft + 3.0;
        MakeInn.makeInnOwnerRoom(shapes, features, "Rock Dark", mainfloor, ownerroompoly, kitchenleft, ownerroomtop, ownerroomright, kitchentop, ml, shapelayer, furniture);
        MakeInn.makeInnStairsDownMainFloor(shapes, features, kitchentop, "Rock Dark", mainfloor, ownerroomright, ml, shapelayer);
        MakeInn.makeInnStairsUpMainFloor(shapes, features, kitchentop, "Rock Dark", mainfloor, ownerroomright, ml, shapelayer);
        Polygon mainroompoly = new Polygon();
        double mainroomtop = kitchentop - 6.0;
        double mainroomright = kitchenright + 4.0 + (double)((int)(Math.random() * 3.0));
        double mainroombottom = kitchenbottom;
        MakeInn.makeInnMainRoom(shapes, features, kitchentop, "Rock Dark", mainfloor, commonroombottom, mainroompoly, kitchenright, mainroomtop, mainroomright, mainroombottom, ml, shapelayer, furniture);
        MakeInn.makeInnKitchen(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", kitchenfloor, ml, shapelayer, furniture);
        Feature maindoor = new Feature("Battlemat/Door Double Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        maindoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(mainroomright * 300.0, ((mainroombottom - mainroomtop) / 2.0 + mainroomtop) * 300.0));
        features.add(maindoor);
        double topfloorleft = mainroomright + 4.0;
        double topfloorright = topfloorleft + 8.0;
        double topfloorbottom = kitchenbottom;
        MapShape forestFloor = BattlematDataGenerator.makeRoom(0.0, 0.0, topfloorleft - 2.0, topfloorbottom + 4.0, "Rock Dark", 0.0, "Forest Floor", shapelayer);
        shapes.add(0, forestFloor);
        MapShape sky = BattlematDataGenerator.makeRoom(topfloorleft - 2.0, 0.0, topfloorright + 2.0, topfloorbottom + 4.0, "Rock Dark", 0.0, Color.LIGHTBLUE, shapelayer);
        shapes.add(sky);
        if ((double)t.length < topfloorright + 2.0 || (double)t[0].length < topfloorbottom + 4.0) {
            Terrain[][] t2 = new Terrain[Math.max((int)(topfloorright + 2.0), t.length)][Math.max((int)(topfloorbottom + 2.0), t[0].length)];
            for (int i2 = 0; i2 < t2.length; ++i2) {
                for (int j = 0; j < t2[i2].length; ++j) {
                    t2[i2][j] = new Terrain("Blank", false);
                }
            }
            t = t2;
        }
        MapShape ms = BattlematDataGenerator.makeRoom(topfloorleft, commonroomtop, topfloorright, topfloorbottom, "Rock Dark", 0.15, topfloor, shapelayer);
        shapes.add(ms);
        Feature stairsdown = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 180.0, null, "stairs", false, false, false, false, ml);
        stairsdown.setLocation(ViewLevel.BATTLEMAT, new Point2D((topfloorleft + 4.0) * 300.0, (ownerroomtop + 0.5) * 300.0));
        features.add(stairsdown);
        MakeInn.makeWall(shapes, "Rock Dark", rockdktexture, shapelayer, (topfloorleft + 3.0) * 300.0, ownerroomtop * 300.0, (topfloorleft + 5.0) * 300.0, ownerroomtop * 300.0, (topfloorleft + 5.0) * 300.0, (ownerroomtop + 1.0) * 300.0, (topfloorleft + 3.0) * 300.0, (ownerroomtop + 1.0) * 300.0);
        int modthree = (int)(topfloorbottom - commonroomtop) % 3;
        for (i = commonroomtop; i < topfloorbottom; i += 3.0) {
            guestroompoly = new Polygon();
            double guestroomtop = i;
            double guestroomright = topfloorleft + 2.0;
            guestroombottom = i + 3.0;
            if ((modthree == 1 || modthree == 2) && i == commonroomtop) {
                guestroombottom = i + 2.0;
                i -= 1.0;
            }
            if (modthree == 1 && i >= topfloorbottom - 2.0) {
                guestroombottom = i + 2.0;
                i -= 1.0;
            }
            MakeInn.makeInnGuestRoom(shapes, features, "Rock Dark", topfloor, guestroompoly, topfloorleft, guestroomtop, guestroomright, guestroombottom, ml, shapelayer);
        }
        for (i = commonroomtop; i < topfloorbottom; i += 3.0) {
            guestroompoly = new Polygon();
            double guestroomleft = topfloorright - 2.0;
            double guestroomtop = i;
            guestroombottom = i + 3.0;
            if ((modthree == 1 || modthree == 2) && i == commonroomtop) {
                guestroombottom = i + 2.0;
                i -= 1.0;
            }
            if (modthree == 1 && i >= topfloorbottom - 2.0) {
                guestroombottom = i + 2.0;
                i -= 1.0;
            }
            MakeInn.makeInnGuestRoomReverse(shapes, features, "Rock Dark", topfloor, guestroompoly, guestroomleft, guestroomtop, topfloorright, guestroombottom, ml, shapelayer);
        }
        MakeInn.makeInnGuestRoomLarge(true, shapes, features, "Rock Dark", topfloor, new Polygon(), topfloorleft + 3.0, commonroomtop, topfloorleft + 5.0, commonroomtop + 4.0, ml, shapelayer);
        MakeInn.makeInnGuestRoomLarge(false, shapes, features, "Rock Dark", topfloor, new Polygon(), topfloorleft + 3.0, topfloorbottom - 4.0, topfloorleft + 5.0, topfloorbottom, ml, shapelayer);
        if (modthree == 0) {
            MakeInn.makeInnStorageRoom(shapes, features, topfloor, ownerroomtop, topfloorleft, topfloorright, topfloorbottom, ml, shapelayer);
        }
        MakeInn.makeInnPrivies(shapes, features, kitchenright, kitchenbottom, mainfloor, ml, shapelayer);
        return t;
    }

    private static void makeInnStorageRoom(List<MapShape> shapes, List<Feature> features, String filltexture, double ownerroomtop, double topfloorleft, double topfloorright, double topfloorbottom, MapLayer ml, MapLayer shapelayer) {
        shapes.add(BattlematDataGenerator.makeRoom(topfloorleft + 3.0, ownerroomtop + 2.0, topfloorright - 3.0, topfloorbottom - 4.0, "Rock Dark", 0.15, filltexture, shapelayer));
        Feature box = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "box", false, false, false, false, ml);
        box.setLocation(ViewLevel.BATTLEMAT, new Point2D((topfloorleft + 3.5) * 300.0, (ownerroomtop + 2.5) * 300.0));
        features.add(box);
        Feature box2 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "box", false, false, false, false, ml);
        box2.setLocation(ViewLevel.BATTLEMAT, new Point2D((topfloorleft + 3.5) * 300.0, (ownerroomtop + 3.5) * 300.0));
        features.add(box2);
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        door.setLocation(ViewLevel.BATTLEMAT, new Point2D((topfloorleft + 4.5) * 300.0, (ownerroomtop + 2.0) * 300.0));
        features.add(door);
    }

    private static void makeInnPrivies(List<MapShape> shapes, List<Feature> features, double kitchenright, double kitchenbottom, String filltexture, MapLayer ml, MapLayer shapelayer) {
        for (int i = 0; i < 4; ++i) {
            MapShape ms = BattlematDataGenerator.makeRoom(kitchenright - 2.0 + (double)i, kitchenbottom + 2.0, kitchenright - 1.0 + (double)i, kitchenbottom + 3.0, "Rock Dark", 0.15, filltexture, shapelayer);
            shapes.add(ms);
            Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 2.0 + (double)i + 0.5) * 300.0, (kitchenbottom + 3.0) * 300.0));
            features.add(door);
            Feature privy = new Feature("Battlemat/Privy", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "privy", false, false, false, false, ml);
            privy.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 2.0 + (double)i + 0.5) * 300.0, (kitchenbottom + 2.25) * 300.0));
            features.add(privy);
        }
    }

    private static void makeInnKitchen(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer, String furniture) {
        MapShape ms = BattlematDataGenerator.makeRoom(kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, 0.15, filltexture, shapelayer);
        shapes.add(ms);
        Feature kitchenfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.25) * 300.0, (kitchenbottom - 1.0) * 300.0));
        features.add(kitchenfire1);
        if (kitchenbottom > 13.0) {
            Feature kitchenfire2 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
            kitchenfire2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.25) * 300.0, (kitchenbottom - 3.0) * 300.0));
            features.add(kitchenfire2);
        }
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchentop + 1.5) * 300.0));
        features.add(kitchendoor);
        Feature barrel1 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.35) * 300.0, (kitchentop + 0.35) * 300.0));
        features.add(barrel1);
        Feature barrel2 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.95) * 300.0, (kitchentop + 0.35) * 300.0));
        features.add(barrel2);
        Feature barrel3 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel3.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.35) * 300.0, (kitchentop + 0.95) * 300.0));
        features.add(barrel3);
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, 180.0, -1.0, null, "table", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.25) * 300.0, (kitchenbottom - 1.0) * 300.0));
        features.add(bookcase1);
        if (kitchenbottom > 13.0) {
            Feature bookcase2 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, 180.0, -1.0, null, "table", false, false, false, false, ml);
            bookcase2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.25) * 300.0, (kitchenbottom - 3.0) * 300.0));
            features.add(bookcase2);
        }
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 300.0, 100.0, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 3.0) * 300.0, (kitchenbottom - 0.5) * 300.0));
        features.add(kitchentable1);
        Feature kitchentable2 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 300.0, 100.0, null, "table", false, false, false, false, ml);
        kitchentable2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 3.0) * 300.0, (kitchenbottom - 2.25) * 300.0));
        features.add(kitchentable2);
        Feature backdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        backdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenleft * 300.0, (kitchentop + 1.5) * 300.0));
        features.add(backdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenleft * 300.0, (kitchentop + 3.0) * 300.0));
        features.add(window);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 3.0) * 300.0, kitchenbottom * 300.0));
        features.add(window5);
    }

    private static void makeInnMainRoom(List<MapShape> shapes, List<Feature> features, double kitchentop, String stroketexture, String filltexture, double commonroombottom, Polygon mainroompoly, double mainroomleft, double mainroomtop, double mainroomright, double mainroombottom, MapLayer ml, MapLayer shapelayer, String furniture) {
        MapShape ms = BattlematDataGenerator.makeRoom(mainroomleft, mainroomtop, mainroomright, mainroombottom, stroketexture, 0.15, filltexture, shapelayer);
        shapes.add(ms);
        double tablew = (mainroomright - mainroomleft - 1.5) / 2.0;
        int numtables = (int)((mainroombottom - mainroomtop + 1.0) / 1.5);
        double tableh = (mainroombottom - mainroomtop - 1.5) / (double)numtables;
        if (tablew == 1.0) {
            tablew = 2.0;
        }
        double i = mainroomright;
        while (i > mainroomleft + 2.0) {
            for (double j = mainroomtop + 0.75; j <= mainroombottom - 0.75; j += tableh) {
                if (i == mainroomright && j > mainroomtop + (mainroombottom - mainroomtop) / 2.0 - 1.0 && j < mainroomtop + (mainroombottom - mainroomtop) / 2.0 + 1.0 || j > mainroomtop + 6.0 && i < mainroomleft + 4.0) continue;
                Feature table1 = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 0.0, null, tablew * 100.0, 100.0, false, false, null, "table", false, false, false, false, ml);
                table1.setLocation(ViewLevel.BATTLEMAT, new Point2D((i - tablew / 2.0) * 300.0, j * 300.0));
                features.add(table1);
            }
            i = i - tablew - 0.25;
        }
        Feature mainfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 270.0, null, -1.0, -1.0, null, "fireplace", false, false, false, false, ml);
        mainfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 0.25) * 300.0, kitchentop * 300.0));
        features.add(mainfire1);
        Feature mainfire2 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 270.0, null, -1.0, -1.0, null, "fireplace", false, false, false, false, ml);
        mainfire2.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 0.25) * 300.0, (commonroombottom - 0.75) * 300.0));
        features.add(mainfire2);
        double barsize = mainroombottom - mainroomtop - 7.0;
        for (double i2 = mainroombottom - barsize + 0.5; i2 < mainroombottom; i2 += 0.75) {
            Feature stool = new Feature("Battlemat/Stool " + furniture, false, false, false, false, null, 90.0, null, 50.0, 50.0, null, "stool", false, false, false, false, ml);
            stool.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.9) * 300.0, i2 * 300.0));
            features.add(stool);
        }
        Feature bartable1 = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, barsize * 100.0, 100.0, null, "table", false, false, false, false, ml);
        bartable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.5) * 300.0, (mainroombottom - barsize / 2.0) * 300.0));
        features.add(bartable1);
        Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 2.0) * 300.0, mainroomtop * 300.0));
        features.add(window1);
        Feature window2 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window2.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 2.0) * 300.0, mainroombottom * 300.0));
        features.add(window2);
        Feature window3 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window3.setLocation(ViewLevel.BATTLEMAT, new Point2D(mainroomright * 300.0, (mainroomtop + 2.0) * 300.0));
        features.add(window3);
        Feature window4 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window4.setLocation(ViewLevel.BATTLEMAT, new Point2D(mainroomright * 300.0, (mainroombottom - 2.0) * 300.0));
        features.add(window4);
    }

    private static void makeInnGuestRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        MapShape ms = BattlematDataGenerator.makeRoom(guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, 0.15, filltexture, shapelayer);
        shapes.add(ms);
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 270.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
        if (guestroombottom - guestroomtop < 2.5) {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroomtop + 0.6) * 300.0));
        } else {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroomtop + 0.75) * 300.0));
        }
        features.add(ownerbed);
        Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "chair", false, false, false, false, ml);
        ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.7) * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerchair);
        Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 180.0, null, -1.0, -1.0, null, "desk", false, false, false, false, ml);
        ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.7) * 300.0, (guestroombottom - 0.3) * 300.0));
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroombottom - 0.75) * 300.0));
        features.add(window);
    }

    private static void makeInnGuestRoomReverse(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        MapShape ms = BattlematDataGenerator.makeRoom(guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, 0.15, filltexture, shapelayer);
        shapes.add(ms);
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
        if (guestroombottom - guestroomtop < 2.5) {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.8) * 300.0, (guestroomtop + 0.6) * 300.0));
        } else {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.8) * 300.0, (guestroomtop + 0.75) * 300.0));
        }
        features.add(ownerbed);
        Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "chair", false, false, false, false, ml);
        ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.7) * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerchair);
        Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 180.0, null, -1.0, -1.0, null, "desk", false, false, false, false, ml);
        ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.7) * 300.0, (guestroombottom - 0.3) * 300.0));
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroombottom - 0.75) * 300.0));
        features.add(window);
    }

    private static void makeInnGuestRoomLarge(boolean top, List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        shapes.add(BattlematDataGenerator.makeRoom(guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, 0.15, filltexture, shapelayer));
        String bed = MakeHouse.getDoubleBed(furniture);
        Feature bed1 = new Feature(bed, false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
        bed1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.8) * 300.0, (guestroomtop + 0.75) * 300.0));
        features.add(bed1);
        Feature bed2 = new Feature(bed, false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
        bed2.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.8) * 300.0, (guestroomtop + 2.5) * 300.0));
        features.add(bed2);
        Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "chair", false, false, false, false, ml);
        ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerchair);
        Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 180.0, null, -1.0, -1.0, null, "desk", false, false, false, false, ml);
        ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, (guestroombottom - 0.3) * 300.0));
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroomtop + 2.0) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        if (top) {
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroomtop * 300.0));
        } else {
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroombottom * 300.0));
        }
        features.add(window);
    }

    private static void makeInnOwnerRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon ownerroompoly, double ownerroomleft, double ownerroomtop, double ownerroomright, double ownerroombottom, MapLayer ml, MapLayer shapelayer, String furniture) {
        shapes.add(BattlematDataGenerator.makeRoom(ownerroomleft, ownerroomtop, ownerroomright, ownerroombottom, stroketexture, 0.15, filltexture, shapelayer));
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
        if (ownerroomright - ownerroomleft < 2.5) {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomleft + 0.6) * 300.0, (ownerroomtop + 0.75) * 300.0));
        } else {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomleft + 1.0) * 300.0, (ownerroomtop + 0.8) * 300.0));
        }
        features.add(ownerbed);
        Feature ownerchair = new Feature("Battlemat/Chair " + furniture, false, false, false, false, null, 270.0, null, -1.0, -1.0, null, "chair", false, false, false, false, ml);
        ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomright - 0.5) * 300.0, (ownerroombottom - 0.7) * 300.0));
        features.add(ownerchair);
        Feature ownerdesk = new Feature("Battlemat/Desk " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "desk", false, false, false, false, ml);
        ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomright - 0.3) * 300.0, (ownerroombottom - 0.7) * 300.0));
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomleft + 1.5) * 300.0, ownerroombottom * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(ownerroomleft * 300.0, (ownerroomtop + 1.0) * 300.0));
        features.add(window);
    }

    private static void makeInnStairsUpMainFloor(List<MapShape> shapes, List<Feature> features, double kitchentop, String stroketexture, String filltexture, double ownerroomright, MapLayer ml, MapLayer shapelayer) {
        Polygon stairsuppoly = new Polygon();
        double stairsuptop = kitchentop - 2.0;
        double stairsupright = ownerroomright + 3.0;
        double stairsupbottom = kitchentop - 1.0;
        shapes.add(BattlematDataGenerator.makeRoom(ownerroomright, stairsuptop, stairsupright, stairsupbottom, stroketexture, 0.15, filltexture, shapelayer));
        Feature stairsup = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 270.0, null, 90.0, 180.0, null, "stairs", false, false, false, false, ml);
        stairsup.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomright + 1.0) * 300.0, (stairsuptop + 0.5) * 300.0));
        features.add(stairsup);
        Feature stairsupdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        stairsupdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(stairsupright * 300.0, (stairsuptop + 0.5) * 300.0));
        features.add(stairsupdoor);
    }

    private static void makeInnStairsDownMainFloor(List<MapShape> shapes, List<Feature> features, double kitchentop, String stroketexture, String filltexture, double ownerroomright, MapLayer ml, MapLayer shapelayer) {
        Polygon stairsdownpoly = new Polygon();
        double stairsdowntop = kitchentop - 1.0;
        double stairsdownright = ownerroomright + 3.0;
        shapes.add(BattlematDataGenerator.makeRoom(ownerroomright, stairsdowntop, stairsdownright, kitchentop, stroketexture, 0.15, filltexture, shapelayer));
        Feature stairsdown = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 180.0, null, "stairs", false, false, false, false, ml);
        stairsdown.setLocation(ViewLevel.BATTLEMAT, new Point2D((ownerroomright + 1.0) * 300.0, (stairsdowntop + 0.5) * 300.0));
        features.add(stairsdown);
        Feature stairsdowndoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        stairsdowndoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((stairsdownright - 0.5) * 300.0, kitchentop * 300.0));
        features.add(stairsdowndoor);
    }

    private static void makeInnCommonRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon commonroompoly, double commonroomleft, double commonroomtop, double commonroomright, double commonroombottom, MapLayer ml, MapLayer shapelayer) {
        shapes.add(BattlematDataGenerator.makeRoom(commonroomleft, commonroomtop, commonroomright, commonroombottom, stroketexture, 0.15, filltexture, shapelayer));
        for (double d = (commonroomleft + 0.5) * 300.0; d < commonroomright * 300.0 - 75.0; d += 300.0) {
            Feature strawmat = new Feature("Battlemat/Bed Strawmat", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
            strawmat.setLocation(ViewLevel.BATTLEMAT, new Point2D(d, (commonroombottom - 0.75) * 300.0));
            features.add(strawmat);
            Feature strawmat1 = new Feature("Battlemat/Bed Strawmat", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, ml);
            strawmat1.setLocation(ViewLevel.BATTLEMAT, new Point2D(d, (commonroomtop + 0.75) * 300.0));
            features.add(strawmat1);
        }
        Feature commonroomdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        commonroomdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(commonroomright * 300.0, ((commonroombottom - commonroomtop) / 2.0 + commonroomtop) * 300.0));
        features.add(commonroomdoor);
        Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window1.setLocation(ViewLevel.BATTLEMAT, new Point2D((commonroomleft + 3.0) * 300.0, commonroomtop * 300.0));
        features.add(window1);
        Feature window2 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "window", false, false, false, false, ml);
        window2.setLocation(ViewLevel.BATTLEMAT, new Point2D(commonroomleft * 300.0, (commonroomtop + 2.0) * 300.0));
        features.add(window2);
    }

    public static void makeWall(List<MapShape> shapes, String strokename, ImagePattern stroketexture, MapLayer shapelayer, double ... pts) {
        Path p = new Path();
        MapShape kitchenms = new MapShape(ViewLevel.BATTLEMAT, ViewLevel.BATTLEMAT, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "wall", 0.0, 0.0, 0.0, 0.0, true, true, true, true, shapelayer);
        p.setStrokeWidth(0.1);
        kitchenms.setStrokeTexture(TextureType.ALL_TEXTURES.get(strokename));
        if (stroketexture == null) {
            stroketexture = new ImagePattern(TextureType.ALL_TEXTURES.get(strokename).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        }
        p.setStroke((Paint)stroketexture);
        p.setFill(null);
        shapes.add(kitchenms);
        for (int i = 0; i < pts.length; i += 2) {
            if (i == 0) {
                MoveTo moveTo = new MoveTo();
                moveTo.setX(pts[i]);
                moveTo.setY(pts[i + 1]);
                p.getElements().add((Object)moveTo);
                continue;
            }
            LineTo lineTo = new LineTo();
            lineTo.setX(pts[i]);
            lineTo.setY(pts[i + 1]);
            p.getElements().add((Object)lineTo);
        }
    }
}

