/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.generator.battlemat.MakeHouse;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TextureType;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class MakeSmith {
    public static Terrain[][] generateSmith(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer) {
        ImagePattern rockdktexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Rock Dark").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        String mainfloor = "Wood";
        double mf = Math.random();
        if (mf < 0.3) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.7) {
            mainfloor = "Wood Light";
        }
        String kitchenfloor = "Cobblestone Light";
        double kf = Math.random();
        if (kf < 0.33) {
            kitchenfloor = "Cobblestone Dark";
        } else if (kf < 0.66) {
            kitchenfloor = "Cobblestone";
        }
        String topfloor = "Wood Light";
        double tf = Math.random();
        if (tf < 0.33) {
            topfloor = "Wood";
        } else if (tf < 0.66) {
            topfloor = "Wood Dark";
        }
        double rnd = Math.random();
        if (rnd < 0.5) {
            double room1bottom;
            double rnd2 = Math.random();
            double rnd4 = Math.random();
            double kitchenbottom = rnd4 < 0.4 ? 7.0 : 8.0;
            Polygon outsidepoly = new Polygon();
            double outsideleft = 9.0;
            double outsidetop = rnd2 < 0.5 ? 6.0 : 7.0;
            double outsideright = 11.0;
            double outsidebottom = kitchenbottom + 1.0;
            MakeSmith.makeSmithOutsideB(shapes, outsidepoly, features, outsideleft, outsidetop, outsideright, outsidebottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            Polygon room1poly = new Polygon();
            double room1left = 3.0;
            double room1top = 4.0;
            double room1right = 5.0;
            double d = room1bottom = rnd2 < 0.5 ? 6.0 : 7.0;
            if (kitchenbottom == 7.0) {
                room1bottom = 6.0;
            }
            MakeSmith.makeSmithBedroom(shapes, features, "Rock Dark", topfloor, room1poly, room1left, room1top, room1right, room1bottom, false, ml, shapelayer);
            double rnd3 = Math.random();
            Polygon room2poly = new Polygon();
            double room2left = 3.0;
            double room2top = room1bottom;
            double room2right = 5.0;
            double room2bottom = room2top + (double)(rnd3 > 0.5 ? 2 : 3);
            MakeSmith.makeSmithBedroom(shapes, features, "Rock Dark", topfloor, room2poly, room2left, room2top, room2right, room2bottom, false, ml, shapelayer);
            Polygon kitchenpoly = new Polygon();
            double kitchenleft = 5.0;
            double kitchentop = 4.0;
            double kitchenright = 9.0;
            MakeSmith.makeSmithFrontRoomB(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", mainfloor, ml, shapelayer);
            Polygon showroompoly = new Polygon();
            double showroomleft = kitchenright;
            double showroomtop = 4.0;
            double showroomright = showroomleft + 2.0;
            double showroombottom = outsidetop;
            MakeSmith.makeSmithShowroom(shapes, showroompoly, features, showroomleft, showroomtop, showroomright, showroombottom, "Rock Dark", mainfloor, ml, shapelayer);
            if ((double)t.length < outsideright + 2.0 || (double)t[0].length < outsidebottom + 2.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(outsideright + 2.0), t.length)][Math.max((int)(outsidebottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
        } else {
            double rnd3 = Math.random();
            Polygon outsidepoly = new Polygon();
            double outsideleft = 7.0;
            double outsidetop = 4.0;
            double outsideright = 9.0;
            double outsidebottom = 6.0;
            MakeSmith.makeSmithOutside(shapes, outsidepoly, features, outsideleft, outsidetop, outsideright, outsidebottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            double rnd4 = Math.random();
            Polygon kitchenpoly = new Polygon();
            double kitchenleft = 4.0;
            double kitchentop = 5.0;
            double kitchenright = 7.0;
            double kitchenbottom = rnd4 < 0.4 ? 10.0 : 9.0;
            MakeSmith.makeSmithFrontRoom(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", mainfloor, ml, shapelayer);
            double rnd2 = Math.random();
            Polygon room1poly = new Polygon();
            double room1left = 3.0;
            double room1top = 4.0;
            double room1right = 5.0;
            double room1bottom = 7.0;
            MakeSmith.makeSmithBedroom(shapes, features, "Rock Dark", topfloor, room1poly, room1left, room1top, room1right, room1bottom, true, ml, shapelayer);
            if ((double)t.length < outsideright + 2.0 || (double)t[0].length < kitchenbottom + 2.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(outsideright + 2.0), t.length)][Math.max((int)(kitchenbottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
        }
        MapShape forestFloor = BattlematDataGenerator.makeRoom(0.0, 0.0, t.length, t[0].length, "Rock Dark", 0.0, "Forest Floor", shapelayer);
        shapes.add(0, forestFloor);
        return t;
    }

    public static void makeSmithBedroom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, boolean doorMiddle, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        String sbed = MakeHouse.getBed(furniture);
        if (Math.random() < 0.5) {
            Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, (guestroomtop + 0.8) * 300.0));
            features.add(ownerbed);
        } else {
            Feature bed1 = new Feature(sbed, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
            bed1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.4) * 300.0, (guestroomtop + 0.8) * 300.0));
            features.add(bed1);
            Feature bed2 = new Feature(sbed, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
            bed2.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.3) * 300.0, (guestroomtop + 0.8) * 300.0));
            features.add(bed2);
        }
        if (guestroombottom - guestroomtop >= 3.0) {
            if (Math.random() < 0.5) {
                Feature bed = new Feature(sbed, false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
                bed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroombottom - 0.4) * 300.0));
                features.add(bed);
            } else {
                Feature bookcase1 = new Feature("Battlemat/Bookcase Full", false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "bookcase", false, false, false, false, ml);
                bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, (guestroombottom - 0.2) * 300.0));
                features.add(bookcase1);
            }
        }
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 2.0) * 300.0, (guestroomtop + (doorMiddle ? 1.5 : 0.5)) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroomtop + 1.5) * 300.0));
        features.add(window);
    }

    private static void makeSmithFrontRoom(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(kitchendoor);
        Feature fireplace = new Feature("Battlemat/Fireplace", false, false, false, false, null, 270.0, null, 120.0, -1.0, false, false, null, "table", false, false, false, false, ml);
        fireplace.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.2) * 300.0, (kitchentop + 1.5) * 300.0));
        features.add(fireplace);
        if (kitchenbottom - kitchentop > 4.5) {
            Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, 90.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.2) * 300.0, (kitchenbottom - 2.0) * 300.0));
            features.add(bookcase1);
        }
        String chair = MakeHouse.getChair(furniture);
        Feature chair1 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 2.0) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair1);
        Feature chair2 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.5) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair2);
        Feature chair3 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair3.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.0) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair3);
        Feature chair4 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair4.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 2.0) * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair4);
        Feature chair5 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.5) * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair5);
        Feature chair6 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair6.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.0) * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair6);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 200.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.5) * 300.0, (kitchenbottom - 0.85) * 300.0));
        features.add(kitchentable1);
        Feature window4 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window4.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(window4);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(window5);
    }

    private static void makeSmithFrontRoomB(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(kitchendoor);
        double center = kitchenleft + (kitchenright - kitchenleft) / 2.0;
        Feature fireplace = new Feature("Battlemat/Fireplace", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
        fireplace.setLocation(ViewLevel.BATTLEMAT, new Point2D(center * 300.0, (kitchentop + 0.45) * 300.0));
        features.add(fireplace);
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 90.0, null, 90.0, 50.0, false, false, null, "bookcase", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.25) * 300.0, (kitchentop + 1.5) * 300.0));
        features.add(bookcase1);
        String chair = MakeHouse.getChair(furniture);
        Feature chair1 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((center - 0.5) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair1);
        Feature chair2 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair2.setLocation(ViewLevel.BATTLEMAT, new Point2D(center * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair2);
        Feature chair3 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair3.setLocation(ViewLevel.BATTLEMAT, new Point2D((center + 0.5) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(chair3);
        Feature chair4 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair4.setLocation(ViewLevel.BATTLEMAT, new Point2D((center - 0.5) * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair4);
        Feature chair5 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair5.setLocation(ViewLevel.BATTLEMAT, new Point2D(center * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair5);
        Feature chair6 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair6.setLocation(ViewLevel.BATTLEMAT, new Point2D((center + 0.5) * 300.0, (kitchenbottom - 1.35) * 300.0));
        features.add(chair6);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 200.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D(center * 300.0, (kitchenbottom - 0.85) * 300.0));
        features.add(kitchentable1);
        Feature window4 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window4.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, kitchentop * 300.0));
        features.add(window4);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, kitchentop * 300.0));
        features.add(window5);
    }

    private static void makeSmithOutside(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom + 2.0, null, filltexture, shapelayer, "room");
        MakeSmith.makeOpenRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, null, shapelayer);
        Feature anvil = new Feature("Battlemat/Anvil", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "anvil", false, false, false, false, ml);
        anvil.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.4) * 300.0, (kitchentop + 3.5) * 300.0));
        features.add(anvil);
        Feature forge = new Feature("Battlemat/Forge B", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "forge", false, false, false, false, ml);
        forge.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchentop + 2.35) * 300.0));
        features.add(forge);
        Feature barrel1 = new Feature("Battlemat/Coal Bin", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "coal bin", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.45) * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(barrel1);
        Feature barrel2 = new Feature("Battlemat/Coal Bin", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "coal bin", false, false, false, false, ml);
        barrel2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.55) * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(barrel2);
        Feature barrel3 = new Feature("Battlemat/Well", false, false, false, false, null, 45.0, null, -1.0, -1.0, false, false, null, "well", false, false, false, false, ml);
        barrel3.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, (kitchenbottom + 1.5) * 300.0));
        features.add(barrel3);
    }

    private static void makeSmithOutsideB(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft - 5.0, kitchentop, kitchenleft, kitchenbottom + 2.0, stroketexture, null, shapelayer, "room");
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom + 2.0, null, filltexture, shapelayer, "room");
        MakeSmith.makeOpenRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, null, shapelayer);
        Feature anvil = new Feature("Battlemat/Anvil", false, false, false, false, null, 135.0, null, -1.0, -1.0, false, false, null, "anvil", false, false, false, false, ml);
        anvil.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft - 2.5) * 300.0, (kitchenbottom + 1.5) * 300.0));
        features.add(anvil);
        Feature forge = new Feature("Battlemat/Forge B", false, false, false, false, null, 270.0, null, -1.0, -1.0, true, false, null, "forge", false, false, false, false, ml);
        forge.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft - 3.3) * 300.0, (kitchenbottom + 0.5) * 300.0));
        features.add(forge);
        Feature barrel1 = new Feature("Battlemat/Coal Bin", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "coal bin", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.55) * 300.0, (kitchentop + 0.55) * 300.0));
        features.add(barrel1);
        Feature barrel2 = new Feature("Battlemat/Coal Bin", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "coal bin", false, false, false, false, ml);
        barrel2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.55) * 300.0, (kitchentop + 1.45) * 300.0));
        features.add(barrel2);
        Feature barrel3 = new Feature("Battlemat/Well", false, false, false, false, null, 45.0, null, -1.0, -1.0, false, false, null, "well", false, false, false, false, ml);
        barrel3.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, (kitchenbottom + 0.5) * 300.0));
        features.add(barrel3);
    }

    private static void makeSmithShowroom(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature maindoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        maindoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.5) * 300.0, kitchenbottom * 300.0));
        features.add(maindoor);
        Feature spearbarrel = new Feature("Battlemat/Spear Barrel", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "spear barrel", false, false, false, false, ml);
        spearbarrel.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.4) * 300.0, (kitchenbottom - 0.4) * 300.0));
        features.add(spearbarrel);
        Feature weaponrack = new Feature("Battlemat/Weapon Rack", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "weapon rack", false, false, false, false, ml);
        weaponrack.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.7) * 300.0, (kitchentop + 0.6) * 300.0));
        features.add(weaponrack);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchenbottom - 0.5) * 300.0));
        features.add(window5);
    }

    public static void makeOpenRoom(List<MapShape> shapes, Polygon kitchenpoly, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String strokename, String fillname, MapLayer shapelayer) {
        Path path = new Path();
        path.getElements().add((Object)new MoveTo(kitchenleft * 300.0, kitchenbottom * 300.0));
        path.getElements().add((Object)new LineTo(kitchenleft * 300.0, kitchentop * 300.0));
        path.getElements().add((Object)new LineTo(kitchenright * 300.0, kitchentop * 300.0));
        path.getElements().add((Object)new LineTo(kitchenright * 300.0, kitchenbottom * 300.0));
        MapShape kitchenms = BattlematDataGenerator.makeRoom((Shape)path, strokename, fillname, shapelayer, "room");
        shapes.add(kitchenms);
    }
}

