/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.world;

import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.information.Religion;
import com.inkwellideas.ographer.io.LoadGeneratorData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.util.Pair;

public class WorldAndNameData {
    public static String datafile = null;
    public static List<String> LOCATION_NAME_TYPES;
    public static List<String> PERSON_NAME_TYPES;
    public static final Map<String, Set<String>> DOMAINS_TO_SYMBOLS;
    public static final Map<String, Set<String>> NAME_TYPES_TO_SYLLABLES;
    public static final Map<String, Set<String>> NAME_TYPES_TO_CONSTRUCTION_RULES;
    public static final Map<String, Set<String>> FEATURE_TYPES_TO_ATTRIBUTES;
    public static final Map<String, Set<String>> FEATURE_ATTRIBUTES_TO_OPTIONS;
    public static final Map<String, Map<String, Map<String, Pair<String, String>>>> ENCOUNTERS_BY_TERRAIN;
    public static final Map<String, Set<String>> CULTURE_ATTRRIBUTE_OPTIONS;
    private static final Properties props;

    public static String verify() {
        Set<String> syllables;
        Set<String> conrulemaster;
        StringBuilder out = new StringBuilder();
        for (String nametype : LOCATION_NAME_TYPES) {
            conrulemaster = NAME_TYPES_TO_CONSTRUCTION_RULES.get("LocationName." + nametype);
            if (conrulemaster == null) {
                out.append("No location name construction rules for ").append(nametype).append(" language.\n");
            }
            if ((syllables = NAME_TYPES_TO_SYLLABLES.get("LocationName." + nametype)) == null) {
                out.append("No location name syllables/names for ").append(nametype).append(" language.\n");
            }
            if (conrulemaster == null || syllables == null) continue;
            double percenttotal = 0.0;
            for (String conrulem : conrulemaster) {
                String[] keypercent = conrulem.split(":");
                percenttotal += Double.parseDouble(keypercent[1]);
                Set<String> conrules = NAME_TYPES_TO_CONSTRUCTION_RULES.get("LocationName." + nametype + "." + keypercent[0]);
                if (conrules == null) {
                    out.append("No location name construction rules for ").append(nametype).append(" ").append(keypercent[0]).append(".\n");
                    continue;
                }
                for (String conrule : conrules) {
                    String[] syls;
                    for (String syllable : syls = conrule.split(",")) {
                        Set<String> syllablesforconrule;
                        if (syllable.equals("+") || (syllablesforconrule = NAME_TYPES_TO_SYLLABLES.get("LocationName." + nametype + "." + syllable)) != null) continue;
                        out.append("No syllables for location name construction rule ").append(nametype).append(" ").append(syllable).append(".\n");
                    }
                }
            }
            if (percenttotal == 1.0) continue;
            out.append("Location name construction rules for ").append(nametype).append(" don't add up to 1.0 (100%).\n");
        }
        for (String nametype : PERSON_NAME_TYPES) {
            conrulemaster = NAME_TYPES_TO_CONSTRUCTION_RULES.get("PersonName." + nametype);
            if (conrulemaster == null) {
                out.append("No person name construction rules for ").append(nametype).append(" language.\n");
            }
            syllables = NAME_TYPES_TO_SYLLABLES.get("PersonName." + nametype);
            boolean hasmale = false;
            boolean hasfemale = false;
            if (syllables == null) {
                out.append("No person name syllables/names for ").append(nametype).append(" language.\n");
            } else {
                for (String syl : syllables) {
                    if (syl.startsWith("M")) {
                        hasmale = true;
                    }
                    if (!syl.startsWith("F")) continue;
                    hasfemale = true;
                }
                if (!hasmale) {
                    out.append("Person name construction rules for ").append(nametype).append(" don't have a male list (syllable list name starting with 'M').\n");
                }
                if (!hasfemale) {
                    out.append("Person name construction rules for ").append(nametype).append(" don't have a female list (syllable list name starting with 'F').\n");
                }
            }
            if (conrulemaster == null || syllables == null) continue;
            double percenttotal = 0.0;
            for (String conrulem : conrulemaster) {
                String[] keypercent = conrulem.split(":");
                percenttotal += Double.parseDouble(keypercent[1]);
                Set<String> conrules = NAME_TYPES_TO_CONSTRUCTION_RULES.get("PersonName." + nametype + "." + keypercent[0]);
                if (conrules == null) {
                    out.append("No person name construction rules for ").append(nametype).append(" ").append(keypercent[0]).append(".\n");
                    continue;
                }
                for (String conrule : conrules) {
                    String[] syls;
                    for (String syllable : syls = conrule.split(",")) {
                        if (syllable.equals("+")) continue;
                        Set<String> syllablesforconrule = NAME_TYPES_TO_SYLLABLES.get("PersonName." + nametype + "." + syllable);
                        if (syllablesforconrule == null) {
                            out.append("No syllables for person name construction rule ").append(nametype).append(" ").append(syllable).append(".\n");
                        }
                        if (syllable.startsWith("M") || syllable.startsWith("F")) continue;
                        out.append("Person name syllable key ").append(nametype).append(" ").append(syllable).append(" must start with 'M' or 'F'.\n");
                    }
                }
            }
            if (percenttotal == 1.0) continue;
            out.append("Person name construction rules for ").append(nametype).append(" don't add up to 1.0 (100%).\n");
        }
        return out.toString();
    }

    public static String createExportString() {
        Set<String> vals;
        StringBuilder valstring;
        StringBuilder out = new StringBuilder();
        StringBuilder locnames = new StringBuilder();
        for (String string : LOCATION_NAME_TYPES) {
            if (locnames.length() > 0) {
                locnames.append(",");
            }
            locnames.append(string);
        }
        out.append("LocationName=").append((CharSequence)locnames).append("\n");
        for (String string : NAME_TYPES_TO_SYLLABLES.keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!string.startsWith("LocationName")) continue;
            Set<String> vals2 = NAME_TYPES_TO_SYLLABLES.get(string);
            for (String string2 : vals2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string2);
            }
            String string4 = string.substring(string.indexOf("."));
            string4 = string4.replace(" ", "\\ ");
            out.append("LocationName.Syllables").append(string4).append("=").append((CharSequence)stringBuilder).append("\n");
        }
        out.append("\n");
        StringBuilder personnames = new StringBuilder();
        for (String string : PERSON_NAME_TYPES) {
            if (personnames.length() > 0) {
                personnames.append(",");
            }
            personnames.append(string);
        }
        out.append("PersonName=").append((CharSequence)personnames).append("\n");
        for (String string : NAME_TYPES_TO_SYLLABLES.keySet()) {
            valstring = new StringBuilder();
            if (!string.startsWith("PersonName")) continue;
            vals = NAME_TYPES_TO_SYLLABLES.get(string);
            for (String v : vals) {
                if (valstring.length() > 0) {
                    valstring.append(",");
                }
                valstring.append(v);
            }
            String string6 = string.substring(string.indexOf("."));
            string6 = string6.replace(" ", "\\ ");
            out.append("PersonName.Syllables").append(string6).append("=").append((CharSequence)valstring).append("\n");
        }
        out.append("\n");
        for (String string : NAME_TYPES_TO_CONSTRUCTION_RULES.keySet()) {
            valstring = new StringBuilder();
            if (!string.startsWith("LocationName")) continue;
            vals = NAME_TYPES_TO_CONSTRUCTION_RULES.get(string);
            for (String v : vals) {
                if (valstring.length() > 0) {
                    valstring.append(",");
                }
                valstring.append(v);
            }
            String string8 = string.substring(string.indexOf("."));
            string8 = string8.replace(" ", "\\ ");
            out.append("LocationName.Construction").append(string8).append("=").append((CharSequence)valstring).append("\n");
        }
        out.append("\n");
        for (String string : NAME_TYPES_TO_CONSTRUCTION_RULES.keySet()) {
            valstring = new StringBuilder();
            if (!string.startsWith("PersonName")) continue;
            vals = NAME_TYPES_TO_CONSTRUCTION_RULES.get(string);
            for (String v : vals) {
                if (valstring.length() > 0) {
                    valstring.append(",");
                }
                valstring.append(v);
            }
            String string10 = string.substring(string.indexOf("."));
            string10 = string10.replace(" ", "\\ ");
            out.append("PersonName.Construction").append(string10).append("=").append((CharSequence)valstring).append("\n");
        }
        out.append("\n");
        for (String string : FEATURE_TYPES_TO_ATTRIBUTES.keySet()) {
            StringBuilder fvalstring = new StringBuilder();
            Set<String> fvals = FEATURE_TYPES_TO_ATTRIBUTES.get(string);
            Iterator<String> iterator = fvals.iterator();
            while (iterator.hasNext()) {
                String fv = iterator.next();
                fv = fv.trim();
                if (fvalstring.length() > 0) {
                    fvalstring.append(";");
                }
                fvalstring.append(fv);
                Set<String> opts = FEATURE_ATTRIBUTES_TO_OPTIONS.get(string + "." + fv);
                StringBuilder foptstring = new StringBuilder();
                Iterator iterator2 = opts.iterator();
                while (iterator2.hasNext()) {
                    String opt = (String)iterator2.next();
                    if (foptstring.length() > 0) {
                        foptstring.append(";");
                    }
                    foptstring.append(opt);
                }
                out.append("FeatureData.").append(string.replace(" ", "\\ ")).append(".").append(fv.replace(" ", "\\ ")).append("=").append((CharSequence)foptstring).append("\n");
            }
            out.append("FeatureData.").append(string.replace(" ", "\\ ")).append("=").append((CharSequence)fvalstring).append("\n");
        }
        out.append("\n");
        for (String string : ENCOUNTERS_BY_TERRAIN.keySet()) {
            Map<String, Map<String, Pair<String, String>>> levels = ENCOUNTERS_BY_TERRAIN.get(string);
            for (String string11 : levels.keySet()) {
                Map<String, Pair<String, String>> idsToPairs = levels.get(string11);
                for (String id : idsToPairs.keySet()) {
                    String keystring = "Encounter." + string + "." + string11 + "." + id;
                    int count = keystring.indexOf(32);
                    while (count >= 1) {
                        keystring = keystring.substring(0, count) + "\\" + keystring.substring(count);
                        count = keystring.indexOf(32, count + 3);
                    }
                    out.append(keystring + "=" + (String)((Pair)idsToPairs.get(id)).getValue() + "\n");
                }
            }
        }
        out.append("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : CULTURE_ATTRRIBUTE_OPTIONS.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(key);
            StringBuilder valstring3 = new StringBuilder();
            Set<String> set = CULTURE_ATTRRIBUTE_OPTIONS.get(key);
            for (String v : set) {
                if (valstring3.length() > 0) {
                    valstring3.append(";");
                }
                valstring3.append(v);
            }
            key = key.replace(" ", "\\ ");
            out.append(key).append("=").append((CharSequence)valstring3).append("\n");
        }
        out.append("CultureData.Keys=").append((CharSequence)stringBuilder).append("\n");
        out.append("\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String key : DOMAINS_TO_SYMBOLS.keySet()) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(key);
            StringBuilder stringBuilder3 = new StringBuilder();
            Set<String> vals4 = DOMAINS_TO_SYMBOLS.get(key);
            for (String v : vals4) {
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append(",");
                }
                stringBuilder3.append(v);
            }
            key = key.replace(" ", "\\ ");
            out.append("Religion.Domain.").append(key).append(".Symbols=").append((CharSequence)stringBuilder3).append("\n");
        }
        out.append("Religion.Domains=").append((CharSequence)stringBuilder2).append("\n");
        return out.toString();
    }

    public static void loadProps(InputStream inputstream) {
        try {
            props.load(inputstream);
            LOCATION_NAME_TYPES = WorldAndNameData.parseNames("LocationName");
            PERSON_NAME_TYPES = WorldAndNameData.parseNames("PersonName");
            String domains = props.getProperty("Religion.Domains");
            if (domains != null) {
                String[] ds;
                for (String d : ds = domains.split(",")) {
                    d = d.trim();
                    String symbols = props.getProperty("Religion.Domain." + d + ".Symbols");
                    TreeSet<String> al = new TreeSet<String>(Arrays.asList(symbols.split(",")));
                    if (symbols == null) continue;
                    DOMAINS_TO_SYMBOLS.put(d, al);
                }
            }
            WorldAndNameData.parseFeatureDatas();
            WorldAndNameData.parseCultureDatas();
            for (String string : props.keySet()) {
                Map<String, Pair<String, String>> majorMinorToIdMap;
                if (!string.startsWith("Encounter.")) continue;
                String[] key = string.split("\\.");
                Pair nameToDesc = new Pair((Object)key[3], (Object)props.getProperty(string));
                Map<String, Map<String, Pair<String, String>>> terrainToMajorMinorMap = ENCOUNTERS_BY_TERRAIN.get(key[1]);
                if (terrainToMajorMinorMap == null) {
                    terrainToMajorMinorMap = new TreeMap<String, Map<String, Pair<String, String>>>();
                    ENCOUNTERS_BY_TERRAIN.put(key[1], terrainToMajorMinorMap);
                }
                if ((majorMinorToIdMap = terrainToMajorMinorMap.get(key[2])) == null) {
                    majorMinorToIdMap = new TreeMap<String, Pair<String, String>>();
                    terrainToMajorMinorMap.put(key[2], majorMinorToIdMap);
                }
                Pair idToDescriptionPair = new Pair((Object)key[3], (Object)props.getProperty(string));
                majorMinorToIdMap.put(key[3], (Pair<String, String>)idToDescriptionPair);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<String> parseNames(String prefix) {
        String[] n = props.getProperty(prefix).split(",");
        ArrayList<String> nametypes = new ArrayList<String>();
        for (int i = 0; i < n.length; ++i) {
            nametypes.add(n[i].trim());
            String syllablessetnames = props.getProperty(prefix + ".Syllables." + (String)nametypes.get(i));
            TreeSet<String> al = new TreeSet<String>(Arrays.asList(syllablessetnames.split(",")));
            NAME_TYPES_TO_SYLLABLES.put(prefix + "." + (String)nametypes.get(i), al);
            for (String syllablekey : al) {
                String syllables = props.getProperty(prefix + ".Syllables." + (String)nametypes.get(i) + "." + syllablekey);
                TreeSet<String> al2 = new TreeSet<String>(Arrays.asList(syllables.split(",")));
                NAME_TYPES_TO_SYLLABLES.put(prefix + "." + (String)nametypes.get(i) + "." + syllablekey, al2);
            }
            String[] constructionrules = props.getProperty(prefix + ".Construction." + (String)nametypes.get(i)).split(",");
            TreeSet<String> al3 = new TreeSet<String>(Arrays.asList(constructionrules));
            NAME_TYPES_TO_CONSTRUCTION_RULES.put(prefix + "." + (String)nametypes.get(i), al3);
            for (String constructionrule : constructionrules) {
                String crkey = constructionrule.substring(0, constructionrule.indexOf(":"));
                String rule = props.getProperty(prefix + ".Construction." + (String)nametypes.get(i) + "." + crkey);
                TreeSet<String> al2 = new TreeSet<String>();
                al2.add(rule);
                NAME_TYPES_TO_CONSTRUCTION_RULES.put(prefix + "." + (String)nametypes.get(i) + "." + crkey, al2);
            }
        }
        return nametypes;
    }

    private static void parseFeatureDatas() {
        Set<Object> keyset = props.keySet();
        for (Object o : keyset) {
            String[] ks;
            String k = (String)o;
            if (!k.startsWith("FeatureData.") || (ks = k.split("\\.")).length != 2) continue;
            String values = props.getProperty(k);
            TreeSet<String> al = new TreeSet<String>(Arrays.asList(values.split(";")));
            FEATURE_TYPES_TO_ATTRIBUTES.put(ks[1], al);
            for (String v : values.split(";")) {
                v = v.trim();
                String attrkey = k + "." + v;
                String options = props.getProperty(attrkey);
                TreeSet<String> al2 = new TreeSet<String>(Arrays.asList(options.split(";")));
                FEATURE_ATTRIBUTES_TO_OPTIONS.put(ks[1] + "." + v, al2);
            }
        }
    }

    public static String generateFeatureNoteData(String type) {
        StringBuilder out = new StringBuilder();
        type = type.toLowerCase();
        for (String key : FEATURE_TYPES_TO_ATTRIBUTES.keySet()) {
            Set<String> attributes;
            if (!type.contains(key.toLowerCase()) || "resource logging camp".equals(type) && "camp".equalsIgnoreCase(key) || (attributes = FEATURE_TYPES_TO_ATTRIBUTES.get(key)) == null) continue;
            for (String attr : attributes) {
                Set<String> attributeoptions = FEATURE_ATTRIBUTES_TO_OPTIONS.get(key + "." + (attr = attr.trim()));
                if (attributeoptions == null) continue;
                Object[] objs = attributeoptions.toArray();
                Object item = (String)objs[(int)(Math.random() * (double)attributeoptions.size())];
                while (((String)item).contains("[")) {
                    String[] list = ((String)item).substring(((String)item).indexOf(91) + 1, ((String)item).indexOf(93)).split(",");
                    item = ((String)item).substring(0, ((String)item).indexOf(91)) + list[(int)(Math.random() * (double)list.length)] + ((String)item).substring(((String)item).indexOf("]") + 1);
                }
                if (attributes.size() > 1) {
                    out.append("<li>").append(attr).append(": ").append(((String)item).trim()).append("</li>");
                    continue;
                }
                out.append("<p>").append(attr).append(": ").append(((String)item).trim()).append("</p>");
            }
        }
        if ("".equals(out.toString())) {
            out = new StringBuilder("No data available to generate details for this feature type.");
        }
        return out.toString();
    }

    private static void parseCultureDatas() {
        Set<Object> keyset = props.keySet();
        for (Object o : keyset) {
            String[] ks;
            String k = (String)o;
            if (!k.startsWith("CultureData.") || (ks = k.split("\\.")).length != 2) continue;
            String values = props.getProperty(k);
            if (ks[1].equalsIgnoreCase("keys")) continue;
            TreeSet<String> al = new TreeSet<String>(Arrays.asList(values.split(";")));
            CULTURE_ATTRRIBUTE_OPTIONS.put(k, al);
        }
    }

    public static String generateCultureData() {
        StringBuilder s = new StringBuilder();
        for (String key : CULTURE_ATTRRIBUTE_OPTIONS.keySet()) {
            Set<String> values = CULTURE_ATTRRIBUTE_OPTIONS.get(key);
            if (key.indexOf(".") > 0) {
                key = key.substring(key.indexOf(".") + 1);
            }
            Object item = (String)values.toArray()[(int)(Math.random() * (double)values.size())];
            while (((String)item).contains("[")) {
                String[] list = ((String)item).substring(((String)item).indexOf(91) + 1, ((String)item).indexOf(93)).split(",");
                item = ((String)item).substring(0, ((String)item).indexOf(91)) + list[(int)(Math.random() * (double)list.length)] + ((String)item).substring(((String)item).indexOf("]") + 1);
            }
            s.append("<li>").append(key).append(": ").append(((String)item).trim()).append("</li>\n");
        }
        return s.toString();
    }

    public static List<Information> generateAllInfo(Integer numnations) {
        ArrayList<Information> info = new ArrayList<Information>();
        info.add(new Information("Intro", "<h1>Intro</h1>", null));
        if (numnations == 0) {
            return info;
        }
        ArrayList<Information> cultures = new ArrayList<Information>();
        Information nations = WorldAndNameData.generateNations(cultures, numnations);
        info.add(nations);
        Information culturestop = new Information("Cultures", "<h1>Cultures</h1>", cultures);
        info.add(culturestop);
        info.add(WorldAndNameData.generateReligions(cultures, (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1) + ((int)(Math.random() * 4.0) + 1)));
        info.add(new Information("Timelines", "<h1>Timelines</h1>", null));
        return info;
    }

    public static String getNameDynamic(String language, NameType nt, String gender) {
        language = language.trim();
        Set<String> syllablelistnames = NAME_TYPES_TO_SYLLABLES.get(nt.name() + "." + language);
        if (syllablelistnames == null) {
            for (String nameType : NAME_TYPES_TO_SYLLABLES.keySet()) {
                if (!nameType.equalsIgnoreCase(nt.name() + "." + language)) continue;
                language = nameType.substring(nameType.indexOf(46) + 1);
            }
            syllablelistnames = NAME_TYPES_TO_SYLLABLES.get(nt.name() + "." + language);
            if (syllablelistnames == null) {
                syllablelistnames = NAME_TYPES_TO_SYLLABLES.get(nt.name() + "." + language.toLowerCase());
            }
            if (syllablelistnames == null) {
                return "no name";
            }
        }
        for (String syll : syllablelistnames) {
            syll = syll.trim();
        }
        HashMap<String, Set<String>> syllists = new HashMap<String, Set<String>>();
        int count1 = 0;
        for (String string : syllablelistnames) {
            String key = nt.name() + "." + language + "." + string;
            Set<String> sl = NAME_TYPES_TO_SYLLABLES.get(key);
            syllists.put(string, sl);
            ++count1;
        }
        Set<String> languageconstruction = NAME_TYPES_TO_CONSTRUCTION_RULES.get(nt.name() + "." + language);
        for (String lc : languageconstruction) {
            lc = lc.trim();
        }
        double d = Math.random();
        double runningtotal = 0.0;
        for (int count = 0; count < 200; ++count) {
            for (String lc : languageconstruction) {
                String[] vals = lc.split(":");
                double d2 = Double.parseDouble(vals[1]);
                if (d < runningtotal + d2) {
                    String[] set;
                    StringBuilder name = new StringBuilder();
                    for (String key : set = ((String)NAME_TYPES_TO_CONSTRUCTION_RULES.get(nt.name() + "." + language + "." + vals[0]).toArray()[0]).split(",")) {
                        if (key.equals("+")) {
                            Set s = syllists.keySet();
                            key = (String)s.toArray()[(int)Math.random() * s.size()];
                        }
                        if (gender != null && !key.startsWith(gender)) continue;
                        Set sl = (Set)syllists.get(key.trim());
                        name.append(sl.toArray()[(int)(Math.random() * (double)sl.size())]);
                    }
                    if (name.toString().equals("")) continue;
                    String c = name.substring(0, 1);
                    c = c.toUpperCase();
                    name = new StringBuilder(c + name.substring(1));
                    return name.toString();
                }
                runningtotal += d2;
            }
        }
        return "no name";
    }

    public static String[] generate3Domains() {
        int one = (int)(Math.random() * (double)DOMAINS_TO_SYMBOLS.keySet().size());
        int two = (int)(Math.random() * (double)DOMAINS_TO_SYMBOLS.keySet().size());
        while (one == two) {
            two = (int)(Math.random() * (double)DOMAINS_TO_SYMBOLS.keySet().size());
        }
        int three = (int)(Math.random() * (double)DOMAINS_TO_SYMBOLS.keySet().size());
        while (three == two || three == one) {
            three = (int)(Math.random() * (double)DOMAINS_TO_SYMBOLS.keySet().size());
        }
        Object[] o = DOMAINS_TO_SYMBOLS.keySet().toArray();
        return new String[]{(String)o[one], (String)o[two], (String)o[three]};
    }

    public static String getHolySymbol(String domain) {
        Set<String> hs = DOMAINS_TO_SYMBOLS.get(domain);
        if (hs != null) {
            return (String)hs.toArray()[(int)(Math.random() * (double)hs.size())];
        }
        return "Domain not found.";
    }

    public static Information generateReligionPantheonGod(String nametype, Culture culture) {
        String title = WorldAndNameData.getNameDynamic(nametype, NameType.PersonName, Math.random() < 0.5 ? "M" : "F");
        String desc = "<h2>" + title + "</h2>";
        desc = desc + "<ul>";
        String[] domains = WorldAndNameData.generate3Domains();
        desc = desc + "<li>Domains: " + domains[0] + ", " + domains[1] + ", " + domains[2] + "</li>";
        String holysymbol = WorldAndNameData.getHolySymbol(domains[0]);
        desc = desc + "<li>Holy Symbol:" + holysymbol + "</li>";
        desc = desc + "<li>God's Physical Description</li>";
        desc = desc + "<li>God's Personality</li>";
        desc = desc + "<li>Common Followers</li>";
        desc = desc + "<li>Origin/mini-story</li>";
        desc = desc + "<li>Holidays</li>";
        desc = desc + "<li>Goals/current event</li>";
        desc = desc + "</ul>";
        return new Religion(title, "Pantheon", culture, domains, holysymbol, desc);
    }

    public static Religion generateReligionPantheon(String language, Culture culture) {
        int numgods = (int)(Math.random() * 6.0) + 1 + ((int)(Math.random() * 6.0) + 1) + ((int)(Math.random() * 6.0) + 1) + ((int)(Math.random() * 6.0) + 1);
        ArrayList<Information> gods = new ArrayList<Information>();
        for (int i = 0; i < numgods; ++i) {
            gods.add(WorldAndNameData.generateReligionPantheonGod(language, culture));
        }
        String title = "Pantheon w/" + numgods + " gods";
        StringBuilder description = new StringBuilder("The gods are: ");
        for (Information i : gods) {
            description.append(i.getName()).append(", ");
        }
        description = new StringBuilder(description.substring(0, description.length() - 2));
        description.append("  It came from the ").append(culture.getName()).append(" culture. ");
        return new Religion(title, "Pantheon", culture, null, null, "", gods);
    }

    public static Religion generateReligionMonotheistic(String language, Culture culture) {
        String name;
        String title = name = WorldAndNameData.getNameDynamic(language, NameType.PersonName, Math.random() < 0.5 ? "M" : "F");
        String[] domains = WorldAndNameData.generate3Domains();
        return new Religion(title, "Monotheistic", culture, domains, WorldAndNameData.getHolySymbol(domains[0]), "");
    }

    public static Religion generateReligionDemonSect(String language, Culture culture) {
        String name;
        String title = name = WorldAndNameData.getNameDynamic(language, NameType.PersonName, Math.random() < 0.5 ? "M" : "F");
        String[] domains = WorldAndNameData.generate3Domains();
        return new Religion(title, "Demon Sect", culture, domains, WorldAndNameData.getHolySymbol(domains[0]), "");
    }

    public static Religion generateReligionSpiritual(String language, Culture culture) {
        String name;
        String title = name = WorldAndNameData.getNameDynamic(language, NameType.PersonName, Math.random() < 0.5 ? "M" : "F");
        String[] domains = WorldAndNameData.generate3Domains();
        return new Religion(title, "Mystical", culture, domains, WorldAndNameData.getHolySymbol(domains[0]), "");
    }

    public static Religion generateReligion(List<Information> cultures) {
        int primculturenum = (int)(Math.random() * (double)cultures.size());
        Culture culture = (Culture)cultures.get(primculturenum);
        return WorldAndNameData.generateReligion(culture);
    }

    public static Religion generateReligion(Culture culture) {
        String type;
        String language = culture.getLanguage();
        String[] types = new String[]{"Pantheon", "Pantheon", "Pantheon", "Monotheistic", "Monotheistic", "Demon Sect", "Demon Sect", "Demon Sect", "Spiritualistic", "Spiritualistic"};
        Religion info = switch (type = types[(int)(Math.random() * (double)types.length)]) {
            case "Pantheon" -> WorldAndNameData.generateReligionPantheon(language, culture);
            case "Monotheistic" -> WorldAndNameData.generateReligionMonotheistic(language, culture);
            case "Demon Sect" -> WorldAndNameData.generateReligionDemonSect(language, culture);
            default -> WorldAndNameData.generateReligionSpiritual(language, culture);
        };
        return info;
    }

    public static Information generateReligions(List<Information> cultures, int num) {
        String text = "<h1>Religions</h1>\nThis world has " + num + " popular or noteworthy religions.";
        ArrayList<Information> religions = new ArrayList<Information>();
        for (int i = 0; i < num; ++i) {
            Religion r = WorldAndNameData.generateReligion(cultures);
            r.generateInfo();
            religions.add(r);
        }
        Information i = new Information("Religions", text, religions);
        return i;
    }

    public static Culture generateCulture(String type) {
        if (type == null) {
            type = LOCATION_NAME_TYPES.get((int)(Math.random() * (double)LOCATION_NAME_TYPES.size()));
        }
        String name = WorldAndNameData.getNameDynamic(type, NameType.PersonName, null);
        Culture c = new Culture(name, type, "");
        c.generateInfo();
        return c;
    }

    public static Information generateNations(List<Information> cultures, int num) {
        ArrayList<Information> nations = new ArrayList<Information>();
        for (int i = 0; i < num; ++i) {
            Culture c;
            if (Math.random() < 0.8 || cultures.size() == 0) {
                c = WorldAndNameData.generateCulture(null);
                cultures.add(c);
            } else {
                c = (Culture)cultures.get((int)(Math.random() * (double)cultures.size()));
            }
            Nation n = WorldAndNameData.generateNation(c);
            nations.add(n);
        }
        Information nationstop = new Information("Nations", "<h1>Nations</h1>", nations);
        return nationstop;
    }

    public static Nation generateNation(Culture c) {
        String name = WorldAndNameData.getNameDynamic(c.getLanguage(), NameType.LocationName, null);
        ArrayList<Culture> cs = new ArrayList<Culture>();
        cs.add(c);
        String government = Nation.GOVERNMENTS[(int)(Math.random() * (double)Nation.GOVERNMENTS.length)];
        String[] rulers = new String[Nation.numRulers(government)];
        for (int j = 0; j < rulers.length; ++j) {
            rulers[j] = WorldAndNameData.getNameDynamic(c.getLanguage(), NameType.PersonName, Math.random() < 0.5 ? "M" : "F");
        }
        Nation n = new Nation(name, cs, government, rulers, "");
        n.generateInfo();
        return n;
    }

    public static Pair<String, String> generateRandomEncounter(String terrain, String level) {
        Map<String, Pair<String, String>> anyMajorMinorToIdMap;
        Set<String> terrainTypes = ENCOUNTERS_BY_TERRAIN.keySet();
        HashSet<String> terrainKeys = new HashSet<String>();
        for (String k : terrainTypes) {
            if (!terrain.toLowerCase().contains(k.toLowerCase())) continue;
            terrainKeys.add(k);
        }
        HashMap<String, String> possibleEncounters = new HashMap<String, String>();
        HashMap<String, String> idsToTerrainMap = new HashMap<String, String>();
        for (String terrainKey : terrainKeys) {
            Map<String, Map<String, Pair<String, String>>> terrainToMajorMinorMap = ENCOUNTERS_BY_TERRAIN.get(terrainKey);
            Map<String, Pair<String, String>> majorMinorToIdMap = terrainToMajorMinorMap.get(level);
            if (majorMinorToIdMap == null) continue;
            for (String idk : majorMinorToIdMap.keySet()) {
                String priorTerrain;
                Pair<String, String> idToDescPair = majorMinorToIdMap.get(idk);
                if (idToDescPair == null || (priorTerrain = (String)idsToTerrainMap.get(idToDescPair.getKey())) != null && priorTerrain.length() > terrainKey.length()) continue;
                possibleEncounters.put((String)idToDescPair.getKey(), (String)idToDescPair.getValue());
                idsToTerrainMap.put((String)idToDescPair.getKey(), terrainKey);
            }
        }
        Map<String, Map<String, Pair<String, String>>> anyTerrainToMajorMinorMap = ENCOUNTERS_BY_TERRAIN.get("AnyLand");
        if (terrain.toLowerCase().contains("water")) {
            anyTerrainToMajorMinorMap = ENCOUNTERS_BY_TERRAIN.get("Water");
        }
        if ((anyMajorMinorToIdMap = anyTerrainToMajorMinorMap.get(level)) != null) {
            for (String idk : anyMajorMinorToIdMap.keySet()) {
                Pair<String, String> idToDescMap = anyMajorMinorToIdMap.get(idk);
                if (idToDescMap == null || possibleEncounters.containsKey(idToDescMap.getKey())) continue;
                possibleEncounters.put((String)idToDescMap.getKey(), (String)idToDescMap.getValue());
            }
        }
        if (possibleEncounters.size() > 0) {
            ArrayList keys = new ArrayList(possibleEncounters.keySet());
            String key = (String)keys.get((int)(Math.random() * (double)possibleEncounters.size()));
            return new Pair((Object)key, (Object)((String)possibleEncounters.get(key)));
        }
        return null;
    }

    static {
        DOMAINS_TO_SYMBOLS = new TreeMap<String, Set<String>>();
        NAME_TYPES_TO_SYLLABLES = new TreeMap<String, Set<String>>();
        NAME_TYPES_TO_CONSTRUCTION_RULES = new TreeMap<String, Set<String>>();
        FEATURE_TYPES_TO_ATTRIBUTES = new TreeMap<String, Set<String>>();
        FEATURE_ATTRIBUTES_TO_OPTIONS = new TreeMap<String, Set<String>>();
        ENCOUNTERS_BY_TERRAIN = new TreeMap<String, Map<String, Map<String, Pair<String, String>>>>();
        CULTURE_ATTRRIBUTE_OPTIONS = new TreeMap<String, Set<String>>();
        props = new Properties();
        try {
            if (props.size() == 0) {
                WorldAndNameData.loadProps(new LoadGeneratorData().getWorldBook());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum NameType {
        LocationName,
        PersonName;

    }
}

