/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.information;

import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Information;
import java.util.ArrayList;
import java.util.UUID;

public class Culture
extends Information {
    private String language;

    public Culture(String name, String lang, String text) {
        this(name, lang, text, UUID.randomUUID());
    }

    public Culture(String name, String lang, String text, UUID uuid) {
        super(name, text, new ArrayList<Information>());
        this.setLanguage(lang);
        if (text == null || "".equals(text.trim())) {
            this.setText(this.generateInfo());
        } else {
            this.setText(text);
        }
        this.uuid = uuid;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public String generateInfo() {
        String s = "<h2>" + this.name + "</h2>\n<ul>\n<li>Language is based on " + this.language + "</li>\n";
        s = s + WorldAndNameData.generateCultureData();
        s = s + "\n</ul>";
        return s;
    }

    @Override
    public String getXMLString() {
        String info = super.getXMLString();
        return info.substring(0, 12) + " language=\"" + this.language + "\" " + info.substring(12);
    }

    @Override
    public String getAdditionalWriteInfo() {
        return " language=\"" + this.language + "\" ";
    }
}

