/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map.component;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.component.ViewLevelDataSetup;

public class ViewLevelData {
    private int continentFactor = -1;
    private int kingdomFactor = -1;
    private int provinceFactor = -1;
    private double worldToContinentHOffset = 0.0;
    private double continentToKingdomHOffset = 0.0;
    private double kingdomToProvinceHOffset = 0.0;
    private double worldToContinentVOffset = 0.0;
    private double continentToKingdomVOffset = 0.0;
    private double kingdomToProvinceVOffset = 0.0;
    private double gridOffsetWorldContinentX = 0.0;
    private double gridOffsetWorldContinentY = 0.0;
    private double gridOffsetContinentKingdomX = 0.0;
    private double gridOffsetContinentKingdomY = 0.0;
    private double gridOffsetWorldKingdomX = 0.0;
    private double gridOffsetWorldKingdomY = 0.0;
    private int triangleSizeContinent;
    private int triangleSizeKingdom;
    private int triangleSizeProvince;
    private int triangleSizeWorld;

    public void setWorldToContinentHOffset(double worldToContinentHOffset) {
        this.worldToContinentHOffset = worldToContinentHOffset;
    }

    public void setContinentToKingdomHOffset(double continentToKingdomHOffset) {
        this.continentToKingdomHOffset = continentToKingdomHOffset;
    }

    public void setKingdomToProvinceHOffset(double kingdomToProvinceHOffset) {
        this.kingdomToProvinceHOffset = kingdomToProvinceHOffset;
    }

    public void setWorldToContinentVOffset(double worldToContinentVOffset) {
        this.worldToContinentVOffset = worldToContinentVOffset;
    }

    public void setContinentToKingdomVOffset(double continentToKingdomVOffset) {
        this.continentToKingdomVOffset = continentToKingdomVOffset;
    }

    public void setKingdomToProvinceVOffset(double kingdomToProvinceVOffset) {
        this.kingdomToProvinceVOffset = kingdomToProvinceVOffset;
    }

    public void setTriangleSizeContinent(int triangleSizeContinent) {
        this.triangleSizeContinent = triangleSizeContinent;
    }

    public void setTriangleSizeKingdom(int triangleSizeKingdom) {
        this.triangleSizeKingdom = triangleSizeKingdom;
    }

    public void setTriangleSizeProvince(int triangleSizeProvince) {
        this.triangleSizeProvince = triangleSizeProvince;
    }

    public void setTriangleSizeWorld(int triangleSizeWorld) {
        this.triangleSizeWorld = triangleSizeWorld;
    }

    public double getWorldToContinentHOffset() {
        return this.worldToContinentHOffset;
    }

    public double getContinentToKingdomHOffset() {
        return this.continentToKingdomHOffset;
    }

    public double getKingdomToProvinceHOffset() {
        return this.kingdomToProvinceHOffset;
    }

    public double getWorldToContinentVOffset() {
        return this.worldToContinentVOffset;
    }

    public double getContinentToKingdomVOffset() {
        return this.continentToKingdomVOffset;
    }

    public double getKingdomToProvinceVOffset() {
        return this.kingdomToProvinceVOffset;
    }

    public int getTriangleSizeContinent() {
        return this.triangleSizeContinent;
    }

    public int getTriangleSizeKingdom() {
        return this.triangleSizeKingdom;
    }

    public int getTriangleSizeProvince() {
        return this.triangleSizeProvince;
    }

    public int getTriangleSizeWorld() {
        return this.triangleSizeWorld;
    }

    public double getGridOffsetWorldContinentX() {
        return this.gridOffsetWorldContinentX;
    }

    public void setGridOffsetWorldContinentX(double gridOffsetWorldContinentX) {
        this.gridOffsetWorldContinentX = gridOffsetWorldContinentX;
    }

    public double getGridOffsetWorldContinentY() {
        return this.gridOffsetWorldContinentY;
    }

    public void setGridOffsetWorldContinentY(double gridOffsetWorldContinentY) {
        this.gridOffsetWorldContinentY = gridOffsetWorldContinentY;
    }

    public double getGridOffsetKingdomProvinceX() {
        return this.gridOffsetContinentKingdomX;
    }

    public double getGridOffsetKingdomProvinceY() {
        return this.gridOffsetContinentKingdomY;
    }

    public double getGridOffsetContinentKingdomX() {
        return this.gridOffsetContinentKingdomX;
    }

    public void setGridOffsetContinentKingdomX(double gridOffsetContinentKingdomX) {
        this.gridOffsetContinentKingdomX = gridOffsetContinentKingdomX;
    }

    public double getGridOffsetContinentKingdomY() {
        return this.gridOffsetContinentKingdomY;
    }

    public void setGridOffsetContinentKingdomY(double gridOffsetContinentKingdomY) {
        this.gridOffsetContinentKingdomY = gridOffsetContinentKingdomY;
    }

    public double getGridOffsetWorldKingdomX() {
        return this.gridOffsetWorldKingdomX;
    }

    public void setGridOffsetWorldKingdomX(double gridOffsetWorldKingdomX) {
        this.gridOffsetWorldKingdomX = gridOffsetWorldKingdomX;
    }

    public double getGridOffsetWorldKingdomY() {
        return this.gridOffsetWorldKingdomY;
    }

    public void setGridOffsetWorldKingdomY(double gridOffsetWorldKingdomY) {
        this.gridOffsetWorldKingdomY = gridOffsetWorldKingdomY;
    }

    public int getContinentFactor() {
        return this.continentFactor;
    }

    public void setContinentFactor(int continentFactor) {
        this.continentFactor = continentFactor;
    }

    public int getKingdomFactor() {
        return this.kingdomFactor;
    }

    public void setKingdomFactor(int kingdomFactor) {
        this.kingdomFactor = kingdomFactor;
    }

    public int getProvinceFactor() {
        return this.provinceFactor;
    }

    public void setProvinceFactor(int provinceFactor) {
        this.provinceFactor = provinceFactor;
    }

    public int getTriangleSize(ViewLevel vl) {
        if (vl == ViewLevel.CONTINENT) {
            return this.triangleSizeContinent;
        }
        if (vl == ViewLevel.KINGDOM) {
            return this.triangleSizeKingdom;
        }
        if (vl == ViewLevel.PROVINCE) {
            return this.triangleSizeProvince;
        }
        return this.triangleSizeWorld;
    }

    public void apply(ViewLevelDataSetup setup, MapData mapData) {
        this.triangleSizeWorld = setup.triangleSize;
        ViewLevel.WORLD.setTriangleSize(this.triangleSizeWorld, mapData);
        this.continentFactor = setup.continentFactor;
        this.kingdomFactor = setup.kingdomFactor;
        this.provinceFactor = setup.provinceFactor;
        if (this.continentFactor != 0 && this.getTriangleSize(ViewLevel.WORLD) != 0) {
            ViewLevel.CONTINENT.setTriangleSize(this.getTriangleSize(ViewLevel.WORLD) * this.continentFactor, mapData);
        }
        if (this.kingdomFactor != 0 && this.getTriangleSize(ViewLevel.CONTINENT) != 0) {
            ViewLevel.KINGDOM.setTriangleSize(this.getTriangleSize(ViewLevel.CONTINENT) * this.kingdomFactor, mapData);
        }
        if (this.provinceFactor != 0 && this.getTriangleSize(ViewLevel.KINGDOM) != 0) {
            ViewLevel.PROVINCE.setTriangleSize(this.getTriangleSize(ViewLevel.KINGDOM) * this.provinceFactor, mapData);
        }
        this.worldToContinentHOffset = setup.worldToContinentHOffset;
        this.continentToKingdomHOffset = setup.continentToKingdomHOffset;
        this.kingdomToProvinceHOffset = setup.kingdomToProvinceHOffset;
        this.worldToContinentVOffset = setup.worldToContinentVOffset;
        this.continentToKingdomVOffset = setup.continentToKingdomVOffset;
        this.kingdomToProvinceVOffset = setup.kingdomToProvinceVOffset;
        this.gridOffsetContinentKingdomX = setup.gridOffsetContinentKingdomX;
        this.gridOffsetContinentKingdomY = setup.gridOffsetContinentKingdomY;
        this.gridOffsetWorldContinentX = setup.gridOffsetWorldContinentX;
        this.gridOffsetWorldContinentY = setup.gridOffsetWorldContinentY;
        this.gridOffsetWorldKingdomX = setup.gridOffsetWorldKingdomX;
        this.gridOffsetWorldKingdomY = setup.gridOffsetWorldKingdomY;
    }
}

