/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.toolbox.WLogger;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.geometry.Point2D;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Pair;

public class MapController {
    final MapData mapData;
    final MapUI mapUI;
    final UndoRedoHandler undoRedoHandler;
    private final WLogger loggerUI;

    public MapController(MapData md, MapUI mu, WLogger loggerUI) {
        this.mapData = md;
        this.mapUI = mu;
        this.loggerUI = loggerUI;
        this.undoRedoHandler = new UndoRedoHandler(this.mapData, loggerUI);
    }

    public static Polygon makeCombinedPolygon(Polygon a, Polygon b) {
        ArrayList<Line> linesa = new ArrayList<Line>();
        for (int i = 0; i < a.getPoints().size() - 1; i += 2) {
            linesa.add(new Line(((Double)a.getPoints().get(i)).doubleValue(), ((Double)a.getPoints().get(i + 1)).doubleValue(), ((Double)a.getPoints().get((i + 2) % a.getPoints().size())).doubleValue(), ((Double)a.getPoints().get((i + 3) % a.getPoints().size())).doubleValue()));
        }
        ArrayList<Line> linesb = new ArrayList<Line>();
        for (int i = 0; i < b.getPoints().size() - 1; i += 2) {
            linesb.add(new Line(((Double)b.getPoints().get(i)).doubleValue(), ((Double)b.getPoints().get(i + 1)).doubleValue(), ((Double)b.getPoints().get((i + 2) % b.getPoints().size())).doubleValue(), ((Double)b.getPoints().get((i + 3) % b.getPoints().size())).doubleValue()));
        }
        ArrayList<Line> linesbeforematcha = new ArrayList<Line>();
        ArrayList<Line> resultlinesa = new ArrayList<Line>();
        boolean ahadmatches = false;
        for (Line linea : linesa) {
            boolean match = false;
            for (Line lineb : linesb) {
                if (!MapController.areLinesSame(linea, lineb)) continue;
                match = true;
                break;
            }
            if (match) {
                ahadmatches = true;
                continue;
            }
            if (ahadmatches) {
                resultlinesa.add(linea);
                continue;
            }
            linesbeforematcha.add(linea);
        }
        resultlinesa.addAll(linesbeforematcha);
        ArrayList<Line> linesbeforematchb = new ArrayList<Line>();
        ArrayList<Line> resultlinesb = new ArrayList<Line>();
        boolean bhadmatches = false;
        for (Line lineb : linesb) {
            boolean match = false;
            for (Line linea : linesa) {
                if (!MapController.areLinesSame(linea, lineb)) continue;
                match = true;
                break;
            }
            if (match) {
                bhadmatches = true;
                continue;
            }
            if (bhadmatches) {
                resultlinesb.add(lineb);
                continue;
            }
            linesbeforematchb.add(lineb);
        }
        resultlinesb.addAll(linesbeforematchb);
        Polygon p = new Polygon();
        for (Line l : resultlinesa) {
            p.getPoints().add((Object)l.getStartX());
            p.getPoints().add((Object)l.getStartY());
        }
        for (Line l : resultlinesb) {
            p.getPoints().add((Object)l.getStartX());
            p.getPoints().add((Object)l.getStartY());
        }
        return p;
    }

    static boolean areLinesSame(Line a, Line b) {
        double diffx1 = Math.abs(a.getStartX() - b.getEndX());
        double diffx2 = Math.abs(a.getEndX() - b.getStartX());
        double diffy1 = Math.abs(a.getStartY() - b.getEndY());
        double diffy2 = Math.abs(a.getEndY() - b.getStartY());
        return diffx1 < 5.0 && diffx2 < 5.0 && diffy1 < 5.0 && diffy2 < 5.0;
    }

    public UndoRedoHandler getUndoRedoHandler() {
        return this.undoRedoHandler;
    }

    public void regenerateResources(ViewLevel vl) {
        Terrain[][] t;
        Terrain[][] terrainArray = t = this.mapData.getTerrain(vl);
        int n = terrainArray.length;
        for (int i = 0; i < n; ++i) {
            Terrain[] terrains;
            for (Terrain terrain : terrains = terrainArray[i]) {
                terrain.generateResources();
            }
        }
    }

    public Feature placeFeature(ViewLevel vl, Point2D pt, String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, boolean hflip, boolean vflip, int labeldist, double labelpos, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer layer, String style, String text, String fontFace, Color labelcolor, double outlineSize, Color outlineColor, Color backgroundColor, double labelrotate, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, boolean isBold, boolean isItalic, boolean gmOnly, double labelScaleFactor, String labeltags, FeatureDecoration[] fds, double labelScale) {
        UndoActionGroup uag = new UndoActionGroup();
        Feature f = this.placeFeature(uag, vl, pt, t, placefreely, hideterrainicon, isgmonly, fillhexbottom, ring, rotate, overridecolor, scale, scaleHt, hflip, vflip, labeldist, labelpos, tags, isworld, iscontinent, iskingdom, isprovince, layer, style, text, fontFace, labelcolor, outlineSize, outlineColor, backgroundColor, labelrotate, isWorld, isContinent, isKingdom, isProvince, isBold, isItalic, gmOnly, labelScaleFactor, labeltags, fds, labelScale);
        this.getUndoRedoHandler().push(uag);
        return f;
    }

    public Feature placeFeature(UndoActionGroup uag, ViewLevel vl, Point2D pt, String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, boolean hflip, boolean vflip, int labeldist, double labelpos, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer layer, String style, String text, String fontFace, Color labelcolor, double outlineSize, Color outlineColor, Color backgroundColor, double labelrotate, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, boolean isBold, boolean isItalic, boolean gmOnly, double labelScaleFactor, String labeltags, FeatureDecoration[] fds, double labelScale) {
        Feature fclone = this.createFeature(vl, t, placefreely, hideterrainicon, isgmonly, fillhexbottom, ring, rotate, overridecolor, scale, scaleHt, hflip, vflip, labeldist, labelpos, tags, isworld, iscontinent, iskingdom, isprovince, layer, style, text, fontFace, labelcolor, outlineSize, outlineColor, backgroundColor, labelrotate, isWorld, isContinent, isKingdom, isProvince, isBold, isItalic, gmOnly, labelScaleFactor, labeltags, fds);
        if (t.toLowerCase().startsWith("structure")) {
            Note n = new Note(ViewLevel.SETTLEMENT, pt.getX(), pt.getY());
            n.setTitle(CityDataGenerator.getName(t));
            n.setDetails(MapLogic.createStructureNoteDetails(t, pt.getX(), pt.getY()));
            n.setParent(fclone);
            this.mapUI.getMapData().getNotes().add(n);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.NOTE, n, null, null, null, null, null));
        }
        this.mapData.addNewFeature(vl, uag, fclone, pt.getX(), pt.getY());
        fclone.getLabel().setLocationAndScale(vl, (Pair<Point2D, Double>)new Pair((Object)fclone.getLocation(vl), (Object)labelScale));
        return fclone;
    }

    public Feature createFeature(ViewLevel vl, String t, boolean placefreely, boolean hideterrainicon, boolean isgmonly, boolean fillhexbottom, Color ring, double rotate, Color overridecolor, double scale, double scaleHt, boolean hflip, boolean vflip, int labeldist, double labelpos, String tags, boolean isworld, boolean iscontinent, boolean iskingdom, boolean isprovince, MapLayer layer, String style, String text, String fontFace, Color labelcolor, double outlineSize, Color outlineColor, Color backgroundColor, double labelrotate, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, boolean isBold, boolean isItalic, boolean gmOnly, double adjustScaleFactor, String labeltags, FeatureDecoration[] fds) {
        MapLabel ml = new MapLabel(style, text, fontFace, labelcolor, outlineSize, outlineColor, backgroundColor, labelrotate, isWorld, isContinent, isKingdom, isProvince, isBold, isItalic, gmOnly, TextAlignment.CENTER, labeltags, layer);
        Feature fclone = new Feature(t, placefreely, hideterrainicon, isgmonly, fillhexbottom, ring, rotate, overridecolor, scale, scaleHt, hflip, vflip, ml, labeldist, labelpos, tags, isworld, iscontinent, iskingdom, isprovince, layer);
        if (fds != null) {
            for (int index = 0; index < fds.length; ++index) {
                fclone.getFeatureDecorations()[index] = fds[index];
            }
        }
        return fclone;
    }

    public void createOrUpdateFeatureMapLabel(boolean undoEnabled, Feature f, String style, String text, String fontFace, Color labelcolor, double outlineSize, Color outlineColor, Color backgroundColor, double labelrotate, boolean isBold, boolean isItalic, MapLayer layer) {
        MapLabel ml = f.getLabel();
        if (ml == null) {
            if (layer == null && (layer = this.mapUI.getMapData().getMapLayer("Features")) == null) {
                layer = new MapLayer("Features");
                this.mapUI.getMapData().getMapLayers().add(1, layer);
            }
            ml = new MapLabel(style, text, fontFace, labelcolor, outlineSize, outlineColor, backgroundColor, labelrotate, false, false, false, false, isBold, isItalic, false, TextAlignment.CENTER, null, layer);
            if (undoEnabled) {
                this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LABEL, UndoAction.Thing.FEATURE, f, ml, null, "text", null, null));
            }
            f.setLabel(ml);
        } else {
            if (undoEnabled) {
                this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LABEL, UndoAction.Thing.FEATURE, f, text, ml.getText(), "text", null, null));
            }
            ml.setText(text);
        }
    }

    public void deleteFeature(Feature f, UndoActionGroup uag) {
        boolean pushhere = false;
        if (uag == null) {
            uag = new UndoActionGroup();
            pushhere = true;
        }
        for (Note n : this.mapUI.getMapData().getNotes()) {
            if (n.getParent() != f) continue;
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.NOTE, n, null, null, null, null, null));
            this.mapUI.getMapData().getNotes().remove(n);
            break;
        }
        this.mapData.getFeatures().remove(f);
        uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.FEATURE, f, null, null, null, null, null));
        if (pushhere) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void deleteNote(Note n, UndoActionGroup uag) {
        this.mapData.getNotes().remove(n);
        uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.NOTE, n, null, null, null, null, null));
    }

    public void addExtraTerrain(Terrain terrain, MapLayer ml, Pair<Double, Double> modelCoords, UndoActionGroup uag) {
        if (ml.getName().equals("Terrain Land") || ml.getName().equals("Terrain Water")) {
            return;
        }
        boolean pushHere = false;
        if (uag == null) {
            uag = new UndoActionGroup();
            pushHere = true;
        }
        Pair mapLayerAndLocation = new Pair((Object)ml, (Object)new Point((Double)modelCoords.getKey(), (Double)modelCoords.getValue()));
        terrain.setMapLayerAndLocation((Pair<MapLayer, Point>)mapLayerAndLocation);
        Map<Point, Terrain> terrainOnLayer = this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey());
        if (terrainOnLayer == null) {
            terrainOnLayer = new HashMap<Point, Terrain>();
            this.mapData.getExtraTerrainByLayer().put((MapLayer)mapLayerAndLocation.getKey(), terrainOnLayer);
        }
        terrainOnLayer.put((Point)mapLayerAndLocation.getValue(), terrain);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.TERRAIN, terrain, null, null, mapLayerAndLocation, null, null));
        if (pushHere) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public Pair<MapLayer, Point> deleteTerrain(Terrain terrain, UndoActionGroup uag) {
        Pair mapLayerAndLocation;
        boolean pushhere = false;
        if (uag == null) {
            uag = new UndoActionGroup();
            pushhere = true;
        }
        if ((mapLayerAndLocation = terrain.getMapLayerAndLocation()) != null) {
            Map<Point, Terrain> locAndTerrain = this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey());
            locAndTerrain.remove(mapLayerAndLocation.getValue());
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.TERRAIN, terrain, null, null, mapLayerAndLocation, null, null));
        } else if (terrain.getGridTempX() >= 0 && terrain.getGridTempY() >= 0) {
            ArrayList<Terrain> terrainList = new ArrayList<Terrain>();
            terrainList.add(new Terrain("Border Only", true));
            Point2D coords = new Point2D((double)terrain.getGridTempX(), (double)terrain.getGridTempY());
            this.mapData.changeTerrain(uag, terrainList, coords, this.mapUI.viewLevel, this.mapUI.viewLevel, false, terrain.getBackgroundColor(), terrain.isGmOnly(), terrain.isIcy(), false, terrain.getElevation(), terrain.getExtraInfo().getResources());
            mapLayerAndLocation = new Pair((Object)new MapLayer("Temp"), (Object)new Point(terrain.getGridTempX(), terrain.getGridTempY()));
        }
        if (pushhere) {
            this.getUndoRedoHandler().push(uag);
        }
        return mapLayerAndLocation;
    }

    public void updateFeatureTags(boolean undoEnabled, Feature f, String tags) {
        Feature old = f.clone();
        f.setTags(tags);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureMapLayer(boolean undoEnabled, Feature f, MapLayer ml) {
        Feature old = f.clone();
        if (old.getMapLayer() != null && old.getMapLayer().equals(ml)) {
            return;
        }
        f.setMapLayer(ml);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureHideTerrainIcon(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        f.setHideTerrainIcon(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "hideterrainicon", null, null));
        }
    }

    public void updateFeaturePlaceFreely(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        f.setPlaceFreely(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "placefreely", null, null));
        }
    }

    public void updateFeatureOverrideColor(Feature f, Color newval) {
        Feature old = f.clone();
        f.setOverrideColor(newval);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
    }

    public void updateFeatureFillHexBottom(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        f.setFillHexBottom(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "fillhexbottom", null, null));
        }
    }

    public void updateFeatureRingColor(Feature f, Color newval) {
        Feature old = f.clone();
        f.setRing(newval);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "ring", null, null));
    }

    public void updateFeatureScale(boolean undoEnabled, Feature f, Double newval) {
        Feature old = f.clone();
        f.setScale(newval);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureScaleHt(boolean undoEnabled, Feature f, Double newval) {
        Feature old = f.clone();
        f.setScaleHt(newval);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureRotate(boolean undoEnabled, Feature f, Double newval) {
        Feature old = f.clone();
        f.setRotate(newval);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureFlipHorizontal(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        f.setHorizontalFlip(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateFeatureFlipVertical(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        f.setVerticalFlip(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
        }
    }

    public void updateGMOnly(boolean undoEnabled, List<MapObject> mapobjects, boolean selected) {
        for (MapObject mo : mapobjects) {
            MapObject old = mo.clone();
            mo.setGmOnly(selected);
            UndoAction.Thing thing = UndoAction.Thing.FEATURE;
            if (mo instanceof Terrain) {
                thing = UndoAction.Thing.TERRAIN;
            } else if (mo instanceof MapShape) {
                thing = UndoAction.Thing.MAP_SHAPE;
            } else if (mo instanceof MapLabel) {
                thing = UndoAction.Thing.LABEL;
            }
            if (!undoEnabled) continue;
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, thing, mo, mo.clone(), old, null, null, null));
        }
    }

    public void updateFeatureWorld(boolean undoEnabled, Feature f, boolean selected) {
        Feature old = f.clone();
        Point2D oldloc = f.getLocation(ViewLevel.WORLD);
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && oldloc == null) {
                this.mapUI.getMapData().updateFeatureLocationNewLevel(this.mapUI.viewLevel, ViewLevel.WORLD, f);
            }
        } else {
            f.setLocation(ViewLevel.WORLD, null);
        }
        f.setWorld(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "world", oldloc, f.getLocation(ViewLevel.WORLD)));
        }
    }

    public void updateFeatureContinent(boolean undoEnabled, Feature f, boolean selected) {
        Point2D oldloc = f.getLocation(ViewLevel.CONTINENT);
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && oldloc == null) {
                this.mapUI.getMapData().updateFeatureLocationNewLevel(this.mapUI.viewLevel, ViewLevel.CONTINENT, f);
            }
        } else {
            f.setLocation(ViewLevel.CONTINENT, null);
        }
        Feature old = f.clone();
        f.setContinent(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "continent", oldloc, f.getLocation(ViewLevel.CONTINENT)));
        }
    }

    public void updateFeatureKingdom(boolean undoEnabled, Feature f, boolean selected) {
        Point2D oldloc = f.getLocation(ViewLevel.KINGDOM);
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && oldloc == null) {
                this.mapUI.getMapData().updateFeatureLocationNewLevel(this.mapUI.viewLevel, ViewLevel.KINGDOM, f);
            }
        } else {
            f.setLocation(ViewLevel.KINGDOM, null);
        }
        Feature old = f.clone();
        f.setKingdom(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "kingdom", oldloc, f.getLocation(ViewLevel.KINGDOM)));
        }
    }

    public void updateFeatureProvince(boolean undoEnabled, Feature f, boolean selected) {
        Point2D oldloc = f.getLocation(ViewLevel.PROVINCE);
        if (selected) {
            if (this.mapData.getView().getContinentFactor() > 0 && oldloc == null) {
                this.mapData.updateFeatureLocationNewLevel(this.mapUI.viewLevel, ViewLevel.PROVINCE, f);
            }
        } else {
            f.setLocation(ViewLevel.PROVINCE, null);
        }
        Feature old = f.clone();
        f.setProvince(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "province", oldloc, f.getLocation(ViewLevel.PROVINCE)));
        }
    }

    public void updateFeatureLabelDistance(boolean undoEnabled, Feature f, int newValue) {
        Feature old = f.clone();
        f.setLabelDistance(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "distance", null, null));
        }
    }

    public void updateFeatureLabelPosition(boolean undoEnabled, Feature f, Double newValue) {
        Feature old = f.clone();
        f.setLabelPosition(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "position", null, null));
        }
    }

    public void updateFeatureLabelRotation(boolean undoEnabled, Feature f, Double newValue) {
        Feature old = f.clone();
        f.getLabel().setRotate(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, "label rotation", null, null));
        }
    }

    public void updateFeatureDecoration(boolean undoEnabled, Feature f, int index, FeatureDecoration fd) {
        Feature old = f.clone();
        f.getFeatureDecorations()[index] = fd == null ? null : new FeatureDecoration(fd.getText(), fd.getColor(), fd.getLocation());
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, index, null, null));
        }
    }

    public void updateFeatureDecorationString(boolean undoEnabled, Feature f, int index, String newValue) {
        Feature old = f.clone();
        f.getFeatureDecorations()[index].setText(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, index, null, null));
        }
    }

    public void updateFeatureDecorationLocation(boolean undoEnabled, Feature f, int index, Double loc) {
        Feature old = f.clone();
        f.getFeatureDecorations()[index].setLocation(loc);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, index, null, null));
        }
    }

    public void updateFeatureDecorationColor(boolean undoEnabled, Feature f, int index, Color color) {
        Feature old = f.clone();
        f.getFeatureDecorations()[index].setColor(color);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, index, null, null));
        }
    }

    public boolean moveFeatureTop(List<MapObject> mapobjects) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapobjects) {
            if (!(mo instanceof Feature)) continue;
            Feature feature = (Feature)mo;
            int oldindex = this.mapUI.getMapData().getFeatures().indexOf(feature);
            this.mapUI.getMapData().getFeatures().remove(feature);
            this.mapUI.getMapData().getFeatures().add(feature);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, this.mapUI.getMapData().getFeatures().indexOf(feature), oldindex, null, null, null));
        }
        if (uag.getActions().size() > 0) {
            this.getUndoRedoHandler().push(uag);
            return true;
        }
        return false;
    }

    public boolean moveFeatureBottom(List<MapObject> mapobjects) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapobjects) {
            if (!(mo instanceof Feature)) continue;
            Feature feature = (Feature)mo;
            int oldindex = this.mapUI.getMapData().getFeatures().indexOf(feature);
            this.mapUI.getMapData().getFeatures().remove(feature);
            this.mapUI.getMapData().getFeatures().add(0, feature);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, this.mapUI.getMapData().getFeatures().indexOf(feature), oldindex, null, null, null));
        }
        if (uag.getActions().size() > 0) {
            this.getUndoRedoHandler().push(uag);
            return true;
        }
        return false;
    }

    public boolean moveFeatureDown(List<MapObject> mapobjects) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapobjects) {
            if (!(mo instanceof Feature)) continue;
            Feature feature = (Feature)mo;
            int oldindex = this.mapUI.getMapData().getFeatures().indexOf(feature);
            Point2D pt = feature.getLocation(this.mapUI.viewLevel);
            double x = pt.getX() - feature.getScaleFallbackType() * 1.5;
            double y = pt.getY() - (feature.getScaleHtFallbackType() > 0.0 ? feature.getScaleHtFallbackType() * 1.5 : feature.getScaleFallbackType() * 1.5);
            double oppx = pt.getX() + feature.getScaleFallbackType() * 1.5;
            double oppy = pt.getY() + (feature.getScaleHtFallbackType() > 0.0 ? feature.getScaleHtFallbackType() * 1.5 : feature.getScaleFallbackType() * 1.5);
            Polygon featureshape = new Polygon();
            featureshape.getPoints().addAll((Object[])new Double[]{x, y, oppx, y, oppx, oppy, x, oppy});
            this.mapUI.getMapData().getFeatures().remove(feature);
            boolean readded = false;
            for (int i = oldindex - 1; i >= 0; --i) {
                Feature f = this.mapUI.getMapData().getFeatures().get(i);
                Point2D fpt = f.getLocation(this.mapUI.viewLevel);
                double fx = fpt.getX() - f.getScaleFallbackType() * 1.5;
                double fy = fpt.getY() - (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                double foppx = fpt.getX() + f.getScaleFallbackType() * 1.5;
                double foppy = fpt.getY() + (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                Polygon fshape = new Polygon();
                fshape.getPoints().addAll((Object[])new Double[]{fx, fy, foppx, fy, foppx, foppy, fx, foppy});
                if (!featureshape.intersects(fshape.getBoundsInLocal())) continue;
                this.mapUI.getMapData().getFeatures().add(Math.min(this.mapUI.getMapData().getFeatures().size(), i), feature);
                uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, this.mapUI.getMapData().getFeatures().indexOf(feature), oldindex, null, null, null));
                readded = true;
                break;
            }
            if (readded) continue;
            this.mapUI.getMapData().getFeatures().add(0, feature);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, this.mapUI.getMapData().getFeatures().indexOf(feature), oldindex, null, null, null));
        }
        if (uag.getActions().size() > 0) {
            this.getUndoRedoHandler().push(uag);
            return true;
        }
        return false;
    }

    public boolean moveFeatureUp(List<MapObject> mapobjects) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapobjects) {
            if (!(mo instanceof Feature)) continue;
            Feature feature = (Feature)mo;
            int oldindex = this.mapUI.getMapData().getFeatures().indexOf(feature);
            Point2D pt = feature.getLocation(this.mapUI.viewLevel);
            double x = pt.getX() - feature.getScaleFallbackType() * 1.5;
            double y = pt.getY() - (feature.getScaleHtFallbackType() > 0.0 ? feature.getScaleHtFallbackType() * 1.5 : feature.getScaleFallbackType() * 1.5);
            double oppx = pt.getX() + feature.getScaleFallbackType() * 1.5;
            double oppy = pt.getY() + (feature.getScaleHtFallbackType() > 0.0 ? feature.getScaleHtFallbackType() * 1.5 : feature.getScaleFallbackType() * 1.5);
            Polygon featureshape = new Polygon();
            featureshape.getPoints().addAll((Object[])new Double[]{x, y, oppx, y, oppx, oppy, x, oppy});
            this.mapUI.getMapData().getFeatures().remove(feature);
            boolean readded = false;
            for (int i = oldindex; i < this.mapUI.getMapData().getFeatures().size(); ++i) {
                Feature f = this.mapUI.getMapData().getFeatures().get(i);
                Point2D fpt = f.getLocation(this.mapUI.viewLevel);
                double fx = fpt.getX() - f.getScaleFallbackType() * 1.5;
                double fy = fpt.getY() - (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                double foppx = fpt.getX() + f.getScaleFallbackType() * 1.5;
                double foppy = fpt.getY() + (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                Polygon fshape = new Polygon();
                fshape.getPoints().addAll((Object[])new Double[]{fx, fy, foppx, fy, foppx, foppy, fx, foppy});
                if (!featureshape.intersects(fshape.getBoundsInLocal())) continue;
                int newindex = Math.min(this.mapUI.getMapData().getFeatures().size(), i + 1);
                this.mapUI.getMapData().getFeatures().add(newindex, feature);
                uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, newindex, oldindex, null, null, null));
                readded = true;
                break;
            }
            if (readded) continue;
            this.mapUI.getMapData().getFeatures().add(feature);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.FEATURE, feature, this.mapUI.getMapData().getFeatures().indexOf(feature), oldindex, null, null, null));
        }
        if (uag.getActions().size() > 0) {
            this.getUndoRedoHandler().push(uag);
            return true;
        }
        return false;
    }

    public void renameLayer(MapLayer mapLayer, String newName) {
        UndoActionGroup uag = new UndoActionGroup();
        String oldName = mapLayer.getName();
        mapLayer.setName(newName);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LAYER, mapLayer, newName, oldName, null, null, null));
        this.getUndoRedoHandler().push(uag);
    }

    public void placeMapLabel(ViewLevel vl, String style, String text, String fontFace, Color color, double outlineSize, Color outlineColor, Color backgroundColor, double rotate, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, boolean isBold, boolean isItalic, boolean gmOnly, TextAlignment textAlign, double adjustScaleFactor, String tags, MapLayer layer, Point2D pt, double scale) {
        if (layer == null && (layer = this.mapUI.getMapData().getMapLayer("Labels")) == null) {
            layer = new MapLayer("Labels");
            this.mapUI.getMapData().getMapLayers().add(1, layer);
        }
        MapLabel ml = new MapLabel(style, text, fontFace, color, outlineSize, outlineColor, backgroundColor, rotate, isWorld, isContinent, isKingdom, isProvince, isBold, isItalic, gmOnly, textAlign, tags, layer);
        this.mapData.addNewMapLabel(this.mapUI.getViewLevel(), ml, pt, scale);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LABEL, ml, null, null, null, null, null));
    }

    public void deleteLabel(MapLabel label) {
        this.mapUI.getMapData().getMapLabels().remove(label);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.LABEL, label, null, null, null, null, null));
    }

    public void updateLabelColor(boolean undoEnabled, MapLabel label, Color newValue) {
        MapLabel old = label.clone();
        label.setColor(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelOutlineSize(boolean undoEnabled, MapLabel label, Double newValue) {
        MapLabel old = label.clone();
        label.setOutlineSize(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelOutlineColor(boolean undoEnabled, MapLabel label, Color newValue) {
        MapLabel old = label.clone();
        label.setOutlineColor(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelScale(boolean undoEnabled, MapLabel label, Double oldValue, Double newValue) {
        MapLabel old = label.clone();
        Point2D oldlocation = label.getLocation(this.mapUI.viewLevel);
        old.setLocationAndScale(this.mapUI.viewLevel, (Pair<Point2D, Double>)new Pair((Object)oldlocation, (Object)oldValue));
        Point2D location = label.getLocation(this.mapUI.viewLevel);
        label.setLocationAndScale(this.mapUI.viewLevel, (Pair<Point2D, Double>)new Pair((Object)location, (Object)newValue));
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelBold(boolean undoEnabled, MapLabel label, boolean isBold) {
        MapLabel old = label.clone();
        label.setBold(isBold);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelItalic(boolean undoEnabled, MapLabel label, boolean isItalic) {
        MapLabel old = label.clone();
        label.setItalic(isItalic);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelBackgroundColor(boolean undoEnabled, MapLabel label, Color newValue) {
        MapLabel old = label.clone();
        label.setBackgroundColor(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, "background", null, null));
        }
    }

    public void updateLabelFontFace(boolean undoEnabled, MapLabel label, String newValue) {
        MapLabel old = label.clone();
        label.setFontFace(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelText(boolean undoEnabled, MapLabel label, String newValue) {
        MapLabel old = label.clone();
        label.setText(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelRotate(boolean undoEnabled, MapLabel label, double newValue, double oldValue) {
        MapLabel old = label.clone();
        old.setRotate(oldValue);
        label.setRotate(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelTextAlignment(boolean undoEnabled, MapLabel label, TextAlignment newValue) {
        MapLabel old = label.clone();
        label.setTextAlignment(newValue);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelLayer(boolean undoEnabled, MapLabel label, MapLayer newValue) {
        MapLabel old = label.clone();
        label.setMapLayer(newValue);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelStyle(boolean undoEnabled, MapLabel label, String newValue) {
        MapLabel old = label.clone();
        label.setStyle(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelProvince(boolean undoEnabled, MapLabel label, boolean selected) {
        MapLabel old = label.clone();
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && label.getLocation(ViewLevel.PROVINCE) == null) {
                this.mapUI.getMapData().updateMapLabelLocationNewLevel(this.mapUI.viewLevel, ViewLevel.PROVINCE, label);
            }
        } else {
            label.setLocationAndScale(ViewLevel.PROVINCE, null);
        }
        label.setProvince(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, "province", null, null));
        }
    }

    public void updateLabelKingdom(boolean undoEnabled, MapLabel label, boolean selected) {
        MapLabel old = label.clone();
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && label.getLocation(ViewLevel.KINGDOM) == null) {
                this.mapUI.getMapData().updateMapLabelLocationNewLevel(this.mapUI.viewLevel, ViewLevel.KINGDOM, label);
            }
        } else {
            label.setLocationAndScale(ViewLevel.KINGDOM, null);
        }
        label.setKingdom(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, "kingdom", null, null));
        }
    }

    public void updateLabelContinent(boolean undoEnabled, MapLabel label, boolean selected) {
        MapLabel old = label.clone();
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0 && label.getLocation(ViewLevel.CONTINENT) == null) {
                this.mapUI.getMapData().updateMapLabelLocationNewLevel(this.mapUI.viewLevel, ViewLevel.CONTINENT, label);
            }
        } else {
            label.setLocationAndScale(ViewLevel.CONTINENT, null);
        }
        label.setContinent(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, "continent", null, null));
        }
    }

    public void updateLabelWorld(boolean undoEnabled, MapLabel label, boolean selected) {
        MapLabel old = label.clone();
        if (selected) {
            if (this.mapUI.getMapData().getView().getContinentFactor() > 0) {
                this.mapUI.getMapData().updateMapLabelLocationNewLevel(this.mapUI.viewLevel, ViewLevel.WORLD, label);
            }
        } else {
            label.setLocationAndScale(ViewLevel.WORLD, null);
        }
        label.setWorld(selected);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, "world", null, null));
        }
    }

    public void updateLabelScaleFactor(boolean undoEnabled, MapLabel label, Double newValue, ViewLevel currentVL, UndoActionGroup uag) {
        MapLabel old = label.clone();
        label.clearOtherLocationsAndScales(currentVL);
        ViewLevel[] cLevels = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE};
        ViewLevel[] nLevels = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE};
        for (ViewLevel cl : cLevels) {
            for (ViewLevel nl : nLevels) {
                if (cl == nl || this.mapData.getTerrain(cl) == null || this.mapData.getTerrain(nl) == null) continue;
                label.updateLocation(cl, nl, this.mapData);
            }
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void updateLabelTags(boolean undoEnabled, MapLabel label, String newValue) {
        MapLabel old = label.clone();
        label.setTags(newValue);
        if (undoEnabled) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, label, label.clone(), old, null, null, null));
        }
    }

    public void placeShapeOrAddPoints(Point2D modelpt, Point2D snapmodelpt, boolean isAltDown, boolean useMoveTo, Shape shape, MapShape.CreationType creationtype, MapShape.StrokeType stroketype, boolean gmonly, String tags, double extraListDistance, double extraLineLength, double extraLineWidth, double extraLineSeparation, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, MapLayer layer, double strokewidth, double opacity, boolean snapvertices, boolean matchtileborders, boolean dropshadow, Color dropshadowcolor, double dropshadowoffsetx, double dropshadowoffsety, double dropshadowspread, double dropshadowradius, boolean innershadow, Color innercolor, double inneroffsetx, double inneroffsety, double innerchoke, double innerradius, boolean boxblur, double boxblurwidth, double boxblurheight, int boxbluriters, StrokeLineCap strokelinecap, StrokeLineJoin strokelinejoin, boolean iscolorfill, Color colorfill, boolean istexturefill, TextureType texturetype, boolean iscolorstroke, Color strokecolor, boolean istexturestroke, TextureType texturestroke, boolean isFractal, double arcStart, double arcExtent, ArcType arcType) {
        UndoActionGroup uag = new UndoActionGroup();
        this.getUndoRedoHandler().push(uag);
        if (this.mapUI.getCurrentObjects().size() == 0) {
            MapShape ms = this.createNewCurrentShape(this.mapUI.viewLevel, shape, creationtype, stroketype, gmonly, tags, extraListDistance, extraLineLength, extraLineWidth, extraLineSeparation, isWorld, isContinent, isKingdom, isProvince, layer, strokewidth, opacity, snapvertices, matchtileborders, dropshadow, dropshadowcolor, dropshadowoffsetx, dropshadowoffsety, dropshadowspread, dropshadowradius, innershadow, innercolor, inneroffsetx, inneroffsety, innerchoke, innerradius, boxblur, boxblurwidth, boxblurheight, boxbluriters, strokelinecap, strokelinejoin, iscolorfill, colorfill, istexturefill, texturetype, iscolorstroke, strokecolor, istexturestroke, texturestroke);
            if (ms != null) {
                this.mapData.getShapes().add(ms);
            }
            this.mapUI.getCurrentObjects().add(ms);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, ms, null, null, null, null));
        }
        for (MapObject mo : this.mapUI.getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            if (matchtileborders && ms.getShape() instanceof Polygon) {
                Polygon p;
                Pair<Integer, Integer> terrainloc = this.mapUI.getTerrainFromModelPt(modelpt.getX(), modelpt.getY());
                Point2D pt = this.mapUI.canvas.calculateTerrainPointXY((Integer)terrainloc.getKey(), (Integer)terrainloc.getValue(), 0.0, 0.0, 300.0, 300.0);
                double basex = pt.getX();
                double basey = pt.getY();
                double w = 300.0;
                double h = 300.0;
                if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
                    pts = new double[]{basex, (int)(basey + h / 2.0), basex + w / 4.0, (int)(basey + h), basex + w * 3.0 / 4.0, basey + h, basex + w, basey + h / 2.0, basex + w * 3.0 / 4.0, basey, basex + w / 4.0, basey};
                    p = new Polygon(pts);
                } else if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
                    pts = new double[]{(int)(basex + w / 2.0), (int)(basey + h), (int)(basex + w), (int)(basey + h * 3.0 / 4.0 + 0.5), (int)(basex + w), (int)(basey + h / 4.0 + 0.5), (int)(basex + w / 2.0), basey, basex, (int)(basey + h / 4.0 + 0.5), basex, (int)(basey + h * 3.0 / 4.0 + 0.5)};
                    p = new Polygon(pts);
                } else {
                    pts = new double[]{basex, basey, basex, basey + h, basex + w, basey + h, basex + w, basey};
                    p = new Polygon(pts);
                }
                Paint fill = ms.getShape().getFill();
                ms.getShape().setFill((Paint)Color.ALICEBLUE);
                boolean containsmodelpt = ms.getShape().contains(modelpt);
                ms.getShape().setFill(fill);
                if (ms.getShape() instanceof Path) {
                    List<Point2D> pts = ms.getShapePoints();
                    double[] ds = new double[pts.size() * 2 + 2];
                    int count = 0;
                    for (Point2D ptd : pts) {
                        ds[count] = ptd.getX();
                        ds[++count] = ptd.getY();
                        ++count;
                    }
                    ds[ds.length - 2] = ds[0];
                    ds[ds.length - 1] = ds[1];
                    Polygon p2 = new Polygon(ds);
                    p2.setFill(ms.getShape().getFill());
                    ms.setShape((Shape)p2);
                }
                MapShape oldms = ms.clone();
                if (containsmodelpt) {
                    Shape oldshape = ms.getShape();
                    ms.setShape((Shape)this.subtractPolygon((Polygon)oldshape, p));
                    this.updateCurrentShapeSettings(ms, strokewidth, opacity, snapvertices, matchtileborders, dropshadow, dropshadowcolor, dropshadowoffsetx, dropshadowoffsety, dropshadowspread, dropshadowradius, innershadow, innercolor, inneroffsetx, inneroffsety, innerchoke, innerradius, boxblur, boxblurwidth, boxblurheight, boxbluriters, strokelinecap, strokelinejoin, iscolorfill, colorfill, istexturefill, texturetype, iscolorstroke, strokecolor, istexturestroke, texturestroke);
                    uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.SHAPE_PTS, ms, ms.getShape(), oldshape, null, null, null));
                    continue;
                }
                if (ms.getShapePoints().size() == 0) {
                    ms.setShape((Shape)p);
                    this.updateCurrentShapeSettings(ms, strokewidth, opacity, snapvertices, matchtileborders, dropshadow, dropshadowcolor, dropshadowoffsetx, dropshadowoffsety, dropshadowspread, dropshadowradius, innershadow, innercolor, inneroffsetx, inneroffsety, innerchoke, innerradius, boxblur, boxblurwidth, boxblurheight, boxbluriters, strokelinecap, strokelinejoin, iscolorfill, colorfill, istexturefill, texturetype, iscolorstroke, strokecolor, istexturestroke, texturestroke);
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, ms, null, null, null, null));
                } else {
                    Shape intersect;
                    boolean shapefillwasnull = false;
                    Shape oldshape = ms.getShape();
                    if (oldshape.getFill() == null) {
                        shapefillwasnull = true;
                        oldshape.setFill((Paint)new Color(1.0, 1.0, 1.0, 1.0));
                    }
                    if (!((intersect = Shape.intersect((Shape)ms.getShape(), (Shape)p)) instanceof Path) || ((Path)intersect).getElements().size() == 0) {
                        return;
                    }
                    ms.setShape((Shape)MapController.makeCombinedPolygon((Polygon)oldshape, p));
                    if (shapefillwasnull) {
                        oldshape.setFill(null);
                    }
                    this.updateCurrentShapeSettings(ms, strokewidth, opacity, snapvertices, matchtileborders, dropshadow, dropshadowcolor, dropshadowoffsetx, dropshadowoffsety, dropshadowspread, dropshadowradius, innershadow, innercolor, inneroffsetx, inneroffsety, innerchoke, innerradius, boxblur, boxblurwidth, boxblurheight, boxbluriters, strokelinecap, strokelinejoin, iscolorfill, colorfill, istexturefill, texturetype, iscolorstroke, strokecolor, istexturestroke, texturestroke);
                    uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.SHAPE_PTS, ms, ms.getShape(), oldshape, null, null, null));
                }
                uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), oldms, null, null, null));
                continue;
            }
            if (ms.isSnapVertices()) {
                modelpt = snapmodelpt;
            }
            if (this.mapUI.draggingObject != null) continue;
            this.addPointToShape(ms, uag, this.mapUI.viewLevel, modelpt, isAltDown, useMoveTo, -1, true, isFractal, arcStart, arcExtent, arcType);
        }
    }

    public void addShapeComplete(MapShape ms) {
        this.mapUI.getMapData().getShapes().add(ms);
        this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
    }

    public MapShape createNewCurrentShape(ViewLevel vl, Shape shape, MapShape.CreationType creationtype, MapShape.StrokeType stroketype, boolean gmonly, String tags, double extraLineDistance, double extraLineLength, double extraLineWidth, double extraLineSeparation, boolean isWorld, boolean isContinent, boolean isKingdom, boolean isProvince, MapLayer layer, double strokewidth, double opacity, boolean snapvertices, boolean matchtileborders, boolean dropshadow, Color dropshadowcolor, double dropshadowoffsetx, double dropshadowoffsety, double dropshadowspread, double dropshadowradius, boolean innershadow, Color innercolor, double inneroffsetx, double inneroffsety, double innerchoke, double innerradius, boolean boxblur, double boxblurwidth, double boxblurheight, int boxbluriters, StrokeLineCap strokelinecap, StrokeLineJoin strokelinejoin, boolean iscolorfill, Color colorfill, boolean istexturefill, TextureType texturetype, boolean iscolorstroke, Color strokecolor, boolean istexturestroke, TextureType texturestroke) {
        MapShape ms = new MapShape(vl, vl, shape, creationtype, stroketype, gmonly, tags, extraLineDistance, extraLineLength, extraLineWidth, extraLineSeparation, isWorld, isContinent, isKingdom, isProvince, layer);
        this.updateCurrentShapeSettings(ms, strokewidth, opacity, snapvertices, matchtileborders, dropshadow, dropshadowcolor, dropshadowoffsetx, dropshadowoffsety, dropshadowspread, dropshadowradius, innershadow, innercolor, inneroffsetx, inneroffsety, innerchoke, innerradius, boxblur, boxblurwidth, boxblurheight, boxbluriters, strokelinecap, strokelinejoin, iscolorfill, colorfill, istexturefill, texturetype, iscolorstroke, strokecolor, istexturestroke, texturestroke);
        return ms;
    }

    public void updateCurrentShapeSettings(MapShape ms, double strokewidth, double opacity, boolean snapvertices, boolean matchtileborders, boolean dropshadow, Color dropshadowcolor, double dropshadowoffsetx, double dropshadowoffsety, double dropshadowspread, double dropshadowradius, boolean innershadow, Color innercolor, double inneroffsetx, double inneroffsety, double innerchoke, double innerradius, boolean boxblur, double boxblurwidth, double boxblurheight, int boxbluriters, StrokeLineCap strokelinecap, StrokeLineJoin strokelinejoin, boolean iscolorfill, Color colorfill, boolean istexturefill, TextureType texturetype, boolean iscolorstroke, Color strokecolor, boolean istexturestroke, TextureType texturestroke) {
        if (ms == null || ms.getShape() == null) {
            return;
        }
        ms.getShape(this.mapData, this.mapUI.viewLevel).setStrokeWidth(strokewidth);
        ms.getShape(this.mapData, this.mapUI.viewLevel).setOpacity(opacity);
        ms.setSnapVertices(snapvertices);
        ms.setMatchTileBorders(matchtileborders);
        ms.setDropShadow(dropshadow);
        ms.setDsColor(dropshadowcolor);
        ms.setDsOffsetX(dropshadowoffsetx);
        ms.setDsOffsetY(dropshadowoffsety);
        ms.setDsSpread(dropshadowspread);
        ms.setDsRadius(dropshadowradius);
        ms.setInnerShadow(innershadow);
        ms.setInsColor(innercolor);
        ms.setInsOffsetX(inneroffsetx);
        ms.setInsOffsetY(inneroffsety);
        ms.setInsChoke(innerchoke);
        ms.setInsRadius(innerradius);
        ms.setBoxBlur(boxblur);
        ms.setBbWidth(boxblurwidth);
        ms.setBbHeight(boxblurheight);
        ms.setBbIterations(boxbluriters);
        ms.getShape().setStrokeLineCap(strokelinecap);
        ms.getShape().setStrokeLineJoin(strokelinejoin);
        if (iscolorfill) {
            ms.getShape(this.mapData, this.mapUI.viewLevel).setFill((Paint)colorfill);
        } else if (istexturefill && texturetype != null) {
            Image fillicon = texturetype.getIcon();
            ms.getShape(this.mapData, this.mapUI.viewLevel).setFill((Paint)new ImagePattern(fillicon, 0.0, 0.0, this.mapData.getTileWidth(), this.mapData.getTileHeight(), false));
            ms.setFillTexture(texturetype);
        } else {
            ms.getShape(this.mapData, this.mapUI.viewLevel).setFill(null);
        }
        if (iscolorstroke) {
            ms.getShape(this.mapData, this.mapUI.viewLevel).setStroke((Paint)strokecolor);
        } else if (istexturestroke && texturestroke != null) {
            ms.getShape(this.mapData, this.mapUI.viewLevel).setStroke((Paint)new ImagePattern(texturestroke.getIcon(), 0.0, 0.0, 50.0, 25.0, false));
            ms.setStrokeTexture(texturestroke);
        }
    }

    public void deletePointFromShape(boolean undoEnabled, MapShape ms, Point2D pt) {
        MapShape oldms = ms.clone();
        ms.removePoint(pt);
        MapShape newms = ms.clone();
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, newms, oldms, null, null, null));
        }
    }

    private void addPointToShape(MapShape ms, UndoActionGroup uag, ViewLevel vl, Point2D modelpt, boolean isAltDown, boolean useMoveTo, int position, boolean undoable, boolean isFractal, double arcStart, double arcExtent, ArcType arcType) {
        Shape origcenter;
        Shape shape;
        Polygon p;
        if (ms.getShape(this.mapData, vl) instanceof Polygon) {
            if (isAltDown || position >= 0) {
                p = (Polygon)ms.getShape(this.mapData, vl);
                this.insertPointInPolygon(modelpt, p, position, ms, undoable);
            } else if (isFractal) {
                ms.fractalize(uag, modelpt, 50, 8);
                if (undoable) {
                    this.getUndoRedoHandler().push(uag);
                }
            } else {
                p = (Polygon)ms.getShape(this.mapData, vl);
                p.getPoints().addAll((Object[])new Double[]{modelpt.getX(), modelpt.getY()});
                if (undoable) {
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, modelpt, null, null, null, null));
                }
            }
        }
        if ((shape = ms.getShape(this.mapData, vl)) instanceof Arc) {
            Arc a = (Arc)shape;
            a.setStartAngle(arcStart);
            a.setLength(arcExtent);
            a.setType(arcType);
            origcenter = new Point2D(a.getCenterX(), a.getCenterY());
            Point2D origradius = new Point2D(a.getRadiusX(), a.getRadiusY());
            if (a.getCenterX() == 0.0 && a.getCenterY() == 0.0) {
                a.setCenterX(modelpt.getX());
                a.setCenterY(modelpt.getY());
            } else {
                double x = modelpt.getX() - a.getCenterX();
                double y = modelpt.getY() - a.getCenterY();
                a.setRadiusX(Math.abs(x));
                a.setRadiusY(Math.abs(y));
            }
            if (undoable) {
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, new Point2D(a.getCenterX(), a.getCenterY()), origcenter, new Point2D(a.getRadiusX(), a.getRadiusY()), origradius, null));
            }
        }
        if ((origcenter = ms.getShape(this.mapData, vl)) instanceof Path) {
            p = (Path)origcenter;
            if (p.getElements().size() == 0) {
                moveTo = new MoveTo();
                moveTo.setX(modelpt.getX());
                moveTo.setY(modelpt.getY());
                p.getElements().add((Object)moveTo);
                if (undoable) {
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, moveTo, null, p.getElements().indexOf((Object)moveTo), null, null));
                }
            } else if (ms.getCreationType() == MapShape.CreationType.CURVE) {
                if (isAltDown) {
                    lineTo = new LineTo();
                    lineTo.setX(modelpt.getX());
                    lineTo.setY(modelpt.getY());
                    this.insertPointInPath(modelpt, (Path)p, lineTo, position, ms, undoable);
                } else if (this.mapUI.curveTo1 != null && this.mapUI.curveTo2 != null) {
                    CubicCurveTo cubicTo = new CubicCurveTo();
                    cubicTo.setControlX1(this.mapUI.curveTo1.getX());
                    cubicTo.setControlY1(this.mapUI.curveTo1.getY());
                    cubicTo.setControlX2(this.mapUI.curveTo2.getX());
                    cubicTo.setControlY2(this.mapUI.curveTo2.getY());
                    cubicTo.setX(modelpt.getX());
                    cubicTo.setY(modelpt.getY());
                    p.getElements().add((Object)cubicTo);
                    if (undoable) {
                        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, cubicTo, null, p.getElements().indexOf((Object)cubicTo), null, null));
                    }
                    this.mapUI.curveTo1 = null;
                    this.mapUI.curveTo2 = null;
                } else if (this.mapUI.curveTo1 == null) {
                    this.mapUI.curveTo1 = modelpt;
                } else {
                    this.mapUI.curveTo2 = modelpt;
                }
            } else if (useMoveTo) {
                moveTo = new MoveTo();
                moveTo.setX(modelpt.getX());
                moveTo.setY(modelpt.getY());
                p.getElements().add((Object)moveTo);
                if (undoable) {
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, moveTo, null, p.getElements().indexOf((Object)moveTo), null, null));
                }
            } else {
                lineTo = new LineTo();
                lineTo.setX(modelpt.getX());
                lineTo.setY(modelpt.getY());
                if (isAltDown) {
                    this.insertPointInPath(modelpt, (Path)p, lineTo, position, ms, undoable);
                } else if (isFractal) {
                    ms.fractalize(uag, modelpt, 50, 8);
                } else {
                    p.getElements().add((Object)lineTo);
                    if (undoable) {
                        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LINE_PT, ms, lineTo, null, p.getElements().indexOf((Object)lineTo), null, null));
                    }
                }
            }
        }
    }

    public void insertPointInPolygon(Point2D modelpt, Polygon p, int position, MapShape ms, boolean undoable) {
        double mindistance = Double.MAX_VALUE;
        int closestindex = -1;
        if (position >= 0) {
            closestindex = position;
        } else {
            for (int i = 0; i < p.getPoints().size(); i += 2) {
                double distance = modelpt.distance(((Double)p.getPoints().get(i)).doubleValue(), ((Double)p.getPoints().get(i + 1)).doubleValue());
                if (!(distance < mindistance)) continue;
                mindistance = distance;
                closestindex = i;
            }
            double priordistance = modelpt.distance(((Double)p.getPoints().get((p.getPoints().size() + closestindex - 2) % p.getPoints().size())).doubleValue(), ((Double)p.getPoints().get((p.getPoints().size() + closestindex - 1) % p.getPoints().size())).doubleValue());
            double nextdistance = modelpt.distance(((Double)p.getPoints().get((closestindex + 2) % p.getPoints().size())).doubleValue(), ((Double)p.getPoints().get((closestindex + 3) % p.getPoints().size())).doubleValue());
            if (nextdistance < priordistance) {
                closestindex += 2;
            }
        }
        MapShape msold = ms.clone();
        p.getPoints().add(closestindex, (Object)modelpt.getY());
        p.getPoints().add(closestindex, (Object)modelpt.getX());
        MapShape msnew = ms.clone();
        if (undoable) {
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, msnew, msold, closestindex, null, null));
        }
    }

    public void insertPointInPath(Point2D modelpt, Path p, LineTo lineTo, int position, MapShape ms, boolean undoable) {
        double mindistance = Double.MAX_VALUE;
        int closestindex = -1;
        if (position >= 0) {
            closestindex = position;
        } else {
            int count = 0;
            for (PathElement pe : p.getElements()) {
                double distance;
                if (pe instanceof LineTo && (distance = modelpt.distance(((LineTo)pe).getX(), ((LineTo)pe).getY())) < mindistance) {
                    mindistance = distance;
                    closestindex = count;
                }
                if (pe instanceof CubicCurveTo) {
                    distance = modelpt.distance(((CubicCurveTo)pe).getX(), ((CubicCurveTo)pe).getY());
                    if (distance < mindistance) {
                        mindistance = distance;
                        closestindex = count;
                    }
                } else if (pe instanceof MoveTo && (distance = modelpt.distance(((MoveTo)pe).getX(), ((MoveTo)pe).getY())) < mindistance) {
                    mindistance = distance;
                    closestindex = count;
                }
                ++count;
            }
        }
        if (closestindex == 0) {
            MapShape msold = ms.clone();
            p.getElements().add(0, (Object)lineTo);
            msnew = ms.clone();
            if (undoable) {
                this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, msnew, msold, closestindex, null, null));
            }
        } else if (closestindex == p.getElements().size() - 1) {
            MapShape msold = ms.clone();
            p.getElements().add(closestindex, (Object)lineTo);
            msnew = ms.clone();
            if (undoable) {
                this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, msnew, msold, closestindex, null, null));
            }
        } else {
            MapShape msold = ms.clone();
            PathElement priorpe = (PathElement)p.getElements().get(closestindex);
            double priordistance = Double.MAX_VALUE;
            if (priorpe instanceof LineTo) {
                priordistance = modelpt.distance(((LineTo)priorpe).getX(), ((LineTo)priorpe).getY());
            } else if (priorpe instanceof CubicCurveTo) {
                priordistance = modelpt.distance(((CubicCurveTo)priorpe).getX(), ((CubicCurveTo)priorpe).getY());
            } else if (priorpe instanceof MoveTo) {
                priordistance = modelpt.distance(((MoveTo)priorpe).getX(), ((MoveTo)priorpe).getY());
            }
            PathElement nextpe = (PathElement)p.getElements().get(closestindex + 1);
            double nextdistance = Double.MAX_VALUE;
            if (nextpe instanceof LineTo) {
                nextdistance = modelpt.distance(((LineTo)nextpe).getX(), ((LineTo)nextpe).getY());
            } else if (nextpe instanceof CubicCurveTo) {
                nextdistance = modelpt.distance(((CubicCurveTo)nextpe).getX(), ((CubicCurveTo)nextpe).getY());
            } else if (nextpe instanceof MoveTo) {
                nextdistance = modelpt.distance(((MoveTo)nextpe).getX(), ((MoveTo)nextpe).getY());
            }
            if (nextdistance < priordistance) {
                ++closestindex;
            }
            if (ms.getCreationType() == MapShape.CreationType.CURVE) {
                CubicCurveTo cubicTo = new CubicCurveTo();
                cubicTo.setControlX1(modelpt.getX() - 150.0);
                cubicTo.setControlY1(modelpt.getY() - 150.0);
                cubicTo.setControlX2(modelpt.getX() + 150.0);
                cubicTo.setControlY2(modelpt.getY() + 150.0);
                cubicTo.setX(modelpt.getX());
                cubicTo.setY(modelpt.getY());
                p.getElements().add(closestindex, (Object)cubicTo);
            } else {
                p.getElements().add(closestindex, (Object)lineTo);
            }
            MapShape msnew = ms.clone();
            if (undoable) {
                this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, msnew, msold, closestindex, null, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    Polygon subtractPolygon(Polygon a, Polygon b) {
        int n;
        int i;
        ArrayList<Line> linesa = new ArrayList<Line>();
        for (int i2 = 0; i2 < a.getPoints().size() - 1; i2 += 2) {
            linesa.add(new Line(((Double)a.getPoints().get(i2)).doubleValue(), ((Double)a.getPoints().get(i2 + 1)).doubleValue(), ((Double)a.getPoints().get((i2 + 2) % a.getPoints().size())).doubleValue(), ((Double)a.getPoints().get((i2 + 3) % a.getPoints().size())).doubleValue()));
        }
        ArrayList<Line> linesb = new ArrayList<Line>();
        for (int i3 = b.getPoints().size() - 2; i3 >= 0; i3 -= 2) {
            linesb.add(new Line(((Double)b.getPoints().get((i3 + 2) % b.getPoints().size())).doubleValue(), ((Double)b.getPoints().get((i3 + 3) % b.getPoints().size())).doubleValue(), ((Double)b.getPoints().get(i3)).doubleValue(), ((Double)b.getPoints().get(i3 + 1)).doubleValue()));
        }
        ArrayList<Line> linesbeforematcha = new ArrayList<Line>();
        ArrayList<Line> resultlinesa = new ArrayList<Line>();
        ArrayList<Line> removefromb = new ArrayList<Line>();
        boolean ahadmatches = false;
        for (Line line : linesa) {
            boolean bl = false;
            for (Line lineb : linesb) {
                if (!MapController.areLinesSame(line, lineb)) continue;
                bl = true;
                removefromb.add(lineb);
                break;
            }
            if (bl) {
                ahadmatches = true;
                continue;
            }
            if (ahadmatches) {
                resultlinesa.add(line);
                continue;
            }
            linesbeforematcha.add(line);
        }
        linesb.removeAll(removefromb);
        Polygon p = new Polygon();
        for (Line line : resultlinesa) {
            p.getPoints().add((Object)line.getStartX());
            p.getPoints().add((Object)line.getStartY());
        }
        for (Line line : linesbeforematcha) {
            p.getPoints().add((Object)line.getStartX());
            p.getPoints().add((Object)line.getStartY());
        }
        if (linesbeforematcha.size() > 0) {
            Point2D point2D = new Point2D(((Line)linesbeforematcha.get(linesbeforematcha.size() - 1)).getEndX(), ((Line)linesbeforematcha.get(linesbeforematcha.size() - 1)).getEndY());
        } else {
            Point2D point2D = new Point2D(((Line)resultlinesa.get(resultlinesa.size() - 1)).getEndX(), ((Line)resultlinesa.get(resultlinesa.size() - 1)).getEndY());
        }
        boolean bl = false;
        for (i = 0; i < linesb.size(); ++i) {
            void var10_17;
            if (!(Math.abs(((Line)linesb.get(i)).getStartX() - var10_17.getX()) < 1.0) || !(Math.abs(((Line)linesb.get(i)).getStartY() - var10_17.getY()) < 1.0)) continue;
            n = i;
        }
        for (i = 0; i < linesb.size(); ++i) {
            Line l = (Line)linesb.get((i + n) % linesb.size());
            p.getPoints().add((Object)l.getStartX());
            p.getPoints().add((Object)l.getStartY());
        }
        return p;
    }

    public void deleteShape(MapShape ms, UndoActionGroup uag) {
        MapShape oldval = ms.clone();
        UndoAction undoaction = new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.MAP_SHAPE, ms, null, oldval, null, null, null);
        if (uag != null) {
            uag.addAction(undoaction);
        } else {
            this.getUndoRedoHandler().push(undoaction);
        }
        this.mapUI.getCurrentObjects().remove(ms);
        this.mapData.getShapes().remove(ms);
    }

    public void deleteShapes(List<MapShape> todeletelist) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapShape todelete : todeletelist) {
            this.deleteShape(todelete, uag);
        }
        this.mapUI.getCurrentObjects().clear();
        this.getUndoRedoHandler().push(uag);
    }

    public void moveShapeUp(List<MapObject> shapes) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : shapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapData mapData = this.mapUI.getMapData();
            int oldindex = mapData.getShapes().indexOf(ms);
            mapData.getShapes().remove(ms);
            boolean moved = false;
            for (int i = oldindex; i < mapData.getShapes().size(); ++i) {
                if (!ms.getShape().intersects(mapData.getShapes().get(i).getShape().getBoundsInLocal())) continue;
                mapData.getShapes().add(Math.min(mapData.getShapes().size(), i + 1), ms);
                uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, mapData.getShapes().indexOf(ms), oldindex, null, null, null));
                moved = true;
                break;
            }
            if (moved) continue;
            mapData.getShapes().add(ms);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, mapData.getShapes().indexOf(ms), oldindex, null, null, null));
        }
        this.getUndoRedoHandler().push(uag);
    }

    public void moveShapeDown(List<MapObject> shapes) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : shapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapData mapData = this.mapUI.getMapData();
            int oldindex = mapData.getShapes().indexOf(ms);
            mapData.getShapes().remove(ms);
            boolean moved = false;
            for (int i = oldindex - 1; i >= 0; --i) {
                if (!ms.getShape().intersects(mapData.getShapes().get(i).getShape().getBoundsInLocal())) continue;
                mapData.getShapes().add(Math.min(mapData.getShapes().size(), i), ms);
                uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, mapData.getShapes().indexOf(ms), oldindex, null, null, null));
                moved = true;
                break;
            }
            if (moved) continue;
            mapData.getShapes().add(0, ms);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, mapData.getShapes().indexOf(ms), oldindex, null, null, null));
        }
        this.getUndoRedoHandler().push(uag);
    }

    public void moveShapeBottom(List<MapObject> shapes) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : shapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            int oldindex = this.mapUI.getMapData().getShapes().indexOf(ms);
            this.mapUI.getMapData().getShapes().remove(ms);
            this.mapUI.getMapData().getShapes().add(0, ms);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, this.mapUI.getMapData().getShapes().indexOf(ms), oldindex, null, null, null));
        }
        this.getUndoRedoHandler().push(uag);
    }

    public void moveShapeTop(List<MapObject> shapes) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : shapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            int oldindex = this.mapUI.getMapData().getShapes().indexOf(ms);
            this.mapUI.getMapData().getShapes().remove(ms);
            this.mapUI.getMapData().getShapes().add(ms);
            uag.addAction(new UndoAction(UndoAction.Action.REORDER, UndoAction.Thing.MAP_SHAPE, ms, this.mapUI.getMapData().getShapes().indexOf(ms), oldindex, null, null, null));
        }
        this.getUndoRedoHandler().push(uag);
    }

    public void joinShapes(boolean undoEnabled) {
        Object e;
        if (this.mapUI.getCurrentObjects().size() > 1 && (e = this.mapUI.getCurrentObjects().get(0)) instanceof MapShape) {
            MapShape orig = (MapShape)e;
            this.loggerUI.addLogText("joining shapes", false);
            UndoActionGroup uag = new UndoActionGroup();
            MapShape dupe = orig.clone();
            Paint fill = orig.getShape().getFill();
            Paint stroke = orig.getShape().getStroke();
            double width = orig.getShape().getStrokeWidth();
            StrokeLineCap lineCap = orig.getShape().getStrokeLineCap();
            StrokeLineJoin lineJoin = orig.getShape().getStrokeLineJoin();
            double opacity = orig.getShape().getOpacity();
            Shape newShape = null;
            for (int i = 1; i < this.mapUI.getCurrentObjects().size(); ++i) {
                if (!(this.mapUI.getCurrentObjects().get(i) instanceof MapShape)) continue;
                Shape s = ((MapShape)this.mapUI.getCurrentObjects().get(i)).getShape();
                newShape = Shape.union((Shape)orig.getShape(), (Shape)s);
                orig.setShape(newShape);
                newShape.setStroke(stroke);
                newShape.setStrokeWidth(width);
                newShape.setStrokeLineCap(lineCap);
                newShape.setStrokeLineJoin(lineJoin);
                newShape.setFill(fill);
                newShape.setOpacity(opacity);
                this.mapUI.getController().deleteShape((MapShape)this.mapUI.getCurrentObjects().get(i), uag);
                this.loggerUI.addLogText("joined shapes", false);
            }
            this.mapUI.draw();
            if (newShape != null && undoEnabled) {
                uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, orig, newShape, dupe.getShape(), null, null, null));
                this.getUndoRedoHandler().push(uag);
            }
        }
    }

    public void updateShapeToRiver(List<MapObject> mapShapes, Double mouthWidth, Double endWidth, String mouthEnd) {
        for (MapObject mo : mapShapes) {
            MapShape ms;
            if (!(mo instanceof MapShape) || !((ms = (MapShape)mo).getShape() instanceof Path)) continue;
            Shape oldShape = ms.getShape();
            List<Point2D> pts = ms.getShapePoints();
            ArrayList<Point2D> ptsOut = new ArrayList<Point2D>();
            double width = mouthWidth;
            double widthAdjustment = (mouthWidth - endWidth) / (double)pts.size();
            if (pts.get(0).getX() < pts.get(pts.size() - 1).getX() && "Right".equals(mouthEnd) || pts.get(0).getX() > pts.get(pts.size() - 1).getX() && "Left".equals(mouthEnd) || pts.get(0).getY() < pts.get(pts.size() - 1).getY() && "Bottom".equals(mouthEnd) || pts.get(0).getY() > pts.get(pts.size() - 1).getY() && "Top".equals(mouthEnd)) {
                for (i = pts.size() - 1; i >= 0; --i) {
                    this.convertLineToPolygonHelper(pts, ptsOut, i, (width -= widthAdjustment) * 1.5);
                }
            } else {
                for (i = 0; i < pts.size(); ++i) {
                    this.convertLineToPolygonHelper(pts, ptsOut, i, (width -= widthAdjustment) * 1.5);
                }
            }
            Object[] ptsoutarray = new Double[ptsOut.size() * 2];
            for (int i = 0; i < ptsOut.size(); ++i) {
                ptsoutarray[i * 2] = ((Point2D)ptsOut.get(i)).getX();
                ptsoutarray[i * 2 + 1] = ((Point2D)ptsOut.get(i)).getY();
            }
            Polygon p = new Polygon();
            p.getPoints().addAll(ptsoutarray);
            p.setFill(ms.getShape().getStroke());
            p.setStroke(ms.getShape().getStroke());
            p.setStrokeWidth(0.0);
            p.setStrokeLineCap(StrokeLineCap.ROUND);
            p.setStrokeLineJoin(StrokeLineJoin.ROUND);
            ms.setShape((Shape)p);
            this.getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_SHAPE, UndoAction.Thing.MAP_SHAPE, ms, p, oldShape, null, null, null));
        }
    }

    public void updateShapeStrokeType(boolean undoEnabled, List<MapObject> mapshapes, MapShape.StrokeType newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setStrokeType(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeStrokeWidth(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        if (!undoEnabled) {
            return;
        }
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.getShape().setStrokeWidth(newValue / 100.0);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "strokewidth", null, null));
        }
    }

    public void updateShapeColorStroke(boolean undoEnabled, List<MapObject> mapshapes, Color newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.getShape().setStroke((Paint)newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "strokecolor", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeTextureStroke(boolean undoEnabled, List<MapObject> mapshapes, TextureType newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ImagePattern newtexture = new ImagePattern(newValue.getIcon(), 0.0, 0.0, 50.0, 25.0, false);
            ms.setStrokeTexture(newValue);
            ms.getShape(this.mapUI.getMapData(), this.mapUI.viewLevel).setStroke((Paint)newtexture);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "strokecolor", newtexture, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeNoFill(boolean undoEnabled, List<MapObject> mapshapes) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setFillTexture(null);
            ms.getShape(this.mapUI.getMapData(), this.mapUI.viewLevel).setFill(null);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeColorFill(boolean undoEnabled, List<MapObject> mapshapes, Color newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeColorFill(undoEnabled, uag, ms, newValue);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeColorFill(boolean undoEnabled, UndoActionGroup uag, MapShape ms, Color newValue) {
        MapShape old = ms.clone();
        ms.getShape().setFill((Paint)newValue);
        UndoAction ua = new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null);
        if (uag != null) {
            uag.addAction(ua);
        } else if (undoEnabled) {
            this.getUndoRedoHandler().push(ua);
        }
    }

    public void updateShapeTextureFill(boolean undoEnabled, List<MapObject> mapshapes, TextureType newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeTextureFill(undoEnabled, uag, ms, newValue);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeTextureFill(boolean undoEnabled, UndoActionGroup uag, MapShape ms, TextureType newValue) {
        MapShape old = ms.clone();
        ImagePattern newtexture = new ImagePattern(newValue.getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        ms.setFillTexture(newValue);
        ms.getShape(this.mapUI.getMapData(), this.mapUI.viewLevel).setFill((Paint)newtexture);
        UndoAction ua = new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "fillcolor", newtexture, null);
        if (uag != null) {
            uag.addAction(ua);
        } else if (undoEnabled) {
            this.getUndoRedoHandler().push(ua);
        }
    }

    public void updateShapeOpacity(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.getShape().setOpacity(newValue / 100.0);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeTags(boolean undoEnabled, List<MapObject> mapshapes, String newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setTags(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeWorld(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeWorld(undoEnabled, ms, newValue, uag);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeWorld(boolean undoEnabled, MapShape ms, boolean newValue, UndoActionGroup uag) {
        MapShape old = ms.clone();
        ms.setWorld(newValue);
        if (undoEnabled) {
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "world", null, null));
        }
    }

    public void updateShapeContinent(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeContinent(undoEnabled, ms, newValue, uag);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeContinent(boolean undoEnabled, MapShape ms, boolean newValue, UndoActionGroup uag) {
        MapShape old = ms.clone();
        ms.setContinent(newValue);
        if (undoEnabled) {
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "continent", null, null));
        }
    }

    public void updateShapeKingdom(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeKingdom(undoEnabled, ms, newValue, uag);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeKingdom(boolean undoEnabled, MapShape ms, boolean newValue, UndoActionGroup uag) {
        MapShape old = ms.clone();
        ms.setKingdom(newValue);
        if (undoEnabled) {
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "kingdom", null, null));
        }
    }

    public void updateShapeProvince(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.updateShapeProvince(undoEnabled, ms, newValue, uag);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeProvince(boolean undoEnabled, MapShape ms, boolean newValue, UndoActionGroup uag) {
        MapShape old = ms.clone();
        ms.setProvince(newValue);
        if (undoEnabled) {
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "province", null, null));
        }
    }

    public void updateShapeMapLayer(boolean undoEnabled, List<MapObject> mapshapes, MapLayer newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            if (newValue == null || newValue.equals(old.getMapLayer())) continue;
            ms.setMapLayer(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled && !uag.getActions().isEmpty()) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeSnap(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setSnapVertices(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeMatchTileBorder(boolean undoEnabled, List<MapObject> mapshapes, boolean newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setMatchTileBorders(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeStrokeLineCap(boolean undoEnabled, List<MapObject> mapshapes, StrokeLineCap newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.getShape().setStrokeLineCap(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "linecap", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeStrokeLineJoin(boolean undoEnabled, List<MapObject> mapshapes, StrokeLineJoin newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.getShape().setStrokeLineJoin(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "linejoin", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeArcStart(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            MapShape ms;
            Shape shape;
            if (!(mo instanceof MapShape) || !((shape = (ms = (MapShape)mo).getShape()) instanceof Arc)) continue;
            Arc a = (Arc)shape;
            MapShape old = ms.clone();
            a.setStartAngle(newValue.doubleValue());
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeArcExtent(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            MapShape ms;
            Shape shape;
            if (!(mo instanceof MapShape) || !((shape = (ms = (MapShape)mo).getShape()) instanceof Arc)) continue;
            Arc a = (Arc)shape;
            MapShape old = ms.clone();
            a.setLength(newValue.doubleValue());
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeArcType(boolean undoEnabled, List<MapObject> mapshapes, ArcType arctype) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            MapShape ms;
            Shape shape;
            if (!(mo instanceof MapShape) || !((shape = (ms = (MapShape)mo).getShape()) instanceof Arc)) continue;
            Arc a = (Arc)shape;
            MapShape old = ms.clone();
            a.setType(arctype);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateExtraLineDetail(boolean undoEnabled, List<MapObject> mapshapes, double newVal, String detail) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            if (detail.equals("width")) {
                ms.setExtraLineWidth(newVal);
            } else if (detail.equals("distance")) {
                ms.setExtraLineDistance(newVal);
            } else if (detail.equals("length")) {
                ms.setExtraLineLength(newVal);
            } else if (detail.equals("separation")) {
                ms.setExtraLineSeparation(newVal);
            } else {
                return;
            }
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadow(boolean undoEnabled, List<MapObject> mapshapes, Boolean enabled, Color color, double offsetx, double offsety, double spread, double radius) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDropShadow(enabled);
            ms.setDsColor(color);
            ms.setDsOffsetX(offsetx);
            ms.setDsOffsetY(offsety);
            ms.setDsSpread(spread);
            ms.setDsRadius(radius);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadowSpread(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDsSpread(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "spread", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadowRadius(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDsRadius(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "radius", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadowOffsetX(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDsOffsetX(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "offsetx", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadowOffsetY(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDsOffsetY(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "offsety", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeDropShadowColor(boolean undoEnabled, List<MapObject> mapshapes, Color newval) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setDsColor(newval);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "dscolor", null, null));
        }
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeBoxBlur(boolean undoEnabled, List<MapObject> mapshapes, Boolean enabled, Double width, Double height, Integer iterations) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setBoxBlur(enabled);
            ms.setBbWidth(width);
            ms.setBbHeight(height);
            ms.setBbIterations(iterations);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadow(boolean undoEnabled, List<MapObject> mapshapes, Boolean enabled, Color color, double offsetx, double offsety, double choke, double radius) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInnerShadow(enabled);
            ms.setInsColor(color);
            ms.setInsOffsetX(offsetx);
            ms.setInsOffsetY(offsety);
            ms.setInsChoke(choke);
            ms.setInsRadius(radius);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadowChoke(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInsChoke(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "choke", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadowRadius(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInsRadius(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "radius", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadowOffsetX(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInsOffsetX(newValue);
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "offsetx", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadowOffsetY(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInsOffsetY(newValue);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "offsety", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeInnerShadowColor(boolean undoEnabled, List<MapObject> mapshapes, Color newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setInsColor(newValue);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "color", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeBBWidth(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setBbWidth(newValue);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "width", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeBBHeight(boolean undoEnabled, List<MapObject> mapshapes, Double newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setBbHeight(newValue);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "height", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeBBIterations(boolean undoEnabled, List<MapObject> mapshapes, Integer newValue) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setBbIterations(newValue);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, "iterations", null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateShapeGradientEdge(boolean undoEnabled, List<MapObject> mapshapes, boolean selected) {
        UndoActionGroup uag = new UndoActionGroup();
        for (MapObject mo : mapshapes) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            MapShape old = ms.clone();
            ms.setGradientEdge(selected);
            if (!undoEnabled) continue;
            uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, ms, ms.clone(), old, null, null, null));
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public boolean placeTerrain(double x, double y, List<Terrain> terrain, boolean isWideArea, boolean isPaintBucket, boolean isDynamic, byte[] terrainResources, boolean autoUpdateOtherLevelsItem, Color overrideTerrainBGCP, boolean terrainGMOnlyCB, boolean terrainIcyCB, boolean terrainOverrideValues, int elevation, boolean changeAllMatchingTerrain) {
        boolean anychanged = false;
        if (terrain != null) {
            Point2D coords = this.mapUI.getTerrainFromScenePt(x, y);
            String oldType = this.mapData.getTerrain(this.mapUI.getViewLevel())[(int)coords.getX()][(int)coords.getY()].getTypeName();
            boolean origIcy = this.mapData.getTerrain(this.mapUI.getViewLevel())[(int)coords.getX()][(int)coords.getY()].isIcy();
            if (isWideArea && !isPaintBucket) {
                UndoActionGroup uag = new UndoActionGroup();
                anychanged = this.changeTerrain(uag, terrain, coords, this.mapUI.getViewLevel(), this.mapUI.getViewLevel(), terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
                boolean changed = this.changeWideAreaTerrain(uag, (int)coords.getX(), (int)coords.getY(), terrain, terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
                if (changed) {
                    anychanged = true;
                }
                this.getUndoRedoHandler().push(uag);
            } else {
                UndoActionGroup uag = new UndoActionGroup();
                anychanged = this.changeTerrain(uag, terrain, coords, this.mapUI.getViewLevel(), this.mapUI.getViewLevel(), terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
                if (isPaintBucket) {
                    HashSet<CallSite> terrainChangedCoords = new HashSet<CallSite>();
                    terrainChangedCoords.add((CallSite)((Object)((int)coords.getX() + ":" + (int)coords.getY())));
                    this.changeAdjacentTerrain(uag, (int)coords.getX(), (int)coords.getY(), oldType, terrain, origIcy, terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation, changeAllMatchingTerrain);
                }
                if (anychanged) {
                    if (isDynamic) {
                        HashMap<String, Integer> featureTypeNamesToPoints = new HashMap<String, Integer>();
                        Terrain changed = this.mapData.getTerrain(this.mapUI.getViewLevel())[(int)coords.getX()][(int)coords.getY()];
                        int maxValuePts = 0;
                        String changedTypeName = changed.getTypeName();
                        if (changedTypeName.contains("/")) {
                            changedTypeName = changedTypeName.substring(changedTypeName.lastIndexOf(47) + 1);
                        }
                        for (String dynamicTerrainName : this.mapUI.dynamicTerrainSettingMap.keySet()) {
                            if (!dynamicTerrainName.contains(changedTypeName)) continue;
                            maxValuePts = this.mapUI.dynamicTerrainSettingMap.get(dynamicTerrainName).getMaxPts();
                            HashMap<String, Integer> featureNamePartsToMatch = this.mapUI.dynamicTerrainSettingMap.get(dynamicTerrainName).getFeatureFilters();
                            for (String ftName : Feature.featureTypes.keySet()) {
                                for (String featureNameParts : featureNamePartsToMatch.keySet()) {
                                    if (featureNameParts.trim().equals("")) continue;
                                    String[] parts = featureNameParts.toLowerCase().split(" ");
                                    boolean matchAll = true;
                                    for (String part : parts) {
                                        if (part.startsWith("-")) {
                                            if (!ftName.toLowerCase().contains(part.substring(1))) continue;
                                            matchAll = false;
                                            break;
                                        }
                                        if (ftName.toLowerCase().contains(part)) continue;
                                        matchAll = false;
                                        break;
                                    }
                                    if (!matchAll) continue;
                                    featureTypeNamesToPoints.put(ftName, (Integer)featureNamePartsToMatch.get(featureNameParts));
                                }
                            }
                        }
                        List<Object> matchingFeatureNames = Arrays.asList(featureTypeNamesToPoints.keySet().toArray());
                        MapLayer ml = this.mapData.getOrCreateMapLayer("Above Terrain Y-Ordered", "Terrain Land");
                        Point2D modelCoords = this.mapUI.getModelCoordsFromScreenPt(x, y);
                        Random r = new Random((long)modelCoords.getX() + (long)modelCoords.getY() * 1000L);
                        int tries = 0;
                        int valuePoints = 0;
                        if (featureTypeNamesToPoints.size() > 0) {
                            ArrayList priorLocations = new ArrayList();
                            while (tries < 15 && valuePoints < maxValuePts) {
                                ++tries;
                                String t = (String)matchingFeatureNames.get(r.nextInt(featureTypeNamesToPoints.size()));
                                int numValuePts = (Integer)featureTypeNamesToPoints.get(t);
                                if (valuePoints + numValuePts > maxValuePts) continue;
                                double ptx = 200.0 * r.nextDouble();
                                double pty = 200.0 * r.nextDouble();
                                boolean overlaps = false;
                                for (Point pt : priorLocations) {
                                    if (Math.abs(pt.getX() - ptx) < (double)(numValuePts * 15)) {
                                        overlaps = true;
                                        break;
                                    }
                                    if (!(Math.abs(pt.getY() - pty) < (double)(numValuePts * 15))) continue;
                                    overlaps = true;
                                    break;
                                }
                                if (overlaps) continue;
                                valuePoints += numValuePts;
                                Point2D pt = new Point2D(modelCoords.getX() - 100.0 + ptx, modelCoords.getY() - 100.0 + pty);
                                this.mapUI.getController().placeFeature(uag, this.mapUI.getViewLevel(), pt, t, true, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, 0, 180.0, "", true, true, true, true, ml, "", "", null, null, 0.0, null, null, 0.0, true, true, true, true, false, false, false, 1.0, "", null, 1.0);
                            }
                        }
                    }
                    this.getUndoRedoHandler().push(uag);
                }
            }
        }
        return anychanged;
    }

    private boolean changeWideAreaTerrain(UndoActionGroup uag, Integer x, Integer y, List<Terrain> terrainList, byte[] terrainResources, boolean autoUpdateOtherLevelsItem, Color overrideTerrainBGCP, boolean terrainGMOnlyCB, boolean terrainIcyCB, boolean terrainOverrideValues, int elevation) {
        boolean anychanged = false;
        Terrain[][] t = this.mapUI.getMapData().getTerrain(this.mapUI.viewLevel);
        ArrayList<Pair> needToChange = new ArrayList<Pair>();
        needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D((double)x.intValue(), (double)y.intValue())));
        Pair thisterrain = (Pair)needToChange.remove(0);
        if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
            if (((Point2D)thisterrain.getValue()).getY() > 0.0) {
                needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() - 1.0)));
            }
            if (((Point2D)thisterrain.getValue()).getY() < (double)(t[0].length - 1)) {
                needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() + 1.0)));
            }
            if (((Point2D)thisterrain.getValue()).getX() % 2.0 == 0.0) {
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY())));
                }
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY())));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
            } else {
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY())));
                }
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY())));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
            }
        } else if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
            if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY())));
            }
            if (((Point2D)thisterrain.getValue()).getX() < (double)(t[0].length - 1)) {
                needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY())));
            }
            if (((Point2D)thisterrain.getValue()).getY() % 2.0 == 0.0) {
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getY() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getX() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() - 1.0, ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getY() < (double)(t[0].length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
            } else {
                if (((Point2D)thisterrain.getValue()).getY() > 0.0) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY() - 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getY() < (double)(t[0].length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX(), ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
                if (((Point2D)thisterrain.getValue()).getX() < (double)(t.length - 1)) {
                    needToChange.add(new Pair((Object)terrainList.get((int)(Math.random() * (double)terrainList.size())), (Object)new Point2D(((Point2D)thisterrain.getValue()).getX() + 1.0, ((Point2D)thisterrain.getValue()).getY() + 1.0)));
                }
            }
        }
        for (Pair ter : needToChange) {
            ArrayList<Terrain> tl = new ArrayList<Terrain>();
            tl.add((Terrain)ter.getKey());
            boolean changed = this.changeTerrain(uag, tl, (Point2D)ter.getValue(), this.mapUI.getViewLevel(), this.mapUI.getViewLevel(), terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
            if (!changed) continue;
            anychanged = true;
        }
        return anychanged;
    }

    private void changeAdjacentTerrain(UndoActionGroup uag, Integer x, Integer y, String oldtype, List<Terrain> terrainList, boolean origicy, byte[] terrainResources, boolean autoUpdateOtherLevelsItem, Color overrideTerrainBGCP, boolean terrainGMOnlyCB, boolean terrainIcyCB, boolean terrainOverrideValues, int elevation, boolean changeAllMatchingTerrain) {
        Terrain[][] t = this.mapUI.getMapData().getTerrain(this.mapUI.viewLevel);
        boolean initial = true;
        HashMap<Point2D, Terrain> needToChange = new HashMap<Point2D, Terrain>();
        HashMap<Point2D, Terrain> alreadyChanged = new HashMap<Point2D, Terrain>();
        needToChange.put(new Point2D((double)x.intValue(), (double)y.intValue()), terrainList.get((int)(Math.random() * (double)terrainList.size())));
        if (changeAllMatchingTerrain) {
            for (int i = 0; i < t.length; ++i) {
                for (int j = 0; j < t[i].length; ++j) {
                    Terrain aTerrain = t[i][j];
                    if (origicy != aTerrain.isIcy() || !aTerrain.getTypeName().equals(oldtype)) continue;
                    Point2D newPt = new Point2D((double)i, (double)j);
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
            }
            for (Point2D pt : needToChange.keySet()) {
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add((Terrain)needToChange.get(pt));
                this.changeTerrain(uag, tl, pt, this.mapUI.getViewLevel(), this.mapUI.getViewLevel(), terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
            }
            return;
        }
        while (needToChange.size() > 0) {
            Point2D newPt;
            boolean changed;
            Point2D pt = (Point2D)needToChange.keySet().stream().findAny().get();
            Terrain aTerrain = (Terrain)needToChange.remove(pt);
            if (!initial && origicy != t[(int)pt.getX()][(int)pt.getY()].isIcy()) continue;
            if (initial) {
                initial = false;
                changed = true;
            } else {
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(aTerrain);
                alreadyChanged.put(pt, aTerrain);
                changed = this.changeTerrain(uag, tl, pt, this.mapUI.getViewLevel(), this.mapUI.getViewLevel(), terrainResources, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation);
            }
            if (!changed) continue;
            if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
                if (pt.getY() > 0.0 && (t[(int)pt.getX()][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() - 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX()][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() + 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getX() % 2.0 == 0.0) {
                    if (pt.getX() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY()))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (pt.getX() > 0.0 && pt.getY() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() - 1.0))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (pt.getX() < (double)(t.length - 1) && (t[(int)pt.getX() + 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY()))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (!(pt.getX() < (double)(t.length - 1)) || !(pt.getY() > 0.0) || !t[(int)pt.getX() + 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) && oldtype != null || alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() - 1.0))) continue;
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    continue;
                }
                if (pt.getX() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY()))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getX() > 0.0 && pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX() - 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() + 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getX() < (double)(t.length - 1) && (t[(int)pt.getX() + 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY()))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (!(pt.getX() < (double)(t.length - 1)) || !(pt.getY() < (double)(t[0].length - 1)) || !t[(int)pt.getX() + 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) && oldtype != null || alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() + 1.0))) continue;
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                continue;
            }
            if (this.mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
                if (pt.getX() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY()))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getX() < (double)(t[0].length - 1) && (t[(int)pt.getX() + 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY()))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getY() % 2.0 == 0.0) {
                    if (pt.getX() > 0.0 && pt.getY() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() - 1.0))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (pt.getY() > 0.0 && (t[(int)pt.getX()][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() - 1.0))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (pt.getX() > 0.0 && pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX() - 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() + 1.0))) {
                        needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    }
                    if (!(pt.getY() < (double)(t[0].length - 1)) || !t[(int)pt.getX()][(int)pt.getY() + 1].getTypeName().equals(oldtype) && oldtype != null || alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() + 1.0))) continue;
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                    continue;
                }
                if (pt.getY() > 0.0 && (t[(int)pt.getX()][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() - 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getX() < (double)(t.length - 1) && pt.getY() > 0.0 && (t[(int)pt.getX() + 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() - 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX()][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() + 1.0))) {
                    needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                }
                if (!(pt.getX() < (double)(t.length - 1)) || !(pt.getY() < (double)(t[0].length - 1)) || !t[(int)pt.getX() + 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) && oldtype != null || alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() + 1.0))) continue;
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
                continue;
            }
            if (pt.getX() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY()))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getX() < (double)(t[0].length - 1) && (t[(int)pt.getX() + 1][(int)pt.getY()].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY()))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getX() > 0.0 && pt.getY() > 0.0 && (t[(int)pt.getX() - 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() - 1.0))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getX() < (double)(t[0].length - 1) && pt.getY() > 0.0 && (t[(int)pt.getX() + 1][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() - 1.0))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getY() > 0.0 && (t[(int)pt.getX()][(int)pt.getY() - 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() - 1.0))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getX() < (double)(t[0].length - 1) && pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX() + 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() + 1.0, pt.getY() + 1.0))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (pt.getX() > 0.0 && pt.getY() < (double)(t[0].length - 1) && (t[(int)pt.getX() - 1][(int)pt.getY() + 1].getTypeName().equals(oldtype) || oldtype == null) && !alreadyChanged.containsKey(newPt = new Point2D(pt.getX() - 1.0, pt.getY() + 1.0))) {
                needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
            }
            if (!(pt.getY() < (double)(t[0].length - 1)) || !t[(int)pt.getX()][(int)pt.getY() + 1].getTypeName().equals(oldtype) && oldtype != null || alreadyChanged.containsKey(newPt = new Point2D(pt.getX(), pt.getY() + 1.0))) continue;
            needToChange.put(newPt, terrainList.get((int)(Math.random() * (double)terrainList.size())));
        }
    }

    public boolean changeTerrain(UndoActionGroup uag, List<Terrain> terrain, Point2D coords, ViewLevel vl, ViewLevel origviewlevel, byte[] terrainResources, boolean autoUpdateOtherLevelsItem, Color overrideTerrainBGCP, boolean terrainGMOnlyCB, boolean terrainIcyCB, boolean terrainOverrideValues, int elevation) {
        return this.mapUI.getMapData().changeTerrain(uag, terrain, coords, vl, origviewlevel, autoUpdateOtherLevelsItem, overrideTerrainBGCP, terrainGMOnlyCB, terrainIcyCB, terrainOverrideValues, elevation, terrainResources);
    }

    public void updateTerrainBackgroundColor(boolean undoEnabled, Terrain t, Color c) {
        Terrain old = t.clone();
        t.setBackgroundColor(c);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, t, t.clone(), old, null, null, null));
        }
    }

    public void updateTerrainElevation(boolean undoEnabled, Terrain t, int newval) {
        Terrain old = t.clone();
        t.setElevation(newval);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, t, t.clone(), old, null, null, null));
        }
    }

    public void updateExtraTerrainMapLayer(boolean undoEnabled, Terrain t, MapLayer newLayer) {
        if (newLayer.getName().equals("Terrain Land") || newLayer.getName().equals("Terrain Water")) {
            return;
        }
        UndoActionGroup uag = new UndoActionGroup();
        Pair<MapLayer, Point> mapLayerAndPoint = this.deleteTerrain(t, uag);
        if (mapLayerAndPoint != null) {
            Pair pt = new Pair((Object)((Point)mapLayerAndPoint.getValue()).getX(), (Object)((Point)mapLayerAndPoint.getValue()).getY());
            this.addExtraTerrain(t, newLayer, (Pair<Double, Double>)pt, uag);
        }
        if (undoEnabled) {
            this.getUndoRedoHandler().push(uag);
        }
    }

    public void updateTerrainResource(boolean undoEnabled, Terrain t, byte newval, int index) {
        Terrain old = t.clone();
        t.getExtraInfo().getResources()[index] = newval;
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, t, t.clone(), old, null, null, null));
        }
    }

    public void updateTerrainIcy(boolean undoEnabled, Terrain t, boolean newval) {
        Terrain old = t.clone();
        t.setIcy(newval);
        if (undoEnabled) {
            this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, t, t.clone(), old, null, null, null));
        }
    }

    public void convertUnderlay(boolean onlyBlanks, List<Terrain> selectedterrain) {
        MapData mapData = this.mapUI.getMapData();
        int rightx = (int)(mapData.getTrace().getTopLeftX() * mapData.getTileWidth() * (mapData.getTileOrientation() == HexOrientation.COLUMNS ? 0.75 : 1.0));
        int uppery = (int)(mapData.getTrace().getTopLeftY() * mapData.getTileHeight() * (mapData.getTileOrientation() == HexOrientation.ROWS ? 0.75 : 1.0));
        Image image = mapData.getTrace().getImage();
        ImageView iv1 = new ImageView();
        iv1.setImage(image);
        ImageView iv2 = new ImageView();
        iv2.setImage(image);
        int imagedisplaywidth = (int)(mapData.getTrace().getWidth() * 100.0 * mapData.getTileWidth() * 3.0 / 4.0 + mapData.getTileWidth() / 2.0);
        int imagedisplayheight = (int)(mapData.getTrace().getHeight() * 100.0 * mapData.getTileHeight() + mapData.getTileHeight() / 2.0);
        if (mapData.getTileOrientation() == HexOrientation.ROWS) {
            imagedisplaywidth = (int)(mapData.getTrace().getWidth() * 100.0 * mapData.getTileWidth() + mapData.getTileWidth() / 2.0);
            imagedisplayheight = (int)(mapData.getTrace().getHeight() * 100.0 * mapData.getTileHeight() * 3.0 / 4.0 + mapData.getTileHeight() / 2.0);
        }
        WritableImage wimg = new WritableImage(imagedisplaywidth, imagedisplayheight);
        SnapshotParameters ssparams = new SnapshotParameters();
        ssparams.setTransform((Transform)new Scale((double)imagedisplaywidth / image.getWidth(), (double)imagedisplayheight / image.getHeight()));
        iv2.snapshot(ssparams, wimg);
        Terrain[][] terrain = mapData.getTerrain(this.mapUI.getViewLevel());
        UndoActionGroup uag = new UndoActionGroup();
        for (int i = 0; i < terrain.length; ++i) {
            for (int j = 0; j < terrain[i].length; ++j) {
                Color color;
                if (onlyBlanks && !"Blank".equals(terrain[i][j].getTypeName())) continue;
                if (mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                    ax = (int)((double)i * mapData.getTileWidth() * 3.0 / 4.0 + mapData.getTileWidth() / 2.0);
                    ay = (int)((double)j * mapData.getTileHeight() + mapData.getTileHeight() / 2.0 + (i % 2 == 1 ? mapData.getTileHeight() / 2.0 : 0.0));
                    if ((ax -= rightx) < 0 || (ay -= uppery) < 0 || (double)ax >= wimg.getWidth() || (double)ay >= wimg.getHeight()) continue;
                    color = wimg.getPixelReader().getColor(ax, ay);
                } else {
                    ax = (int)((double)i * mapData.getTileWidth() + mapData.getTileWidth() / 2.0 + (j % 2 == 1 ? mapData.getTileWidth() / 2.0 : 0.0));
                    ay = (int)((double)j * mapData.getTileHeight() * 3.0 / 4.0 + mapData.getTileHeight() / 2.0);
                    if ((ax -= rightx) < 0 || (ay -= uppery) < 0 || (double)ax >= wimg.getWidth() || (double)ay >= wimg.getHeight()) continue;
                    color = wimg.getPixelReader().getColor(ax, ay);
                }
                double red = color.getRed();
                double green = color.getGreen();
                double blue = color.getBlue();
                Terrain bestmatch = null;
                double bestdiff = 2.147483647E9;
                for (Terrain ti : selectedterrain) {
                    double bluediff;
                    double greendiff;
                    double reddiff;
                    if (ti.getType().getBgColor() == null || !((reddiff = Math.abs(red - ti.getType().getBgColor().getRed())) + (greendiff = Math.abs(green - ti.getType().getBgColor().getGreen())) + (bluediff = Math.abs(blue - ti.getType().getBgColor().getBlue())) < bestdiff)) continue;
                    bestdiff = reddiff + greendiff + bluediff;
                    bestmatch = ti;
                }
                if (bestmatch == null) continue;
                Terrain t = new Terrain(bestmatch.getTypeName(), true);
                byte[] resources = new byte[ResourceType.values().length];
                for (int k = 0; k < ResourceType.values().length; ++k) {
                    resources[k] = 0;
                }
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(t);
                this.mapUI.getController().changeTerrain(uag, tl, new Point2D((double)i, (double)j), this.mapUI.viewLevel, this.mapUI.viewLevel, resources, true, null, false, false, false, 0);
            }
        }
        this.getUndoRedoHandler().push(uag);
    }

    private void convertLineToPolygonHelper(List<Point2D> pts, List<Point2D> ptsOut, int i, double width) {
        int otherpt = i - 1;
        if (otherpt < 0) {
            otherpt = i + 1;
        }
        double riseA = pts.get(i).getY() - pts.get(otherpt).getY();
        double runa = pts.get(i).getX() - pts.get(otherpt).getX();
        double slopeA = riseA / runa;
        double perpendicularSlopeA = Math.abs(-1.0 / slopeA);
        double perpendicularRunA = width;
        if (perpendicularSlopeA != -1.0) {
            perpendicularRunA = Math.sqrt(Math.abs(width * width / (1.0 + perpendicularSlopeA)));
        }
        double perpendicularRiseA = Math.sqrt(Math.abs(width * width - perpendicularRunA * perpendicularRunA));
        if (pts.get(i).getX() > pts.get(otherpt).getX()) {
            if (pts.get(i).getY() < pts.get(otherpt).getY()) {
                perpendicularRunA = -perpendicularRunA;
            }
            perpendicularRiseA = -perpendicularRiseA;
        } else if (pts.get(i).getY() < pts.get(otherpt).getY()) {
            perpendicularRunA = -perpendicularRunA;
        }
        double newX1a = pts.get(i).getX() + perpendicularRunA;
        double newY1a = pts.get(i).getY() + perpendicularRiseA;
        double newX2a = pts.get(i).getX() - perpendicularRunA;
        double newY2a = pts.get(i).getY() - perpendicularRiseA;
        ptsOut.add(new Point2D(newX1a, newY1a));
        ptsOut.add(0, new Point2D(newX2a, newY2a));
        if (i + 2 >= pts.size()) {
            return;
        }
        otherpt = i + 1;
        double rise = pts.get(otherpt).getY() - pts.get(i).getY();
        double run = pts.get(otherpt).getX() - pts.get(i).getX();
        double slope = rise / run;
        double perpendicularSlope = Math.abs(-1.0 / slope);
        double perpendicularRun = width * width;
        if (perpendicularSlope != -1.0) {
            perpendicularRun = Math.sqrt(Math.abs(width * width / (1.0 + perpendicularSlope)));
        }
        double perpendicularRise = Math.sqrt(Math.abs(width * width - perpendicularRun * perpendicularRun));
        if (pts.get(otherpt).getX() > pts.get(i).getX()) {
            if (pts.get(otherpt).getY() < pts.get(i).getY()) {
                perpendicularRun = -perpendicularRun;
            }
            perpendicularRise = -perpendicularRise;
        } else if (pts.get(otherpt).getY() < pts.get(i).getY()) {
            perpendicularRun = -perpendicularRun;
        }
        double newX1 = pts.get(i).getX() + perpendicularRun;
        double newY1 = pts.get(i).getY() + perpendicularRise;
        double newX2 = pts.get(i).getX() - perpendicularRun;
        double newY2 = pts.get(i).getY() - perpendicularRise;
        ptsOut.add(new Point2D(newX1, newY1));
        ptsOut.add(0, new Point2D(newX2, newY2));
    }

    public MapLayer addLayer(int index, String name) {
        MapLayer ml = new MapLayer(name);
        this.mapUI.getMapData().getMapLayers().add(index, ml);
        this.mapUI.getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, ml, null, null, index, null, null));
        return ml;
    }

    public MapLayer addLayer(UndoActionGroup uag, int index, String name) {
        MapLayer ml = new MapLayer(name);
        this.mapUI.getMapData().getMapLayers().add(index, ml);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, ml, null, null, index, null, null));
        return ml;
    }

    public void removeLayer(MapLayer ml, int index) {
        UndoActionGroup uag = new UndoActionGroup();
        ArrayList<Feature> todeletef = new ArrayList<Feature>();
        for (Feature feature : this.mapUI.getMapData().getFeatures()) {
            if (!feature.getMapLayer().equals(ml)) continue;
            this.mapUI.getCurrentObjects().remove(feature);
            todeletef.add(feature);
        }
        for (Feature feature : todeletef) {
            this.deleteFeature(feature, uag);
        }
        ArrayList<MapShape> todeletems = new ArrayList<MapShape>();
        for (MapShape ms : this.mapUI.getMapData().getShapes()) {
            if (!ms.getMapLayer().equals(ml)) continue;
            this.mapUI.getCurrentObjects().remove(ms);
            todeletems.add(ms);
        }
        for (MapShape ms : todeletems) {
            this.deleteShape(ms, uag);
        }
        ArrayList<MapLabel> arrayList = new ArrayList<MapLabel>();
        for (MapLabel l : this.mapUI.getMapData().getMapLabels()) {
            if (l.getMapLayer() != ml) continue;
            this.mapUI.getCurrentObjects().remove(l);
            arrayList.add(l);
        }
        for (MapLabel l : arrayList) {
            this.mapData.getMapLabels().remove(l);
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.LABEL, l, null, null, null, null, null));
        }
        uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.LAYER, ml, null, null, index, null, null));
        this.mapData.getMapLayers().remove(ml);
        this.getUndoRedoHandler().push(uag);
    }
}

