/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.TableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;

public class Note
extends MapObject {
    private ViewLevel originalViewLevel;
    private Feature parent;
    private String title;
    private String filename;
    private String details;
    private boolean isWorld;
    private boolean isContinent;
    private boolean isKingdom;
    private boolean isProvince;
    private Color color = Color.YELLOW;
    public final UUID uuid = UUID.randomUUID();
    private Map<ViewLevel, Point2D> location = new HashMap<ViewLevel, Point2D>();
    private final Map<String, NoteTable> tableData = new TreeMap<String, NoteTable>();

    public String getKey() {
        return String.valueOf((Object)this.originalViewLevel) + "," + this.location.get((Object)this.originalViewLevel).getX() + "," + this.location.get((Object)this.originalViewLevel).getY();
    }

    public String getKeyInt() {
        return String.valueOf((Object)this.originalViewLevel) + "-" + (int)this.location.get((Object)this.originalViewLevel).getX() + "-" + (int)this.location.get((Object)this.originalViewLevel).getY();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setDetails(Map<String, Object> map) {
        StringBuilder s = new StringBuilder();
        for (String k : map.keySet()) {
            Object val = map.get(k);
            if (val instanceof String) {
                s.append(val);
                continue;
            }
            if (!(val instanceof NoteTable)) continue;
            this.tableData.put(k, (NoteTable)map.get(k));
        }
        this.details = s.toString();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isWorld() {
        return this.isWorld;
    }

    public void setWorld(boolean world) {
        this.isWorld = world;
    }

    public boolean isContinent() {
        return this.isContinent;
    }

    public void setContinent(boolean continent) {
        this.isContinent = continent;
    }

    public boolean isKingdom() {
        return this.isKingdom;
    }

    public void setKingdom(boolean kingdom) {
        this.isKingdom = kingdom;
    }

    public boolean isProvince() {
        return this.isProvince;
    }

    public void setProvince(boolean province) {
        this.isProvince = province;
    }

    public Feature getParent() {
        return this.parent;
    }

    public void setParent(Feature parent) {
        this.parent = parent;
    }

    public Point2D getLocation(ViewLevel vl) {
        return this.location.get((Object)vl);
    }

    public void setLocation(ViewLevel vl, Point2D pt) {
        this.location.put(vl, pt);
    }

    public ViewLevel getOriginalViewLevel() {
        return this.originalViewLevel;
    }

    public Map<String, NoteTable> getTableData() {
        return this.tableData;
    }

    public void setTableData(Map<String, NoteTable> t) {
        this.tableData.clear();
        for (String tablekey : t.keySet()) {
            NoteTable oldnt = t.get(tablekey);
            TableData newheadings = new TableData(oldnt.getHeadings().getA(), oldnt.getHeadings().getB(), oldnt.getHeadings().getC(), oldnt.getHeadings().getD(), oldnt.getHeadings().getE(), oldnt.getHeadings().getF(), oldnt.getHeadings().getG(), oldnt.getHeadings().getH());
            ArrayList<TableData> data = new ArrayList<TableData>();
            for (TableData olddata : oldnt.getData()) {
                data.add(new TableData(olddata.getA(), olddata.getB(), olddata.getC(), olddata.getD(), olddata.getE(), olddata.getF(), olddata.getG(), olddata.getH()));
            }
            this.tableData.put(tablekey, new NoteTable(newheadings, (ObservableList<TableData>)FXCollections.observableArrayList(data)));
        }
    }

    public Note(ViewLevel vl, double x, double y) {
        this.originalViewLevel = vl;
        this.setLocation(vl, new Point2D(x, y));
        this.title = "";
        this.details = "";
        this.filename = "";
        this.isWorld = true;
        this.isContinent = true;
        this.isKingdom = true;
        this.isProvince = true;
    }

    public Note() {
    }

    public void generateNoteInfo(ViewLevel vl, String featurename) {
        this.generateNoteInfo(vl, featurename, null);
    }

    public void generateNoteInfo(ViewLevel vl, String featurename, String specificInfo) {
        if (featurename.toLowerCase().startsWith("structure")) {
            if (this.getTitle().equals("")) {
                this.setTitle(CityDataGenerator.getName(featurename));
            }
            Point2D loc = this.getLocation(vl);
            Map<String, Object> newDetails = MapLogic.createStructureNoteDetails(featurename, loc.getX(), loc.getY());
            if (specificInfo != null) {
                newDetails.keySet().removeIf(key -> !key.equals(specificInfo));
            }
            this.setDetails(newDetails);
        } else {
            this.details = WorldAndNameData.generateFeatureNoteData(featurename);
        }
    }

    public String getXMLString() {
        StringBuilder sb = new StringBuilder("<note key=\"" + this.getKey() + "\"");
        sb.append(" originalViewLevel=\"").append((Object)this.originalViewLevel).append("\" filename=\"").append(MapDataIO.toEscapedXML(this.filename)).append("\" parent=\"").append(this.parent != null ? this.getParent().getUUID() : "").append("\"");
        if (this.getColor() != null) {
            sb.append(" color=\"").append(this.getColor().getRed()).append(",").append(this.getColor().getGreen()).append(",").append(this.getColor().getBlue()).append(",").append(this.getColor().getOpacity()).append("\"");
        }
        sb.append(" isWorld=\"").append(this.isWorld()).append("\" isContinent=\"").append(this.isContinent()).append("\" isKingdom=\"").append(this.isKingdom()).append("\" isProvince=\"").append(this.isProvince()).append("\"");
        sb.append(" title=\"").append(MapDataIO.toEscapedXML(this.title)).append("\">\n");
        sb.append("<notetext><![CDATA[").append(MapDataIO.toEscapedXML(this.details, false)).append("]]></notetext>");
        for (String k : this.tableData.keySet()) {
            NoteTable nt = this.tableData.get(k);
            sb.append("/n<table key=\"").append(k).append("\" headingA=\"").append(nt.getHeadings().getA()).append("\" headingB=\"").append(nt.getHeadings().getB()).append("\" headingC=\"").append(nt.getHeadings().getC()).append("\" headingD=\"").append(nt.getHeadings().getD()).append("\" headingE=\"").append(nt.getHeadings().getE()).append("\" headingF=\"").append(nt.getHeadings().getF()).append("\" headingG=\"").append(nt.getHeadings().getG()).append("\" headingH=\"").append(nt.getHeadings().getH()).append("\">");
            sb.append("<![CDATA[");
            for (TableData tdata : nt.getData()) {
                sb.append(tdata.getA()).append("\t").append(tdata.getB()).append("\t").append(tdata.getC()).append("\t").append(tdata.getD()).append("\t").append(tdata.getE()).append("\t").append(tdata.getF()).append("\t").append(tdata.getG()).append("\t").append(tdata.getH()).append("\n");
            }
            sb.append("]]></table>");
        }
        this.appendLocationXML(sb, ViewLevel.COSMIC);
        this.appendLocationXML(sb, ViewLevel.WORLD);
        this.appendLocationXML(sb, ViewLevel.CONTINENT);
        this.appendLocationXML(sb, ViewLevel.KINGDOM);
        this.appendLocationXML(sb, ViewLevel.PROVINCE);
        this.appendLocationXML(sb, ViewLevel.SETTLEMENT);
        this.appendLocationXML(sb, ViewLevel.BATTLEMAT);
        sb.append("</note>\n");
        return sb.toString();
    }

    private void appendLocationXML(StringBuilder sb, ViewLevel vl) {
        if (this.getLocation(vl) != null) {
            Point2D loc = this.getLocation(vl);
            sb.append("<location viewLevel=\"").append(vl.name()).append("\" x=\"").append(loc.getX()).append("\" y=\"").append(loc.getY()).append("\" />");
        }
    }

    public String getTableDataHTMLString() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.tableData.keySet()) {
            NoteTable nt = this.tableData.get(k);
            sb.append("<h3>").append(k).append("</h3>\n<table>\n<tr>\n");
            String[] headings = new String[]{nt.getHeadings().getA(), nt.getHeadings().getB(), nt.getHeadings().getC(), nt.getHeadings().getD(), nt.getHeadings().getE(), nt.getHeadings().getF(), nt.getHeadings().getG(), nt.getHeadings().getH()};
            for (String h : headings) {
                sb.append("<th>").append(h).append("</th>");
            }
            sb.append("</tr>\n");
            for (TableData tdata : nt.getData()) {
                sb.append("<tr><td>").append(tdata.getA()).append("</td><td>").append(tdata.getB()).append("</td><td>").append(tdata.getC()).append("</td><td>").append(tdata.getD()).append("</td><td>").append(tdata.getE()).append("</td><td>").append(tdata.getF()).append("</td><td>").append(tdata.getG()).append("</td><td>").append(tdata.getH()).append("</td></tr>\n");
            }
            sb.append("</table>\n");
        }
        return sb.toString();
    }

    @Override
    public MapObject clone() {
        Note n = new Note(this.originalViewLevel, this.location.get((Object)this.originalViewLevel).getX(), this.location.get((Object)this.originalViewLevel).getY());
        n.setTitle(this.title);
        n.setColor(this.color);
        n.setParent(this.parent);
        for (ViewLevel vl : this.location.keySet()) {
            n.setLocation(vl, new Point2D(this.location.get((Object)vl).getX(), this.location.get((Object)vl).getY()));
        }
        n.setFilename(this.filename);
        n.setDetails(this.details);
        n.setTableData(this.tableData);
        n.setWorld(this.isWorld);
        n.setContinent(this.isContinent);
        n.setKingdom(this.isKingdom);
        n.setProvince(this.isProvince);
        return n;
    }
}

