/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.model.TextureType;
import java.util.Map;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ShapeStyle {
    public static final ShapeStyle RIVER = new ShapeStyle("River", MapShape.StrokeType.SIMPLE, false, 10.0, (Paint)new Color(0.55, 0.7, 0.85, 1.0), null, null, null, 100.0, "river", false, false, false, false, null, null);
    public static final ShapeStyle RIVER_ISOMETRIC = new ShapeStyle("River Isometric", MapShape.StrokeType.SIMPLE, false, 3.0, (Paint)new Color(0.31, 0.57, 0.68, 1.0), null, 100.0, false, "river", true, false, true, 0.7, 14.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 3, new Color(0.8, 0.81, 0.76, 1.0), null, null, null, "ROUND", "ROUND");
    public static final ShapeStyle COAST_ISOMETRIC = new ShapeStyle("Coast Isometric", MapShape.StrokeType.COAST, false, 0.5, (Paint)new Color(0.92, 0.92, 0.92, 1.0), null, 100.0, false, "coast", true, false, true, 0.85, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 3.0, 3, new Color(0.8, 0.81, 0.76, 1.0), null, TextureType.ALL_TEXTURES.get("Sea"), null, "ROUND", "ROUND");
    public static final ShapeStyle ROAD = new ShapeStyle("Road", MapShape.StrokeType.SIMPLE, false, 10.0, (Paint)new Color(0.0, 0.0, 0.0, 1.0), null, null, null, 100.0, "road", false, false, false, false, null, null);
    public static final ShapeStyle SETTLEMENT_ROAD = new ShapeStyle("Settlement Road", MapShape.StrokeType.SIMPLE, false, 30.0, (Paint)new Color(0.0, 0.0, 0.0, 1.0), null, null, null, 100.0, "road", false, false, false, false, null, null);
    public static final ShapeStyle SETTLEMENT_RIVER = new ShapeStyle("Settlement River", MapShape.StrokeType.SIMPLE, false, 3.0, (Paint)new Color(0.31, 0.57, 0.68, 1.0), null, 100.0, false, "river", true, false, true, 0.7, 14.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 3, new Color(0.8, 0.81, 0.76, 1.0), null, null, null, "ROUND", "ROUND");
    public static final ShapeStyle TRAIL = new ShapeStyle("Trail", MapShape.StrokeType.SIMPLE, false, 10.0, (Paint)new Color(0.81, 0.71, 0.3, 1.0), null, null, null, 100.0, "trail", false, false, false, false, null, null);
    public static final ShapeStyle BORDER = new ShapeStyle("Border", MapShape.StrokeType.SIMPLE, false, 10.0, (Paint)new Color(0.81, 0.0, 0.0, 1.0), null, null, null, 100.0, "border", true, false, false, false, null, null);
    public static final ShapeStyle STONE_WALL = new ShapeStyle("Stone Wall", MapShape.StrokeType.SIMPLE, false, 15.0, (Paint)new Color(0.15, 0.15, 0.15, 1.0), null, 100.0, true, "wall", false, false, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, null, null, null, TextureType.ALL_TEXTURES.get("Rock Dark"), "SQUARE", "ROUND");
    public static final ShapeStyle DUNGEON = new ShapeStyle("Dungeon Floor/Wall", MapShape.StrokeType.SIMPLE, false, 15.0, (Paint)new Color(0.15, 0.15, 0.15, 1.0), null, 100.0, true, "dungeon", false, false, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, null, null, TextureType.ALL_TEXTURES.get("Stone Light 5x5"), TextureType.ALL_TEXTURES.get("Rock Dark"), "SQUARE", "ROUND");
    public static final ShapeStyle SHIPPING = new ShapeStyle("Shipping", MapShape.StrokeType.DOTTED, false, 10.0, (Paint)new Color(1.0, 1.0, 1.0, 1.0), null, 100.0, false, "shipping", false, false, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, null, null, null, null, "ROUND", "ROUND");
    public static final ShapeStyle COSMIC_ROUTE = new ShapeStyle("Cosmic Route", MapShape.StrokeType.DOTTED, false, 10.0, (Paint)new Color(1.0, 1.0, 1.0, 1.0), null, 100.0, false, "shipping", false, false, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, null, null, null, null, "ROUND", "ROUND");
    private String name;
    private final MapShape.StrokeType strokeType;
    private final boolean isFractal;
    private final Double strokeWidth;
    private final Paint strokePaint;
    private final Paint fillPaint;
    private final Double opacity;
    private final boolean snapVertices;
    private final String tags;
    private final boolean dropShadow;
    private final boolean innerShadow;
    private final boolean boxBlur;
    private final double dsSpread;
    private final double dsRadius;
    private final double dsOffsetX;
    private final double dsOffsetY;
    private final double insChoke;
    private final double insRadius;
    private final double insOffsetX;
    private final double insOffsetY;
    private final double bbWidth;
    private final double bbHeight;
    private final int bbIterations;
    private final Color dsColor;
    private final Color insColor;
    private final TextureType fillTexture;
    private final TextureType strokeTexture;
    private final String lineCap;
    private final String lineJoin;

    public ShapeStyle(String name, MapShape.StrokeType strokeType, boolean isFractal, double strokeWidth, Paint strokePaint, Paint fillPaint, TextureType strokeTexture, TextureType fillTexture, double opacity, String tags, boolean snapVertices, boolean dropShadow, boolean innerShadow, boolean boxBlur, Color dsColor, Color insColor) {
        this(name, strokeType, isFractal, strokeWidth, strokePaint, fillPaint, opacity, snapVertices, tags, dropShadow, innerShadow, boxBlur, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, dsColor, insColor, strokeTexture, fillTexture, "SQUARE", "ROUND");
    }

    public ShapeStyle(String name, MapShape.StrokeType strokeType, boolean isFractal, double strokeWidth, Paint strokePaint, Paint fillPaint, double opacity, boolean snapVertices, String tags, boolean dropShadow, boolean innerShadow, boolean boxBlur, double dsSpread, double dsRadius, double dsOffsetX, double dsOffsetY, double insChoke, double insRadius, double insOffsetX, double insOffsetY, double bbWidth, double bbHeight, int bbIterations, Color dsColor, Color insColor, TextureType fillTexture, TextureType strokeTexture, String lineCap, String lineJoin) {
        this.name = name;
        this.strokeType = strokeType;
        this.isFractal = isFractal;
        this.strokeWidth = strokeWidth;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        this.opacity = opacity;
        this.snapVertices = snapVertices;
        this.tags = tags;
        this.dropShadow = dropShadow;
        this.innerShadow = innerShadow;
        this.boxBlur = boxBlur;
        this.dsSpread = dsSpread;
        this.dsRadius = dsRadius;
        this.dsOffsetX = dsOffsetX;
        this.dsOffsetY = dsOffsetY;
        this.insChoke = insChoke;
        this.insRadius = insRadius;
        this.insOffsetX = insOffsetX;
        this.insOffsetY = insOffsetY;
        this.bbWidth = bbWidth;
        this.bbHeight = bbHeight;
        this.bbIterations = bbIterations;
        this.dsColor = dsColor;
        this.insColor = insColor;
        this.fillTexture = fillTexture;
        this.strokeTexture = strokeTexture;
        this.lineCap = lineCap;
        this.lineJoin = lineJoin;
    }

    public static void setupShapeStyles(Map<String, ShapeStyle> shapeStyleMap, ViewLevel viewLevel) {
        if (viewLevel == ViewLevel.BATTLEMAT) {
            shapeStyleMap.put("Dungeon Floor/Wall", DUNGEON);
            shapeStyleMap.put("Wall", STONE_WALL);
        } else if (viewLevel == ViewLevel.COSMIC) {
            shapeStyleMap.put("Cosmic Route", COSMIC_ROUTE);
        } else if (viewLevel == ViewLevel.SETTLEMENT) {
            shapeStyleMap.put("Settlement Road", SETTLEMENT_ROAD);
            shapeStyleMap.put("Settlement River", SETTLEMENT_RIVER);
        } else {
            shapeStyleMap.put("River", RIVER);
            shapeStyleMap.put("River Isometric", RIVER_ISOMETRIC);
            shapeStyleMap.put("Coast Isometric", COAST_ISOMETRIC);
            shapeStyleMap.put("Road", ROAD);
            shapeStyleMap.put("Trail", TRAIL);
            shapeStyleMap.put("Border", BORDER);
            shapeStyleMap.put("Shipping", SHIPPING);
        }
    }

    public String getXMLString() {
        if (this.name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String ft = null;
        if (this.fillTexture != null) {
            ft = this.fillTexture.getType();
        }
        String st = null;
        if (this.strokeTexture != null) {
            st = this.strokeTexture.getType();
        }
        sb.append("<shapestyle name=\"").append(this.name).append("\" strokeType=\"").append((Object)this.strokeType).append("\" isFractal=\"").append(this.isFractal).append("\" strokeWidth=\"").append(this.strokeWidth).append("\" opacity=\"").append(this.opacity).append("\" snapVertices=\"").append(this.snapVertices).append("\" tags=\"").append(this.tags).append("\" dropShadow=\"").append(this.dropShadow).append("\" innerShadow=\"").append(this.innerShadow).append("\" boxBlur=\"").append(this.boxBlur).append("\" dsSpread=\"").append(this.dsSpread).append("\" dsRadius=\"").append(this.dsRadius).append("\" dsOffsetX=\"").append(this.dsOffsetX).append("\" dsOffsetY=\"").append(this.dsOffsetY).append("\" insChoke=\"").append(this.insChoke).append("\" insRadius=\"").append(this.insRadius).append("\" insOffsetX=\"").append(this.insOffsetX).append("\" insOffsetY=\"").append(this.insOffsetY).append("\" bbWidth=\"").append(this.bbWidth).append("\" bbHeight=\"").append(this.bbHeight).append("\" bbIterations=\"").append(this.bbIterations).append("\" fillTexture=\"").append(ft).append("\" strokeTexture=\"").append(st).append("\" ");
        if (this.strokePaint != null && this.strokePaint instanceof Color) {
            sb.append(" strokePaint=\"").append(((Color)this.strokePaint).getRed()).append(",").append(((Color)this.strokePaint).getGreen()).append(",").append(((Color)this.strokePaint).getBlue()).append(",").append(((Color)this.strokePaint).getOpacity()).append("\" ");
        } else {
            sb.append(" strokePaint=\"null\" ");
        }
        if (this.fillPaint != null && this.fillPaint instanceof Color) {
            sb.append(" fillPaint=\"").append(((Color)this.fillPaint).getRed()).append(",").append(((Color)this.fillPaint).getGreen()).append(",").append(((Color)this.fillPaint).getBlue()).append(",").append(((Color)this.fillPaint).getOpacity()).append("\" ");
        } else {
            sb.append(" fillPaint=\"null\" ");
        }
        if (this.getDsColor() != null) {
            sb.append(" dscolor=\"").append(this.getDsColor().getRed()).append(",").append(this.getDsColor().getGreen()).append(",").append(this.getDsColor().getBlue()).append(",").append(this.getDsColor().getOpacity()).append("\" ");
        } else {
            sb.append(" dscolor=\"null\" ");
        }
        if (this.getInsColor() != null) {
            sb.append(" insColor=\"").append(this.getInsColor().getRed()).append(",").append(this.getInsColor().getGreen()).append(",").append(this.getInsColor().getBlue()).append(",").append(this.getInsColor().getOpacity()).append("\" ");
        } else {
            sb.append(" insColor=\"null\" ");
        }
        sb.append(" lineCap=\"").append(this.getLineCap()).append("\" ");
        sb.append(" lineJoin=\"").append(this.getLineJoin()).append("\" ");
        sb.append(" />");
        return sb.toString();
    }

    public String getLineCap() {
        return this.lineCap;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MapShape.StrokeType getStrokeType() {
        return this.strokeType;
    }

    public boolean isFractal() {
        return this.isFractal;
    }

    public Double getStrokeWidth() {
        return this.strokeWidth;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public Double getOpacity() {
        return this.opacity;
    }

    public boolean isSnapVertices() {
        return this.snapVertices;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isDropShadow() {
        return this.dropShadow;
    }

    public boolean isInnerShadow() {
        return this.innerShadow;
    }

    public boolean isBoxBlur() {
        return this.boxBlur;
    }

    public double getDsSpread() {
        return this.dsSpread;
    }

    public double getDsRadius() {
        return this.dsRadius;
    }

    public double getDsOffsetX() {
        return this.dsOffsetX;
    }

    public double getDsOffsetY() {
        return this.dsOffsetY;
    }

    public double getInsChoke() {
        return this.insChoke;
    }

    public double getInsRadius() {
        return this.insRadius;
    }

    public double getInsOffsetX() {
        return this.insOffsetX;
    }

    public double getInsOffsetY() {
        return this.insOffsetY;
    }

    public double getBbWidth() {
        return this.bbWidth;
    }

    public double getBbHeight() {
        return this.bbHeight;
    }

    public int getBbIterations() {
        return this.bbIterations;
    }

    public Color getDsColor() {
        return this.dsColor;
    }

    public Color getInsColor() {
        return this.insColor;
    }

    public TextureType getFillTexture() {
        return this.fillTexture;
    }

    public TextureType getStrokeTexture() {
        return this.strokeTexture;
    }
}

