/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import javax.imageio.ImageIO;

public class TerrainType {
    String type;
    Color bgColor;
    int elevation;
    Image icon;
    double iconSize;
    double offsetXDecimal;
    double offsetYDecimal;
    public boolean isDefaultAndUnchanged;
    String[] similarTerrain = null;
    static int count = 0;

    public TerrainType(String type, Image icon, double iconSize, Color bgcolor, int elevation, boolean isdefault) {
        this(type, icon, iconSize, bgcolor, elevation, null, isdefault, 0.0, 0.0);
    }

    public TerrainType(String type, Image icon, double iconSize, Color bgcolor, int elevation, String similarterrain, boolean isdefault, double offsetXPercent, double offsetYPercent) {
        ++count;
        this.type = type;
        this.elevation = elevation;
        this.icon = icon;
        this.iconSize = iconSize;
        this.bgColor = bgcolor;
        if (similarterrain != null) {
            this.similarTerrain = similarterrain.split(";");
        }
        this.isDefaultAndUnchanged = isdefault;
        this.offsetXDecimal = offsetXPercent;
        this.offsetYDecimal = offsetYPercent;
    }

    public void setDefaultAndUnchanged(boolean isDefaultAndUnchanged) {
        this.isDefaultAndUnchanged = isDefaultAndUnchanged;
    }

    public String[] getSimilarTerrain() {
        return this.similarTerrain;
    }

    public void setSimilarTerrain(String[] similarTerrain) {
        this.similarTerrain = similarTerrain;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public double getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(double iconSize) {
        this.iconSize = iconSize;
    }

    public double getOffsetXDecimal() {
        return this.offsetXDecimal;
    }

    public void setOffsetXDecimal(double offsetXDecimal) {
        this.offsetXDecimal = offsetXDecimal;
    }

    public double getOffsetYDecimal() {
        return this.offsetYDecimal;
    }

    public void setOffsetYDecimal(double offsetYDecimal) {
        this.offsetYDecimal = offsetYDecimal;
    }

    public static Map<String, TerrainType> setupDefaults() {
        Properties props = TerrainType.loadDefaults();
        TreeMap<String, TerrainType> terrain = new TreeMap<String, TerrainType>();
        for (Object key : props.keySet()) {
            String[] vals = props.getProperty((String)key).split("\t");
            try {
                Image img = null;
                if (vals.length == 4 || vals.length == 5) {
                    if (!vals[0].trim().equals("x")) {
                        img = LoadImage.image(TerrainType.class, vals[0]);
                    }
                    String[] colorstrs = vals[2].split(",");
                    Color color = new Color(Double.parseDouble(colorstrs[0]), Double.parseDouble(colorstrs[1]), Double.parseDouble(colorstrs[2]), Double.parseDouble(colorstrs[3]));
                    terrain.put((String)key, new TerrainType((String)key, img, Double.parseDouble(vals[1]), color, Integer.parseInt(vals[3]), true));
                }
                if (vals.length != 6) continue;
                if (!vals[0].trim().equals("x")) {
                    img = LoadImage.image(TerrainType.class, vals[0]);
                }
                Image imgtop = null;
                if (!vals[4].trim().equals("") && !vals[4].trim().equals("x")) {
                    imgtop = LoadImage.image(TerrainType.class, vals[4]);
                }
                String[] colorstrs = vals[2].split(",");
                Color color = new Color(Double.parseDouble(colorstrs[0]), Double.parseDouble(colorstrs[1]), Double.parseDouble(colorstrs[2]), Double.parseDouble(colorstrs[3]));
                terrain.put((String)key, new TerrainType((String)key, img, Double.parseDouble(vals[1]), color, Integer.parseInt(vals[3]), vals[5], true, 0.0, 0.0));
            }
            catch (Exception e) {
                System.err.println("Terrain not loaded:" + String.valueOf(key) + ":" + vals[0] + ":");
                e.printStackTrace();
            }
        }
        return terrain;
    }

    static Properties loadDefaults() {
        Properties prop = new Properties();
        try (InputStream in = new LoadGeneratorData().getTerrainProperties();){
            prop.load(in);
        }
        catch (Exception e) {
            System.err.println("Unable to load Terrain properties");
            e.printStackTrace();
        }
        return prop;
    }

    public static void loadUserTerrain(Map<String, TerrainType> terrain, String folder) {
        File dir = null;
        try {
            dir = new File(folder + File.separator + "terrain");
            TerrainType.loadUserTerrainHelper("", dir, terrain);
        }
        catch (Exception e) {
            System.err.println("Error loading custom terrain: " + String.valueOf(dir));
            e.printStackTrace();
            return;
        }
    }

    public static Boolean loadUserTerrainHelper(String prefix, File dir, Map<String, TerrainType> terrain) {
        boolean success = false;
        if (dir == null) {
            return false;
        }
        if (dir.listFiles() == null) {
            return false;
        }
        for (File f : Objects.requireNonNull(dir.listFiles())) {
            if (f.isDirectory()) {
                TerrainType.loadUserTerrainHelper(prefix + f.getName() + " ", f, terrain);
                continue;
            }
            boolean loadedFile = TerrainType.loadUserTerrainSingleFile(prefix, terrain, f, -1.0, null);
            if (!loadedFile) continue;
            success = true;
        }
        return success;
    }

    public static boolean loadUserTerrainSingleFile(String prefix, Map<String, TerrainType> terrain, File f, double sizeOverridePercent, Color backgroundColor) {
        return TerrainType.loadUserTerrainSingleFile(prefix, terrain, f, sizeOverridePercent, backgroundColor, 0.0, 0.0, 1000, "");
    }

    public static boolean loadUserTerrainSingleFile(String prefix, Map<String, TerrainType> terrain, final File f, double sizeOverridePercent, Color backgroundColor, double offsetXPercent, double offsetYPercent, int elevation, String polygonString) {
        String lowercasename;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Worldographer.getWorldographer().addStatus("Loading terrain: " + f.getName() + " from " + f.getAbsolutePath(), false);
            }
        });
        if (prefix == null) {
            prefix = "";
        }
        if (((String)prefix).endsWith(" ")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        if (((String)prefix).length() > 0 && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        if (!((lowercasename = f.getName().toLowerCase()).endsWith(".png") || lowercasename.endsWith(".gif") || lowercasename.endsWith(".jpg"))) {
            return false;
        }
        Image image = new Image(f.toURI().toString());
        if (!polygonString.isEmpty()) {
            String[] points = polygonString.split(",");
            Object[] pointInts = new Double[points.length];
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (int i = 0; i < points.length; i += 2) {
                double pt = Double.parseDouble(points[i].trim());
                if (pt < minX) {
                    minX = pt;
                }
                if (pt > maxX) {
                    maxX = pt;
                }
                pointInts[i] = pt;
                double pt2 = Double.parseDouble(points[i + 1].trim());
                if (pt2 < minY) {
                    minY = pt2;
                }
                if (pt2 > maxY) {
                    maxY = pt2;
                }
                pointInts[i + 1] = pt2;
            }
            PixelReader pr = image.getPixelReader();
            WritableImage writableImage = new WritableImage((int)(maxX - minX - 2.0), (int)(maxY - minY - 2.0));
            PixelWriter pw = writableImage.getPixelWriter();
            Polygon polygon = new Polygon();
            polygon.getPoints().addAll(pointInts);
            int x = 0;
            while ((double)x < maxX - minX - 2.0) {
                int y = 0;
                while ((double)y < maxY - minY - 2.0) {
                    if (polygon.contains((double)x + minX + 1.0, (double)y + minY + 1.0)) {
                        pw.setColor(x, y, pr.getColor(x + (int)minX + 1, y + (int)minY + 1));
                    }
                    ++y;
                }
                ++x;
            }
            image = writableImage;
        }
        if (!f.getName().contains("--")) {
            double size = 0.8;
            if (sizeOverridePercent >= 0.0) {
                size = sizeOverridePercent / 100.0;
            }
            String name = f.getName().substring(0, f.getName().lastIndexOf("."));
            terrain.put((String)prefix + name, new TerrainType((String)prefix + name, image, size, backgroundColor != null ? backgroundColor : Color.GRAY, elevation, null, false, offsetXPercent / 100.0, offsetYPercent / 100.0));
            return false;
        }
        String name = f.getName().substring(0, f.getName().lastIndexOf("--"));
        String valstr = f.getName().substring(f.getName().lastIndexOf("--") + 2, f.getName().lastIndexOf("."));
        String[] vals = valstr.split("-");
        if (vals.length == 6) {
            Object elev;
            Color color = new Color(Double.parseDouble(vals[1]) / 100.0, Double.parseDouble(vals[2]) / 100.0, Double.parseDouble(vals[3]) / 100.0, Double.parseDouble(vals[4]) / 100.0);
            if (backgroundColor != null) {
                color = backgroundColor;
            }
            if (((String)(elev = vals[5])).startsWith("n")) {
                elev = "-" + vals[5].substring(1);
            }
            double size = Double.parseDouble(vals[0]) / 100.0;
            if (sizeOverridePercent >= 0.0) {
                size = sizeOverridePercent / 100.0;
            }
            terrain.put((String)prefix + name, new TerrainType((String)prefix + name, image, size, color, Integer.parseInt((String)elev), null, false, offsetXPercent / 100.0, offsetYPercent / 100.0));
        } else if (vals.length == 2) {
            Object elev = vals[1];
            if (((String)elev).startsWith("n")) {
                elev = "-" + ((String)elev).substring(1);
            }
            double size = Double.parseDouble(vals[0]) / 100.0;
            if (sizeOverridePercent >= 0.0) {
                size = sizeOverridePercent / 100.0;
            }
            PixelReader pr = image.getPixelReader();
            Color c1 = pr.getColor((int)(image.getWidth() * 0.35), (int)(image.getHeight() * 0.35));
            Color c2 = pr.getColor((int)(image.getWidth() * 0.65), (int)(image.getHeight() * 0.35));
            Color c3 = pr.getColor((int)(image.getWidth() * 0.5), (int)(image.getHeight() * 0.35));
            Color c4 = pr.getColor((int)(image.getWidth() * 0.5), (int)(image.getHeight() * 0.5));
            Color c5 = pr.getColor((int)(image.getWidth() * 0.5), (int)(image.getHeight() * 0.5));
            Color c6 = pr.getColor((int)(image.getWidth() * 0.5), (int)(image.getHeight() * 0.65));
            Color c7 = pr.getColor((int)(image.getWidth() * 0.35), (int)(image.getHeight() * 0.65));
            Color c8 = pr.getColor((int)(image.getWidth() * 0.65), (int)(image.getHeight() * 0.65));
            double red = (c1.getRed() + c2.getRed() + c3.getRed() + c4.getRed() + c5.getRed() + c6.getRed() + c7.getRed() + c8.getRed()) / 8.0;
            double green = (c1.getGreen() + c2.getGreen() + c3.getGreen() + c4.getGreen() + c5.getGreen() + c6.getGreen() + c7.getGreen() + c8.getGreen()) / 8.0;
            double blue = (c1.getBlue() + c2.getBlue() + c3.getBlue() + c4.getBlue() + c5.getBlue() + c6.getBlue() + c7.getBlue() + c8.getBlue()) / 8.0;
            terrain.put((String)prefix + name, new TerrainType((String)prefix + name, image, size, new Color(red, green, blue, 1.0), Integer.parseInt((String)elev), null, false, offsetXPercent / 100.0, offsetYPercent / 100.0));
        } else {
            double size = 0.8;
            if (sizeOverridePercent >= 0.0) {
                size = sizeOverridePercent / 100.0;
            }
            terrain.put((String)prefix + name, new TerrainType((String)prefix + name, image, size, backgroundColor != null ? backgroundColor : Color.GRAY, elevation, null, false, offsetXPercent / 100.0, offsetYPercent / 100.0));
        }
        return true;
    }

    public void writeXMLString(Writer w) throws IOException {
        StringBuilder similarTerrainString = new StringBuilder();
        if (this.similarTerrain != null) {
            for (int i = 0; i < this.similarTerrain.length; ++i) {
                if (i != 0) {
                    similarTerrainString.append(":::");
                }
                similarTerrainString.append(this.similarTerrain[i]);
            }
        }
        w.write("<terraintype type=\"" + MapDataIO.toEscapedXML(this.type) + "\" elevation=\"" + this.elevation + "\" similarTerrain=\"" + String.valueOf(similarTerrainString) + "\" iconSize=\"" + this.iconSize + "\" isDefault=\"" + this.isDefaultAndUnchanged + "\"");
        if (this.getOffsetXDecimal() != 0.0) {
            w.write(" offsetXDecimal=\"" + this.offsetXDecimal + "\"");
        }
        if (this.getOffsetYDecimal() != 0.0) {
            w.write(" offsetYDecimal=\"" + this.offsetYDecimal + "\"");
        }
        if (this.getBgColor() != null) {
            w.write(" color=\"" + this.getBgColor().getRed() + "," + this.getBgColor().getGreen() + "," + this.getBgColor().getBlue() + "," + this.getBgColor().getOpacity() + "\" >");
        } else {
            w.write(" color=\"null\" >");
        }
        if (this.icon != null) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)this.icon, null), "png", bas);
            w.write(Base64.encodeObject((Serializable)bas.toByteArray()));
        }
        w.write("</terraintype>\n");
        w.flush();
    }
}

