/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;

public class TextureType {
    public String type;
    Image icon;
    public boolean isDefaultAndUnchanged;
    int width;
    public static final Map<String, TextureType> ALL_TEXTURES;

    public TextureType(String type, Image icon, boolean isDefaultAndUnchanged, int w) {
        this.type = type;
        this.icon = icon;
        this.isDefaultAndUnchanged = isDefaultAndUnchanged;
        this.width = w;
    }

    public static void loadUserTextures(String folder) {
        File dir = null;
        try {
            dir = new File(folder + File.separator + "textures");
            TextureType.loadUserTexturesHelper("", dir);
        }
        catch (Exception e) {
            System.err.println("Custom Textures folder not found: " + String.valueOf(dir));
        }
    }

    public static void loadUserTexturesHelper(String prefix, File dir) {
        for (File f : Objects.requireNonNull(dir.listFiles())) {
            if (f.isDirectory()) {
                TextureType.loadUserTexturesHelper(prefix + f.getName() + " ", f);
                continue;
            }
            TextureType.loadUserTextureSingleFile(f);
        }
    }

    public static boolean loadUserTextureSingleFile(final File f) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Worldographer.getWorldographer().addStatus("Loading texture: " + f.getName() + " from " + f.getAbsolutePath(), false);
            }
        });
        String name = f.getName();
        if (!(name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".png"))) {
            return false;
        }
        int w = 174;
        if (name.contains("-")) {
            try {
                w = Integer.parseInt(name.substring(name.lastIndexOf("-") + 1, name.lastIndexOf(".")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Image image = new Image(f.toURI().toString());
        name = name.substring(0, f.getName().lastIndexOf(46));
        ALL_TEXTURES.put(name, new TextureType(name, image, false, w));
        return true;
    }

    public void setDefaultAndUnchanged(boolean isDefaultAndUnchanged) {
        this.isDefaultAndUnchanged = isDefaultAndUnchanged;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String toString() {
        return this.type;
    }

    public void writeXMLString(Writer w) throws IOException {
        w.write("<texturetype type=\"" + this.type + "\" width=\"" + this.getWidth() + "\" isDefault=\"" + this.isDefaultAndUnchanged + "\">");
        if (this.icon != null) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)this.icon, null), "png", bas);
            w.write(Base64.encodeObject((Serializable)bas.toByteArray()));
        }
        w.write("</texturetype>\n");
    }

    static {
        String[] keys;
        ALL_TEXTURES = new TreeMap<String, TextureType>();
        for (String key : keys = new String[]{"Badlands", "Beach", "Blacktop", "Brick Floor Brown", "Brick Floor Grey", "Brick Floor Red", "Cobblestone", "Cobblestone Dark", "Cobblestone Light", "Desert Dark Floor", "Desert Floor", "Flagstones", "Flagstones Dark", "Flagstones Light", "Forest Dead", "Forest Deciduous", "Forest Evergreen", "Forest Floor", "Forest Fungal", "Forest Jungle", "Forest Mixed", "Grass", "Grassland", "Hills", "Jungle", "Mountain", "Rock Dark", "Rock Light", "Rock Medium", "Desert Rocky", "Mountain Floor", "Pavers Dark", "Pavers", "Pavers Light", "Rough Stone Dark", "Rough Stone Light", "Rough Stone Dark", "Stone Light", "Stone Light 5x5", "Desert Sandy", "Savannah", "Sea", "Shrubland", "Swamp", "Tile Deluxe", "Volcano", "Water", "Wood", "Wood Dark", "Wood Light", "Wood Vert", "Wood Dark Vert", "Wood Light Vert", "Wood Wall Pine", "Wood Wall Walnut", "Wood Wall Weathered"}) {
            Image img;
            String fname = key.toLowerCase();
            fname = fname.replaceAll(" ", "_");
            try {
                img = LoadImage.image(TextureType.class, "textures/" + fname + ".png");
            }
            catch (Exception e) {
                try {
                    img = LoadImage.image(TextureType.class, "textures/" + fname + ".jpg");
                }
                catch (Exception ex) {
                    img = LoadImage.image(TextureType.class, "textures/" + fname + ".gif");
                }
            }
            if (key.equals("Stone Light") || key.equals("Stone Light 5x5") || key.startsWith("Floor Wood ")) {
                ALL_TEXTURES.put(key, new TextureType(key, img, true, 300));
                continue;
            }
            if (key.equals("Tile Deluxe")) {
                ALL_TEXTURES.put(key, new TextureType(key, img, true, 200));
                continue;
            }
            if (key.equals("Forest Floor") || key.equals("Desert Floor") || key.equals("Mountain Floor")) {
                ALL_TEXTURES.put(key, new TextureType(key, img, true, 1500));
                continue;
            }
            if (key.equals("Wood") || key.equals("Wood Dark") || key.equals("Wood Light") || key.equals("Wood Vert") || key.equals("Wood Dark Vert") || key.equals("Wood Light Vert")) {
                ALL_TEXTURES.put(key, new TextureType(key, img, true, 300));
                continue;
            }
            if (key.equals("Rock Dark") || key.equals("Rock Light") || key.equals("Rock Medium") || key.equals("Wood Wall Pine") || key.equals("Wood Wall Walnut") || key.equals("Wood Wall Weathered") || key.equals("Brick Floor Brown") || key.equals("Brick Floor Grey") || key.equals("Brick Floor Red")) {
                ALL_TEXTURES.put(key, new TextureType(key, img, true, 299));
                continue;
            }
            ALL_TEXTURES.put(key, new TextureType(key, img, true, 174));
        }
    }
}

