/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapDataSetTerrain;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.undo.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javafx.concurrent.Task;
import javafx.scene.shape.Polygon;
import javafx.util.Pair;

public class GenerateMapTask
extends Task<MapDataSetup> {
    final MapDataSetup setup;
    final ViewLevel viewLevel;
    final List<Feature> features;
    final List<MapLayer> mapLayers;
    final MapLayer featuresLayer;
    final SetupWorldRegionScreen.TerrainStyle terrainstyle;
    final int landFrequency;
    final int mountainFrequency;
    final int vegetationFrequency;
    final int desertFrequency;
    final int swampFrequency;
    final int swampContinueFrequency;
    final int icyFrequency;
    final int tropicalFrequency;
    final boolean isPreview;
    private final boolean driftCluster;
    private final double cluster;
    String landForm;
    double deltatthreshold = 0.0;
    TreeMap<String, Polygon> terrainpolys;
    Random random;
    Map<String, String> terrainSubstitutions;

    public GenerateMapTask(Worldographer worldographer, MapDataSetup setup, ViewLevel vl, SetupWorldRegionScreen.TerrainStyle terrainstyle, int landfreq, String landForm, double cluster, boolean driftCluster, int mountainfreq, int vegfreq, int desertfreq, int swampfreq, int swampcontinuefreq, int icyfreq, int tropicalfreq, boolean isPreview, int seed, Map<String, String> terrainSubstitutions) {
        this.random = new Random(seed);
        this.setup = setup;
        this.viewLevel = vl;
        this.features = new ArrayList<Feature>();
        setup.features = this.features;
        setup.terrainStyle = terrainstyle;
        this.mapLayers = new ArrayList<MapLayer>();
        this.mapLayers.add(new MapLayer("Labels"));
        this.mapLayers.add(new MapLayer("Grid"));
        this.featuresLayer = new MapLayer("Features");
        this.mapLayers.add(this.featuresLayer);
        this.mapLayers.add(new MapLayer("Above Terrain"));
        this.mapLayers.add(new MapLayer("Terrain Land"));
        this.mapLayers.add(new MapLayer("Above Water"));
        this.mapLayers.add(new MapLayer("Terrain Water"));
        this.mapLayers.add(new MapLayer("Below All"));
        setup.mapLayers = this.mapLayers;
        this.terrainstyle = terrainstyle;
        this.landFrequency = landfreq;
        this.landForm = landForm;
        this.cluster = cluster * 0.01;
        this.driftCluster = driftCluster;
        this.mountainFrequency = mountainfreq;
        this.vegetationFrequency = vegfreq;
        this.desertFrequency = desertfreq;
        this.swampFrequency = swampfreq;
        this.swampContinueFrequency = swampcontinuefreq;
        this.icyFrequency = icyfreq;
        this.tropicalFrequency = tropicalfreq;
        this.isPreview = isPreview;
        this.terrainSubstitutions = terrainSubstitutions;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
        worldographer.getCancelButton().setDisable(false);
        worldographer.getCancelButton().setOnAction(t -> {
            this.cancel();
            worldographer.getCancelButton().setDisable(true);
            worldographer.getMapUI().draw();
        });
    }

    protected MapDataSetup call() throws InterruptedException {
        this.updateMessage("Starting . . .");
        Terrain[][] t = this.setup.getTerrainByViewLevel(this.viewLevel);
        int triangleSize = this.setup.view.triangleSize;
        if (!this.isCancelled()) {
            if (this.setup.mapProjection == MapProjection.ICOSAHEDRAL) {
                t = this.generateIcosahedralMap(this.setup, t, triangleSize);
            } else {
                for (int y = 0; y < t[0].length; ++y) {
                    for (int x = 0; x < t.length; ++x) {
                        t[x][y] = new Terrain("Classic/Water Ocean", true);
                    }
                }
            }
        }
        Pair<Double, Double> totalLandAndMountains = new Pair<Double, Double>((Object)0.0, (Object)0.0);
        int totalNotEmptyTerrain = 0;
        if (!this.isCancelled()) {
            Terrain[][] terrainArray = t;
            int n = terrainArray.length;
            for (int i = 0; i < n; ++i) {
                Terrain[] terrains;
                for (Terrain terrain : terrains = terrainArray[i]) {
                    if (terrain.getTypeName() == null) {
                        terrain.setType("Empty");
                    }
                    if (!terrain.getTypeName().equals("Classic/Water Ocean")) continue;
                    ++totalNotEmptyTerrain;
                }
            }
            totalLandAndMountains = this.generateLandMountains(this.setup, t, triangleSize, totalNotEmptyTerrain);
        }
        if (!this.isCancelled()) {
            this.setup.features.addAll(this.generateVegetation(t, totalNotEmptyTerrain, totalLandAndMountains, this.setup.hexOrientation, this.viewLevel, this.featuresLayer));
        }
        if (this.setup.mapProjection == MapProjection.FLAT) {
            this.centerTerrain(t);
        }
        if (!this.isCancelled()) {
            if (this.terrainSubstitutions.size() > 0) {
                this.updateMessage("Setting substitute terrain types.");
                HashMap substitutionsMap = new HashMap();
                for (String terrainName : this.terrainSubstitutions.values()) {
                    ArrayList<String> subs = (ArrayList<String>)substitutionsMap.get(terrainName);
                    if (subs != null) continue;
                    subs = new ArrayList<String>();
                    String subTerrainName = terrainName.substring(0, terrainName.length() - 2);
                    for (String name : Terrain.terrainTypes.keySet()) {
                        int lengthDiff;
                        if (!name.startsWith(subTerrainName) || (lengthDiff = Math.abs(name.length() - subTerrainName.length())) > 3) continue;
                        subs.add(name);
                    }
                    substitutionsMap.put(terrainName, subs);
                }
                this.updateMessage("Substituting terrain map setup:" + substitutionsMap.size());
                for (int i = 0; i < t.length; ++i) {
                    this.updateMessage("Substituting terrain:" + i * t[i].length + "/" + t.length * t[i].length);
                    for (int j = 0; j < t[i].length; ++j) {
                        String newTerrainType = this.terrainSubstitutions.get(t[i][j].getTypeName());
                        if (newTerrainType == null) continue;
                        List alternateTerrainList = (List)substitutionsMap.get(newTerrainType);
                        String alternateTerrainName = (String)alternateTerrainList.get((int)(Math.random() * (double)alternateTerrainList.size()));
                        if (newTerrainType == null) continue;
                        t[i][j].setType(alternateTerrainName, false);
                    }
                }
            }
            this.updateMessage("Substituting terrain done");
            if (this.terrainstyle == SetupWorldRegionScreen.TerrainStyle.Isometric && !this.isPreview) {
                this.updateMessage("Setting isometric.");
                MapDataSetTerrain.setTerrainToIsometric(t, this.setup.features, null, this.setup.hexOrientation, null);
            }
        }
        this.updateMessage("Finished.");
        return this.setup;
    }

    public void centerTerrain(Terrain[][] t) {
        int lastLandColumn = t.length - 1;
        for (int i = t.length - 1; i >= 0; --i) {
            int waterCount = 0;
            for (int j = 0; j < t[i].length; ++j) {
                if (!t[i][j].getTypeName().toLowerCase(Locale.ROOT).contains("water")) continue;
                ++waterCount;
            }
            if (!(1.0 * (double)waterCount / (double)t[i].length < 0.97)) continue;
            lastLandColumn = i;
            break;
        }
        int firstLandColumn = 0;
        for (int i = 0; i < t.length; ++i) {
            int waterCount = 0;
            for (int j = 0; j < t[i].length; ++j) {
                if (!t[i][j].getTypeName().toLowerCase(Locale.ROOT).contains("water")) continue;
                ++waterCount;
            }
            if (!(1.0 * (double)waterCount / (double)t[i].length < 0.97)) continue;
            firstLandColumn = i;
            break;
        }
        if (firstLandColumn != 0 || lastLandColumn != t.length - 1) {
            int waterColsRight = t.length - 1 - lastLandColumn;
            System.out.println("centering:" + firstLandColumn + ":" + lastLandColumn + ":" + waterColsRight);
            if (firstLandColumn - 1 > waterColsRight || firstLandColumn < waterColsRight - 1) {
                int i;
                int shift = (firstLandColumn - waterColsRight) / 2;
                System.out.println("shift:" + shift);
                Terrain[][] t2 = new Terrain[t.length][t[0].length];
                for (i = 0; i < t.length; ++i) {
                    int index = i + shift;
                    if (index < 0) {
                        index += t.length;
                    }
                    if (index >= t.length) {
                        index -= t.length;
                    }
                    for (int j = 0; j < t[i].length; ++j) {
                        t2[i][j] = t[index][j];
                    }
                }
                for (i = 0; i < t.length; ++i) {
                    for (int j = 0; j < t[i].length; ++j) {
                        t[i][j] = t2[i][j];
                    }
                }
            }
        }
    }

    public Pair<Double, Double> getModelPtFromTerrain(HexOrientation ho, double i, double j) {
        if (ho == HexOrientation.COLUMNS) {
            return new Pair((Object)(i * 225.0 + 150.0), (Object)(j * 300.0 + (double)(i % 2.0 == 1.0 ? 300 : 150)));
        }
        return new Pair((Object)(i * 300.0 + (double)(j % 2.0 == 1.0 ? 300 : 150)), (Object)(j * 225.0 + 150.0));
    }

    private Terrain[][] generateIcosahedralMap(MapDataSetup setup, Terrain[][] t, int triangleSize) {
        this.updateMessage("Generating Icosahedral Map...");
        t = HexOrientation.ROWS == setup.hexOrientation ? this.setIcosahedralToWaterIfOrientationRows(setup, triangleSize) : this.setIcosahedralToWaterIfOrientationColumns(setup, triangleSize);
        return t;
    }

    private Terrain[][] setIcosahedralToWaterIfOrientationRows(MapDataSetup setup, int triangleSize) {
        if (triangleSize % 2 == 1) {
            // empty if block
        }
        Terrain[][] t = new Terrain[(int)((double)triangleSize * 5.5) + 2][triangleSize * 3 + 1];
        setup.setTerrainByViewLevel(this.viewLevel, t);
        for (int x = 0; x < t.length; ++x) {
            for (int y = 0; y < t[x].length; ++y) {
                t[x][y] = new Terrain("Empty", true);
            }
        }
        for (int y = 1; y < t[0].length + 1; ++y) {
            int i;
            int j;
            int offset = 0;
            if (triangleSize % 2 == 1 && y % 2 == 1) {
                offset = 1;
            }
            if (y <= triangleSize) {
                int start = (triangleSize - (y - 1)) / 2;
                for (j = 0; j < 5; ++j) {
                    for (i = start; i < start + y; ++i) {
                        if (i == start + y - 1) {
                            t[j * triangleSize + i + offset][y - 1] = t[(j + 1) * triangleSize % (triangleSize * 5) + start + offset][y - 1];
                        }
                        t[j * triangleSize + i + offset][y - 1].setType("Classic/Water Ocean");
                    }
                }
                if (y != 1) continue;
                for (j = 1; j < 5; ++j) {
                    t[(j + 1) * triangleSize - triangleSize / 2][0] = t[1 * triangleSize - triangleSize / 2][0];
                }
                continue;
            }
            if (y <= triangleSize * 2 + 1) {
                for (int x = 0; x <= triangleSize * 5; ++x) {
                    t[x + (y - 1 - triangleSize) / 2 + offset][y - 1].setType("Classic/Water Ocean");
                    if (x != triangleSize * 5) continue;
                    t[x + (y - 1 - triangleSize) / 2 + offset][y - 1] = t[(y - 1 - triangleSize) / 2 + offset][y - 1];
                }
                continue;
            }
            if (y > triangleSize * 3 + 1) continue;
            if (triangleSize % 2 == 1) {
                offset = 0;
            }
            if (triangleSize % 2 == 0 && y % 2 == 0) {
                offset = -1;
            }
            int frombottom = t[y].length - y;
            for (j = 0; j < 5; ++j) {
                for (i = 0; i <= frombottom; ++i) {
                    t[j * triangleSize + (triangleSize - frombottom / 2) + i + offset][y - 1].setType("Classic/Water Ocean");
                    if (i != frombottom) continue;
                    int switchwith = j * triangleSize + (triangleSize - frombottom / 2) + i + triangleSize - frombottom + offset;
                    if (switchwith > triangleSize * 5) {
                        switchwith %= triangleSize * 5;
                    }
                    t[j * triangleSize + (triangleSize - frombottom / 2) + i + offset][y - 1] = t[switchwith][y - 1];
                }
            }
            if (y != t[0].length - 1) continue;
            for (j = 1; j < 5; ++j) {
                t[(j + 1) * triangleSize][t[0].length - 1] = t[1 * triangleSize][t[0].length - 1];
            }
        }
        return t;
    }

    private Terrain[][] setIcosahedralToWaterIfOrientationColumns(MapDataSetup setup, int triangleSize) {
        Terrain[][] t = new Terrain[(int)((double)triangleSize * 5.5) + 1][(int)((double)triangleSize * 2.25) + 1];
        setup.setTerrainByViewLevel(this.viewLevel, t);
        for (int x = 0; x < t.length; ++x) {
            for (int y = 0; y < t[x].length; ++y) {
                t[x][y] = new Terrain("Empty", true);
            }
        }
        int topindent = triangleSize / 2;
        int topdiff = 1;
        int middleindent = 1;
        int bottomindent = 0;
        int bottomdiff = triangleSize - 1;
        for (int y = 0; y < t[0].length; ++y) {
            int i;
            int j;
            if (topindent >= 0) {
                for (j = 0; j < 5; ++j) {
                    for (i = topindent; i < topindent + topdiff; ++i) {
                        if ((y == 0 || i == topindent + topdiff - 1) && y % 3 != 2) {
                            t[j * triangleSize + i][y] = t[((j + 1) * triangleSize + topindent) % (triangleSize * 5)][y];
                        }
                        t[j * triangleSize + i][y].setType("Classic/Water Ocean");
                    }
                }
                if (y % 3 == 1) continue;
                --topindent;
                topdiff += 2;
                continue;
            }
            if (middleindent <= triangleSize / 2) {
                for (int i2 = middleindent; i2 <= middleindent + triangleSize * 5; ++i2) {
                    t[i2][y].setType("Classic/Water Ocean");
                }
                if (y % 3 == 2) continue;
                ++middleindent;
                continue;
            }
            for (j = 0; j < 5; ++j) {
                for (i = bottomindent; i < bottomindent + bottomdiff; ++i) {
                    if ((y == 0 || i == bottomindent + bottomdiff - 1) && y % 3 != 2) {
                        t[j * triangleSize + i + middleindent][y] = t[((j + 1) * triangleSize + bottomindent + middleindent) % (triangleSize * 5)][y];
                    }
                    t[j * triangleSize + i + middleindent][y].setType("Classic/Water Ocean");
                }
            }
            if (y % 3 == 2) continue;
            ++bottomindent;
            bottomdiff -= 2;
        }
        return t;
    }

    private Pair<Double, Double> generateLandMountains(MapDataSetup setup, Terrain[][] t, int triangleSize, int totalNotEmptyTerrain) {
        this.updateMessage("Generating land & mountains...");
        this.deltatthreshold = 1.0 / (double)((t.length + t[0].length) / 4);
        double mf = 0.01 * (double)this.mountainFrequency;
        int land = 0;
        double landQuota = (int)((double)this.landFrequency / 100.0 * (double)totalNotEmptyTerrain);
        double mntns = 0.0;
        int lastx = -1;
        int lasty = -1;
        int fails = 0;
        int priorland = 0;
        while ((double)land < landQuota && fails < 100) {
            int x = (int)(this.random.nextDouble() * (double)t.length);
            int y = (int)(this.random.nextDouble() * (double)t[0].length);
            if (t.length > 25 && t[0].length > 18 && this.landFrequency < 70) {
                x = (int)(this.random.nextDouble() * ((double)t.length - (double)t.length * 0.15)) + (int)((double)t.length * 0.075);
                y = (int)(this.random.nextDouble() * ((double)t[0].length - (double)t[0].length * 0.08)) + (int)((double)t[0].length * 0.04);
                for (int i = 0; i < 3; ++i) {
                    int distance1;
                    int y2;
                    int x2;
                    int distance2;
                    if (lastx < 0 || !(this.random.nextDouble() < this.cluster) || (distance2 = (lastx - (x2 = (int)(this.random.nextDouble() * ((double)t.length - (double)t.length * 0.15)) + (int)((double)t.length * 0.075))) * (lastx - x2) + (lasty - (y2 = (int)(this.random.nextDouble() * ((double)t[0].length - (double)t[0].length * 0.08)) + (int)((double)t[0].length * 0.04))) * (lasty - y2)) >= (distance1 = (lastx - x) * (lastx - x) + (lasty - y) * (lasty - y))) continue;
                    x = x2;
                    y = y2;
                }
                if (lastx < 0 || this.driftCluster) {
                    System.out.println(x + "," + y);
                    lastx = x;
                    lasty = y;
                }
            }
            if (t[x][y].getTypeName().equals("empty")) continue;
            HashMap<Point, Terrain> terraintoadd = new HashMap<Point, Terrain>();
            int verthor = (int)(this.random.nextDouble() * 3.0);
            double maxThreshold = 0.9;
            if (this.landForm.equals("Small Islands")) {
                maxThreshold = 0.1;
            } else if (this.landForm.equals("Islands & Small Continents")) {
                maxThreshold = 0.3;
            } else if (this.landForm.equals("Continents & Some Islands")) {
                maxThreshold = 0.6;
            } else if (this.landForm.equals("Mostly Large Continents")) {
                maxThreshold = 0.9;
            }
            double thres = 0.1 + maxThreshold * this.random.nextDouble();
            this.generateLandHelper(x, y, t, terraintoadd, thres, verthor);
            for (Terrain ti : terraintoadd.values()) {
                if (!"Classic/Water Ocean".equals(ti.getTypeName())) continue;
                ti.setType("Classic/Flat Farmland");
                this.updateMessage("Land:" + ++land + "/" + landQuota);
            }
            fails = land == priorland ? ++fails : 0;
            priorland = land;
        }
        Double mountains = this.generateMountains(t, mf, land, mntns, setup.hexOrientation);
        return new Pair((Object)landQuota, (Object)mountains);
    }

    private double generateMountains(Terrain[][] t, double mf, int land, double mountainCount, HexOrientation hexOrientation) {
        int mountainQuota = (int)((double)land * mf);
        int maxRadius = Math.max(t.length, t[0].length) / 60;
        if (maxRadius < 2) {
            maxRadius = 2;
        }
        block0: while (mountainCount < (double)mountainQuota) {
            int radius;
            int n = radius = maxRadius > 2 ? (int)((double)maxRadius * this.random.nextDouble()) : maxRadius;
            if (radius < 2) {
                radius = 2;
            }
            double chanceRepeat = 1.0;
            this.updateMessage("Mountains added:" + (int)mountainCount + "/" + mountainQuota);
            mountainCount += 0.1;
            double moveX = 0.0;
            double moveY = 0.0;
            double xa = this.random.nextDouble() * (double)(t.length - radius * 2) + (double)radius;
            double ya = this.random.nextDouble() * (double)(t[(int)xa].length - radius * 2) + (double)radius;
            double repeat = this.random.nextDouble();
            while (mountainCount < (double)mountainQuota && repeat < chanceRepeat) {
                chanceRepeat *= 0.95;
                if (moveX == 0.0 && moveY == 0.0) {
                    moveX = (double)radius * this.random.nextDouble() * (double)(this.random.nextBoolean() ? 1 : -1);
                    moveY = (double)radius * this.random.nextDouble() * (double)(this.random.nextBoolean() ? 1 : -1);
                } else {
                    xa += moveX;
                    ya += moveY;
                }
                int r = (int)((double)radius - (double)radius * 0.5 + (double)radius * this.random.nextDouble());
                if (xa < 0.0 || ya < 0.0 || xa >= (double)t.length || ya >= (double)t[0].length) continue block0;
                for (int x = (int)(xa - (double)r); x < (int)(xa + (double)r); ++x) {
                    int dx = (int)Math.abs(xa - (double)x);
                    for (int y = (int)(ya - (double)r); y < (int)(ya + (double)r); ++y) {
                        int dy = (int)Math.abs(ya - (double)y);
                        int distanceSquared = dx * dx + dy * dy;
                        if (!((double)distanceSquared <= (double)(r * r) * (1.0 - this.random.nextDouble() * this.random.nextDouble())) || x < 0 || y < 0 || x >= t.length || y >= t[0].length) continue;
                        if ("Classic/Flat Farmland".equals(t[x][y].getTypeName())) {
                            mountainCount += 1.0;
                            t[x][y].setType("Classic/Hills");
                            continue;
                        }
                        if (!"Classic/Hills".equals(t[(int)xa][(int)ya].getTypeName())) continue;
                        t[x][y].setType("Classic/Mountains");
                        Map<Point, Terrain> adjTerrain = MapLogic.getAdjTerrainPoint(t, hexOrientation, x, y);
                        for (Terrain adjT : adjTerrain.values()) {
                            if (!(this.random.nextDouble() < 0.5) || !"Classic/Hills".equals(t[(int)xa][(int)ya].getTypeName())) continue;
                            adjT.setType("Classic/Mountains");
                        }
                    }
                }
            }
        }
        return mountainCount;
    }

    private void generateLandHelper(int x, int y, Terrain[][] t, Map<Point, Terrain> terrainToAdd, double threshold, int verthor) {
        if (threshold < 0.0) {
            return;
        }
        Map<Point, Terrain> adjacent = MapLogic.getAdjTerrainPoint(t, this.setup.hexOrientation, x, y);
        for (Point key : adjacent.keySet()) {
            if (!(this.random.nextDouble() < threshold) || terrainToAdd.containsKey(key) || t[(int)key.getX()][(int)key.getY()].getTypeName().contains("Empty")) continue;
            terrainToAdd.put(key, t[(int)key.getX()][(int)key.getY()]);
            double newthreshold = threshold - this.deltatthreshold;
            if (verthor == 1 && key.getY() == (double)y) {
                newthreshold = threshold - (this.deltatthreshold - this.deltatthreshold / 3.0);
            } else if (verthor == 1 && key.getY() != (double)y) {
                newthreshold = threshold - (this.deltatthreshold + this.deltatthreshold / 3.0);
            } else if (verthor == 2 && key.getX() == (double)x) {
                newthreshold = threshold - (this.deltatthreshold - this.deltatthreshold / 3.0);
            } else if (verthor == 2 && key.getX() != (double)x) {
                newthreshold = threshold - (this.deltatthreshold + this.deltatthreshold / 3.0);
            }
            this.generateLandHelper((int)key.getX(), (int)key.getY(), t, terrainToAdd, newthreshold, verthor);
        }
    }

    public List<Feature> generateVegetation(Terrain[][] t, int landQuota, Pair<Double, Double> totalLandAndMountains, HexOrientation ho, ViewLevel vl, MapLayer featureLayer) {
        this.updateMessage("Generating vegetation...");
        double totalland = (Double)totalLandAndMountains.getKey();
        double mountains = (Double)totalLandAndMountains.getValue();
        int vegQuota = (int)(totalland * ((double)this.vegetationFrequency * 0.01));
        this.addVegetation(t, vegQuota);
        this.convertSomeVegetationToSwamps(t, ho);
        int remainingFarmland = 0;
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[i].length; ++j) {
                if (!t[i][j].getTypeName().contains("Farmland")) continue;
                ++remainingFarmland;
            }
        }
        int desertQuota = (int)((double)remainingFarmland * ((double)this.desertFrequency * 0.01));
        this.addDesert(desertQuota, t, (int)totalland, vegQuota, (int)mountains, ho);
        List<Feature> features = this.addVolcanoes((int)totalland, t, ho, vl, featureLayer);
        this.applyClimate(t);
        return features;
    }

    private void convertSomeVegetationToSwamps(Terrain[][] t, HexOrientation ho) {
        this.updateMessage("Converting to Swamp...");
        int startx = this.random.nextInt(t.length);
        int starty = this.random.nextInt(t[startx].length);
        for (int i = startx; i < startx + t.length; ++i) {
            int tx = i % t.length;
            for (int j = starty; j < starty + t[0].length; ++j) {
                int ty = j % t[0].length;
                if (!t[tx][ty].getTypeName().toLowerCase(Locale.ROOT).contains("flat forest")) continue;
                Map<Point, Terrain> adjacentTerrain = MapLogic.getAdjTerrainPoint(t, ho, tx, ty);
                boolean coast = false;
                for (Terrain adjTerrain : adjacentTerrain.values()) {
                    if (!adjTerrain.getTypeName().toLowerCase(Locale.ROOT).contains("water")) continue;
                    coast = true;
                }
                if (!coast || !(this.random.nextDouble() < (double)this.swampFrequency / 100.0)) continue;
                t[tx][ty].setType("Classic/Flat Swamp");
                ArrayList<Terrain> alreadyChecked = new ArrayList<Terrain>();
                this.convertSwampRecurse(t, adjacentTerrain, alreadyChecked, ho, 0);
            }
        }
    }

    private void convertSwampRecurse(Terrain[][] t, Map<Point, Terrain> adjacentTerrain, List<Terrain> alreadyChecked, HexOrientation ho, int k) {
        for (Point key : adjacentTerrain.keySet()) {
            Terrain oneTerrain = adjacentTerrain.get(key);
            if (k < t.length / 10 && !alreadyChecked.contains(oneTerrain) && oneTerrain.getTypeName().toLowerCase(Locale.ROOT).contains("flat forest") && this.random.nextDouble() < (double)this.swampContinueFrequency / 100.0) {
                oneTerrain.setType("Classic/Flat Swamp");
                this.convertSwampRecurse(t, MapLogic.getAdjTerrainPoint(t, ho, (int)key.getX(), (int)key.getY()), alreadyChecked, ho, k++);
            }
            alreadyChecked.add(oneTerrain);
        }
    }

    private void addDesert(int desertquota, Terrain[][] t, int totalland, int vegCount, int mountainCount, HexOrientation tileorientation) {
        int ya;
        int xa;
        int i;
        this.updateMessage("Adding deserts...");
        int maxRadius = Math.max(t.length, t[0].length) / 60;
        if (maxRadius < 2) {
            maxRadius = 2;
        }
        int desert = 0;
        while (desert < desertquota) {
            this.updateMessage("Desert added:" + desert + "/" + desertquota);
            ++desert;
            int radius = maxRadius > 2 ? (int)((double)maxRadius * this.random.nextDouble()) : maxRadius;
            int xa2 = (int)(this.random.nextDouble() * (double)(t.length - radius * 2)) + radius;
            int ya2 = (int)(this.random.nextDouble() * (double)(t[xa2].length - radius * 2)) + radius;
            for (i = 0; i < 10; ++i) {
                int ya30NSMinDistance = Math.min(Math.abs(ya2 - t[0].length / 3), Math.abs(ya2 - t[0].length * 2 / 3));
                int yc = (int)(this.random.nextDouble() * (double)(t[xa2].length - radius * 2)) + radius;
                int yc30NSMinDistance = Math.min(Math.abs(yc - t[0].length / 3), Math.abs(yc - t[0].length * 2 / 3));
                if (yc30NSMinDistance >= ya30NSMinDistance) continue;
                ya2 = yc;
            }
            for (int x = xa2 - radius; x < xa2 + radius; ++x) {
                int dx = Math.abs(xa2 - x);
                for (int y = ya2 - radius; y < ya2 + radius; ++y) {
                    int dy = Math.abs(ya2 - y);
                    int distanceSquared = dx * dx + dy * dy;
                    if (!((double)distanceSquared <= (double)(radius * radius) * (1.0 - this.random.nextDouble() * this.random.nextDouble()))) continue;
                    if (t[x][y].getTypeName().contains("Farmland")) {
                        ++desert;
                        t[x][y].setType("Classic/Flat Desert Rocky");
                        Map<Point, Terrain> adjacentTerrain = MapLogic.getAdjTerrainPoint(t, tileorientation, x, y);
                        for (Terrain adjT : adjacentTerrain.values()) {
                            if (!adjT.getTypeName().contains("Forest")) continue;
                            if (adjT.getTypeName().contains("Mountains")) {
                                adjT.setType("Classic/Mountains");
                                continue;
                            }
                            if (adjT.getTypeName().contains("Hills")) {
                                adjT.setType("Classic/Hills");
                                continue;
                            }
                            adjT.setType("Classic/Flat Grassland");
                        }
                        continue;
                    }
                    if (!"Classic/Flat Desert Rocky".equals(t[x][y].getTypeName())) continue;
                    t[x][y].setType("Classic/Flat Desert Sandy");
                }
            }
        }
        int grasslandQuota = (int)((double)(totalland - mountainCount - vegCount - desert) * 0.1);
        System.out.println("totalland:" + totalland + " mountain:" + mountainCount + " veg:" + vegCount + " desert:" + desert + " grass:" + grasslandQuota);
        double grasslandCount = 0.0;
        while (grasslandCount < (double)grasslandQuota) {
            int radius;
            this.updateMessage("Grassland added:" + (int)grasslandCount + "/" + grasslandQuota);
            grasslandCount += 0.1;
            int n = radius = maxRadius > 2 ? (int)((double)(maxRadius / 2) * this.random.nextDouble() / 2.0) : maxRadius;
            if (radius < 2) {
                radius = 2;
            }
            if (!"Classic/Flat Farmland".equals(t[xa = (int)(this.random.nextDouble() * (double)(t.length - radius * 2)) + radius][ya = (int)(this.random.nextDouble() * (double)(t[xa].length - radius * 2)) + radius].getTypeName()) || "Classic/Water Ocean".equals(t[xa - 1][ya].getTypeName()) || "Classic/Water Ocean".equals(t[xa + 1][ya].getTypeName()) || "Classic/Water Ocean".equals(t[xa][ya - 1].getTypeName()) || "Classic/Water Ocean".equals(t[xa][ya + 1].getTypeName()) || "Classic/Water Ocean".equals(t[xa - 1][ya - 1].getTypeName()) || "Classic/Water Ocean".equals(t[xa - 1][ya + 1].getTypeName()) || "Classic/Water Ocean".equals(t[xa + 1][ya - 1].getTypeName()) || "Classic/Water Ocean".equals(t[xa + 1][ya + 1].getTypeName())) continue;
            for (int x = xa - radius; x < xa + radius; ++x) {
                int dx = Math.abs(xa - x);
                for (int y = ya - radius; y < ya + radius; ++y) {
                    int dy = Math.abs(ya - y);
                    int distanceSquared = dx * dx + dy * dy;
                    if (!((double)distanceSquared <= (double)(radius * radius) * (1.0 - this.random.nextDouble())) || "Empty".equals(t[x][y].getTypeName())) continue;
                    t[x][y].setType("Classic/Flat Grassland");
                    grasslandCount += 1.0;
                }
            }
        }
        for (i = 0; i < totalland / 60; ++i) {
            this.updateMessage("Badlands added:" + i + "/" + totalland / 60);
            xa = (int)(this.random.nextDouble() * (double)t.length);
            ya = (int)(this.random.nextDouble() * (double)t[xa].length);
            if (!"Classic/Mountains".equals(t[xa][ya].getTypeName()) && !"Classic/Hills".equals(t[xa][ya].getTypeName()) && !"Classic/Flat Desert Rocky".equals(t[xa][ya].getTypeName()) || "Empty".equals(t[xa][ya].getTypeName())) continue;
            t[xa][ya].setType("Classic/Other Badlands");
        }
    }

    private int addVegetation(Terrain[][] t, int vegquota) {
        this.updateMessage("Adding Vegetation...");
        int vegCount = 0;
        int maxRadius = Math.max(t.length, t[0].length) / 60;
        if (maxRadius < 2) {
            maxRadius = 2;
        }
        while (vegCount < vegquota) {
            int radius = maxRadius > 2 ? (int)((double)maxRadius * this.random.nextDouble()) : maxRadius;
            this.updateMessage("Vegetation added:" + vegCount + "/" + vegquota);
            int xa = (int)(this.random.nextDouble() * (double)(t.length - radius * 2)) + radius;
            int ya = (int)(this.random.nextDouble() * (double)(t[xa].length - radius * 2)) + radius;
            int numberHexesToCheck = t.length / 30;
            for (int j = 0; j < 100; ++j) {
                boolean fail = false;
                double latitudeAsDecimal = (double)ya * 1.0 / (double)t[0].length;
                if (latitudeAsDecimal > 0.17 && latitudeAsDecimal < 0.29 || latitudeAsDecimal > 0.71 && latitudeAsDecimal < 0.83) {
                    for (i = Math.max(0, xa - numberHexesToCheck); i < xa; ++i) {
                        if (!t[i][ya].getTypeName().toLowerCase().contains("mountain")) continue;
                        fail = true;
                        break;
                    }
                } else {
                    for (i = Math.min(t.length - 1, xa + numberHexesToCheck); i > xa; --i) {
                        if (!t[i][ya].getTypeName().toLowerCase().contains("mountain")) continue;
                        fail = true;
                        break;
                    }
                }
                if (!fail) break;
                xa = (int)(this.random.nextDouble() * (double)(t.length - radius * 2)) + radius;
                ya = (int)(this.random.nextDouble() * (double)(t[xa].length - radius * 2)) + radius;
            }
            for (int x = xa - radius; x < xa + radius; ++x) {
                int dx = x - xa;
                for (int y = ya - radius; y < ya + radius; ++y) {
                    int distanceSquared;
                    int dy = y - ya;
                    if (x < 0 || y < 0 || x >= t.length || y >= t[0].length || !((double)(distanceSquared = dx * dx + dy * dy) <= (double)(radius * radius) * (1.0 - this.random.nextDouble() * this.random.nextDouble()))) continue;
                    if ("Classic/Flat Farmland".equals(t[x][y].getTypeName())) {
                        ++vegCount;
                        t[x][y].setType("Classic/Flat Forest Deciduous");
                        continue;
                    }
                    if (t[x][y].getTypeName().contains("Classic/Flat Forest")) {
                        ++vegCount;
                        t[x][y].setType("Classic/Flat Forest Deciduous Heavy");
                        continue;
                    }
                    if ("Classic/Hills".equals(t[x][y].getTypeName())) {
                        ++vegCount;
                        t[x][y].setType("Classic/Hills Forest Deciduous");
                        continue;
                    }
                    if (!"Classic/Mountains".equals(t[x][y].getTypeName())) continue;
                    ++vegCount;
                    t[x][y].setType("Classic/Mountains Forest Deciduous");
                }
            }
        }
        return vegCount;
    }

    public List<Feature> addVolcanoes(int totalland, Terrain[][] t, HexOrientation ho, ViewLevel vl, MapLayer featuresLayer) {
        Pair<Double, Double> modelPt;
        Feature f;
        int ya;
        int xa;
        int i;
        this.updateMessage("Adding volcanoes...");
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (i = 0; i < totalland / 40; ++i) {
            xa = (int)(this.random.nextDouble() * (double)t.length);
            if (!t[xa][ya = (int)(this.random.nextDouble() * (double)t[xa].length)].getTypeName().contains("Mountains")) continue;
            f = new Feature("Classic/Natural Volcano");
            if (this.random.nextDouble() < 0.5) {
                f = new Feature("Classic/Natural Volcano Dormant");
            }
            modelPt = this.getModelPtFromTerrain(ho, xa, ya);
            f.setLocation(vl, (Double)modelPt.getKey(), (Double)modelPt.getValue());
            f.setMapLayer(featuresLayer);
            f.setHideTerrainIcon(false);
            features.add(f);
        }
        for (i = 0; i < t.length * t[0].length / 300; ++i) {
            xa = (int)(this.random.nextDouble() * (double)t.length);
            if (!t[xa][ya = (int)(this.random.nextDouble() * (double)t[xa].length)].getTypeName().contains("Classic/Ocean")) continue;
            t[xa][ya].setType("Classic/Mountains");
            f = new Feature("Classic/Natural Volcano");
            if (this.random.nextDouble() < 0.5) {
                f = new Feature("Classic/Natural Volcano Dormant");
            }
            modelPt = this.getModelPtFromTerrain(ho, xa, ya);
            f.setLocation(vl, (Double)modelPt.getKey(), (Double)modelPt.getValue());
            f.setMapLayer(featuresLayer);
            f.setHideTerrainIcon(false);
            features.add(f);
            System.out.println(t[xa][ya].getTypeName() + "added volc:" + xa + "," + ya);
            int dx = (int)(this.random.nextDouble() * 5.0) - 2;
            int dy = (int)(this.random.nextDouble() * 5.0) - 2;
            if (xa + dx <= 0 || xa + dx >= t.length || ya + dy <= 0 || ya + dy >= t[0].length || !t[xa + dx][ya + dy].getTypeName().contains("Classic/Ocean")) continue;
            t[xa + dx][ya + dy].setType("Classic/Mountains");
            Feature f2 = new Feature("Classic/Natural Volcano");
            if (this.random.nextDouble() < 0.5) {
                f2 = new Feature("Classic/Natural Volcano Dormant");
            }
            Pair<Double, Double> modelPt2 = this.getModelPtFromTerrain(ho, xa + dx, ya + dy);
            f2.setLocation(vl, (Double)modelPt2.getKey(), (Double)modelPt2.getValue());
            f2.setMapLayer(featuresLayer);
            f2.setHideTerrainIcon(false);
            features.add(f2);
        }
        return features;
    }

    public void applyClimate(Terrain[][] t) {
        this.updateMessage("Applying climate...");
        for (int x = 0; x < t.length; ++x) {
            this.updateMessage("Climate applied:" + x * t[0].length + "/" + t.length * t[0].length);
            for (int y = 0; y < t[x].length; ++y) {
                if (t[x][y].getTypeName().equals("Empty")) continue;
                double percentfromequator = Math.abs((double)y - (double)t[x].length / 2.0) / (double)(t[x].length / 2) * 100.0;
                if (this.icyFrequency != 0) {
                    if (percentfromequator > (double)(100 - this.icyFrequency + 5) || this.icyFrequency == 100) {
                        t[x][y].setIcy(true);
                        if (t[x][y].getTypeName().contains("Deciduous")) {
                            t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Evergreen"));
                        }
                        if (t[x][y].getTypeName().equals("Classic/Flat Swamp")) {
                            t[x][y].setType("Classic/Flat Moor");
                        }
                    } else if (percentfromequator > (double)(100 - this.icyFrequency)) {
                        if (this.random.nextDouble() < 0.65) {
                            t[x][y].setIcy(true);
                        }
                        if (t[x][y].getTypeName().contains("Deciduous")) {
                            t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Evergreen"));
                        }
                        if (t[x][y].getTypeName().equals("Classic/Flat Swamp")) {
                            t[x][y].setType("Classic/Flat Moor");
                        }
                    } else if (percentfromequator > (double)(100 - this.icyFrequency - 5)) {
                        if (this.random.nextDouble() < 0.35) {
                            t[x][y].setIcy(true);
                        }
                        if (t[x][y].getTypeName().contains("Deciduous")) {
                            t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Evergreen"));
                        }
                        if (t[x][y].getTypeName().equals("Classic/Flat Swamp")) {
                            t[x][y].setType("Classic/Flat Moor");
                        }
                    }
                }
                if (percentfromequator < (double)(this.tropicalFrequency - 5) || this.tropicalFrequency == 100) {
                    if (!t[x][y].getTypeName().contains("Deciduous")) continue;
                    t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Jungle"));
                    continue;
                }
                if (percentfromequator < (double)this.tropicalFrequency) {
                    if (!(this.random.nextDouble() < 0.65) || !t[x][y].getTypeName().contains("Deciduous")) continue;
                    t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Jungle"));
                    continue;
                }
                if (!(percentfromequator < (double)(this.tropicalFrequency + 5)) || !(this.random.nextDouble() < 0.35) || !t[x][y].getTypeName().contains("Deciduous")) continue;
                t[x][y].setType(t[x][y].getTypeName().replace("Deciduous", "Jungle"));
            }
        }
    }
}

