/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.TableData;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.util.Base64;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImportCityTask {
    private static final Map<String, String> CONVERTED_SHAPES = new HashMap<String, String>();

    public static MapDataSetup importCity(Stage parentStage, File file) throws Exception {
        MapDataSetup setup = new MapDataSetup();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource();
        FileInputStream fis = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
        String line1 = br.readLine();
        fis.close();
        fis = new FileInputStream(file);
        inputSource.setCharacterStream(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
        Document doc = documentBuilder.parse(inputSource);
        Element topel = doc.getDocumentElement();
        Element el = null;
        ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
        mapLayers.add(new MapLayer("Labels"));
        mapLayers.add(new MapLayer("Grid"));
        mapLayers.add(new MapLayer("Features"));
        mapLayers.add(new MapLayer("Above Terrain"));
        mapLayers.add(new MapLayer("Terrain Land"));
        mapLayers.add(new MapLayer("Above Water"));
        mapLayers.add(new MapLayer("Terrain Water"));
        mapLayers.add(new MapLayer("Below All"));
        setup.mapLayers = mapLayers;
        NodeList nlmis = doc.getElementsByTagName("mapitem-settings");
        if (nlmis.getLength() > 0) {
            el = (Element)nlmis.item(0);
            String mis = el.getTextContent();
            byte[] sarray = Base64.decode(mis);
            String decoded = new String(sarray);
            ImportCityTask.getMapItemsConfig(parentStage, decoded);
        }
        ArrayList<MapShape> shapes = new ArrayList<MapShape>();
        NodeList nl4 = doc.getElementsByTagName("contour");
        for (int ik = 0; ik < nl4.getLength(); ++ik) {
            el = (Element)nl4.item(ik);
            shapes.add(ImportCityTask.readContour(el, (MapLayer)mapLayers.get(2)));
        }
        NodeList nl2 = doc.getElementsByTagName("line");
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            el = (Element)nl2.item(ik);
            shapes.add(ImportCityTask.readLine(el, (MapLayer)mapLayers.get(2)));
        }
        ArrayList<MapLabel> labels = new ArrayList<MapLabel>();
        NodeList nlt = doc.getElementsByTagName("text");
        for (int ik = 0; ik < nlt.getLength(); ++ik) {
            el = (Element)nlt.item(ik);
            labels.add(ImportCityTask.readText(el, (MapLayer)mapLayers.get(0)));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap<String, Feature> featuresbyid = new HashMap<String, Feature>();
        NodeList nl3 = doc.getElementsByTagName("mapitem");
        for (int ik = 0; ik < nl3.getLength(); ++ik) {
            el = (Element)nl3.item(ik);
            Feature f = ImportCityTask.readMapItem(el, featuresbyid, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(0));
            if (f == null) continue;
            features.add(f);
        }
        HashSet<Note> notes = new HashSet<Note>();
        NodeList nl5 = doc.getElementsByTagName("note");
        for (int ik = 0; ik < nl5.getLength(); ++ik) {
            el = (Element)nl5.item(ik);
            notes.add(ImportCityTask.readNote(el, featuresbyid));
        }
        int hexwidth = Integer.parseInt(topel.getAttribute("hex-width"));
        int hexheight = Integer.parseInt(topel.getAttribute("hex-height"));
        int hexesWide = Integer.parseInt(topel.getAttribute("num-hexes-wide"));
        int hexesHigh = Integer.parseInt(topel.getAttribute("num-hexes-high"));
        String title = topel.getAttribute("title");
        setup.view.continentFactor = 1;
        setup.view.kingdomFactor = 1;
        setup.view.provinceFactor = 1;
        setup.view.worldToContinentHOffset = 0.0;
        setup.view.continentToKingdomHOffset = 0.0;
        setup.view.kingdomToProvinceHOffset = 0.0;
        setup.view.worldToContinentVOffset = 0.0;
        setup.view.continentToKingdomVOffset = 0.0;
        setup.view.kingdomToProvinceVOffset = 0.0;
        setup.hexWidth = hexwidth;
        setup.hexHeight = hexheight;
        setup.hexOrientation = HexOrientation.COLUMNS;
        setup.mapProjection = MapProjection.FLAT;
        Terrain[][] t = new Terrain[hexesWide][hexesHigh];
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[i].length; ++j) {
                t[i][j] = new Terrain("Blank", true);
            }
        }
        setup.settlementTerrain = t;
        setup.generateOneTerrain = false;
        setup.solidTerrain = null;
        setup.iconStyle = SetupWorldRegionScreen.TerrainStyle.Isometric;
        setup.notes = notes;
        setup.features = features;
        setup.shapes = shapes;
        setup.labels = labels;
        setup.information = new ArrayList<Information>();
        return setup;
    }

    private static void getMapItemsConfig(Stage parentStage, String decoded) {
        String[] vals;
        String[] keys = decoded.substring(decoded.indexOf(61) + 1, decoded.indexOf(10)).split("\\t");
        HashMap<String, String> keyvals = new HashMap<String, String>();
        for (String v : vals = decoded.split("\\n")) {
            if (v.indexOf(61) <= 0) continue;
            keyvals.put(v.substring(0, v.indexOf(61)), v.substring(v.indexOf(61) + 1));
        }
        File parentfolder = null;
        for (String key : keys) {
            String file = (String)keyvals.get(key + ".file");
            if (file == null || file.startsWith("resources/")) continue;
            Object name = key;
            File f = new File(file);
            if (!f.exists() && parentfolder != null) {
                f = new File(parentfolder.getAbsolutePath() + File.separator + file);
            }
            if (!f.exists()) {
                StyledDialog d1 = new StyledDialog(true, (Window)parentStage, "Select Icons Directory");
                d1.setHeaderText("Select Icons Directory");
                Label statusLabel = new Label("Your map uses some icons that are not built-in to Worldographer.\nThe next dialog will allow you to select the folder containing them.\nIt is best if you put them all in one folder, and not in subfolders.");
                d1.getDialogPane().setContent((Node)statusLabel);
                ButtonType ok = new ButtonType("OK");
                d1.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok});
                d1.showAndWait();
                File d = FileSaveLoad.getLastUsedDir();
                DirectoryChooser fc = new DirectoryChooser();
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                parentfolder = fc.showDialog(null);
                if (f != null) {
                    f = new File(parentfolder.getAbsolutePath() + File.separator + file);
                }
            }
            if (!f.exists()) continue;
            if (((String)name).startsWith("FD-")) {
                name = "Dwarf " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FE-")) {
                name = "Elf " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FH-")) {
                name = "Halfling " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FO-")) {
                name = "Orc " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FT-")) {
                name = "Tree " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FW-")) {
                name = "Wizard " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FC-")) {
                name = "Future Clean " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FG-")) {
                name = "Future Gritty " + ((String)name).substring(3);
            } else if (((String)name).startsWith("FR-")) {
                name = "Future Retro " + ((String)name).substring(3);
            } else if (((String)name).startsWith("F-")) {
                name = "Fantasy " + ((String)name).substring(2);
            } else if (((String)name).startsWith("M-")) {
                name = "Modern " + ((String)name).substring(2);
            } else if (((String)name).startsWith("W-")) {
                name = "Western " + ((String)name).substring(2);
            } else if (((String)name).startsWith("P-")) {
                name = "Post-Apocalypse " + ((String)name).substring(2);
            } else if (((String)name).startsWith("R-")) {
                name = "Rubble " + ((String)name).substring(2);
            }
            CONVERTED_SHAPES.put(key, "structure " + (String)name);
            FeatureType.loadUserFeatureSingleFile("structure ", Feature.featureTypes, f, (String)name, -1.0, -1.0, "");
        }
    }

    private static MapShape readLine(Element el, MapLayer ml) {
        String idtype = el.getAttribute("id-type");
        String tags = el.getAttribute("tags");
        String texture = el.getAttribute("texture");
        Color awtcolor = new Color(Integer.parseInt(el.getAttribute("color")));
        javafx.scene.paint.Color color = null;
        if (awtcolor != null) {
            color = new javafx.scene.paint.Color((double)awtcolor.getRed() / 255.0, (double)awtcolor.getGreen() / 255.0, (double)awtcolor.getBlue() / 255.0, 1.0);
        }
        float width = Float.parseFloat(el.getAttribute("width"));
        String creationstyle = el.getAttribute("creation-style");
        MapShape.CreationType ct = MapShape.CreationType.BASIC;
        if ("CURVE".equals(creationstyle)) {
            ct = MapShape.CreationType.CURVE;
        }
        if ("FRACTAL".equals(creationstyle)) {
            ct = MapShape.CreationType.FRACTAL;
        }
        String style = el.getAttribute("style");
        boolean ishashinverted = Boolean.parseBoolean(el.getAttribute("hash-inverted"));
        MapShape.StrokeType st = MapShape.StrokeType.SIMPLE;
        if ("DASHED".equals(style)) {
            st = MapShape.StrokeType.DASHED;
        } else if ("DOTTED".equals(style)) {
            st = MapShape.StrokeType.DOTTED;
        } else if ("HASHED".equals(style) && ishashinverted) {
            st = MapShape.StrokeType.ELEV_INVERTED;
        } else if ("HASHED".equals(style)) {
            st = MapShape.StrokeType.ELEVATION;
        } else if ("RAILROAD".equals(style) && ishashinverted) {
            st = MapShape.StrokeType.RAILROAD;
        }
        Boolean issnaptovertex = Boolean.parseBoolean(el.getAttribute("snap-to-vertex"));
        NodeList nl2 = el.getElementsByTagName("point");
        ArrayList<Double> points = new ArrayList<Double>();
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            el = (Element)nl2.item(ik);
            points.add(Double.parseDouble(el.getAttribute("x")));
            points.add(Double.parseDouble(el.getAttribute("y")));
        }
        Path p = new Path();
        if (points.size() > 1) {
            p.getElements().add((Object)new MoveTo(((Double)points.get(0)).doubleValue(), ((Double)points.get(1)).doubleValue()));
        }
        if (ct == MapShape.CreationType.CURVE) {
            try {
                for (int i = 6; i < points.size(); i += 6) {
                    p.getElements().add((Object)new CubicCurveTo(((Double)points.get(i)).doubleValue(), ((Double)points.get(i + 1)).doubleValue(), ((Double)points.get(i + 2)).doubleValue(), ((Double)points.get(i + 3)).doubleValue(), ((Double)points.get(i + 4)).doubleValue(), ((Double)points.get(i + 5)).doubleValue()));
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else {
            for (int i = 2; i < points.size(); i += 2) {
                p.getElements().add((Object)new LineTo(((Double)points.get(i)).doubleValue(), ((Double)points.get(i + 1)).doubleValue()));
            }
        }
        p.setStrokeWidth((double)(width / 300.0f));
        p.setStroke((Paint)color);
        MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)p, ct, st, false, tags, 0.0, 0.0, 0.0, 0.0, false, false, false, false, ml);
        if ("TEXTURED".equals(style)) {
            TextureType tt;
            p.setStroke((Paint)javafx.scene.paint.Color.ANTIQUEWHITE);
            if (texture.equals("cobblestone")) {
                texture = "Cobblestone";
            }
            if ((tt = TextureType.ALL_TEXTURES.get(texture)) != null) {
                p.setStroke((Paint)new ImagePattern(tt.getIcon(), 0.0, 0.0, 50.0, 25.0, false));
                ms.setStrokeTexture(tt);
            }
        }
        return ms;
    }

    private static MapLabel readText(Element el, MapLayer labellayer) {
        String idtype = el.getAttribute("id-type");
        String tags = el.getAttribute("tags");
        String text = el.getAttribute("text");
        String fontface = el.getAttribute("font-name");
        Color awtcolor = new Color(Integer.parseInt(el.getAttribute("color")));
        javafx.scene.paint.Color color = new javafx.scene.paint.Color((double)awtcolor.getRed() / 255.0, (double)awtcolor.getGreen() / 255.0, (double)awtcolor.getBlue() / 255.0, (double)awtcolor.getAlpha() / 255.0);
        Color awtoutlinecolor = new Color(Integer.parseInt(el.getAttribute("outline-color")));
        javafx.scene.paint.Color outlinecolor = new javafx.scene.paint.Color((double)awtoutlinecolor.getRed() / 255.0, (double)awtoutlinecolor.getGreen() / 255.0, (double)awtoutlinecolor.getBlue() / 255.0, (double)awtoutlinecolor.getAlpha() / 255.0);
        float fontsize = Float.parseFloat(el.getAttribute("font-size"));
        float outlinesize = Float.parseFloat(el.getAttribute("outline-size"));
        int fontstyle = Integer.parseInt(el.getAttribute("font-style"));
        double rotation = Double.parseDouble(el.getAttribute("rotation"));
        String location = el.getAttribute("location");
        String[] locs = location.split(",");
        MapLabel ml = new MapLabel(idtype, text, fontface, color, outlinesize, outlinecolor, null, 0.0, false, false, false, false, fontstyle == 1, fontstyle == 2, false, TextAlignment.CENTER, tags, labellayer);
        ml.setLocationAndScale(ViewLevel.SETTLEMENT, new Point2D((double)Integer.parseInt(locs[0].trim()), (double)Integer.parseInt(locs[1].trim())), Double.valueOf(fontsize));
        ml.setRotate(rotation);
        return ml;
    }

    private static Feature readMapItem(Element el, Map<String, Feature> featuresbyid, MapLayer maplayer, MapLayer labellayer) {
        String shape = el.getAttribute("shape");
        String id = el.getAttribute("id");
        String label = el.getAttribute("label");
        Color awtfillcolor = null;
        String fc = el.getAttribute("fill-color");
        if (fc != null && !fc.equals("")) {
            awtfillcolor = new Color(Integer.parseInt(fc));
        }
        String lbc = el.getAttribute("label-bg-color");
        Color awtlabelbgcolor = null;
        if (lbc != null && !lbc.equals("")) {
            awtlabelbgcolor = new Color(Integer.parseInt(lbc));
        }
        int width = Integer.parseInt(el.getAttribute("width"));
        int height = Integer.parseInt(el.getAttribute("height"));
        int rotation = (360 - Integer.parseInt(el.getAttribute("rotation"))) % 360;
        String ltc = el.getAttribute("label-text-color");
        Color awtlabeltextcolor = null;
        if (ltc != null && !ltc.equals("")) {
            awtlabeltextcolor = new Color(Integer.parseInt(ltc));
        }
        String olc = el.getAttribute("outline-color");
        Color awtoutlinecolor = null;
        if (olc != null && !olc.equals("")) {
            awtoutlinecolor = new Color(Integer.parseInt(olc));
        }
        String location = el.getAttribute("location");
        String[] locs = location.split(",");
        Point locpt = new Point(Integer.parseInt(locs[0].trim()), Integer.parseInt(locs[1].trim()));
        boolean isgmonly = Boolean.parseBoolean(el.getAttribute("gm-only"));
        String convertedshape = CONVERTED_SHAPES.get(shape);
        if (convertedshape != null) {
            shape = convertedshape;
        }
        Map<String, FeatureType> fts = Feature.featureTypes;
        if (!Feature.featureTypes.containsKey(shape)) {
            return null;
        }
        double widthnew = Feature.featureTypes.get((Object)shape).icon.getWidth() * (double)width / 300.0;
        double heightnew = Feature.featureTypes.get((Object)shape).icon.getHeight() * (double)height / 300.0;
        MapLabel ml = null;
        if (label != null && !"".equals(label)) {
            ml = new MapLabel("Building", label, "Arial", javafx.scene.paint.Color.BLACK, 0.0, null, null, 0.0, false, false, false, false, false, false, false, TextAlignment.CENTER, "", labellayer);
        }
        if (shape.toLowerCase().contains("gatehouse")) {
            widthnew = 150.0;
            heightnew = 150.0;
        }
        if (shape.toLowerCase().contains("walltower")) {
            widthnew = 100.0;
            heightnew = 100.0;
        }
        Feature f = new Feature(shape, true, false, isgmonly, false, null, rotation, null, widthnew, heightnew, false, false, ml, "", false, false, false, false, maplayer);
        f.setLocation(ViewLevel.SETTLEMENT, new Point2D((double)Integer.parseInt(locs[0].trim()), (double)Integer.parseInt(locs[1].trim())));
        featuresbyid.put(id, f);
        return f;
    }

    private static MapShape readContour(Element el, MapLayer ml) {
        int layer = Integer.parseInt(el.getAttribute("layer"));
        int type = Integer.parseInt(el.getAttribute("type"));
        String br = el.getAttribute("border");
        String border = null;
        if (ImportCityTask.isInteger(br)) {
            Color bc = new Color(Integer.parseInt(br));
            border = new javafx.scene.paint.Color((double)bc.getRed() / 255.0, (double)bc.getGreen() / 255.0, (double)bc.getBlue() / 255.0, 1.0);
        } else {
            border = br;
        }
        String fl = el.getAttribute("fill");
        String fill = null;
        if (ImportCityTask.isInteger(fl)) {
            Color fc = new Color(Integer.parseInt(fl));
            fill = new javafx.scene.paint.Color((double)fc.getRed() / 255.0, (double)fc.getGreen() / 255.0, (double)fc.getBlue() / 255.0, 1.0);
        } else {
            fill = fl;
        }
        double width = Double.parseDouble(el.getAttribute("width"));
        double opacity = Double.parseDouble(el.getAttribute("opacity"));
        Boolean issnaptovertex = Boolean.parseBoolean(el.getAttribute("snap-to-vertex"));
        Boolean isroomorcorridor = Boolean.parseBoolean(el.getAttribute("is-room-or-corridor"));
        Boolean ispassable = Boolean.parseBoolean(el.getAttribute("is-passable"));
        NodeList nl2 = el.getElementsByTagName("point");
        Polygon poly = new Polygon();
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            el = (Element)nl2.item(ik);
            double x = Double.parseDouble(el.getAttribute("x"));
            double y = Double.parseDouble(el.getAttribute("y"));
            poly.getPoints().add((Object)x);
            poly.getPoints().add((Object)y);
        }
        poly.setStrokeWidth(width / 300.0);
        if (border instanceof javafx.scene.paint.Color) {
            poly.setStroke((Paint)((javafx.scene.paint.Color)border));
        }
        if (fill instanceof javafx.scene.paint.Color) {
            poly.setFill((Paint)((javafx.scene.paint.Color)fill));
        }
        MapShape ms = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)poly, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "", 0.0, 0.0, 0.0, 0.0, false, false, false, false, ml);
        if (!(border instanceof javafx.scene.paint.Color)) {
            TextureType tt;
            poly.setStroke((Paint)javafx.scene.paint.Color.ANTIQUEWHITE);
            if (border.equals("cobblestone")) {
                border = "Cobblestone";
            }
            if ((tt = TextureType.ALL_TEXTURES.get(border)) != null) {
                poly.setStroke((Paint)new ImagePattern(tt.getIcon(), 0.0, 0.0, 50.0, 25.0, false));
                ms.setStrokeTexture(tt);
            }
        }
        if (!(fill instanceof javafx.scene.paint.Color)) {
            TextureType tt;
            poly.setFill((Paint)javafx.scene.paint.Color.ANTIQUEWHITE);
            if (fill.equals("cobblestone")) {
                fill = "Cobblestone";
            }
            if ((tt = TextureType.ALL_TEXTURES.get(fill)) != null) {
                poly.setFill((Paint)new ImagePattern(tt.getIcon(), 0.0, 0.0, 50.0, 25.0, false));
                ms.setFillTexture(tt);
            }
        }
        return ms;
    }

    private static boolean isInteger(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i)) || '-' == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static Note readNote(Element el, Map<String, Feature> featuresbyid) {
        double hexx = Integer.parseInt(el.getAttribute("hex-x"));
        double hexy = Integer.parseInt(el.getAttribute("hex-y"));
        String buildingtype = el.getAttribute("building-type");
        String link = el.getAttribute("link");
        String graphiclink = el.getAttribute("graphic-link");
        String title = el.getAttribute("title");
        String key = el.getAttribute("key");
        Feature featureparent = featuresbyid.get(key);
        int order = Integer.parseInt(el.getAttribute("order"));
        NodeList nl2 = el.getElementsByTagName("description");
        String description = null;
        HashMap<String, Object> tabs = new HashMap<String, Object>();
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el2 = (Element)nl2.item(ik);
            String text = el2.getAttribute("text");
            String tab = el2.getAttribute("tab");
            if (tab == null) {
                description = text;
                if (featureparent != null) {
                    hexx = featureparent.getLocation(ViewLevel.SETTLEMENT).getX();
                    hexy = featureparent.getLocation(ViewLevel.SETTLEMENT).getY();
                }
                Note n = new Note(ViewLevel.SETTLEMENT, hexx, hexy);
                if (featureparent != null) {
                    n.setParent(featureparent);
                }
                n.setTitle(title);
                if (description instanceof String) {
                    n.setDetails(description);
                }
                n.setFilename(link);
                return n;
            }
            String value = el2.getAttribute("value");
            NodeList nl3 = el2.getElementsByTagName("tab-content");
            if (value != null && (nl3 == null || nl3.getLength() == 0)) {
                description = value;
                continue;
            }
            ArrayList descs = new ArrayList();
            if (nl3.getLength() <= 0) continue;
            Element elx = (Element)nl3.item(0);
            String linex = elx.getTextContent();
            String[] hs = linex.split("\\t");
            String h1 = "";
            if (hs.length > 0) {
                h1 = hs[0];
            }
            String h2 = "";
            if (hs.length > 1) {
                h2 = hs[1];
            }
            String h3 = "";
            if (hs.length > 2) {
                h3 = hs[2];
            }
            String h4 = "";
            if (hs.length > 3) {
                h4 = hs[3];
            }
            String h5 = "";
            if (hs.length > 4) {
                h5 = hs[4];
            }
            String h6 = "";
            if (hs.length > 5) {
                h6 = hs[5];
            }
            String h7 = "";
            if (hs.length > 6) {
                h7 = hs[6];
            }
            String h8 = "";
            if (hs.length > 7) {
                h8 = hs[7];
            }
            TableData headings = new TableData(h1, h2, h3, h4, h5, h6, h7, h8);
            ArrayList<TableData> rows = new ArrayList<TableData>();
            for (int im = 1; im < nl3.getLength(); ++im) {
                Element el3 = (Element)nl3.item(im);
                String line = el3.getTextContent();
                String[] rs = line.split("\\t");
                String r1 = "";
                if (rs.length > 0) {
                    r1 = rs[0];
                }
                String r2 = "";
                if (rs.length > 1) {
                    r2 = rs[1];
                }
                String r3 = "";
                if (rs.length > 2) {
                    r3 = rs[2];
                }
                String r4 = "";
                if (rs.length > 3) {
                    r4 = rs[3];
                }
                String r5 = "";
                if (rs.length > 4) {
                    r5 = rs[4];
                }
                String r6 = "";
                if (rs.length > 5) {
                    r6 = rs[5];
                }
                String r7 = "";
                if (rs.length > 6) {
                    r7 = rs[6];
                }
                String r8 = "";
                if (rs.length > 7) {
                    r8 = rs[7];
                }
                rows.add(new TableData(r1, r2, r3, r4, r5, r6, r7, r8));
            }
            NoteTable nt = new NoteTable(headings, (ObservableList<TableData>)FXCollections.observableArrayList(rows));
            tabs.put(tab, nt);
        }
        if (featureparent != null) {
            hexx = featureparent.getLocation(ViewLevel.SETTLEMENT).getX();
            hexy = featureparent.getLocation(ViewLevel.SETTLEMENT).getY();
        }
        Note n = new Note(ViewLevel.SETTLEMENT, hexx, hexy);
        if (featureparent != null) {
            n.setParent(featureparent);
        }
        n.setTitle(title);
        if (description instanceof String) {
            n.setDetails(description);
        }
        n.setDetails(tabs);
        n.setFilename(link);
        return n;
    }

    static {
        CONVERTED_SHAPES.put("Academy", "Structure Medieval Academy");
        CONVERTED_SHAPES.put("Alchemist", "Structure Medieval Alchemist");
        CONVERTED_SHAPES.put("Arena", "Structure Medieval Arena");
        CONVERTED_SHAPES.put("Armorer", "Structure Medieval Armorer");
        CONVERTED_SHAPES.put("Baker", "Structure Medieval Baker");
        CONVERTED_SHAPES.put("Barn", "Structure Medieval Barn");
        CONVERTED_SHAPES.put("Barracks", "Structure Medieval Barracks");
        CONVERTED_SHAPES.put("Black-Market", "Structure Medieval Black-Market");
        CONVERTED_SHAPES.put("Blacksmith", "Structure Medieval Blacksmith");
        CONVERTED_SHAPES.put("Bookseller", "Structure Medieval Bookseller");
        CONVERTED_SHAPES.put("Brewery", "Structure Medieval Brewery");
        CONVERTED_SHAPES.put("Brothel", "Structure Medieval Brothel");
        CONVERTED_SHAPES.put("Buckle-Maker", "Structure Medieval Buckle-Maker");
        CONVERTED_SHAPES.put("Butcher", "Structure Medieval Butcher");
        CONVERTED_SHAPES.put("Casters-Tower", "Structure Medieval Casters-Tower");
        CONVERTED_SHAPES.put("Castle", "Structure Medieval Castle");
        CONVERTED_SHAPES.put("Cathedral", "Structure Medieval Cathedral");
        CONVERTED_SHAPES.put("Chicken-Butcher", "Structure Medieval Chicken-Butcher");
        CONVERTED_SHAPES.put("Cooper", "Structure Medieval Cooper");
        CONVERTED_SHAPES.put("Doctor", "Structure Medieval Doctor");
        CONVERTED_SHAPES.put("Dump", "Structure Medieval Dump");
        CONVERTED_SHAPES.put("Exotic-Craftsman", "Structure Medieval Exotic Craftsman");
        CONVERTED_SHAPES.put("Farm", "Structure Medieval Farm");
        CONVERTED_SHAPES.put("Farm-Large", "Structure Medieval Farm-Large");
        CONVERTED_SHAPES.put("Fishmonger", "Structure Medieval Fishmonger");
        CONVERTED_SHAPES.put("Furrier", "Structure Medieval Furrier");
        CONVERTED_SHAPES.put("Garrison", "Structure Medieval Garrison");
        CONVERTED_SHAPES.put("Gatehouse", "Structure Medieval Gatehouse");
        CONVERTED_SHAPES.put("Guildhouse", "Structure Medieval Guildhouse");
        CONVERTED_SHAPES.put("Hatmaker", "Structure Medieval Hatmaker");
        CONVERTED_SHAPES.put("Herbalist", "Structure Medieval Herbalist");
        CONVERTED_SHAPES.put("House-Fat-L-Ceramic", "Structure House Fat-L Ceramic");
        CONVERTED_SHAPES.put("House-Fat-L-Thatch", "Structure House Fat-L Thatched");
        CONVERTED_SHAPES.put("House-Fat-L-Wood", "Structure House Fat-L Wood");
        CONVERTED_SHAPES.put("House-L-Shaped-Ceramic", "Structure House L-Shaped Ceramic");
        CONVERTED_SHAPES.put("House-L-Shaped-Thatch", "Structure House L-Shaped Thatched");
        CONVERTED_SHAPES.put("House-L-Shaped-Wood", "Structure House L-Shaped Wood");
        CONVERTED_SHAPES.put("House-Square-Ceramic", "Structure House Square Ceramic");
        CONVERTED_SHAPES.put("House-Square-Thatch", "Structure House Square Thatched");
        CONVERTED_SHAPES.put("House-Square-Wood", "Structure House Square Wood");
        CONVERTED_SHAPES.put("House-Very-Fat-L-Ceramic", "Structure House Very-Fat-L Ceramic");
        CONVERTED_SHAPES.put("House-Very-Fat-L-Thatch", "Structure House Very-Fat-L Thatched");
        CONVERTED_SHAPES.put("House-Very-Fat-L-Wood", "Structure House Very-Fat-L Wood");
        CONVERTED_SHAPES.put("Inn", "Structure Medieval Inn");
        CONVERTED_SHAPES.put("Jail", "Structure Medieval Jail");
        CONVERTED_SHAPES.put("Jeweler", "Structure Medieval Jeweler");
        CONVERTED_SHAPES.put("Library", "Structure Medieval Library");
        CONVERTED_SHAPES.put("Locksmith", "Structure Medieval Locksmith");
        CONVERTED_SHAPES.put("Luxury-Store", "Structure Medieval Luxury Store");
        CONVERTED_SHAPES.put("Lumber-Yard", "Structure Medieval Lumber-Yard");
        CONVERTED_SHAPES.put("Magic-Shop", "Structure Medieval Magic-Shop");
        CONVERTED_SHAPES.put("Market", "Structure Medieval Market");
        CONVERTED_SHAPES.put("Mill", "Structure Medieval Mill C");
        CONVERTED_SHAPES.put("Mine", "Structure Medieval Mine");
        CONVERTED_SHAPES.put("Noble-Villa", "Structure Medieval Noble-Villa");
        CONVERTED_SHAPES.put("Old-Clothes", "Structure Medieval Old-Clothes");
        CONVERTED_SHAPES.put("Pier", "Structure Medieval Pier");
        CONVERTED_SHAPES.put("Pursemaker", "Structure Medieval Pursemaker");
        CONVERTED_SHAPES.put("Ropemaker", "Structure Medieval Ropemaker");
        CONVERTED_SHAPES.put("Saddler", "Structure Medieval Saddler");
        CONVERTED_SHAPES.put("Scabbardmaker", "Structure Medieval Scabbardmaker");
        CONVERTED_SHAPES.put("Shoemaker", "Structure Medieval Shoemaker");
        CONVERTED_SHAPES.put("Shop", "Structure Medieval Shop");
        CONVERTED_SHAPES.put("Shrine", "Structure Medieval Shrine");
        CONVERTED_SHAPES.put("Storehouse", "Structure Medieval Storehouse");
        CONVERTED_SHAPES.put("Spice-Merchant", "Structure Medieval Spice-Merchant");
        CONVERTED_SHAPES.put("Tailor", "Structure Medieval Tailor");
        CONVERTED_SHAPES.put("Tannery", "Structure Medieval Tannery");
        CONVERTED_SHAPES.put("Tavern", "Structure Medieval Tavern");
        CONVERTED_SHAPES.put("Temple", "Structure Medieval Temple");
        CONVERTED_SHAPES.put("Tenement", "Structure Medieval Tenement");
        CONVERTED_SHAPES.put("Theatre", "Structure Medieval Theatre");
        CONVERTED_SHAPES.put("Town-Hall", "Structure Medieval Town Hall");
        CONVERTED_SHAPES.put("Tradesman", "Structure Medieval Tradesman");
        CONVERTED_SHAPES.put("Wall-Segment", "Structure Medieval Wall Segment");
        CONVERTED_SHAPES.put("Wall-Segment-Short", "Structure Medieval Segment Short");
        CONVERTED_SHAPES.put("Wall-Tower-1Stair", "Structure Medieval Walltower 1 Stair");
        CONVERTED_SHAPES.put("Wall-Tower-2Stairs-12-6", "Structure Medieval Walltower 2 Stairs 12-6");
        CONVERTED_SHAPES.put("Wall-Tower-2Stairs-3-6", "Structure Medieval Walltower 2Stairs 3-6");
        CONVERTED_SHAPES.put("Wall-Tower-No-Stairs", "Structure Medieval Walltower");
        CONVERTED_SHAPES.put("Watchtower", "Structure Medieval Watchtower");
        CONVERTED_SHAPES.put("Waterfront", "Structure Medieval Waterfront");
        CONVERTED_SHAPES.put("Weaponsmith", "Structure Medieval Weaponsmith");
        CONVERTED_SHAPES.put("Wineseller", "Structure Medieval Wineseller");
        CONVERTED_SHAPES.put("Woodseller", "Structure Medieval Woodseller");
        CONVERTED_SHAPES.put("Bridge-Stone", "Structure Bridge Stone");
        CONVERTED_SHAPES.put("Bridge-Wood", "Structure Bridge Wood");
        CONVERTED_SHAPES.put("Monument", "Structure Monument");
        CONVERTED_SHAPES.put("Park", "Structure Park");
        CONVERTED_SHAPES.put("Fields-Green", "Structure Fields Green");
        CONVERTED_SHAPES.put("Fields-Wheat", "Structure Fields Wheat");
        CONVERTED_SHAPES.put("Future-Clean-Arena-A", "Structure Future Clean Arena A");
        CONVERTED_SHAPES.put("Future-Clean-Factory-A", "Structure Future Clean Factory A");
        CONVERTED_SHAPES.put("Future-Clean-Farm-A", "Structure Future Clean Farm A");
        CONVERTED_SHAPES.put("Future-Clean-House-A", "Structure Future Clean House A");
        CONVERTED_SHAPES.put("Future-Clean-House-B", "Structure Future Clean House B");
        CONVERTED_SHAPES.put("Future-Clean-House-C", "Structure Future Clean House C");
        CONVERTED_SHAPES.put("Future-Clean-Landing-Pad-A", "Structure Future Clean Landing Pad A");
        CONVERTED_SHAPES.put("Future-Clean-Large-Flat-Building-A", "Structure Future Clean Large Flat Building A");
        CONVERTED_SHAPES.put("Future-Clean-Mansion-A", "Structure Future Clean Mansion A");
        CONVERTED_SHAPES.put("Future-Clean-Medium-Office-A", "Structure Future Clean Medium Office A");
        CONVERTED_SHAPES.put("Future-Clean-Power-Statio-A", "Structure Future Clean Power Statio A");
        CONVERTED_SHAPES.put("Future-Clean-School-A", "Structure Future Clean School A");
        CONVERTED_SHAPES.put("Future-Clean-Small-Building-A", "Structure Future Clean Small Building A");
        CONVERTED_SHAPES.put("Future-Clean-Small-Building-B", "Structure Future Clean Small Building B");
        CONVERTED_SHAPES.put("Future-Clean-Tall-Building-A", "Structure Future Clean Tall Building A");
        CONVERTED_SHAPES.put("Future-Gritty-Factory-A", "Structure Future Gritty Factory A");
        CONVERTED_SHAPES.put("Future-Gritty-House-A", "Structure Future Gritty House A");
        CONVERTED_SHAPES.put("Future-Gritty-House-B", "Structure Future Gritty House B");
        CONVERTED_SHAPES.put("Future-Gritty-Flat-Building-A", "Structure Future Gritty Flat Building A");
        CONVERTED_SHAPES.put("Future-Gritty-Medium-Office-A", "Structure Future Gritty Medium Office A");
        CONVERTED_SHAPES.put("Future-Gritty-Small-Building-A", "Structure Future Gritty Small Building A");
        CONVERTED_SHAPES.put("Future-Gritty-Small-Building-B", "Structure Future Gritty Small-Building B");
        CONVERTED_SHAPES.put("Future-Gritty-Tall-Building-A", "Structure Future Gritty Tall-Building A");
        CONVERTED_SHAPES.put("Modern-Arena-A", "Structure Modern Arena A");
        CONVERTED_SHAPES.put("Modern-Bank-A", "Structure Modern Bank A");
        CONVERTED_SHAPES.put("Modern-Box-Store-A", "Structure Modern Box Store A");
        CONVERTED_SHAPES.put("Modern-Cafe-A", "Structure Modern Cafe A");
        CONVERTED_SHAPES.put("Modern-Church-A", "Structure Modern Church A");
        CONVERTED_SHAPES.put("Modern-Convenience-Store-A", "Structure Convenience-Store Arena A");
        CONVERTED_SHAPES.put("Modern-Factory-A", "Structure Modern Factory A");
        CONVERTED_SHAPES.put("Modern-FastFood-A", "Structure Modern Fast Food A");
        CONVERTED_SHAPES.put("Modern-GroceryStore-A", "Structure Modern Grocery Store A");
        CONVERTED_SHAPES.put("Modern-House-A", "Structure Modern House A");
        CONVERTED_SHAPES.put("Modern-House-B", "Structure Modern House B");
        CONVERTED_SHAPES.put("Modern-House-C", "Structure Modern House C");
        CONVERTED_SHAPES.put("Modern-House-D", "Structure Modern House D");
        CONVERTED_SHAPES.put("Modern-Kiosk-A", "Structure Modern Kiosk A");
        CONVERTED_SHAPES.put("Modern-Mansion-A", "Structure Modern Mansion A");
        CONVERTED_SHAPES.put("Modern-Office-Building-A", "Structure Modern Office Building A");
        CONVERTED_SHAPES.put("Modern-Office-Building-B", "Structure Modern Office Building B");
        CONVERTED_SHAPES.put("Modern-Restaurant-A", "Structure Modern Restaurant A");
        CONVERTED_SHAPES.put("Modern-Skyscraper-A", "Structure Modern Skyscraper A");
        CONVERTED_SHAPES.put("Modern-nonUSFootball-A", "Structure Modern Stadium nonUS Football A");
        CONVERTED_SHAPES.put("Modern-StripMall-A", "Structure Modern StripMall A");
        CONVERTED_SHAPES.put("Modern-StripMall-B", "Structure Modern StripMall B");
        CONVERTED_SHAPES.put("Modern-StripMall-Large-A", "Structure Modern StripMall Large A");
        CONVERTED_SHAPES.put("Modern-Tenement-A", "Structure Modern Tenement A");
        CONVERTED_SHAPES.put("Modern-Townhouse-A", "Structure Modern Townhouse A");
        CONVERTED_SHAPES.put("Modern-Townhouse-B", "Structure Modern Townhouse B");
        CONVERTED_SHAPES.put("Modern-House-A", "Structure Modern House A");
        CONVERTED_SHAPES.put("Modern-House-A", "Structure Modern House A");
        CONVERTED_SHAPES.put("Jagged-Hill", "Semi-Real Hill Jagged");
        CONVERTED_SHAPES.put("Rolling-Hill", "Semi-Real Hill Rolling");
        CONVERTED_SHAPES.put("Rough", "Semi-Real Rough");
        CONVERTED_SHAPES.put("Tree", "Semi-Real Tree");
        CONVERTED_SHAPES.put("Tree-Cluster", "Semi-Real Tree Cluster");
        CONVERTED_SHAPES.put("Tree-Evergreen", "Semi-Real Evergreen");
        CONVERTED_SHAPES.put("Tree-Evergreen-Cluster", "Semi-Real Evergreen Cluster");
        CONVERTED_SHAPES.put("Tree-Evergreen-Mini-Cluster", "Semi-Real Tree Cluster 2");
        CONVERTED_SHAPES.put("Tree-Mini-Cluster", "Semi-Real Tree Cluster 2");
        CONVERTED_SHAPES.put("Tree-Mixed-Cluster", "Semi-Real Tree Cluster 3");
    }
}

