/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.DynamicTerrainSetting;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapKeyEntry;
import com.inkwellideas.ographer.map.MapKeyType;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.MapController;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.task.ChildMapTask;
import com.inkwellideas.ographer.ui.MapScene;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.ShapesToolbox;
import com.inkwellideas.ographer.ui.toolbox.WLogger;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.util.ArraySet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Stage;
import javafx.util.Pair;

public class MapUI
extends BorderPane {
    public String lastTerrainFilterCombo = null;
    public String lastFeatureFilterCombo = null;
    public String lastTerrainFilterText = "";
    public String lastFeatureFilterText = "";
    public boolean isSelectingArea;
    private boolean useAlternateIcons = false;
    private final MapController controller;
    private final WLogger WLogger;
    public static MapUI selectedMapUI = null;
    public final List<Point2D> selectPts = new ArrayList<Point2D>();
    boolean creatingDragSelectArea = false;
    Point2D dragPlaceFeatureLastPoint = null;
    public final ResizableCanvas canvas;
    public final ResizableCanvas overviewCanvas;
    final ResizableCanvas snapShotCanvas;
    public final ScrollBar hScrollBar = new ScrollBar();
    public final ScrollBar vScrollBar = new ScrollBar();
    final MapData mapData;
    String hideTags = "";
    String showTags = "";
    public boolean selectingShapes = false;
    public ViewLevel viewLevel;
    public Object hoverObject = null;
    public Object draggingObject = null;
    public Object draggingObjectParentOrig = null;
    public final Map<MapObject, Point2D> alsoDragging = new HashMap<MapObject, Point2D>();
    MapShape draggingObjectParent = null;
    Point2D dragStart = null;
    private final ArraySet<MapObject> currentObjects = new ArraySet();
    HashMap<MapShape, MapShape> dragShapeOrigsToCopies = null;
    Point2D selectedScaleNW = null;
    Point2D selectedScaleNE = null;
    Point2D selectedScaleSW = null;
    Point2D selectedScaleSE = null;
    Point2D selectedScalePt = null;
    final double initialScaleW = -1.0;
    double initialScaleH = -1.0;
    Point2D selectedRotate = null;
    double initialRotate = -1.0;
    public Point2D curveTo1 = null;
    public Point2D curveTo2 = null;
    boolean addRandomness = UserPrefs.get("addRandomnessToNewTerrain", true);
    public double totalMapWidthBase = 0.0;
    public double totalMapHeightBase = 0.0;
    public double totalMapWidthScreen = 0.0;
    public double totalMapHeightScreen = 0.0;
    WritableImage overviewImageOrig = null;
    public BufferedImage overviewImage = null;
    public Map<String, DynamicTerrainSetting> dynamicTerrainSettingMap = new TreeMap<String, DynamicTerrainSetting>();
    String noteFilter = "";
    Pair<Point2D, String> toolTipText = null;
    MapObject placingObject = null;

    public MapUI(MapData md, ViewLevel initiaLevel, WLogger WLogger2) {
        this.mapData = md;
        this.viewLevel = initiaLevel;
        this.controller = new MapController(md, this, WLogger2);
        this.WLogger = WLogger2;
        if (Worldographer.newui) {
            Stage stage = new Stage();
            MapScene ss = new MapScene(this.mapData, this.viewLevel);
            ss.start(stage);
            stage.show();
            this.canvas = new ResizableCanvas(false, false, false);
        } else {
            this.canvas = new ResizableCanvas(false, false, false);
            this.setCenter((Node)this.canvas);
            this.canvas.widthProperty().bind((ObservableValue)this.widthProperty().subtract(20));
            this.canvas.heightProperty().bind((ObservableValue)this.heightProperty().subtract(20));
            this.canvas.draw();
        }
        this.overviewCanvas = new ResizableCanvas(true, true, true);
        this.snapShotCanvas = new ResizableCanvas(true, false, false);
        this.vScrollBar.setOrientation(Orientation.VERTICAL);
        this.vScrollBar.valueProperty().addListener((ov, old_val, new_val) -> this.canvas.draw());
        this.hScrollBar.valueProperty().addListener((ov, old_val, new_val) -> this.canvas.draw());
        this.recaclulateMapSize();
        this.setRight((Node)this.vScrollBar);
        BorderPane bottomPane = new BorderPane();
        bottomPane.setCenter((Node)this.hScrollBar);
        bottomPane.setRight((Node)new Label("    "));
        this.setBottom((Node)bottomPane);
    }

    public MapController getController() {
        return this.controller;
    }

    public void setAddRandomness(boolean addRandomness) {
        this.addRandomness = addRandomness;
    }

    public Pair<Point2D, String> getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(Pair<Point2D, String> toolTipText) {
        this.toolTipText = toolTipText;
    }

    public boolean isUseAlternateIcons() {
        return this.useAlternateIcons;
    }

    public void setUseAlternateIcons(boolean useAlternateIcons) {
        this.useAlternateIcons = useAlternateIcons;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public MapData getMapData() {
        return this.mapData;
    }

    public void setNoteFilter(String noteFilter) {
        this.noteFilter = noteFilter.toLowerCase();
    }

    public String getNoteFilter() {
        return this.noteFilter;
    }

    public void resetOverview() {
        this.overviewImageOrig = null;
    }

    public String getHideTags() {
        return this.hideTags;
    }

    public void setHideTags(String hideTags) {
        this.hideTags = hideTags;
    }

    public String getShowTags() {
        return this.showTags;
    }

    public void setShowTags(String showTags) {
        this.showTags = showTags;
    }

    public ViewLevel getViewLevel() {
        return this.viewLevel;
    }

    public void setViewLevel(ViewLevel viewLevel) {
        this.viewLevel = viewLevel;
    }

    public MapObject getPlacingObject() {
        return this.placingObject;
    }

    public void setPlacingObject(MapObject placingObject) {
        this.placingObject = placingObject;
    }

    public void recaclulateMapSize() {
        this.canvas.recalculateHorizontalScrollBar();
        this.canvas.recalculateVerticalScrollBar();
    }

    public double computeTotalMapWidthPixelsCurrentTileSize() {
        return this.computeTotalMapWidthPixels(this.mapData.getTileWidth());
    }

    public double computeTotalMapHeightPixelsCurrentTileSize() {
        return this.computeTotalMapHeightPixels(this.mapData.getTileHeight());
    }

    public double computeTotalMapWidthPixels(double hexWidth) {
        return this.computeTotalMapWidthPixels(hexWidth, this.viewLevel);
    }

    public double computeTotalMapWidthPixels(double hexWidth, ViewLevel vl) {
        double totalMapWidthScreen = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? (double)this.mapData.getTerrain(vl).length * hexWidth * 3.0 / 4.0 + hexWidth / 4.0 : (this.mapData.getTileOrientation() == HexOrientation.ROWS ? (double)this.mapData.getTerrain(vl).length * hexWidth + hexWidth / 2.0 : (double)this.mapData.getTerrain(vl).length * hexWidth);
        return totalMapWidthScreen;
    }

    public double computeTotalMapHeightPixels(double hexHeight) {
        return this.computeTotalMapHeightPixels(hexHeight, this.viewLevel);
    }

    public double computeTotalMapHeightPixels(double hexHeight, ViewLevel vl) {
        double totalMapHeightScreen = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? (double)this.mapData.getTerrain(vl)[0].length * hexHeight + hexHeight / 2.0 : (this.mapData.getTileOrientation() == HexOrientation.ROWS ? (double)this.mapData.getTerrain(vl)[0].length * hexHeight * 3.0 / 4.0 + hexHeight / 4.0 : (double)this.mapData.getTerrain(vl)[0].length * hexHeight);
        return totalMapHeightScreen;
    }

    public double computeTotalMapWidthPixelsBaseTileSize() {
        return this.computeTotalMapWidthPixelsBaseHexSize();
    }

    public double computeTotalMapWidthPixelsBaseHexSize() {
        if (this.totalMapWidthBase == 0.0) {
            this.totalMapWidthBase = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? (double)this.mapData.getTerrain(this.viewLevel).length * 300.0 * 3.0 / 4.0 + 75.0 : (this.mapData.getTileOrientation() == HexOrientation.ROWS ? (double)this.mapData.getTerrain(this.viewLevel).length * 300.0 + 150.0 : (double)this.mapData.getTerrain(this.viewLevel).length * 300.0);
        }
        return this.totalMapWidthBase;
    }

    public double computeTotalMapHeightPixelsBaseTileSize() {
        return this.computeTotalMapHeightPixelsBaseHexSize();
    }

    public double computeTotalMapHeightPixelsBaseHexSize() {
        if (this.totalMapHeightBase == 0.0) {
            this.totalMapHeightBase = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? (double)this.mapData.getTerrain(this.viewLevel)[0].length * 300.0 + 150.0 : (this.mapData.getTileOrientation() == HexOrientation.ROWS ? (double)this.mapData.getTerrain(this.viewLevel)[0].length * 300.0 * 3.0 / 4.0 + 75.0 : (double)this.mapData.getTerrain(this.viewLevel)[0].length * 300.0);
        }
        return this.totalMapHeightBase;
    }

    public Rectangle getSnapShotArea(boolean selectingarea) {
        int w = (int)this.computeTotalMapWidthPixelsCurrentTileSize();
        int h = (int)this.computeTotalMapHeightPixelsCurrentTileSize();
        Rectangle rect = new Rectangle(0.0, 0.0, (double)w, (double)h);
        if (selectingarea && this.selectPts.size() > 1) {
            double minx = Double.MAX_VALUE;
            double miny = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double maxy = Double.MIN_VALUE;
            for (Point2D pt : this.selectPts) {
                if (pt.getX() > maxx) {
                    maxx = pt.getX();
                }
                if (pt.getX() < minx) {
                    minx = pt.getX();
                }
                if (pt.getY() > maxy) {
                    maxy = pt.getY();
                }
                if (!(pt.getY() < miny)) continue;
                miny = pt.getY();
            }
            Point2D startpt = MapUI.getScreenCoordsFromModelCoords(minx, miny, 0.0, 0.0, this.mapData.getTileWidth(), this.mapData.getTileHeight());
            Point2D endpt = MapUI.getScreenCoordsFromModelCoords(maxx, maxy, 0.0, 0.0, this.mapData.getTileWidth(), this.mapData.getTileHeight());
            w = (int)Math.abs(endpt.getX() - startpt.getX());
            h = (int)Math.abs(endpt.getY() - startpt.getY());
            rect = new Rectangle(startpt.getX(), startpt.getY(), (double)w, (double)h);
        }
        return rect;
    }

    public BufferedImage getSnapShotMapAsImage(Rectangle rect) {
        int framesW = (int)(rect.getWidth() / 2000.0 + (double)(rect.getWidth() % 2000.0 != 0.0 ? 1 : 0));
        int framesH = (int)(rect.getHeight() / 2000.0 + (double)(rect.getHeight() % 2000.0 != 0.0 ? 1 : 0));
        this.snapShotCanvas.setWidth(2000.0);
        this.snapShotCanvas.setHeight(2000.0);
        BufferedImage overallbi = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), 2);
        for (int i = 0; i < framesW; ++i) {
            for (int j = 0; j < framesH; ++j) {
                this.snapShotCanvas.getGraphicsContext2D().clearRect(0.0, 0.0, 2000.0, 2000.0);
                this.snapShotCanvas.draw(-1, -1, (double)(i * 2000) + rect.getX(), (double)(j * 2000) + rect.getY(), this.snapShotCanvas.getGraphicsContext2D(), false);
                SnapshotParameters ssparams = new SnapshotParameters();
                WritableImage wi = new WritableImage((int)this.snapShotCanvas.getWidth(), (int)this.snapShotCanvas.getHeight());
                this.snapShotCanvas.snapshot(ssparams, wi);
                BufferedImage bi = SwingFXUtils.fromFXImage((Image)wi, null);
                overallbi.getGraphics().drawImage(bi, i * 2000, j * 2000, null);
            }
        }
        return overallbi;
    }

    public void draw() {
        this.draw(-1, -1);
    }

    public void draw(int hexx, int hexy) {
        this.canvas.draw(hexx, hexy);
    }

    public Pair<Double, Double> getModelPtFromTerrain(double i, double j) {
        return this.mapData.getModelPtFromTerrain((int)i, (int)j);
    }

    public Point2D getSnapFeatureModelPt(double x, double y, boolean ismodelpt) {
        Point2D coords;
        if (ismodelpt) {
            Pair<Integer, Integer> pair = this.getTerrainFromModelPt(x, y);
            coords = new Point2D((double)((Integer)pair.getKey()).intValue(), (double)((Integer)pair.getValue()).intValue());
        } else {
            coords = this.getTerrainFromScenePt(x, y);
        }
        if (this.getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
            x = coords.getX() * 300.0 * 3.0 / 4.0 + 150.0;
            y = coords.getY() * 300.0 + (double)(coords.getX() % 2.0 == 1.0 ? 300 : 150);
        } else if (this.getMapData().getTileOrientation() == HexOrientation.ROWS) {
            y = coords.getY() * 300.0 * 3.0 / 4.0 + 150.0;
            x = coords.getX() * 300.0 + (double)(coords.getY() % 2.0 == 1.0 ? 300 : 150);
        } else if (this.getMapData().getTileOrientation() == HexOrientation.SQUARE) {
            Point2D apt = this.getModelCoordsFromScreenPt(x, y);
            x = (int)(apt.getX() + 37.0) / 75 * 75;
            y = (int)(apt.getY() + 37.0) / 75 * 75;
        }
        return new Point2D(x, y);
    }

    public Point2D getTerrainFromScenePt(double x, double y) {
        if (this.mapData.getTileOrientation() == HexOrientation.SQUARE) {
            int i = (int)(x / this.mapData.getTileWidth() + this.hScrollBar.getValue() / 300.0);
            int j = (int)(y / this.mapData.getTileHeight() + this.vScrollBar.getValue() / 300.0);
            return new Point2D((double)i, (double)j);
        }
        if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
            int i = (int)((x + this.hScrollBar.getValue() * this.mapData.getTileWidth() / 300.0) / (this.mapData.getTileWidth() * 3.0 / 4.0));
            int j = (int)(((i % 2 == 0 ? y : y - this.mapData.getTileHeight() / 2.0) + this.vScrollBar.getValue() * this.mapData.getTileHeight() / 300.0) / this.mapData.getTileHeight());
            return new Point2D((double)i, (double)j);
        }
        int j = (int)((y + this.vScrollBar.getValue() * this.mapData.getTileHeight() / 300.0) / (this.mapData.getTileHeight() * 3.0 / 4.0));
        int i = (int)(((j % 2 == 0 ? x : x - this.mapData.getTileWidth() / 2.0) + this.hScrollBar.getValue() * this.mapData.getTileWidth() / 300.0) / this.mapData.getTileWidth());
        return new Point2D((double)i, (double)j);
    }

    public Pair<Integer, Integer> getTerrainFromModelPt(double x, double y) {
        return this.mapData.getTerrainFromModelPt(x, y);
    }

    public Point2D getModelCoordsFromScreenPt(double x, double y) {
        return new Point2D(x / this.mapData.getTileWidth() * 300.0 + this.hScrollBar.getValue(), y / this.mapData.getTileHeight() * 300.0 + this.vScrollBar.getValue());
    }

    public Point2D getScreenCoordsFromModelCoords(double x, double y) {
        double offseth = this.hScrollBar.getValue() / this.hScrollBar.getMax() * (this.computeTotalMapWidthPixelsCurrentTileSize() - this.canvas.getWidth());
        double offsetv = this.vScrollBar.getValue() / this.vScrollBar.getMax() * (this.computeTotalMapHeightPixelsCurrentTileSize() - this.canvas.getHeight());
        return MapUI.getScreenCoordsFromModelCoords(x, y, offseth, offsetv, this.mapData.getTileWidth(), this.mapData.getTileHeight());
    }

    public static Point2D getScreenCoordsFromModelCoords(double x, double y, double scrollbarh, double scrollbarv, double hexw, double hexh) {
        return new Point2D(x * hexw / 300.0 - scrollbarh, y * hexh / 300.0 - scrollbarv);
    }

    private boolean doesObjectMatchTags(String objectTags, String[] tagArray) {
        for (String s : tagArray) {
            s = s.trim().toLowerCase();
            for (String t : objectTags.split(";")) {
                String featuretag = t.trim().toLowerCase();
                if (s.startsWith("year:")) {
                    int yr = 0;
                    try {
                        yr = Integer.parseInt(s.substring(5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (!featuretag.startsWith("years:")) continue;
                    String[] yearranges = featuretag.split(":");
                    for (int i = 1; i < yearranges.length; ++i) {
                        String[] years = yearranges[i].split("/");
                        int start = 0;
                        try {
                            start = Integer.parseInt(years[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int end = 0;
                        try {
                            end = Integer.parseInt(years[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (yr < start || yr > end) continue;
                        return true;
                    }
                    continue;
                }
                if (!featuretag.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static double getFontStringWidth(Font font, String s) {
        Text text = new Text(s);
        text.setFont(font);
        return text.getLayoutBounds().getWidth();
    }

    public ArraySet<MapObject> getCurrentObjects() {
        return this.currentObjects;
    }

    public class ResizableCanvas
    extends Canvas {
        final boolean isFull;
        final boolean isShowCurrentArea;
        final boolean expedite;
        double scaleOverview;
        public boolean isDirty = true;
        private final HashMap<String, javafx.scene.paint.Color> textureColors = new HashMap();

        public ResizableCanvas(boolean isfull, boolean expedite, boolean isshowcurrentarea) {
            this.isFull = isfull;
            this.expedite = expedite;
            this.isShowCurrentArea = isshowcurrentarea;
            if (!this.isFull) {
                this.widthProperty().addListener(evt -> this.redraw());
                this.heightProperty().addListener(evt -> this.redraw());
            }
        }

        public void redraw() {
            this.recalculateVerticalScrollBar();
            this.recalculateHorizontalScrollBar();
            this.draw();
        }

        public void recalculateHorizontalScrollBar() {
            MapUI.this.hScrollBar.setMax(MapUI.this.computeTotalMapWidthPixelsBaseTileSize() - this.getWidth() * 300.0 / MapUI.this.mapData.getTileWidth());
            MapUI.this.hScrollBar.setUnitIncrement(this.getWidth() / 4.0);
            MapUI.this.hScrollBar.setBlockIncrement(this.getWidth() / MapUI.this.computeTotalMapWidthPixelsCurrentTileSize() * MapUI.this.computeTotalMapWidthPixelsBaseTileSize());
        }

        public void recalculateVerticalScrollBar() {
            MapUI.this.vScrollBar.setMax(MapUI.this.computeTotalMapHeightPixelsBaseTileSize() - this.getHeight() * 300.0 / MapUI.this.mapData.getTileHeight());
            MapUI.this.vScrollBar.setUnitIncrement(this.getHeight() / 4.0);
            MapUI.this.vScrollBar.setBlockIncrement(this.getHeight() / MapUI.this.computeTotalMapHeightPixelsCurrentTileSize() * MapUI.this.computeTotalMapHeightPixelsBaseTileSize());
        }

        public void draw() {
            this.draw(-1, -1);
        }

        public void draw(int hexx, int hexy) {
            double offseth = MapUI.this.hScrollBar.getValue() / MapUI.this.hScrollBar.getMax() * (MapUI.this.computeTotalMapWidthPixelsCurrentTileSize() - this.getWidth());
            double offsetv = MapUI.this.vScrollBar.getValue() / MapUI.this.vScrollBar.getMax() * (MapUI.this.computeTotalMapHeightPixelsCurrentTileSize() - this.getHeight());
            this.draw(hexx, hexy, offseth, offsetv);
        }

        public void draw(int hexx, int hexy, double offseth, double offsetv) {
            this.draw(hexx, hexy, offseth, offsetv, this.getGraphicsContext2D(), true);
        }

        /*
         * WARNING - void declaration
         */
        public void draw(int hexx, int hexy, double offseth, double offsetv, GraphicsContext gc, boolean drawselection) {
            try {
                long drawStartTime = System.nanoTime();
                Font beginningfont = gc.getFont();
                double hexHeight = MapUI.this.mapData.getTileHeight();
                double hexWidth = MapUI.this.mapData.getTileWidth();
                MapLayer waterTerrainLayer = MapUI.this.mapData.getMapLayer("Terrain Water");
                MapLayer landTerrainLayer = MapUI.this.mapData.getMapLayer("Terrain Land");
                boolean isWaterTerrainLayerVisible = true;
                if (waterTerrainLayer != null) {
                    isWaterTerrainLayerVisible = waterTerrainLayer.isVisible();
                }
                boolean isLandTerrainLayerVisible = true;
                if (landTerrainLayer != null) {
                    isLandTerrainLayerVisible = landTerrainLayer.isVisible();
                }
                Rectangle windowbounds = this.getWindowOffsetBounds(offseth, offsetv, hexHeight, hexWidth);
                double wpt75 = MapUI.this.mapData.getTileWidth() * 0.75;
                double hpt75 = MapUI.this.mapData.getTileHeight() * 0.75;
                StringBuilder drawTimeDetailed = new StringBuilder("drawCanvas Times Setup:" + (System.nanoTime() - drawStartTime) / 1000L);
                if (this.expedite) {
                    offseth = 0.0;
                    offsetv = 0.0;
                    ViewLevel vl = MapUI.this.getViewLevel();
                    int greenboxfactor = 1;
                    if (vl == ViewLevel.PROVINCE && MapUI.this.mapData.getTerrain(vl).length * MapUI.this.mapData.getTerrain(vl)[0].length > 250000 && MapUI.this.mapData.getTerrain(ViewLevel.KINGDOM) != null) {
                        vl = ViewLevel.KINGDOM;
                        greenboxfactor = MapUI.this.mapData.getView().getProvinceFactor();
                    }
                    if (vl == ViewLevel.KINGDOM && MapUI.this.mapData.getTerrain(vl).length * MapUI.this.mapData.getTerrain(vl)[0].length > 250000 && MapUI.this.mapData.getTerrain(ViewLevel.CONTINENT) != null) {
                        vl = ViewLevel.CONTINENT;
                        greenboxfactor *= MapUI.this.mapData.getView().getKingdomFactor();
                    }
                    if (vl == ViewLevel.CONTINENT && MapUI.this.mapData.getTerrain(vl).length * MapUI.this.mapData.getTerrain(vl)[0].length > 250000 && MapUI.this.mapData.getTerrain(ViewLevel.WORLD) != null) {
                        vl = ViewLevel.WORLD;
                        greenboxfactor *= MapUI.this.mapData.getView().getContinentFactor();
                    }
                    MapUI.this.WLogger.addLogText("expediting greenboxfactor:" + greenboxfactor + " time:" + (System.nanoTime() - drawStartTime) / 1000L, true);
                    long afterGreenBoxTime = System.nanoTime();
                    hexHeight = Math.max(1.0, 200.0 / (double)MapUI.this.mapData.getTerrain(vl)[0].length);
                    hexWidth = hexHeight * MapUI.this.mapData.getTileWidth() / MapUI.this.mapData.getTileHeight();
                    this.setWidth(MapUI.this.computeTotalMapWidthPixels(hexWidth, vl));
                    this.setHeight(MapUI.this.computeTotalMapHeightPixels(hexHeight, vl));
                    if (this.isDirty) {
                        HashMap<String, List<MapShape>> shapesByLayer = new HashMap<String, List<MapShape>>();
                        for (MapShape ms : MapUI.this.mapData.getShapes()) {
                            if (ms.getMapLayer() == null) continue;
                            if (!shapesByLayer.containsKey(ms.getMapLayer().getName())) {
                                shapesByLayer.put(ms.getMapLayer().getName(), new ArrayList());
                            }
                            ((List)shapesByLayer.get(ms.getMapLayer().getName())).add(ms);
                        }
                        HashMap<String, List<Feature>> featuresByLayer = new HashMap<String, List<Feature>>();
                        HashMap<String, List<MapLabel>> labelsByLayer = new HashMap<String, List<MapLabel>>();
                        MapUI.this.WLogger.addLogText("expediting setup done:" + (System.nanoTime() - afterGreenBoxTime) / 1000L, true);
                        long l = System.nanoTime();
                        int layercount = MapUI.this.mapData.getMapLayers().size() - 1;
                        HashMap<String, Integer> terrainstartandendmap = new HashMap<String, Integer>();
                        terrainstartandendmap.put("xstart", 0);
                        terrainstartandendmap.put("xend", MapUI.this.mapData.getTerrain(vl).length);
                        terrainstartandendmap.put("ystart", 0);
                        terrainstartandendmap.put("yend", MapUI.this.mapData.getTerrain(vl)[0].length);
                        if (vl == ViewLevel.BATTLEMAT || vl == ViewLevel.SETTLEMENT) {
                            layercount = this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, new TreeMap<String, TreeMap<Double, Feature>>(), labelsByLayer, shapesByLayer, layercount, "Terrain Water", vl, wpt75, hpt75, true, drawTimeDetailed);
                        }
                        MapUI.this.WLogger.addLogText("expediting first draw features/shapes/labels:" + (System.nanoTime() - l) / 1000L, true);
                        long postFirstTime = System.nanoTime();
                        if (isWaterTerrainLayerVisible) {
                            this.drawTerrainExpress(vl, gc, hexHeight, hexWidth, true, false, null);
                        }
                        MapUI.this.WLogger.addLogText("expediting water:" + (System.nanoTime() - postFirstTime) / 1000L, true);
                        long postWaterTime = System.nanoTime();
                        if (vl == ViewLevel.BATTLEMAT || vl == ViewLevel.SETTLEMENT) {
                            layercount = this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, new TreeMap<String, TreeMap<Double, Feature>>(), labelsByLayer, shapesByLayer, layercount, "Terrain Land", vl, wpt75, hpt75, true, drawTimeDetailed);
                        }
                        MapUI.this.WLogger.addLogText("expediting after water:" + (System.nanoTime() - postWaterTime) / 1000L, true);
                        long postAfterWaterTime = System.nanoTime();
                        if (isLandTerrainLayerVisible) {
                            this.drawTerrainExpress(vl, gc, hexHeight, hexWidth, false, true, null);
                        }
                        MapUI.this.WLogger.addLogText("expediting land:" + (System.nanoTime() - postAfterWaterTime) / 1000L, true);
                        long postLandTime = System.nanoTime();
                        if (vl == ViewLevel.BATTLEMAT || vl == ViewLevel.SETTLEMENT) {
                            this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, new TreeMap<String, TreeMap<Double, Feature>>(), labelsByLayer, shapesByLayer, layercount, "All remaining layers - this string shouldn't match", vl, wpt75, hpt75, true, drawTimeDetailed);
                        }
                        MapUI.this.WLogger.addLogText("expediting after land:" + (System.nanoTime() - postLandTime) / 1000L, true);
                        long postAfterLandTime = System.nanoTime();
                        if (!MapUI.this.mapData.getShow().isGMOnly()) {
                            this.drawTerrainExpress(vl, gc, hexHeight, hexWidth, true, true, (Paint)javafx.scene.paint.Color.LIGHTGRAY);
                        }
                        MapUI.this.WLogger.addLogText("expediting after gmonly:" + (System.nanoTime() - postAfterLandTime) / 1000L, true);
                    }
                    this.isDirty = false;
                    if (MapUI.this.mapData.getMapProjection() == MapProjection.ICOSAHEDRAL) {
                        this.paintIcosahedralMask(gc, MapUI.this.mapData, offseth / (double)greenboxfactor, offsetv / (double)greenboxfactor, hexWidth, hexHeight, vl);
                    }
                    SnapshotParameters parameter = new SnapshotParameters();
                    double w = MapUI.this.computeTotalMapWidthPixels(hexWidth, vl) * 200.0 / MapUI.this.computeTotalMapHeightPixels(hexHeight, vl);
                    double d = 200.0;
                    if (w > 400.0) {
                        d = MapUI.this.computeTotalMapHeightPixels(hexHeight, vl) * 400.0 / MapUI.this.computeTotalMapWidthPixels(hexWidth, vl);
                        w = 400.0;
                    }
                    MapUI.this.overviewImageOrig = new WritableImage((int)w, (int)d);
                    this.scaleOverview = Math.min(w / this.getWidth(), d / this.getHeight());
                    parameter.setTransform((Transform)new Scale(this.scaleOverview, this.scaleOverview));
                    this.snapshot(parameter, MapUI.this.overviewImageOrig);
                    MapUI.this.overviewImage = new BufferedImage((int)MapUI.this.overviewImageOrig.getWidth(), (int)MapUI.this.overviewImageOrig.getHeight(), 2);
                    SwingFXUtils.fromFXImage((Image)MapUI.this.overviewImageOrig, (BufferedImage)MapUI.this.overviewImage);
                    double greenboxhexh = hexHeight / (double)greenboxfactor;
                    double greenboxhexw = hexWidth / (double)greenboxfactor;
                    this.drawOverviewBox(greenboxhexh, greenboxhexw);
                    gc.setFont(beginningfont);
                    return;
                }
                if (MapUI.this.mapData.getTrace().getImage() != null) {
                    hexx = -1;
                    hexy = -1;
                }
                long overallstarttime = System.nanoTime();
                long time = System.nanoTime();
                if (hexx < 0 && hexy < 0) {
                    gc.clearRect(0.0, 0.0, MapUI.this.canvas.getWidth(), MapUI.this.canvas.getHeight());
                }
                HashMap<String, List<Feature>> featuresByLayer = new HashMap<String, List<Feature>>();
                TreeMap<String, TreeMap<Double, Feature>> yOrderedFeatures = new TreeMap<String, TreeMap<Double, Feature>>();
                for (Feature feature : MapUI.this.mapData.getFeatures()) {
                    if (feature == null || feature.getLocation(MapUI.this.viewLevel) == null || feature.getMapLayer() == null) continue;
                    if (feature.getMapLayer().getName().toLowerCase().contains("y-order")) {
                        void var34_59;
                        TreeMap treeMap = (TreeMap)yOrderedFeatures.get(feature.getMapLayer().getName());
                        if (treeMap == null) {
                            TreeMap treeMap2 = new TreeMap();
                            yOrderedFeatures.put(feature.getMapLayer().getName(), treeMap2);
                        }
                        var34_59.put(feature.getLocation(MapUI.this.viewLevel).getY(), feature);
                        continue;
                    }
                    if (!featuresByLayer.containsKey(feature.getMapLayer().getName())) {
                        featuresByLayer.put(feature.getMapLayer().getName(), new ArrayList());
                    }
                    ((List)featuresByLayer.get(feature.getMapLayer().getName())).add(feature);
                }
                HashMap labelsByLayer = new HashMap();
                for (MapLabel mapLabel : MapUI.this.mapData.getMapLabels()) {
                    if (!labelsByLayer.containsKey(mapLabel.getMapLayer().getName())) {
                        labelsByLayer.put(mapLabel.getMapLayer().getName(), new ArrayList());
                    }
                    ((List)labelsByLayer.get(mapLabel.getMapLayer().getName())).add(mapLabel);
                }
                HashMap<String, List<MapShape>> hashMap = new HashMap<String, List<MapShape>>();
                for (MapShape ms : MapUI.this.mapData.getShapes()) {
                    if (ms.getMapLayer() == null) continue;
                    if (!hashMap.containsKey(ms.getMapLayer().getName())) {
                        hashMap.put(ms.getMapLayer().getName(), new ArrayList());
                    }
                    ((List)hashMap.get(ms.getMapLayer().getName())).add(ms);
                }
                drawTimeDetailed.append(" Clear:" + (System.nanoTime() - time) / 1000L);
                time = System.nanoTime();
                drawTimeDetailed.append(" Area:" + offseth + "," + offsetv + " " + this.getWidth() + "," + this.getHeight());
                if (MapUI.this.mapData.getTrace().getImage() != null) {
                    double d = MapUI.this.mapData.getTrace().getTopLeftX() * MapUI.this.mapData.getTileWidth();
                    double y = MapUI.this.mapData.getTrace().getTopLeftY() * MapUI.this.mapData.getTileHeight();
                    double w = MapUI.this.mapData.getTileWidth() * MapUI.this.mapData.getTrace().getWidth();
                    double h = MapUI.this.mapData.getTileHeight() * MapUI.this.mapData.getTrace().getHeight();
                    if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                        d *= 0.75;
                        w *= 0.75;
                    } else if (MapUI.this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                        y *= 0.75;
                        h *= 0.75;
                    }
                    gc.drawImage(MapUI.this.mapData.getTrace().getImage(), d - offseth, y - offsetv, w * 100.0, h * 100.0);
                }
                int n = MapUI.this.mapData.getMapLayers().size() - 1;
                Map<String, Integer> terrainstartandendmap = this.calculateTerrainDrawStartAndEnds(hexx, hexy, offseth, offsetv, hexHeight, hexWidth);
                int n2 = this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, yOrderedFeatures, labelsByLayer, hashMap, n, "Terrain Water", MapUI.this.viewLevel, wpt75, hpt75, false, drawTimeDetailed);
                MapUI.this.WLogger.addLogText("drawCanvas drawFSLByLayers Terrain Water:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                Set<Pair<Integer, Integer>> hiddenterraincoords = this.getHiddenTerrainIconCoords();
                MapUI.this.WLogger.addLogText("hidden terrain icons:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                if (isWaterTerrainLayerVisible) {
                    gc.setGlobalAlpha(this.calculateAlpha(MapUI.this.mapData.getMapLayer("Terrain Water"), 1.0));
                    this.drawTerrain(terrainstartandendmap, gc, offseth, offsetv, hexHeight, hexWidth, true, false, true, true, hiddenterraincoords, false, MapUI.this.getViewLevel());
                }
                drawTimeDetailed.append(" Terrain-Water:" + (System.nanoTime() - time) / 1000L);
                MapUI.this.WLogger.addLogText("drawCanvas terrain water:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                int n3 = this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, yOrderedFeatures, labelsByLayer, hashMap, n2, "Terrain Land", MapUI.this.viewLevel, wpt75, hpt75, false, drawTimeDetailed);
                MapUI.this.WLogger.addLogText("drawCanvas drawFSLByLayers Terrain Land:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                if (isLandTerrainLayerVisible) {
                    gc.setGlobalAlpha(this.calculateAlpha(MapUI.this.mapData.getMapLayer("Terrain Land"), 1.0));
                    this.drawTerrain(terrainstartandendmap, gc, offseth, offsetv, hexHeight, hexWidth, true, false, false, true, hiddenterraincoords, false, MapUI.this.getViewLevel());
                }
                drawTimeDetailed.append(" Terrain-Land:" + (System.nanoTime() - time) / 1000L);
                MapUI.this.WLogger.addLogText("drawCanvas terrain land:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                this.drawFeaturesLabelsShapesByLayers(terrainstartandendmap, offseth, offsetv, gc, hexHeight, hexWidth, windowbounds, featuresByLayer, yOrderedFeatures, labelsByLayer, hashMap, n3, "All remaining layers - this string shouldn't match", MapUI.this.viewLevel, wpt75, hpt75, false, drawTimeDetailed);
                gc.setGlobalAlpha(1.0);
                MapUI.this.WLogger.addLogText("drawCanvas drawFSLByLayers All Remaining:" + (System.nanoTime() - time) / 1000L, true);
                time = System.nanoTime();
                if (MapUI.this.mapData.getShow().isNotes()) {
                    double notesize = hexWidth / 6.0;
                    for (Note n4 : MapUI.this.mapData.getNotes()) {
                        Point2D pt;
                        Point2D notePt;
                        if (MapUI.this.viewLevel == ViewLevel.WORLD && !n4.isWorld() || MapUI.this.viewLevel == ViewLevel.CONTINENT && !n4.isContinent() || MapUI.this.viewLevel == ViewLevel.KINGDOM && !n4.isKingdom() || MapUI.this.viewLevel == ViewLevel.PROVINCE && !n4.isProvince() || n4.getParent() != null && (n4.getParent().isGmOnly() && !MapUI.this.mapData.getShow().isGMOnly() || n4.getParent().getMapLayer() != null && !n4.getParent().getMapLayer().isVisible()) || (notePt = n4.getLocation(MapUI.this.viewLevel)) == null || MapUI.this.noteFilter != null && !MapUI.this.noteFilter.equals("") && !n4.getTitle().toLowerCase().contains(MapUI.this.noteFilter) || (pt = MapUI.getScreenCoordsFromModelCoords(notePt.getX(), notePt.getY(), offseth, offsetv, hexWidth, hexHeight)).getX() + notesize < 0.0 || pt.getY() + notesize < 0.0 || pt.getX() > windowbounds.getWidth() || pt.getY() > windowbounds.getHeight()) continue;
                        javafx.scene.paint.Color c = new javafx.scene.paint.Color(n4.getColor().getRed(), n4.getColor().getGreen(), n4.getColor().getBlue(), 0.5);
                        gc.setFill((Paint)c);
                        gc.setStroke((Paint)new javafx.scene.paint.Color(0.5, 0.5, 0.5, 0.5));
                        gc.fillRect(pt.getX() - notesize / 2.0, pt.getY() - notesize / 2.0, notesize, notesize);
                        gc.strokeRect(pt.getX() - notesize / 2.0, pt.getY() - notesize / 2.0, notesize, notesize);
                    }
                }
                if (MapUI.this.hoverObject != null) {
                    this.drawSelectionOrHover(new javafx.scene.paint.Color(1.0, 1.0, 0.0, 0.3), MapUI.this.hoverObject, offseth, offsetv, gc, hexHeight, hexWidth);
                }
                if (MapUI.this.currentObjects.size() > 0 && drawselection) {
                    for (MapObject mo : MapUI.this.currentObjects) {
                        this.drawSelectionOrHover(new javafx.scene.paint.Color(1.0, 1.0, 0.0, 0.5), mo, offseth, offsetv, gc, hexHeight, hexWidth);
                    }
                }
                if (!MapUI.this.mapData.getShow().isGMOnly()) {
                    this.drawTerrain(terrainstartandendmap, gc, offseth, offsetv, hexHeight, hexWidth, true, false, false, true, null, true, MapUI.this.getViewLevel());
                }
                if (MapUI.this.mapData.getMapProjection() == MapProjection.ICOSAHEDRAL) {
                    this.paintIcosahedralMask(gc, MapUI.this.mapData, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), MapUI.this.viewLevel);
                }
                MapUI.this.WLogger.addLogText("drawCanvas mask time:" + (System.nanoTime() - time) / 1000L, true);
                if (MapUI.this.toolTipText != null) {
                    gc.setFill((Paint)javafx.scene.paint.Color.BISQUE);
                    gc.setStroke((Paint)javafx.scene.paint.Color.BLACK);
                    gc.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)10.0));
                    gc.setTextAlign(TextAlignment.LEFT);
                    double textw = MapUI.getFontStringWidth(gc.getFont(), (String)MapUI.this.toolTipText.getValue());
                    String[] lines = ((String)MapUI.this.toolTipText.getValue()).split("\\n");
                    gc.fillRect(((Point2D)MapUI.this.toolTipText.getKey()).getX(), ((Point2D)MapUI.this.toolTipText.getKey()).getY() - (double)(lines.length * 12) + 1.0, textw, (double)(lines.length * 12));
                    gc.setFill((Paint)javafx.scene.paint.Color.BLACK);
                    gc.fillText((String)MapUI.this.toolTipText.getValue(), ((Point2D)MapUI.this.toolTipText.getKey()).getX(), ((Point2D)MapUI.this.toolTipText.getKey()).getY() - (double)((lines.length - 1) * 12));
                }
                if (MapUI.this.selectPts.size() > 1 && drawselection) {
                    gc.setFill((Paint)new javafx.scene.paint.Color(1.0, 1.0, 0.0, 0.25));
                    double[] xs = new double[MapUI.this.selectPts.size()];
                    double[] ys = new double[MapUI.this.selectPts.size()];
                    int i = 0;
                    for (Point2D pt : MapUI.this.selectPts) {
                        Point2D selectptscreen = MapUI.getScreenCoordsFromModelCoords(pt.getX(), pt.getY(), offseth, offsetv, hexWidth, hexHeight);
                        xs[i] = selectptscreen.getX();
                        ys[i] = selectptscreen.getY();
                        ++i;
                    }
                    gc.fillPolygon(xs, ys, xs.length);
                }
                gc.setGlobalAlpha(1.0);
                this.drawMapKey(gc, offseth, offsetv, windowbounds);
                gc.setFont(beginningfont);
                if (MapUI.this.placingObject != null) {
                    Point2D tilecenterpt = null;
                    MapObject i = MapUI.this.placingObject;
                    if (i instanceof Feature) {
                        Feature f = (Feature)i;
                        if (((Feature)MapUI.this.placingObject).isFillHexBottom()) {
                            Point2D floc = f.getLocation(MapUI.this.viewLevel);
                            Pair<Integer, Integer> tilecoord = MapUI.this.mapData.getTerrainFromModelPt(floc.getX(), floc.getY());
                            tilecenterpt = this.calculateTerrainPointXY((Integer)tilecoord.getKey(), (Integer)tilecoord.getValue(), offseth, offsetv, hexWidth, hexHeight);
                            tilecenterpt = tilecenterpt.add(hexWidth / 2.0, hexHeight / 2.0);
                        }
                        f.paint(gc, MapUI.this.mapData, hexWidth, hexHeight, offseth, offsetv, MapUI.this.mapData.getTileOrientation(), MapUI.this.viewLevel, MapUI.this.mapData.getShow().isGMOnlyGlow(), MapUI.this.mapData.getShow().isFeatureLabels(), MapUI.this.useAlternateIcons, tilecenterpt);
                    }
                    if (MapUI.this.placingObject instanceof MapLabel) {
                        ((MapLabel)MapUI.this.placingObject).paint(gc, MapUI.this.mapData, hexWidth, hexHeight, offseth, offsetv, MapUI.this.viewLevel, MapUI.this.mapData.getTileOrientation(), MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), false);
                    }
                    if (MapUI.this.placingObject instanceof MapShape) {
                        this.drawShape(gc, offseth, offsetv, hexHeight, hexWidth, windowbounds, new HashMap<String, WritableImage>(), (MapShape)MapUI.this.placingObject, MapUI.this.viewLevel, true);
                    }
                }
                drawTimeDetailed.append(" Total:" + (System.nanoTime() - overallstarttime) / 1000L);
                MapUI.this.WLogger.addLogText("drawCanvas total paint time:" + (System.nanoTime() - overallstarttime) / 1000L, true);
                MapUI.this.WLogger.addLogText(drawTimeDetailed.toString(), false);
            }
            catch (ConcurrentModificationException e) {
                System.err.println("ConcurrentModificationException when drawing.");
            }
        }

        private void drawSelectionOrHover(javafx.scene.paint.Color c, Object obj, double offseth, double offsetv, GraphicsContext gc, double hexHeight, double hexWidth) {
            if (obj instanceof Point2D) {
                Point2D mpt = (Point2D)obj;
                Point2D pt = MapUI.getScreenCoordsFromModelCoords(mpt.getX(), mpt.getY(), offseth, offsetv, hexWidth, hexHeight);
                gc.setFill((Paint)c);
                int radius = 5;
                gc.fillOval(pt.getX() - (double)radius, pt.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2));
            } else if (obj instanceof MapShape) {
                MapShape ms = (MapShape)obj;
                ms.getShapePoints();
            } else if (obj instanceof List) {
                List selections = (List)obj;
                for (Object o : selections) {
                    if (!(o instanceof Feature)) continue;
                    this.drawSelectionFeature(c, offseth, offsetv, gc, hexHeight, hexWidth, (Feature)o);
                }
            } else if (obj instanceof Feature) {
                Feature selectedf = (Feature)obj;
                this.drawSelectionFeature(c, offseth, offsetv, gc, hexHeight, hexWidth, selectedf);
            } else if (obj instanceof MapLabel) {
                MapLabel selectedml = (MapLabel)obj;
                List<Point2D> labelscreencontrolpts = selectedml.getRotatedBoundingBoxPoints(MapUI.this.mapData, hexWidth, hexHeight, MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), offseth, offsetv, MapUI.this.getViewLevel());
                this.drawSelectionControlPoints(gc, labelscreencontrolpts, true);
                gc.setFill((Paint)c);
                double[] polyxpts = new double[]{labelscreencontrolpts.get(0).getX(), labelscreencontrolpts.get(1).getX(), labelscreencontrolpts.get(2).getX(), labelscreencontrolpts.get(3).getX()};
                double[] polyypts = new double[]{labelscreencontrolpts.get(0).getY(), labelscreencontrolpts.get(1).getY(), labelscreencontrolpts.get(2).getY(), labelscreencontrolpts.get(3).getY()};
                gc.fillPolygon(polyxpts, polyypts, polyxpts.length);
            }
        }

        private void drawSelectionFeature(javafx.scene.paint.Color c, double offseth, double offsetv, GraphicsContext gc, double hexHeight, double hexWidth, Feature selectedf) {
            Point2D modelpt = selectedf.getLocation(MapUI.this.viewLevel);
            if (modelpt != null) {
                Point2D pt = MapUI.getScreenCoordsFromModelCoords(modelpt.getX(), modelpt.getY(), offseth, offsetv, hexWidth, hexHeight);
                gc.setFill((Paint)c);
                double scale = selectedf.getScale();
                if (scale <= 0.0) {
                    scale = selectedf.getType().getIconSize() * 100.0;
                }
                double w = scale / 100.0 * hexWidth;
                double h = selectedf.getScaleHt() < 0.0 ? scale / 100.0 * hexHeight : selectedf.getScaleHt() / 100.0 * hexHeight;
                this.drawSelectionControlPoints(gc, selectedf, pt, w, h);
            }
        }

        private void drawGrid(double offseth, double offsetv, GraphicsContext gc, double hexHeight, double hexWidth, Map<String, Integer> terrainstartandendmap) {
            gc.setGlobalAlpha(this.calculateAlpha(MapUI.this.mapData.getMapLayer("Grid"), 1.0));
            if (MapUI.this.mapData.getShow().isGridNumbers()) {
                this.drawTerrain(terrainstartandendmap, gc, offseth, offsetv, hexHeight, hexWidth, false, MapUI.this.mapData.getShow().isGridNumbers(), false, false, null, false, MapUI.this.getViewLevel());
            }
            if (MapUI.this.mapData.getShow().isGrid() && (MapUI.this.mapData.getGrid().getSquare() == 1 || MapUI.this.mapData.getGrid().getSquare() == 2 || MapUI.this.mapData.getGrid().getSquare() == 9 || MapUI.this.mapData.getGrid().getSquare() == 10)) {
                this.drawSquareGrid(gc, offseth, offsetv, hexHeight, hexWidth);
            }
            if (MapUI.this.mapData.getShow().isGrid() && MapUI.this.mapData.getGrid().getSquare() != 1 && MapUI.this.mapData.getGrid().getSquare() != 9) {
                this.drawHigherLevelGrid(gc, offseth, offsetv, hexHeight, hexWidth);
            }
        }

        private double calculateAlpha(MapLayer layer, double otherObjectAlpha) {
            double alpha = layer != null ? layer.getOpacity() : 1.0;
            alpha *= otherObjectAlpha;
            if (MapUI.this.mapData.getTrace().getImage() != null && MapUI.this.mapData.getTrace().getOpacity() < 1.0) {
                alpha *= MapUI.this.mapData.getTrace().getOpacity();
            }
            return alpha;
        }

        private int drawFeaturesLabelsShapesByLayers(Map<String, Integer> terrainstartandendmap, double offseth, double offsetv, GraphicsContext gc, double hexHeight, double hexWidth, Rectangle windowbounds, Map<String, List<Feature>> featuresByLayer, TreeMap<String, TreeMap<Double, Feature>> yOrderedFeatures, Map<String, List<MapLabel>> labelsByLayer, Map<String, List<MapShape>> shapesByLayer, int layercount, String lastlayername, ViewLevel vl, double wpt75, double hpt75, boolean expedited, StringBuilder drawTimeDetailed) {
            long wrappertime = System.nanoTime();
            while (layercount >= 0) {
                long layertime = System.nanoTime();
                long time = System.nanoTime();
                MapLayer currentMapLayer = MapUI.this.mapData.getMapLayers().get(layercount);
                if (currentMapLayer.isVisible()) {
                    Map<Point, Terrain> extraTerrain;
                    gc.setGlobalAlpha(this.calculateAlpha(currentMapLayer, 1.0));
                    time = System.nanoTime();
                    Map<MapLayer, Map<Point, Terrain>> allExtraTerrain = MapUI.this.mapData.getExtraTerrainByLayer();
                    if (allExtraTerrain != null && (extraTerrain = allExtraTerrain.get(currentMapLayer)) != null) {
                        for (Point pt : extraTerrain.keySet()) {
                            Terrain singleTerrain = extraTerrain.get(pt);
                            Point2D screenPt = MapUI.getScreenCoordsFromModelCoords(pt.getX(), pt.getY(), offseth, offsetv, hexWidth, hexHeight);
                            singleTerrain.paint(gc, screenPt.getX(), screenPt.getY(), hexWidth, hexHeight, wpt75, hpt75, null, MapUI.this.mapData.getTileOrientation(), true, false, true, (Paint)singleTerrain.getBackgroundColor(), MapUI.this.isUseAlternateIcons() && MapUI.this.viewLevel == ViewLevel.BATTLEMAT);
                        }
                    }
                    drawTimeDetailed.append(" ExtraTerrain-" + currentMapLayer.getName() + ":" + (System.nanoTime() - time) / 1000L);
                    time = System.nanoTime();
                    List<MapShape> layerShapes = shapesByLayer.get(currentMapLayer.getName());
                    if (layerShapes != null && layerShapes.size() > 0 && (!expedited || vl != ViewLevel.WORLD && vl != ViewLevel.CONTINENT && vl != ViewLevel.KINGDOM && vl != ViewLevel.PROVINCE)) {
                        this.drawShapeHelper(gc, layerShapes, offseth, offsetv, hexHeight, hexWidth, vl, windowbounds, expedited);
                    }
                    drawTimeDetailed.append(" Shapes-" + currentMapLayer.getName() + ":" + (System.nanoTime() - time) / 1000L);
                    time = System.nanoTime();
                    if (currentMapLayer.getName().toLowerCase().contains("y-order")) {
                        if (yOrderedFeatures.get(currentMapLayer.getName()) != null && (layerFeatures = yOrderedFeatures.get(currentMapLayer.getName()).values()) != null && layerFeatures.size() > 0) {
                            this.drawFeatures(gc, offseth, offsetv, hexHeight, hexWidth, layerFeatures, windowbounds);
                        }
                    } else {
                        layerFeatures = featuresByLayer.get(currentMapLayer.getName());
                        if (layerFeatures != null && layerFeatures.size() > 0) {
                            this.drawFeatures(gc, offseth, offsetv, hexHeight, hexWidth, layerFeatures, windowbounds);
                        }
                    }
                    drawTimeDetailed.append(" Features-" + currentMapLayer.getName() + ":" + (System.nanoTime() - time) / 1000L);
                    time = System.nanoTime();
                    List<MapLabel> layerLabels = labelsByLayer.get(currentMapLayer.getName());
                    if (layerLabels != null && layerLabels.size() > 0) {
                        this.drawLabels(gc, MapUI.this.mapData, offseth, offsetv, hexHeight, hexWidth, layerLabels, windowbounds);
                    }
                    drawTimeDetailed.append(" Labels-" + currentMapLayer.getName() + ":" + (System.nanoTime() - time) / 1000L);
                    if ("grid".equalsIgnoreCase(currentMapLayer.getName()) && !this.expedite) {
                        long timegrid = System.nanoTime();
                        this.drawGrid(offseth, offsetv, gc, hexHeight, hexWidth, terrainstartandendmap);
                        drawTimeDetailed.append(" Grid:" + currentMapLayer.getName() + ":" + (System.nanoTime() - timegrid) / 1000L);
                    }
                }
                if (--layercount < 0 || !MapUI.this.mapData.getMapLayers().get(layercount).getName().equals(lastlayername)) continue;
                return layercount;
            }
            return layercount;
        }

        private void drawSquareGrid(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth) {
            gc.setLineWidth(MapUI.this.mapData.getGrid().getWidth()[4]);
            javafx.scene.paint.Color c = MapUI.this.mapData.getGrid().getColor()[4];
            gc.setStroke((Paint)new javafx.scene.paint.Color(c.getRed(), c.getGreen(), c.getBlue(), c.getOpacity()));
            if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                double adjx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getSquareWidth() : hexWidth * 3.0 / 4.0;
                double adjy = MapUI.this.mapData.getGrid().getSquareHeight() > 0.0 ? MapUI.this.mapData.getGrid().getSquareHeight() : hexHeight;
                double offsetx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetX() : hexWidth / 8.0;
                double offsety = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetY() : 0.0;
                offsetx -= offseth % adjx;
                offsety -= offsetv % adjy;
                for (double i = 0.0; i < this.getWidth(); i += adjx) {
                    gc.strokeLine(i + offsetx, 0.0, i + offsetx, this.getHeight());
                }
                for (double j = 0.0; j < this.getHeight(); j += adjy) {
                    gc.strokeLine(0.0, j + offsety, this.getWidth(), j + offsety);
                }
            } else if (MapUI.this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                double adjx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getSquareWidth() : hexWidth;
                double adjy = MapUI.this.mapData.getGrid().getSquareHeight() > 0.0 ? MapUI.this.mapData.getGrid().getSquareHeight() : hexHeight * 3.0 / 4.0;
                double offsetx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetX() : 0.0;
                double offsety = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetY() : hexHeight / 8.0;
                offsetx -= offseth % adjx;
                offsety -= offsetv % adjy;
                for (double i = 0.0; i < this.getWidth(); i += adjx) {
                    gc.strokeLine(i + offsetx, 0.0, i + offsetx, this.getHeight());
                }
                for (double j = 0.0; j < this.getHeight(); j += adjy) {
                    gc.strokeLine(0.0, j + offsety, this.getWidth(), j + offsety);
                }
            } else {
                double adjx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getSquareWidth() : hexWidth;
                double adjy = MapUI.this.mapData.getGrid().getSquareHeight() > 0.0 ? MapUI.this.mapData.getGrid().getSquareHeight() : hexHeight;
                double offsetx = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetX() : 0.0;
                double offsety = MapUI.this.mapData.getGrid().getSquareWidth() > 0.0 ? MapUI.this.mapData.getGrid().getOffsetY() : 0.0;
                if ((offsetx -= offseth % adjx) < 0.0) {
                    offsetx += adjx;
                }
                if ((offsety -= offsetv % adjy) < 0.0) {
                    offsety += adjy;
                }
                for (double i = 0.0; i < this.getWidth(); i += adjx) {
                    gc.strokeLine(i + offsetx, 0.0, i + offsetx, this.getHeight());
                }
                for (double j = 0.0; j < this.getHeight(); j += adjy) {
                    gc.strokeLine(0.0, j + offsety, this.getWidth(), j + offsety);
                }
            }
        }

        void drawOverviewBox(double hexHeight, double hexWidth) {
            double factor = 1.0;
            if (this.isShowCurrentArea) {
                this.paintOverviewBox(MapUI.this.overviewImage.getGraphics(), hexWidth * this.scaleOverview * factor, hexHeight * this.scaleOverview * factor);
            }
        }

        private Set<Pair<Integer, Integer>> getHiddenTerrainIconCoords() {
            HashSet<Pair<Integer, Integer>> hiddenterraincoords = new HashSet<Pair<Integer, Integer>>();
            for (Feature f : MapUI.this.mapData.getFeatures()) {
                Point2D pt;
                if (f == null || !f.isHideTerrainIcon() || f.isGmOnly() && !MapUI.this.mapData.getShow().isGMOnly() || (pt = f.getLocation(MapUI.this.viewLevel)) == null) continue;
                Pair<Integer, Integer> coord = MapUI.this.getTerrainFromModelPt(pt.getX(), pt.getY());
                hiddenterraincoords.add(coord);
            }
            return hiddenterraincoords;
        }

        private void drawMapKey(GraphicsContext gc, double offseth, double offsetv, Rectangle windowbounds) {
            gc.setTextAlign(TextAlignment.LEFT);
            if (MapUI.this.mapData.getMapKeySettings() == null) {
                return;
            }
            int ht = MapUI.this.mapData.getMapKeySettings().height;
            if (ht <= 1) {
                return;
            }
            Double posx = MapUI.this.mapData.getMapKeySettings().positionx;
            Double posy = MapUI.this.mapData.getMapKeySettings().positiony;
            ViewLevel vl = MapUI.this.mapData.getMapKeySettings().viewlevel;
            Pair<Double, Double> mapkeymodelpt = MapUI.this.getModelPtFromTerrain(posx, posy);
            HashMap<String, WritableImage> imagecache = new HashMap<String, WritableImage>();
            double conversionfactor = MapObject.getConversionFactor(MapUI.this.viewLevel, vl, MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor());
            double xposition = (Double)mapkeymodelpt.getKey() * conversionfactor;
            double yposition = (Double)mapkeymodelpt.getValue() * conversionfactor;
            Map<String, MapKeyEntry> entries = MapUI.this.mapData.getMapKeySettings().entries;
            TreeMap<Integer, MapKeyEntry> sortedentries = new TreeMap<Integer, MapKeyEntry>();
            double wideststring = 0.0;
            Font font = Font.font((String)MapUI.this.mapData.getMapKeySettings().entryFontFace, (FontWeight)(MapUI.this.mapData.getMapKeySettings().entryFontBold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(MapUI.this.mapData.getMapKeySettings().entryFontItalic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)(MapUI.this.mapData.getTileHeight() * (double)MapUI.this.mapData.getMapKeySettings().entryScale / 100.0));
            gc.setFont(font);
            Text texttest = new Text();
            texttest.setFont(font);
            for (MapKeyEntry mke : entries.values()) {
                texttest.setText(mke.getLabel());
                double w = texttest.getLayoutBounds().getWidth();
                if (w > wideststring) {
                    wideststring = w;
                }
                if (mke.getOrder() <= 0) continue;
                sortedentries.put(mke.getOrder(), mke);
            }
            int numcolumns = sortedentries.size() / ht;
            if (sortedentries.size() % ht > 0) {
                ++numcolumns;
            }
            double textheight = texttest.getLayoutBounds().getHeight() * 300.0 / MapUI.this.mapData.getTileHeight();
            double wideststringscreen = wideststring;
            wideststring = wideststring * 300.0 / MapUI.this.mapData.getTileWidth();
            Point2D screenpt = MapUI.getScreenCoordsFromModelCoords(xposition, yposition, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
            javafx.scene.paint.Color fill = MapUI.this.mapData.getMapKeySettings().backgroundColor;
            fill = new javafx.scene.paint.Color(fill.getRed(), fill.getGreen(), fill.getBlue(), (double)MapUI.this.mapData.getMapKeySettings().backgroundOpacity / 100.0);
            gc.setFill((Paint)fill);
            gc.fillRect(screenpt.getX() - MapUI.this.mapData.getTileWidth() / 2.0, screenpt.getY() - MapUI.this.mapData.getTileHeight(), (double)numcolumns * (wideststringscreen + 4.0 * MapUI.this.mapData.getTileWidth() / 3.0) + MapUI.this.mapData.getTileWidth(), (double)ht * MapUI.this.mapData.getTileHeight() + 1.75 * MapUI.this.mapData.getTileHeight());
            this.drawMapKeyTitle(gc, screenpt);
            screenpt = numcolumns == 1 ? MapUI.getScreenCoordsFromModelCoords(xposition, yposition + 300.0, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight()) : MapUI.getScreenCoordsFromModelCoords(xposition + 400.0 + wideststring, yposition, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
            this.drawMapKeyScale(gc, screenpt);
            double ypositionorig = yposition;
            yposition = (numcolumns == 1 ? yposition + 300.0 : yposition) + 75.0;
            double wpt75 = MapUI.this.mapData.getTileWidth() * 0.75;
            double hpt75 = MapUI.this.mapData.getTileHeight() * 0.75;
            for (MapKeyEntry mke : sortedentries.values()) {
                Terrain t;
                if (mke.getOrder() <= 0) continue;
                if (yposition > ypositionorig + (double)(ht * 300)) {
                    yposition = (numcolumns == 1 ? ypositionorig + 300.0 : ypositionorig) + 75.0;
                    xposition = xposition + 400.0 + wideststring;
                }
                if (MapKeyType.EE_TERRAIN == mke.getType()) {
                    t = new Terrain(mke.getKey(), false);
                    t.setBackgroundColor(mke.getColor());
                    screenpt = MapUI.getScreenCoordsFromModelCoords(xposition, yposition, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
                    t.paint(gc, screenpt.getX(), screenpt.getY(), MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), wpt75, hpt75, javafx.scene.paint.Color.BLACK, MapUI.this.mapData.getTileOrientation(), true, true, true, null, MapUI.this.isUseAlternateIcons());
                }
                if (MapKeyType.LL_FEATURE == mke.getType()) {
                    t = new Terrain("Blank", false);
                    t.setBackgroundColor(mke.getColor());
                    screenpt = MapUI.getScreenCoordsFromModelCoords(xposition, yposition, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
                    t.paint(gc, screenpt.getX(), screenpt.getY(), MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), wpt75, hpt75, javafx.scene.paint.Color.BLACK, MapUI.this.mapData.getTileOrientation(), true, true, true, null, MapUI.this.isUseAlternateIcons());
                    Feature f = new Feature(mke.getKey());
                    f.setLocation(MapUI.this.getViewLevel(), new Point2D(xposition + 150.0, yposition + 150.0));
                    f.setScale(mke.getScale());
                    f.paint(gc, MapUI.this.mapData, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), offseth, offsetv, MapUI.this.mapData.getTileOrientation(), MapUI.this.viewLevel, false, false, MapUI.this.useAlternateIcons, null);
                }
                if (MapKeyType.SS_SHAPE == mke.getType()) {
                    MapShape ms = null;
                    for (MapShape m : MapUI.this.mapData.getShapes()) {
                        if (!m.getTags().equals(mke.getKey())) continue;
                        ms = m.clone();
                        break;
                    }
                    if (ms != null) {
                        Shape shape;
                        Shape pts;
                        Polygon p;
                        MapShape m;
                        m = ms.getShape();
                        if (m instanceof Polygon) {
                            p = (Polygon)m;
                            pts = p.getPoints();
                            pts.remove(0, pts.size());
                            pts.add((Object)(xposition + 25.0));
                            pts.add((Object)(yposition + 25.0));
                            pts.add((Object)(xposition + 25.0));
                            pts.add((Object)(yposition + 275.0));
                            pts.add((Object)(xposition + 275.0));
                            pts.add((Object)(yposition + 275.0));
                            pts.add((Object)(xposition + 275.0));
                            pts.add((Object)(yposition + 25.0));
                        }
                        if ((pts = ms.getShape()) instanceof Path) {
                            p = (Path)pts;
                            p.getElements().remove(0, p.getElements().size());
                            MoveTo mt = new MoveTo(xposition + 25.0, yposition + 150.0);
                            p.getElements().add((Object)mt);
                            LineTo lt = new LineTo(xposition + 275.0, yposition + 150.0);
                            p.getElements().add((Object)lt);
                        }
                        if ((shape = ms.getShape()) instanceof Arc) {
                            Arc a = (Arc)shape;
                            a.setCenterX(xposition + 25.0);
                            a.setCenterY(yposition + 25.0);
                            a.setRadiusX(250.0);
                            a.setRadiusY(250.0);
                        }
                        this.drawShape(gc, offseth, offsetv, MapUI.this.mapData.getTileHeight(), MapUI.this.mapData.getTileWidth(), windowbounds, imagecache, ms, MapUI.this.viewLevel, false);
                    }
                }
                String text = mke.getLabel();
                screenpt = MapUI.getScreenCoordsFromModelCoords(xposition + 310.0, yposition + 150.0 + textheight / 2.0, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
                font = Font.font((String)MapUI.this.mapData.getMapKeySettings().entryFontFace, (FontWeight)(MapUI.this.mapData.getMapKeySettings().entryFontBold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(MapUI.this.mapData.getMapKeySettings().entryFontItalic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)(MapUI.this.mapData.getTileHeight() * (double)MapUI.this.mapData.getMapKeySettings().entryScale / 100.0));
                gc.setFont(font);
                gc.setFill((Paint)MapUI.this.mapData.getMapKeySettings().entryFontColor);
                gc.fillText(text, screenpt.getX(), screenpt.getY() - MapUI.this.mapData.getTileHeight() / 10.0);
                yposition += 300.0;
            }
            MapUI.this.resetOverview();
        }

        private void drawMapKeyScale(GraphicsContext gc, Point2D screenpt) {
            String scale = MapUI.this.mapData.getMapKeySettings().scaleText;
            Font font = Font.font((String)MapUI.this.mapData.getMapKeySettings().scaleFontFace, (FontWeight)(MapUI.this.mapData.getMapKeySettings().scaleFontBold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(MapUI.this.mapData.getMapKeySettings().scaleFontItalic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)(MapUI.this.mapData.getTileHeight() * (double)MapUI.this.mapData.getMapKeySettings().scaleScale / 100.0));
            gc.setFont(font);
            gc.setFill((Paint)MapUI.this.mapData.getMapKeySettings().scaleFontColor);
            gc.fillText(scale, screenpt.getX(), screenpt.getY());
        }

        private void drawMapKeyTitle(GraphicsContext gc, Point2D screenpt) {
            String title = MapUI.this.mapData.getMapKeySettings().titleText;
            Font font = Font.font((String)MapUI.this.mapData.getMapKeySettings().titleFontFace, (FontWeight)(MapUI.this.mapData.getMapKeySettings().titleFontBold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(MapUI.this.mapData.getMapKeySettings().titleFontItalic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)(MapUI.this.mapData.getTileHeight() * (double)MapUI.this.mapData.getMapKeySettings().titleScale / 100.0));
            gc.setFont(font);
            gc.setFill((Paint)MapUI.this.mapData.getMapKeySettings().titleFontColor);
            gc.fillText(title, screenpt.getX(), screenpt.getY());
        }

        private void drawHigherLevelGrid(GraphicsContext gc, double offseth, double offsetv, double h, double w) {
            double userChosenOffsetY2;
            double userChosenOffsetX2;
            double wf;
            double kf;
            double userChosenOffsetY;
            double userChosenOffsetX;
            if (MapUI.this.mapData.getGrid().getWidth()[0] != 0.0) {
                gc.setStroke((Paint)MapUI.this.mapData.getGrid().getColor()[0]);
                gc.setLineWidth(MapUI.this.mapData.getGrid().getWidth()[0]);
                this.drawHigherLevelGridHelper(gc, offseth, offsetv, h, w, 1.0, w, h, MapUI.this.mapData.getTerrain(MapUI.this.viewLevel), true);
            }
            if (MapUI.this.viewLevel == ViewLevel.CONTINENT && MapUI.this.mapData.getGrid().getWidth()[1] != 0.0) {
                double cf = MapUI.this.mapData.getView().getContinentFactor();
                userChosenOffsetX = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldContinentX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetWorldContinentX() * w;
                userChosenOffsetY = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldContinentY() * h : MapUI.this.mapData.getView().getGridOffsetWorldContinentY() * h * 0.75;
                this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.WORLD), MapUI.this.mapData.getGrid().getColor()[1], MapUI.this.mapData.getGrid().getWidth()[1], offseth, offsetv, userChosenOffsetX, userChosenOffsetY, h, w, cf);
            }
            if (MapUI.this.viewLevel == ViewLevel.KINGDOM) {
                if (MapUI.this.mapData.getGrid().getWidth()[1] != 0.0) {
                    kf = MapUI.this.mapData.getView().getKingdomFactor();
                    userChosenOffsetX = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetContinentKingdomX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetContinentKingdomX() * w;
                    userChosenOffsetY = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetContinentKingdomY() * h : MapUI.this.mapData.getView().getGridOffsetContinentKingdomY() * h * 0.75;
                    this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.CONTINENT), MapUI.this.mapData.getGrid().getColor()[1], MapUI.this.mapData.getGrid().getWidth()[1], offseth, offsetv, userChosenOffsetX, userChosenOffsetY, h, w, kf);
                }
                if (MapUI.this.mapData.getGrid().getWidth()[2] != 0.0) {
                    wf = MapUI.this.mapData.getView().getContinentFactor() * MapUI.this.mapData.getView().getKingdomFactor();
                    userChosenOffsetX2 = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldKingdomX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetWorldKingdomX() * w;
                    userChosenOffsetY2 = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldKingdomY() * h : MapUI.this.mapData.getView().getGridOffsetWorldKingdomY() * h * 0.75;
                    this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.WORLD), MapUI.this.mapData.getGrid().getColor()[2], MapUI.this.mapData.getGrid().getWidth()[2], offseth, offsetv, userChosenOffsetX2, userChosenOffsetY2, h, w, wf);
                }
            }
            if (MapUI.this.viewLevel == ViewLevel.PROVINCE) {
                if (MapUI.this.mapData.getGrid().getWidth()[1] != 0.0) {
                    double pf = MapUI.this.mapData.getView().getProvinceFactor();
                    userChosenOffsetX = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetKingdomProvinceX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetKingdomProvinceX() * w;
                    userChosenOffsetY = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetKingdomProvinceY() * h : MapUI.this.mapData.getView().getGridOffsetKingdomProvinceY() * h * 0.75;
                    this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.KINGDOM), MapUI.this.mapData.getGrid().getColor()[1], MapUI.this.mapData.getGrid().getWidth()[1], offseth, offsetv, userChosenOffsetX, userChosenOffsetY, h, w, pf);
                }
                if (MapUI.this.mapData.getGrid().getWidth()[2] != 0.0) {
                    kf = MapUI.this.mapData.getView().getKingdomFactor() * MapUI.this.mapData.getView().getProvinceFactor();
                    userChosenOffsetX = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetContinentKingdomX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetContinentKingdomX() * w;
                    userChosenOffsetY = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetContinentKingdomY() * h : MapUI.this.mapData.getView().getGridOffsetContinentKingdomY() * h * 0.75;
                    this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.CONTINENT), MapUI.this.mapData.getGrid().getColor()[2], MapUI.this.mapData.getGrid().getWidth()[2], offseth, offsetv, userChosenOffsetX, userChosenOffsetY, h, w, kf);
                }
                if (MapUI.this.mapData.getGrid().getWidth()[3] != 0.0) {
                    wf = MapUI.this.mapData.getView().getContinentFactor() * MapUI.this.mapData.getView().getKingdomFactor() * MapUI.this.mapData.getView().getProvinceFactor();
                    userChosenOffsetX2 = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldKingdomX() * w * 0.75 : MapUI.this.mapData.getView().getGridOffsetWorldKingdomX() * w;
                    userChosenOffsetY2 = MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? MapUI.this.mapData.getView().getGridOffsetWorldKingdomY() * h : MapUI.this.mapData.getView().getGridOffsetWorldKingdomY() * h * 0.75;
                    this.drawHigherLevelGridHelperSetup(gc, MapUI.this.mapData.getTerrain(ViewLevel.WORLD), MapUI.this.mapData.getGrid().getColor()[3], MapUI.this.mapData.getGrid().getWidth()[3], offseth, offsetv, userChosenOffsetX2, userChosenOffsetY2, h, w, wf);
                }
            }
        }

        private void drawHigherLevelGridHelperSetup(GraphicsContext gc, Terrain[][] terrain, javafx.scene.paint.Color gridcolor, double linewidth, double offseth, double offsetv, double userChosenOffsetX, double userChosenOffsetY, double h, double w, double factor) {
            gc.setStroke((Paint)gridcolor);
            gc.setLineWidth(linewidth);
            this.drawHigherLevelGridHelper(gc, offseth - userChosenOffsetX, offsetv - userChosenOffsetY, h, w, factor, w * factor, h * factor, terrain, false);
        }

        private void drawHigherLevelGridHelper(GraphicsContext gc, double offseth, double offsetv, double h, double w, double cf, double wc, double hc, Terrain[][] terrain, boolean iscurrentlevel) {
            if (terrain == null) {
                return;
            }
            if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS || MapUI.this.mapData.getTileOrientation() == HexOrientation.SQUARE && MapUI.this.mapData.getGrid().getSquare() < 8) {
                double squareadjforx = 0.0;
                if (MapUI.this.mapData.getTileOrientation() == HexOrientation.SQUARE) {
                    squareadjforx = wc * 0.08;
                    wc *= 1.33;
                }
                block0: for (int i = 0; i < terrain.length + (iscurrentlevel ? 0 : 1); ++i) {
                    double basex = MapUI.this.mapData.getTileOrientation() == HexOrientation.SQUARE ? (double)i * w * cf - w * cf / 2.0 - offseth + w / 4.0 + squareadjforx : (double)i * w * cf * 3.0 / 4.0 - w * cf / 2.0 - offseth + w / 2.0;
                    if (basex + w * cf < 0.0) continue;
                    if (!(basex - w * cf > this.getWidth())) {
                        for (int j = 0; j < terrain[0].length + (!iscurrentlevel && i % 2 == 0 ? 1 : 0); ++j) {
                            double basey = (double)j * h * cf - h * cf / 2.0 + (i % 2 == 1 ? h * cf / 2.0 : 0.0) - offsetv + h / 2.0;
                            if ((double)(j + 1) * h * cf - h * cf / 2.0 + (i % 2 == 1 ? h * cf : h * cf / 2.0) - offsetv + h / 2.0 < 0.0) continue;
                            if (basey > this.getHeight()) continue block0;
                            double[] xs = new double[]{basex, basex + wc / 4.0, basex + wc * 3.0 / 4.0, basex + wc, basex + wc * 3.0 / 4.0, basex + wc / 4.0};
                            double[] ys = new double[]{basey + hc / 2.0, basey, basey, basey + hc / 2.0, basey + hc, basey + hc};
                            gc.strokePolygon(xs, ys, xs.length);
                        }
                        continue;
                    }
                    break;
                }
            } else {
                double squareadjfory = 0.0;
                if (MapUI.this.mapData.getTileOrientation() == HexOrientation.SQUARE) {
                    squareadjfory = hc * 0.08;
                    hc *= 1.33;
                }
                for (int i = 0; i < terrain.length + (iscurrentlevel ? 0 : 1); ++i) {
                    for (int j = 0; j < terrain[0].length + (!iscurrentlevel && i % 2 == 0 ? 1 : 0); ++j) {
                        double basey;
                        double basex = (double)i * w * cf - w * cf / 2.0 + (j % 2 == 1 ? w * cf / 2.0 : 0.0) - offseth + w / 2.0;
                        if (basex + w * cf < 0.0 || basex - w * cf > this.getWidth() || (basey = MapUI.this.mapData.getTileOrientation() == HexOrientation.SQUARE ? (double)j * h * cf - h * cf / 2.0 - offsetv + h / 4.0 + squareadjfory : (double)j * h * cf * 3.0 / 4.0 - h * cf / 2.0 - offsetv + h / 2.0) + h * cf < 0.0 || basey - h * cf > this.getHeight()) continue;
                        double[] xs = new double[]{basex, basex + wc / 2.0, basex + wc, basex + wc, basex + wc / 2.0, basex};
                        double[] ys = new double[]{basey + hc / 4.0, basey, basey + hc / 4.0, basey + hc * 3.0 / 4.0, basey + hc, basey + hc * 3.0 / 4.0};
                        gc.strokePolygon(xs, ys, xs.length);
                    }
                }
            }
        }

        private void drawSelectionControlPoints(GraphicsContext gc, Feature selectedf, Point2D pt, double w, double h) {
            double d = Math.min(w, h);
            gc.fillOval(pt.getX() - d / 2.0, pt.getY() - d / 2.0, d, d);
            gc.setFill((Paint)new javafx.scene.paint.Color(1.0, 0.0, 0.0, 0.5));
            Rotate rotate = new Rotate();
            rotate.setAngle(selectedf.getRotate());
            rotate.setPivotX(pt.getX());
            rotate.setPivotY(pt.getY());
            Point2D pt1 = rotate.transform(pt.getX() - w / 2.0, pt.getY() - h / 2.0);
            Point2D pt2 = rotate.transform(pt.getX() + w / 2.0, pt.getY() + h / 2.0);
            Point2D pt3 = rotate.transform(pt.getX() - w / 2.0, pt.getY() + h / 2.0);
            Point2D pt4 = rotate.transform(pt.getX() + w / 2.0, pt.getY() - h / 2.0);
            if (selectedf.getScale() >= 0.0) {
                gc.fillOval(pt1.getX() - 3.0, pt1.getY() - 3.0, 6.0, 6.0);
                gc.fillOval(pt2.getX() - 3.0, pt2.getY() - 3.0, 6.0, 6.0);
                gc.fillOval(pt3.getX() - 3.0, pt3.getY() - 3.0, 6.0, 6.0);
                gc.fillOval(pt4.getX() - 3.0, pt4.getY() - 3.0, 6.0, 6.0);
            }
            double diffx = Math.cos(Math.toRadians(selectedf.getRotate())) * w / 2.0;
            double diffy = Math.sin(Math.toRadians(selectedf.getRotate())) * w / 2.0;
            gc.setStroke((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.5));
            gc.setLineWidth(1.0);
            gc.moveTo(pt.getX(), pt.getY());
            gc.lineTo(pt.getX() + diffx, pt.getY() + diffy);
            gc.fillOval(pt.getX() + diffx - 3.0, pt.getY() + diffy - 3.0, 6.0, 6.0);
            if (selectedf.getScale() >= 0.0) {
                gc.strokeOval(pt1.getX() - 3.0, pt1.getY() - 3.0, 6.0, 6.0);
                gc.strokeOval(pt2.getX() - 3.0, pt2.getY() - 3.0, 6.0, 6.0);
                gc.strokeOval(pt3.getX() - 3.0, pt3.getY() - 3.0, 6.0, 6.0);
                gc.strokeOval(pt4.getX() - 3.0, pt4.getY() - 3.0, 6.0, 6.0);
            }
            gc.strokeOval(pt.getX() + diffx - 3.0, pt.getY() + diffy - 3.0, 6.0, 6.0);
        }

        private void drawSelectionControlPoints(GraphicsContext gc, List<Point2D> points, boolean rotateOnly) {
            int start;
            int n = start = rotateOnly ? 4 : 0;
            if (points == null) {
                return;
            }
            for (int i = start; i < points.size(); ++i) {
                Point2D pt = points.get(i);
                gc.setFill((Paint)new javafx.scene.paint.Color(1.0, 0.0, 0.0, 0.5));
                gc.fillOval(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0);
                gc.setStroke((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.5));
                gc.setLineWidth(1.0);
                gc.strokeOval(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0);
            }
        }

        private void paintOverviewBox(Graphics gc, double hexWidth, double hexHeight) {
            Color c = new Color(0, 255, 0, 80);
            gc.setColor(c);
            Point2D pt = new Point2D(MapUI.this.hScrollBar.getValue() * hexWidth / 300.0, MapUI.this.vScrollBar.getValue() * hexHeight / 300.0);
            gc.fillRect((int)pt.getX(), (int)pt.getY(), (int)(MapUI.this.canvas.getWidth() * hexWidth / MapUI.this.mapData.getTileWidth()), (int)(MapUI.this.canvas.getHeight() * hexHeight / MapUI.this.mapData.getTileHeight()));
            gc.setColor(Color.YELLOW);
            gc.drawRect((int)pt.getX() - 1, (int)pt.getY() - 1, (int)(MapUI.this.canvas.getWidth() * hexWidth / MapUI.this.mapData.getTileWidth()) + 1, (int)(MapUI.this.canvas.getHeight() * hexHeight / MapUI.this.mapData.getTileHeight()) + 1);
        }

        private void drawFeatures(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, Collection<Feature> layerfeatures, Rectangle windowbounds) {
            if (layerfeatures == null || layerfeatures.size() == 0) {
                return;
            }
            for (Feature f : layerfeatures) {
                Point2D floc;
                if (MapUI.this.viewLevel == ViewLevel.WORLD && !f.isWorld() || MapUI.this.viewLevel == ViewLevel.CONTINENT && !f.isContinent() || MapUI.this.viewLevel == ViewLevel.KINGDOM && !f.isKingdom() || (floc = f.getLocation(MapUI.this.viewLevel)) == null) continue;
                double fw = f.getScaleFallbackType() * 3.0;
                double fth = f.getScaleHtFallbackType();
                if (fth <= 0.0) {
                    fth = f.getScaleFallbackType();
                }
                double fh = fth * 3.0;
                BoundingBox flocrect = new BoundingBox(floc.getX() - fw, floc.getY() - fh, fw * 2.0, fh * 2.0);
                if (!windowbounds.intersects((Bounds)flocrect)) {
                    Text text;
                    if (f.getLabel() == null || "".equals(f.getLabel().getText()) || !MapUI.this.mapData.getShow().isFeatureLabels()) continue;
                    Point2D modelpt = f.getLocation(MapUI.this.viewLevel);
                    if (modelpt == null) {
                        return;
                    }
                    MapLabel label = f.getLabel();
                    gc.setFont(label.getFont(MapUI.this.mapData, hexHeight, MapUI.this.viewLevel, 1.0, 1.0));
                    if (label.getLocation() == null || label.getLocation().size() == 0) {
                        label.setLocationAndScale(MapUI.this.viewLevel, new Point2D(modelpt.getX(), modelpt.getY() + (double)f.getLabelDistance() / 100.0 * 300.0 + gc.getFont().getSize() / 2.0 * 300.0 / hexHeight), label.getScale(MapUI.this.viewLevel));
                    }
                    if ((text = label.getTextObjectQuick(MapUI.this.mapData, MapUI.this.viewLevel, label.getLocation(MapUI.this.viewLevel).getX(), label.getLocation(MapUI.this.viewLevel).getY(), hexHeight, MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), true)) == null) continue;
                    Bounds bounds = text.getBoundsInLocal();
                    double x = bounds.getMinX() + bounds.getWidth() / 2.0 * 300.0 / hexWidth;
                    double y = bounds.getMinY() + bounds.getHeight() / 2.0 * 300.0 / hexHeight;
                    double maxwh = Math.max(bounds.getWidth() * 300.0, bounds.getHeight() * 300.0);
                    if (!windowbounds.intersects(x - maxwh / 2.0, y - maxwh / 2.0, maxwh, maxwh)) continue;
                }
                if (f.isGmOnly() && !MapUI.this.mapData.getShow().isGMOnly()) continue;
                if (!f.getTags().equals("")) {
                    if (!MapUI.this.showTags.equals("")) {
                        String[] showTagArray = MapUI.this.showTags.split(";");
                        boolean found = MapUI.this.doesObjectMatchTags(f.getTags(), showTagArray);
                        if (!found) continue;
                    }
                    if (!MapUI.this.hideTags.equals("")) {
                        String[] hideTagArray = MapUI.this.hideTags.split(";");
                        boolean found = MapUI.this.doesObjectMatchTags(f.getTags(), hideTagArray);
                        if (found) continue;
                    }
                }
                Point2D tilecenterpt = null;
                if (f.isFillHexBottom()) {
                    Pair<Integer, Integer> tilecoord = MapUI.this.mapData.getTerrainFromModelPt(floc.getX(), floc.getY());
                    tilecenterpt = this.calculateTerrainPointXY((Integer)tilecoord.getKey(), (Integer)tilecoord.getValue(), offseth, offsetv, hexWidth, hexHeight);
                    tilecenterpt = tilecenterpt.add(hexWidth / 2.0, hexHeight / 2.0);
                }
                f.paint(gc, MapUI.this.mapData, hexWidth, hexHeight, offseth, offsetv, MapUI.this.mapData.getTileOrientation(), MapUI.this.viewLevel, MapUI.this.mapData.getShow().isGMOnlyGlow(), MapUI.this.mapData.getShow().isFeatureLabels(), MapUI.this.useAlternateIcons, tilecenterpt);
            }
        }

        private void drawLabels(GraphicsContext gc, MapData md, double offseth, double offsetv, double hexHeight, double hexWidth, List<MapLabel> labels, Rectangle windowbounds) {
            if (labels == null) {
                return;
            }
            for (MapLabel ml : labels) {
                Text text;
                if (ml.getLocation(MapUI.this.viewLevel) == null || MapUI.this.getViewLevel() == ViewLevel.WORLD && !ml.isWorld() || MapUI.this.getViewLevel() == ViewLevel.CONTINENT && !ml.isContinent() || MapUI.this.getViewLevel() == ViewLevel.KINGDOM && !ml.isKingdom() || (text = ml.getTextObjectQuick(md, MapUI.this.viewLevel, ml.getLocation(MapUI.this.viewLevel).getX(), ml.getLocation(MapUI.this.viewLevel).getY(), hexHeight, MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), true)) == null) continue;
                Bounds bounds = text.getBoundsInLocal();
                double x = bounds.getMinX() + bounds.getWidth() / 2.0 * 300.0 / hexWidth;
                double y = bounds.getMinY() + bounds.getHeight() / 2.0 * 300.0 / hexHeight;
                double maxwh = Math.max(bounds.getWidth() * 300.0, bounds.getHeight() * 300.0);
                if (!windowbounds.intersects(x - maxwh / 2.0, y - maxwh / 2.0, maxwh, maxwh) || ml.isGmOnly() && !MapUI.this.mapData.getShow().isGMOnly()) continue;
                if (!ml.getTags().equals("")) {
                    boolean found;
                    if (!MapUI.this.showTags.equals("")) {
                        String[] showTagArray = MapUI.this.showTags.split(";");
                        found = MapUI.this.doesObjectMatchTags(ml.getTags(), showTagArray);
                        if (!found) continue;
                    }
                    if (!MapUI.this.hideTags.equals("")) {
                        String[] hideTagArray = MapUI.this.hideTags.split(";");
                        found = MapUI.this.doesObjectMatchTags(ml.getTags(), hideTagArray);
                        if (found) continue;
                    }
                }
                ml.paint(gc, md, hexWidth, hexHeight, offseth, offsetv, MapUI.this.viewLevel, MapUI.this.mapData.getTileOrientation(), MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), MapUI.this.mapData.getShow().isGMOnlyGlow());
            }
        }

        private Rectangle getWindowOffsetBounds(double offseth, double offsetv, double hexHeight, double hexWidth) {
            double w = this.getWidth() * 300.0 / hexWidth;
            double h = this.getHeight() * 300.0 / hexHeight;
            offseth = offseth * 300.0 / hexWidth;
            offsetv = offsetv * 300.0 / hexHeight;
            return new Rectangle(offseth, offsetv, w, h);
        }

        private void drawShapeHelper(GraphicsContext gc, List<MapShape> shapes, double offseth, double offsetv, double hexHeight, double hexWidth, ViewLevel vl, Rectangle windowbounds, boolean expedited) {
            if (shapes == null || shapes.size() == 0) {
                return;
            }
            Paint origstroke = gc.getStroke();
            double origlinewidth = gc.getLineWidth();
            HashMap<String, WritableImage> imagecache = new HashMap<String, WritableImage>();
            int numskipped = 0;
            for (MapShape ms : shapes) {
                numskipped += this.drawShape(gc, offseth, offsetv, hexHeight, hexWidth, windowbounds, imagecache, ms, vl, expedited);
            }
            gc.setStroke(origstroke);
            gc.setLineWidth(origlinewidth);
            gc.setLineDashes(null);
        }

        private int drawShape(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, Rectangle windowbounds, Map<String, WritableImage> imagecache, MapShape ms, ViewLevel vl, boolean expedited) {
            if (vl == ViewLevel.WORLD && !ms.isWorld()) {
                ms.getShape(MapUI.this.mapData, vl);
                return 0;
            }
            if (vl == ViewLevel.CONTINENT && !ms.isContinent()) {
                ms.getShape(MapUI.this.mapData, vl);
                return 0;
            }
            if (vl == ViewLevel.KINGDOM && !ms.isKingdom()) {
                ms.getShape(MapUI.this.mapData, vl);
                return 0;
            }
            if (vl == ViewLevel.PROVINCE && !ms.isProvince()) {
                ms.getShape(MapUI.this.mapData, vl);
                return 0;
            }
            if (!(ms.getShape(MapUI.this.mapData, vl) == null || windowbounds.intersects(ms.getShape(MapUI.this.mapData, vl).getBoundsInLocal()) || expedited || ms.getShape() instanceof Path && ((Path)ms.getShape()).getElements().size() == 1)) {
                ms.getShape(MapUI.this.mapData, vl);
                return 1;
            }
            if (!ms.getTags().equals("")) {
                boolean found;
                if (!MapUI.this.showTags.equals("")) {
                    String[] showTagArray = MapUI.this.showTags.split(";");
                    found = MapUI.this.doesObjectMatchTags(ms.getTags(), showTagArray);
                    if (!found) {
                        return 0;
                    }
                }
                if (!MapUI.this.hideTags.equals("")) {
                    String[] hideTagArray = MapUI.this.hideTags.split(";");
                    found = MapUI.this.doesObjectMatchTags(ms.getTags(), hideTagArray);
                    if (found) {
                        return 0;
                    }
                }
            }
            if (!ms.isGmOnly() || MapUI.this.mapData.getShow().isGMOnly()) {
                ImageView imageView;
                double h;
                double w;
                Shape s = ms.getShape(MapUI.this.mapData, vl);
                if (s == null) {
                    return 0;
                }
                Paint stroke = s.getStroke();
                if (stroke instanceof ImagePattern && ms.getStrokeTexture() != null) {
                    if (MapUI.this.useAlternateIcons && vl == ViewLevel.BATTLEMAT) {
                        javafx.scene.paint.Color c = this.textureColors.get(ms.getStrokeTexture().getType());
                        if (c == null) {
                            Image im = ((ImagePattern)stroke).getImage();
                            double red = 0.0;
                            double green = 0.0;
                            double blue = 0.0;
                            double opacity = 0.0;
                            for (int i = 0; i < 8; ++i) {
                                javafx.scene.paint.Color cx = im.getPixelReader().getColor((int)(Math.random() * im.getWidth()), (int)(Math.random() * im.getHeight()));
                                red += cx.getRed();
                                green += cx.getGreen();
                                blue += cx.getBlue();
                                opacity += cx.getOpacity();
                            }
                            c = new javafx.scene.paint.Color(red / 8.0, green / 8.0, blue / 8.0, opacity / 8.0);
                            this.textureColors.put(ms.getStrokeTexture().getType(), c);
                        }
                        gc.setStroke((Paint)c);
                    } else {
                        WritableImage croppedImage = imagecache.get(ms.getStrokeTexture().getType());
                        int texturew = ms.getStrokeTexture().getWidth();
                        w = (double)texturew * MapUI.this.mapData.getTileWidth() / 300.0;
                        h = (double)texturew * MapUI.this.mapData.getTileWidth() / 300.0;
                        if (w - (double)((int)w) <= 0.5) {
                            w += 0.5;
                        }
                        if (h - (double)((int)h) <= 0.5) {
                            h += 0.5;
                        }
                        if (croppedImage == null) {
                            Image i = ((ImagePattern)stroke).getImage();
                            imageView = new ImageView(i);
                            imageView.setFitWidth(w);
                            imageView.setFitHeight(h);
                            imageView.setSmooth(true);
                            croppedImage = imageView.snapshot(null, null);
                            imagecache.put(ms.getStrokeTexture().getType(), croppedImage);
                        }
                        if (croppedImage != null) {
                            gc.setStroke((Paint)new ImagePattern((Image)croppedImage, w - offseth % w, h - offsetv % h, w, h, false));
                        } else {
                            gc.setStroke((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0));
                        }
                    }
                } else if (stroke instanceof ImagePattern) {
                    gc.setStroke((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0));
                } else {
                    gc.setStroke(Objects.requireNonNullElseGet(stroke, () -> new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0)));
                }
                Paint fill = s.getFill();
                if (fill instanceof ImagePattern && ms.getFillTexture() != null) {
                    if (MapUI.this.useAlternateIcons && vl == ViewLevel.BATTLEMAT) {
                        javafx.scene.paint.Color c = this.textureColors.get(ms.getFillTexture().getType());
                        if (c == null) {
                            Image im = ((ImagePattern)fill).getImage();
                            double red = 0.0;
                            double green = 0.0;
                            double blue = 0.0;
                            double opacity = 0.0;
                            for (int i = 0; i < 8; ++i) {
                                javafx.scene.paint.Color cx = im.getPixelReader().getColor((int)(Math.random() * im.getWidth()), (int)(Math.random() * im.getHeight()));
                                red += cx.getRed();
                                green += cx.getGreen();
                                blue += cx.getBlue();
                                opacity += cx.getOpacity();
                            }
                            c = new javafx.scene.paint.Color(red / 8.0, green / 8.0, blue / 8.0, opacity / 8.0);
                            this.textureColors.put(ms.getFillTexture().getType(), c);
                        }
                        gc.setFill((Paint)c);
                    } else {
                        WritableImage croppedImage = imagecache.get(ms.getFillTexture().getType());
                        w = (double)ms.getFillTexture().getWidth() * MapUI.this.mapData.getTileWidth() / 300.0;
                        h = (double)ms.getFillTexture().getWidth() * MapUI.this.mapData.getTileWidth() / 300.0;
                        if (w - (double)((int)w) <= 0.5) {
                            w += 0.5;
                        }
                        if (h - (double)((int)h) <= 0.5) {
                            h += 0.5;
                        }
                        if (croppedImage == null) {
                            Image i = ((ImagePattern)fill).getImage();
                            imageView = new ImageView(i);
                            imageView.setFitWidth((double)((int)w));
                            imageView.setFitHeight((double)((int)h));
                            imageView.setSmooth(true);
                            croppedImage = imageView.snapshot(null, null);
                            imagecache.put(ms.getFillTexture().getType(), croppedImage);
                        }
                        if (croppedImage != null) {
                            gc.setFill((Paint)new ImagePattern((Image)croppedImage, w - offseth % w, h - offsetv % h, w, h, false));
                        } else {
                            gc.setFill((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0));
                        }
                    }
                } else if (fill instanceof ImagePattern) {
                    gc.setFill((Paint)new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0));
                } else {
                    gc.setFill(Objects.requireNonNullElseGet(fill, () -> new javafx.scene.paint.Color(0.0, 0.0, 0.0, 0.0)));
                }
                if (ms.getStrokeType() == MapShape.StrokeType.DASHED) {
                    gc.setLineDashes(new double[]{s.getStrokeWidth() * MapUI.this.mapData.getTileWidth() * 2.0, s.getStrokeWidth() * MapUI.this.mapData.getTileWidth() * 2.0});
                } else if (ms.getStrokeType() == MapShape.StrokeType.DOTTED) {
                    gc.setLineDashes(new double[]{0.0, s.getStrokeWidth() * MapUI.this.mapData.getTileWidth() * 2.0});
                } else {
                    gc.setLineDashes(null);
                }
                gc.setLineCap(s.getStrokeLineCap());
                gc.setLineJoin(s.getStrokeLineJoin());
                double strokewidth = s.getStrokeWidth() * hexWidth;
                if (expedited && strokewidth > 1.0) {
                    strokewidth = 1.0;
                }
                gc.setLineWidth(strokewidth);
                if (MapUI.this.mapData.getShow().isShadows() && ms.isDropShadow() && ms.getDsColor() != null) {
                    DropShadow ds = new DropShadow();
                    ds.setSpread(ms.getDsSpread());
                    ds.setRadius(ms.getDsRadius() * MapUI.this.mapData.getTileWidth() / 300.0);
                    ds.setColor(ms.getDsColor());
                    ds.setOffsetX(ms.getDsOffsetX() * MapUI.this.mapData.getTileWidth() / 300.0);
                    ds.setOffsetY(ms.getDsOffsetY() * MapUI.this.mapData.getTileHeight() / 300.0);
                    gc.setEffect((Effect)ds);
                }
                if (MapUI.this.mapData.getShow().isShadows() && ms.isInnerShadow() && ms.getInsColor() != null) {
                    InnerShadow is = new InnerShadow();
                    is.setOffsetX(ms.getInsOffsetX() * MapUI.this.mapData.getTileWidth() / 300.0);
                    is.setOffsetY(ms.getInsOffsetY() * MapUI.this.mapData.getTileHeight() / 300.0);
                    if (gc.getEffect(null) != null) {
                        is.setInput(gc.getEffect(null));
                    }
                    is.setColor(ms.getInsColor());
                    is.setChoke(ms.getInsChoke());
                    is.setRadius(ms.getInsRadius() * MapUI.this.mapData.getTileWidth() / 300.0);
                    gc.setEffect((Effect)is);
                }
                if (MapUI.this.mapData.getShow().isShadows() && ms.isBoxBlur()) {
                    BoxBlur bb = new BoxBlur();
                    if (gc.getEffect(null) != null) {
                        bb.setInput(gc.getEffect(null));
                    }
                    bb.setHeight(ms.getBbHeight() * MapUI.this.mapData.getTileHeight() / 300.0);
                    bb.setWidth(ms.getBbWidth() * MapUI.this.mapData.getTileWidth() / 300.0);
                    bb.setIterations(ms.getBbIterations());
                    gc.setEffect((Effect)bb);
                }
                if (MapUI.this.mapData.getShow().isGMOnlyGlow() && ms.isGmOnly()) {
                    DropShadow ds = new DropShadow();
                    ds.setSpread(2.0);
                    ds.setRadius(2.0);
                    ds.setColor(new javafx.scene.paint.Color(1.0, 0.0, 0.0, 0.5));
                    ds.setOffsetX(0.0);
                    ds.setOffsetY(0.0);
                    gc.setEffect((Effect)ds);
                }
                if (s instanceof Polygon) {
                    Polygon p = (Polygon)s;
                    this.drawPolygon(gc, offseth, offsetv, hexHeight, hexWidth, ms, p);
                } else if (s instanceof Arc) {
                    Arc a = (Arc)s;
                    alpha = gc.getGlobalAlpha();
                    if (a.getOpacity() != 1.0) {
                        gc.setGlobalAlpha(this.calculateAlpha(ms.getMapLayer(), a.getOpacity()));
                    }
                    Point2D centerPt = MapUI.getScreenCoordsFromModelCoords(a.getCenterX(), a.getCenterY(), offseth, offsetv, hexWidth, hexHeight);
                    Point2D radius = MapUI.getScreenCoordsFromModelCoords(a.getRadiusX(), a.getRadiusY(), 0.0, 0.0, hexWidth, hexHeight);
                    if (s.getFill() != null) {
                        gc.fillArc(centerPt.getX() - radius.getX(), centerPt.getY() - radius.getY(), radius.getX() * 2.0, radius.getY() * 2.0, a.getStartAngle(), a.getLength(), a.getType());
                    }
                    if (s.getStrokeWidth() != 0.0) {
                        gc.strokeArc(centerPt.getX() - radius.getX(), centerPt.getY() - radius.getY(), radius.getX() * 2.0, radius.getY() * 2.0, a.getStartAngle(), a.getLength(), a.getType());
                    }
                    gc.setEffect(null);
                    gc.setGlobalAlpha(alpha);
                } else if (s instanceof Path) {
                    Path p = (Path)s;
                    alpha = gc.getGlobalAlpha();
                    if (p.getOpacity() != 1.0) {
                        gc.setGlobalAlpha(this.calculateAlpha(ms.getMapLayer(), p.getOpacity()));
                    }
                    this.drawPath(gc, offseth, offsetv, hexHeight, hexWidth, ms, p);
                    gc.stroke();
                    if (ms.getStrokeType() == MapShape.StrokeType.CROSS_HATCH || ms.getStrokeType() == MapShape.StrokeType.RAILROAD || ms.getStrokeType() == MapShape.StrokeType.ELEVATION || ms.getStrokeType() == MapShape.StrokeType.ELEV_INVERTED) {
                        gc.setLineWidth(ms.getExtraLineWidth() / 100.0 * hexWidth);
                        this.drawPathExtraLines(gc, offseth, offsetv, hexHeight, hexWidth, ms, p);
                        gc.stroke();
                    }
                    gc.fill();
                    gc.setEffect(null);
                    gc.setGlobalAlpha(alpha);
                }
                if (ms.getStrokeType() == MapShape.StrokeType.COAST) {
                    gc.setEffect(null);
                    double[] pts = new double[ms.getShapePoints().size() * 2];
                    int count = 0;
                    for (Point2D pt : ms.getShapePoints()) {
                        pts[count] = pt.getX();
                        pts[++count] = pt.getY();
                        ++count;
                    }
                    Polygon poly = new Polygon(pts);
                    poly.setStrokeWidth(0.0);
                    this.drawPolygon(gc, offseth, offsetv, hexHeight, hexWidth, ms, poly);
                }
                if (expedited) {
                    return 0;
                }
                if (MapUI.this.getCurrentObjects().contains(ms) || MapUI.this.getCurrentObjects().size() == 0 && ShapesToolbox.shapesSelectButton != null && ShapesToolbox.shapesSelectButton.isSelected()) {
                    List<Point2D> pts = ms.getShapePoints();
                    boolean isCurve = false;
                    if (ms.getShape() instanceof Path) {
                        for (int i = 0; i < Math.min(5, ((Path)ms.getShape()).getElements().size()); ++i) {
                            PathElement pe = (PathElement)((Path)ms.getShape()).getElements().get(i);
                            if (!(pe instanceof CubicCurveTo)) continue;
                            isCurve = true;
                            break;
                        }
                    }
                    if (MapUI.this.curveTo1 != null) {
                        pts.add(MapUI.this.curveTo1);
                    }
                    if (MapUI.this.curveTo2 != null) {
                        pts.add(MapUI.this.curveTo2);
                    }
                    for (int i = 0; i < pts.size(); ++i) {
                        Point2D modelPt = pts.get(i);
                        Point2D pt = MapUI.getScreenCoordsFromModelCoords(modelPt.getX(), modelPt.getY(), offseth, offsetv, hexWidth, hexHeight);
                        if (MapUI.this.getCurrentObjects().size() == 0 && ShapesToolbox.shapesSelectButton != null && ShapesToolbox.shapesSelectButton.isSelected()) {
                            gc.setFill((Paint)javafx.scene.paint.Color.LIGHTCYAN);
                            gc.fillOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                            gc.setStroke((Paint)javafx.scene.paint.Color.GRAY);
                            gc.setLineWidth(1.0);
                            gc.strokeOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                            continue;
                        }
                        if (i == 0) {
                            gc.setFill((Paint)javafx.scene.paint.Color.GREEN);
                            gc.fillOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                            continue;
                        }
                        if (i == pts.size() - 1 && !isCurve || isCurve && pts.size() % 3 == 1 && i == pts.size() - 3) {
                            gc.setFill((Paint)javafx.scene.paint.Color.RED);
                            gc.fillOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                            continue;
                        }
                        if (isCurve && (i % 3 == 0 || i % 3 == 2)) {
                            gc.setFill((Paint)javafx.scene.paint.Color.YELLOW);
                            gc.fillOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                            continue;
                        }
                        gc.setFill((Paint)javafx.scene.paint.Color.AQUA);
                        gc.fillOval(pt.getX() - 2.0, pt.getY() - 2.0, 5.0, 5.0);
                    }
                }
            }
            return 0;
        }

        private void drawPolygon(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, MapShape ms, Polygon p) {
            double[] xs = new double[p.getPoints().size() / 2];
            double[] ys = new double[p.getPoints().size() / 2];
            for (int i = 0; i < p.getPoints().size() - 1; i += 2) {
                double x = (Double)p.getPoints().get(i);
                double y = (Double)p.getPoints().get(i + 1);
                Point2D pt = MapUI.getScreenCoordsFromModelCoords(x, y, offseth, offsetv, hexWidth, hexHeight);
                xs[i / 2] = pt.getX();
                ys[i / 2] = pt.getY();
            }
            double alpha = gc.getGlobalAlpha();
            if (p.getOpacity() != 1.0) {
                gc.setGlobalAlpha(this.calculateAlpha(ms.getMapLayer(), p.getOpacity()));
            }
            if (p.getFill() != null) {
                gc.fillPolygon(xs, ys, xs.length);
            }
            if (ms.isGradientEdge() && MapUI.this.mapData.getShow().isShadows()) {
                double origstrokewidth = p.getStrokeWidth();
                double sw = origstrokewidth * hexWidth * 2.0;
                int numLoops = (int)(sw / 4.0);
                for (double i = 1.0; i < (double)numLoops; i += 1.0) {
                    gc.setGlobalAlpha(this.calculateAlpha(ms.getMapLayer(), (1.0 - i / (double)numLoops) / 4.0));
                    gc.setLineWidth(sw * i / (double)numLoops);
                    gc.strokePolygon(xs, ys, xs.length);
                }
                p.setStrokeWidth(origstrokewidth);
            } else if (p.getStrokeWidth() > 0.0) {
                gc.strokePolygon(xs, ys, xs.length);
            }
            gc.setGlobalAlpha(alpha);
            gc.setEffect(null);
        }

        private void drawPath(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, MapShape ms, Path p) {
            if (ms.getStrokeType() == MapShape.StrokeType.COAST) {
                gc.setFill(null);
            }
            gc.beginPath();
            Point2D prevpt = null;
            double distancesincelasthash = 0.0;
            double railwidthoffset = hexWidth / 100.0 * ms.getExtraLineSeparation();
            for (int i = 0; i < p.getElements().size(); ++i) {
                Point2D pt;
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    pt = MapUI.getScreenCoordsFromModelCoords(mt.getX(), mt.getY(), offseth, offsetv, hexWidth, hexHeight);
                    gc.moveTo(pt.getX(), pt.getY());
                    prevpt = pt;
                    continue;
                }
                if (pe instanceof ClosePath) {
                    gc.closePath();
                    continue;
                }
                if (pe instanceof LineTo) {
                    LineTo lt = (LineTo)pe;
                    pt = MapUI.getScreenCoordsFromModelCoords(lt.getX(), lt.getY(), offseth, offsetv, hexWidth, hexHeight);
                    if (ms.getStrokeType() != MapShape.StrokeType.RAILROAD) {
                        gc.lineTo(pt.getX(), pt.getY());
                    }
                    if (prevpt != null && ms.getStrokeType() == MapShape.StrokeType.ELEVATION || ms.getStrokeType() == MapShape.StrokeType.ELEV_INVERTED) {
                        prevpt = pt;
                    }
                    if (ms.getStrokeType() != MapShape.StrokeType.RAILROAD) continue;
                    Point2D ptb = new Point2D(prevpt.getX(), prevpt.getY());
                    double distance = ptb.distance(pt);
                    double slopex = pt.getX() - ptb.getX();
                    double slopey = pt.getY() - ptb.getY();
                    double hypotlength = Math.sqrt(slopex * slopex + slopey * slopey);
                    gc.moveTo(ptb.getX() - slopey * railwidthoffset / hypotlength, ptb.getY() + slopex * railwidthoffset / hypotlength);
                    gc.lineTo(pt.getX() - slopey * railwidthoffset / hypotlength, pt.getY() + slopex * railwidthoffset / hypotlength);
                    gc.moveTo(ptb.getX() + slopey * railwidthoffset / hypotlength, ptb.getY() - slopex * railwidthoffset / hypotlength);
                    gc.lineTo(pt.getX() + slopey * railwidthoffset / hypotlength, pt.getY() - slopex * railwidthoffset / hypotlength);
                    distancesincelasthash += distance;
                    prevpt = pt;
                    continue;
                }
                if (!(pe instanceof CubicCurveTo)) continue;
                CubicCurveTo cubicTo = (CubicCurveTo)pe;
                Point2D c1pt = MapUI.getScreenCoordsFromModelCoords(cubicTo.getControlX1(), cubicTo.getControlY1(), offseth, offsetv, hexWidth, hexHeight);
                Point2D c2pt = MapUI.getScreenCoordsFromModelCoords(cubicTo.getControlX2(), cubicTo.getControlY2(), offseth, offsetv, hexWidth, hexHeight);
                Point2D pt2 = MapUI.getScreenCoordsFromModelCoords(cubicTo.getX(), cubicTo.getY(), offseth, offsetv, hexWidth, hexHeight);
                gc.bezierCurveTo(c1pt.getX(), c1pt.getY(), c2pt.getX(), c2pt.getY(), pt2.getX(), pt2.getY());
            }
        }

        private void drawPathExtraLines(GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, MapShape ms, Path p) {
            double extraLineWidth;
            double elevationLength;
            gc.beginPath();
            Point2D prevpt = null;
            double distancesincelasthash = 0.0;
            double threshold = ms.getExtraLineDistance() / 100.0 * hexWidth;
            if (threshold == 0.0) {
                threshold = hexWidth / 6.0;
            }
            if ((elevationLength = ms.getExtraLineLength() / 100.0 * hexWidth) == 0.0) {
                elevationLength = hexWidth / 8.0;
            }
            if ((extraLineWidth = ms.getExtraLineWidth() / 100.0 * hexWidth) == 0.0) {
                extraLineWidth = gc.getLineWidth();
            }
            for (int i = 0; i < p.getElements().size(); ++i) {
                Point2D pt;
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    pt = MapUI.getScreenCoordsFromModelCoords(mt.getX(), mt.getY(), offseth, offsetv, hexWidth, hexHeight);
                    gc.moveTo(pt.getX(), pt.getY());
                    prevpt = pt;
                    continue;
                }
                if (pe instanceof ClosePath) {
                    gc.closePath();
                    continue;
                }
                if (pe instanceof LineTo) {
                    double slopey;
                    double slopex;
                    Point2D ptb;
                    LineTo lt = (LineTo)pe;
                    pt = MapUI.getScreenCoordsFromModelCoords(lt.getX(), lt.getY(), offseth, offsetv, hexWidth, hexHeight);
                    if (ms.getStrokeType() == MapShape.StrokeType.CROSS_HATCH) {
                        ptb = new Point2D(prevpt.getX(), prevpt.getY());
                        Object ptCrossHatchDestination = null;
                        double distance = ptb.distance(pt);
                        int crossCount = 0;
                        double crossHatchDistanceX = 0.0;
                        double crossHatchDistanceY = 0.0;
                        double crossHatchDistanceFactor = Math.random() * 0.5 + 0.25;
                        Random r = new Random((int)ptb.getX() + (int)ptb.getY());
                        while (distance + distancesincelasthash >= threshold) {
                            double slopex2 = pt.getX() - ptb.getX();
                            double slopey2 = pt.getY() - ptb.getY();
                            double proportion = (threshold - distancesincelasthash) / distance;
                            double intersectx = slopex2 * proportion;
                            double intersecty = slopey2 * proportion;
                            double hypotlength = Math.sqrt(slopex2 * slopex2 + slopey2 * slopey2);
                            ptb = new Point2D(ptb.getX() + intersectx, ptb.getY() + intersecty);
                            if (crossCount % 3 == 0) {
                                crossHatchDistanceFactor = r.nextDouble() - 0.5 + 0.15;
                            }
                            ++crossCount;
                            crossHatchDistanceX = ptb.getX() + intersectx * crossHatchDistanceFactor;
                            crossHatchDistanceY = ptb.getY() + intersecty * crossHatchDistanceFactor;
                            gc.setLineWidth(extraLineWidth);
                            gc.moveTo(ptb.getX(), ptb.getY());
                            if (ms.getStrokeType() == MapShape.StrokeType.CROSS_HATCH) {
                                gc.lineTo(crossHatchDistanceX - slopey2 * elevationLength / hypotlength, crossHatchDistanceY + slopex2 * elevationLength / hypotlength);
                            } else {
                                gc.lineTo(crossHatchDistanceX + slopey2 * elevationLength / hypotlength, crossHatchDistanceY - slopex2 * elevationLength / hypotlength);
                            }
                            gc.moveTo(pt.getX(), pt.getY());
                            distancesincelasthash = 0.0;
                            distance = ptb.distance(pt);
                        }
                        distancesincelasthash += distance;
                        prevpt = pt;
                    }
                    if (prevpt != null && ms.getStrokeType() == MapShape.StrokeType.ELEVATION || ms.getStrokeType() == MapShape.StrokeType.ELEV_INVERTED) {
                        ptb = new Point2D(prevpt.getX(), prevpt.getY());
                        double distance = ptb.distance(pt);
                        while (distance + distancesincelasthash >= threshold) {
                            slopex = pt.getX() - ptb.getX();
                            slopey = pt.getY() - ptb.getY();
                            double proportion = (threshold - distancesincelasthash) / distance;
                            double intersectx = slopex * proportion;
                            double intersecty = slopey * proportion;
                            double hypotlength = Math.sqrt(slopex * slopex + slopey * slopey);
                            ptb = new Point2D(ptb.getX() + intersectx, ptb.getY() + intersecty);
                            gc.setLineWidth(extraLineWidth);
                            gc.moveTo(ptb.getX(), ptb.getY());
                            if (ms.getStrokeType() == MapShape.StrokeType.ELEVATION) {
                                gc.lineTo(ptb.getX() - slopey * elevationLength / hypotlength, ptb.getY() + slopex * elevationLength / hypotlength);
                            } else {
                                gc.lineTo(ptb.getX() + slopey * elevationLength / hypotlength, ptb.getY() - slopex * elevationLength / hypotlength);
                            }
                            gc.moveTo(pt.getX(), pt.getY());
                            distancesincelasthash = 0.0;
                            distance = ptb.distance(pt);
                        }
                        distancesincelasthash += distance;
                        prevpt = pt;
                    }
                    if (ms.getStrokeType() != MapShape.StrokeType.RAILROAD) continue;
                    ptb = new Point2D(prevpt.getX(), prevpt.getY());
                    double distance = ptb.distance(pt);
                    slopex = pt.getX() - ptb.getX();
                    slopey = pt.getY() - ptb.getY();
                    double hypotlength = Math.sqrt(slopex * slopex + slopey * slopey);
                    while (distance + distancesincelasthash >= threshold) {
                        slopex = pt.getX() - ptb.getX();
                        slopey = pt.getY() - ptb.getY();
                        hypotlength = Math.sqrt(slopex * slopex + slopey * slopey);
                        double proportion = (threshold - distancesincelasthash) / distance;
                        double intersectx = slopex * proportion;
                        double intersecty = slopey * proportion;
                        ptb = new Point2D(ptb.getX() + intersectx, ptb.getY() + intersecty);
                        gc.moveTo(ptb.getX() - slopey * elevationLength / hypotlength, ptb.getY() + slopex * elevationLength / hypotlength);
                        gc.lineTo(ptb.getX() + slopey * elevationLength / hypotlength, ptb.getY() - slopex * elevationLength / hypotlength);
                        gc.moveTo(pt.getX(), pt.getY());
                        distancesincelasthash = 0.0;
                        distance = ptb.distance(pt);
                    }
                    distancesincelasthash += distance;
                    prevpt = pt;
                    continue;
                }
                if (!(pe instanceof CubicCurveTo)) continue;
                CubicCurveTo cubicTo = (CubicCurveTo)pe;
                Point2D c1pt = MapUI.getScreenCoordsFromModelCoords(cubicTo.getControlX1(), cubicTo.getControlY1(), offseth, offsetv, hexWidth, hexHeight);
                Point2D c2pt = MapUI.getScreenCoordsFromModelCoords(cubicTo.getControlX2(), cubicTo.getControlY2(), offseth, offsetv, hexWidth, hexHeight);
                Point2D pt2 = MapUI.getScreenCoordsFromModelCoords(cubicTo.getX(), cubicTo.getY(), offseth, offsetv, hexWidth, hexHeight);
                gc.bezierCurveTo(c1pt.getX(), c1pt.getY(), c2pt.getX(), c2pt.getY(), pt2.getX(), pt2.getY());
            }
        }

        private Map<String, Integer> calculateTerrainDrawStartAndEnds(int hexx, int hexy, double offseth, double offsetv, double hexHeight, double hexWidth) {
            int yend;
            Terrain[][] t = MapUI.this.mapData.getTerrain(MapUI.this.viewLevel);
            int xstart = Math.max(hexx - 2, 0);
            int xend = hexx < 0 ? t.length : Math.min(hexx + 2, t.length);
            int ystart = Math.max(hexy - 2, 0);
            int n = yend = hexy < 0 ? t[0].length : Math.min(hexy + 2, t[0].length);
            if (xstart == 0 && ystart == 0) {
                Pair<Integer, Integer> start = MapUI.this.getTerrainFromModelPt(offseth * 300.0 / hexWidth, offsetv * 300.0 / hexHeight);
                xstart = Math.max((Integer)start.getKey() - 1, 0);
                ystart = Math.max((Integer)start.getValue() - 1, 0);
            }
            if (xend == t.length && yend == t[0].length) {
                Pair<Integer, Integer> end = MapUI.this.getTerrainFromModelPt((offseth + this.getWidth()) * 300.0 / hexWidth, (offsetv + this.getHeight()) * 300.0 / hexHeight);
                xend = Math.min((Integer)end.getKey() + 2, t.length);
                yend = Math.min((Integer)end.getValue() + 2, t[0].length);
            }
            HashMap<String, Integer> out = new HashMap<String, Integer>();
            out.put("xstart", xstart);
            out.put("xend", xend);
            out.put("ystart", ystart);
            out.put("yend", yend);
            return out;
        }

        public void setTerrainGMOnly(Shape polyselected, boolean gmonly) {
            double offseth = 0.0;
            double offsetv = 0.0;
            Terrain[][] t = MapUI.this.mapData.getTerrain(MapUI.this.viewLevel);
            double wpt75 = MapUI.this.mapData.getTileWidth() * 0.75;
            double hpt75 = MapUI.this.mapData.getTileHeight() * 0.75;
            polyselected.setStrokeWidth(1.0);
            polyselected.setStroke((Paint)javafx.scene.paint.Color.RED);
            polyselected.setFill((Paint)javafx.scene.paint.Color.RED);
            for (int y = 0; y < t[0].length; ++y) {
                for (int x = 0; x < t.length; ++x) {
                    if (t[x][y].getType() == null) continue;
                    Point2D pt = this.calculateTerrainPointXY(x, y, offseth, offsetv, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight());
                    Polygon terrainp = t[x][y].getPolygon(pt.getX(), pt.getY(), MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), wpt75, hpt75, MapUI.this.mapData.getTileOrientation());
                    terrainp.setFill((Paint)javafx.scene.paint.Color.RED);
                    terrainp.setStrokeWidth(1.0);
                    terrainp.setStroke((Paint)javafx.scene.paint.Color.RED);
                    Shape s = Shape.intersect((Shape)terrainp, (Shape)polyselected);
                    if (!(s instanceof Path) || ((Path)s).getElements().size() <= 0) continue;
                    t[x][y].setGmOnly(gmonly);
                    t[x][y].setTempGMOnly(gmonly);
                }
            }
        }

        private void drawTerrain(Map<String, Integer> startsandendsmap, GraphicsContext gc, double offseth, double offsetv, double hexHeight, double hexWidth, boolean paintterrain, boolean paintnumbers, boolean onlywater, boolean fill, Set<Pair<Integer, Integer>> hiddenterraincoords, boolean onlyGMOnly, ViewLevel vl) {
            Terrain.drawImageTime = 0L;
            Terrain.calcLocTime = 0L;
            Terrain.setupTime = 0L;
            Terrain.offsetTime = 0L;
            Terrain[][] t = MapUI.this.mapData.getTerrain(MapUI.this.viewLevel);
            int xstart = startsandendsmap.get("xstart");
            int xend = startsandendsmap.get("xend");
            int ystart = startsandendsmap.get("ystart");
            int yend = startsandendsmap.get("yend");
            Font prefont = gc.getFont();
            double fontsize = (double)MapUI.this.mapData.getNumbering().getFontSize() / 100.0 * MapUI.this.mapData.getTileHeight();
            if (paintnumbers) {
                FontWeight fw = FontWeight.NORMAL;
                if (MapUI.this.mapData.getNumbering().getFontStyle() == NumberingData.FontStyle.BOLD) {
                    fw = FontWeight.BOLD;
                }
                FontPosture fp = FontPosture.REGULAR;
                if (MapUI.this.mapData.getNumbering().getFontStyle() == NumberingData.FontStyle.ITALIC) {
                    fp = FontPosture.ITALIC;
                }
                Font f = Font.font((String)MapUI.this.mapData.getNumbering().getFontName(), (FontWeight)fw, (FontPosture)fp, (double)fontsize);
                gc.setTextAlign(TextAlignment.CENTER);
                gc.setFont(f);
            }
            gc.setLineWidth(MapUI.this.mapData.getGrid().getWidth()[0]);
            javafx.scene.paint.Color gridcolor = MapUI.this.mapData.getGrid().getColor()[0];
            double wpt75 = MapUI.this.mapData.getTileWidth() * 0.75;
            double hpt75 = MapUI.this.mapData.getTileHeight() * 0.75;
            long terraincopytime = 0L;
            long terraincopyfinishtime = 0L;
            long nearestneighborfilltime = 0L;
            long paintterrainandbordertime = 0L;
            long calcterrainpttime = 0L;
            long paintnumberstime = 0L;
            Terrain[][] terraincopy = null;
            for (double yVal = (double)ystart; yVal < (double)yend; yVal += 0.5) {
                int ynumber = (int)yVal + MapUI.this.mapData.getNumbering().getFirstRow();
                Object ystr = "";
                if (paintnumbers) {
                    if (ynumber > -10 && ynumber < 10 && (MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.DOUBLE_ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO)) {
                        ystr = "0";
                    }
                    if (ynumber > -100 && ynumber < 100 && (MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.DOUBLE_ZERO)) {
                        ystr = "0" + (String)ystr;
                    }
                    if (ynumber > -1000 && ynumber < 1000 && MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO) {
                        ystr = "0" + (String)ystr;
                    }
                    ystr = ynumber < 0 ? "-" + (String)ystr + Math.abs(ynumber) : (String)ystr + ynumber;
                }
                for (int x = xstart; x < xend; ++x) {
                    long time;
                    int y = (int)yVal;
                    if (x % 2 != 0 ? (double)y == yVal : (double)y != yVal) continue;
                    if (t[x][y] == null && vl == ViewLevel.PROVINCE) {
                        time = System.nanoTime();
                        int xcopystart = Math.max(0, xstart - MapUI.this.mapData.getView().getProvinceFactor() * 2);
                        int ycopystart = Math.max(0, ystart - MapUI.this.mapData.getView().getProvinceFactor() * 2);
                        int xcopyend = Math.min(t.length, xend + MapUI.this.mapData.getView().getProvinceFactor() * 2);
                        int ycopyend = Math.min(t[0].length, yend + MapUI.this.mapData.getView().getProvinceFactor() * 2);
                        if (terraincopy == null) {
                            MapUI.this.WLogger.addLogText("Generating Province: " + xcopystart + "," + ycopystart + ":" + xcopyend + "," + ycopyend, false);
                            terraincopy = new Terrain[xcopyend - xcopystart][ycopyend - ycopystart];
                            terraincopytime += System.nanoTime() - time;
                            time = System.nanoTime();
                            for (int xc = xcopystart; xc < xcopyend; ++xc) {
                                if (ycopyend - ycopystart < 0) continue;
                                System.arraycopy(t[xc], ycopystart, terraincopy[xc - xcopystart], 0, ycopyend - ycopystart);
                            }
                        }
                        terraincopyfinishtime += System.nanoTime() - time;
                        time = System.nanoTime();
                        ChildMapTask.runNearestNeighborFillProvinceSingle(MapUI.this.mapData, t, x, y, MapUI.this.mapData.getView().getProvinceFactor(), MapUI.this.addRandomness);
                        nearestneighborfilltime += System.nanoTime() - time;
                    }
                    if (t[x][y] == null || t[x][y].getType() == null) continue;
                    time = System.nanoTime();
                    Point2D pt = this.calculateTerrainPointXY(x, y, offseth, offsetv, hexWidth, hexHeight);
                    if (onlyGMOnly) {
                        if (!t[x][y].isGmOnly()) continue;
                        t[x][y].paint(gc, pt.getX(), pt.getY(), hexWidth, hexHeight, wpt75, hpt75, gridcolor, MapUI.this.mapData.getTileOrientation(), false, false, fill, (Paint)javafx.scene.paint.Color.LIGHTGRAY, MapUI.this.isUseAlternateIcons() && MapUI.this.viewLevel == ViewLevel.BATTLEMAT);
                        continue;
                    }
                    calcterrainpttime += System.nanoTime() - time;
                    time = System.nanoTime();
                    if (paintnumbers) {
                        int xnumber = x + MapUI.this.mapData.getNumbering().getFirstColumn();
                        Object xstr = "";
                        if (xnumber > -10 && xnumber < 10 && (MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.DOUBLE_ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO)) {
                            xstr = "0";
                        }
                        if (xnumber > -100 && xnumber < 100 && (MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO || MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.DOUBLE_ZERO)) {
                            xstr = "0" + (String)xstr;
                        }
                        if (xnumber > -1000 && xnumber < 1000 && MapUI.this.mapData.getNumbering().getPrePadNums() == NumberingData.PrePadNums.TRIPLE_ZERO) {
                            xstr = "0" + (String)xstr;
                        }
                        xstr = xnumber < 0 ? "-" + (String)xstr + Math.abs(xnumber) : (String)xstr + xnumber;
                        String text = (String)xstr + MapUI.this.mapData.getNumbering().getSeparator() + (String)ystr;
                        if (MapUI.this.mapData.getNumbering().getOrder() == NumberingData.OrderNumbers.ROW_COL) {
                            text = (String)ystr + MapUI.this.mapData.getNumbering().getSeparator() + (String)xstr;
                        }
                        if (MapUI.this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                            double texty = (double)y * hexHeight * 3.0 / 4.0 - offsetv - hexHeight / 6.0;
                            if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.TOP) {
                                texty = (double)y * hexHeight * 3.0 / 4.0 - offsetv - hexHeight / 2.0 - fontsize + hexHeight / 7.0;
                            } else if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.MIDDLE) {
                                texty = (double)y * hexHeight * 3.0 / 4.0 - offsetv - hexHeight / 7.0 - hexHeight / 4.0;
                            }
                            t[x][y].paintText(gc, text, (double)x * hexWidth + (y % 2 == 0 ? 0.0 : hexWidth / 2.0) + hexWidth / 2.0 - offseth, texty, hexHeight, MapUI.this.mapData.getNumbering().getFontColor());
                        } else if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                            double baseH = (double)y * hexHeight + (x % 2 == 0 ? 0.0 : hexHeight / 2.0);
                            double texty = baseH - offsetv - 0.0 - hexHeight / 20.0;
                            if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.TOP) {
                                texty = baseH - offsetv - hexHeight / 2.0 - fontsize - hexHeight / 20.0;
                            }
                            if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.MIDDLE) {
                                texty = baseH - offsetv - fontsize - hexHeight / 5.0;
                            }
                            t[x][y].paintText(gc, text, (double)x * hexWidth * 3.0 / 4.0 - offseth + hexWidth / 2.0, texty, hexHeight, MapUI.this.mapData.getNumbering().getFontColor());
                        } else {
                            double texty = (double)y * hexHeight - offsetv - 0.0 - hexHeight / 20.0;
                            if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.TOP) {
                                texty = (double)y * hexHeight - offsetv - hexHeight / 2.0 - fontsize - hexHeight / 20.0;
                            }
                            if (MapUI.this.mapData.getNumbering().getPosition() == NumberingData.NumberPosition.MIDDLE) {
                                texty = (double)y * hexHeight - offsetv - fontsize - hexHeight / 5.0;
                            }
                            t[x][y].paintText(gc, text, (double)x * hexWidth - offseth + hexWidth / 2.0, texty, hexHeight, MapUI.this.mapData.getNumbering().getFontColor());
                        }
                    }
                    boolean iswater = t[x][y].getTypeName().contains("Water") || t[x][y].getTypeName().contains("Sea") || t[x][y].getTypeName().contains("Ocean");
                    paintnumberstime += System.nanoTime() - time;
                    if (onlywater && !iswater || !onlywater && iswater || t[x][y].isGmOnly() && !MapUI.this.mapData.getShow().isGMOnly()) continue;
                    time = System.nanoTime();
                    if (paintterrain) {
                        boolean painticon = hiddenterraincoords == null || !hiddenterraincoords.contains(new Pair((Object)x, (Object)y));
                        t[x][y].paint(gc, pt.getX(), pt.getY(), hexWidth, hexHeight, wpt75, hpt75, gridcolor, MapUI.this.mapData.getTileOrientation(), painticon, false, fill, null, MapUI.this.isUseAlternateIcons() && MapUI.this.viewLevel == ViewLevel.BATTLEMAT);
                    }
                    paintterrainandbordertime += System.nanoTime() - time;
                    if (MapUI.this.mapData.getShow().isGMOnly() && MapUI.this.mapData.getShow().isGMOnlyGlow() && t[x][y].isGmOnly()) {
                        t[x][y].paintBorder(gc, pt.getX(), pt.getY(), hexWidth, hexHeight, javafx.scene.paint.Color.RED, MapUI.this.mapData.getTileOrientation());
                    }
                    for (MapObject mo : MapUI.this.currentObjects) {
                        if (mo != t[x][y]) continue;
                        t[x][y].paintBorder(gc, pt.getX(), pt.getY(), hexWidth, hexHeight, javafx.scene.paint.Color.YELLOW, MapUI.this.mapData.getTileOrientation());
                    }
                }
            }
            gc.setFont(prefont);
        }

        public Point2D calculateTerrainPointXY(int x, int y, double offseth, double offsetv, double hexWidth, double hexHeight) {
            if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                return new Point2D((double)x * hexWidth * 3.0 / 4.0 - offseth, (double)y * hexHeight + (x % 2 == 0 ? 0.0 : hexHeight / 2.0) - offsetv);
            }
            if (MapUI.this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                return new Point2D((double)x * hexWidth + (y % 2 == 0 ? 0.0 : hexWidth / 2.0) - offseth, (double)y * hexHeight * 3.0 / 4.0 - offsetv);
            }
            return new Point2D((double)x * hexWidth - offseth, (double)y * hexHeight - offsetv);
        }

        private void drawTerrainExpress(ViewLevel vl, GraphicsContext gc, double hexHeight, double hexWidth, boolean paintwater, boolean paintland, Paint overrideFill) {
            double wpt75 = hexWidth * 0.75;
            double hpt75 = hexHeight * 0.75;
            double wpt5 = hexWidth * 0.5;
            double hpt5 = hexHeight * 0.5;
            Terrain[][] t = MapUI.this.mapData.getTerrain(vl);
            if (MapUI.this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                for (int y = 0; y < t[0].length; ++y) {
                    for (int x = 0; x < t.length; ++x) {
                        boolean showtile;
                        if (t[x][y] == null || t[x][y].getType() == null) continue;
                        boolean bl = showtile = !t[x][y].isGmOnly() || t[x][y].isGmOnly() && MapUI.this.mapData.getShow().isGMOnly();
                        if ((!paintwater || !t[x][y].getType().getType().toLowerCase().contains("water")) && (!paintland || t[x][y].getType().getType().toLowerCase().contains("water"))) continue;
                        if (t[x][y].getTypeName().equals("Empty")) {
                            gc.setFill((Paint)javafx.scene.paint.Color.BLACK);
                        } else if (t[x][y].isIcy()) {
                            if (t[x][y].getTypeName().toLowerCase().contains("water")) {
                                gc.setFill((Paint)javafx.scene.paint.Color.ALICEBLUE);
                            } else {
                                gc.setFill((Paint)javafx.scene.paint.Color.WHITE);
                            }
                        } else if (t[x][y].getBackgroundColor() != null) {
                            gc.setFill((Paint)t[x][y].getBackgroundColor());
                        } else {
                            gc.setFill((Paint)t[x][y].getType().getBgColor());
                        }
                        if (!showtile && overrideFill != null) {
                            gc.setFill(overrideFill);
                        }
                        gc.fillRect((double)x * wpt75 - wpt5, (double)y * hexHeight + (x % 2 == 0 ? 0.0 : hpt5) - hpt5, hexWidth, hexHeight);
                    }
                }
            } else if (MapUI.this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                for (int y = 0; y < t[0].length; ++y) {
                    for (int x = 0; x < t.length; ++x) {
                        boolean showtile;
                        if (t[x][y] == null || t[x][y].getType() == null) continue;
                        boolean bl = showtile = !t[x][y].isGmOnly() || t[x][y].isGmOnly() && MapUI.this.mapData.getShow().isGMOnly();
                        if ((!paintwater || !t[x][y].getType().getType().toLowerCase().contains("water")) && (!paintland || t[x][y].getType().getType().toLowerCase().contains("water"))) continue;
                        if (t[x][y].getTypeName().equals("Empty")) {
                            gc.setFill((Paint)javafx.scene.paint.Color.BLACK);
                        } else if (t[x][y].isIcy()) {
                            if (t[x][y].getTypeName().toLowerCase().contains("water")) {
                                gc.setFill((Paint)javafx.scene.paint.Color.ALICEBLUE);
                            } else {
                                gc.setFill((Paint)javafx.scene.paint.Color.WHITE);
                            }
                        } else if (t[x][y].getBackgroundColor() != null) {
                            gc.setFill((Paint)t[x][y].getBackgroundColor());
                        } else {
                            gc.setFill((Paint)t[x][y].getType().getBgColor());
                        }
                        if (!showtile && overrideFill != null) {
                            gc.setFill(overrideFill);
                        }
                        gc.fillRect((double)x * hexWidth + (y % 2 == 0 ? 0.0 : wpt5) - wpt5, (double)y * hpt75 - hpt5, hexWidth, hexHeight);
                    }
                }
            } else {
                for (int y = 0; y < t[0].length; ++y) {
                    for (int x = 0; x < t.length; ++x) {
                        boolean showtile;
                        if (t[x][y].getType() == null) continue;
                        boolean bl = showtile = !t[x][y].isGmOnly() || t[x][y].isGmOnly() && MapUI.this.mapData.getShow().isGMOnly();
                        if ((!paintwater || !t[x][y].getType().getType().toLowerCase().contains("water")) && (!paintland || t[x][y].getType().getType().toLowerCase().contains("water"))) continue;
                        if (t[x][y].getTypeName().equals("Empty")) {
                            gc.setFill((Paint)javafx.scene.paint.Color.BLACK);
                        } else if (t[x][y].isIcy()) {
                            if (t[x][y].getTypeName().toLowerCase().contains("water")) {
                                gc.setFill((Paint)javafx.scene.paint.Color.ALICEBLUE);
                            } else {
                                gc.setFill((Paint)javafx.scene.paint.Color.WHITE);
                            }
                        } else if (t[x][y].getBackgroundColor() != null) {
                            gc.setFill((Paint)t[x][y].getBackgroundColor());
                        } else {
                            gc.setFill((Paint)t[x][y].getType().getBgColor());
                        }
                        if (!showtile && overrideFill != null) {
                            gc.setFill(overrideFill);
                        }
                        gc.fillRect((double)x * hexWidth, (double)y * hexHeight, hexWidth, hexHeight);
                    }
                }
            }
        }

        public void paintIcosahedralMask(GraphicsContext gc, MapData data, double offseth, double offsetv, double hexWidth, double hexHeight, ViewLevel vl) {
            double triangleSize = data.getView().getTriangleSize(vl);
            gc.setFill((Paint)data.getMaskColor());
            if (data.getTileOrientation() == HexOrientation.COLUMNS) {
                double[] x2s = this.getNorthXsColumns(triangleSize, hexWidth, offseth);
                double[] y2s = this.getNorthYsColumns(triangleSize, hexWidth, hexHeight, offsetv, vl);
                gc.fillPolygon(x2s, y2s, x2s.length);
                double[] xs = this.getSouthXsColumns(triangleSize, hexWidth, offseth);
                double[] ys = this.getSouthYsColumns(triangleSize, hexHeight, offsetv, vl);
                gc.fillPolygon(xs, ys, xs.length);
            } else {
                double[] x2s = this.getNorthXsRows(triangleSize, hexWidth, offseth);
                double[] y2s = this.getNorthYsRows(triangleSize, hexHeight, offsetv);
                gc.fillPolygon(x2s, y2s, x2s.length);
                double[] xs = this.getSouthXsRows(triangleSize, hexWidth, offseth);
                double[] ys = this.getSouthYsRows(triangleSize, hexHeight, offsetv);
                gc.fillPolygon(xs, ys, xs.length);
            }
        }

        public double[] getNorthXsColumns(double triangleSize, double hexWidth, double offseth) {
            double offset = triangleSize % 2.0 == 0.0 ? hexWidth / 2.0 : hexWidth;
            double[] xs = new double[]{0.0, offset, triangleSize * 0.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 1.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 1.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 2.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 2.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 3.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 3.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 4.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 4.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + hexWidth * 3.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + hexWidth * 3.0 + offset, 0.0};
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = xs[i] - offseth;
            }
            return xs;
        }

        public double[] getNorthYsColumns(double triangleSize, double hexWidth, double hexHeight, double offsetv, ViewLevel vl) {
            double ht3quarter = hexHeight * 3.0 / 4.0;
            double offset = triangleSize % 4.0 == 0.0 ? 0.0 : hexWidth / 2.0;
            double[] ys = new double[]{triangleSize * ht3quarter + hexHeight / 2.0 + offset, triangleSize * ht3quarter + hexHeight / 2.0 + offset, 0.5 * hexHeight + offset, triangleSize * ht3quarter + hexHeight / 2.0 + offset, 0.5 * hexHeight + offset, triangleSize * ht3quarter + hexHeight / 2.0 + offset, 0.5 * hexHeight + offset, triangleSize * ht3quarter + hexHeight / 2.0 + offset, 0.5 * hexHeight + offset, triangleSize * ht3quarter + hexHeight / 2.0 + offset, 0.5 * hexHeight + offset, 2.0 * triangleSize * ht3quarter + hexHeight / 2.0 + offset, 2.0 * triangleSize * ht3quarter + hexHeight / 2.0 + offset, -hexHeight, -hexHeight};
            for (int i = 0; i < ys.length; ++i) {
                if (ys[i] > 0.0) {
                    if (vl == ViewLevel.CONTINENT) {
                        ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                    if (vl == ViewLevel.KINGDOM) {
                        ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getKingdomFactor() * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                } else {
                    if (vl == ViewLevel.CONTINENT) {
                        ys[i] = ys[i] - hexHeight * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                    if (vl == ViewLevel.KINGDOM) {
                        ys[i] = ys[i] - hexHeight * (double)MapUI.this.getMapData().getView().getKingdomFactor() * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                }
                ys[i] = ys[i] - offsetv;
            }
            return ys;
        }

        public double[] getSouthXsColumns(double triangleSize, double hexWidth, double offseth) {
            double offset = triangleSize % 2.0 == 0.0 ? hexWidth / 2.0 : hexWidth;
            double[] xs = new double[]{0.0, offset, (double)((int)(triangleSize * 1.0 * hexWidth * 3.0 / 4.0)) + offset, triangleSize * 1.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 2.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 2.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 3.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 3.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 4.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 4.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 5.0 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + hexWidth * 3.0 + offset, triangleSize * 5.5 * hexWidth * 3.0 / 4.0 + hexWidth * 3.0 + offset, 0.0};
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = xs[i] - offseth;
            }
            return xs;
        }

        public double[] getSouthYsColumns(double triangleSize, double hexHeight, double offsetv, ViewLevel vl) {
            double ht3quarter = hexHeight * 3.0 / 4.0;
            double offset = triangleSize % 4.0 == 0.0 ? hexHeight / 2.0 : hexHeight;
            double[] ys = new double[]{triangleSize * ht3quarter + offset, triangleSize * ht3quarter + offset, triangleSize * 3.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, triangleSize * 3.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, triangleSize * 3.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, triangleSize * 3.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, triangleSize * 3.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, triangleSize * 2.0 * ht3quarter + offset, (triangleSize * 3.0 + 3.0) * ht3quarter + offset, (triangleSize * 3.0 + 3.0) * ht3quarter + offset, (triangleSize * 3.0 + 3.0) * ht3quarter + offset};
            for (int i = 0; i < ys.length; ++i) {
                if (ys[i] == (triangleSize * 3.0 + 2.0) * ht3quarter + offset) {
                    if (vl == ViewLevel.CONTINENT) {
                        ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                    if (vl == ViewLevel.KINGDOM) {
                        ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getKingdomFactor() * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                    }
                }
                if (vl == ViewLevel.CONTINENT) {
                    ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                }
                if (vl == ViewLevel.KINGDOM) {
                    ys[i] = ys[i] + hexHeight * (double)MapUI.this.getMapData().getView().getKingdomFactor() * (double)MapUI.this.getMapData().getView().getContinentFactor() / 2.0;
                }
                ys[i] = ys[i] - offsetv;
            }
            return ys;
        }

        public double[] getNorthXsRows(double triangleSize, double hexWidth, double offseth) {
            double offset = triangleSize % 2.0 == 0.0 ? hexWidth / 2.0 : hexWidth;
            double[] xs = new double[]{0.0, offset, triangleSize * 0.5 * hexWidth + offset, triangleSize * 1.0 * hexWidth + offset, triangleSize * 1.5 * hexWidth + offset, triangleSize * 2.0 * hexWidth + offset, triangleSize * 2.5 * hexWidth + offset, triangleSize * 3.0 * hexWidth + offset, triangleSize * 3.5 * hexWidth + offset, triangleSize * 4.0 * hexWidth + offset, triangleSize * 4.5 * hexWidth + offset, triangleSize * 5.5 * hexWidth + offset, triangleSize * 5.5 * hexWidth + hexWidth * 3.0 + offset, triangleSize * 5.5 * hexWidth + hexWidth * 3.0 + offset, 0.0};
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = xs[i] - offseth;
            }
            return xs;
        }

        public double[] getNorthYsRows(double triangleSize, double hexHeight, double offsetv) {
            double ht3quarter = hexHeight * 3.0 / 4.0;
            double[] ys = new double[]{(triangleSize + 0.5) * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, 0.5 * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, 0.5 * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, 0.5 * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, 0.5 * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, 0.5 * ht3quarter + 3.0, (2.0 * triangleSize + 0.5) * ht3quarter + 3.0, (2.0 * triangleSize + 0.5) * ht3quarter + 3.0, 0.0, 0.0};
            for (int i = 0; i < ys.length; ++i) {
                ys[i] = ys[i] - offsetv;
            }
            return ys;
        }

        public double[] getSouthXsRows(double triangleSize, double hexWidth, double offseth) {
            double offset = triangleSize % 2.0 == 0.0 ? hexWidth / 2.0 : hexWidth;
            double[] xs = new double[]{0.0, offset, (double)((int)(triangleSize * 1.0 * hexWidth)) + offset, triangleSize * 1.5 * hexWidth + offset, triangleSize * 2.0 * hexWidth + offset, triangleSize * 2.5 * hexWidth + offset, triangleSize * 3.0 * hexWidth + offset, triangleSize * 3.5 * hexWidth + offset, triangleSize * 4.0 * hexWidth + offset, triangleSize * 4.5 * hexWidth + offset, triangleSize * 5.0 * hexWidth + offset, triangleSize * 5.5 * hexWidth + offset, triangleSize * 5.5 * hexWidth + hexWidth * 3.0 + offset, triangleSize * 5.5 * hexWidth + hexWidth * 3.0 + offset, 0.0};
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = xs[i] - offseth;
            }
            return xs;
        }

        public double[] getSouthYsRows(double triangleSize, double hexHeight, double offsetv) {
            double ht3quarter = hexHeight * 3.0 / 4.0;
            double[] ys = new double[]{(triangleSize + 0.5) * ht3quarter + 3.0, (triangleSize + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 2.0 + 0.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 1.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 1.5) * ht3quarter + 3.0, (triangleSize * 3.0 + 1.5) * ht3quarter + 3.0};
            for (int i = 0; i < ys.length; ++i) {
                ys[i] = ys[i] - offsetv;
            }
            return ys;
        }

        public boolean isInsideLabelBoundingBox(MapLabel ml, Point2D pt) {
            double offseth = MapUI.this.hScrollBar.getValue() * MapUI.this.computeTotalMapWidthPixelsCurrentTileSize() / MapUI.this.computeTotalMapWidthPixelsBaseTileSize();
            double offsetv = MapUI.this.vScrollBar.getValue() * MapUI.this.computeTotalMapHeightPixelsCurrentTileSize() / MapUI.this.computeTotalMapHeightPixelsBaseTileSize();
            return ml.isInsideLabelBoundingBox(MapUI.this.mapData, MapUI.this.mapData.getTileWidth(), MapUI.this.mapData.getTileHeight(), MapUI.this.mapData.getView().getContinentFactor(), MapUI.this.mapData.getView().getKingdomFactor(), MapUI.this.mapData.getView().getProvinceFactor(), offseth, offsetv, MapUI.this.viewLevel, pt);
        }

        public boolean isResizable() {
            return true;
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }
    }
}

