/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureSingleFeatureScreen
extends ConfigureScreen {
    Image changedImage;
    Image changedAltImage;
    Spinner<Double> sizeSpinner = new Spinner();
    Spinner<Double> heightSpinner = new Spinner();
    final String typeName;

    public ConfigureSingleFeatureScreen(Worldographer ms, String typename) {
        super(ms, 600, 400);
        this.typeName = typename;
    }

    @Override
    public void setValues() {
        this.title = "Configure Individual Feature";
        this.configureLabel = "";
        this.configureTitle = "Configure Individual Feature Instructions";
        this.configureHeader = "Edit a Single Feature Type's Data/Settings.";
        this.configureScreenHelpText = "You may bulk edit these settings for many features at once via 'Configure Features' on the 'Configure' menu.\n<ul><li>Key: System name and usually the name of the feature shown to the user in tooltips and such.</li>\n<li>Icon: The current icon for the feature is displayed here. Change it to another file on your computer with the 'Choose File' button.</li>\n<li>Width: The size of the icon as a percentage of a tile's overall width</li>\n<li>Height: The height of an icon as a percentage of a tile's height. If this value is negative, Worldographer will keep the icon's height proportional to the icon's width.</li>\n<li>Alternate Icon: When showing a Batttlemat, Worldographer's Tools menu has an option to show the map in a 'Simplistic' style. These are typically line art icons.    Use the 'Choose File' button here to set/change the icon used in that simplistic style. (The same menu allows you to change the icons back to the 'Realistic' style.)</li>\n<li>Reset: Reset the values to what they were when you opened this window.</li>\n<li>Reset To Original: If the feature was part of Worldographer's built in icons, this button allows you to restore it to the default settings.</li></ul>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        System.out.println("Applying changes");
        FeatureType ft = Feature.featureTypes.get(this.typeName);
        if (this.changedImage != null) {
            ft.setIcon(this.changedImage);
        }
        if (this.changedAltImage != null) {
            ft.setAlternateIcon(this.changedAltImage);
        }
        ft.setIconSize((Double)this.sizeSpinner.getValue() / 100.0);
        ft.setIconHeight((Double)this.heightSpinner.getValue() / 100.0);
        this.worldographer.featuresToolbox.clearFeatureButtons();
        this.worldographer.featuresToolbox.updateFeatureButtons();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key:");
        gp1.add((Node)l1, 0, 0);
        Label l3 = new Label("Icon:");
        gp1.add((Node)l3, 0, 1);
        Label l4 = new Label("Width:");
        gp1.add((Node)l4, 0, 3);
        Label ls = new Label("Height:");
        gp1.add((Node)ls, 0, 4);
        Label l5 = new Label("Alternate Icon:");
        gp1.add((Node)l5, 2, 1);
        this.createFeatureRow(gp1, this.typeName);
        return gp1;
    }

    private void createFeatureRow(GridPane gp2, String key) {
        FeatureType ft = Feature.featureTypes.get(key);
        Label keylabel = new Label(key);
        gp2.add((Node)keylabel, 1, 0, 3, 1);
        ImageView iv1 = new ImageView(ft == null ? null : ft.getIcon());
        iv1.setFitWidth(100.0);
        iv1.setFitHeight(100.0);
        iv1.setPreserveRatio(true);
        iv1.setSmooth(true);
        iv1.setCache(true);
        Label imagelabel = new Label("", (Node)iv1);
        gp2.add((Node)imagelabel, 1, 1);
        Button iconfilebutton1 = new Button("Choose File");
        iconfilebutton1.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                this.changedImage = new Image("file:" + f.getAbsolutePath());
                iv1.setImage(this.changedImage);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton1, 1, 2);
        this.sizeSpinner = new FocusSpinner<Double>(-100.0, 1000.0, ft == null ? 85.0 : ft.getIconSize() * 100.0);
        this.sizeSpinner.setMaxWidth(90.0);
        HBox sizeBox = new HBox(new Node[]{this.sizeSpinner, new Label("% of tile")});
        gp2.add((Node)sizeBox, 1, 3);
        this.sizeSpinner.setEditable(true);
        this.heightSpinner = new FocusSpinner<Double>(-100.0, 1000.0, ft == null ? 85.0 : ft.getIconHeight() * 100.0);
        this.heightSpinner.setMaxWidth(90.0);
        HBox heightBox = new HBox(new Node[]{this.heightSpinner, new Label("% (Negative=\n  Use Width)")});
        gp2.add((Node)heightBox, 1, 4);
        this.heightSpinner.setEditable(true);
        ImageView iv2 = new ImageView(ft == null ? null : ft.getAlternateIcon());
        iv2.setFitWidth(60.0);
        iv2.setFitHeight(60.0);
        iv2.setPreserveRatio(true);
        iv2.setSmooth(true);
        iv2.setCache(true);
        Label imagelabel2 = new Label("", (Node)iv2);
        gp2.add((Node)imagelabel2, 3, 1);
        Button iconfilebutton = new Button("Choose File");
        iconfilebutton.setMaxWidth(100.0);
        iconfilebutton.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                this.changedAltImage = new Image("file:" + f.getAbsolutePath());
                iv2.setImage(this.changedAltImage);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton, 3, 2);
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {
            FeatureType ft2 = Feature.DEFAULT_FEATURES.get(key);
            if (ft2 != null) {
                iv1.setImage(ft2.getIcon());
                this.changedImage = ft2.getIcon();
                iv2.setImage(ft2.getAlternateIcon());
                this.changedAltImage = ft2.getAlternateIcon();
                this.sizeSpinner.getValueFactory().setValue((Object)(ft2.getIconSize() * 100.0));
                this.heightSpinner.getValueFactory().setValue((Object)(ft2.getIconHeight() * 100.0));
            }
        });
        Button resetorigbutton = new Button("Reset To Original");
        resetorigbutton.setStyle("-fx-alignment: center ;");
        resetorigbutton.setOnAction(event -> {
            FeatureType ft2 = Feature.restoreOneDefault(key);
            if (ft2 != null) {
                iv1.setImage(ft2.getIcon());
                this.changedImage = ft2.getIcon();
                iv2.setImage(ft2.getAlternateIcon());
                this.changedAltImage = ft2.getAlternateIcon();
                this.sizeSpinner.getValueFactory().setValue((Object)(ft2.getIconSize() * 100.0));
                this.heightSpinner.getValueFactory().setValue((Object)(ft2.getIconHeight() * 100.0));
            }
        });
        HBox resetBox = new HBox(new Node[]{resetbutton, resetorigbutton});
        resetBox.setAlignment(Pos.CENTER_RIGHT);
        gp2.add((Node)resetBox, 3, 4);
    }
}

