/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureTexturesScreen
extends ConfigureScreen {
    final Map<String, Image> changedImagesMap = new HashMap<String, Image>();
    final Map<String, CheckBox> removeCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> keyTFsMap = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> widthSpinners = new HashMap<String, Spinner<Integer>>();
    int numFeatureRows;

    public ConfigureTexturesScreen(Worldographer ms) {
        super(ms, 660, 400);
    }

    @Override
    public void setValues() {
        this.title = "Configure Textures";
        this.configureLabel = "";
        this.configureTitle = "Configure Textures Instructions";
        this.configureHeader = "Configure Textures Instructions";
        this.configureScreenHelpText = "<p>To configure many textures, use the Configure Textures dialog. Each row configures a different texture.</p><h3>Add</h3><p>Click the 'Add Row' button to add a new texture to the system. You may have to scroll down to the new row.</p>\n<h3>Configure</h3>\n<ul><li>Key: System name and usually the name of the texture shown to the user in tooltips and such.</li>\n<li>Icon: The current image for the texture is displayed here. Change it to another file on your computer with the 'Choose File' button.</li>\n<li>Width: The size of the image as a percentage of a tile's overall width</li>\n<li>Reset: Reset the values to what they were when you opened this window.</li>\n<li>Remove: Remove this texture from the system.</li></ul>\n<h3>Remove</h3><p>To remove any texture from the system, check the 'Remove' checkbox (last column) for that row.  Then click 'Apply' on the bottom.</p>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        TextureType tt;
        CheckBox cb;
        for (String key : this.changedImagesMap.keySet()) {
            if (key.startsWith("temp###")) {
                cb = this.removeCBsMap.get(key);
                if (cb.isSelected()) continue;
                Object name = this.keyTFsMap.get(key).getText();
                if (((String)name).trim().equals("")) {
                    name = "No Name " + key.substring(6);
                    this.keyTFsMap.get(key).setText((String)name);
                }
                Integer w = (Integer)this.widthSpinners.get(key).getValue();
                TextureType tt2 = new TextureType((String)name, this.changedImagesMap.get(key), false, w);
                TextureType.ALL_TEXTURES.put((String)name, tt2);
                continue;
            }
            tt = TextureType.ALL_TEXTURES.get(key);
            tt.setDefaultAndUnchanged(false);
            tt.setIcon(this.changedImagesMap.get(key));
            tt.setWidth((Integer)this.widthSpinners.get(key).getValue());
        }
        for (String key : this.widthSpinners.keySet()) {
            if (key.startsWith("temp###")) continue;
            tt = TextureType.ALL_TEXTURES.get(key);
            Integer newval = (Integer)this.widthSpinners.get(key).getValue();
            if (newval.intValue() == tt.getWidth()) continue;
            tt.setWidth(newval);
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.removeCBsMap.keySet()) {
            if (key.startsWith("temp###") || !(cb = this.removeCBsMap.get(key)).isSelected()) continue;
            TextureType.ALL_TEXTURES.remove(key);
        }
        this.worldographer.shapesToolbox.updateTextures();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key");
        l1.setMinWidth(205.0);
        gp1.add((Node)l1, 0, 0);
        Label l3 = new Label("Icon");
        l3.setMinWidth(160.0);
        gp1.add((Node)l3, 1, 0);
        Label l4 = new Label("Width");
        l4.setMinWidth(80.0);
        gp1.add((Node)l4, 2, 0);
        GridPane gp2 = new GridPane();
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        int count = 0;
        for (String key : TextureType.ALL_TEXTURES.keySet()) {
            count = this.createTextureRow(gp2, count, key);
        }
        this.numFeatureRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            this.numFeatureRows = this.createTextureRow(gp2, this.numFeatureRows, "temp###" + Math.random());
            scrollpane.setVvalue(1.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        return bp;
    }

    private int createTextureRow(GridPane gp2, int count, String key) {
        TextureType ft = TextureType.ALL_TEXTURES.get(key);
        if (ft != null) {
            Label keylabel = new Label(key);
            keylabel.setMaxWidth(200.0);
            keylabel.setMinWidth(200.0);
            gp2.add((Node)keylabel, 0, count);
        } else {
            TextField tf = new TextField("");
            tf.setMaxWidth(200.0);
            tf.setMinWidth(200.0);
            gp2.add((Node)tf, 0, count);
            this.keyTFsMap.put(key, tf);
        }
        ImageView iv = new ImageView(ft == null ? null : ft.getIcon());
        iv.setFitWidth(60.0);
        iv.setFitHeight(60.0);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        iv.setCache(true);
        Label imagelabel = new Label("", (Node)iv);
        gp2.add((Node)imagelabel, 2, count);
        Button iconfilebutton = new Button("Choose File");
        iconfilebutton.setMaxWidth(100.0);
        iconfilebutton.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                Image image = new Image("file:" + f.getAbsolutePath());
                iv.setImage(image);
                this.changedImagesMap.put(key, image);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton, 3, count);
        int wdefault = 300;
        if (ft != null) {
            wdefault = ft.getWidth();
        }
        FocusSpinner widthspinner = new FocusSpinner(0, Integer.MAX_VALUE, wdefault);
        this.widthSpinners.put(key, widthspinner);
        widthspinner.setMaxWidth(80.0);
        widthspinner.setMinWidth(80.0);
        gp2.add(widthspinner, 4, count);
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {
            TextureType tt = TextureType.ALL_TEXTURES.get(key);
            if (tt != null) {
                iv.setImage(tt.getIcon());
                this.changedImagesMap.put(key, tt.getIcon());
            }
        });
        gp2.add((Node)resetbutton, 5, count);
        CheckBox removeCB = new CheckBox("Remove");
        this.removeCBsMap.put(key, removeCB);
        gp2.add((Node)removeCB, 6, count);
        return ++count;
    }
}

