/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfigureTileNumbersDialog {
    public void showConfigureTileNumbersDialog(Stage parentStage, MapUI mapUI) {
        StyledDialog d = new StyledDialog(true, (Window)parentStage, "Configure Tile Numbers");
        d.setHeaderText("Use the Following Controls to Configure Tile Numbers:");
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)new Label("Font Settings:"), 0, 0, 6, 1);
        grid.add((Node)new Label("Font:"), 0, 1);
        ObservableList options = FXCollections.observableArrayList((Collection)Font.getFamilies());
        ComboBox fontCombo = new ComboBox(options);
        fontCombo.getSelectionModel().select((Object)mapUI.getMapData().getNumbering().getFontName());
        grid.add((Node)fontCombo, 1, 1);
        grid.add((Node)new Label("Color:"), 0, 2);
        ColorPicker fontCP = new ColorPicker(Color.BLACK);
        grid.add((Node)fontCP, 1, 2);
        grid.add((Node)new Label("Style:"), 0, 3);
        ArrayList<NumberingData.FontStyle> stylelist = new ArrayList<NumberingData.FontStyle>();
        stylelist.add(NumberingData.FontStyle.PLAIN);
        stylelist.add(NumberingData.FontStyle.BOLD);
        stylelist.add(NumberingData.FontStyle.ITALIC);
        ComboBox fontStyleCombo = new ComboBox(FXCollections.observableArrayList(stylelist));
        fontStyleCombo.getSelectionModel().select((Object)mapUI.getMapData().getNumbering().getFontStyle());
        grid.add((Node)fontStyleCombo, 1, 3);
        grid.add((Node)new Label("Size:"), 0, 4);
        FocusSpinner fontSizeSpinner = new FocusSpinner(1, 50, mapUI.getMapData().getNumbering().getFontSize());
        fontSizeSpinner.setEditable(true);
        grid.add(fontSizeSpinner, 1, 4);
        grid.add((Node)new Label("Position Settings:"), 0, 5, 6, 1);
        grid.add((Node)new Label("Numbers on:"), 0, 6);
        ArrayList<NumberingData.NumberPosition> numsonlist = new ArrayList<NumberingData.NumberPosition>();
        numsonlist.add(NumberingData.NumberPosition.TOP);
        numsonlist.add(NumberingData.NumberPosition.MIDDLE);
        numsonlist.add(NumberingData.NumberPosition.BOTTOM);
        ComboBox numsOnCombo = new ComboBox(FXCollections.observableArrayList(numsonlist));
        numsOnCombo.getSelectionModel().select((Object)mapUI.getMapData().getNumbering().getPosition());
        grid.add((Node)numsOnCombo, 1, 6);
        grid.add((Node)new Label("Order Numbers:"), 0, 7);
        ArrayList<NumberingData.OrderNumbers> ordernumslist = new ArrayList<NumberingData.OrderNumbers>();
        ordernumslist.add(NumberingData.OrderNumbers.COL_ROW);
        ordernumslist.add(NumberingData.OrderNumbers.ROW_COL);
        ComboBox orderNumsCombo = new ComboBox(FXCollections.observableArrayList(ordernumslist));
        orderNumsCombo.getSelectionModel().select((Object)mapUI.getMapData().getNumbering().getOrder());
        grid.add((Node)orderNumsCombo, 1, 7);
        grid.add((Node)new Label("Sequence Settings:"), 0, 9, 6, 1);
        grid.add((Node)new Label("1st Column:"), 0, 10);
        FocusSpinner firstColSpinner = new FocusSpinner(-10000, 10000, mapUI.getMapData().getNumbering().getFirstColumn());
        firstColSpinner.setEditable(true);
        grid.add(firstColSpinner, 1, 10);
        grid.add((Node)new Label("Separator:"), 0, 11);
        TextField rowcolseparator = new TextField(mapUI.getMapData().getNumbering().getSeparator());
        grid.add((Node)rowcolseparator, 1, 11);
        grid.add((Node)new Label("1st Row:"), 0, 12);
        FocusSpinner firstRowSpinner = new FocusSpinner(-10000, 10000, mapUI.getMapData().getNumbering().getFirstRow());
        firstRowSpinner.setEditable(true);
        grid.add(firstRowSpinner, 1, 12);
        grid.add((Node)new Label("Pre-Pad #'s:"), 0, 13);
        ArrayList<NumberingData.PrePadNums> prepadlist = new ArrayList<NumberingData.PrePadNums>();
        prepadlist.add(NumberingData.PrePadNums.ZERO);
        prepadlist.add(NumberingData.PrePadNums.DOUBLE_ZERO);
        prepadlist.add(NumberingData.PrePadNums.TRIPLE_ZERO);
        prepadlist.add(NumberingData.PrePadNums.NO);
        ComboBox prePadCombo = new ComboBox(FXCollections.observableArrayList(prepadlist));
        prePadCombo.getSelectionModel().select((Object)mapUI.getMapData().getNumbering().getPrePadNums());
        grid.add((Node)prePadCombo, 1, 13);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            MapData mapData = mapUI.getMapData();
            mapData.getNumbering().setFontName((String)fontCombo.getSelectionModel().getSelectedItem());
            mapData.getNumbering().setFontColor((Color)fontCP.getValue());
            Integer size = (Integer)fontSizeSpinner.getValue();
            mapData.getNumbering().setFontSize(size);
            mapData.getNumbering().setFontStyle((NumberingData.FontStyle)((Object)fontStyleCombo.getSelectionModel().getSelectedItem()));
            mapData.getNumbering().setFirstColumn((Integer)firstColSpinner.getValue());
            mapData.getNumbering().setFirstRow((Integer)firstRowSpinner.getValue());
            mapData.getNumbering().setOrder((NumberingData.OrderNumbers)((Object)orderNumsCombo.getValue()));
            mapData.getNumbering().setPosition((NumberingData.NumberPosition)((Object)numsOnCombo.getValue()));
            mapData.getNumbering().setPrePadNums((NumberingData.PrePadNums)((Object)prePadCombo.getValue()));
            mapData.getNumbering().setSeparator(rowcolseparator.getText());
            mapUI.draw();
        }
    }
}

